/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.spark.api.r.RUtils$;
import org.apache.spark.deploy.RPackageUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.RedirectThread;
import org.apache.spark.util.RedirectThread$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.sparkproject.guava.io.ByteStreams;
import org.sparkproject.guava.io.Files;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class RPackageUtils$
implements Logging {
    public static final RPackageUtils$ MODULE$ = new RPackageUtils$();
    private static final scala.collection.immutable.Seq<String> baseInstallCmd;
    private static final String RJarDoc;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        baseInstallCmd = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"R", "CMD", "INSTALL", "-l"}));
        RJarDoc = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(857).append("In order for Spark to build R packages that are parts of Spark Packages, there are a few\n      |requirements. The R source code must be shipped in a jar, with additional Java/Scala\n      |classes. The jar must be in the following format:\n      |  1- The Manifest (META-INF/MANIFEST.mf) must contain the key-value: ").append("Spark-HasRPackage").append(": true\n      |  2- The standard R package layout must be preserved under R/pkg/ inside the jar. More\n      |  information on the standard R package layout can be found in:\n      |  http://cran.r-project.org/doc/contrib/Leisch-CreatingPackages.pdf\n      |  An example layout is given below. After running `jar tf $JAR_FILE | sort`:\n      |\n      |META-INF/MANIFEST.MF\n      |R/\n      |R/pkg/\n      |R/pkg/DESCRIPTION\n      |R/pkg/NAMESPACE\n      |R/pkg/R/\n      |R/pkg/R/myRcode.R\n      |org/\n      |org/apache/\n      |...\n    ").toString())).trim();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private final String hasRPackage() {
        return "Spark-HasRPackage";
    }

    private final scala.collection.immutable.Seq<String> baseInstallCmd() {
        return baseInstallCmd;
    }

    private final String RJarEntries() {
        return "R/pkg";
    }

    public final String RJarDoc() {
        return RJarDoc;
    }

    private void print(String msg, PrintStream printStream, Level level, Throwable e) {
        block7: {
            block6: {
                if (printStream == null) break block6;
                printStream.println(msg);
                if (e == null) break block7;
                e.printStackTrace(printStream);
                break block7;
            }
            Level level2 = level;
            Level level3 = Level.INFO;
            Level level4 = level2;
            if (!(level3 != null ? !((Object)level3).equals(level4) : level4 != null)) {
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> msg);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Level level5 = Level.WARNING;
                Level level6 = level2;
                if (!(level5 != null ? !((Object)level5).equals(level6) : level6 != null)) {
                    this.logWarning((Function0<String>)(Function0 & Serializable)() -> msg);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Level level7 = Level.SEVERE;
                    Level level8 = level2;
                    if (!(level7 != null ? !((Object)level7).equals(level8) : level8 != null)) {
                        this.logError((Function0<String>)(Function0 & Serializable)() -> msg, e);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.logDebug((Function0<String>)(Function0 & Serializable)() -> msg);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
        }
    }

    private Level print$default$3() {
        return Level.FINE;
    }

    private Throwable print$default$4() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkManifestForR(JarFile jar) {
        if (jar.getManifest() == null) {
            return false;
        }
        Attributes manifest = jar.getManifest().getMainAttributes();
        if (manifest.getValue("Spark-HasRPackage") == null) return false;
        String string = manifest.getValue("Spark-HasRPackage").trim();
        String string2 = "true";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    private boolean rPackageBuilder(File dir, PrintStream printStream, boolean verbose, String libDir) {
        boolean bl;
        block4: {
            String pathToPkg = package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{dir, "R", "pkg"})).mkString(File.separator);
            scala.collection.immutable.Seq installCmd = (scala.collection.immutable.Seq)this.baseInstallCmd().$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{libDir, pathToPkg})));
            if (verbose) {
                this.print(new StringBuilder(37).append("Building R package with the command: ").append(installCmd).toString(), printStream, this.print$default$3(), this.print$default$4());
            }
            try {
                ProcessBuilder builder = new ProcessBuilder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)installCmd).asJava());
                builder.redirectErrorStream(true);
                Map<String, String> env = builder.environment();
                scala.collection.immutable.Seq<String> rPackageDir = RUtils$.MODULE$.sparkRPackagePath(true);
                env.put("SPARKR_PACKAGE_DIR", rPackageDir.mkString(","));
                env.put("R_PROFILE_USER", package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)rPackageDir.apply(0), "SparkR", "profile", "general.R"})).mkString(File.separator));
                Process process = builder.start();
                new RedirectThread(process.getInputStream(), printStream, "redirect R packaging", RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
                if (process.waitFor() == 0) {
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            catch (Throwable e) {
                this.print("Failed to build R package.", printStream, Level.SEVERE, e);
                bl = false;
            }
        }
        return bl;
    }

    private File extractRFolder(JarFile jar, PrintStream printStream, boolean verbose) {
        File tempDir = Utils$.MODULE$.createTempDir(null, Utils$.MODULE$.createTempDir$default$2());
        Enumeration<JarEntry> jarEntries = jar.entries();
        while (jarEntries.hasMoreElements()) {
            Object object;
            JarEntry entry = jarEntries.nextElement();
            int entryRIndex = entry.getName().indexOf("R/pkg");
            if (entryRIndex > -1) {
                String entryPath = entry.getName().substring(entryRIndex);
                if (entry.isDirectory()) {
                    File dir = new File(tempDir, entryPath);
                    if (verbose) {
                        this.print(new StringBuilder(20).append("Creating directory: ").append(dir).toString(), printStream, this.print$default$3(), this.print$default$4());
                    }
                    object = BoxesRunTime.boxToBoolean((boolean)dir.mkdirs());
                    continue;
                }
                InputStream inStream = jar.getInputStream(entry);
                File outPath = new File(tempDir, entryPath);
                Files.createParentDirs((File)outPath);
                FileOutputStream outStream = new FileOutputStream(outPath);
                if (verbose) {
                    this.print(new StringBuilder(15).append("Extracting ").append(entry).append(" to ").append(outPath).toString(), printStream, this.print$default$3(), this.print$default$4());
                }
                object = BoxesRunTime.boxToLong((long)Utils$.MODULE$.copyStream(inStream, outStream, true, Utils$.MODULE$.copyStream$default$4()));
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        return tempDir;
    }

    public void checkAndBuildRPackage(String jars, PrintStream printStream, boolean verbose) {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])jars.split(",")), (Function1 & Serializable)jarPath -> {
            RPackageUtils$.$anonfun$checkAndBuildRPackage$1(printStream, verbose, jarPath);
            return BoxedUnit.UNIT;
        });
    }

    public PrintStream checkAndBuildRPackage$default$2() {
        return null;
    }

    public boolean checkAndBuildRPackage$default$3() {
        return false;
    }

    private Set<File> listFilesRecursively(File dir, scala.collection.immutable.Seq<String> excludePatterns) {
        Set set;
        if (!dir.exists()) {
            set = Predef$.MODULE$.Set().empty();
        } else if (dir.isDirectory()) {
            File[] subDir = dir.listFiles(new FilenameFilter(excludePatterns){
                private final scala.collection.immutable.Seq excludePatterns$1;

                public boolean accept(File dir, String name) {
                    return !BoxesRunTime.unboxToBoolean((Object)((IterableOnceOps)this.excludePatterns$1.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$accept$1(name, x$1)))).reduce((Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$accept$2(BoxesRunTime.unboxToBoolean((Object)x$1), BoxesRunTime.unboxToBoolean((Object)x$2)))));
                }

                public static final /* synthetic */ boolean $anonfun$accept$1(String name$1, CharSequence x$1) {
                    return name$1.contains(x$1);
                }

                public static final /* synthetic */ boolean $anonfun$accept$2(boolean x$1, boolean x$2) {
                    return x$1 || x$2;
                }
                {
                    this.excludePatterns$1 = excludePatterns$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$accept$1$adapted(java.lang.String java.lang.CharSequence ), $anonfun$accept$2$adapted(java.lang.Object java.lang.Object )}, serializedLambda);
                }
            });
            set = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])subDir), (Function1 & Serializable)x$3 -> MODULE$.listFilesRecursively((File)x$3, excludePatterns), ClassTag$.MODULE$.apply(File.class))).toSet();
        } else {
            set = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{dir}));
        }
        return set;
    }

    public File zipRLibraries(File dir, String name) {
        Set<File> filesToBundle = this.listFilesRecursively(dir, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".zip"}))));
        File zipFile = new File(dir, name);
        if (!zipFile.delete()) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(15).append("Error deleting ").append(zipFile.getPath()).toString());
        }
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFile, false));){
            filesToBundle.foreach((Function1 & Serializable)file -> {
                RPackageUtils$.$anonfun$zipRLibraries$2(dir, zipOutputStream, file);
                return BoxedUnit.UNIT;
            });
        }
        return zipFile;
    }

    public static final /* synthetic */ void $anonfun$checkAndBuildRPackage$1(PrintStream printStream$1, boolean verbose$1, String jarPath) {
        File file = new File(Utils$.MODULE$.resolveURI(jarPath));
        if (file.exists()) {
            JarFile jar = new JarFile(file);
            Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable)() -> {
                if (MODULE$.checkManifestForR(jar)) {
                    MODULE$.print(new StringBuilder(48).append(file).append(" contains R source code. Now installing package.").toString(), printStream$1, Level.INFO, MODULE$.print$default$4());
                    File rSource = MODULE$.extractRFolder(jar, printStream$1, verbose$1);
                    if (RUtils$.MODULE$.rPackages().isEmpty()) {
                        RUtils$.MODULE$.rPackages_$eq((Option<String>)new Some((Object)Utils$.MODULE$.createTempDir().getAbsolutePath()));
                    }
                    try {
                        if (MODULE$.rPackageBuilder(rSource, printStream$1, verbose$1, (String)RUtils$.MODULE$.rPackages().get())) return;
                        MODULE$.print(new StringBuilder(37).append("ERROR: Failed to build R package in ").append(file).append(".").toString(), printStream$1, MODULE$.print$default$3(), MODULE$.print$default$4());
                        MODULE$.print(MODULE$.RJarDoc(), printStream$1, MODULE$.print$default$3(), MODULE$.print$default$4());
                        return;
                    }
                    finally {
                        if (!rSource.delete()) {
                            MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(15).append("Error deleting ").append(rSource.getPath()).toString());
                        }
                    }
                } else {
                    if (!verbose$1) return;
                    MODULE$.print(new StringBuilder(43).append(file).append(" doesn't contain R source code, skipping...").toString(), printStream$1, MODULE$.print$default$3(), MODULE$.print$default$4());
                }
            }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> jar.close());
        } else {
            MODULE$.print(new StringBuilder(45).append("WARN: ").append(file).append(" resolved as dependency, but not found.").toString(), printStream$1, Level.WARNING, MODULE$.print$default$4());
        }
    }

    public static final /* synthetic */ void $anonfun$zipRLibraries$2(File dir$1, ZipOutputStream zipOutputStream$1, File file) {
        String relPath = file.toURI().toString().replaceFirst(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(dir$1.toURI().toString()), "/"), "");
        FileInputStream fis = new FileInputStream(file);
        ZipEntry zipEntry = new ZipEntry(relPath);
        zipOutputStream$1.putNextEntry(zipEntry);
        ByteStreams.copy((InputStream)fis, (OutputStream)zipOutputStream$1);
        zipOutputStream$1.closeEntry();
        fis.close();
    }

    private RPackageUtils$() {
    }
}

