/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.correlation.alert;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.model.Alert;
import org.opensearch.commons.alerting.model.CorrelationAlert;
import org.opensearch.commons.alerting.model.Table;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptType;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.securityanalytics.action.AckCorrelationAlertsResponse;
import org.opensearch.securityanalytics.action.GetCorrelationAlertsResponse;
import org.opensearch.securityanalytics.correlation.alert.CorrelationAlertsList;
import org.opensearch.transport.client.Client;

public class CorrelationAlertService {
    private static final Logger log = LogManager.getLogger(CorrelationAlertService.class);
    private final NamedXContentRegistry xContentRegistry;
    private final Client client;
    protected static final String CORRELATED_FINDING_IDS = "correlated_finding_ids";
    protected static final String CORRELATION_RULE_ID = "correlation_rule_id";
    protected static final String CORRELATION_RULE_NAME = "correlation_rule_name";
    protected static final String ALERT_ID_FIELD = "id";
    protected static final String SCHEMA_VERSION_FIELD = "schema_version";
    protected static final String ALERT_VERSION_FIELD = "version";
    protected static final String USER_FIELD = "user";
    protected static final String TRIGGER_NAME_FIELD = "trigger_name";
    protected static final String STATE_FIELD = "state";
    protected static final String START_TIME_FIELD = "start_time";
    protected static final String END_TIME_FIELD = "end_time";
    protected static final String ACKNOWLEDGED_TIME_FIELD = "acknowledged_time";
    protected static final String ERROR_MESSAGE_FIELD = "error_message";
    protected static final String SEVERITY_FIELD = "severity";
    protected static final String ACTION_EXECUTION_RESULTS_FIELD = "action_execution_results";
    protected static final String NO_ID = "";
    protected static final long NO_VERSION = -1L;

    public CorrelationAlertService(Client client, NamedXContentRegistry xContentRegistry) {
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    public void getActiveAlerts(String ruleId, long currentTime, ActionListener<CorrelationAlertsList> listener) {
        Instant currentTimeDate = Instant.ofEpochMilli(currentTime);
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)CORRELATION_RULE_ID, (String)ruleId)).must((QueryBuilder)QueryBuilders.rangeQuery((String)START_TIME_FIELD).lte((Object)currentTimeDate)).must((QueryBuilder)QueryBuilders.rangeQuery((String)END_TIME_FIELD).gte((Object)currentTimeDate)).must((QueryBuilder)QueryBuilders.termQuery((String)STATE_FIELD, (String)"ACTIVE"));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true)).size(10000).query((QueryBuilder)queryBuilder);
        SearchRequest searchRequest = new SearchRequest(new String[]{".opensearch-sap-correlation-alerts"}).source(searchSourceBuilder);
        this.client.search(searchRequest, ActionListener.wrap(searchResponse -> {
            if (searchResponse.getHits().getTotalHits().equals((Object)0)) {
                listener.onResponse((Object)new CorrelationAlertsList(Collections.emptyList(), 0));
            } else {
                listener.onResponse((Object)new CorrelationAlertsList(this.parseCorrelationAlerts((SearchResponse)searchResponse), searchResponse.getHits() != null && searchResponse.getHits().getTotalHits() != null ? (int)searchResponse.getHits().getTotalHits().value() : 0));
            }
        }, e -> {
            log.error("Search request to fetch correlation alerts failed", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    public void indexCorrelationAlert(CorrelationAlert correlationAlert, TimeValue indexTimeout, ActionListener<IndexResponse> listener) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            builder.field(CORRELATED_FINDING_IDS, (Iterable)correlationAlert.getCorrelatedFindingIds());
            builder.field(CORRELATION_RULE_ID, correlationAlert.getCorrelationRuleId());
            builder.field(CORRELATION_RULE_NAME, correlationAlert.getCorrelationRuleName());
            builder.field(ALERT_ID_FIELD, correlationAlert.getId());
            builder.field(USER_FIELD, (ToXContent)correlationAlert.getUser());
            builder.field(SCHEMA_VERSION_FIELD, correlationAlert.getSchemaVersion());
            builder.field(SEVERITY_FIELD, correlationAlert.getSeverity());
            builder.field(STATE_FIELD, (Object)correlationAlert.getState());
            builder.field(TRIGGER_NAME_FIELD, correlationAlert.getTriggerName());
            builder.field(ALERT_VERSION_FIELD, correlationAlert.getVersion());
            builder.field(START_TIME_FIELD, (Object)correlationAlert.getStartTime());
            builder.field(END_TIME_FIELD, (Object)correlationAlert.getEndTime());
            builder.field(ACTION_EXECUTION_RESULTS_FIELD, (Iterable)correlationAlert.getActionExecutionResults());
            builder.field(ERROR_MESSAGE_FIELD, correlationAlert.getErrorMessage());
            builder.field(ACKNOWLEDGED_TIME_FIELD, (Object)correlationAlert.getAcknowledgedTime());
            builder.endObject();
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(".opensearch-sap-correlation-alerts").id(correlationAlert.getId()).source(builder).timeout(indexTimeout);
            this.client.index(indexRequest, listener);
        }
        catch (IOException ex) {
            log.error("Exception while adding alerts in .opensearch-sap-correlation-alerts index", (Throwable)ex);
        }
    }

    public void getCorrelationAlerts(String ruleId, Table tableProp, ActionListener<GetCorrelationAlertsResponse> listener) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (ruleId != null) {
            queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)CORRELATION_RULE_ID, (String)ruleId));
        }
        FieldSortBuilder sortBuilder = (FieldSortBuilder)SortBuilders.fieldSort((String)tableProp.getSortString()).order(SortOrder.fromString((String)tableProp.getSortOrder()));
        if (tableProp.getMissing() != null && !tableProp.getMissing().isEmpty()) {
            sortBuilder.missing((Object)tableProp.getMissing());
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().version(Boolean.valueOf(true)).seqNoAndPrimaryTerm(Boolean.valueOf(true)).query((QueryBuilder)queryBuilder).sort((SortBuilder)sortBuilder).size(tableProp.getSize()).from(tableProp.getStartIndex());
        SearchRequest searchRequest = new SearchRequest(new String[]{".opensearch-sap-correlation-alerts"}).source(searchSourceBuilder);
        this.client.search(searchRequest, ActionListener.wrap(searchResponse -> {
            if (searchResponse.getHits().getTotalHits().equals((Object)0)) {
                listener.onResponse((Object)new GetCorrelationAlertsResponse(Collections.emptyList(), 0));
            } else {
                listener.onResponse((Object)new GetCorrelationAlertsResponse(this.parseCorrelationAlerts((SearchResponse)searchResponse), searchResponse.getHits() != null && searchResponse.getHits().getTotalHits() != null ? (int)searchResponse.getHits().getTotalHits().value() : 0));
            }
        }, e -> {
            log.error("Search request to fetch correlation alerts failed", (Throwable)e);
            if (e instanceof IndexNotFoundException) {
                listener.onResponse((Object)new GetCorrelationAlertsResponse(Collections.emptyList(), 0));
            } else {
                listener.onFailure(e);
            }
        }));
    }

    public void acknowledgeAlerts(List<String> alertIds, final ActionListener<AckCorrelationAlertsResponse> listener) {
        final BulkRequest bulkRequest = new BulkRequest();
        final ArrayList acknowledgedAlerts = new ArrayList();
        final ArrayList failedAlerts = new ArrayList();
        TermsQueryBuilder termsQueryBuilder = QueryBuilders.termsQuery((String)ALERT_ID_FIELD, alertIds);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)termsQueryBuilder);
        SearchRequest searchRequest = new SearchRequest(new String[]{".opensearch-sap-correlation-alerts"}).source(searchSourceBuilder);
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){
            final /* synthetic */ CorrelationAlertService this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(SearchResponse searchResponse) {
                bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                for (SearchHit hit : searchResponse.getHits().getHits()) {
                    Script script = new Script(ScriptType.INLINE, "painless", "ctx._source.state = params.state; ctx._source.acknowledged_time = params.time", Map.of(CorrelationAlertService.STATE_FIELD, Alert.State.ACKNOWLEDGED, "time", Instant.now()));
                    UpdateRequest updateRequest = new UpdateRequest(".opensearch-sap-correlation-alerts", hit.getId()).script(script);
                    bulkRequest.add(updateRequest);
                    try {
                        acknowledgedAlerts.add(this.this$0.getParsedCorrelationAlert(hit));
                    }
                    catch (IOException e) {
                        log.error("Exception while acknowledging alerts: {}", (Object)e.toString());
                    }
                }
                if (!bulkRequest.requests().isEmpty()) {
                    this.this$0.client.bulk(bulkRequest, (ActionListener)new ActionListener<BulkResponse>(){

                        public void onResponse(BulkResponse bulkResponse) {
                            for (BulkItemResponse itemResponse : bulkResponse.getItems()) {
                                if (!itemResponse.isFailed()) continue;
                                failedAlerts.add((CorrelationAlert)acknowledgedAlerts.get(itemResponse.getItemId()));
                            }
                            listener.onResponse((Object)new AckCorrelationAlertsResponse(acknowledgedAlerts, failedAlerts));
                        }

                        public void onFailure(Exception e) {
                            listener.onFailure(e);
                        }
                    });
                } else {
                    listener.onResponse((Object)new AckCorrelationAlertsResponse(acknowledgedAlerts, failedAlerts));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    public void updateCorrelationAlertsWithError(final String correlationRuleId) {
        final BulkRequest bulkRequest = new BulkRequest();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)CORRELATION_RULE_ID, (String)correlationRuleId));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder);
        SearchRequest searchRequest = new SearchRequest(new String[]{".opensearch-sap-correlation-alerts"}).source(searchSourceBuilder);
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){
            final /* synthetic */ CorrelationAlertService this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(SearchResponse searchResponse) {
                for (SearchHit hit : searchResponse.getHits().getHits()) {
                    Script script = new Script(ScriptType.INLINE, "painless", "ctx._source.state = params.state; ctx._source.error_message = params.error_message", Map.of(CorrelationAlertService.STATE_FIELD, Alert.State.ERROR, CorrelationAlertService.ERROR_MESSAGE_FIELD, "The rule associated to this Alert is deleted"));
                    UpdateRequest updateRequest = new UpdateRequest(".opensearch-sap-correlation-alerts", hit.getId()).script(script);
                    bulkRequest.add(updateRequest);
                    this.this$0.client.bulk(bulkRequest);
                }
            }

            public void onFailure(Exception e) {
                log.error("Error updating the alerts with Error message for correlation ruleId: {}", (Object)correlationRuleId);
            }
        });
    }

    public List<CorrelationAlert> parseCorrelationAlerts(SearchResponse response) throws IOException {
        ArrayList<CorrelationAlert> alerts = new ArrayList<CorrelationAlert>();
        for (SearchHit hit : response.getHits()) {
            CorrelationAlert correlationAlert = this.getParsedCorrelationAlert(hit);
            alerts.add(correlationAlert);
        }
        return alerts;
    }

    private CorrelationAlert getParsedCorrelationAlert(SearchHit hit) throws IOException {
        XContentParser xcp = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
        xcp.nextToken();
        CorrelationAlert correlationAlert = CorrelationAlertsList.parse(xcp, hit.getId(), hit.getVersion());
        return correlationAlert;
    }
}

