/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.service;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Strings;
import org.opensearch.securityanalytics.model.STIX2IOC;
import org.opensearch.securityanalytics.threatIntel.model.JsonPathIocSchema;
import org.opensearch.securityanalytics.threatIntel.model.JsonPathSchemaField;

public class JsonPathIocSchemaThreatIntelHandler {
    public static final Logger log = LogManager.getLogger(JsonPathIocSchemaThreatIntelHandler.class);

    public static List<STIX2IOC> parseCustomSchema(JsonPathIocSchema iocSchema, String iocsJson, String sourceName, String sourceId) {
        return JsonPathIocSchemaThreatIntelHandler.parseCustomSchemaInternal(iocSchema, new StringIocHandler(iocsJson), sourceName, sourceId);
    }

    public static List<STIX2IOC> parseCustomSchema(JsonPathIocSchema iocSchema, InputStream inputStream, String sourceName, String sourceId) {
        return JsonPathIocSchemaThreatIntelHandler.parseCustomSchemaInternal(iocSchema, new InputStreamIocHandler(inputStream), sourceName, sourceId);
    }

    private static List<STIX2IOC> parseCustomSchemaInternal(JsonPathIocSchema iocSchema, IocInputHandler inputHandler, String sourceName, String sourceId) {
        Configuration conf = Configuration.defaultConfiguration().addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL}).addOptions(new Option[]{Option.ALWAYS_RETURN_LIST}).addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS});
        try {
            DocumentContext context = inputHandler.getDocumentContext(conf);
            List valuesList = (List)context.read(iocSchema.getValue().getJsonPath(), new com.jayway.jsonpath.Predicate[0]);
            List typesList = (List)context.read(iocSchema.getType().getJsonPath(), new com.jayway.jsonpath.Predicate[0]);
            List<String> ids = JsonPathIocSchemaThreatIntelHandler.parseStringListFromJsonPathNotation(context, iocSchema.getId(), true, valuesList.size());
            List<String> names = JsonPathIocSchemaThreatIntelHandler.parseStringListFromJsonPathNotation(context, iocSchema.getName(), true, valuesList.size());
            List<String> severityList = JsonPathIocSchemaThreatIntelHandler.parseStringListFromJsonPathNotation(context, iocSchema.getSeverity(), false, valuesList.size());
            List<String> descriptionList = JsonPathIocSchemaThreatIntelHandler.parseStringListFromJsonPathNotation(context, iocSchema.getDescription(), false, valuesList.size());
            List<String> specVersionList = JsonPathIocSchemaThreatIntelHandler.parseStringListFromJsonPathNotation(context, iocSchema.getSpecVersion(), false, valuesList.size());
            List<Instant> createdList = JsonPathIocSchemaThreatIntelHandler.parseInstantListFromJsonPathNotation(context, iocSchema.getCreated(), valuesList.size());
            List<Instant> modifiedList = JsonPathIocSchemaThreatIntelHandler.parseInstantListFromJsonPathNotation(context, iocSchema.getModified(), valuesList.size());
            if (typesList.isEmpty() || typesList.stream().allMatch(JsonPathIocSchemaThreatIntelHandler.objectIsNullOrNotStringOrNotVal())) {
                throw new IllegalArgumentException("No valid ioc type parsed from custom schema threat intel source " + sourceName);
            }
            if (valuesList.isEmpty() || valuesList.stream().allMatch(JsonPathIocSchemaThreatIntelHandler.objectIsNullOrNotStringOrNotArray())) {
                throw new IllegalArgumentException("No valid ioc value parsed from custom schema threat intel source " + sourceName);
            }
            if (typesList.size() != valuesList.size()) {
                throw new IllegalArgumentException(String.format("Unable to parse custom schema threat intel source %s as equal number of ioc-values and ioc-types were not extracted", sourceName));
            }
            if (typesList.size() == 1 && JsonPathIocSchemaThreatIntelHandler.isStringAndNonEmpty(typesList, 0) && valuesList.size() > 1) {
                ArrayList<STIX2IOC> res = new ArrayList<STIX2IOC>();
                for (int i = 0; i < valuesList.size(); ++i) {
                    String type = String.valueOf(typesList.get(0));
                    List<String> valsList = JsonPathIocSchemaThreatIntelHandler.handleIocValueFieldParsing(valuesList, i);
                    if (valsList.isEmpty()) continue;
                    String id = ids.get(i);
                    for (String value : valsList) {
                        res.add(new STIX2IOC(id, names.get(i), type, value, severityList.get(i), createdList.get(i), modifiedList.get(i), descriptionList.get(i), Collections.emptyList(), specVersionList.get(i), Strings.isBlank((String)sourceId) ? null : sourceId, sourceName, 1L));
                        id = UUID.randomUUID().toString();
                    }
                }
                if (res.isEmpty()) {
                    log.error("No valid IOCs found while parsing custom ioc schema threat intel source " + sourceName);
                    throw new IllegalArgumentException("No valid IOCs found while parsing custom ioc schema threat intel source " + sourceName);
                }
                return res;
            }
            ArrayList<STIX2IOC> res = new ArrayList<STIX2IOC>();
            for (int i = 0; i < Math.min(valuesList.size(), typesList.size()); ++i) {
                if (typesList.get(i) == null) {
                    log.error("Skipping parsing some iocs since type is null in threat intel source " + sourceName);
                    continue;
                }
                if (!JsonPathIocSchemaThreatIntelHandler.isStringAndNonEmpty(typesList, i)) {
                    log.error("Skipping parsing some iocs since type {} is not a valid string in threat intel source {}", typesList.get(i), (Object)sourceName);
                    continue;
                }
                String type = String.valueOf(typesList.get(i));
                if (Strings.isBlank((String)type)) {
                    log.error("Skipping parsing some iocs since type is blank in threat intel source " + sourceName);
                    continue;
                }
                List<String> valsList = JsonPathIocSchemaThreatIntelHandler.handleIocValueFieldParsing(valuesList, i);
                if (valsList.isEmpty()) continue;
                String id = ids.get(i);
                for (String value : valsList) {
                    res.add(new STIX2IOC(id, names.get(i), type, value, severityList.get(i), createdList.get(i), modifiedList.get(i), descriptionList.get(i), Collections.emptyList(), specVersionList.get(i), Strings.isBlank((String)sourceId) ? null : sourceId, sourceName, 1L));
                    id = UUID.randomUUID().toString();
                }
            }
            if (res.isEmpty()) {
                log.error("No valid IOCs found while parsing custom ioc schema threat intel source " + sourceName);
                throw new IllegalArgumentException("No valid IOCs found while parsing custom ioc schema threat intel source " + sourceName);
            }
            return res;
        }
        catch (Exception ex) {
            log.error(String.format("Unexpected failure while parsing custom ioc schema threat intel source %s", sourceName), (Throwable)ex);
            throw new IllegalArgumentException("Failed to parse threat intel ioc JSON with provided paths for source " + sourceName, ex);
        }
    }

    private static boolean isStringAndNonEmpty(List<Object> typesList, int index) {
        return typesList.get(index) instanceof String && false == Strings.isBlank((String)typesList.get(index).toString());
    }

    private static Predicate<Object> objectIsNullOrNotStringOrNotVal() {
        return obj -> Objects.isNull(obj) || false == (obj instanceof String || obj instanceof Number);
    }

    private static Predicate<Object> objectIsNullOrNotStringOrNotArray() {
        return obj -> {
            if (Objects.isNull(obj)) {
                return true;
            }
            if (obj instanceof String) {
                return false;
            }
            if (obj instanceof Collection) {
                return ((Collection)obj).stream().allMatch(JsonPathIocSchemaThreatIntelHandler.objectIsNullOrNotStringOrNotVal());
            }
            return true;
        };
    }

    private static List<String> parseStringListFromJsonPathNotation(DocumentContext context, JsonPathSchemaField schemaField, boolean replaceNullsWithRandom, int listSize) {
        ArrayList<String> res = new ArrayList<String>();
        if (schemaField == null || schemaField.getJsonPath() == null) {
            for (int i = 0; i < listSize; ++i) {
                if (replaceNullsWithRandom) {
                    res.add(UUID.randomUUID().toString());
                    continue;
                }
                res.add(null);
            }
            return res;
        }
        List fieldValues = (List)context.read(schemaField.getJsonPath(), new com.jayway.jsonpath.Predicate[0]);
        if (fieldValues == null || fieldValues.isEmpty() || fieldValues.stream().allMatch(s -> s == null || Strings.isBlank((String)s.toString()))) {
            for (int i = 0; i < listSize; ++i) {
                if (replaceNullsWithRandom) {
                    res.add(UUID.randomUUID().toString());
                    continue;
                }
                res.add(null);
            }
            return res;
        }
        for (int i = 0; i < listSize; ++i) {
            if (fieldValues.get(i) == null) {
                if (replaceNullsWithRandom) {
                    res.add(UUID.randomUUID().toString());
                    continue;
                }
                res.add(null);
                continue;
            }
            if (fieldValues.get(i) instanceof String) {
                res.add(fieldValues.get(i).toString());
                continue;
            }
            if (replaceNullsWithRandom) {
                res.add(UUID.randomUUID().toString());
                continue;
            }
            res.add(null);
        }
        return res;
    }

    private static List<Instant> parseInstantListFromJsonPathNotation(DocumentContext context, JsonPathSchemaField schemaField, int listSize) {
        ArrayList<Instant> res = new ArrayList<Instant>();
        if (schemaField == null || schemaField.getJsonPath() == null) {
            for (int i = 0; i < listSize; ++i) {
                res.add(null);
            }
            return res;
        }
        List fieldValues = (List)context.read(schemaField.getJsonPath(), new com.jayway.jsonpath.Predicate[0]);
        if (fieldValues == null || fieldValues.isEmpty() || fieldValues.stream().allMatch(s -> s == null || Strings.isBlank((String)s.toString()))) {
            for (int i = 0; i < listSize; ++i) {
                res.add(null);
            }
            return res;
        }
        for (int i = 0; i < listSize; ++i) {
            if (fieldValues.get(i) == null) {
                res.add(null);
                continue;
            }
            try {
                String value = fieldValues.get(i).toString();
                res.add(Instant.parse(value));
                continue;
            }
            catch (Exception ex) {
                log.error(String.format("Failed to parse Instant value from json path notation [%s]", schemaField.getJsonPath()), (Throwable)ex);
                res.add(null);
            }
        }
        return res;
    }

    private static List<String> handleIocValueFieldParsing(List<Object> valuesList, int i) {
        ArrayList<String> valsList = new ArrayList<String>();
        if (valuesList.stream().allMatch(JsonPathIocSchemaThreatIntelHandler::nullOrBlank)) {
            return Collections.emptyList();
        }
        if (valuesList.get(i) instanceof List) {
            ((List)valuesList.get(i)).stream().filter(it -> it instanceof String && !Strings.isBlank((String)it.toString()) || it instanceof Number).forEach(it -> valsList.add(it.toString()));
        } else if (valuesList.get(i) instanceof String || valuesList.get(i) instanceof Number) {
            String value = String.valueOf(valuesList.get(i));
            valsList.add(value);
        }
        return valsList;
    }

    private static boolean nullOrBlank(Object it) {
        return it == null || Strings.isBlank((String)it.toString());
    }

    private static class StringIocHandler
    implements IocInputHandler {
        private final String iocsJson;

        public StringIocHandler(String iocsJson) {
            this.iocsJson = iocsJson;
        }

        @Override
        public DocumentContext getDocumentContext(Configuration conf) {
            return JsonPath.using((Configuration)conf).parse(this.iocsJson);
        }
    }

    private static interface IocInputHandler {
        public DocumentContext getDocumentContext(Configuration var1) throws Exception;
    }

    private static class InputStreamIocHandler
    implements IocInputHandler {
        private final InputStream inputStream;

        public InputStreamIocHandler(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public DocumentContext getDocumentContext(Configuration conf) {
            return JsonPath.using((Configuration)conf).parse(this.inputStream);
        }
    }
}

