/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ubi.ext;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.search.SearchExtBuilder;
import org.opensearch.ubi.ext.UbiParametersExtBuilder;

public class UbiParameters
implements Writeable,
ToXContentObject {
    private static final ObjectParser<UbiParameters, Void> PARSER;
    private static final ParseField QUERY_ID;
    private static final ParseField USER_QUERY;
    private static final ParseField CLIENT_ID;
    private static final ParseField APPLICATION;
    private static final ParseField OBJECT_ID_FIELD;
    private static final ParseField QUERY_ATTRIBUTES;
    private String queryId;
    private String userQuery;
    private String clientId;
    private String application;
    private String objectIdField;
    private Map<String, String> queryAttributes;

    public static UbiParameters getUbiParameters(SearchRequest request) {
        Optional<SearchExtBuilder> b;
        UbiParametersExtBuilder builder = null;
        if (request.source() != null && request.source().ext() != null && !request.source().ext().isEmpty() && (b = request.source().ext().stream().filter(bldr -> "ubi".equals(bldr.getWriteableName())).findFirst()).isPresent()) {
            builder = (UbiParametersExtBuilder)b.get();
        }
        if (builder != null) {
            return builder.getParams();
        }
        return null;
    }

    public UbiParameters() {
    }

    public UbiParameters(StreamInput input) throws IOException {
        this.queryId = input.readString();
        this.userQuery = input.readOptionalString();
        this.clientId = input.readOptionalString();
        this.application = input.readOptionalString();
        this.objectIdField = input.readOptionalString();
        this.queryAttributes = (Map)input.readGenericValue();
    }

    public UbiParameters(String queryId, String userQuery, String clientId, String application, String objectIdField, Map<String, String> queryAttributes) {
        this.queryId = queryId;
        this.userQuery = userQuery;
        this.clientId = clientId;
        this.application = application;
        this.objectIdField = objectIdField;
        this.queryAttributes = queryAttributes;
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        return xContentBuilder.field(QUERY_ID.getPreferredName(), this.queryId).field(USER_QUERY.getPreferredName(), this.userQuery).field(CLIENT_ID.getPreferredName(), this.clientId).field(APPLICATION.getPreferredName(), this.application).field(OBJECT_ID_FIELD.getPreferredName(), this.objectIdField).field(QUERY_ATTRIBUTES.getPreferredName(), this.queryAttributes);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.getQueryId());
        out.writeOptionalString(this.userQuery);
        out.writeOptionalString(this.clientId);
        out.writeOptionalString(this.application);
        out.writeOptionalString(this.objectIdField);
        out.writeGenericValue(this.queryAttributes);
    }

    public static UbiParameters parse(XContentParser parser) throws IOException {
        return (UbiParameters)PARSER.parse(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UbiParameters other = (UbiParameters)o;
        return Objects.equals(this.queryId, other.getQueryId()) && Objects.equals(this.userQuery, other.getUserQuery()) && Objects.equals(this.clientId, other.getClientId()) && Objects.equals(this.application, other.getApplication()) && Objects.equals(this.objectIdField, other.getObjectIdField()) && Objects.equals(this.queryAttributes, other.getQueryAttributes());
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.queryId);
    }

    public String getQueryId() {
        if (this.queryId == null) {
            this.queryId = UUID.randomUUID().toString();
        }
        return this.queryId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getObjectIdField() {
        return this.objectIdField;
    }

    public void setObjectIdField(String objectIdField) {
        this.objectIdField = objectIdField;
    }

    public String getUserQuery() {
        return this.userQuery;
    }

    public void setUserQuery(String userQuery) {
        this.userQuery = userQuery;
    }

    public Map<String, String> getQueryAttributes() {
        if (this.queryAttributes == null) {
            this.queryAttributes = new HashMap<String, String>();
        }
        return this.queryAttributes;
    }

    public void setQueryAttributes(Map<String, String> queryAttributes) {
        this.queryAttributes = queryAttributes;
    }

    static {
        QUERY_ID = new ParseField("query_id", new String[0]);
        USER_QUERY = new ParseField("user_query", new String[0]);
        CLIENT_ID = new ParseField("client_id", new String[0]);
        APPLICATION = new ParseField("application", new String[0]);
        OBJECT_ID_FIELD = new ParseField("object_id_field", new String[0]);
        QUERY_ATTRIBUTES = new ParseField("query_attributes", new String[0]);
        PARSER = new ObjectParser("ubi", UbiParameters::new);
        PARSER.declareString(UbiParameters::setQueryId, QUERY_ID);
        PARSER.declareString(UbiParameters::setUserQuery, USER_QUERY);
        PARSER.declareString(UbiParameters::setClientId, CLIENT_ID);
        PARSER.declareString(UbiParameters::setApplication, APPLICATION);
        PARSER.declareString(UbiParameters::setObjectIdField, OBJECT_ID_FIELD);
        PARSER.declareObject(UbiParameters::setQueryAttributes, (p, c) -> p.mapStrings(), QUERY_ATTRIBUTES);
    }
}

