/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.transport.judgment;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.search.SearchHit;
import org.opensearch.searchrelevance.dao.ExperimentDao;
import org.opensearch.searchrelevance.dao.JudgmentDao;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.transport.OpenSearchDocRequest;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class DeleteJudgmentTransportAction
extends HandledTransportAction<OpenSearchDocRequest, DeleteResponse> {
    private final ClusterService clusterService;
    private final JudgmentDao judgmentDao;
    private final ExperimentDao experimentDao;

    @Inject
    public DeleteJudgmentTransportAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, JudgmentDao judgmentDao, ExperimentDao experimentDao) {
        super("cluster:admin/opensearch/search_relevance/judgment/delete", transportService, actionFilters, OpenSearchDocRequest::new);
        this.clusterService = clusterService;
        this.judgmentDao = judgmentDao;
        this.experimentDao = experimentDao;
    }

    protected void doExecute(Task task, OpenSearchDocRequest request, final ActionListener<DeleteResponse> listener) {
        try {
            final String judgmentId = request.getId();
            if (judgmentId == null || judgmentId.trim().isEmpty()) {
                listener.onFailure((Exception)((Object)new SearchRelevanceException("judgmentId cannot be null or empty", RestStatus.BAD_REQUEST)));
                return;
            }
            this.experimentDao.getExperimentByFieldId(judgmentId, "judgmentList", 3, new ActionListener<SearchResponse>(this){
                final /* synthetic */ DeleteJudgmentTransportAction this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(SearchResponse experiments) {
                    if (experiments != null && experiments.getHits().getTotalHits().value() > 0L) {
                        List<String> ids = Arrays.stream(experiments.getHits().getHits()).map(SearchHit::getId).toList();
                        listener.onFailure((Exception)((Object)new SearchRelevanceException(String.format(Locale.ROOT, "judgement cannot be deleted as it is currently used by experiments with ids %s", String.join((CharSequence)", ", ids)), RestStatus.CONFLICT)));
                        return;
                    }
                    this.this$0.judgmentDao.deleteJudgment(judgmentId, (ActionListener<DeleteResponse>)listener);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

