/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.utils;

public class TextValidationUtil {
    private static final int DEFAULT_MAX_TEXT_LENGTH = 2000;
    private static final int MAX_NAME_LENGTH = 50;
    private static final int MAX_DESCRIPTION_LENGTH = 250;
    private static final String DANGEROUS_CHARS_PATTERN = "[\"\\\\<>]+";

    public static ValidationResult validateText(String text) {
        return TextValidationUtil.validateText(text, 2000);
    }

    public static ValidationResult validateText(String text, int maxLength) {
        if (text == null) {
            return new ValidationResult(false, "Text cannot be null");
        }
        if (text.isEmpty()) {
            return new ValidationResult(false, "Text cannot be empty");
        }
        if (text.length() > maxLength) {
            return new ValidationResult(false, "Text exceeds maximum length of " + maxLength + " characters");
        }
        if (text.matches(".*[\"\\\\<>]+.*")) {
            return new ValidationResult(false, "Text contains invalid characters (quotes, backslashes, or HTML tags are not allowed)");
        }
        return new ValidationResult(true, null);
    }

    public static ValidationResult validateName(String name) {
        return TextValidationUtil.validateText(name, 50);
    }

    public static ValidationResult validateDescription(String description) {
        return TextValidationUtil.validateText(description, 250);
    }

    public static class ValidationResult {
        private final boolean valid;
        private final String errorMessage;

        public ValidationResult(boolean valid, String errorMessage) {
            this.valid = valid;
            this.errorMessage = errorMessage;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

