/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.geospatial;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.geospatial.GeoJSONData;
import org.opensearch.client.opensearch.geospatial.GeojsonUploadPostResponse;
import org.opensearch.client.opensearch.geospatial.GeospatialFieldType;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class GeojsonUploadPostRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, GeojsonUploadPostRequest> {
    @Nonnull
    private final List<GeoJSONData> data;
    @Nullable
    private final String field;
    @Nonnull
    private final String index;
    @Nonnull
    private final GeospatialFieldType type;
    public static final JsonpDeserializer<GeojsonUploadPostRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeojsonUploadPostRequest::setupGeojsonUploadPostRequestDeserializer);
    public static final Endpoint<GeojsonUploadPostRequest, GeojsonUploadPostResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GeojsonUploadPostRequest, GeojsonUploadPostResponse>(request -> "POST", request -> "/_plugins/geospatial/geojson/_upload", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, GeojsonUploadPostResponse._DESERIALIZER);

    private GeojsonUploadPostRequest(Builder builder) {
        super(builder);
        this.data = ApiTypeHelper.unmodifiableRequired(builder.data, (Object)this, "data");
        this.field = builder.field;
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static GeojsonUploadPostRequest of(Function<Builder, ObjectBuilder<GeojsonUploadPostRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<GeoJSONData> data() {
        return this.data;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nonnull
    public final String index() {
        return this.index;
    }

    @Nonnull
    public final GeospatialFieldType type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("data");
        generator.writeStartArray();
        for (GeoJSONData item0 : this.data) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        generator.writeKey("index");
        generator.write(this.index);
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGeojsonUploadPostRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::data, JsonpDeserializer.arrayDeserializer(GeoJSONData._DESERIALIZER), "data");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::type, GeospatialFieldType._DESERIALIZER, "type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.data.hashCode();
        result = 31 * result + Objects.hashCode(this.field);
        result = 31 * result + this.index.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeojsonUploadPostRequest other = (GeojsonUploadPostRequest)o;
        return this.data.equals(other.data) && Objects.equals(this.field, other.field) && this.index.equals(other.index) && this.type.equals(other.type);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, GeojsonUploadPostRequest> {
        private List<GeoJSONData> data;
        @Nullable
        private String field;
        private String index;
        private GeospatialFieldType type;

        public Builder() {
        }

        private Builder(GeojsonUploadPostRequest o) {
            super(o);
            this.data = Builder._listCopy(o.data);
            this.field = o.field;
            this.index = o.index;
            this.type = o.type;
        }

        private Builder(Builder o) {
            super(o);
            this.data = Builder._listCopy(o.data);
            this.field = o.field;
            this.index = o.index;
            this.type = o.type;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder data(List<GeoJSONData> list) {
            this.data = Builder._listAddAll(this.data, list);
            return this;
        }

        @Nonnull
        public final Builder data(GeoJSONData value, GeoJSONData ... values) {
            this.data = Builder._listAdd(this.data, value, values);
            return this;
        }

        @Nonnull
        public final Builder data(Function<GeoJSONData.Builder, ObjectBuilder<GeoJSONData>> fn) {
            return this.data(fn.apply(new GeoJSONData.Builder()).build(), new GeoJSONData[0]);
        }

        @Nonnull
        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder type(GeospatialFieldType value) {
            this.type = value;
            return this;
        }

        @Override
        @Nonnull
        public GeojsonUploadPostRequest build() {
            this._checkSingleUse();
            return new GeojsonUploadPostRequest(this);
        }
    }
}

