/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.NodeRole;
import org.opensearch.client.opensearch.nodes.stats.AdaptiveSelection;
import org.opensearch.client.opensearch.nodes.stats.Breaker;
import org.opensearch.client.opensearch.nodes.stats.CacheStats;
import org.opensearch.client.opensearch.nodes.stats.Discovery;
import org.opensearch.client.opensearch.nodes.stats.FileSystem;
import org.opensearch.client.opensearch.nodes.stats.Http;
import org.opensearch.client.opensearch.nodes.stats.IndexingPressure;
import org.opensearch.client.opensearch.nodes.stats.Ingest;
import org.opensearch.client.opensearch.nodes.stats.Jvm;
import org.opensearch.client.opensearch.nodes.stats.NodeIndicesStats;
import org.opensearch.client.opensearch.nodes.stats.OperatingSystem;
import org.opensearch.client.opensearch.nodes.stats.Process;
import org.opensearch.client.opensearch.nodes.stats.RemoteStoreStats;
import org.opensearch.client.opensearch.nodes.stats.ScriptCacheStats;
import org.opensearch.client.opensearch.nodes.stats.ScriptStats;
import org.opensearch.client.opensearch.nodes.stats.ShardAdmissionControlStats;
import org.opensearch.client.opensearch.nodes.stats.ShardClusterManagerThrottlingStats;
import org.opensearch.client.opensearch.nodes.stats.ShardIndexingPressureStats;
import org.opensearch.client.opensearch.nodes.stats.ShardResourceUsageStatsDetail;
import org.opensearch.client.opensearch.nodes.stats.ShardSearchBackpressureStats;
import org.opensearch.client.opensearch.nodes.stats.ShardSearchPipelineStats;
import org.opensearch.client.opensearch.nodes.stats.ShardSegmentReplicationBackpressureStats;
import org.opensearch.client.opensearch.nodes.stats.ShardTaskCancellationStats;
import org.opensearch.client.opensearch.nodes.stats.ShardWeightedRoutingStats;
import org.opensearch.client.opensearch.nodes.stats.ThreadCount;
import org.opensearch.client.opensearch.nodes.stats.Transport;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Stats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Stats> {
    @Nonnull
    private final Map<String, AdaptiveSelection> adaptiveSelection;
    @Nullable
    private final ShardAdmissionControlStats admissionControl;
    @Nonnull
    private final Map<String, String> attributes;
    @Nonnull
    private final Map<String, Breaker> breakers;
    @Nonnull
    private final Map<String, CacheStats> caches;
    @Nullable
    private final ShardClusterManagerThrottlingStats clusterManagerThrottling;
    @Nullable
    private final Discovery discovery;
    @Nullable
    private final FileSystem fs;
    @Nullable
    private final String host;
    @Nullable
    private final Http http;
    @Nullable
    private final IndexingPressure indexingPressure;
    @Nullable
    private final NodeIndicesStats indices;
    @Nullable
    private final Ingest ingest;
    @Nonnull
    private final List<String> ip;
    @Nullable
    private final Jvm jvm;
    @Nullable
    private final String name;
    @Nullable
    private final OperatingSystem os;
    @Nullable
    private final Process process;
    @Nullable
    private final RemoteStoreStats remoteStore;
    @Nonnull
    private final List<JsonData> repositories;
    @Nonnull
    private final Map<String, ShardResourceUsageStatsDetail> resourceUsageStats;
    @Nonnull
    private final List<NodeRole> roles;
    @Nullable
    private final ScriptStats script;
    @Nullable
    private final ScriptCacheStats scriptCache;
    @Nullable
    private final ShardSearchBackpressureStats searchBackpressure;
    @Nullable
    private final ShardSearchPipelineStats searchPipeline;
    @Nullable
    private final ShardSegmentReplicationBackpressureStats segmentReplicationBackpressure;
    @Nullable
    private final ShardIndexingPressureStats shardIndexingPressure;
    @Nullable
    private final ShardTaskCancellationStats taskCancellation;
    @Nonnull
    private final Map<String, ThreadCount> threadPool;
    @Nullable
    private final Long timestamp;
    @Nullable
    private final Transport transport;
    @Nullable
    private final String transportAddress;
    @Nullable
    private final ShardWeightedRoutingStats weightedRouting;
    public static final JsonpDeserializer<Stats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Stats::setupStatsDeserializer);

    private Stats(Builder builder) {
        this.adaptiveSelection = ApiTypeHelper.unmodifiable(builder.adaptiveSelection);
        this.admissionControl = builder.admissionControl;
        this.attributes = ApiTypeHelper.unmodifiable(builder.attributes);
        this.breakers = ApiTypeHelper.unmodifiable(builder.breakers);
        this.caches = ApiTypeHelper.unmodifiable(builder.caches);
        this.clusterManagerThrottling = builder.clusterManagerThrottling;
        this.discovery = builder.discovery;
        this.fs = builder.fs;
        this.host = builder.host;
        this.http = builder.http;
        this.indexingPressure = builder.indexingPressure;
        this.indices = builder.indices;
        this.ingest = builder.ingest;
        this.ip = ApiTypeHelper.unmodifiable(builder.ip);
        this.jvm = builder.jvm;
        this.name = builder.name;
        this.os = builder.os;
        this.process = builder.process;
        this.remoteStore = builder.remoteStore;
        this.repositories = ApiTypeHelper.unmodifiable(builder.repositories);
        this.resourceUsageStats = ApiTypeHelper.unmodifiable(builder.resourceUsageStats);
        this.roles = ApiTypeHelper.unmodifiable(builder.roles);
        this.script = builder.script;
        this.scriptCache = builder.scriptCache;
        this.searchBackpressure = builder.searchBackpressure;
        this.searchPipeline = builder.searchPipeline;
        this.segmentReplicationBackpressure = builder.segmentReplicationBackpressure;
        this.shardIndexingPressure = builder.shardIndexingPressure;
        this.taskCancellation = builder.taskCancellation;
        this.threadPool = ApiTypeHelper.unmodifiable(builder.threadPool);
        this.timestamp = builder.timestamp;
        this.transport = builder.transport;
        this.transportAddress = builder.transportAddress;
        this.weightedRouting = builder.weightedRouting;
    }

    public static Stats of(Function<Builder, ObjectBuilder<Stats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, AdaptiveSelection> adaptiveSelection() {
        return this.adaptiveSelection;
    }

    @Nullable
    public final ShardAdmissionControlStats admissionControl() {
        return this.admissionControl;
    }

    @Nonnull
    public final Map<String, String> attributes() {
        return this.attributes;
    }

    @Nonnull
    public final Map<String, Breaker> breakers() {
        return this.breakers;
    }

    @Nonnull
    public final Map<String, CacheStats> caches() {
        return this.caches;
    }

    @Nullable
    public final ShardClusterManagerThrottlingStats clusterManagerThrottling() {
        return this.clusterManagerThrottling;
    }

    @Nullable
    public final Discovery discovery() {
        return this.discovery;
    }

    @Nullable
    public final FileSystem fs() {
        return this.fs;
    }

    @Nullable
    public final String host() {
        return this.host;
    }

    @Nullable
    public final Http http() {
        return this.http;
    }

    @Nullable
    public final IndexingPressure indexingPressure() {
        return this.indexingPressure;
    }

    @Nullable
    public final NodeIndicesStats indices() {
        return this.indices;
    }

    @Nullable
    public final Ingest ingest() {
        return this.ingest;
    }

    @Nonnull
    public final List<String> ip() {
        return this.ip;
    }

    @Nullable
    public final Jvm jvm() {
        return this.jvm;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Nullable
    public final OperatingSystem os() {
        return this.os;
    }

    @Nullable
    public final Process process() {
        return this.process;
    }

    @Nullable
    public final RemoteStoreStats remoteStore() {
        return this.remoteStore;
    }

    @Nonnull
    public final List<JsonData> repositories() {
        return this.repositories;
    }

    @Nonnull
    public final Map<String, ShardResourceUsageStatsDetail> resourceUsageStats() {
        return this.resourceUsageStats;
    }

    @Nonnull
    public final List<NodeRole> roles() {
        return this.roles;
    }

    @Nullable
    public final ScriptStats script() {
        return this.script;
    }

    @Nullable
    public final ScriptCacheStats scriptCache() {
        return this.scriptCache;
    }

    @Nullable
    public final ShardSearchBackpressureStats searchBackpressure() {
        return this.searchBackpressure;
    }

    @Nullable
    public final ShardSearchPipelineStats searchPipeline() {
        return this.searchPipeline;
    }

    @Nullable
    public final ShardSegmentReplicationBackpressureStats segmentReplicationBackpressure() {
        return this.segmentReplicationBackpressure;
    }

    @Nullable
    public final ShardIndexingPressureStats shardIndexingPressure() {
        return this.shardIndexingPressure;
    }

    @Nullable
    public final ShardTaskCancellationStats taskCancellation() {
        return this.taskCancellation;
    }

    @Nonnull
    public final Map<String, ThreadCount> threadPool() {
        return this.threadPool;
    }

    @Nullable
    public final Long timestamp() {
        return this.timestamp;
    }

    @Nullable
    public final Transport transport() {
        return this.transport;
    }

    @Nullable
    public final String transportAddress() {
        return this.transportAddress;
    }

    @Nullable
    public final ShardWeightedRoutingStats weightedRouting() {
        return this.weightedRouting;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.adaptiveSelection)) {
            generator.writeKey("adaptive_selection");
            generator.writeStartObject();
            for (Map.Entry<String, AdaptiveSelection> entry : this.adaptiveSelection.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.admissionControl != null) {
            generator.writeKey("admission_control");
            this.admissionControl.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.attributes)) {
            generator.writeKey("attributes");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.breakers)) {
            generator.writeKey("breakers");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.breakers.entrySet()) {
                generator.writeKey(entry.getKey());
                ((Breaker)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.caches)) {
            generator.writeKey("caches");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.caches.entrySet()) {
                generator.writeKey(entry.getKey());
                ((CacheStats)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.clusterManagerThrottling != null) {
            generator.writeKey("cluster_manager_throttling");
            this.clusterManagerThrottling.serialize(generator, mapper);
        }
        if (this.discovery != null) {
            generator.writeKey("discovery");
            this.discovery.serialize(generator, mapper);
        }
        if (this.fs != null) {
            generator.writeKey("fs");
            this.fs.serialize(generator, mapper);
        }
        if (this.host != null) {
            generator.writeKey("host");
            generator.write(this.host);
        }
        if (this.http != null) {
            generator.writeKey("http");
            this.http.serialize(generator, mapper);
        }
        if (this.indexingPressure != null) {
            generator.writeKey("indexing_pressure");
            this.indexingPressure.serialize(generator, mapper);
        }
        if (this.indices != null) {
            generator.writeKey("indices");
            this.indices.serialize(generator, mapper);
        }
        if (this.ingest != null) {
            generator.writeKey("ingest");
            this.ingest.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.ip)) {
            generator.writeKey("ip");
            generator.writeStartArray();
            for (String string : this.ip) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.jvm != null) {
            generator.writeKey("jvm");
            this.jvm.serialize(generator, mapper);
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.os != null) {
            generator.writeKey("os");
            this.os.serialize(generator, mapper);
        }
        if (this.process != null) {
            generator.writeKey("process");
            this.process.serialize(generator, mapper);
        }
        if (this.remoteStore != null) {
            generator.writeKey("remote_store");
            this.remoteStore.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.repositories)) {
            generator.writeKey("repositories");
            generator.writeStartArray();
            for (JsonData jsonData : this.repositories) {
                jsonData.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.resourceUsageStats)) {
            generator.writeKey("resource_usage_stats");
            generator.writeStartObject();
            for (Map.Entry entry : this.resourceUsageStats.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((ShardResourceUsageStatsDetail)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (NodeRole nodeRole : this.roles) {
                nodeRole.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.scriptCache != null) {
            generator.writeKey("script_cache");
            this.scriptCache.serialize(generator, mapper);
        }
        if (this.searchBackpressure != null) {
            generator.writeKey("search_backpressure");
            this.searchBackpressure.serialize(generator, mapper);
        }
        if (this.searchPipeline != null) {
            generator.writeKey("search_pipeline");
            this.searchPipeline.serialize(generator, mapper);
        }
        if (this.segmentReplicationBackpressure != null) {
            generator.writeKey("segment_replication_backpressure");
            this.segmentReplicationBackpressure.serialize(generator, mapper);
        }
        if (this.shardIndexingPressure != null) {
            generator.writeKey("shard_indexing_pressure");
            this.shardIndexingPressure.serialize(generator, mapper);
        }
        if (this.taskCancellation != null) {
            generator.writeKey("task_cancellation");
            this.taskCancellation.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.threadPool)) {
            generator.writeKey("thread_pool");
            generator.writeStartObject();
            for (Map.Entry entry : this.threadPool.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((ThreadCount)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.timestamp != null) {
            generator.writeKey("timestamp");
            generator.write(this.timestamp.longValue());
        }
        if (this.transport != null) {
            generator.writeKey("transport");
            this.transport.serialize(generator, mapper);
        }
        if (this.transportAddress != null) {
            generator.writeKey("transport_address");
            generator.write(this.transportAddress);
        }
        if (this.weightedRouting != null) {
            generator.writeKey("weighted_routing");
            this.weightedRouting.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::adaptiveSelection, JsonpDeserializer.stringMapDeserializer(AdaptiveSelection._DESERIALIZER), "adaptive_selection");
        op.add(Builder::admissionControl, ShardAdmissionControlStats._DESERIALIZER, "admission_control");
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
        op.add(Builder::breakers, JsonpDeserializer.stringMapDeserializer(Breaker._DESERIALIZER), "breakers");
        op.add(Builder::caches, JsonpDeserializer.stringMapDeserializer(CacheStats._DESERIALIZER), "caches");
        op.add(Builder::clusterManagerThrottling, ShardClusterManagerThrottlingStats._DESERIALIZER, "cluster_manager_throttling");
        op.add(Builder::discovery, Discovery._DESERIALIZER, "discovery");
        op.add(Builder::fs, FileSystem._DESERIALIZER, "fs");
        op.add(Builder::host, JsonpDeserializer.stringDeserializer(), "host");
        op.add(Builder::http, Http._DESERIALIZER, "http");
        op.add(Builder::indexingPressure, IndexingPressure._DESERIALIZER, "indexing_pressure");
        op.add(Builder::indices, NodeIndicesStats._DESERIALIZER, "indices");
        op.add(Builder::ingest, Ingest._DESERIALIZER, "ingest");
        op.add(Builder::ip, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ip");
        op.add(Builder::jvm, Jvm._DESERIALIZER, "jvm");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::os, OperatingSystem._DESERIALIZER, "os");
        op.add(Builder::process, Process._DESERIALIZER, "process");
        op.add(Builder::remoteStore, RemoteStoreStats._DESERIALIZER, "remote_store");
        op.add(Builder::repositories, JsonpDeserializer.arrayDeserializer(JsonData._DESERIALIZER), "repositories");
        op.add(Builder::resourceUsageStats, JsonpDeserializer.stringMapDeserializer(ShardResourceUsageStatsDetail._DESERIALIZER), "resource_usage_stats");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(NodeRole._DESERIALIZER), "roles");
        op.add(Builder::script, ScriptStats._DESERIALIZER, "script");
        op.add(Builder::scriptCache, ScriptCacheStats._DESERIALIZER, "script_cache");
        op.add(Builder::searchBackpressure, ShardSearchBackpressureStats._DESERIALIZER, "search_backpressure");
        op.add(Builder::searchPipeline, ShardSearchPipelineStats._DESERIALIZER, "search_pipeline");
        op.add(Builder::segmentReplicationBackpressure, ShardSegmentReplicationBackpressureStats._DESERIALIZER, "segment_replication_backpressure");
        op.add(Builder::shardIndexingPressure, ShardIndexingPressureStats._DESERIALIZER, "shard_indexing_pressure");
        op.add(Builder::taskCancellation, ShardTaskCancellationStats._DESERIALIZER, "task_cancellation");
        op.add(Builder::threadPool, JsonpDeserializer.stringMapDeserializer(ThreadCount._DESERIALIZER), "thread_pool");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
        op.add(Builder::transport, Transport._DESERIALIZER, "transport");
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address");
        op.add(Builder::weightedRouting, ShardWeightedRoutingStats._DESERIALIZER, "weighted_routing");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.adaptiveSelection);
        result = 31 * result + Objects.hashCode(this.admissionControl);
        result = 31 * result + Objects.hashCode(this.attributes);
        result = 31 * result + Objects.hashCode(this.breakers);
        result = 31 * result + Objects.hashCode(this.caches);
        result = 31 * result + Objects.hashCode(this.clusterManagerThrottling);
        result = 31 * result + Objects.hashCode(this.discovery);
        result = 31 * result + Objects.hashCode(this.fs);
        result = 31 * result + Objects.hashCode(this.host);
        result = 31 * result + Objects.hashCode(this.http);
        result = 31 * result + Objects.hashCode(this.indexingPressure);
        result = 31 * result + Objects.hashCode(this.indices);
        result = 31 * result + Objects.hashCode(this.ingest);
        result = 31 * result + Objects.hashCode(this.ip);
        result = 31 * result + Objects.hashCode(this.jvm);
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.os);
        result = 31 * result + Objects.hashCode(this.process);
        result = 31 * result + Objects.hashCode(this.remoteStore);
        result = 31 * result + Objects.hashCode(this.repositories);
        result = 31 * result + Objects.hashCode(this.resourceUsageStats);
        result = 31 * result + Objects.hashCode(this.roles);
        result = 31 * result + Objects.hashCode(this.script);
        result = 31 * result + Objects.hashCode(this.scriptCache);
        result = 31 * result + Objects.hashCode(this.searchBackpressure);
        result = 31 * result + Objects.hashCode(this.searchPipeline);
        result = 31 * result + Objects.hashCode(this.segmentReplicationBackpressure);
        result = 31 * result + Objects.hashCode(this.shardIndexingPressure);
        result = 31 * result + Objects.hashCode(this.taskCancellation);
        result = 31 * result + Objects.hashCode(this.threadPool);
        result = 31 * result + Objects.hashCode(this.timestamp);
        result = 31 * result + Objects.hashCode(this.transport);
        result = 31 * result + Objects.hashCode(this.transportAddress);
        result = 31 * result + Objects.hashCode(this.weightedRouting);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stats other = (Stats)o;
        return Objects.equals(this.adaptiveSelection, other.adaptiveSelection) && Objects.equals(this.admissionControl, other.admissionControl) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.breakers, other.breakers) && Objects.equals(this.caches, other.caches) && Objects.equals(this.clusterManagerThrottling, other.clusterManagerThrottling) && Objects.equals(this.discovery, other.discovery) && Objects.equals(this.fs, other.fs) && Objects.equals(this.host, other.host) && Objects.equals(this.http, other.http) && Objects.equals(this.indexingPressure, other.indexingPressure) && Objects.equals(this.indices, other.indices) && Objects.equals(this.ingest, other.ingest) && Objects.equals(this.ip, other.ip) && Objects.equals(this.jvm, other.jvm) && Objects.equals(this.name, other.name) && Objects.equals(this.os, other.os) && Objects.equals(this.process, other.process) && Objects.equals(this.remoteStore, other.remoteStore) && Objects.equals(this.repositories, other.repositories) && Objects.equals(this.resourceUsageStats, other.resourceUsageStats) && Objects.equals(this.roles, other.roles) && Objects.equals(this.script, other.script) && Objects.equals(this.scriptCache, other.scriptCache) && Objects.equals(this.searchBackpressure, other.searchBackpressure) && Objects.equals(this.searchPipeline, other.searchPipeline) && Objects.equals(this.segmentReplicationBackpressure, other.segmentReplicationBackpressure) && Objects.equals(this.shardIndexingPressure, other.shardIndexingPressure) && Objects.equals(this.taskCancellation, other.taskCancellation) && Objects.equals(this.threadPool, other.threadPool) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.transport, other.transport) && Objects.equals(this.transportAddress, other.transportAddress) && Objects.equals(this.weightedRouting, other.weightedRouting);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Stats> {
        @Nullable
        private Map<String, AdaptiveSelection> adaptiveSelection;
        @Nullable
        private ShardAdmissionControlStats admissionControl;
        @Nullable
        private Map<String, String> attributes;
        @Nullable
        private Map<String, Breaker> breakers;
        @Nullable
        private Map<String, CacheStats> caches;
        @Nullable
        private ShardClusterManagerThrottlingStats clusterManagerThrottling;
        @Nullable
        private Discovery discovery;
        @Nullable
        private FileSystem fs;
        @Nullable
        private String host;
        @Nullable
        private Http http;
        @Nullable
        private IndexingPressure indexingPressure;
        @Nullable
        private NodeIndicesStats indices;
        @Nullable
        private Ingest ingest;
        @Nullable
        private List<String> ip;
        @Nullable
        private Jvm jvm;
        @Nullable
        private String name;
        @Nullable
        private OperatingSystem os;
        @Nullable
        private Process process;
        @Nullable
        private RemoteStoreStats remoteStore;
        @Nullable
        private List<JsonData> repositories;
        @Nullable
        private Map<String, ShardResourceUsageStatsDetail> resourceUsageStats;
        @Nullable
        private List<NodeRole> roles;
        @Nullable
        private ScriptStats script;
        @Nullable
        private ScriptCacheStats scriptCache;
        @Nullable
        private ShardSearchBackpressureStats searchBackpressure;
        @Nullable
        private ShardSearchPipelineStats searchPipeline;
        @Nullable
        private ShardSegmentReplicationBackpressureStats segmentReplicationBackpressure;
        @Nullable
        private ShardIndexingPressureStats shardIndexingPressure;
        @Nullable
        private ShardTaskCancellationStats taskCancellation;
        @Nullable
        private Map<String, ThreadCount> threadPool;
        @Nullable
        private Long timestamp;
        @Nullable
        private Transport transport;
        @Nullable
        private String transportAddress;
        @Nullable
        private ShardWeightedRoutingStats weightedRouting;

        public Builder() {
        }

        private Builder(Stats o) {
            this.adaptiveSelection = Builder._mapCopy(o.adaptiveSelection);
            this.admissionControl = o.admissionControl;
            this.attributes = Builder._mapCopy(o.attributes);
            this.breakers = Builder._mapCopy(o.breakers);
            this.caches = Builder._mapCopy(o.caches);
            this.clusterManagerThrottling = o.clusterManagerThrottling;
            this.discovery = o.discovery;
            this.fs = o.fs;
            this.host = o.host;
            this.http = o.http;
            this.indexingPressure = o.indexingPressure;
            this.indices = o.indices;
            this.ingest = o.ingest;
            this.ip = Builder._listCopy(o.ip);
            this.jvm = o.jvm;
            this.name = o.name;
            this.os = o.os;
            this.process = o.process;
            this.remoteStore = o.remoteStore;
            this.repositories = Builder._listCopy(o.repositories);
            this.resourceUsageStats = Builder._mapCopy(o.resourceUsageStats);
            this.roles = Builder._listCopy(o.roles);
            this.script = o.script;
            this.scriptCache = o.scriptCache;
            this.searchBackpressure = o.searchBackpressure;
            this.searchPipeline = o.searchPipeline;
            this.segmentReplicationBackpressure = o.segmentReplicationBackpressure;
            this.shardIndexingPressure = o.shardIndexingPressure;
            this.taskCancellation = o.taskCancellation;
            this.threadPool = Builder._mapCopy(o.threadPool);
            this.timestamp = o.timestamp;
            this.transport = o.transport;
            this.transportAddress = o.transportAddress;
            this.weightedRouting = o.weightedRouting;
        }

        private Builder(Builder o) {
            this.adaptiveSelection = Builder._mapCopy(o.adaptiveSelection);
            this.admissionControl = o.admissionControl;
            this.attributes = Builder._mapCopy(o.attributes);
            this.breakers = Builder._mapCopy(o.breakers);
            this.caches = Builder._mapCopy(o.caches);
            this.clusterManagerThrottling = o.clusterManagerThrottling;
            this.discovery = o.discovery;
            this.fs = o.fs;
            this.host = o.host;
            this.http = o.http;
            this.indexingPressure = o.indexingPressure;
            this.indices = o.indices;
            this.ingest = o.ingest;
            this.ip = Builder._listCopy(o.ip);
            this.jvm = o.jvm;
            this.name = o.name;
            this.os = o.os;
            this.process = o.process;
            this.remoteStore = o.remoteStore;
            this.repositories = Builder._listCopy(o.repositories);
            this.resourceUsageStats = Builder._mapCopy(o.resourceUsageStats);
            this.roles = Builder._listCopy(o.roles);
            this.script = o.script;
            this.scriptCache = o.scriptCache;
            this.searchBackpressure = o.searchBackpressure;
            this.searchPipeline = o.searchPipeline;
            this.segmentReplicationBackpressure = o.segmentReplicationBackpressure;
            this.shardIndexingPressure = o.shardIndexingPressure;
            this.taskCancellation = o.taskCancellation;
            this.threadPool = Builder._mapCopy(o.threadPool);
            this.timestamp = o.timestamp;
            this.transport = o.transport;
            this.transportAddress = o.transportAddress;
            this.weightedRouting = o.weightedRouting;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder adaptiveSelection(Map<String, AdaptiveSelection> map) {
            this.adaptiveSelection = Builder._mapPutAll(this.adaptiveSelection, map);
            return this;
        }

        @Nonnull
        public final Builder adaptiveSelection(String key, AdaptiveSelection value) {
            this.adaptiveSelection = Builder._mapPut(this.adaptiveSelection, key, value);
            return this;
        }

        @Nonnull
        public final Builder adaptiveSelection(String key, Function<AdaptiveSelection.Builder, ObjectBuilder<AdaptiveSelection>> fn) {
            return this.adaptiveSelection(key, fn.apply(new AdaptiveSelection.Builder()).build());
        }

        @Nonnull
        public final Builder admissionControl(@Nullable ShardAdmissionControlStats value) {
            this.admissionControl = value;
            return this;
        }

        @Nonnull
        public final Builder admissionControl(Function<ShardAdmissionControlStats.Builder, ObjectBuilder<ShardAdmissionControlStats>> fn) {
            return this.admissionControl(fn.apply(new ShardAdmissionControlStats.Builder()).build());
        }

        @Nonnull
        public final Builder attributes(Map<String, String> map) {
            this.attributes = Builder._mapPutAll(this.attributes, map);
            return this;
        }

        @Nonnull
        public final Builder attributes(String key, String value) {
            this.attributes = Builder._mapPut(this.attributes, key, value);
            return this;
        }

        @Nonnull
        public final Builder breakers(Map<String, Breaker> map) {
            this.breakers = Builder._mapPutAll(this.breakers, map);
            return this;
        }

        @Nonnull
        public final Builder breakers(String key, Breaker value) {
            this.breakers = Builder._mapPut(this.breakers, key, value);
            return this;
        }

        @Nonnull
        public final Builder breakers(String key, Function<Breaker.Builder, ObjectBuilder<Breaker>> fn) {
            return this.breakers(key, fn.apply(new Breaker.Builder()).build());
        }

        @Nonnull
        public final Builder caches(Map<String, CacheStats> map) {
            this.caches = Builder._mapPutAll(this.caches, map);
            return this;
        }

        @Nonnull
        public final Builder caches(String key, CacheStats value) {
            this.caches = Builder._mapPut(this.caches, key, value);
            return this;
        }

        @Nonnull
        public final Builder caches(String key, Function<CacheStats.Builder, ObjectBuilder<CacheStats>> fn) {
            return this.caches(key, fn.apply(new CacheStats.Builder()).build());
        }

        @Nonnull
        public final Builder clusterManagerThrottling(@Nullable ShardClusterManagerThrottlingStats value) {
            this.clusterManagerThrottling = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerThrottling(Function<ShardClusterManagerThrottlingStats.Builder, ObjectBuilder<ShardClusterManagerThrottlingStats>> fn) {
            return this.clusterManagerThrottling(fn.apply(new ShardClusterManagerThrottlingStats.Builder()).build());
        }

        @Nonnull
        public final Builder discovery(@Nullable Discovery value) {
            this.discovery = value;
            return this;
        }

        @Nonnull
        public final Builder discovery(Function<Discovery.Builder, ObjectBuilder<Discovery>> fn) {
            return this.discovery(fn.apply(new Discovery.Builder()).build());
        }

        @Nonnull
        public final Builder fs(@Nullable FileSystem value) {
            this.fs = value;
            return this;
        }

        @Nonnull
        public final Builder fs(Function<FileSystem.Builder, ObjectBuilder<FileSystem>> fn) {
            return this.fs(fn.apply(new FileSystem.Builder()).build());
        }

        @Nonnull
        public final Builder host(@Nullable String value) {
            this.host = value;
            return this;
        }

        @Nonnull
        public final Builder http(@Nullable Http value) {
            this.http = value;
            return this;
        }

        @Nonnull
        public final Builder http(Function<Http.Builder, ObjectBuilder<Http>> fn) {
            return this.http(fn.apply(new Http.Builder()).build());
        }

        @Nonnull
        public final Builder indexingPressure(@Nullable IndexingPressure value) {
            this.indexingPressure = value;
            return this;
        }

        @Nonnull
        public final Builder indexingPressure(Function<IndexingPressure.Builder, ObjectBuilder<IndexingPressure>> fn) {
            return this.indexingPressure(fn.apply(new IndexingPressure.Builder()).build());
        }

        @Nonnull
        public final Builder indices(@Nullable NodeIndicesStats value) {
            this.indices = value;
            return this;
        }

        @Nonnull
        public final Builder indices(Function<NodeIndicesStats.Builder, ObjectBuilder<NodeIndicesStats>> fn) {
            return this.indices(fn.apply(new NodeIndicesStats.Builder()).build());
        }

        @Nonnull
        public final Builder ingest(@Nullable Ingest value) {
            this.ingest = value;
            return this;
        }

        @Nonnull
        public final Builder ingest(Function<Ingest.Builder, ObjectBuilder<Ingest>> fn) {
            return this.ingest(fn.apply(new Ingest.Builder()).build());
        }

        @Nonnull
        public final Builder ip(List<String> list) {
            this.ip = Builder._listAddAll(this.ip, list);
            return this;
        }

        @Nonnull
        public final Builder ip(String value, String ... values) {
            this.ip = Builder._listAdd(this.ip, value, values);
            return this;
        }

        @Nonnull
        public final Builder jvm(@Nullable Jvm value) {
            this.jvm = value;
            return this;
        }

        @Nonnull
        public final Builder jvm(Function<Jvm.Builder, ObjectBuilder<Jvm>> fn) {
            return this.jvm(fn.apply(new Jvm.Builder()).build());
        }

        @Nonnull
        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder os(@Nullable OperatingSystem value) {
            this.os = value;
            return this;
        }

        @Nonnull
        public final Builder os(Function<OperatingSystem.Builder, ObjectBuilder<OperatingSystem>> fn) {
            return this.os(fn.apply(new OperatingSystem.Builder()).build());
        }

        @Nonnull
        public final Builder process(@Nullable Process value) {
            this.process = value;
            return this;
        }

        @Nonnull
        public final Builder process(Function<Process.Builder, ObjectBuilder<Process>> fn) {
            return this.process(fn.apply(new Process.Builder()).build());
        }

        @Nonnull
        public final Builder remoteStore(@Nullable RemoteStoreStats value) {
            this.remoteStore = value;
            return this;
        }

        @Nonnull
        public final Builder remoteStore(Function<RemoteStoreStats.Builder, ObjectBuilder<RemoteStoreStats>> fn) {
            return this.remoteStore(fn.apply(new RemoteStoreStats.Builder()).build());
        }

        @Nonnull
        public final Builder repositories(List<JsonData> list) {
            this.repositories = Builder._listAddAll(this.repositories, list);
            return this;
        }

        @Nonnull
        public final Builder repositories(JsonData value, JsonData ... values) {
            this.repositories = Builder._listAdd(this.repositories, value, values);
            return this;
        }

        @Nonnull
        public final Builder resourceUsageStats(Map<String, ShardResourceUsageStatsDetail> map) {
            this.resourceUsageStats = Builder._mapPutAll(this.resourceUsageStats, map);
            return this;
        }

        @Nonnull
        public final Builder resourceUsageStats(String key, ShardResourceUsageStatsDetail value) {
            this.resourceUsageStats = Builder._mapPut(this.resourceUsageStats, key, value);
            return this;
        }

        @Nonnull
        public final Builder resourceUsageStats(String key, Function<ShardResourceUsageStatsDetail.Builder, ObjectBuilder<ShardResourceUsageStatsDetail>> fn) {
            return this.resourceUsageStats(key, fn.apply(new ShardResourceUsageStatsDetail.Builder()).build());
        }

        @Nonnull
        public final Builder roles(List<NodeRole> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        @Nonnull
        public final Builder roles(NodeRole value, NodeRole ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        @Nonnull
        public final Builder script(@Nullable ScriptStats value) {
            this.script = value;
            return this;
        }

        @Nonnull
        public final Builder script(Function<ScriptStats.Builder, ObjectBuilder<ScriptStats>> fn) {
            return this.script(fn.apply(new ScriptStats.Builder()).build());
        }

        @Nonnull
        public final Builder scriptCache(@Nullable ScriptCacheStats value) {
            this.scriptCache = value;
            return this;
        }

        @Nonnull
        public final Builder scriptCache(Function<ScriptCacheStats.Builder, ObjectBuilder<ScriptCacheStats>> fn) {
            return this.scriptCache(fn.apply(new ScriptCacheStats.Builder()).build());
        }

        @Nonnull
        public final Builder searchBackpressure(@Nullable ShardSearchBackpressureStats value) {
            this.searchBackpressure = value;
            return this;
        }

        @Nonnull
        public final Builder searchBackpressure(Function<ShardSearchBackpressureStats.Builder, ObjectBuilder<ShardSearchBackpressureStats>> fn) {
            return this.searchBackpressure(fn.apply(new ShardSearchBackpressureStats.Builder()).build());
        }

        @Nonnull
        public final Builder searchPipeline(@Nullable ShardSearchPipelineStats value) {
            this.searchPipeline = value;
            return this;
        }

        @Nonnull
        public final Builder searchPipeline(Function<ShardSearchPipelineStats.Builder, ObjectBuilder<ShardSearchPipelineStats>> fn) {
            return this.searchPipeline(fn.apply(new ShardSearchPipelineStats.Builder()).build());
        }

        @Nonnull
        public final Builder segmentReplicationBackpressure(@Nullable ShardSegmentReplicationBackpressureStats value) {
            this.segmentReplicationBackpressure = value;
            return this;
        }

        @Nonnull
        public final Builder segmentReplicationBackpressure(Function<ShardSegmentReplicationBackpressureStats.Builder, ObjectBuilder<ShardSegmentReplicationBackpressureStats>> fn) {
            return this.segmentReplicationBackpressure(fn.apply(new ShardSegmentReplicationBackpressureStats.Builder()).build());
        }

        @Nonnull
        public final Builder shardIndexingPressure(@Nullable ShardIndexingPressureStats value) {
            this.shardIndexingPressure = value;
            return this;
        }

        @Nonnull
        public final Builder shardIndexingPressure(Function<ShardIndexingPressureStats.Builder, ObjectBuilder<ShardIndexingPressureStats>> fn) {
            return this.shardIndexingPressure(fn.apply(new ShardIndexingPressureStats.Builder()).build());
        }

        @Nonnull
        public final Builder taskCancellation(@Nullable ShardTaskCancellationStats value) {
            this.taskCancellation = value;
            return this;
        }

        @Nonnull
        public final Builder taskCancellation(Function<ShardTaskCancellationStats.Builder, ObjectBuilder<ShardTaskCancellationStats>> fn) {
            return this.taskCancellation(fn.apply(new ShardTaskCancellationStats.Builder()).build());
        }

        @Nonnull
        public final Builder threadPool(Map<String, ThreadCount> map) {
            this.threadPool = Builder._mapPutAll(this.threadPool, map);
            return this;
        }

        @Nonnull
        public final Builder threadPool(String key, ThreadCount value) {
            this.threadPool = Builder._mapPut(this.threadPool, key, value);
            return this;
        }

        @Nonnull
        public final Builder threadPool(String key, Function<ThreadCount.Builder, ObjectBuilder<ThreadCount>> fn) {
            return this.threadPool(key, fn.apply(new ThreadCount.Builder()).build());
        }

        @Nonnull
        public final Builder timestamp(@Nullable Long value) {
            this.timestamp = value;
            return this;
        }

        @Nonnull
        public final Builder transport(@Nullable Transport value) {
            this.transport = value;
            return this;
        }

        @Nonnull
        public final Builder transport(Function<Transport.Builder, ObjectBuilder<Transport>> fn) {
            return this.transport(fn.apply(new Transport.Builder()).build());
        }

        @Nonnull
        public final Builder transportAddress(@Nullable String value) {
            this.transportAddress = value;
            return this;
        }

        @Nonnull
        public final Builder weightedRouting(@Nullable ShardWeightedRoutingStats value) {
            this.weightedRouting = value;
            return this;
        }

        @Nonnull
        public final Builder weightedRouting(Function<ShardWeightedRoutingStats.Builder, ObjectBuilder<ShardWeightedRoutingStats>> fn) {
            return this.weightedRouting(fn.apply(new ShardWeightedRoutingStats.Builder()).build());
        }

        @Override
        @Nonnull
        public Stats build() {
            this._checkSingleUse();
            return new Stats(this);
        }
    }
}

