/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.util.TextRange;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.util.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WordSplitter
extends BaseSplitter {
    private static final WordSplitter INSTANCE = new WordSplitter();
    @NonNls
    private static final Pattern SPECIAL = Pattern.compile("&\\p{Alnum}{2};?|#\\p{Alnum}{3,6}|0x\\p{Alnum}?");

    public static WordSplitter getInstance() {
        return INSTANCE;
    }

    @Override
    public void split(@Nullable String text, @NotNull TextRange range, @NotNull Consumer<TextRange> consumer) {
        if (range == null) {
            WordSplitter.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            WordSplitter.$$$reportNull$$$0(1);
        }
        if (text == null || range.getLength() <= 1) {
            return;
        }
        try {
            Matcher specialMatcher = SPECIAL.matcher(WordSplitter.newBombedCharSequence(text));
            specialMatcher.region(range.getStartOffset(), range.getEndOffset());
            if (specialMatcher.find()) {
                TextRange found = new TextRange(specialMatcher.start(), specialMatcher.end());
                WordSplitter.addWord(consumer, true, found);
            } else {
                IdentifierSplitter.getInstance().split(text, range, consumer);
            }
        }
        catch (BaseSplitter.TooLongBombedMatchingException tooLongBombedMatchingException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "range";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/spellchecker/inspections/WordSplitter";
        objectArray[2] = "split";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

