/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.internal.state.Measurement;

public final class MutableMeasurement
implements Measurement {
    private long startEpochNanos;
    private long epochNanos;
    private boolean hasLongValue;
    private long longValue;
    private boolean hasDoubleValue;
    private double doubleValue;
    private Attributes attributes = Attributes.empty();

    static void setDoubleMeasurement(MutableMeasurement mutableMeasurement, long startEpochNanos, long epochNanos, double value, Attributes attributes) {
        mutableMeasurement.set(startEpochNanos, epochNanos, false, 0L, true, value, attributes);
    }

    static void setLongMeasurement(MutableMeasurement mutableMeasurement, long startEpochNanos, long epochNanos, long value, Attributes attributes) {
        mutableMeasurement.set(startEpochNanos, epochNanos, true, value, false, 0.0, attributes);
    }

    private void set(long startEpochNanos, long epochNanos, boolean hasLongValue, long longValue, boolean hasDoubleValue, double doubleValue, Attributes attributes) {
        this.startEpochNanos = startEpochNanos;
        this.epochNanos = epochNanos;
        this.hasLongValue = hasLongValue;
        this.longValue = longValue;
        this.hasDoubleValue = hasDoubleValue;
        this.doubleValue = doubleValue;
        this.attributes = attributes;
    }

    @Override
    public Measurement withStartEpochNanos(long startEpochNanos) {
        this.startEpochNanos = startEpochNanos;
        return this;
    }

    @Override
    public Measurement withAttributes(Attributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @Override
    public long startEpochNanos() {
        return this.startEpochNanos;
    }

    @Override
    public long epochNanos() {
        return this.epochNanos;
    }

    @Override
    public boolean hasLongValue() {
        return this.hasLongValue;
    }

    @Override
    public long longValue() {
        return this.longValue;
    }

    @Override
    public boolean hasDoubleValue() {
        return this.hasDoubleValue;
    }

    @Override
    public double doubleValue() {
        return this.doubleValue;
    }

    @Override
    public Attributes attributes() {
        return this.attributes;
    }
}

