/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.autocomplete.AbstractAutoCompleteAdaptor;
import org.jdesktop.swingx.autocomplete.AutoCompleteComboBoxEditor;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.AutoCompleteDocument;
import org.jdesktop.swingx.autocomplete.ComboBoxAdaptor;

final class AutoComplete {
    private AutoComplete() {
    }

    static class SelectionAction
    implements Action {
        private Action delegate;

        public SelectionAction(Action delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e2) {
            JComboBox comboBox = (JComboBox)e2.getSource();
            JTextComponent textComponent = (JTextComponent)comboBox.getEditor().getEditorComponent();
            AutoCompleteDocument doc = (AutoCompleteDocument)textComponent.getDocument();
            doc.strictMatching = true;
            try {
                this.delegate.actionPerformed(e2);
            }
            finally {
                doc.strictMatching = false;
            }
        }

        @Override
        public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
            this.delegate.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
            this.delegate.removePropertyChangeListener(listener);
        }

        @Override
        public Object getValue(String key) {
            return this.delegate.getValue(key);
        }

        @Override
        public void putValue(String key, Object value) {
            this.delegate.putValue(key, value);
        }

        @Override
        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }

        @Override
        public void setEnabled(boolean b) {
            this.delegate.setEnabled(b);
        }
    }

    static class PropertyChangeListener
    implements java.beans.PropertyChangeListener {
        private JComboBox comboBox;

        public PropertyChangeListener(JComboBox comboBox) {
            this.comboBox = comboBox;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("editor".equals(evt.getPropertyName())) {
                this.handleEditor(evt);
            } else if ("enabled".equals(evt.getPropertyName())) {
                this.handleEnabled(evt);
            }
        }

        private void handleEnabled(PropertyChangeEvent evt) {
            if (Boolean.TRUE.equals(evt.getNewValue())) {
                this.comboBox.setEditable(true);
            } else {
                JTextComponent textComponent = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
                boolean strictMatching = ((AutoCompleteDocument)textComponent.getDocument()).strictMatching;
                this.comboBox.setEditable(!strictMatching);
            }
        }

        private void handleEditor(PropertyChangeEvent evt) {
            if (evt.getNewValue() instanceof AutoCompleteComboBoxEditor) {
                return;
            }
            AutoCompleteComboBoxEditor acEditor = (AutoCompleteComboBoxEditor)evt.getOldValue();
            boolean strictMatching = false;
            if (acEditor.getEditorComponent() != null) {
                JTextComponent textComponent = (JTextComponent)acEditor.getEditorComponent();
                strictMatching = ((AutoCompleteDocument)textComponent.getDocument()).strictMatching;
                AutoCompleteDecorator.undecorate(textComponent);
                for (KeyListener l : textComponent.getKeyListeners()) {
                    if (!(l instanceof KeyAdapter)) continue;
                    textComponent.removeKeyListener(l);
                    break;
                }
            }
            JTextComponent editorComponent = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
            ComboBoxAdaptor adaptor = new ComboBoxAdaptor(this.comboBox);
            AutoCompleteDocument document2 = AutoCompleteDecorator.createAutoCompleteDocument(adaptor, strictMatching, acEditor.stringConverter, editorComponent.getDocument());
            AutoCompleteDecorator.decorate(editorComponent, document2, adaptor);
            editorComponent.addKeyListener(new KeyAdapter(this.comboBox));
            this.comboBox.setEditor(new AutoCompleteComboBoxEditor(this.comboBox.getEditor(), document2.stringConverter));
        }
    }

    static class KeyAdapter
    extends java.awt.event.KeyAdapter {
        private JComboBox comboBox;

        public KeyAdapter(JComboBox comboBox) {
            this.comboBox = comboBox;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isActionKey()) {
                return;
            }
            if (this.comboBox.isDisplayable() && !this.comboBox.isPopupVisible()) {
                int keyCode = keyEvent.getKeyCode();
                if (keyCode == 16 || keyCode == 17 || keyCode == 18) {
                    return;
                }
                if (keyCode == 10 || keyCode == 27) {
                    return;
                }
                this.comboBox.setPopupVisible(true);
            }
        }
    }

    static class FocusAdapter
    extends java.awt.event.FocusAdapter {
        private AbstractAutoCompleteAdaptor adaptor;

        public FocusAdapter(AbstractAutoCompleteAdaptor adaptor) {
            this.adaptor = adaptor;
        }

        @Override
        public void focusGained(FocusEvent e2) {
            this.adaptor.markEntireText();
        }
    }

    static class InputMap
    extends javax.swing.InputMap {
        private static final long serialVersionUID = 1L;

        InputMap() {
        }
    }
}

