/*
 * Decompiled with CFR 0.152.
 */
package liqp.filters.date;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import liqp.filters.date.CustomDateFormatSupport;

public class CustomDateFormatRegistry {
    private static final List<CustomDateFormatSupport> supportedTypes = new ArrayList<CustomDateFormatSupport>();

    public static void add(CustomDateFormatSupport supportThis) {
        supportedTypes.add(0, supportThis);
    }

    public static boolean isRegistered(CustomDateFormatSupport<?> typeSupport) {
        return supportedTypes.contains(typeSupport);
    }

    public static boolean isCustomDateType(Object value) {
        for (CustomDateFormatSupport el : supportedTypes) {
            if (!el.support(value)) continue;
            return true;
        }
        return false;
    }

    public static ZonedDateTime getFromCustomType(Object value) {
        for (CustomDateFormatSupport el : supportedTypes) {
            if (!el.support(value)) continue;
            return el.getValue(value);
        }
        throw new UnsupportedOperationException();
    }
}

