/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.mcf;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.decorators.Decorators;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.Connection;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.executors.CommandExecutor;
import redis.clients.jedis.mcf.ConnectionFailoverException;
import redis.clients.jedis.mcf.MultiDbConnectionProvider;
import redis.clients.jedis.mcf.MultiDbFailoverBase;

@Experimental
public class MultiDbCommandExecutor
extends MultiDbFailoverBase
implements CommandExecutor {
    public MultiDbCommandExecutor(MultiDbConnectionProvider provider) {
        super(provider);
    }

    @Override
    public <T> T executeCommand(CommandObject<T> commandObject) {
        MultiDbConnectionProvider.Database database = this.provider.getDatabase();
        Decorators.DecorateSupplier supplier = Decorators.ofSupplier(() -> this.handleExecuteCommand(commandObject, database));
        supplier.withCircuitBreaker(database.getCircuitBreaker());
        supplier.withRetry(database.getRetry());
        supplier.withFallback(this.provider.getFallbackExceptionList(), e -> this.handleDatabaseFailover(commandObject, database));
        try {
            return supplier.decorate().get();
        }
        catch (Exception e2) {
            if (database.getCircuitBreaker().getState() == CircuitBreaker.State.OPEN && this.isActiveDatabase(database)) {
                this.databaseFailover(database);
            }
            throw e2;
        }
    }

    private <T> T handleExecuteCommand(CommandObject<T> commandObject, MultiDbConnectionProvider.Database database) {
        Connection connection;
        try {
            connection = database.getConnection();
        }
        catch (JedisConnectionException e) {
            this.provider.assertOperability();
            throw e;
        }
        try {
            T e = connection.executeCommand(commandObject);
            return e;
        }
        catch (Exception e) {
            if (database.retryOnFailover() && !this.isActiveDatabase(database) && MultiDbCommandExecutor.isCircuitBreakerTrackedException(e, database)) {
                throw new ConnectionFailoverException("Command failed during failover: " + database.getCircuitBreaker().getName(), e);
            }
            throw e;
        }
        finally {
            connection.close();
        }
    }

    private <T> T handleDatabaseFailover(CommandObject<T> commandObject, MultiDbConnectionProvider.Database database) {
        this.databaseFailover(database);
        return this.executeCommand(commandObject);
    }
}

