# _build_config.py.in is converted into _build_config.py during the meson build process.

from __future__ import annotations


def build_config() -> dict[str, str]:
    """
    Return a dictionary containing build configuration settings.

    All dictionary keys and values are strings, for example ``False`` is
    returned as ``"False"``.

        .. versionadded:: 1.1.0
    """
    return dict(
        # Python settings
        python_version="3.13",
        python_install_dir=r"/usr/local/lib/python3.13/site-packages/",
        python_path=r"/usr/local/bin/python3.13",

        # Package versions
        contourpy_version="1.2.1",
        meson_version="1.10.1",
        mesonpy_version="0.19.0",
        pybind11_version="3.0.1",

        # Misc meson settings
        meson_backend="ninja",
        build_dir=r"/pobj/py-contourpy-1.2.1/contourpy-1.2.1/.mesonpy-fu_ca359/lib/contourpy/util",
        source_dir=r"/pobj/py-contourpy-1.2.1/contourpy-1.2.1/lib/contourpy/util",
        cross_build="False",

        # Build options
        build_options=r"-Dbuildtype=release -Db_ndebug=if-release -Db_vscrt=md -Dvsenv=True --native-file=/pobj/py-contourpy-1.2.1/contourpy-1.2.1/.mesonpy-fu_ca359/meson-python-native-file.ini",
        buildtype="release",
        cpp_std="c++17",
        debug="False",
        optimization="3",
        vsenv="True",
        b_ndebug="if-release",
        b_vscrt="from_buildtype",

        # C++ compiler
        compiler_name="clang",
        compiler_version="19.1.7",
        linker_id="ld.bfd",
        compile_command="c++",

        # Host machine
        host_cpu="mips64",
        host_cpu_family="mips64",
        host_cpu_endian="big",
        host_cpu_system="openbsd",

        # Build machine, same as host machine if not a cross_build
        build_cpu="mips64",
        build_cpu_family="mips64",
        build_cpu_endian="big",
        build_cpu_system="openbsd",
    )
