/* ========================================================================
 * Copyright (c) 2005-2021 The OPC Foundation, Inc. All rights reserved.
 *
 * OPC Foundation MIT License 1.00
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * The complete license agreement can be found here:
 * http://opcfoundation.org/License/MIT/1.00/
 * ======================================================================*/

using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;
using System.Xml;
using System.Runtime.Serialization;

namespace Opc.Ua
{
    #region DataType Identifiers
    /// <summary>
    /// A class that declares constants for all DataTypes in the Model Design.
    /// </summary>
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class DataTypes
    {
        /// <summary>
        /// The identifier for the BaseDataType DataType.
        /// </summary>
        public const uint BaseDataType = 24;

        /// <summary>
        /// The identifier for the Number DataType.
        /// </summary>
        public const uint Number = 26;

        /// <summary>
        /// The identifier for the Integer DataType.
        /// </summary>
        public const uint Integer = 27;

        /// <summary>
        /// The identifier for the UInteger DataType.
        /// </summary>
        public const uint UInteger = 28;

        /// <summary>
        /// The identifier for the Enumeration DataType.
        /// </summary>
        public const uint Enumeration = 29;

        /// <summary>
        /// The identifier for the Boolean DataType.
        /// </summary>
        public const uint Boolean = 1;

        /// <summary>
        /// The identifier for the SByte DataType.
        /// </summary>
        public const uint SByte = 2;

        /// <summary>
        /// The identifier for the Byte DataType.
        /// </summary>
        public const uint Byte = 3;

        /// <summary>
        /// The identifier for the Int16 DataType.
        /// </summary>
        public const uint Int16 = 4;

        /// <summary>
        /// The identifier for the UInt16 DataType.
        /// </summary>
        public const uint UInt16 = 5;

        /// <summary>
        /// The identifier for the Int32 DataType.
        /// </summary>
        public const uint Int32 = 6;

        /// <summary>
        /// The identifier for the UInt32 DataType.
        /// </summary>
        public const uint UInt32 = 7;

        /// <summary>
        /// The identifier for the Int64 DataType.
        /// </summary>
        public const uint Int64 = 8;

        /// <summary>
        /// The identifier for the UInt64 DataType.
        /// </summary>
        public const uint UInt64 = 9;

        /// <summary>
        /// The identifier for the Float DataType.
        /// </summary>
        public const uint Float = 10;

        /// <summary>
        /// The identifier for the Double DataType.
        /// </summary>
        public const uint Double = 11;

        /// <summary>
        /// The identifier for the String DataType.
        /// </summary>
        public const uint String = 12;

        /// <summary>
        /// The identifier for the DateTime DataType.
        /// </summary>
        public const uint DateTime = 13;

        /// <summary>
        /// The identifier for the Guid DataType.
        /// </summary>
        public const uint Guid = 14;

        /// <summary>
        /// The identifier for the ByteString DataType.
        /// </summary>
        public const uint ByteString = 15;

        /// <summary>
        /// The identifier for the XmlElement DataType.
        /// </summary>
        public const uint XmlElement = 16;

        /// <summary>
        /// The identifier for the NodeId DataType.
        /// </summary>
        public const uint NodeId = 17;

        /// <summary>
        /// The identifier for the ExpandedNodeId DataType.
        /// </summary>
        public const uint ExpandedNodeId = 18;

        /// <summary>
        /// The identifier for the StatusCode DataType.
        /// </summary>
        public const uint StatusCode = 19;

        /// <summary>
        /// The identifier for the QualifiedName DataType.
        /// </summary>
        public const uint QualifiedName = 20;

        /// <summary>
        /// The identifier for the LocalizedText DataType.
        /// </summary>
        public const uint LocalizedText = 21;

        /// <summary>
        /// The identifier for the Structure DataType.
        /// </summary>
        public const uint Structure = 22;

        /// <summary>
        /// The identifier for the DataValue DataType.
        /// </summary>
        public const uint DataValue = 23;

        /// <summary>
        /// The identifier for the DiagnosticInfo DataType.
        /// </summary>
        public const uint DiagnosticInfo = 25;

        /// <summary>
        /// The identifier for the Image DataType.
        /// </summary>
        public const uint Image = 30;

        /// <summary>
        /// The identifier for the Decimal DataType.
        /// </summary>
        public const uint Decimal = 50;

        /// <summary>
        /// The identifier for the NamingRuleType DataType.
        /// </summary>
        public const uint NamingRuleType = 120;

        /// <summary>
        /// The identifier for the ImageBMP DataType.
        /// </summary>
        public const uint ImageBMP = 2000;

        /// <summary>
        /// The identifier for the ImageGIF DataType.
        /// </summary>
        public const uint ImageGIF = 2001;

        /// <summary>
        /// The identifier for the ImageJPG DataType.
        /// </summary>
        public const uint ImageJPG = 2002;

        /// <summary>
        /// The identifier for the ImagePNG DataType.
        /// </summary>
        public const uint ImagePNG = 2003;

        /// <summary>
        /// The identifier for the AudioDataType DataType.
        /// </summary>
        public const uint AudioDataType = 16307;

        /// <summary>
        /// The identifier for the Union DataType.
        /// </summary>
        public const uint Union = 12756;

        /// <summary>
        /// The identifier for the BitFieldMaskDataType DataType.
        /// </summary>
        public const uint BitFieldMaskDataType = 11737;

        /// <summary>
        /// The identifier for the KeyValuePair DataType.
        /// </summary>
        public const uint KeyValuePair = 14533;

        /// <summary>
        /// The identifier for the AdditionalParametersType DataType.
        /// </summary>
        public const uint AdditionalParametersType = 16313;

        /// <summary>
        /// The identifier for the EphemeralKeyType DataType.
        /// </summary>
        public const uint EphemeralKeyType = 17548;

        /// <summary>
        /// The identifier for the EndpointType DataType.
        /// </summary>
        public const uint EndpointType = 15528;

        /// <summary>
        /// The identifier for the RationalNumber DataType.
        /// </summary>
        public const uint RationalNumber = 18806;

        /// <summary>
        /// The identifier for the Vector DataType.
        /// </summary>
        public const uint Vector = 18807;

        /// <summary>
        /// The identifier for the ThreeDVector DataType.
        /// </summary>
        public const uint ThreeDVector = 18808;

        /// <summary>
        /// The identifier for the CartesianCoordinates DataType.
        /// </summary>
        public const uint CartesianCoordinates = 18809;

        /// <summary>
        /// The identifier for the ThreeDCartesianCoordinates DataType.
        /// </summary>
        public const uint ThreeDCartesianCoordinates = 18810;

        /// <summary>
        /// The identifier for the Orientation DataType.
        /// </summary>
        public const uint Orientation = 18811;

        /// <summary>
        /// The identifier for the ThreeDOrientation DataType.
        /// </summary>
        public const uint ThreeDOrientation = 18812;

        /// <summary>
        /// The identifier for the Frame DataType.
        /// </summary>
        public const uint Frame = 18813;

        /// <summary>
        /// The identifier for the ThreeDFrame DataType.
        /// </summary>
        public const uint ThreeDFrame = 18814;

        /// <summary>
        /// The identifier for the OpenFileMode DataType.
        /// </summary>
        public const uint OpenFileMode = 11939;

        /// <summary>
        /// The identifier for the IdentityCriteriaType DataType.
        /// </summary>
        public const uint IdentityCriteriaType = 15632;

        /// <summary>
        /// The identifier for the IdentityMappingRuleType DataType.
        /// </summary>
        public const uint IdentityMappingRuleType = 15634;

        /// <summary>
        /// The identifier for the CurrencyUnitType DataType.
        /// </summary>
        public const uint CurrencyUnitType = 23498;

        /// <summary>
        /// The identifier for the TrustListMasks DataType.
        /// </summary>
        public const uint TrustListMasks = 12552;

        /// <summary>
        /// The identifier for the TrustListDataType DataType.
        /// </summary>
        public const uint TrustListDataType = 12554;

        /// <summary>
        /// The identifier for the DecimalDataType DataType.
        /// </summary>
        public const uint DecimalDataType = 17861;

        /// <summary>
        /// The identifier for the DataTypeSchemaHeader DataType.
        /// </summary>
        public const uint DataTypeSchemaHeader = 15534;

        /// <summary>
        /// The identifier for the DataTypeDescription DataType.
        /// </summary>
        public const uint DataTypeDescription = 14525;

        /// <summary>
        /// The identifier for the StructureDescription DataType.
        /// </summary>
        public const uint StructureDescription = 15487;

        /// <summary>
        /// The identifier for the EnumDescription DataType.
        /// </summary>
        public const uint EnumDescription = 15488;

        /// <summary>
        /// The identifier for the SimpleTypeDescription DataType.
        /// </summary>
        public const uint SimpleTypeDescription = 15005;

        /// <summary>
        /// The identifier for the UABinaryFileDataType DataType.
        /// </summary>
        public const uint UABinaryFileDataType = 15006;

        /// <summary>
        /// The identifier for the PubSubState DataType.
        /// </summary>
        public const uint PubSubState = 14647;

        /// <summary>
        /// The identifier for the DataSetMetaDataType DataType.
        /// </summary>
        public const uint DataSetMetaDataType = 14523;

        /// <summary>
        /// The identifier for the FieldMetaData DataType.
        /// </summary>
        public const uint FieldMetaData = 14524;

        /// <summary>
        /// The identifier for the DataSetFieldFlags DataType.
        /// </summary>
        public const uint DataSetFieldFlags = 15904;

        /// <summary>
        /// The identifier for the ConfigurationVersionDataType DataType.
        /// </summary>
        public const uint ConfigurationVersionDataType = 14593;

        /// <summary>
        /// The identifier for the PublishedDataSetDataType DataType.
        /// </summary>
        public const uint PublishedDataSetDataType = 15578;

        /// <summary>
        /// The identifier for the PublishedDataSetSourceDataType DataType.
        /// </summary>
        public const uint PublishedDataSetSourceDataType = 15580;

        /// <summary>
        /// The identifier for the PublishedVariableDataType DataType.
        /// </summary>
        public const uint PublishedVariableDataType = 14273;

        /// <summary>
        /// The identifier for the PublishedDataItemsDataType DataType.
        /// </summary>
        public const uint PublishedDataItemsDataType = 15581;

        /// <summary>
        /// The identifier for the PublishedEventsDataType DataType.
        /// </summary>
        public const uint PublishedEventsDataType = 15582;

        /// <summary>
        /// The identifier for the DataSetFieldContentMask DataType.
        /// </summary>
        public const uint DataSetFieldContentMask = 15583;

        /// <summary>
        /// The identifier for the DataSetWriterDataType DataType.
        /// </summary>
        public const uint DataSetWriterDataType = 15597;

        /// <summary>
        /// The identifier for the DataSetWriterTransportDataType DataType.
        /// </summary>
        public const uint DataSetWriterTransportDataType = 15598;

        /// <summary>
        /// The identifier for the DataSetWriterMessageDataType DataType.
        /// </summary>
        public const uint DataSetWriterMessageDataType = 15605;

        /// <summary>
        /// The identifier for the PubSubGroupDataType DataType.
        /// </summary>
        public const uint PubSubGroupDataType = 15609;

        /// <summary>
        /// The identifier for the WriterGroupDataType DataType.
        /// </summary>
        public const uint WriterGroupDataType = 15480;

        /// <summary>
        /// The identifier for the WriterGroupTransportDataType DataType.
        /// </summary>
        public const uint WriterGroupTransportDataType = 15611;

        /// <summary>
        /// The identifier for the WriterGroupMessageDataType DataType.
        /// </summary>
        public const uint WriterGroupMessageDataType = 15616;

        /// <summary>
        /// The identifier for the PubSubConnectionDataType DataType.
        /// </summary>
        public const uint PubSubConnectionDataType = 15617;

        /// <summary>
        /// The identifier for the ConnectionTransportDataType DataType.
        /// </summary>
        public const uint ConnectionTransportDataType = 15618;

        /// <summary>
        /// The identifier for the NetworkAddressDataType DataType.
        /// </summary>
        public const uint NetworkAddressDataType = 15502;

        /// <summary>
        /// The identifier for the NetworkAddressUrlDataType DataType.
        /// </summary>
        public const uint NetworkAddressUrlDataType = 15510;

        /// <summary>
        /// The identifier for the ReaderGroupDataType DataType.
        /// </summary>
        public const uint ReaderGroupDataType = 15520;

        /// <summary>
        /// The identifier for the ReaderGroupTransportDataType DataType.
        /// </summary>
        public const uint ReaderGroupTransportDataType = 15621;

        /// <summary>
        /// The identifier for the ReaderGroupMessageDataType DataType.
        /// </summary>
        public const uint ReaderGroupMessageDataType = 15622;

        /// <summary>
        /// The identifier for the DataSetReaderDataType DataType.
        /// </summary>
        public const uint DataSetReaderDataType = 15623;

        /// <summary>
        /// The identifier for the DataSetReaderTransportDataType DataType.
        /// </summary>
        public const uint DataSetReaderTransportDataType = 15628;

        /// <summary>
        /// The identifier for the DataSetReaderMessageDataType DataType.
        /// </summary>
        public const uint DataSetReaderMessageDataType = 15629;

        /// <summary>
        /// The identifier for the SubscribedDataSetDataType DataType.
        /// </summary>
        public const uint SubscribedDataSetDataType = 15630;

        /// <summary>
        /// The identifier for the TargetVariablesDataType DataType.
        /// </summary>
        public const uint TargetVariablesDataType = 15631;

        /// <summary>
        /// The identifier for the FieldTargetDataType DataType.
        /// </summary>
        public const uint FieldTargetDataType = 14744;

        /// <summary>
        /// The identifier for the OverrideValueHandling DataType.
        /// </summary>
        public const uint OverrideValueHandling = 15874;

        /// <summary>
        /// The identifier for the SubscribedDataSetMirrorDataType DataType.
        /// </summary>
        public const uint SubscribedDataSetMirrorDataType = 15635;

        /// <summary>
        /// The identifier for the PubSubConfigurationDataType DataType.
        /// </summary>
        public const uint PubSubConfigurationDataType = 15530;

        /// <summary>
        /// The identifier for the DataSetOrderingType DataType.
        /// </summary>
        public const uint DataSetOrderingType = 20408;

        /// <summary>
        /// The identifier for the UadpNetworkMessageContentMask DataType.
        /// </summary>
        public const uint UadpNetworkMessageContentMask = 15642;

        /// <summary>
        /// The identifier for the UadpWriterGroupMessageDataType DataType.
        /// </summary>
        public const uint UadpWriterGroupMessageDataType = 15645;

        /// <summary>
        /// The identifier for the UadpDataSetMessageContentMask DataType.
        /// </summary>
        public const uint UadpDataSetMessageContentMask = 15646;

        /// <summary>
        /// The identifier for the UadpDataSetWriterMessageDataType DataType.
        /// </summary>
        public const uint UadpDataSetWriterMessageDataType = 15652;

        /// <summary>
        /// The identifier for the UadpDataSetReaderMessageDataType DataType.
        /// </summary>
        public const uint UadpDataSetReaderMessageDataType = 15653;

        /// <summary>
        /// The identifier for the JsonNetworkMessageContentMask DataType.
        /// </summary>
        public const uint JsonNetworkMessageContentMask = 15654;

        /// <summary>
        /// The identifier for the JsonWriterGroupMessageDataType DataType.
        /// </summary>
        public const uint JsonWriterGroupMessageDataType = 15657;

        /// <summary>
        /// The identifier for the JsonDataSetMessageContentMask DataType.
        /// </summary>
        public const uint JsonDataSetMessageContentMask = 15658;

        /// <summary>
        /// The identifier for the JsonDataSetWriterMessageDataType DataType.
        /// </summary>
        public const uint JsonDataSetWriterMessageDataType = 15664;

        /// <summary>
        /// The identifier for the JsonDataSetReaderMessageDataType DataType.
        /// </summary>
        public const uint JsonDataSetReaderMessageDataType = 15665;

        /// <summary>
        /// The identifier for the DatagramConnectionTransportDataType DataType.
        /// </summary>
        public const uint DatagramConnectionTransportDataType = 17467;

        /// <summary>
        /// The identifier for the DatagramWriterGroupTransportDataType DataType.
        /// </summary>
        public const uint DatagramWriterGroupTransportDataType = 15532;

        /// <summary>
        /// The identifier for the BrokerConnectionTransportDataType DataType.
        /// </summary>
        public const uint BrokerConnectionTransportDataType = 15007;

        /// <summary>
        /// The identifier for the BrokerTransportQualityOfService DataType.
        /// </summary>
        public const uint BrokerTransportQualityOfService = 15008;

        /// <summary>
        /// The identifier for the BrokerWriterGroupTransportDataType DataType.
        /// </summary>
        public const uint BrokerWriterGroupTransportDataType = 15667;

        /// <summary>
        /// The identifier for the BrokerDataSetWriterTransportDataType DataType.
        /// </summary>
        public const uint BrokerDataSetWriterTransportDataType = 15669;

        /// <summary>
        /// The identifier for the BrokerDataSetReaderTransportDataType DataType.
        /// </summary>
        public const uint BrokerDataSetReaderTransportDataType = 15670;

        /// <summary>
        /// The identifier for the DiagnosticsLevel DataType.
        /// </summary>
        public const uint DiagnosticsLevel = 19723;

        /// <summary>
        /// The identifier for the PubSubDiagnosticsCounterClassification DataType.
        /// </summary>
        public const uint PubSubDiagnosticsCounterClassification = 19730;

        /// <summary>
        /// The identifier for the AliasNameDataType DataType.
        /// </summary>
        public const uint AliasNameDataType = 23468;

        /// <summary>
        /// The identifier for the Duplex DataType.
        /// </summary>
        public const uint Duplex = 24210;

        /// <summary>
        /// The identifier for the InterfaceAdminStatus DataType.
        /// </summary>
        public const uint InterfaceAdminStatus = 24212;

        /// <summary>
        /// The identifier for the InterfaceOperStatus DataType.
        /// </summary>
        public const uint InterfaceOperStatus = 24214;

        /// <summary>
        /// The identifier for the NegotiationStatus DataType.
        /// </summary>
        public const uint NegotiationStatus = 24216;

        /// <summary>
        /// The identifier for the TsnFailureCode DataType.
        /// </summary>
        public const uint TsnFailureCode = 24218;

        /// <summary>
        /// The identifier for the TsnStreamState DataType.
        /// </summary>
        public const uint TsnStreamState = 24220;

        /// <summary>
        /// The identifier for the TsnTalkerStatus DataType.
        /// </summary>
        public const uint TsnTalkerStatus = 24222;

        /// <summary>
        /// The identifier for the TsnListenerStatus DataType.
        /// </summary>
        public const uint TsnListenerStatus = 24224;

        /// <summary>
        /// The identifier for the UnsignedRationalNumber DataType.
        /// </summary>
        public const uint UnsignedRationalNumber = 24107;

        /// <summary>
        /// The identifier for the IdType DataType.
        /// </summary>
        public const uint IdType = 256;

        /// <summary>
        /// The identifier for the NodeClass DataType.
        /// </summary>
        public const uint NodeClass = 257;

        /// <summary>
        /// The identifier for the PermissionType DataType.
        /// </summary>
        public const uint PermissionType = 94;

        /// <summary>
        /// The identifier for the AccessLevelType DataType.
        /// </summary>
        public const uint AccessLevelType = 15031;

        /// <summary>
        /// The identifier for the AccessLevelExType DataType.
        /// </summary>
        public const uint AccessLevelExType = 15406;

        /// <summary>
        /// The identifier for the EventNotifierType DataType.
        /// </summary>
        public const uint EventNotifierType = 15033;

        /// <summary>
        /// The identifier for the AccessRestrictionType DataType.
        /// </summary>
        public const uint AccessRestrictionType = 95;

        /// <summary>
        /// The identifier for the RolePermissionType DataType.
        /// </summary>
        public const uint RolePermissionType = 96;

        /// <summary>
        /// The identifier for the DataTypeDefinition DataType.
        /// </summary>
        public const uint DataTypeDefinition = 97;

        /// <summary>
        /// The identifier for the StructureType DataType.
        /// </summary>
        public const uint StructureType = 98;

        /// <summary>
        /// The identifier for the StructureField DataType.
        /// </summary>
        public const uint StructureField = 101;

        /// <summary>
        /// The identifier for the StructureDefinition DataType.
        /// </summary>
        public const uint StructureDefinition = 99;

        /// <summary>
        /// The identifier for the EnumDefinition DataType.
        /// </summary>
        public const uint EnumDefinition = 100;

        /// <summary>
        /// The identifier for the Node DataType.
        /// </summary>
        public const uint Node = 258;

        /// <summary>
        /// The identifier for the InstanceNode DataType.
        /// </summary>
        public const uint InstanceNode = 11879;

        /// <summary>
        /// The identifier for the TypeNode DataType.
        /// </summary>
        public const uint TypeNode = 11880;

        /// <summary>
        /// The identifier for the ObjectNode DataType.
        /// </summary>
        public const uint ObjectNode = 261;

        /// <summary>
        /// The identifier for the ObjectTypeNode DataType.
        /// </summary>
        public const uint ObjectTypeNode = 264;

        /// <summary>
        /// The identifier for the VariableNode DataType.
        /// </summary>
        public const uint VariableNode = 267;

        /// <summary>
        /// The identifier for the VariableTypeNode DataType.
        /// </summary>
        public const uint VariableTypeNode = 270;

        /// <summary>
        /// The identifier for the ReferenceTypeNode DataType.
        /// </summary>
        public const uint ReferenceTypeNode = 273;

        /// <summary>
        /// The identifier for the MethodNode DataType.
        /// </summary>
        public const uint MethodNode = 276;

        /// <summary>
        /// The identifier for the ViewNode DataType.
        /// </summary>
        public const uint ViewNode = 279;

        /// <summary>
        /// The identifier for the DataTypeNode DataType.
        /// </summary>
        public const uint DataTypeNode = 282;

        /// <summary>
        /// The identifier for the ReferenceNode DataType.
        /// </summary>
        public const uint ReferenceNode = 285;

        /// <summary>
        /// The identifier for the Argument DataType.
        /// </summary>
        public const uint Argument = 296;

        /// <summary>
        /// The identifier for the EnumValueType DataType.
        /// </summary>
        public const uint EnumValueType = 7594;

        /// <summary>
        /// The identifier for the EnumField DataType.
        /// </summary>
        public const uint EnumField = 102;

        /// <summary>
        /// The identifier for the OptionSet DataType.
        /// </summary>
        public const uint OptionSet = 12755;

        /// <summary>
        /// The identifier for the NormalizedString DataType.
        /// </summary>
        public const uint NormalizedString = 12877;

        /// <summary>
        /// The identifier for the DecimalString DataType.
        /// </summary>
        public const uint DecimalString = 12878;

        /// <summary>
        /// The identifier for the DurationString DataType.
        /// </summary>
        public const uint DurationString = 12879;

        /// <summary>
        /// The identifier for the TimeString DataType.
        /// </summary>
        public const uint TimeString = 12880;

        /// <summary>
        /// The identifier for the DateString DataType.
        /// </summary>
        public const uint DateString = 12881;

        /// <summary>
        /// The identifier for the Duration DataType.
        /// </summary>
        public const uint Duration = 290;

        /// <summary>
        /// The identifier for the UtcTime DataType.
        /// </summary>
        public const uint UtcTime = 294;

        /// <summary>
        /// The identifier for the Time DataType.
        /// </summary>
        public const uint Time = 292;

        /// <summary>
        /// The identifier for the Date DataType.
        /// </summary>
        public const uint Date = 293;

        /// <summary>
        /// The identifier for the LocaleId DataType.
        /// </summary>
        public const uint LocaleId = 295;

        /// <summary>
        /// The identifier for the TimeZoneDataType DataType.
        /// </summary>
        public const uint TimeZoneDataType = 8912;

        /// <summary>
        /// The identifier for the Index DataType.
        /// </summary>
        public const uint Index = 17588;

        /// <summary>
        /// The identifier for the IntegerId DataType.
        /// </summary>
        public const uint IntegerId = 288;

        /// <summary>
        /// The identifier for the ApplicationType DataType.
        /// </summary>
        public const uint ApplicationType = 307;

        /// <summary>
        /// The identifier for the ApplicationDescription DataType.
        /// </summary>
        public const uint ApplicationDescription = 308;

        /// <summary>
        /// The identifier for the RequestHeader DataType.
        /// </summary>
        public const uint RequestHeader = 389;

        /// <summary>
        /// The identifier for the ResponseHeader DataType.
        /// </summary>
        public const uint ResponseHeader = 392;

        /// <summary>
        /// The identifier for the VersionTime DataType.
        /// </summary>
        public const uint VersionTime = 20998;

        /// <summary>
        /// The identifier for the ServiceFault DataType.
        /// </summary>
        public const uint ServiceFault = 395;

        /// <summary>
        /// The identifier for the SessionlessInvokeRequestType DataType.
        /// </summary>
        public const uint SessionlessInvokeRequestType = 15901;

        /// <summary>
        /// The identifier for the SessionlessInvokeResponseType DataType.
        /// </summary>
        public const uint SessionlessInvokeResponseType = 20999;

        /// <summary>
        /// The identifier for the FindServersRequest DataType.
        /// </summary>
        public const uint FindServersRequest = 420;

        /// <summary>
        /// The identifier for the FindServersResponse DataType.
        /// </summary>
        public const uint FindServersResponse = 423;

        /// <summary>
        /// The identifier for the ServerOnNetwork DataType.
        /// </summary>
        public const uint ServerOnNetwork = 12189;

        /// <summary>
        /// The identifier for the FindServersOnNetworkRequest DataType.
        /// </summary>
        public const uint FindServersOnNetworkRequest = 12190;

        /// <summary>
        /// The identifier for the FindServersOnNetworkResponse DataType.
        /// </summary>
        public const uint FindServersOnNetworkResponse = 12191;

        /// <summary>
        /// The identifier for the ApplicationInstanceCertificate DataType.
        /// </summary>
        public const uint ApplicationInstanceCertificate = 311;

        /// <summary>
        /// The identifier for the MessageSecurityMode DataType.
        /// </summary>
        public const uint MessageSecurityMode = 302;

        /// <summary>
        /// The identifier for the UserTokenType DataType.
        /// </summary>
        public const uint UserTokenType = 303;

        /// <summary>
        /// The identifier for the UserTokenPolicy DataType.
        /// </summary>
        public const uint UserTokenPolicy = 304;

        /// <summary>
        /// The identifier for the EndpointDescription DataType.
        /// </summary>
        public const uint EndpointDescription = 312;

        /// <summary>
        /// The identifier for the GetEndpointsRequest DataType.
        /// </summary>
        public const uint GetEndpointsRequest = 426;

        /// <summary>
        /// The identifier for the GetEndpointsResponse DataType.
        /// </summary>
        public const uint GetEndpointsResponse = 429;

        /// <summary>
        /// The identifier for the RegisteredServer DataType.
        /// </summary>
        public const uint RegisteredServer = 432;

        /// <summary>
        /// The identifier for the RegisterServerRequest DataType.
        /// </summary>
        public const uint RegisterServerRequest = 435;

        /// <summary>
        /// The identifier for the RegisterServerResponse DataType.
        /// </summary>
        public const uint RegisterServerResponse = 438;

        /// <summary>
        /// The identifier for the DiscoveryConfiguration DataType.
        /// </summary>
        public const uint DiscoveryConfiguration = 12890;

        /// <summary>
        /// The identifier for the MdnsDiscoveryConfiguration DataType.
        /// </summary>
        public const uint MdnsDiscoveryConfiguration = 12891;

        /// <summary>
        /// The identifier for the RegisterServer2Request DataType.
        /// </summary>
        public const uint RegisterServer2Request = 12193;

        /// <summary>
        /// The identifier for the RegisterServer2Response DataType.
        /// </summary>
        public const uint RegisterServer2Response = 12194;

        /// <summary>
        /// The identifier for the SecurityTokenRequestType DataType.
        /// </summary>
        public const uint SecurityTokenRequestType = 315;

        /// <summary>
        /// The identifier for the ChannelSecurityToken DataType.
        /// </summary>
        public const uint ChannelSecurityToken = 441;

        /// <summary>
        /// The identifier for the OpenSecureChannelRequest DataType.
        /// </summary>
        public const uint OpenSecureChannelRequest = 444;

        /// <summary>
        /// The identifier for the OpenSecureChannelResponse DataType.
        /// </summary>
        public const uint OpenSecureChannelResponse = 447;

        /// <summary>
        /// The identifier for the CloseSecureChannelRequest DataType.
        /// </summary>
        public const uint CloseSecureChannelRequest = 450;

        /// <summary>
        /// The identifier for the CloseSecureChannelResponse DataType.
        /// </summary>
        public const uint CloseSecureChannelResponse = 453;

        /// <summary>
        /// The identifier for the SignedSoftwareCertificate DataType.
        /// </summary>
        public const uint SignedSoftwareCertificate = 344;

        /// <summary>
        /// The identifier for the SessionAuthenticationToken DataType.
        /// </summary>
        public const uint SessionAuthenticationToken = 388;

        /// <summary>
        /// The identifier for the SignatureData DataType.
        /// </summary>
        public const uint SignatureData = 456;

        /// <summary>
        /// The identifier for the CreateSessionRequest DataType.
        /// </summary>
        public const uint CreateSessionRequest = 459;

        /// <summary>
        /// The identifier for the CreateSessionResponse DataType.
        /// </summary>
        public const uint CreateSessionResponse = 462;

        /// <summary>
        /// The identifier for the UserIdentityToken DataType.
        /// </summary>
        public const uint UserIdentityToken = 316;

        /// <summary>
        /// The identifier for the AnonymousIdentityToken DataType.
        /// </summary>
        public const uint AnonymousIdentityToken = 319;

        /// <summary>
        /// The identifier for the UserNameIdentityToken DataType.
        /// </summary>
        public const uint UserNameIdentityToken = 322;

        /// <summary>
        /// The identifier for the X509IdentityToken DataType.
        /// </summary>
        public const uint X509IdentityToken = 325;

        /// <summary>
        /// The identifier for the IssuedIdentityToken DataType.
        /// </summary>
        public const uint IssuedIdentityToken = 938;

        /// <summary>
        /// The identifier for the RsaEncryptedSecret DataType.
        /// </summary>
        public const uint RsaEncryptedSecret = 17545;

        /// <summary>
        /// The identifier for the EccEncryptedSecret DataType.
        /// </summary>
        public const uint EccEncryptedSecret = 17546;

        /// <summary>
        /// The identifier for the ActivateSessionRequest DataType.
        /// </summary>
        public const uint ActivateSessionRequest = 465;

        /// <summary>
        /// The identifier for the ActivateSessionResponse DataType.
        /// </summary>
        public const uint ActivateSessionResponse = 468;

        /// <summary>
        /// The identifier for the CloseSessionRequest DataType.
        /// </summary>
        public const uint CloseSessionRequest = 471;

        /// <summary>
        /// The identifier for the CloseSessionResponse DataType.
        /// </summary>
        public const uint CloseSessionResponse = 474;

        /// <summary>
        /// The identifier for the CancelRequest DataType.
        /// </summary>
        public const uint CancelRequest = 477;

        /// <summary>
        /// The identifier for the CancelResponse DataType.
        /// </summary>
        public const uint CancelResponse = 480;

        /// <summary>
        /// The identifier for the NodeAttributesMask DataType.
        /// </summary>
        public const uint NodeAttributesMask = 348;

        /// <summary>
        /// The identifier for the NodeAttributes DataType.
        /// </summary>
        public const uint NodeAttributes = 349;

        /// <summary>
        /// The identifier for the ObjectAttributes DataType.
        /// </summary>
        public const uint ObjectAttributes = 352;

        /// <summary>
        /// The identifier for the VariableAttributes DataType.
        /// </summary>
        public const uint VariableAttributes = 355;

        /// <summary>
        /// The identifier for the MethodAttributes DataType.
        /// </summary>
        public const uint MethodAttributes = 358;

        /// <summary>
        /// The identifier for the ObjectTypeAttributes DataType.
        /// </summary>
        public const uint ObjectTypeAttributes = 361;

        /// <summary>
        /// The identifier for the VariableTypeAttributes DataType.
        /// </summary>
        public const uint VariableTypeAttributes = 364;

        /// <summary>
        /// The identifier for the ReferenceTypeAttributes DataType.
        /// </summary>
        public const uint ReferenceTypeAttributes = 367;

        /// <summary>
        /// The identifier for the DataTypeAttributes DataType.
        /// </summary>
        public const uint DataTypeAttributes = 370;

        /// <summary>
        /// The identifier for the ViewAttributes DataType.
        /// </summary>
        public const uint ViewAttributes = 373;

        /// <summary>
        /// The identifier for the GenericAttributeValue DataType.
        /// </summary>
        public const uint GenericAttributeValue = 17606;

        /// <summary>
        /// The identifier for the GenericAttributes DataType.
        /// </summary>
        public const uint GenericAttributes = 17607;

        /// <summary>
        /// The identifier for the AddNodesItem DataType.
        /// </summary>
        public const uint AddNodesItem = 376;

        /// <summary>
        /// The identifier for the AddNodesResult DataType.
        /// </summary>
        public const uint AddNodesResult = 483;

        /// <summary>
        /// The identifier for the AddNodesRequest DataType.
        /// </summary>
        public const uint AddNodesRequest = 486;

        /// <summary>
        /// The identifier for the AddNodesResponse DataType.
        /// </summary>
        public const uint AddNodesResponse = 489;

        /// <summary>
        /// The identifier for the AddReferencesItem DataType.
        /// </summary>
        public const uint AddReferencesItem = 379;

        /// <summary>
        /// The identifier for the AddReferencesRequest DataType.
        /// </summary>
        public const uint AddReferencesRequest = 492;

        /// <summary>
        /// The identifier for the AddReferencesResponse DataType.
        /// </summary>
        public const uint AddReferencesResponse = 495;

        /// <summary>
        /// The identifier for the DeleteNodesItem DataType.
        /// </summary>
        public const uint DeleteNodesItem = 382;

        /// <summary>
        /// The identifier for the DeleteNodesRequest DataType.
        /// </summary>
        public const uint DeleteNodesRequest = 498;

        /// <summary>
        /// The identifier for the DeleteNodesResponse DataType.
        /// </summary>
        public const uint DeleteNodesResponse = 501;

        /// <summary>
        /// The identifier for the DeleteReferencesItem DataType.
        /// </summary>
        public const uint DeleteReferencesItem = 385;

        /// <summary>
        /// The identifier for the DeleteReferencesRequest DataType.
        /// </summary>
        public const uint DeleteReferencesRequest = 504;

        /// <summary>
        /// The identifier for the DeleteReferencesResponse DataType.
        /// </summary>
        public const uint DeleteReferencesResponse = 507;

        /// <summary>
        /// The identifier for the AttributeWriteMask DataType.
        /// </summary>
        public const uint AttributeWriteMask = 347;

        /// <summary>
        /// The identifier for the BrowseDirection DataType.
        /// </summary>
        public const uint BrowseDirection = 510;

        /// <summary>
        /// The identifier for the ViewDescription DataType.
        /// </summary>
        public const uint ViewDescription = 511;

        /// <summary>
        /// The identifier for the BrowseDescription DataType.
        /// </summary>
        public const uint BrowseDescription = 514;

        /// <summary>
        /// The identifier for the BrowseResultMask DataType.
        /// </summary>
        public const uint BrowseResultMask = 517;

        /// <summary>
        /// The identifier for the ReferenceDescription DataType.
        /// </summary>
        public const uint ReferenceDescription = 518;

        /// <summary>
        /// The identifier for the ContinuationPoint DataType.
        /// </summary>
        public const uint ContinuationPoint = 521;

        /// <summary>
        /// The identifier for the BrowseResult DataType.
        /// </summary>
        public const uint BrowseResult = 522;

        /// <summary>
        /// The identifier for the BrowseRequest DataType.
        /// </summary>
        public const uint BrowseRequest = 525;

        /// <summary>
        /// The identifier for the BrowseResponse DataType.
        /// </summary>
        public const uint BrowseResponse = 528;

        /// <summary>
        /// The identifier for the BrowseNextRequest DataType.
        /// </summary>
        public const uint BrowseNextRequest = 531;

        /// <summary>
        /// The identifier for the BrowseNextResponse DataType.
        /// </summary>
        public const uint BrowseNextResponse = 534;

        /// <summary>
        /// The identifier for the RelativePathElement DataType.
        /// </summary>
        public const uint RelativePathElement = 537;

        /// <summary>
        /// The identifier for the RelativePath DataType.
        /// </summary>
        public const uint RelativePath = 540;

        /// <summary>
        /// The identifier for the BrowsePath DataType.
        /// </summary>
        public const uint BrowsePath = 543;

        /// <summary>
        /// The identifier for the BrowsePathTarget DataType.
        /// </summary>
        public const uint BrowsePathTarget = 546;

        /// <summary>
        /// The identifier for the BrowsePathResult DataType.
        /// </summary>
        public const uint BrowsePathResult = 549;

        /// <summary>
        /// The identifier for the TranslateBrowsePathsToNodeIdsRequest DataType.
        /// </summary>
        public const uint TranslateBrowsePathsToNodeIdsRequest = 552;

        /// <summary>
        /// The identifier for the TranslateBrowsePathsToNodeIdsResponse DataType.
        /// </summary>
        public const uint TranslateBrowsePathsToNodeIdsResponse = 555;

        /// <summary>
        /// The identifier for the RegisterNodesRequest DataType.
        /// </summary>
        public const uint RegisterNodesRequest = 558;

        /// <summary>
        /// The identifier for the RegisterNodesResponse DataType.
        /// </summary>
        public const uint RegisterNodesResponse = 561;

        /// <summary>
        /// The identifier for the UnregisterNodesRequest DataType.
        /// </summary>
        public const uint UnregisterNodesRequest = 564;

        /// <summary>
        /// The identifier for the UnregisterNodesResponse DataType.
        /// </summary>
        public const uint UnregisterNodesResponse = 567;

        /// <summary>
        /// The identifier for the Counter DataType.
        /// </summary>
        public const uint Counter = 289;

        /// <summary>
        /// The identifier for the NumericRange DataType.
        /// </summary>
        public const uint NumericRange = 291;

        /// <summary>
        /// The identifier for the EndpointConfiguration DataType.
        /// </summary>
        public const uint EndpointConfiguration = 331;

        /// <summary>
        /// The identifier for the QueryDataDescription DataType.
        /// </summary>
        public const uint QueryDataDescription = 570;

        /// <summary>
        /// The identifier for the NodeTypeDescription DataType.
        /// </summary>
        public const uint NodeTypeDescription = 573;

        /// <summary>
        /// The identifier for the FilterOperator DataType.
        /// </summary>
        public const uint FilterOperator = 576;

        /// <summary>
        /// The identifier for the QueryDataSet DataType.
        /// </summary>
        public const uint QueryDataSet = 577;

        /// <summary>
        /// The identifier for the NodeReference DataType.
        /// </summary>
        public const uint NodeReference = 580;

        /// <summary>
        /// The identifier for the ContentFilterElement DataType.
        /// </summary>
        public const uint ContentFilterElement = 583;

        /// <summary>
        /// The identifier for the ContentFilter DataType.
        /// </summary>
        public const uint ContentFilter = 586;

        /// <summary>
        /// The identifier for the FilterOperand DataType.
        /// </summary>
        public const uint FilterOperand = 589;

        /// <summary>
        /// The identifier for the ElementOperand DataType.
        /// </summary>
        public const uint ElementOperand = 592;

        /// <summary>
        /// The identifier for the LiteralOperand DataType.
        /// </summary>
        public const uint LiteralOperand = 595;

        /// <summary>
        /// The identifier for the AttributeOperand DataType.
        /// </summary>
        public const uint AttributeOperand = 598;

        /// <summary>
        /// The identifier for the SimpleAttributeOperand DataType.
        /// </summary>
        public const uint SimpleAttributeOperand = 601;

        /// <summary>
        /// The identifier for the ContentFilterElementResult DataType.
        /// </summary>
        public const uint ContentFilterElementResult = 604;

        /// <summary>
        /// The identifier for the ContentFilterResult DataType.
        /// </summary>
        public const uint ContentFilterResult = 607;

        /// <summary>
        /// The identifier for the ParsingResult DataType.
        /// </summary>
        public const uint ParsingResult = 610;

        /// <summary>
        /// The identifier for the QueryFirstRequest DataType.
        /// </summary>
        public const uint QueryFirstRequest = 613;

        /// <summary>
        /// The identifier for the QueryFirstResponse DataType.
        /// </summary>
        public const uint QueryFirstResponse = 616;

        /// <summary>
        /// The identifier for the QueryNextRequest DataType.
        /// </summary>
        public const uint QueryNextRequest = 619;

        /// <summary>
        /// The identifier for the QueryNextResponse DataType.
        /// </summary>
        public const uint QueryNextResponse = 622;

        /// <summary>
        /// The identifier for the TimestampsToReturn DataType.
        /// </summary>
        public const uint TimestampsToReturn = 625;

        /// <summary>
        /// The identifier for the ReadValueId DataType.
        /// </summary>
        public const uint ReadValueId = 626;

        /// <summary>
        /// The identifier for the ReadRequest DataType.
        /// </summary>
        public const uint ReadRequest = 629;

        /// <summary>
        /// The identifier for the ReadResponse DataType.
        /// </summary>
        public const uint ReadResponse = 632;

        /// <summary>
        /// The identifier for the HistoryReadValueId DataType.
        /// </summary>
        public const uint HistoryReadValueId = 635;

        /// <summary>
        /// The identifier for the HistoryReadResult DataType.
        /// </summary>
        public const uint HistoryReadResult = 638;

        /// <summary>
        /// The identifier for the HistoryReadDetails DataType.
        /// </summary>
        public const uint HistoryReadDetails = 641;

        /// <summary>
        /// The identifier for the ReadEventDetails DataType.
        /// </summary>
        public const uint ReadEventDetails = 644;

        /// <summary>
        /// The identifier for the ReadRawModifiedDetails DataType.
        /// </summary>
        public const uint ReadRawModifiedDetails = 647;

        /// <summary>
        /// The identifier for the ReadProcessedDetails DataType.
        /// </summary>
        public const uint ReadProcessedDetails = 650;

        /// <summary>
        /// The identifier for the ReadAtTimeDetails DataType.
        /// </summary>
        public const uint ReadAtTimeDetails = 653;

        /// <summary>
        /// The identifier for the ReadAnnotationDataDetails DataType.
        /// </summary>
        public const uint ReadAnnotationDataDetails = 23497;

        /// <summary>
        /// The identifier for the HistoryData DataType.
        /// </summary>
        public const uint HistoryData = 656;

        /// <summary>
        /// The identifier for the ModificationInfo DataType.
        /// </summary>
        public const uint ModificationInfo = 11216;

        /// <summary>
        /// The identifier for the HistoryModifiedData DataType.
        /// </summary>
        public const uint HistoryModifiedData = 11217;

        /// <summary>
        /// The identifier for the HistoryEvent DataType.
        /// </summary>
        public const uint HistoryEvent = 659;

        /// <summary>
        /// The identifier for the HistoryReadRequest DataType.
        /// </summary>
        public const uint HistoryReadRequest = 662;

        /// <summary>
        /// The identifier for the HistoryReadResponse DataType.
        /// </summary>
        public const uint HistoryReadResponse = 665;

        /// <summary>
        /// The identifier for the WriteValue DataType.
        /// </summary>
        public const uint WriteValue = 668;

        /// <summary>
        /// The identifier for the WriteRequest DataType.
        /// </summary>
        public const uint WriteRequest = 671;

        /// <summary>
        /// The identifier for the WriteResponse DataType.
        /// </summary>
        public const uint WriteResponse = 674;

        /// <summary>
        /// The identifier for the HistoryUpdateDetails DataType.
        /// </summary>
        public const uint HistoryUpdateDetails = 677;

        /// <summary>
        /// The identifier for the HistoryUpdateType DataType.
        /// </summary>
        public const uint HistoryUpdateType = 11234;

        /// <summary>
        /// The identifier for the PerformUpdateType DataType.
        /// </summary>
        public const uint PerformUpdateType = 11293;

        /// <summary>
        /// The identifier for the UpdateDataDetails DataType.
        /// </summary>
        public const uint UpdateDataDetails = 680;

        /// <summary>
        /// The identifier for the UpdateStructureDataDetails DataType.
        /// </summary>
        public const uint UpdateStructureDataDetails = 11295;

        /// <summary>
        /// The identifier for the UpdateEventDetails DataType.
        /// </summary>
        public const uint UpdateEventDetails = 683;

        /// <summary>
        /// The identifier for the DeleteRawModifiedDetails DataType.
        /// </summary>
        public const uint DeleteRawModifiedDetails = 686;

        /// <summary>
        /// The identifier for the DeleteAtTimeDetails DataType.
        /// </summary>
        public const uint DeleteAtTimeDetails = 689;

        /// <summary>
        /// The identifier for the DeleteEventDetails DataType.
        /// </summary>
        public const uint DeleteEventDetails = 692;

        /// <summary>
        /// The identifier for the HistoryUpdateResult DataType.
        /// </summary>
        public const uint HistoryUpdateResult = 695;

        /// <summary>
        /// The identifier for the HistoryUpdateRequest DataType.
        /// </summary>
        public const uint HistoryUpdateRequest = 698;

        /// <summary>
        /// The identifier for the HistoryUpdateResponse DataType.
        /// </summary>
        public const uint HistoryUpdateResponse = 701;

        /// <summary>
        /// The identifier for the CallMethodRequest DataType.
        /// </summary>
        public const uint CallMethodRequest = 704;

        /// <summary>
        /// The identifier for the CallMethodResult DataType.
        /// </summary>
        public const uint CallMethodResult = 707;

        /// <summary>
        /// The identifier for the CallRequest DataType.
        /// </summary>
        public const uint CallRequest = 710;

        /// <summary>
        /// The identifier for the CallResponse DataType.
        /// </summary>
        public const uint CallResponse = 713;

        /// <summary>
        /// The identifier for the MonitoringMode DataType.
        /// </summary>
        public const uint MonitoringMode = 716;

        /// <summary>
        /// The identifier for the DataChangeTrigger DataType.
        /// </summary>
        public const uint DataChangeTrigger = 717;

        /// <summary>
        /// The identifier for the DeadbandType DataType.
        /// </summary>
        public const uint DeadbandType = 718;

        /// <summary>
        /// The identifier for the MonitoringFilter DataType.
        /// </summary>
        public const uint MonitoringFilter = 719;

        /// <summary>
        /// The identifier for the DataChangeFilter DataType.
        /// </summary>
        public const uint DataChangeFilter = 722;

        /// <summary>
        /// The identifier for the EventFilter DataType.
        /// </summary>
        public const uint EventFilter = 725;

        /// <summary>
        /// The identifier for the AggregateConfiguration DataType.
        /// </summary>
        public const uint AggregateConfiguration = 948;

        /// <summary>
        /// The identifier for the AggregateFilter DataType.
        /// </summary>
        public const uint AggregateFilter = 728;

        /// <summary>
        /// The identifier for the MonitoringFilterResult DataType.
        /// </summary>
        public const uint MonitoringFilterResult = 731;

        /// <summary>
        /// The identifier for the EventFilterResult DataType.
        /// </summary>
        public const uint EventFilterResult = 734;

        /// <summary>
        /// The identifier for the AggregateFilterResult DataType.
        /// </summary>
        public const uint AggregateFilterResult = 737;

        /// <summary>
        /// The identifier for the MonitoringParameters DataType.
        /// </summary>
        public const uint MonitoringParameters = 740;

        /// <summary>
        /// The identifier for the MonitoredItemCreateRequest DataType.
        /// </summary>
        public const uint MonitoredItemCreateRequest = 743;

        /// <summary>
        /// The identifier for the MonitoredItemCreateResult DataType.
        /// </summary>
        public const uint MonitoredItemCreateResult = 746;

        /// <summary>
        /// The identifier for the CreateMonitoredItemsRequest DataType.
        /// </summary>
        public const uint CreateMonitoredItemsRequest = 749;

        /// <summary>
        /// The identifier for the CreateMonitoredItemsResponse DataType.
        /// </summary>
        public const uint CreateMonitoredItemsResponse = 752;

        /// <summary>
        /// The identifier for the MonitoredItemModifyRequest DataType.
        /// </summary>
        public const uint MonitoredItemModifyRequest = 755;

        /// <summary>
        /// The identifier for the MonitoredItemModifyResult DataType.
        /// </summary>
        public const uint MonitoredItemModifyResult = 758;

        /// <summary>
        /// The identifier for the ModifyMonitoredItemsRequest DataType.
        /// </summary>
        public const uint ModifyMonitoredItemsRequest = 761;

        /// <summary>
        /// The identifier for the ModifyMonitoredItemsResponse DataType.
        /// </summary>
        public const uint ModifyMonitoredItemsResponse = 764;

        /// <summary>
        /// The identifier for the SetMonitoringModeRequest DataType.
        /// </summary>
        public const uint SetMonitoringModeRequest = 767;

        /// <summary>
        /// The identifier for the SetMonitoringModeResponse DataType.
        /// </summary>
        public const uint SetMonitoringModeResponse = 770;

        /// <summary>
        /// The identifier for the SetTriggeringRequest DataType.
        /// </summary>
        public const uint SetTriggeringRequest = 773;

        /// <summary>
        /// The identifier for the SetTriggeringResponse DataType.
        /// </summary>
        public const uint SetTriggeringResponse = 776;

        /// <summary>
        /// The identifier for the DeleteMonitoredItemsRequest DataType.
        /// </summary>
        public const uint DeleteMonitoredItemsRequest = 779;

        /// <summary>
        /// The identifier for the DeleteMonitoredItemsResponse DataType.
        /// </summary>
        public const uint DeleteMonitoredItemsResponse = 782;

        /// <summary>
        /// The identifier for the CreateSubscriptionRequest DataType.
        /// </summary>
        public const uint CreateSubscriptionRequest = 785;

        /// <summary>
        /// The identifier for the CreateSubscriptionResponse DataType.
        /// </summary>
        public const uint CreateSubscriptionResponse = 788;

        /// <summary>
        /// The identifier for the ModifySubscriptionRequest DataType.
        /// </summary>
        public const uint ModifySubscriptionRequest = 791;

        /// <summary>
        /// The identifier for the ModifySubscriptionResponse DataType.
        /// </summary>
        public const uint ModifySubscriptionResponse = 794;

        /// <summary>
        /// The identifier for the SetPublishingModeRequest DataType.
        /// </summary>
        public const uint SetPublishingModeRequest = 797;

        /// <summary>
        /// The identifier for the SetPublishingModeResponse DataType.
        /// </summary>
        public const uint SetPublishingModeResponse = 800;

        /// <summary>
        /// The identifier for the NotificationMessage DataType.
        /// </summary>
        public const uint NotificationMessage = 803;

        /// <summary>
        /// The identifier for the NotificationData DataType.
        /// </summary>
        public const uint NotificationData = 945;

        /// <summary>
        /// The identifier for the DataChangeNotification DataType.
        /// </summary>
        public const uint DataChangeNotification = 809;

        /// <summary>
        /// The identifier for the MonitoredItemNotification DataType.
        /// </summary>
        public const uint MonitoredItemNotification = 806;

        /// <summary>
        /// The identifier for the EventNotificationList DataType.
        /// </summary>
        public const uint EventNotificationList = 914;

        /// <summary>
        /// The identifier for the EventFieldList DataType.
        /// </summary>
        public const uint EventFieldList = 917;

        /// <summary>
        /// The identifier for the HistoryEventFieldList DataType.
        /// </summary>
        public const uint HistoryEventFieldList = 920;

        /// <summary>
        /// The identifier for the StatusChangeNotification DataType.
        /// </summary>
        public const uint StatusChangeNotification = 818;

        /// <summary>
        /// The identifier for the SubscriptionAcknowledgement DataType.
        /// </summary>
        public const uint SubscriptionAcknowledgement = 821;

        /// <summary>
        /// The identifier for the PublishRequest DataType.
        /// </summary>
        public const uint PublishRequest = 824;

        /// <summary>
        /// The identifier for the PublishResponse DataType.
        /// </summary>
        public const uint PublishResponse = 827;

        /// <summary>
        /// The identifier for the RepublishRequest DataType.
        /// </summary>
        public const uint RepublishRequest = 830;

        /// <summary>
        /// The identifier for the RepublishResponse DataType.
        /// </summary>
        public const uint RepublishResponse = 833;

        /// <summary>
        /// The identifier for the TransferResult DataType.
        /// </summary>
        public const uint TransferResult = 836;

        /// <summary>
        /// The identifier for the TransferSubscriptionsRequest DataType.
        /// </summary>
        public const uint TransferSubscriptionsRequest = 839;

        /// <summary>
        /// The identifier for the TransferSubscriptionsResponse DataType.
        /// </summary>
        public const uint TransferSubscriptionsResponse = 842;

        /// <summary>
        /// The identifier for the DeleteSubscriptionsRequest DataType.
        /// </summary>
        public const uint DeleteSubscriptionsRequest = 845;

        /// <summary>
        /// The identifier for the DeleteSubscriptionsResponse DataType.
        /// </summary>
        public const uint DeleteSubscriptionsResponse = 848;

        /// <summary>
        /// The identifier for the BuildInfo DataType.
        /// </summary>
        public const uint BuildInfo = 338;

        /// <summary>
        /// The identifier for the RedundancySupport DataType.
        /// </summary>
        public const uint RedundancySupport = 851;

        /// <summary>
        /// The identifier for the ServerState DataType.
        /// </summary>
        public const uint ServerState = 852;

        /// <summary>
        /// The identifier for the RedundantServerDataType DataType.
        /// </summary>
        public const uint RedundantServerDataType = 853;

        /// <summary>
        /// The identifier for the EndpointUrlListDataType DataType.
        /// </summary>
        public const uint EndpointUrlListDataType = 11943;

        /// <summary>
        /// The identifier for the NetworkGroupDataType DataType.
        /// </summary>
        public const uint NetworkGroupDataType = 11944;

        /// <summary>
        /// The identifier for the SamplingIntervalDiagnosticsDataType DataType.
        /// </summary>
        public const uint SamplingIntervalDiagnosticsDataType = 856;

        /// <summary>
        /// The identifier for the ServerDiagnosticsSummaryDataType DataType.
        /// </summary>
        public const uint ServerDiagnosticsSummaryDataType = 859;

        /// <summary>
        /// The identifier for the ServerStatusDataType DataType.
        /// </summary>
        public const uint ServerStatusDataType = 862;

        /// <summary>
        /// The identifier for the SessionDiagnosticsDataType DataType.
        /// </summary>
        public const uint SessionDiagnosticsDataType = 865;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsDataType DataType.
        /// </summary>
        public const uint SessionSecurityDiagnosticsDataType = 868;

        /// <summary>
        /// The identifier for the ServiceCounterDataType DataType.
        /// </summary>
        public const uint ServiceCounterDataType = 871;

        /// <summary>
        /// The identifier for the StatusResult DataType.
        /// </summary>
        public const uint StatusResult = 299;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsDataType DataType.
        /// </summary>
        public const uint SubscriptionDiagnosticsDataType = 874;

        /// <summary>
        /// The identifier for the ModelChangeStructureVerbMask DataType.
        /// </summary>
        public const uint ModelChangeStructureVerbMask = 11941;

        /// <summary>
        /// The identifier for the ModelChangeStructureDataType DataType.
        /// </summary>
        public const uint ModelChangeStructureDataType = 877;

        /// <summary>
        /// The identifier for the SemanticChangeStructureDataType DataType.
        /// </summary>
        public const uint SemanticChangeStructureDataType = 897;

        /// <summary>
        /// The identifier for the Range DataType.
        /// </summary>
        public const uint Range = 884;

        /// <summary>
        /// The identifier for the EUInformation DataType.
        /// </summary>
        public const uint EUInformation = 887;

        /// <summary>
        /// The identifier for the AxisScaleEnumeration DataType.
        /// </summary>
        public const uint AxisScaleEnumeration = 12077;

        /// <summary>
        /// The identifier for the ComplexNumberType DataType.
        /// </summary>
        public const uint ComplexNumberType = 12171;

        /// <summary>
        /// The identifier for the DoubleComplexNumberType DataType.
        /// </summary>
        public const uint DoubleComplexNumberType = 12172;

        /// <summary>
        /// The identifier for the AxisInformation DataType.
        /// </summary>
        public const uint AxisInformation = 12079;

        /// <summary>
        /// The identifier for the XVType DataType.
        /// </summary>
        public const uint XVType = 12080;

        /// <summary>
        /// The identifier for the ProgramDiagnosticDataType DataType.
        /// </summary>
        public const uint ProgramDiagnosticDataType = 894;

        /// <summary>
        /// The identifier for the ProgramDiagnostic2DataType DataType.
        /// </summary>
        public const uint ProgramDiagnostic2DataType = 24033;

        /// <summary>
        /// The identifier for the Annotation DataType.
        /// </summary>
        public const uint Annotation = 891;

        /// <summary>
        /// The identifier for the ExceptionDeviationFormat DataType.
        /// </summary>
        public const uint ExceptionDeviationFormat = 890;
    }
    #endregion

    #region Method Identifiers
    /// <summary>
    /// A class that declares constants for all Methods in the Model Design.
    /// </summary>
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class Methods
    {
        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespaceFile_Open Method.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespaceFile_Open = 15971;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespaceFile_Close Method.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespaceFile_Close = 15974;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespaceFile_Read Method.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespaceFile_Read = 15976;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespaceFile_Write Method.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespaceFile_Write = 15979;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespaceFile_GetPosition Method.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespaceFile_GetPosition = 15981;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespaceFile_SetPosition Method.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespaceFile_SetPosition = 15984;

        /// <summary>
        /// The identifier for the ServerType_ServerCapabilities_RoleSet_AddRole Method.
        /// </summary>
        public const uint ServerType_ServerCapabilities_RoleSet_AddRole = 16290;

        /// <summary>
        /// The identifier for the ServerType_ServerCapabilities_RoleSet_RemoveRole Method.
        /// </summary>
        public const uint ServerType_ServerCapabilities_RoleSet_RemoveRole = 16293;

        /// <summary>
        /// The identifier for the ServerType_GetMonitoredItems Method.
        /// </summary>
        public const uint ServerType_GetMonitoredItems = 11489;

        /// <summary>
        /// The identifier for the ServerType_ResendData Method.
        /// </summary>
        public const uint ServerType_ResendData = 12871;

        /// <summary>
        /// The identifier for the ServerType_SetSubscriptionDurable Method.
        /// </summary>
        public const uint ServerType_SetSubscriptionDurable = 12746;

        /// <summary>
        /// The identifier for the ServerType_RequestServerStateChange Method.
        /// </summary>
        public const uint ServerType_RequestServerStateChange = 12883;

        /// <summary>
        /// The identifier for the ServerCapabilitiesType_RoleSet_AddRole Method.
        /// </summary>
        public const uint ServerCapabilitiesType_RoleSet_AddRole = 16296;

        /// <summary>
        /// The identifier for the ServerCapabilitiesType_RoleSet_RemoveRole Method.
        /// </summary>
        public const uint ServerCapabilitiesType_RoleSet_RemoveRole = 16299;

        /// <summary>
        /// The identifier for the FileType_Open Method.
        /// </summary>
        public const uint FileType_Open = 11580;

        /// <summary>
        /// The identifier for the FileType_Close Method.
        /// </summary>
        public const uint FileType_Close = 11583;

        /// <summary>
        /// The identifier for the FileType_Read Method.
        /// </summary>
        public const uint FileType_Read = 11585;

        /// <summary>
        /// The identifier for the FileType_Write Method.
        /// </summary>
        public const uint FileType_Write = 11588;

        /// <summary>
        /// The identifier for the FileType_GetPosition Method.
        /// </summary>
        public const uint FileType_GetPosition = 11590;

        /// <summary>
        /// The identifier for the FileType_SetPosition Method.
        /// </summary>
        public const uint FileType_SetPosition = 11593;

        /// <summary>
        /// The identifier for the AddressSpaceFileType_ExportNamespace Method.
        /// </summary>
        public const uint AddressSpaceFileType_ExportNamespace = 11615;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceFile_Open Method.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceFile_Open = 11629;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceFile_Close Method.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceFile_Close = 11632;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceFile_Read Method.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceFile_Read = 11634;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceFile_Write Method.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceFile_Write = 11637;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceFile_GetPosition Method.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceFile_GetPosition = 11639;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceFile_SetPosition Method.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceFile_SetPosition = 11642;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open Method.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open = 11659;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close Method.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close = 11662;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read Method.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read = 11664;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write Method.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write = 11667;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition Method.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition = 11669;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition Method.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition = 11672;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_RoleSet_AddRole Method.
        /// </summary>
        public const uint Server_ServerCapabilities_RoleSet_AddRole = 16301;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_RoleSet_RemoveRole Method.
        /// </summary>
        public const uint Server_ServerCapabilities_RoleSet_RemoveRole = 16304;

        /// <summary>
        /// The identifier for the Server_GetMonitoredItems Method.
        /// </summary>
        public const uint Server_GetMonitoredItems = 11492;

        /// <summary>
        /// The identifier for the Server_ResendData Method.
        /// </summary>
        public const uint Server_ResendData = 12873;

        /// <summary>
        /// The identifier for the Server_SetSubscriptionDurable Method.
        /// </summary>
        public const uint Server_SetSubscriptionDurable = 12749;

        /// <summary>
        /// The identifier for the Server_RequestServerStateChange Method.
        /// </summary>
        public const uint Server_RequestServerStateChange = 12886;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory Method.
        /// </summary>
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory = 13355;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileDirectoryName_Placeholder_CreateFile Method.
        /// </summary>
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_CreateFile = 13358;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject Method.
        /// </summary>
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject = 17718;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy Method.
        /// </summary>
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy = 13363;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileName_Placeholder_Open Method.
        /// </summary>
        public const uint FileDirectoryType_FileName_Placeholder_Open = 13372;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileName_Placeholder_Close Method.
        /// </summary>
        public const uint FileDirectoryType_FileName_Placeholder_Close = 13375;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileName_Placeholder_Read Method.
        /// </summary>
        public const uint FileDirectoryType_FileName_Placeholder_Read = 13377;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileName_Placeholder_Write Method.
        /// </summary>
        public const uint FileDirectoryType_FileName_Placeholder_Write = 13380;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileName_Placeholder_GetPosition Method.
        /// </summary>
        public const uint FileDirectoryType_FileName_Placeholder_GetPosition = 13382;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileName_Placeholder_SetPosition Method.
        /// </summary>
        public const uint FileDirectoryType_FileName_Placeholder_SetPosition = 13385;

        /// <summary>
        /// The identifier for the FileDirectoryType_CreateDirectory Method.
        /// </summary>
        public const uint FileDirectoryType_CreateDirectory = 13387;

        /// <summary>
        /// The identifier for the FileDirectoryType_CreateFile Method.
        /// </summary>
        public const uint FileDirectoryType_CreateFile = 13390;

        /// <summary>
        /// The identifier for the FileDirectoryType_DeleteFileSystemObject Method.
        /// </summary>
        public const uint FileDirectoryType_DeleteFileSystemObject = 13393;

        /// <summary>
        /// The identifier for the FileDirectoryType_MoveOrCopy Method.
        /// </summary>
        public const uint FileDirectoryType_MoveOrCopy = 13395;

        /// <summary>
        /// The identifier for the FileSystem_FileDirectoryName_Placeholder_CreateDirectory Method.
        /// </summary>
        public const uint FileSystem_FileDirectoryName_Placeholder_CreateDirectory = 16316;

        /// <summary>
        /// The identifier for the FileSystem_FileDirectoryName_Placeholder_CreateFile Method.
        /// </summary>
        public const uint FileSystem_FileDirectoryName_Placeholder_CreateFile = 16319;

        /// <summary>
        /// The identifier for the FileSystem_FileDirectoryName_Placeholder_DeleteFileSystemObject Method.
        /// </summary>
        public const uint FileSystem_FileDirectoryName_Placeholder_DeleteFileSystemObject = 17722;

        /// <summary>
        /// The identifier for the FileSystem_FileDirectoryName_Placeholder_MoveOrCopy Method.
        /// </summary>
        public const uint FileSystem_FileDirectoryName_Placeholder_MoveOrCopy = 16324;

        /// <summary>
        /// The identifier for the FileSystem_FileName_Placeholder_Open Method.
        /// </summary>
        public const uint FileSystem_FileName_Placeholder_Open = 16333;

        /// <summary>
        /// The identifier for the FileSystem_FileName_Placeholder_Close Method.
        /// </summary>
        public const uint FileSystem_FileName_Placeholder_Close = 16336;

        /// <summary>
        /// The identifier for the FileSystem_FileName_Placeholder_Read Method.
        /// </summary>
        public const uint FileSystem_FileName_Placeholder_Read = 16338;

        /// <summary>
        /// The identifier for the FileSystem_FileName_Placeholder_Write Method.
        /// </summary>
        public const uint FileSystem_FileName_Placeholder_Write = 16341;

        /// <summary>
        /// The identifier for the FileSystem_FileName_Placeholder_GetPosition Method.
        /// </summary>
        public const uint FileSystem_FileName_Placeholder_GetPosition = 16343;

        /// <summary>
        /// The identifier for the FileSystem_FileName_Placeholder_SetPosition Method.
        /// </summary>
        public const uint FileSystem_FileName_Placeholder_SetPosition = 16346;

        /// <summary>
        /// The identifier for the FileSystem_CreateDirectory Method.
        /// </summary>
        public const uint FileSystem_CreateDirectory = 16348;

        /// <summary>
        /// The identifier for the FileSystem_CreateFile Method.
        /// </summary>
        public const uint FileSystem_CreateFile = 16351;

        /// <summary>
        /// The identifier for the FileSystem_DeleteFileSystemObject Method.
        /// </summary>
        public const uint FileSystem_DeleteFileSystemObject = 16354;

        /// <summary>
        /// The identifier for the FileSystem_MoveOrCopy Method.
        /// </summary>
        public const uint FileSystem_MoveOrCopy = 16356;

        /// <summary>
        /// The identifier for the TemporaryFileTransferType_GenerateFileForRead Method.
        /// </summary>
        public const uint TemporaryFileTransferType_GenerateFileForRead = 15746;

        /// <summary>
        /// The identifier for the TemporaryFileTransferType_GenerateFileForWrite Method.
        /// </summary>
        public const uint TemporaryFileTransferType_GenerateFileForWrite = 15749;

        /// <summary>
        /// The identifier for the TemporaryFileTransferType_CloseAndCommit Method.
        /// </summary>
        public const uint TemporaryFileTransferType_CloseAndCommit = 15751;

        /// <summary>
        /// The identifier for the TemporaryFileTransferType_TransferState_Placeholder_Reset Method.
        /// </summary>
        public const uint TemporaryFileTransferType_TransferState_Placeholder_Reset = 15794;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_Reset Method.
        /// </summary>
        public const uint FileTransferStateMachineType_Reset = 15843;

        /// <summary>
        /// The identifier for the RoleSetType_AddRole Method.
        /// </summary>
        public const uint RoleSetType_AddRole = 15997;

        /// <summary>
        /// The identifier for the RoleSetType_RemoveRole Method.
        /// </summary>
        public const uint RoleSetType_RemoveRole = 16000;

        /// <summary>
        /// The identifier for the RoleType_AddIdentity Method.
        /// </summary>
        public const uint RoleType_AddIdentity = 15624;

        /// <summary>
        /// The identifier for the RoleType_RemoveIdentity Method.
        /// </summary>
        public const uint RoleType_RemoveIdentity = 15626;

        /// <summary>
        /// The identifier for the RoleType_AddApplication Method.
        /// </summary>
        public const uint RoleType_AddApplication = 16176;

        /// <summary>
        /// The identifier for the RoleType_RemoveApplication Method.
        /// </summary>
        public const uint RoleType_RemoveApplication = 16178;

        /// <summary>
        /// The identifier for the RoleType_AddEndpoint Method.
        /// </summary>
        public const uint RoleType_AddEndpoint = 16180;

        /// <summary>
        /// The identifier for the RoleType_RemoveEndpoint Method.
        /// </summary>
        public const uint RoleType_RemoveEndpoint = 16182;

        /// <summary>
        /// The identifier for the WellKnownRole_Anonymous_AddIdentity Method.
        /// </summary>
        public const uint WellKnownRole_Anonymous_AddIdentity = 15648;

        /// <summary>
        /// The identifier for the WellKnownRole_Anonymous_RemoveIdentity Method.
        /// </summary>
        public const uint WellKnownRole_Anonymous_RemoveIdentity = 15650;

        /// <summary>
        /// The identifier for the WellKnownRole_Anonymous_AddApplication Method.
        /// </summary>
        public const uint WellKnownRole_Anonymous_AddApplication = 16195;

        /// <summary>
        /// The identifier for the WellKnownRole_Anonymous_RemoveApplication Method.
        /// </summary>
        public const uint WellKnownRole_Anonymous_RemoveApplication = 16197;

        /// <summary>
        /// The identifier for the WellKnownRole_Anonymous_AddEndpoint Method.
        /// </summary>
        public const uint WellKnownRole_Anonymous_AddEndpoint = 16199;

        /// <summary>
        /// The identifier for the WellKnownRole_Anonymous_RemoveEndpoint Method.
        /// </summary>
        public const uint WellKnownRole_Anonymous_RemoveEndpoint = 16201;

        /// <summary>
        /// The identifier for the WellKnownRole_AuthenticatedUser_AddIdentity Method.
        /// </summary>
        public const uint WellKnownRole_AuthenticatedUser_AddIdentity = 15660;

        /// <summary>
        /// The identifier for the WellKnownRole_AuthenticatedUser_RemoveIdentity Method.
        /// </summary>
        public const uint WellKnownRole_AuthenticatedUser_RemoveIdentity = 15662;

        /// <summary>
        /// The identifier for the WellKnownRole_AuthenticatedUser_AddApplication Method.
        /// </summary>
        public const uint WellKnownRole_AuthenticatedUser_AddApplication = 16206;

        /// <summary>
        /// The identifier for the WellKnownRole_AuthenticatedUser_RemoveApplication Method.
        /// </summary>
        public const uint WellKnownRole_AuthenticatedUser_RemoveApplication = 16208;

        /// <summary>
        /// The identifier for the WellKnownRole_AuthenticatedUser_AddEndpoint Method.
        /// </summary>
        public const uint WellKnownRole_AuthenticatedUser_AddEndpoint = 16210;

        /// <summary>
        /// The identifier for the WellKnownRole_AuthenticatedUser_RemoveEndpoint Method.
        /// </summary>
        public const uint WellKnownRole_AuthenticatedUser_RemoveEndpoint = 16212;

        /// <summary>
        /// The identifier for the WellKnownRole_Observer_AddIdentity Method.
        /// </summary>
        public const uint WellKnownRole_Observer_AddIdentity = 15672;

        /// <summary>
        /// The identifier for the WellKnownRole_Observer_RemoveIdentity Method.
        /// </summary>
        public const uint WellKnownRole_Observer_RemoveIdentity = 15674;

        /// <summary>
        /// The identifier for the WellKnownRole_Observer_AddApplication Method.
        /// </summary>
        public const uint WellKnownRole_Observer_AddApplication = 16217;

        /// <summary>
        /// The identifier for the WellKnownRole_Observer_RemoveApplication Method.
        /// </summary>
        public const uint WellKnownRole_Observer_RemoveApplication = 16219;

        /// <summary>
        /// The identifier for the WellKnownRole_Observer_AddEndpoint Method.
        /// </summary>
        public const uint WellKnownRole_Observer_AddEndpoint = 16221;

        /// <summary>
        /// The identifier for the WellKnownRole_Observer_RemoveEndpoint Method.
        /// </summary>
        public const uint WellKnownRole_Observer_RemoveEndpoint = 16223;

        /// <summary>
        /// The identifier for the WellKnownRole_Operator_AddIdentity Method.
        /// </summary>
        public const uint WellKnownRole_Operator_AddIdentity = 15684;

        /// <summary>
        /// The identifier for the WellKnownRole_Operator_RemoveIdentity Method.
        /// </summary>
        public const uint WellKnownRole_Operator_RemoveIdentity = 15686;

        /// <summary>
        /// The identifier for the WellKnownRole_Operator_AddApplication Method.
        /// </summary>
        public const uint WellKnownRole_Operator_AddApplication = 16228;

        /// <summary>
        /// The identifier for the WellKnownRole_Operator_RemoveApplication Method.
        /// </summary>
        public const uint WellKnownRole_Operator_RemoveApplication = 16230;

        /// <summary>
        /// The identifier for the WellKnownRole_Operator_AddEndpoint Method.
        /// </summary>
        public const uint WellKnownRole_Operator_AddEndpoint = 16232;

        /// <summary>
        /// The identifier for the WellKnownRole_Operator_RemoveEndpoint Method.
        /// </summary>
        public const uint WellKnownRole_Operator_RemoveEndpoint = 16234;

        /// <summary>
        /// The identifier for the WellKnownRole_Engineer_AddIdentity Method.
        /// </summary>
        public const uint WellKnownRole_Engineer_AddIdentity = 16041;

        /// <summary>
        /// The identifier for the WellKnownRole_Engineer_RemoveIdentity Method.
        /// </summary>
        public const uint WellKnownRole_Engineer_RemoveIdentity = 16043;

        /// <summary>
        /// The identifier for the WellKnownRole_Engineer_AddApplication Method.
        /// </summary>
        public const uint WellKnownRole_Engineer_AddApplication = 16239;

        /// <summary>
        /// The identifier for the WellKnownRole_Engineer_RemoveApplication Method.
        /// </summary>
        public const uint WellKnownRole_Engineer_RemoveApplication = 16241;

        /// <summary>
        /// The identifier for the WellKnownRole_Engineer_AddEndpoint Method.
        /// </summary>
        public const uint WellKnownRole_Engineer_AddEndpoint = 16243;

        /// <summary>
        /// The identifier for the WellKnownRole_Engineer_RemoveEndpoint Method.
        /// </summary>
        public const uint WellKnownRole_Engineer_RemoveEndpoint = 16245;

        /// <summary>
        /// The identifier for the WellKnownRole_Supervisor_AddIdentity Method.
        /// </summary>
        public const uint WellKnownRole_Supervisor_AddIdentity = 15696;

        /// <summary>
        /// The identifier for the WellKnownRole_Supervisor_RemoveIdentity Method.
        /// </summary>
        public const uint WellKnownRole_Supervisor_RemoveIdentity = 15698;

        /// <summary>
        /// The identifier for the WellKnownRole_Supervisor_AddApplication Method.
        /// </summary>
        public const uint WellKnownRole_Supervisor_AddApplication = 16250;

        /// <summary>
        /// The identifier for the WellKnownRole_Supervisor_RemoveApplication Method.
        /// </summary>
        public const uint WellKnownRole_Supervisor_RemoveApplication = 16252;

        /// <summary>
        /// The identifier for the WellKnownRole_Supervisor_AddEndpoint Method.
        /// </summary>
        public const uint WellKnownRole_Supervisor_AddEndpoint = 16254;

        /// <summary>
        /// The identifier for the WellKnownRole_Supervisor_RemoveEndpoint Method.
        /// </summary>
        public const uint WellKnownRole_Supervisor_RemoveEndpoint = 16256;

        /// <summary>
        /// The identifier for the WellKnownRole_ConfigureAdmin_AddIdentity Method.
        /// </summary>
        public const uint WellKnownRole_ConfigureAdmin_AddIdentity = 15720;

        /// <summary>
        /// The identifier for the WellKnownRole_ConfigureAdmin_RemoveIdentity Method.
        /// </summary>
        public const uint WellKnownRole_ConfigureAdmin_RemoveIdentity = 15722;

        /// <summary>
        /// The identifier for the WellKnownRole_ConfigureAdmin_AddApplication Method.
        /// </summary>
        public const uint WellKnownRole_ConfigureAdmin_AddApplication = 16272;

        /// <summary>
        /// The identifier for the WellKnownRole_ConfigureAdmin_RemoveApplication Method.
        /// </summary>
        public const uint WellKnownRole_ConfigureAdmin_RemoveApplication = 16274;

        /// <summary>
        /// The identifier for the WellKnownRole_ConfigureAdmin_AddEndpoint Method.
        /// </summary>
        public const uint WellKnownRole_ConfigureAdmin_AddEndpoint = 16276;

        /// <summary>
        /// The identifier for the WellKnownRole_ConfigureAdmin_RemoveEndpoint Method.
        /// </summary>
        public const uint WellKnownRole_ConfigureAdmin_RemoveEndpoint = 16278;

        /// <summary>
        /// The identifier for the WellKnownRole_SecurityAdmin_AddIdentity Method.
        /// </summary>
        public const uint WellKnownRole_SecurityAdmin_AddIdentity = 15708;

        /// <summary>
        /// The identifier for the WellKnownRole_SecurityAdmin_RemoveIdentity Method.
        /// </summary>
        public const uint WellKnownRole_SecurityAdmin_RemoveIdentity = 15710;

        /// <summary>
        /// The identifier for the WellKnownRole_SecurityAdmin_AddApplication Method.
        /// </summary>
        public const uint WellKnownRole_SecurityAdmin_AddApplication = 16261;

        /// <summary>
        /// The identifier for the WellKnownRole_SecurityAdmin_RemoveApplication Method.
        /// </summary>
        public const uint WellKnownRole_SecurityAdmin_RemoveApplication = 16263;

        /// <summary>
        /// The identifier for the WellKnownRole_SecurityAdmin_AddEndpoint Method.
        /// </summary>
        public const uint WellKnownRole_SecurityAdmin_AddEndpoint = 16265;

        /// <summary>
        /// The identifier for the WellKnownRole_SecurityAdmin_RemoveEndpoint Method.
        /// </summary>
        public const uint WellKnownRole_SecurityAdmin_RemoveEndpoint = 16267;

        /// <summary>
        /// The identifier for the ConditionType_Disable Method.
        /// </summary>
        public const uint ConditionType_Disable = 9028;

        /// <summary>
        /// The identifier for the ConditionType_Enable Method.
        /// </summary>
        public const uint ConditionType_Enable = 9027;

        /// <summary>
        /// The identifier for the ConditionType_AddComment Method.
        /// </summary>
        public const uint ConditionType_AddComment = 9029;

        /// <summary>
        /// The identifier for the ConditionType_ConditionRefresh Method.
        /// </summary>
        public const uint ConditionType_ConditionRefresh = 3875;

        /// <summary>
        /// The identifier for the ConditionType_ConditionRefresh2 Method.
        /// </summary>
        public const uint ConditionType_ConditionRefresh2 = 12912;

        /// <summary>
        /// The identifier for the DialogConditionType_Respond Method.
        /// </summary>
        public const uint DialogConditionType_Respond = 9069;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_Acknowledge Method.
        /// </summary>
        public const uint AcknowledgeableConditionType_Acknowledge = 9111;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_Confirm Method.
        /// </summary>
        public const uint AcknowledgeableConditionType_Confirm = 9113;

        /// <summary>
        /// The identifier for the AlarmConditionType_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint AlarmConditionType_ShelvingState_TimedShelve = 9213;

        /// <summary>
        /// The identifier for the AlarmConditionType_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint AlarmConditionType_ShelvingState_Unshelve = 9211;

        /// <summary>
        /// The identifier for the AlarmConditionType_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint AlarmConditionType_ShelvingState_OneShotShelve = 9212;

        /// <summary>
        /// The identifier for the AlarmConditionType_Silence Method.
        /// </summary>
        public const uint AlarmConditionType_Silence = 16402;

        /// <summary>
        /// The identifier for the AlarmConditionType_Suppress Method.
        /// </summary>
        public const uint AlarmConditionType_Suppress = 16403;

        /// <summary>
        /// The identifier for the AlarmConditionType_Unsuppress Method.
        /// </summary>
        public const uint AlarmConditionType_Unsuppress = 17868;

        /// <summary>
        /// The identifier for the AlarmConditionType_RemoveFromService Method.
        /// </summary>
        public const uint AlarmConditionType_RemoveFromService = 17869;

        /// <summary>
        /// The identifier for the AlarmConditionType_PlaceInService Method.
        /// </summary>
        public const uint AlarmConditionType_PlaceInService = 17870;

        /// <summary>
        /// The identifier for the AlarmConditionType_Reset Method.
        /// </summary>
        public const uint AlarmConditionType_Reset = 18199;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_Disable Method.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Disable = 16439;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_Enable Method.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Enable = 16440;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment Method.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment = 16441;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge Method.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge = 16461;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve = 16517;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve = 16515;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve = 16516;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_TimedShelve Method.
        /// </summary>
        public const uint ShelvedStateMachineType_TimedShelve = 2949;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_Unshelve Method.
        /// </summary>
        public const uint ShelvedStateMachineType_Unshelve = 2947;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_OneShotShelve Method.
        /// </summary>
        public const uint ShelvedStateMachineType_OneShotShelve = 2948;

        /// <summary>
        /// The identifier for the LimitAlarmType_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint LimitAlarmType_ShelvingState_TimedShelve = 9314;

        /// <summary>
        /// The identifier for the LimitAlarmType_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint LimitAlarmType_ShelvingState_Unshelve = 9312;

        /// <summary>
        /// The identifier for the LimitAlarmType_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint LimitAlarmType_ShelvingState_OneShotShelve = 9313;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_ShelvingState_TimedShelve = 9451;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_ShelvingState_Unshelve = 9449;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_ShelvingState_OneShotShelve = 9450;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_ShelvingState_TimedShelve = 10016;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_ShelvingState_Unshelve = 10014;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve = 10015;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_ShelvingState_TimedShelve = 10170;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_ShelvingState_Unshelve = 10168;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve = 10169;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_ShelvingState_TimedShelve = 9592;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_ShelvingState_Unshelve = 9590;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_ShelvingState_OneShotShelve = 9591;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve = 10478;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_ShelvingState_Unshelve = 10476;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve = 10477;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve = 10324;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve = 10322;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve = 10323;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_ShelvingState_TimedShelve = 9874;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_ShelvingState_Unshelve = 9872;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve = 9873;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve = 9733;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve = 9731;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve = 9732;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint DiscreteAlarmType_ShelvingState_TimedShelve = 10633;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint DiscreteAlarmType_ShelvingState_Unshelve = 10631;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint DiscreteAlarmType_ShelvingState_OneShotShelve = 10632;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint OffNormalAlarmType_ShelvingState_TimedShelve = 10747;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint OffNormalAlarmType_ShelvingState_Unshelve = 10745;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint OffNormalAlarmType_ShelvingState_OneShotShelve = 10746;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint SystemOffNormalAlarmType_ShelvingState_TimedShelve = 11846;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint SystemOffNormalAlarmType_ShelvingState_Unshelve = 11844;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint SystemOffNormalAlarmType_ShelvingState_OneShotShelve = 11845;

        /// <summary>
        /// The identifier for the TripAlarmType_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint TripAlarmType_ShelvingState_TimedShelve = 10861;

        /// <summary>
        /// The identifier for the TripAlarmType_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint TripAlarmType_ShelvingState_Unshelve = 10859;

        /// <summary>
        /// The identifier for the TripAlarmType_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint TripAlarmType_ShelvingState_OneShotShelve = 10860;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve = 18453;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_ShelvingState_Unshelve = 18455;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_ShelvingState_OneShotShelve = 18456;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_ShelvingState_TimedShelve = 18602;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_ShelvingState_Unshelve = 18604;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_ShelvingState_OneShotShelve = 18605;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint CertificateExpirationAlarmType_ShelvingState_TimedShelve = 13320;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint CertificateExpirationAlarmType_ShelvingState_Unshelve = 13318;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint CertificateExpirationAlarmType_ShelvingState_OneShotShelve = 13319;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint DiscrepancyAlarmType_ShelvingState_TimedShelve = 17195;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint DiscrepancyAlarmType_ShelvingState_Unshelve = 17193;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint DiscrepancyAlarmType_ShelvingState_OneShotShelve = 17194;

        /// <summary>
        /// The identifier for the AlarmMetricsType_Reset Method.
        /// </summary>
        public const uint AlarmMetricsType_Reset = 18666;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_Start Method.
        /// </summary>
        public const uint ProgramStateMachineType_Start = 2426;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_Suspend Method.
        /// </summary>
        public const uint ProgramStateMachineType_Suspend = 2427;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_Resume Method.
        /// </summary>
        public const uint ProgramStateMachineType_Resume = 2428;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_Halt Method.
        /// </summary>
        public const uint ProgramStateMachineType_Halt = 2429;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_Reset Method.
        /// </summary>
        public const uint ProgramStateMachineType_Reset = 2430;

        /// <summary>
        /// The identifier for the TrustListType_OpenWithMasks Method.
        /// </summary>
        public const uint TrustListType_OpenWithMasks = 12543;

        /// <summary>
        /// The identifier for the TrustListType_CloseAndUpdate Method.
        /// </summary>
        public const uint TrustListType_CloseAndUpdate = 12546;

        /// <summary>
        /// The identifier for the TrustListType_AddCertificate Method.
        /// </summary>
        public const uint TrustListType_AddCertificate = 12548;

        /// <summary>
        /// The identifier for the TrustListType_RemoveCertificate Method.
        /// </summary>
        public const uint TrustListType_RemoveCertificate = 12550;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_ShelvingState_TimedShelve = 19403;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_ShelvingState_Unshelve = 19405;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_ShelvingState_OneShotShelve = 19406;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_Open Method.
        /// </summary>
        public const uint CertificateGroupType_TrustList_Open = 13605;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_Close Method.
        /// </summary>
        public const uint CertificateGroupType_TrustList_Close = 13608;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_Read Method.
        /// </summary>
        public const uint CertificateGroupType_TrustList_Read = 13610;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_Write Method.
        /// </summary>
        public const uint CertificateGroupType_TrustList_Write = 13613;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_GetPosition Method.
        /// </summary>
        public const uint CertificateGroupType_TrustList_GetPosition = 13615;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_SetPosition Method.
        /// </summary>
        public const uint CertificateGroupType_TrustList_SetPosition = 13618;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_OpenWithMasks Method.
        /// </summary>
        public const uint CertificateGroupType_TrustList_OpenWithMasks = 13621;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_Disable Method.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_Disable = 19483;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_Enable Method.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_Enable = 19484;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_AddComment Method.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_AddComment = 19485;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_Acknowledge Method.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_Acknowledge = 19505;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve = 20097;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_ShelvingState_Unshelve = 20099;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve = 20100;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_Disable Method.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_Disable = 20176;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_Enable Method.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_Enable = 20177;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_AddComment Method.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_AddComment = 20178;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_Acknowledge Method.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_Acknowledge = 20198;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve = 20245;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve = 20247;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve = 20248;

        /// <summary>
        /// The identifier for the CertificateGroupType_GetRejectedList Method.
        /// </summary>
        public const uint CertificateGroupType_GetRejectedList = 23526;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open = 13821;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close = 13824;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read = 13826;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write = 13829;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition = 13831;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition = 13834;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks = 13837;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Disable Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Disable = 20324;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Enable Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Enable = 20325;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment = 20326;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge = 20346;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve = 20393;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve = 20395;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve = 20396;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Disable Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Disable = 20474;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Enable Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Enable = 20475;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment = 20476;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge = 20496;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 20543;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve = 20545;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 20546;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open = 13855;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close = 13858;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read = 13860;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write = 13863;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition = 13865;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition = 13868;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks = 13871;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Disable Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Disable = 20622;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Enable Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Enable = 20623;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment = 20624;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge = 20644;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve = 20691;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve = 20693;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve = 20694;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Disable Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Disable = 20770;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Enable Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Enable = 20771;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment = 20772;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge = 20792;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 20839;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve = 20841;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 20842;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open = 13889;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close = 13892;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read = 13894;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write = 13897;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition = 13899;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition = 13902;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks = 13905;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Disable Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Disable = 20918;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Enable Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Enable = 20919;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AddComment Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AddComment = 20920;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Acknowledge Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Acknowledge = 20940;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve = 20987;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve = 20989;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve = 20990;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Disable Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Disable = 21269;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Enable Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Enable = 21270;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AddComment Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AddComment = 21271;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge = 21291;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 21338;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve = 21340;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 21341;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open Method.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open = 13923;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close Method.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close = 13926;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read Method.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read = 13928;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write Method.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write = 13931;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition Method.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition = 13933;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition Method.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition = 13936;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks Method.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks = 13939;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Disable Method.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Disable = 21417;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Enable Method.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Enable = 21418;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AddComment Method.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AddComment = 21419;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Acknowledge Method.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Acknowledge = 21439;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve = 21486;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve = 21488;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve = 21489;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Disable Method.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Disable = 21565;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Enable Method.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Enable = 21566;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AddComment Method.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AddComment = 21567;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Acknowledge Method.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Acknowledge = 21587;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve = 21634;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve = 21636;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve = 21637;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open = 13958;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close = 13961;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read = 13963;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write = 13966;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition = 13968;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition = 13971;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks = 13974;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable = 21713;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable = 21714;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment = 21715;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge = 21735;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve = 21782;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve = 21784;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve = 21785;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable = 21861;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable = 21862;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment = 21863;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge = 21883;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 21930;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve = 21932;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 21933;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open = 13992;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close = 13995;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read = 13997;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write = 14000;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition = 14002;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition = 14005;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks = 14008;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable = 22009;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable = 22010;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment = 22011;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge = 22031;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve = 22078;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve = 22080;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve = 22081;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable = 22157;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable = 22158;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment = 22159;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge = 22179;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 22226;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve = 22228;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 22229;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open = 14026;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close = 14029;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read = 14031;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write = 14034;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition = 14036;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition = 14039;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks = 14042;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable = 22305;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable = 22306;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment = 22307;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge = 22327;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve = 22374;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve = 22376;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve = 22377;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable = 22453;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable = 22454;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment = 22455;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge = 22475;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 22522;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve = 22524;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 22525;

        /// <summary>
        /// The identifier for the ServerConfigurationType_UpdateCertificate Method.
        /// </summary>
        public const uint ServerConfigurationType_UpdateCertificate = 12616;

        /// <summary>
        /// The identifier for the ServerConfigurationType_ApplyChanges Method.
        /// </summary>
        public const uint ServerConfigurationType_ApplyChanges = 12734;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CreateSigningRequest Method.
        /// </summary>
        public const uint ServerConfigurationType_CreateSigningRequest = 12731;

        /// <summary>
        /// The identifier for the ServerConfigurationType_GetRejectedList Method.
        /// </summary>
        public const uint ServerConfigurationType_GetRejectedList = 12775;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open = 12647;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close = 12650;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read = 12652;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write = 12655;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition = 12657;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition = 12660;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks = 12663;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate = 12666;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate = 12668;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate = 12670;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable = 22601;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable = 22602;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment = 22603;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge = 22623;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve = 22670;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve = 22672;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve = 22673;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable = 22749;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable = 22750;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment = 22751;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge = 22771;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 22818;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve = 22820;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 22821;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open = 14095;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close = 14098;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read = 14100;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write = 14103;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition = 14105;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition = 14108;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks = 14111;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate = 14114;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate = 14117;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate = 14119;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable = 22897;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable = 22898;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment = 22899;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge = 22919;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve = 22966;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve = 22968;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve = 22969;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable = 23045;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable = 23046;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment = 23047;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge = 23067;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 23114;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve = 23116;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 23117;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open = 14129;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close = 14132;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read = 14134;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write = 14137;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition = 14139;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition = 14142;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks = 14145;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate = 14148;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate = 14151;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate = 14153;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable = 23193;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable = 23194;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment = 23195;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge = 23215;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve = 23262;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve = 23264;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve = 23265;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable = 23341;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable = 23342;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment = 23343;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge = 23363;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve = 23410;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve = 23412;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve Method.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve = 23413;

        /// <summary>
        /// The identifier for the ServerConfiguration_UpdateCertificate Method.
        /// </summary>
        public const uint ServerConfiguration_UpdateCertificate = 13737;

        /// <summary>
        /// The identifier for the ServerConfiguration_ApplyChanges Method.
        /// </summary>
        public const uint ServerConfiguration_ApplyChanges = 12740;

        /// <summary>
        /// The identifier for the ServerConfiguration_CreateSigningRequest Method.
        /// </summary>
        public const uint ServerConfiguration_CreateSigningRequest = 12737;

        /// <summary>
        /// The identifier for the ServerConfiguration_GetRejectedList Method.
        /// </summary>
        public const uint ServerConfiguration_GetRejectedList = 12777;

        /// <summary>
        /// The identifier for the KeyCredentialConfigurationFolderType_CreateCredential Method.
        /// </summary>
        public const uint KeyCredentialConfigurationFolderType_CreateCredential = 17522;

        /// <summary>
        /// The identifier for the KeyCredentialConfigurationType_GetEncryptingKey Method.
        /// </summary>
        public const uint KeyCredentialConfigurationType_GetEncryptingKey = 17534;

        /// <summary>
        /// The identifier for the KeyCredentialConfigurationType_UpdateCredential Method.
        /// </summary>
        public const uint KeyCredentialConfigurationType_UpdateCredential = 18006;

        /// <summary>
        /// The identifier for the KeyCredentialConfigurationType_DeleteCredential Method.
        /// </summary>
        public const uint KeyCredentialConfigurationType_DeleteCredential = 18008;

        /// <summary>
        /// The identifier for the PubSubKeyServiceType_GetSecurityKeys Method.
        /// </summary>
        public const uint PubSubKeyServiceType_GetSecurityKeys = 15907;

        /// <summary>
        /// The identifier for the PubSubKeyServiceType_GetSecurityGroup Method.
        /// </summary>
        public const uint PubSubKeyServiceType_GetSecurityGroup = 15910;

        /// <summary>
        /// The identifier for the PubSubKeyServiceType_SecurityGroups_AddSecurityGroup Method.
        /// </summary>
        public const uint PubSubKeyServiceType_SecurityGroups_AddSecurityGroup = 15914;

        /// <summary>
        /// The identifier for the PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup Method.
        /// </summary>
        public const uint PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup = 15917;

        /// <summary>
        /// The identifier for the SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup Method.
        /// </summary>
        public const uint SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup = 15454;

        /// <summary>
        /// The identifier for the SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup Method.
        /// </summary>
        public const uint SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup = 15457;

        /// <summary>
        /// The identifier for the SecurityGroupFolderType_AddSecurityGroup Method.
        /// </summary>
        public const uint SecurityGroupFolderType_AddSecurityGroup = 15461;

        /// <summary>
        /// The identifier for the SecurityGroupFolderType_RemoveSecurityGroup Method.
        /// </summary>
        public const uint SecurityGroupFolderType_RemoveSecurityGroup = 15464;

        /// <summary>
        /// The identifier for the PublishSubscribeType_SecurityGroups_AddSecurityGroup Method.
        /// </summary>
        public const uint PublishSubscribeType_SecurityGroups_AddSecurityGroup = 15435;

        /// <summary>
        /// The identifier for the PublishSubscribeType_SecurityGroups_RemoveSecurityGroup Method.
        /// </summary>
        public const uint PublishSubscribeType_SecurityGroups_RemoveSecurityGroup = 15438;

        /// <summary>
        /// The identifier for the PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Reset Method.
        /// </summary>
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Reset = 18679;

        /// <summary>
        /// The identifier for the PublishSubscribeType_SetSecurityKeys Method.
        /// </summary>
        public const uint PublishSubscribeType_SetSecurityKeys = 17296;

        /// <summary>
        /// The identifier for the PublishSubscribeType_AddConnection Method.
        /// </summary>
        public const uint PublishSubscribeType_AddConnection = 16598;

        /// <summary>
        /// The identifier for the PublishSubscribeType_RemoveConnection Method.
        /// </summary>
        public const uint PublishSubscribeType_RemoveConnection = 14432;

        /// <summary>
        /// The identifier for the PublishSubscribeType_Diagnostics_Reset Method.
        /// </summary>
        public const uint PublishSubscribeType_Diagnostics_Reset = 18727;

        /// <summary>
        /// The identifier for the PublishSubscribe_GetSecurityKeys Method.
        /// </summary>
        public const uint PublishSubscribe_GetSecurityKeys = 15215;

        /// <summary>
        /// The identifier for the PublishSubscribe_GetSecurityGroup Method.
        /// </summary>
        public const uint PublishSubscribe_GetSecurityGroup = 15440;

        /// <summary>
        /// The identifier for the PublishSubscribe_SecurityGroups_AddSecurityGroup Method.
        /// </summary>
        public const uint PublishSubscribe_SecurityGroups_AddSecurityGroup = 15444;

        /// <summary>
        /// The identifier for the PublishSubscribe_SecurityGroups_RemoveSecurityGroup Method.
        /// </summary>
        public const uint PublishSubscribe_SecurityGroups_RemoveSecurityGroup = 15447;

        /// <summary>
        /// The identifier for the PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Reset Method.
        /// </summary>
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Reset = 16076;

        /// <summary>
        /// The identifier for the PublishSubscribe_AddConnection Method.
        /// </summary>
        public const uint PublishSubscribe_AddConnection = 17366;

        /// <summary>
        /// The identifier for the PublishSubscribe_RemoveConnection Method.
        /// </summary>
        public const uint PublishSubscribe_RemoveConnection = 17369;

        /// <summary>
        /// The identifier for the PublishSubscribe_Diagnostics_Reset Method.
        /// </summary>
        public const uint PublishSubscribe_Diagnostics_Reset = 17421;

        /// <summary>
        /// The identifier for the PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Reset Method.
        /// </summary>
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Reset = 18883;

        /// <summary>
        /// The identifier for the PublishedDataSetType_ExtensionFields_AddExtensionField Method.
        /// </summary>
        public const uint PublishedDataSetType_ExtensionFields_AddExtensionField = 15482;

        /// <summary>
        /// The identifier for the PublishedDataSetType_ExtensionFields_RemoveExtensionField Method.
        /// </summary>
        public const uint PublishedDataSetType_ExtensionFields_RemoveExtensionField = 15485;

        /// <summary>
        /// The identifier for the ExtensionFieldsType_AddExtensionField Method.
        /// </summary>
        public const uint ExtensionFieldsType_AddExtensionField = 15491;

        /// <summary>
        /// The identifier for the ExtensionFieldsType_RemoveExtensionField Method.
        /// </summary>
        public const uint ExtensionFieldsType_RemoveExtensionField = 15494;

        /// <summary>
        /// The identifier for the PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Reset Method.
        /// </summary>
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Reset = 18942;

        /// <summary>
        /// The identifier for the PublishedDataItemsType_ExtensionFields_AddExtensionField Method.
        /// </summary>
        public const uint PublishedDataItemsType_ExtensionFields_AddExtensionField = 15504;

        /// <summary>
        /// The identifier for the PublishedDataItemsType_ExtensionFields_RemoveExtensionField Method.
        /// </summary>
        public const uint PublishedDataItemsType_ExtensionFields_RemoveExtensionField = 15507;

        /// <summary>
        /// The identifier for the PublishedDataItemsType_AddVariables Method.
        /// </summary>
        public const uint PublishedDataItemsType_AddVariables = 14555;

        /// <summary>
        /// The identifier for the PublishedDataItemsType_RemoveVariables Method.
        /// </summary>
        public const uint PublishedDataItemsType_RemoveVariables = 14558;

        /// <summary>
        /// The identifier for the PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Reset Method.
        /// </summary>
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Reset = 19001;

        /// <summary>
        /// The identifier for the PublishedEventsType_ExtensionFields_AddExtensionField Method.
        /// </summary>
        public const uint PublishedEventsType_ExtensionFields_AddExtensionField = 15512;

        /// <summary>
        /// The identifier for the PublishedEventsType_ExtensionFields_RemoveExtensionField Method.
        /// </summary>
        public const uint PublishedEventsType_ExtensionFields_RemoveExtensionField = 15515;

        /// <summary>
        /// The identifier for the PublishedEventsType_ModifyFieldSelection Method.
        /// </summary>
        public const uint PublishedEventsType_ModifyFieldSelection = 15052;

        /// <summary>
        /// The identifier for the DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems Method.
        /// </summary>
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems = 14479;

        /// <summary>
        /// The identifier for the DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents Method.
        /// </summary>
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents = 14482;

        /// <summary>
        /// The identifier for the DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate Method.
        /// </summary>
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate = 16842;

        /// <summary>
        /// The identifier for the DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate Method.
        /// </summary>
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate = 16881;

        /// <summary>
        /// The identifier for the DataSetFolderType_DataSetFolderName_Placeholder_RemovePublishedDataSet Method.
        /// </summary>
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_RemovePublishedDataSet = 14485;

        /// <summary>
        /// The identifier for the DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder Method.
        /// </summary>
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder = 16884;

        /// <summary>
        /// The identifier for the DataSetFolderType_DataSetFolderName_Placeholder_RemoveDataSetFolder Method.
        /// </summary>
        public const uint DataSetFolderType_DataSetFolderName_Placeholder_RemoveDataSetFolder = 16923;

        /// <summary>
        /// The identifier for the DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField Method.
        /// </summary>
        public const uint DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField = 15474;

        /// <summary>
        /// The identifier for the DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_RemoveExtensionField Method.
        /// </summary>
        public const uint DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_RemoveExtensionField = 15477;

        /// <summary>
        /// The identifier for the DataSetFolderType_AddPublishedDataItems Method.
        /// </summary>
        public const uint DataSetFolderType_AddPublishedDataItems = 14493;

        /// <summary>
        /// The identifier for the DataSetFolderType_AddPublishedEvents Method.
        /// </summary>
        public const uint DataSetFolderType_AddPublishedEvents = 14496;

        /// <summary>
        /// The identifier for the DataSetFolderType_AddPublishedDataItemsTemplate Method.
        /// </summary>
        public const uint DataSetFolderType_AddPublishedDataItemsTemplate = 16935;

        /// <summary>
        /// The identifier for the DataSetFolderType_AddPublishedEventsTemplate Method.
        /// </summary>
        public const uint DataSetFolderType_AddPublishedEventsTemplate = 16960;

        /// <summary>
        /// The identifier for the DataSetFolderType_RemovePublishedDataSet Method.
        /// </summary>
        public const uint DataSetFolderType_RemovePublishedDataSet = 14499;

        /// <summary>
        /// The identifier for the DataSetFolderType_AddDataSetFolder Method.
        /// </summary>
        public const uint DataSetFolderType_AddDataSetFolder = 16994;

        /// <summary>
        /// The identifier for the DataSetFolderType_RemoveDataSetFolder Method.
        /// </summary>
        public const uint DataSetFolderType_RemoveDataSetFolder = 16997;

        /// <summary>
        /// The identifier for the PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Reset Method.
        /// </summary>
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Reset = 19119;

        /// <summary>
        /// The identifier for the PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Reset Method.
        /// </summary>
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Reset = 19188;

        /// <summary>
        /// The identifier for the PubSubConnectionType_Diagnostics_Reset Method.
        /// </summary>
        public const uint PubSubConnectionType_Diagnostics_Reset = 19253;

        /// <summary>
        /// The identifier for the PubSubConnectionType_AddWriterGroup Method.
        /// </summary>
        public const uint PubSubConnectionType_AddWriterGroup = 17427;

        /// <summary>
        /// The identifier for the PubSubConnectionType_AddReaderGroup Method.
        /// </summary>
        public const uint PubSubConnectionType_AddReaderGroup = 17465;

        /// <summary>
        /// The identifier for the PubSubConnectionType_RemoveGroup Method.
        /// </summary>
        public const uint PubSubConnectionType_RemoveGroup = 14225;

        /// <summary>
        /// The identifier for the WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Reset Method.
        /// </summary>
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Reset = 17765;

        /// <summary>
        /// The identifier for the WriterGroupType_Diagnostics_Reset Method.
        /// </summary>
        public const uint WriterGroupType_Diagnostics_Reset = 17824;

        /// <summary>
        /// The identifier for the WriterGroupType_AddDataSetWriter Method.
        /// </summary>
        public const uint WriterGroupType_AddDataSetWriter = 17969;

        /// <summary>
        /// The identifier for the WriterGroupType_RemoveDataSetWriter Method.
        /// </summary>
        public const uint WriterGroupType_RemoveDataSetWriter = 17992;

        /// <summary>
        /// The identifier for the ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Reset Method.
        /// </summary>
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Reset = 18104;

        /// <summary>
        /// The identifier for the ReaderGroupType_Diagnostics_Reset Method.
        /// </summary>
        public const uint ReaderGroupType_Diagnostics_Reset = 21027;

        /// <summary>
        /// The identifier for the ReaderGroupType_AddDataSetReader Method.
        /// </summary>
        public const uint ReaderGroupType_AddDataSetReader = 21082;

        /// <summary>
        /// The identifier for the ReaderGroupType_RemoveDataSetReader Method.
        /// </summary>
        public const uint ReaderGroupType_RemoveDataSetReader = 21085;

        /// <summary>
        /// The identifier for the DataSetWriterType_Diagnostics_Reset Method.
        /// </summary>
        public const uint DataSetWriterType_Diagnostics_Reset = 19562;

        /// <summary>
        /// The identifier for the DataSetReaderType_Diagnostics_Reset Method.
        /// </summary>
        public const uint DataSetReaderType_Diagnostics_Reset = 19621;

        /// <summary>
        /// The identifier for the DataSetReaderType_CreateTargetVariables Method.
        /// </summary>
        public const uint DataSetReaderType_CreateTargetVariables = 17386;

        /// <summary>
        /// The identifier for the DataSetReaderType_CreateDataSetMirror Method.
        /// </summary>
        public const uint DataSetReaderType_CreateDataSetMirror = 17389;

        /// <summary>
        /// The identifier for the TargetVariablesType_AddTargetVariables Method.
        /// </summary>
        public const uint TargetVariablesType_AddTargetVariables = 15115;

        /// <summary>
        /// The identifier for the TargetVariablesType_RemoveTargetVariables Method.
        /// </summary>
        public const uint TargetVariablesType_RemoveTargetVariables = 15118;

        /// <summary>
        /// The identifier for the PubSubStatusType_Enable Method.
        /// </summary>
        public const uint PubSubStatusType_Enable = 14645;

        /// <summary>
        /// The identifier for the PubSubStatusType_Disable Method.
        /// </summary>
        public const uint PubSubStatusType_Disable = 14646;

        /// <summary>
        /// The identifier for the PubSubDiagnosticsType_Reset Method.
        /// </summary>
        public const uint PubSubDiagnosticsType_Reset = 19689;

        /// <summary>
        /// The identifier for the AliasNameCategoryType_SubAliasNameCategories_Placeholder_FindAlias Method.
        /// </summary>
        public const uint AliasNameCategoryType_SubAliasNameCategories_Placeholder_FindAlias = 23459;

        /// <summary>
        /// The identifier for the AliasNameCategoryType_FindAlias Method.
        /// </summary>
        public const uint AliasNameCategoryType_FindAlias = 23462;

        /// <summary>
        /// The identifier for the Aliases_SubAliasNameCategories_Placeholder_FindAlias Method.
        /// </summary>
        public const uint Aliases_SubAliasNameCategories_Placeholder_FindAlias = 23473;

        /// <summary>
        /// The identifier for the Aliases_FindAlias Method.
        /// </summary>
        public const uint Aliases_FindAlias = 23476;

        /// <summary>
        /// The identifier for the TagVariables_SubAliasNameCategories_Placeholder_FindAlias Method.
        /// </summary>
        public const uint TagVariables_SubAliasNameCategories_Placeholder_FindAlias = 23482;

        /// <summary>
        /// The identifier for the TagVariables_FindAlias Method.
        /// </summary>
        public const uint TagVariables_FindAlias = 23485;

        /// <summary>
        /// The identifier for the Topics_SubAliasNameCategories_Placeholder_FindAlias Method.
        /// </summary>
        public const uint Topics_SubAliasNameCategories_Placeholder_FindAlias = 23491;

        /// <summary>
        /// The identifier for the Topics_FindAlias Method.
        /// </summary>
        public const uint Topics_FindAlias = 23494;
    }
    #endregion

    #region Object Identifiers
    /// <summary>
    /// A class that declares constants for all Objects in the Model Design.
    /// </summary>
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class Objects
    {
        /// <summary>
        /// The identifier for the DefaultBinary Object.
        /// </summary>
        public const uint DefaultBinary = 3062;

        /// <summary>
        /// The identifier for the DefaultXml Object.
        /// </summary>
        public const uint DefaultXml = 3063;

        /// <summary>
        /// The identifier for the ModellingRule_Mandatory Object.
        /// </summary>
        public const uint ModellingRule_Mandatory = 78;

        /// <summary>
        /// The identifier for the ModellingRule_Optional Object.
        /// </summary>
        public const uint ModellingRule_Optional = 80;

        /// <summary>
        /// The identifier for the ModellingRule_ExposesItsArray Object.
        /// </summary>
        public const uint ModellingRule_ExposesItsArray = 83;

        /// <summary>
        /// The identifier for the ModellingRule_OptionalPlaceholder Object.
        /// </summary>
        public const uint ModellingRule_OptionalPlaceholder = 11508;

        /// <summary>
        /// The identifier for the ModellingRule_MandatoryPlaceholder Object.
        /// </summary>
        public const uint ModellingRule_MandatoryPlaceholder = 11510;

        /// <summary>
        /// The identifier for the RootFolder Object.
        /// </summary>
        public const uint RootFolder = 84;

        /// <summary>
        /// The identifier for the ObjectsFolder Object.
        /// </summary>
        public const uint ObjectsFolder = 85;

        /// <summary>
        /// The identifier for the TypesFolder Object.
        /// </summary>
        public const uint TypesFolder = 86;

        /// <summary>
        /// The identifier for the ViewsFolder Object.
        /// </summary>
        public const uint ViewsFolder = 87;

        /// <summary>
        /// The identifier for the ObjectTypesFolder Object.
        /// </summary>
        public const uint ObjectTypesFolder = 88;

        /// <summary>
        /// The identifier for the VariableTypesFolder Object.
        /// </summary>
        public const uint VariableTypesFolder = 89;

        /// <summary>
        /// The identifier for the DataTypesFolder Object.
        /// </summary>
        public const uint DataTypesFolder = 90;

        /// <summary>
        /// The identifier for the ReferenceTypesFolder Object.
        /// </summary>
        public const uint ReferenceTypesFolder = 91;

        /// <summary>
        /// The identifier for the XmlSchema_TypeSystem Object.
        /// </summary>
        public const uint XmlSchema_TypeSystem = 92;

        /// <summary>
        /// The identifier for the OPCBinarySchema_TypeSystem Object.
        /// </summary>
        public const uint OPCBinarySchema_TypeSystem = 93;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata Object.
        /// </summary>
        public const uint OPCUANamespaceMetadata = 15957;

        /// <summary>
        /// The identifier for the ServerType_ServerCapabilities Object.
        /// </summary>
        public const uint ServerType_ServerCapabilities = 2009;

        /// <summary>
        /// The identifier for the ServerType_ServerCapabilities_ModellingRules Object.
        /// </summary>
        public const uint ServerType_ServerCapabilities_ModellingRules = 3093;

        /// <summary>
        /// The identifier for the ServerType_ServerCapabilities_AggregateFunctions Object.
        /// </summary>
        public const uint ServerType_ServerCapabilities_AggregateFunctions = 3094;

        /// <summary>
        /// The identifier for the ServerType_ServerDiagnostics Object.
        /// </summary>
        public const uint ServerType_ServerDiagnostics = 2010;

        /// <summary>
        /// The identifier for the ServerType_ServerDiagnostics_SessionsDiagnosticsSummary Object.
        /// </summary>
        public const uint ServerType_ServerDiagnostics_SessionsDiagnosticsSummary = 3111;

        /// <summary>
        /// The identifier for the ServerType_VendorServerInfo Object.
        /// </summary>
        public const uint ServerType_VendorServerInfo = 2011;

        /// <summary>
        /// The identifier for the ServerType_ServerRedundancy Object.
        /// </summary>
        public const uint ServerType_ServerRedundancy = 2012;

        /// <summary>
        /// The identifier for the ServerType_Namespaces Object.
        /// </summary>
        public const uint ServerType_Namespaces = 11527;

        /// <summary>
        /// The identifier for the ServerCapabilitiesType_OperationLimits Object.
        /// </summary>
        public const uint ServerCapabilitiesType_OperationLimits = 11551;

        /// <summary>
        /// The identifier for the ServerCapabilitiesType_ModellingRules Object.
        /// </summary>
        public const uint ServerCapabilitiesType_ModellingRules = 2019;

        /// <summary>
        /// The identifier for the ServerCapabilitiesType_AggregateFunctions Object.
        /// </summary>
        public const uint ServerCapabilitiesType_AggregateFunctions = 2754;

        /// <summary>
        /// The identifier for the ServerCapabilitiesType_RoleSet Object.
        /// </summary>
        public const uint ServerCapabilitiesType_RoleSet = 16295;

        /// <summary>
        /// The identifier for the ServerDiagnosticsType_SessionsDiagnosticsSummary Object.
        /// </summary>
        public const uint ServerDiagnosticsType_SessionsDiagnosticsSummary = 2744;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder Object.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder = 12097;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceFile Object.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceFile = 11624;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder Object.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder = 11646;

        /// <summary>
        /// The identifier for the EventTypesFolder Object.
        /// </summary>
        public const uint EventTypesFolder = 3048;

        /// <summary>
        /// The identifier for the Server Object.
        /// </summary>
        public const uint Server = 2253;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities Object.
        /// </summary>
        public const uint Server_ServerCapabilities = 2268;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_OperationLimits Object.
        /// </summary>
        public const uint Server_ServerCapabilities_OperationLimits = 11704;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_ModellingRules Object.
        /// </summary>
        public const uint Server_ServerCapabilities_ModellingRules = 2996;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_AggregateFunctions Object.
        /// </summary>
        public const uint Server_ServerCapabilities_AggregateFunctions = 2997;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_RoleSet Object.
        /// </summary>
        public const uint Server_ServerCapabilities_RoleSet = 15606;

        /// <summary>
        /// The identifier for the Server_ServerDiagnostics Object.
        /// </summary>
        public const uint Server_ServerDiagnostics = 2274;

        /// <summary>
        /// The identifier for the Server_ServerDiagnostics_SessionsDiagnosticsSummary Object.
        /// </summary>
        public const uint Server_ServerDiagnostics_SessionsDiagnosticsSummary = 3706;

        /// <summary>
        /// The identifier for the Server_VendorServerInfo Object.
        /// </summary>
        public const uint Server_VendorServerInfo = 2295;

        /// <summary>
        /// The identifier for the Server_ServerRedundancy Object.
        /// </summary>
        public const uint Server_ServerRedundancy = 2296;

        /// <summary>
        /// The identifier for the Server_Namespaces Object.
        /// </summary>
        public const uint Server_Namespaces = 11715;

        /// <summary>
        /// The identifier for the HistoryServerCapabilities Object.
        /// </summary>
        public const uint HistoryServerCapabilities = 11192;

        /// <summary>
        /// The identifier for the HistoryServerCapabilities_AggregateFunctions Object.
        /// </summary>
        public const uint HistoryServerCapabilities_AggregateFunctions = 11201;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileDirectoryName_Placeholder Object.
        /// </summary>
        public const uint FileDirectoryType_FileDirectoryName_Placeholder = 13354;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileName_Placeholder Object.
        /// </summary>
        public const uint FileDirectoryType_FileName_Placeholder = 13366;

        /// <summary>
        /// The identifier for the FileSystem Object.
        /// </summary>
        public const uint FileSystem = 16314;

        /// <summary>
        /// The identifier for the TemporaryFileTransferType_TransferState_Placeholder Object.
        /// </summary>
        public const uint TemporaryFileTransferType_TransferState_Placeholder = 15754;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_Idle Object.
        /// </summary>
        public const uint FileTransferStateMachineType_Idle = 15815;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_ReadPrepare Object.
        /// </summary>
        public const uint FileTransferStateMachineType_ReadPrepare = 15817;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_ReadTransfer Object.
        /// </summary>
        public const uint FileTransferStateMachineType_ReadTransfer = 15819;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_ApplyWrite Object.
        /// </summary>
        public const uint FileTransferStateMachineType_ApplyWrite = 15821;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_Error Object.
        /// </summary>
        public const uint FileTransferStateMachineType_Error = 15823;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_IdleToReadPrepare Object.
        /// </summary>
        public const uint FileTransferStateMachineType_IdleToReadPrepare = 15825;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_ReadPrepareToReadTransfer Object.
        /// </summary>
        public const uint FileTransferStateMachineType_ReadPrepareToReadTransfer = 15827;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_ReadTransferToIdle Object.
        /// </summary>
        public const uint FileTransferStateMachineType_ReadTransferToIdle = 15829;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_IdleToApplyWrite Object.
        /// </summary>
        public const uint FileTransferStateMachineType_IdleToApplyWrite = 15831;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_ApplyWriteToIdle Object.
        /// </summary>
        public const uint FileTransferStateMachineType_ApplyWriteToIdle = 15833;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_ReadPrepareToError Object.
        /// </summary>
        public const uint FileTransferStateMachineType_ReadPrepareToError = 15835;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_ReadTransferToError Object.
        /// </summary>
        public const uint FileTransferStateMachineType_ReadTransferToError = 15837;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_ApplyWriteToError Object.
        /// </summary>
        public const uint FileTransferStateMachineType_ApplyWriteToError = 15839;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_ErrorToIdle Object.
        /// </summary>
        public const uint FileTransferStateMachineType_ErrorToIdle = 15841;

        /// <summary>
        /// The identifier for the RoleSetType_RoleName_Placeholder Object.
        /// </summary>
        public const uint RoleSetType_RoleName_Placeholder = 15608;

        /// <summary>
        /// The identifier for the WellKnownRole_Anonymous Object.
        /// </summary>
        public const uint WellKnownRole_Anonymous = 15644;

        /// <summary>
        /// The identifier for the WellKnownRole_AuthenticatedUser Object.
        /// </summary>
        public const uint WellKnownRole_AuthenticatedUser = 15656;

        /// <summary>
        /// The identifier for the WellKnownRole_Observer Object.
        /// </summary>
        public const uint WellKnownRole_Observer = 15668;

        /// <summary>
        /// The identifier for the WellKnownRole_Operator Object.
        /// </summary>
        public const uint WellKnownRole_Operator = 15680;

        /// <summary>
        /// The identifier for the WellKnownRole_Engineer Object.
        /// </summary>
        public const uint WellKnownRole_Engineer = 16036;

        /// <summary>
        /// The identifier for the WellKnownRole_Supervisor Object.
        /// </summary>
        public const uint WellKnownRole_Supervisor = 15692;

        /// <summary>
        /// The identifier for the WellKnownRole_ConfigureAdmin Object.
        /// </summary>
        public const uint WellKnownRole_ConfigureAdmin = 15716;

        /// <summary>
        /// The identifier for the WellKnownRole_SecurityAdmin Object.
        /// </summary>
        public const uint WellKnownRole_SecurityAdmin = 15704;

        /// <summary>
        /// The identifier for the DictionaryEntryType_DictionaryEntryName_Placeholder Object.
        /// </summary>
        public const uint DictionaryEntryType_DictionaryEntryName_Placeholder = 17590;

        /// <summary>
        /// The identifier for the DictionaryFolderType_DictionaryFolderName_Placeholder Object.
        /// </summary>
        public const uint DictionaryFolderType_DictionaryFolderName_Placeholder = 17592;

        /// <summary>
        /// The identifier for the DictionaryFolderType_DictionaryEntryName_Placeholder Object.
        /// </summary>
        public const uint DictionaryFolderType_DictionaryEntryName_Placeholder = 17593;

        /// <summary>
        /// The identifier for the Dictionaries Object.
        /// </summary>
        public const uint Dictionaries = 17594;

        /// <summary>
        /// The identifier for the InterfaceTypes Object.
        /// </summary>
        public const uint InterfaceTypes = 17708;

        /// <summary>
        /// The identifier for the OrderedListType_OrderedObject_Placeholder Object.
        /// </summary>
        public const uint OrderedListType_OrderedObject_Placeholder = 23519;

        /// <summary>
        /// The identifier for the AlarmConditionType_ShelvingState Object.
        /// </summary>
        public const uint AlarmConditionType_ShelvingState = 9178;

        /// <summary>
        /// The identifier for the AlarmConditionType_FirstInGroup Object.
        /// </summary>
        public const uint AlarmConditionType_FirstInGroup = 16398;

        /// <summary>
        /// The identifier for the AlarmConditionType_AlarmGroup_Placeholder Object.
        /// </summary>
        public const uint AlarmConditionType_AlarmGroup_Placeholder = 16399;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder Object.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder = 16406;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_Unshelved Object.
        /// </summary>
        public const uint ShelvedStateMachineType_Unshelved = 2930;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_TimedShelved Object.
        /// </summary>
        public const uint ShelvedStateMachineType_TimedShelved = 2932;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_OneShotShelved Object.
        /// </summary>
        public const uint ShelvedStateMachineType_OneShotShelved = 2933;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_UnshelvedToTimedShelved Object.
        /// </summary>
        public const uint ShelvedStateMachineType_UnshelvedToTimedShelved = 2935;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_UnshelvedToOneShotShelved Object.
        /// </summary>
        public const uint ShelvedStateMachineType_UnshelvedToOneShotShelved = 2936;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_TimedShelvedToUnshelved Object.
        /// </summary>
        public const uint ShelvedStateMachineType_TimedShelvedToUnshelved = 2940;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_TimedShelvedToOneShotShelved Object.
        /// </summary>
        public const uint ShelvedStateMachineType_TimedShelvedToOneShotShelved = 2942;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_OneShotShelvedToUnshelved Object.
        /// </summary>
        public const uint ShelvedStateMachineType_OneShotShelvedToUnshelved = 2943;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_OneShotShelvedToTimedShelved Object.
        /// </summary>
        public const uint ShelvedStateMachineType_OneShotShelvedToTimedShelved = 2945;

        /// <summary>
        /// The identifier for the ExclusiveLimitStateMachineType_HighHigh Object.
        /// </summary>
        public const uint ExclusiveLimitStateMachineType_HighHigh = 9329;

        /// <summary>
        /// The identifier for the ExclusiveLimitStateMachineType_High Object.
        /// </summary>
        public const uint ExclusiveLimitStateMachineType_High = 9331;

        /// <summary>
        /// The identifier for the ExclusiveLimitStateMachineType_Low Object.
        /// </summary>
        public const uint ExclusiveLimitStateMachineType_Low = 9333;

        /// <summary>
        /// The identifier for the ExclusiveLimitStateMachineType_LowLow Object.
        /// </summary>
        public const uint ExclusiveLimitStateMachineType_LowLow = 9335;

        /// <summary>
        /// The identifier for the ExclusiveLimitStateMachineType_LowLowToLow Object.
        /// </summary>
        public const uint ExclusiveLimitStateMachineType_LowLowToLow = 9337;

        /// <summary>
        /// The identifier for the ExclusiveLimitStateMachineType_LowToLowLow Object.
        /// </summary>
        public const uint ExclusiveLimitStateMachineType_LowToLowLow = 9338;

        /// <summary>
        /// The identifier for the ExclusiveLimitStateMachineType_HighHighToHigh Object.
        /// </summary>
        public const uint ExclusiveLimitStateMachineType_HighHighToHigh = 9339;

        /// <summary>
        /// The identifier for the ExclusiveLimitStateMachineType_HighToHighHigh Object.
        /// </summary>
        public const uint ExclusiveLimitStateMachineType_HighToHighHigh = 9340;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_LimitState Object.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_LimitState = 9455;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_FinalResultData Object.
        /// </summary>
        public const uint ProgramStateMachineType_FinalResultData = 3850;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_Halted Object.
        /// </summary>
        public const uint ProgramStateMachineType_Halted = 2406;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_Ready Object.
        /// </summary>
        public const uint ProgramStateMachineType_Ready = 2400;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_Running Object.
        /// </summary>
        public const uint ProgramStateMachineType_Running = 2402;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_Suspended Object.
        /// </summary>
        public const uint ProgramStateMachineType_Suspended = 2404;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_HaltedToReady Object.
        /// </summary>
        public const uint ProgramStateMachineType_HaltedToReady = 2408;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_ReadyToRunning Object.
        /// </summary>
        public const uint ProgramStateMachineType_ReadyToRunning = 2410;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_RunningToHalted Object.
        /// </summary>
        public const uint ProgramStateMachineType_RunningToHalted = 2412;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_RunningToReady Object.
        /// </summary>
        public const uint ProgramStateMachineType_RunningToReady = 2414;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_RunningToSuspended Object.
        /// </summary>
        public const uint ProgramStateMachineType_RunningToSuspended = 2416;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_SuspendedToRunning Object.
        /// </summary>
        public const uint ProgramStateMachineType_SuspendedToRunning = 2418;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_SuspendedToHalted Object.
        /// </summary>
        public const uint ProgramStateMachineType_SuspendedToHalted = 2420;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_SuspendedToReady Object.
        /// </summary>
        public const uint ProgramStateMachineType_SuspendedToReady = 2422;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_ReadyToHalted Object.
        /// </summary>
        public const uint ProgramStateMachineType_ReadyToHalted = 2424;

        /// <summary>
        /// The identifier for the HistoricalDataConfigurationType_AggregateConfiguration Object.
        /// </summary>
        public const uint HistoricalDataConfigurationType_AggregateConfiguration = 3059;

        /// <summary>
        /// The identifier for the HistoricalDataConfigurationType_AggregateFunctions Object.
        /// </summary>
        public const uint HistoricalDataConfigurationType_AggregateFunctions = 11876;

        /// <summary>
        /// The identifier for the HAConfiguration Object.
        /// </summary>
        public const uint HAConfiguration = 11202;

        /// <summary>
        /// The identifier for the HAConfiguration_AggregateConfiguration Object.
        /// </summary>
        public const uint HAConfiguration_AggregateConfiguration = 11203;

        /// <summary>
        /// The identifier for the HistoryServerCapabilitiesType_AggregateFunctions Object.
        /// </summary>
        public const uint HistoryServerCapabilitiesType_AggregateFunctions = 11172;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList Object.
        /// </summary>
        public const uint CertificateGroupType_TrustList = 13599;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired Object.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired = 19450;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate Object.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate = 20143;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup Object.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup = 13814;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList Object.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList = 13815;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup Object.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup = 13848;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList Object.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList = 13849;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup Object.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup = 13882;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList Object.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList = 13883;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder Object.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder = 13916;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList Object.
        /// </summary>
        public const uint CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList = 13917;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups Object.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups = 13950;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup Object.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup = 13951;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList Object.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList = 13952;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList Object.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList = 13986;

        /// <summary>
        /// The identifier for the ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList Object.
        /// </summary>
        public const uint ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList = 14020;

        /// <summary>
        /// The identifier for the ServerConfiguration Object.
        /// </summary>
        public const uint ServerConfiguration = 12637;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups Object.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups = 14053;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup Object.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup = 14156;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList Object.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList = 12642;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup Object.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup = 14088;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList Object.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList = 14089;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup Object.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup = 14122;

        /// <summary>
        /// The identifier for the ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList Object.
        /// </summary>
        public const uint ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList = 14123;

        /// <summary>
        /// The identifier for the KeyCredentialConfigurationFolderType_ServiceName_Placeholder Object.
        /// </summary>
        public const uint KeyCredentialConfigurationFolderType_ServiceName_Placeholder = 17511;

        /// <summary>
        /// The identifier for the KeyCredentialConfiguration Object.
        /// </summary>
        public const uint KeyCredentialConfiguration = 18155;

        /// <summary>
        /// The identifier for the AuthorizationServicesConfigurationFolderType_ServiceName_Placeholder Object.
        /// </summary>
        public const uint AuthorizationServicesConfigurationFolderType_ServiceName_Placeholder = 23557;

        /// <summary>
        /// The identifier for the AuthorizationServices Object.
        /// </summary>
        public const uint AuthorizationServices = 17732;

        /// <summary>
        /// The identifier for the AggregateFunction_Interpolative Object.
        /// </summary>
        public const uint AggregateFunction_Interpolative = 2341;

        /// <summary>
        /// The identifier for the AggregateFunction_Average Object.
        /// </summary>
        public const uint AggregateFunction_Average = 2342;

        /// <summary>
        /// The identifier for the AggregateFunction_TimeAverage Object.
        /// </summary>
        public const uint AggregateFunction_TimeAverage = 2343;

        /// <summary>
        /// The identifier for the AggregateFunction_TimeAverage2 Object.
        /// </summary>
        public const uint AggregateFunction_TimeAverage2 = 11285;

        /// <summary>
        /// The identifier for the AggregateFunction_Total Object.
        /// </summary>
        public const uint AggregateFunction_Total = 2344;

        /// <summary>
        /// The identifier for the AggregateFunction_Total2 Object.
        /// </summary>
        public const uint AggregateFunction_Total2 = 11304;

        /// <summary>
        /// The identifier for the AggregateFunction_Minimum Object.
        /// </summary>
        public const uint AggregateFunction_Minimum = 2346;

        /// <summary>
        /// The identifier for the AggregateFunction_Maximum Object.
        /// </summary>
        public const uint AggregateFunction_Maximum = 2347;

        /// <summary>
        /// The identifier for the AggregateFunction_MinimumActualTime Object.
        /// </summary>
        public const uint AggregateFunction_MinimumActualTime = 2348;

        /// <summary>
        /// The identifier for the AggregateFunction_MaximumActualTime Object.
        /// </summary>
        public const uint AggregateFunction_MaximumActualTime = 2349;

        /// <summary>
        /// The identifier for the AggregateFunction_Range Object.
        /// </summary>
        public const uint AggregateFunction_Range = 2350;

        /// <summary>
        /// The identifier for the AggregateFunction_Minimum2 Object.
        /// </summary>
        public const uint AggregateFunction_Minimum2 = 11286;

        /// <summary>
        /// The identifier for the AggregateFunction_Maximum2 Object.
        /// </summary>
        public const uint AggregateFunction_Maximum2 = 11287;

        /// <summary>
        /// The identifier for the AggregateFunction_MinimumActualTime2 Object.
        /// </summary>
        public const uint AggregateFunction_MinimumActualTime2 = 11305;

        /// <summary>
        /// The identifier for the AggregateFunction_MaximumActualTime2 Object.
        /// </summary>
        public const uint AggregateFunction_MaximumActualTime2 = 11306;

        /// <summary>
        /// The identifier for the AggregateFunction_Range2 Object.
        /// </summary>
        public const uint AggregateFunction_Range2 = 11288;

        /// <summary>
        /// The identifier for the AggregateFunction_AnnotationCount Object.
        /// </summary>
        public const uint AggregateFunction_AnnotationCount = 2351;

        /// <summary>
        /// The identifier for the AggregateFunction_Count Object.
        /// </summary>
        public const uint AggregateFunction_Count = 2352;

        /// <summary>
        /// The identifier for the AggregateFunction_DurationInStateZero Object.
        /// </summary>
        public const uint AggregateFunction_DurationInStateZero = 11307;

        /// <summary>
        /// The identifier for the AggregateFunction_DurationInStateNonZero Object.
        /// </summary>
        public const uint AggregateFunction_DurationInStateNonZero = 11308;

        /// <summary>
        /// The identifier for the AggregateFunction_NumberOfTransitions Object.
        /// </summary>
        public const uint AggregateFunction_NumberOfTransitions = 2355;

        /// <summary>
        /// The identifier for the AggregateFunction_Start Object.
        /// </summary>
        public const uint AggregateFunction_Start = 2357;

        /// <summary>
        /// The identifier for the AggregateFunction_End Object.
        /// </summary>
        public const uint AggregateFunction_End = 2358;

        /// <summary>
        /// The identifier for the AggregateFunction_Delta Object.
        /// </summary>
        public const uint AggregateFunction_Delta = 2359;

        /// <summary>
        /// The identifier for the AggregateFunction_StartBound Object.
        /// </summary>
        public const uint AggregateFunction_StartBound = 11505;

        /// <summary>
        /// The identifier for the AggregateFunction_EndBound Object.
        /// </summary>
        public const uint AggregateFunction_EndBound = 11506;

        /// <summary>
        /// The identifier for the AggregateFunction_DeltaBounds Object.
        /// </summary>
        public const uint AggregateFunction_DeltaBounds = 11507;

        /// <summary>
        /// The identifier for the AggregateFunction_DurationGood Object.
        /// </summary>
        public const uint AggregateFunction_DurationGood = 2360;

        /// <summary>
        /// The identifier for the AggregateFunction_DurationBad Object.
        /// </summary>
        public const uint AggregateFunction_DurationBad = 2361;

        /// <summary>
        /// The identifier for the AggregateFunction_PercentGood Object.
        /// </summary>
        public const uint AggregateFunction_PercentGood = 2362;

        /// <summary>
        /// The identifier for the AggregateFunction_PercentBad Object.
        /// </summary>
        public const uint AggregateFunction_PercentBad = 2363;

        /// <summary>
        /// The identifier for the AggregateFunction_WorstQuality Object.
        /// </summary>
        public const uint AggregateFunction_WorstQuality = 2364;

        /// <summary>
        /// The identifier for the AggregateFunction_WorstQuality2 Object.
        /// </summary>
        public const uint AggregateFunction_WorstQuality2 = 11292;

        /// <summary>
        /// The identifier for the AggregateFunction_StandardDeviationSample Object.
        /// </summary>
        public const uint AggregateFunction_StandardDeviationSample = 11426;

        /// <summary>
        /// The identifier for the AggregateFunction_StandardDeviationPopulation Object.
        /// </summary>
        public const uint AggregateFunction_StandardDeviationPopulation = 11427;

        /// <summary>
        /// The identifier for the AggregateFunction_VarianceSample Object.
        /// </summary>
        public const uint AggregateFunction_VarianceSample = 11428;

        /// <summary>
        /// The identifier for the AggregateFunction_VariancePopulation Object.
        /// </summary>
        public const uint AggregateFunction_VariancePopulation = 11429;

        /// <summary>
        /// The identifier for the PubSubKeyServiceType_SecurityGroups Object.
        /// </summary>
        public const uint PubSubKeyServiceType_SecurityGroups = 15913;

        /// <summary>
        /// The identifier for the SecurityGroupFolderType_SecurityGroupFolderName_Placeholder Object.
        /// </summary>
        public const uint SecurityGroupFolderType_SecurityGroupFolderName_Placeholder = 15453;

        /// <summary>
        /// The identifier for the SecurityGroupFolderType_SecurityGroupName_Placeholder Object.
        /// </summary>
        public const uint SecurityGroupFolderType_SecurityGroupName_Placeholder = 15459;

        /// <summary>
        /// The identifier for the PublishSubscribeType_ConnectionName_Placeholder Object.
        /// </summary>
        public const uint PublishSubscribeType_ConnectionName_Placeholder = 14417;

        /// <summary>
        /// The identifier for the PublishSubscribeType_ConnectionName_Placeholder_Address Object.
        /// </summary>
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Address = 14423;

        /// <summary>
        /// The identifier for the PublishSubscribeType_ConnectionName_Placeholder_Status Object.
        /// </summary>
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Status = 14419;

        /// <summary>
        /// The identifier for the PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters Object.
        /// </summary>
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters = 18681;

        /// <summary>
        /// The identifier for the PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues Object.
        /// </summary>
        public const uint PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues = 18712;

        /// <summary>
        /// The identifier for the PublishSubscribeType_PublishedDataSets Object.
        /// </summary>
        public const uint PublishSubscribeType_PublishedDataSets = 14434;

        /// <summary>
        /// The identifier for the PublishSubscribeType_Status Object.
        /// </summary>
        public const uint PublishSubscribeType_Status = 15844;

        /// <summary>
        /// The identifier for the PublishSubscribeType_Diagnostics Object.
        /// </summary>
        public const uint PublishSubscribeType_Diagnostics = 18715;

        /// <summary>
        /// The identifier for the PublishSubscribeType_Diagnostics_Counters Object.
        /// </summary>
        public const uint PublishSubscribeType_Diagnostics_Counters = 18729;

        /// <summary>
        /// The identifier for the PublishSubscribeType_Diagnostics_LiveValues Object.
        /// </summary>
        public const uint PublishSubscribeType_Diagnostics_LiveValues = 18760;

        /// <summary>
        /// The identifier for the PublishSubscribe Object.
        /// </summary>
        public const uint PublishSubscribe = 14443;

        /// <summary>
        /// The identifier for the PublishSubscribe_SecurityGroups Object.
        /// </summary>
        public const uint PublishSubscribe_SecurityGroups = 15443;

        /// <summary>
        /// The identifier for the PublishSubscribe_ConnectionName_Placeholder_Address Object.
        /// </summary>
        public const uint PublishSubscribe_ConnectionName_Placeholder_Address = 15851;

        /// <summary>
        /// The identifier for the PublishSubscribe_ConnectionName_Placeholder_Status Object.
        /// </summary>
        public const uint PublishSubscribe_ConnectionName_Placeholder_Status = 15865;

        /// <summary>
        /// The identifier for the PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters Object.
        /// </summary>
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters = 16102;

        /// <summary>
        /// The identifier for the PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues Object.
        /// </summary>
        public const uint PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues = 17352;

        /// <summary>
        /// The identifier for the PublishSubscribe_PublishedDataSets Object.
        /// </summary>
        public const uint PublishSubscribe_PublishedDataSets = 17371;

        /// <summary>
        /// The identifier for the PublishSubscribe_Status Object.
        /// </summary>
        public const uint PublishSubscribe_Status = 17405;

        /// <summary>
        /// The identifier for the PublishSubscribe_Diagnostics Object.
        /// </summary>
        public const uint PublishSubscribe_Diagnostics = 17409;

        /// <summary>
        /// The identifier for the PublishSubscribe_Diagnostics_Counters Object.
        /// </summary>
        public const uint PublishSubscribe_Diagnostics_Counters = 17423;

        /// <summary>
        /// The identifier for the PublishSubscribe_Diagnostics_LiveValues Object.
        /// </summary>
        public const uint PublishSubscribe_Diagnostics_LiveValues = 17457;

        /// <summary>
        /// The identifier for the PublishedDataSetType_DataSetWriterName_Placeholder Object.
        /// </summary>
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder = 15222;

        /// <summary>
        /// The identifier for the PublishedDataSetType_DataSetWriterName_Placeholder_Status Object.
        /// </summary>
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Status = 15223;

        /// <summary>
        /// The identifier for the PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters Object.
        /// </summary>
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters = 18885;

        /// <summary>
        /// The identifier for the PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues Object.
        /// </summary>
        public const uint PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues = 18916;

        /// <summary>
        /// The identifier for the PublishedDataSetType_ExtensionFields Object.
        /// </summary>
        public const uint PublishedDataSetType_ExtensionFields = 15481;

        /// <summary>
        /// The identifier for the PublishedDataItemsType_DataSetWriterName_Placeholder_Status Object.
        /// </summary>
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Status = 15231;

        /// <summary>
        /// The identifier for the PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters Object.
        /// </summary>
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters = 18944;

        /// <summary>
        /// The identifier for the PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues Object.
        /// </summary>
        public const uint PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues = 18975;

        /// <summary>
        /// The identifier for the PublishedEventsType_DataSetWriterName_Placeholder_Status Object.
        /// </summary>
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Status = 15239;

        /// <summary>
        /// The identifier for the PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters Object.
        /// </summary>
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters = 19003;

        /// <summary>
        /// The identifier for the PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues Object.
        /// </summary>
        public const uint PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues = 19034;

        /// <summary>
        /// The identifier for the DataSetFolderType_DataSetFolderName_Placeholder Object.
        /// </summary>
        public const uint DataSetFolderType_DataSetFolderName_Placeholder = 14478;

        /// <summary>
        /// The identifier for the DataSetFolderType_PublishedDataSetName_Placeholder Object.
        /// </summary>
        public const uint DataSetFolderType_PublishedDataSetName_Placeholder = 14487;

        /// <summary>
        /// The identifier for the PubSubConnectionType_Address Object.
        /// </summary>
        public const uint PubSubConnectionType_Address = 14221;

        /// <summary>
        /// The identifier for the PubSubConnectionType_TransportSettings Object.
        /// </summary>
        public const uint PubSubConnectionType_TransportSettings = 17203;

        /// <summary>
        /// The identifier for the PubSubConnectionType_WriterGroupName_Placeholder Object.
        /// </summary>
        public const uint PubSubConnectionType_WriterGroupName_Placeholder = 17310;

        /// <summary>
        /// The identifier for the PubSubConnectionType_WriterGroupName_Placeholder_Status Object.
        /// </summary>
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Status = 17314;

        /// <summary>
        /// The identifier for the PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters Object.
        /// </summary>
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters = 19121;

        /// <summary>
        /// The identifier for the PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues Object.
        /// </summary>
        public const uint PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues = 19152;

        /// <summary>
        /// The identifier for the PubSubConnectionType_ReaderGroupName_Placeholder Object.
        /// </summary>
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder = 17325;

        /// <summary>
        /// The identifier for the PubSubConnectionType_ReaderGroupName_Placeholder_Status Object.
        /// </summary>
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Status = 17329;

        /// <summary>
        /// The identifier for the PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters Object.
        /// </summary>
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters = 19190;

        /// <summary>
        /// The identifier for the PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues Object.
        /// </summary>
        public const uint PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues = 19221;

        /// <summary>
        /// The identifier for the PubSubConnectionType_Status Object.
        /// </summary>
        public const uint PubSubConnectionType_Status = 14600;

        /// <summary>
        /// The identifier for the PubSubConnectionType_Diagnostics Object.
        /// </summary>
        public const uint PubSubConnectionType_Diagnostics = 19241;

        /// <summary>
        /// The identifier for the PubSubConnectionType_Diagnostics_Counters Object.
        /// </summary>
        public const uint PubSubConnectionType_Diagnostics_Counters = 19255;

        /// <summary>
        /// The identifier for the PubSubConnectionType_Diagnostics_LiveValues Object.
        /// </summary>
        public const uint PubSubConnectionType_Diagnostics_LiveValues = 19286;

        /// <summary>
        /// The identifier for the PubSubGroupType_Status Object.
        /// </summary>
        public const uint PubSubGroupType_Status = 15265;

        /// <summary>
        /// The identifier for the WriterGroupType_TransportSettings Object.
        /// </summary>
        public const uint WriterGroupType_TransportSettings = 17741;

        /// <summary>
        /// The identifier for the WriterGroupType_MessageSettings Object.
        /// </summary>
        public const uint WriterGroupType_MessageSettings = 17742;

        /// <summary>
        /// The identifier for the WriterGroupType_DataSetWriterName_Placeholder Object.
        /// </summary>
        public const uint WriterGroupType_DataSetWriterName_Placeholder = 17743;

        /// <summary>
        /// The identifier for the WriterGroupType_DataSetWriterName_Placeholder_Status Object.
        /// </summary>
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Status = 17749;

        /// <summary>
        /// The identifier for the WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters Object.
        /// </summary>
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters = 17767;

        /// <summary>
        /// The identifier for the WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues Object.
        /// </summary>
        public const uint WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues = 17798;

        /// <summary>
        /// The identifier for the WriterGroupType_Diagnostics Object.
        /// </summary>
        public const uint WriterGroupType_Diagnostics = 17812;

        /// <summary>
        /// The identifier for the WriterGroupType_Diagnostics_Counters Object.
        /// </summary>
        public const uint WriterGroupType_Diagnostics_Counters = 17826;

        /// <summary>
        /// The identifier for the WriterGroupType_Diagnostics_LiveValues Object.
        /// </summary>
        public const uint WriterGroupType_Diagnostics_LiveValues = 17858;

        /// <summary>
        /// The identifier for the ReaderGroupType_DataSetReaderName_Placeholder Object.
        /// </summary>
        public const uint ReaderGroupType_DataSetReaderName_Placeholder = 18076;

        /// <summary>
        /// The identifier for the ReaderGroupType_DataSetReaderName_Placeholder_Status Object.
        /// </summary>
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Status = 18088;

        /// <summary>
        /// The identifier for the ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters Object.
        /// </summary>
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters = 18106;

        /// <summary>
        /// The identifier for the ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues Object.
        /// </summary>
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues = 18137;

        /// <summary>
        /// The identifier for the ReaderGroupType_DataSetReaderName_Placeholder_SubscribedDataSet Object.
        /// </summary>
        public const uint ReaderGroupType_DataSetReaderName_Placeholder_SubscribedDataSet = 21006;

        /// <summary>
        /// The identifier for the ReaderGroupType_Diagnostics Object.
        /// </summary>
        public const uint ReaderGroupType_Diagnostics = 21015;

        /// <summary>
        /// The identifier for the ReaderGroupType_Diagnostics_Counters Object.
        /// </summary>
        public const uint ReaderGroupType_Diagnostics_Counters = 21029;

        /// <summary>
        /// The identifier for the ReaderGroupType_Diagnostics_LiveValues Object.
        /// </summary>
        public const uint ReaderGroupType_Diagnostics_LiveValues = 21060;

        /// <summary>
        /// The identifier for the ReaderGroupType_TransportSettings Object.
        /// </summary>
        public const uint ReaderGroupType_TransportSettings = 21080;

        /// <summary>
        /// The identifier for the ReaderGroupType_MessageSettings Object.
        /// </summary>
        public const uint ReaderGroupType_MessageSettings = 21081;

        /// <summary>
        /// The identifier for the DataSetWriterType_TransportSettings Object.
        /// </summary>
        public const uint DataSetWriterType_TransportSettings = 15303;

        /// <summary>
        /// The identifier for the DataSetWriterType_MessageSettings Object.
        /// </summary>
        public const uint DataSetWriterType_MessageSettings = 21095;

        /// <summary>
        /// The identifier for the DataSetWriterType_Status Object.
        /// </summary>
        public const uint DataSetWriterType_Status = 15299;

        /// <summary>
        /// The identifier for the DataSetWriterType_Diagnostics Object.
        /// </summary>
        public const uint DataSetWriterType_Diagnostics = 19550;

        /// <summary>
        /// The identifier for the DataSetWriterType_Diagnostics_Counters Object.
        /// </summary>
        public const uint DataSetWriterType_Diagnostics_Counters = 19564;

        /// <summary>
        /// The identifier for the DataSetWriterType_Diagnostics_LiveValues Object.
        /// </summary>
        public const uint DataSetWriterType_Diagnostics_LiveValues = 19595;

        /// <summary>
        /// The identifier for the DataSetReaderType_TransportSettings Object.
        /// </summary>
        public const uint DataSetReaderType_TransportSettings = 15311;

        /// <summary>
        /// The identifier for the DataSetReaderType_MessageSettings Object.
        /// </summary>
        public const uint DataSetReaderType_MessageSettings = 21103;

        /// <summary>
        /// The identifier for the DataSetReaderType_Status Object.
        /// </summary>
        public const uint DataSetReaderType_Status = 15307;

        /// <summary>
        /// The identifier for the DataSetReaderType_Diagnostics Object.
        /// </summary>
        public const uint DataSetReaderType_Diagnostics = 19609;

        /// <summary>
        /// The identifier for the DataSetReaderType_Diagnostics_Counters Object.
        /// </summary>
        public const uint DataSetReaderType_Diagnostics_Counters = 19623;

        /// <summary>
        /// The identifier for the DataSetReaderType_Diagnostics_LiveValues Object.
        /// </summary>
        public const uint DataSetReaderType_Diagnostics_LiveValues = 19654;

        /// <summary>
        /// The identifier for the DataSetReaderType_SubscribedDataSet Object.
        /// </summary>
        public const uint DataSetReaderType_SubscribedDataSet = 15316;

        /// <summary>
        /// The identifier for the PubSubDiagnosticsType_Counters Object.
        /// </summary>
        public const uint PubSubDiagnosticsType_Counters = 19691;

        /// <summary>
        /// The identifier for the PubSubDiagnosticsType_LiveValues Object.
        /// </summary>
        public const uint PubSubDiagnosticsType_LiveValues = 19722;

        /// <summary>
        /// The identifier for the PubSubDiagnosticsRootType_LiveValues Object.
        /// </summary>
        public const uint PubSubDiagnosticsRootType_LiveValues = 19777;

        /// <summary>
        /// The identifier for the PubSubDiagnosticsConnectionType_LiveValues Object.
        /// </summary>
        public const uint PubSubDiagnosticsConnectionType_LiveValues = 19831;

        /// <summary>
        /// The identifier for the PubSubDiagnosticsWriterGroupType_Counters Object.
        /// </summary>
        public const uint PubSubDiagnosticsWriterGroupType_Counters = 19848;

        /// <summary>
        /// The identifier for the PubSubDiagnosticsWriterGroupType_LiveValues Object.
        /// </summary>
        public const uint PubSubDiagnosticsWriterGroupType_LiveValues = 19879;

        /// <summary>
        /// The identifier for the PubSubDiagnosticsReaderGroupType_Counters Object.
        /// </summary>
        public const uint PubSubDiagnosticsReaderGroupType_Counters = 19917;

        /// <summary>
        /// The identifier for the PubSubDiagnosticsReaderGroupType_LiveValues Object.
        /// </summary>
        public const uint PubSubDiagnosticsReaderGroupType_LiveValues = 19948;

        /// <summary>
        /// The identifier for the PubSubDiagnosticsDataSetWriterType_Counters Object.
        /// </summary>
        public const uint PubSubDiagnosticsDataSetWriterType_Counters = 19982;

        /// <summary>
        /// The identifier for the PubSubDiagnosticsDataSetWriterType_LiveValues Object.
        /// </summary>
        public const uint PubSubDiagnosticsDataSetWriterType_LiveValues = 20013;

        /// <summary>
        /// The identifier for the PubSubDiagnosticsDataSetReaderType_Counters Object.
        /// </summary>
        public const uint PubSubDiagnosticsDataSetReaderType_Counters = 20041;

        /// <summary>
        /// The identifier for the PubSubDiagnosticsDataSetReaderType_LiveValues Object.
        /// </summary>
        public const uint PubSubDiagnosticsDataSetReaderType_LiveValues = 20072;

        /// <summary>
        /// The identifier for the DatagramConnectionTransportType_DiscoveryAddress Object.
        /// </summary>
        public const uint DatagramConnectionTransportType_DiscoveryAddress = 15072;

        /// <summary>
        /// The identifier for the AliasNameCategoryType_Alias_Placeholder Object.
        /// </summary>
        public const uint AliasNameCategoryType_Alias_Placeholder = 23457;

        /// <summary>
        /// The identifier for the AliasNameCategoryType_SubAliasNameCategories_Placeholder Object.
        /// </summary>
        public const uint AliasNameCategoryType_SubAliasNameCategories_Placeholder = 23458;

        /// <summary>
        /// The identifier for the Aliases Object.
        /// </summary>
        public const uint Aliases = 23470;

        /// <summary>
        /// The identifier for the TagVariables Object.
        /// </summary>
        public const uint TagVariables = 23479;

        /// <summary>
        /// The identifier for the Topics Object.
        /// </summary>
        public const uint Topics = 23488;

        /// <summary>
        /// The identifier for the Resources Object.
        /// </summary>
        public const uint Resources = 24226;

        /// <summary>
        /// The identifier for the Communication Object.
        /// </summary>
        public const uint Communication = 24227;

        /// <summary>
        /// The identifier for the MappingTables Object.
        /// </summary>
        public const uint MappingTables = 24228;

        /// <summary>
        /// The identifier for the NetworkInterfaces Object.
        /// </summary>
        public const uint NetworkInterfaces = 24229;

        /// <summary>
        /// The identifier for the Streams Object.
        /// </summary>
        public const uint Streams = 24230;

        /// <summary>
        /// The identifier for the TalkerStreams Object.
        /// </summary>
        public const uint TalkerStreams = 24231;

        /// <summary>
        /// The identifier for the ListenerStreams Object.
        /// </summary>
        public const uint ListenerStreams = 24232;

        /// <summary>
        /// The identifier for the Union_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint Union_Encoding_DefaultBinary = 12766;

        /// <summary>
        /// The identifier for the KeyValuePair_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint KeyValuePair_Encoding_DefaultBinary = 14846;

        /// <summary>
        /// The identifier for the AdditionalParametersType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint AdditionalParametersType_Encoding_DefaultBinary = 17537;

        /// <summary>
        /// The identifier for the EphemeralKeyType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint EphemeralKeyType_Encoding_DefaultBinary = 17549;

        /// <summary>
        /// The identifier for the EndpointType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint EndpointType_Encoding_DefaultBinary = 15671;

        /// <summary>
        /// The identifier for the RationalNumber_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint RationalNumber_Encoding_DefaultBinary = 18815;

        /// <summary>
        /// The identifier for the Vector_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint Vector_Encoding_DefaultBinary = 18816;

        /// <summary>
        /// The identifier for the ThreeDVector_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ThreeDVector_Encoding_DefaultBinary = 18817;

        /// <summary>
        /// The identifier for the CartesianCoordinates_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint CartesianCoordinates_Encoding_DefaultBinary = 18818;

        /// <summary>
        /// The identifier for the ThreeDCartesianCoordinates_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ThreeDCartesianCoordinates_Encoding_DefaultBinary = 18819;

        /// <summary>
        /// The identifier for the Orientation_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint Orientation_Encoding_DefaultBinary = 18820;

        /// <summary>
        /// The identifier for the ThreeDOrientation_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ThreeDOrientation_Encoding_DefaultBinary = 18821;

        /// <summary>
        /// The identifier for the Frame_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint Frame_Encoding_DefaultBinary = 18822;

        /// <summary>
        /// The identifier for the ThreeDFrame_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ThreeDFrame_Encoding_DefaultBinary = 18823;

        /// <summary>
        /// The identifier for the IdentityMappingRuleType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint IdentityMappingRuleType_Encoding_DefaultBinary = 15736;

        /// <summary>
        /// The identifier for the CurrencyUnitType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint CurrencyUnitType_Encoding_DefaultBinary = 23507;

        /// <summary>
        /// The identifier for the TrustListDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint TrustListDataType_Encoding_DefaultBinary = 12680;

        /// <summary>
        /// The identifier for the DecimalDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DecimalDataType_Encoding_DefaultBinary = 17863;

        /// <summary>
        /// The identifier for the DataTypeSchemaHeader_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DataTypeSchemaHeader_Encoding_DefaultBinary = 15676;

        /// <summary>
        /// The identifier for the DataTypeDescription_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DataTypeDescription_Encoding_DefaultBinary = 125;

        /// <summary>
        /// The identifier for the StructureDescription_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint StructureDescription_Encoding_DefaultBinary = 126;

        /// <summary>
        /// The identifier for the EnumDescription_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint EnumDescription_Encoding_DefaultBinary = 127;

        /// <summary>
        /// The identifier for the SimpleTypeDescription_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint SimpleTypeDescription_Encoding_DefaultBinary = 15421;

        /// <summary>
        /// The identifier for the UABinaryFileDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint UABinaryFileDataType_Encoding_DefaultBinary = 15422;

        /// <summary>
        /// The identifier for the DataSetMetaDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DataSetMetaDataType_Encoding_DefaultBinary = 124;

        /// <summary>
        /// The identifier for the FieldMetaData_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint FieldMetaData_Encoding_DefaultBinary = 14839;

        /// <summary>
        /// The identifier for the ConfigurationVersionDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ConfigurationVersionDataType_Encoding_DefaultBinary = 14847;

        /// <summary>
        /// The identifier for the PublishedDataSetDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint PublishedDataSetDataType_Encoding_DefaultBinary = 15677;

        /// <summary>
        /// The identifier for the PublishedDataSetSourceDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint PublishedDataSetSourceDataType_Encoding_DefaultBinary = 15678;

        /// <summary>
        /// The identifier for the PublishedVariableDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint PublishedVariableDataType_Encoding_DefaultBinary = 14323;

        /// <summary>
        /// The identifier for the PublishedDataItemsDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint PublishedDataItemsDataType_Encoding_DefaultBinary = 15679;

        /// <summary>
        /// The identifier for the PublishedEventsDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint PublishedEventsDataType_Encoding_DefaultBinary = 15681;

        /// <summary>
        /// The identifier for the DataSetWriterDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DataSetWriterDataType_Encoding_DefaultBinary = 15682;

        /// <summary>
        /// The identifier for the DataSetWriterTransportDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DataSetWriterTransportDataType_Encoding_DefaultBinary = 15683;

        /// <summary>
        /// The identifier for the DataSetWriterMessageDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DataSetWriterMessageDataType_Encoding_DefaultBinary = 15688;

        /// <summary>
        /// The identifier for the PubSubGroupDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint PubSubGroupDataType_Encoding_DefaultBinary = 15689;

        /// <summary>
        /// The identifier for the WriterGroupDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint WriterGroupDataType_Encoding_DefaultBinary = 21150;

        /// <summary>
        /// The identifier for the WriterGroupTransportDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint WriterGroupTransportDataType_Encoding_DefaultBinary = 15691;

        /// <summary>
        /// The identifier for the WriterGroupMessageDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint WriterGroupMessageDataType_Encoding_DefaultBinary = 15693;

        /// <summary>
        /// The identifier for the PubSubConnectionDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint PubSubConnectionDataType_Encoding_DefaultBinary = 15694;

        /// <summary>
        /// The identifier for the ConnectionTransportDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ConnectionTransportDataType_Encoding_DefaultBinary = 15695;

        /// <summary>
        /// The identifier for the NetworkAddressDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint NetworkAddressDataType_Encoding_DefaultBinary = 21151;

        /// <summary>
        /// The identifier for the NetworkAddressUrlDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint NetworkAddressUrlDataType_Encoding_DefaultBinary = 21152;

        /// <summary>
        /// The identifier for the ReaderGroupDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ReaderGroupDataType_Encoding_DefaultBinary = 21153;

        /// <summary>
        /// The identifier for the ReaderGroupTransportDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ReaderGroupTransportDataType_Encoding_DefaultBinary = 15701;

        /// <summary>
        /// The identifier for the ReaderGroupMessageDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ReaderGroupMessageDataType_Encoding_DefaultBinary = 15702;

        /// <summary>
        /// The identifier for the DataSetReaderDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DataSetReaderDataType_Encoding_DefaultBinary = 15703;

        /// <summary>
        /// The identifier for the DataSetReaderTransportDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DataSetReaderTransportDataType_Encoding_DefaultBinary = 15705;

        /// <summary>
        /// The identifier for the DataSetReaderMessageDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DataSetReaderMessageDataType_Encoding_DefaultBinary = 15706;

        /// <summary>
        /// The identifier for the SubscribedDataSetDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint SubscribedDataSetDataType_Encoding_DefaultBinary = 15707;

        /// <summary>
        /// The identifier for the TargetVariablesDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint TargetVariablesDataType_Encoding_DefaultBinary = 15712;

        /// <summary>
        /// The identifier for the FieldTargetDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint FieldTargetDataType_Encoding_DefaultBinary = 14848;

        /// <summary>
        /// The identifier for the SubscribedDataSetMirrorDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint SubscribedDataSetMirrorDataType_Encoding_DefaultBinary = 15713;

        /// <summary>
        /// The identifier for the PubSubConfigurationDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint PubSubConfigurationDataType_Encoding_DefaultBinary = 21154;

        /// <summary>
        /// The identifier for the UadpWriterGroupMessageDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint UadpWriterGroupMessageDataType_Encoding_DefaultBinary = 15715;

        /// <summary>
        /// The identifier for the UadpDataSetWriterMessageDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint UadpDataSetWriterMessageDataType_Encoding_DefaultBinary = 15717;

        /// <summary>
        /// The identifier for the UadpDataSetReaderMessageDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint UadpDataSetReaderMessageDataType_Encoding_DefaultBinary = 15718;

        /// <summary>
        /// The identifier for the JsonWriterGroupMessageDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint JsonWriterGroupMessageDataType_Encoding_DefaultBinary = 15719;

        /// <summary>
        /// The identifier for the JsonDataSetWriterMessageDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint JsonDataSetWriterMessageDataType_Encoding_DefaultBinary = 15724;

        /// <summary>
        /// The identifier for the JsonDataSetReaderMessageDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint JsonDataSetReaderMessageDataType_Encoding_DefaultBinary = 15725;

        /// <summary>
        /// The identifier for the DatagramConnectionTransportDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DatagramConnectionTransportDataType_Encoding_DefaultBinary = 17468;

        /// <summary>
        /// The identifier for the DatagramWriterGroupTransportDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DatagramWriterGroupTransportDataType_Encoding_DefaultBinary = 21155;

        /// <summary>
        /// The identifier for the BrokerConnectionTransportDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint BrokerConnectionTransportDataType_Encoding_DefaultBinary = 15479;

        /// <summary>
        /// The identifier for the BrokerWriterGroupTransportDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint BrokerWriterGroupTransportDataType_Encoding_DefaultBinary = 15727;

        /// <summary>
        /// The identifier for the BrokerDataSetWriterTransportDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint BrokerDataSetWriterTransportDataType_Encoding_DefaultBinary = 15729;

        /// <summary>
        /// The identifier for the BrokerDataSetReaderTransportDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint BrokerDataSetReaderTransportDataType_Encoding_DefaultBinary = 15733;

        /// <summary>
        /// The identifier for the AliasNameDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint AliasNameDataType_Encoding_DefaultBinary = 23499;

        /// <summary>
        /// The identifier for the UnsignedRationalNumber_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint UnsignedRationalNumber_Encoding_DefaultBinary = 24110;

        /// <summary>
        /// The identifier for the RolePermissionType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint RolePermissionType_Encoding_DefaultBinary = 128;

        /// <summary>
        /// The identifier for the DataTypeDefinition_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DataTypeDefinition_Encoding_DefaultBinary = 121;

        /// <summary>
        /// The identifier for the StructureField_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint StructureField_Encoding_DefaultBinary = 14844;

        /// <summary>
        /// The identifier for the StructureDefinition_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint StructureDefinition_Encoding_DefaultBinary = 122;

        /// <summary>
        /// The identifier for the EnumDefinition_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint EnumDefinition_Encoding_DefaultBinary = 123;

        /// <summary>
        /// The identifier for the Node_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint Node_Encoding_DefaultBinary = 260;

        /// <summary>
        /// The identifier for the InstanceNode_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint InstanceNode_Encoding_DefaultBinary = 11889;

        /// <summary>
        /// The identifier for the TypeNode_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint TypeNode_Encoding_DefaultBinary = 11890;

        /// <summary>
        /// The identifier for the ObjectNode_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ObjectNode_Encoding_DefaultBinary = 263;

        /// <summary>
        /// The identifier for the ObjectTypeNode_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ObjectTypeNode_Encoding_DefaultBinary = 266;

        /// <summary>
        /// The identifier for the VariableNode_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint VariableNode_Encoding_DefaultBinary = 269;

        /// <summary>
        /// The identifier for the VariableTypeNode_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint VariableTypeNode_Encoding_DefaultBinary = 272;

        /// <summary>
        /// The identifier for the ReferenceTypeNode_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ReferenceTypeNode_Encoding_DefaultBinary = 275;

        /// <summary>
        /// The identifier for the MethodNode_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint MethodNode_Encoding_DefaultBinary = 278;

        /// <summary>
        /// The identifier for the ViewNode_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ViewNode_Encoding_DefaultBinary = 281;

        /// <summary>
        /// The identifier for the DataTypeNode_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DataTypeNode_Encoding_DefaultBinary = 284;

        /// <summary>
        /// The identifier for the ReferenceNode_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ReferenceNode_Encoding_DefaultBinary = 287;

        /// <summary>
        /// The identifier for the Argument_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint Argument_Encoding_DefaultBinary = 298;

        /// <summary>
        /// The identifier for the EnumValueType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint EnumValueType_Encoding_DefaultBinary = 8251;

        /// <summary>
        /// The identifier for the EnumField_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint EnumField_Encoding_DefaultBinary = 14845;

        /// <summary>
        /// The identifier for the OptionSet_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint OptionSet_Encoding_DefaultBinary = 12765;

        /// <summary>
        /// The identifier for the TimeZoneDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint TimeZoneDataType_Encoding_DefaultBinary = 8917;

        /// <summary>
        /// The identifier for the ApplicationDescription_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ApplicationDescription_Encoding_DefaultBinary = 310;

        /// <summary>
        /// The identifier for the RequestHeader_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint RequestHeader_Encoding_DefaultBinary = 391;

        /// <summary>
        /// The identifier for the ResponseHeader_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ResponseHeader_Encoding_DefaultBinary = 394;

        /// <summary>
        /// The identifier for the ServiceFault_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ServiceFault_Encoding_DefaultBinary = 397;

        /// <summary>
        /// The identifier for the SessionlessInvokeRequestType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint SessionlessInvokeRequestType_Encoding_DefaultBinary = 15903;

        /// <summary>
        /// The identifier for the SessionlessInvokeResponseType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint SessionlessInvokeResponseType_Encoding_DefaultBinary = 21001;

        /// <summary>
        /// The identifier for the FindServersRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint FindServersRequest_Encoding_DefaultBinary = 422;

        /// <summary>
        /// The identifier for the FindServersResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint FindServersResponse_Encoding_DefaultBinary = 425;

        /// <summary>
        /// The identifier for the ServerOnNetwork_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ServerOnNetwork_Encoding_DefaultBinary = 12207;

        /// <summary>
        /// The identifier for the FindServersOnNetworkRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint FindServersOnNetworkRequest_Encoding_DefaultBinary = 12208;

        /// <summary>
        /// The identifier for the FindServersOnNetworkResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint FindServersOnNetworkResponse_Encoding_DefaultBinary = 12209;

        /// <summary>
        /// The identifier for the UserTokenPolicy_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint UserTokenPolicy_Encoding_DefaultBinary = 306;

        /// <summary>
        /// The identifier for the EndpointDescription_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint EndpointDescription_Encoding_DefaultBinary = 314;

        /// <summary>
        /// The identifier for the GetEndpointsRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint GetEndpointsRequest_Encoding_DefaultBinary = 428;

        /// <summary>
        /// The identifier for the GetEndpointsResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint GetEndpointsResponse_Encoding_DefaultBinary = 431;

        /// <summary>
        /// The identifier for the RegisteredServer_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint RegisteredServer_Encoding_DefaultBinary = 434;

        /// <summary>
        /// The identifier for the RegisterServerRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint RegisterServerRequest_Encoding_DefaultBinary = 437;

        /// <summary>
        /// The identifier for the RegisterServerResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint RegisterServerResponse_Encoding_DefaultBinary = 440;

        /// <summary>
        /// The identifier for the DiscoveryConfiguration_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DiscoveryConfiguration_Encoding_DefaultBinary = 12900;

        /// <summary>
        /// The identifier for the MdnsDiscoveryConfiguration_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint MdnsDiscoveryConfiguration_Encoding_DefaultBinary = 12901;

        /// <summary>
        /// The identifier for the RegisterServer2Request_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint RegisterServer2Request_Encoding_DefaultBinary = 12211;

        /// <summary>
        /// The identifier for the RegisterServer2Response_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint RegisterServer2Response_Encoding_DefaultBinary = 12212;

        /// <summary>
        /// The identifier for the ChannelSecurityToken_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ChannelSecurityToken_Encoding_DefaultBinary = 443;

        /// <summary>
        /// The identifier for the OpenSecureChannelRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint OpenSecureChannelRequest_Encoding_DefaultBinary = 446;

        /// <summary>
        /// The identifier for the OpenSecureChannelResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint OpenSecureChannelResponse_Encoding_DefaultBinary = 449;

        /// <summary>
        /// The identifier for the CloseSecureChannelRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint CloseSecureChannelRequest_Encoding_DefaultBinary = 452;

        /// <summary>
        /// The identifier for the CloseSecureChannelResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint CloseSecureChannelResponse_Encoding_DefaultBinary = 455;

        /// <summary>
        /// The identifier for the SignedSoftwareCertificate_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint SignedSoftwareCertificate_Encoding_DefaultBinary = 346;

        /// <summary>
        /// The identifier for the SignatureData_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint SignatureData_Encoding_DefaultBinary = 458;

        /// <summary>
        /// The identifier for the CreateSessionRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint CreateSessionRequest_Encoding_DefaultBinary = 461;

        /// <summary>
        /// The identifier for the CreateSessionResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint CreateSessionResponse_Encoding_DefaultBinary = 464;

        /// <summary>
        /// The identifier for the UserIdentityToken_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint UserIdentityToken_Encoding_DefaultBinary = 318;

        /// <summary>
        /// The identifier for the AnonymousIdentityToken_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint AnonymousIdentityToken_Encoding_DefaultBinary = 321;

        /// <summary>
        /// The identifier for the UserNameIdentityToken_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint UserNameIdentityToken_Encoding_DefaultBinary = 324;

        /// <summary>
        /// The identifier for the X509IdentityToken_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint X509IdentityToken_Encoding_DefaultBinary = 327;

        /// <summary>
        /// The identifier for the IssuedIdentityToken_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint IssuedIdentityToken_Encoding_DefaultBinary = 940;

        /// <summary>
        /// The identifier for the ActivateSessionRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ActivateSessionRequest_Encoding_DefaultBinary = 467;

        /// <summary>
        /// The identifier for the ActivateSessionResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ActivateSessionResponse_Encoding_DefaultBinary = 470;

        /// <summary>
        /// The identifier for the CloseSessionRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint CloseSessionRequest_Encoding_DefaultBinary = 473;

        /// <summary>
        /// The identifier for the CloseSessionResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint CloseSessionResponse_Encoding_DefaultBinary = 476;

        /// <summary>
        /// The identifier for the CancelRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint CancelRequest_Encoding_DefaultBinary = 479;

        /// <summary>
        /// The identifier for the CancelResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint CancelResponse_Encoding_DefaultBinary = 482;

        /// <summary>
        /// The identifier for the NodeAttributes_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint NodeAttributes_Encoding_DefaultBinary = 351;

        /// <summary>
        /// The identifier for the ObjectAttributes_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ObjectAttributes_Encoding_DefaultBinary = 354;

        /// <summary>
        /// The identifier for the VariableAttributes_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint VariableAttributes_Encoding_DefaultBinary = 357;

        /// <summary>
        /// The identifier for the MethodAttributes_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint MethodAttributes_Encoding_DefaultBinary = 360;

        /// <summary>
        /// The identifier for the ObjectTypeAttributes_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ObjectTypeAttributes_Encoding_DefaultBinary = 363;

        /// <summary>
        /// The identifier for the VariableTypeAttributes_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint VariableTypeAttributes_Encoding_DefaultBinary = 366;

        /// <summary>
        /// The identifier for the ReferenceTypeAttributes_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ReferenceTypeAttributes_Encoding_DefaultBinary = 369;

        /// <summary>
        /// The identifier for the DataTypeAttributes_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DataTypeAttributes_Encoding_DefaultBinary = 372;

        /// <summary>
        /// The identifier for the ViewAttributes_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ViewAttributes_Encoding_DefaultBinary = 375;

        /// <summary>
        /// The identifier for the GenericAttributeValue_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint GenericAttributeValue_Encoding_DefaultBinary = 17610;

        /// <summary>
        /// The identifier for the GenericAttributes_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint GenericAttributes_Encoding_DefaultBinary = 17611;

        /// <summary>
        /// The identifier for the AddNodesItem_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint AddNodesItem_Encoding_DefaultBinary = 378;

        /// <summary>
        /// The identifier for the AddNodesResult_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint AddNodesResult_Encoding_DefaultBinary = 485;

        /// <summary>
        /// The identifier for the AddNodesRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint AddNodesRequest_Encoding_DefaultBinary = 488;

        /// <summary>
        /// The identifier for the AddNodesResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint AddNodesResponse_Encoding_DefaultBinary = 491;

        /// <summary>
        /// The identifier for the AddReferencesItem_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint AddReferencesItem_Encoding_DefaultBinary = 381;

        /// <summary>
        /// The identifier for the AddReferencesRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint AddReferencesRequest_Encoding_DefaultBinary = 494;

        /// <summary>
        /// The identifier for the AddReferencesResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint AddReferencesResponse_Encoding_DefaultBinary = 497;

        /// <summary>
        /// The identifier for the DeleteNodesItem_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DeleteNodesItem_Encoding_DefaultBinary = 384;

        /// <summary>
        /// The identifier for the DeleteNodesRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DeleteNodesRequest_Encoding_DefaultBinary = 500;

        /// <summary>
        /// The identifier for the DeleteNodesResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DeleteNodesResponse_Encoding_DefaultBinary = 503;

        /// <summary>
        /// The identifier for the DeleteReferencesItem_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DeleteReferencesItem_Encoding_DefaultBinary = 387;

        /// <summary>
        /// The identifier for the DeleteReferencesRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DeleteReferencesRequest_Encoding_DefaultBinary = 506;

        /// <summary>
        /// The identifier for the DeleteReferencesResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DeleteReferencesResponse_Encoding_DefaultBinary = 509;

        /// <summary>
        /// The identifier for the ViewDescription_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ViewDescription_Encoding_DefaultBinary = 513;

        /// <summary>
        /// The identifier for the BrowseDescription_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint BrowseDescription_Encoding_DefaultBinary = 516;

        /// <summary>
        /// The identifier for the ReferenceDescription_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ReferenceDescription_Encoding_DefaultBinary = 520;

        /// <summary>
        /// The identifier for the BrowseResult_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint BrowseResult_Encoding_DefaultBinary = 524;

        /// <summary>
        /// The identifier for the BrowseRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint BrowseRequest_Encoding_DefaultBinary = 527;

        /// <summary>
        /// The identifier for the BrowseResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint BrowseResponse_Encoding_DefaultBinary = 530;

        /// <summary>
        /// The identifier for the BrowseNextRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint BrowseNextRequest_Encoding_DefaultBinary = 533;

        /// <summary>
        /// The identifier for the BrowseNextResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint BrowseNextResponse_Encoding_DefaultBinary = 536;

        /// <summary>
        /// The identifier for the RelativePathElement_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint RelativePathElement_Encoding_DefaultBinary = 539;

        /// <summary>
        /// The identifier for the RelativePath_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint RelativePath_Encoding_DefaultBinary = 542;

        /// <summary>
        /// The identifier for the BrowsePath_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint BrowsePath_Encoding_DefaultBinary = 545;

        /// <summary>
        /// The identifier for the BrowsePathTarget_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint BrowsePathTarget_Encoding_DefaultBinary = 548;

        /// <summary>
        /// The identifier for the BrowsePathResult_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint BrowsePathResult_Encoding_DefaultBinary = 551;

        /// <summary>
        /// The identifier for the TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultBinary = 554;

        /// <summary>
        /// The identifier for the TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultBinary = 557;

        /// <summary>
        /// The identifier for the RegisterNodesRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint RegisterNodesRequest_Encoding_DefaultBinary = 560;

        /// <summary>
        /// The identifier for the RegisterNodesResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint RegisterNodesResponse_Encoding_DefaultBinary = 563;

        /// <summary>
        /// The identifier for the UnregisterNodesRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint UnregisterNodesRequest_Encoding_DefaultBinary = 566;

        /// <summary>
        /// The identifier for the UnregisterNodesResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint UnregisterNodesResponse_Encoding_DefaultBinary = 569;

        /// <summary>
        /// The identifier for the EndpointConfiguration_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint EndpointConfiguration_Encoding_DefaultBinary = 333;

        /// <summary>
        /// The identifier for the QueryDataDescription_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint QueryDataDescription_Encoding_DefaultBinary = 572;

        /// <summary>
        /// The identifier for the NodeTypeDescription_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint NodeTypeDescription_Encoding_DefaultBinary = 575;

        /// <summary>
        /// The identifier for the QueryDataSet_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint QueryDataSet_Encoding_DefaultBinary = 579;

        /// <summary>
        /// The identifier for the NodeReference_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint NodeReference_Encoding_DefaultBinary = 582;

        /// <summary>
        /// The identifier for the ContentFilterElement_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ContentFilterElement_Encoding_DefaultBinary = 585;

        /// <summary>
        /// The identifier for the ContentFilter_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ContentFilter_Encoding_DefaultBinary = 588;

        /// <summary>
        /// The identifier for the FilterOperand_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint FilterOperand_Encoding_DefaultBinary = 591;

        /// <summary>
        /// The identifier for the ElementOperand_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ElementOperand_Encoding_DefaultBinary = 594;

        /// <summary>
        /// The identifier for the LiteralOperand_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint LiteralOperand_Encoding_DefaultBinary = 597;

        /// <summary>
        /// The identifier for the AttributeOperand_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint AttributeOperand_Encoding_DefaultBinary = 600;

        /// <summary>
        /// The identifier for the SimpleAttributeOperand_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint SimpleAttributeOperand_Encoding_DefaultBinary = 603;

        /// <summary>
        /// The identifier for the ContentFilterElementResult_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ContentFilterElementResult_Encoding_DefaultBinary = 606;

        /// <summary>
        /// The identifier for the ContentFilterResult_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ContentFilterResult_Encoding_DefaultBinary = 609;

        /// <summary>
        /// The identifier for the ParsingResult_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ParsingResult_Encoding_DefaultBinary = 612;

        /// <summary>
        /// The identifier for the QueryFirstRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint QueryFirstRequest_Encoding_DefaultBinary = 615;

        /// <summary>
        /// The identifier for the QueryFirstResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint QueryFirstResponse_Encoding_DefaultBinary = 618;

        /// <summary>
        /// The identifier for the QueryNextRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint QueryNextRequest_Encoding_DefaultBinary = 621;

        /// <summary>
        /// The identifier for the QueryNextResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint QueryNextResponse_Encoding_DefaultBinary = 624;

        /// <summary>
        /// The identifier for the ReadValueId_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ReadValueId_Encoding_DefaultBinary = 628;

        /// <summary>
        /// The identifier for the ReadRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ReadRequest_Encoding_DefaultBinary = 631;

        /// <summary>
        /// The identifier for the ReadResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ReadResponse_Encoding_DefaultBinary = 634;

        /// <summary>
        /// The identifier for the HistoryReadValueId_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint HistoryReadValueId_Encoding_DefaultBinary = 637;

        /// <summary>
        /// The identifier for the HistoryReadResult_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint HistoryReadResult_Encoding_DefaultBinary = 640;

        /// <summary>
        /// The identifier for the HistoryReadDetails_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint HistoryReadDetails_Encoding_DefaultBinary = 643;

        /// <summary>
        /// The identifier for the ReadEventDetails_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ReadEventDetails_Encoding_DefaultBinary = 646;

        /// <summary>
        /// The identifier for the ReadRawModifiedDetails_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ReadRawModifiedDetails_Encoding_DefaultBinary = 649;

        /// <summary>
        /// The identifier for the ReadProcessedDetails_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ReadProcessedDetails_Encoding_DefaultBinary = 652;

        /// <summary>
        /// The identifier for the ReadAtTimeDetails_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ReadAtTimeDetails_Encoding_DefaultBinary = 655;

        /// <summary>
        /// The identifier for the ReadAnnotationDataDetails_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ReadAnnotationDataDetails_Encoding_DefaultBinary = 23500;

        /// <summary>
        /// The identifier for the HistoryData_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint HistoryData_Encoding_DefaultBinary = 658;

        /// <summary>
        /// The identifier for the ModificationInfo_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ModificationInfo_Encoding_DefaultBinary = 11226;

        /// <summary>
        /// The identifier for the HistoryModifiedData_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint HistoryModifiedData_Encoding_DefaultBinary = 11227;

        /// <summary>
        /// The identifier for the HistoryEvent_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint HistoryEvent_Encoding_DefaultBinary = 661;

        /// <summary>
        /// The identifier for the HistoryReadRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint HistoryReadRequest_Encoding_DefaultBinary = 664;

        /// <summary>
        /// The identifier for the HistoryReadResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint HistoryReadResponse_Encoding_DefaultBinary = 667;

        /// <summary>
        /// The identifier for the WriteValue_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint WriteValue_Encoding_DefaultBinary = 670;

        /// <summary>
        /// The identifier for the WriteRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint WriteRequest_Encoding_DefaultBinary = 673;

        /// <summary>
        /// The identifier for the WriteResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint WriteResponse_Encoding_DefaultBinary = 676;

        /// <summary>
        /// The identifier for the HistoryUpdateDetails_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint HistoryUpdateDetails_Encoding_DefaultBinary = 679;

        /// <summary>
        /// The identifier for the UpdateDataDetails_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint UpdateDataDetails_Encoding_DefaultBinary = 682;

        /// <summary>
        /// The identifier for the UpdateStructureDataDetails_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint UpdateStructureDataDetails_Encoding_DefaultBinary = 11300;

        /// <summary>
        /// The identifier for the UpdateEventDetails_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint UpdateEventDetails_Encoding_DefaultBinary = 685;

        /// <summary>
        /// The identifier for the DeleteRawModifiedDetails_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DeleteRawModifiedDetails_Encoding_DefaultBinary = 688;

        /// <summary>
        /// The identifier for the DeleteAtTimeDetails_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DeleteAtTimeDetails_Encoding_DefaultBinary = 691;

        /// <summary>
        /// The identifier for the DeleteEventDetails_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DeleteEventDetails_Encoding_DefaultBinary = 694;

        /// <summary>
        /// The identifier for the HistoryUpdateResult_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint HistoryUpdateResult_Encoding_DefaultBinary = 697;

        /// <summary>
        /// The identifier for the HistoryUpdateRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint HistoryUpdateRequest_Encoding_DefaultBinary = 700;

        /// <summary>
        /// The identifier for the HistoryUpdateResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint HistoryUpdateResponse_Encoding_DefaultBinary = 703;

        /// <summary>
        /// The identifier for the CallMethodRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint CallMethodRequest_Encoding_DefaultBinary = 706;

        /// <summary>
        /// The identifier for the CallMethodResult_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint CallMethodResult_Encoding_DefaultBinary = 709;

        /// <summary>
        /// The identifier for the CallRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint CallRequest_Encoding_DefaultBinary = 712;

        /// <summary>
        /// The identifier for the CallResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint CallResponse_Encoding_DefaultBinary = 715;

        /// <summary>
        /// The identifier for the MonitoringFilter_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint MonitoringFilter_Encoding_DefaultBinary = 721;

        /// <summary>
        /// The identifier for the DataChangeFilter_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DataChangeFilter_Encoding_DefaultBinary = 724;

        /// <summary>
        /// The identifier for the EventFilter_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint EventFilter_Encoding_DefaultBinary = 727;

        /// <summary>
        /// The identifier for the AggregateConfiguration_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint AggregateConfiguration_Encoding_DefaultBinary = 950;

        /// <summary>
        /// The identifier for the AggregateFilter_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint AggregateFilter_Encoding_DefaultBinary = 730;

        /// <summary>
        /// The identifier for the MonitoringFilterResult_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint MonitoringFilterResult_Encoding_DefaultBinary = 733;

        /// <summary>
        /// The identifier for the EventFilterResult_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint EventFilterResult_Encoding_DefaultBinary = 736;

        /// <summary>
        /// The identifier for the AggregateFilterResult_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint AggregateFilterResult_Encoding_DefaultBinary = 739;

        /// <summary>
        /// The identifier for the MonitoringParameters_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint MonitoringParameters_Encoding_DefaultBinary = 742;

        /// <summary>
        /// The identifier for the MonitoredItemCreateRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint MonitoredItemCreateRequest_Encoding_DefaultBinary = 745;

        /// <summary>
        /// The identifier for the MonitoredItemCreateResult_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint MonitoredItemCreateResult_Encoding_DefaultBinary = 748;

        /// <summary>
        /// The identifier for the CreateMonitoredItemsRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint CreateMonitoredItemsRequest_Encoding_DefaultBinary = 751;

        /// <summary>
        /// The identifier for the CreateMonitoredItemsResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint CreateMonitoredItemsResponse_Encoding_DefaultBinary = 754;

        /// <summary>
        /// The identifier for the MonitoredItemModifyRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint MonitoredItemModifyRequest_Encoding_DefaultBinary = 757;

        /// <summary>
        /// The identifier for the MonitoredItemModifyResult_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint MonitoredItemModifyResult_Encoding_DefaultBinary = 760;

        /// <summary>
        /// The identifier for the ModifyMonitoredItemsRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ModifyMonitoredItemsRequest_Encoding_DefaultBinary = 763;

        /// <summary>
        /// The identifier for the ModifyMonitoredItemsResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ModifyMonitoredItemsResponse_Encoding_DefaultBinary = 766;

        /// <summary>
        /// The identifier for the SetMonitoringModeRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint SetMonitoringModeRequest_Encoding_DefaultBinary = 769;

        /// <summary>
        /// The identifier for the SetMonitoringModeResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint SetMonitoringModeResponse_Encoding_DefaultBinary = 772;

        /// <summary>
        /// The identifier for the SetTriggeringRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint SetTriggeringRequest_Encoding_DefaultBinary = 775;

        /// <summary>
        /// The identifier for the SetTriggeringResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint SetTriggeringResponse_Encoding_DefaultBinary = 778;

        /// <summary>
        /// The identifier for the DeleteMonitoredItemsRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DeleteMonitoredItemsRequest_Encoding_DefaultBinary = 781;

        /// <summary>
        /// The identifier for the DeleteMonitoredItemsResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DeleteMonitoredItemsResponse_Encoding_DefaultBinary = 784;

        /// <summary>
        /// The identifier for the CreateSubscriptionRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint CreateSubscriptionRequest_Encoding_DefaultBinary = 787;

        /// <summary>
        /// The identifier for the CreateSubscriptionResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint CreateSubscriptionResponse_Encoding_DefaultBinary = 790;

        /// <summary>
        /// The identifier for the ModifySubscriptionRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ModifySubscriptionRequest_Encoding_DefaultBinary = 793;

        /// <summary>
        /// The identifier for the ModifySubscriptionResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ModifySubscriptionResponse_Encoding_DefaultBinary = 796;

        /// <summary>
        /// The identifier for the SetPublishingModeRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint SetPublishingModeRequest_Encoding_DefaultBinary = 799;

        /// <summary>
        /// The identifier for the SetPublishingModeResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint SetPublishingModeResponse_Encoding_DefaultBinary = 802;

        /// <summary>
        /// The identifier for the NotificationMessage_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint NotificationMessage_Encoding_DefaultBinary = 805;

        /// <summary>
        /// The identifier for the NotificationData_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint NotificationData_Encoding_DefaultBinary = 947;

        /// <summary>
        /// The identifier for the DataChangeNotification_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DataChangeNotification_Encoding_DefaultBinary = 811;

        /// <summary>
        /// The identifier for the MonitoredItemNotification_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint MonitoredItemNotification_Encoding_DefaultBinary = 808;

        /// <summary>
        /// The identifier for the EventNotificationList_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint EventNotificationList_Encoding_DefaultBinary = 916;

        /// <summary>
        /// The identifier for the EventFieldList_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint EventFieldList_Encoding_DefaultBinary = 919;

        /// <summary>
        /// The identifier for the HistoryEventFieldList_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint HistoryEventFieldList_Encoding_DefaultBinary = 922;

        /// <summary>
        /// The identifier for the StatusChangeNotification_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint StatusChangeNotification_Encoding_DefaultBinary = 820;

        /// <summary>
        /// The identifier for the SubscriptionAcknowledgement_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint SubscriptionAcknowledgement_Encoding_DefaultBinary = 823;

        /// <summary>
        /// The identifier for the PublishRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint PublishRequest_Encoding_DefaultBinary = 826;

        /// <summary>
        /// The identifier for the PublishResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint PublishResponse_Encoding_DefaultBinary = 829;

        /// <summary>
        /// The identifier for the RepublishRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint RepublishRequest_Encoding_DefaultBinary = 832;

        /// <summary>
        /// The identifier for the RepublishResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint RepublishResponse_Encoding_DefaultBinary = 835;

        /// <summary>
        /// The identifier for the TransferResult_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint TransferResult_Encoding_DefaultBinary = 838;

        /// <summary>
        /// The identifier for the TransferSubscriptionsRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint TransferSubscriptionsRequest_Encoding_DefaultBinary = 841;

        /// <summary>
        /// The identifier for the TransferSubscriptionsResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint TransferSubscriptionsResponse_Encoding_DefaultBinary = 844;

        /// <summary>
        /// The identifier for the DeleteSubscriptionsRequest_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DeleteSubscriptionsRequest_Encoding_DefaultBinary = 847;

        /// <summary>
        /// The identifier for the DeleteSubscriptionsResponse_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DeleteSubscriptionsResponse_Encoding_DefaultBinary = 850;

        /// <summary>
        /// The identifier for the BuildInfo_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint BuildInfo_Encoding_DefaultBinary = 340;

        /// <summary>
        /// The identifier for the RedundantServerDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint RedundantServerDataType_Encoding_DefaultBinary = 855;

        /// <summary>
        /// The identifier for the EndpointUrlListDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint EndpointUrlListDataType_Encoding_DefaultBinary = 11957;

        /// <summary>
        /// The identifier for the NetworkGroupDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint NetworkGroupDataType_Encoding_DefaultBinary = 11958;

        /// <summary>
        /// The identifier for the SamplingIntervalDiagnosticsDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint SamplingIntervalDiagnosticsDataType_Encoding_DefaultBinary = 858;

        /// <summary>
        /// The identifier for the ServerDiagnosticsSummaryDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ServerDiagnosticsSummaryDataType_Encoding_DefaultBinary = 861;

        /// <summary>
        /// The identifier for the ServerStatusDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ServerStatusDataType_Encoding_DefaultBinary = 864;

        /// <summary>
        /// The identifier for the SessionDiagnosticsDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint SessionDiagnosticsDataType_Encoding_DefaultBinary = 867;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint SessionSecurityDiagnosticsDataType_Encoding_DefaultBinary = 870;

        /// <summary>
        /// The identifier for the ServiceCounterDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ServiceCounterDataType_Encoding_DefaultBinary = 873;

        /// <summary>
        /// The identifier for the StatusResult_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint StatusResult_Encoding_DefaultBinary = 301;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint SubscriptionDiagnosticsDataType_Encoding_DefaultBinary = 876;

        /// <summary>
        /// The identifier for the ModelChangeStructureDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ModelChangeStructureDataType_Encoding_DefaultBinary = 879;

        /// <summary>
        /// The identifier for the SemanticChangeStructureDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint SemanticChangeStructureDataType_Encoding_DefaultBinary = 899;

        /// <summary>
        /// The identifier for the Range_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint Range_Encoding_DefaultBinary = 886;

        /// <summary>
        /// The identifier for the EUInformation_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint EUInformation_Encoding_DefaultBinary = 889;

        /// <summary>
        /// The identifier for the ComplexNumberType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ComplexNumberType_Encoding_DefaultBinary = 12181;

        /// <summary>
        /// The identifier for the DoubleComplexNumberType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint DoubleComplexNumberType_Encoding_DefaultBinary = 12182;

        /// <summary>
        /// The identifier for the AxisInformation_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint AxisInformation_Encoding_DefaultBinary = 12089;

        /// <summary>
        /// The identifier for the XVType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint XVType_Encoding_DefaultBinary = 12090;

        /// <summary>
        /// The identifier for the ProgramDiagnosticDataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ProgramDiagnosticDataType_Encoding_DefaultBinary = 896;

        /// <summary>
        /// The identifier for the ProgramDiagnostic2DataType_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint ProgramDiagnostic2DataType_Encoding_DefaultBinary = 24034;

        /// <summary>
        /// The identifier for the Annotation_Encoding_DefaultBinary Object.
        /// </summary>
        public const uint Annotation_Encoding_DefaultBinary = 893;

        /// <summary>
        /// The identifier for the Union_Encoding_DefaultXml Object.
        /// </summary>
        public const uint Union_Encoding_DefaultXml = 12758;

        /// <summary>
        /// The identifier for the KeyValuePair_Encoding_DefaultXml Object.
        /// </summary>
        public const uint KeyValuePair_Encoding_DefaultXml = 14802;

        /// <summary>
        /// The identifier for the AdditionalParametersType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint AdditionalParametersType_Encoding_DefaultXml = 17541;

        /// <summary>
        /// The identifier for the EphemeralKeyType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint EphemeralKeyType_Encoding_DefaultXml = 17553;

        /// <summary>
        /// The identifier for the EndpointType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint EndpointType_Encoding_DefaultXml = 15949;

        /// <summary>
        /// The identifier for the RationalNumber_Encoding_DefaultXml Object.
        /// </summary>
        public const uint RationalNumber_Encoding_DefaultXml = 18851;

        /// <summary>
        /// The identifier for the Vector_Encoding_DefaultXml Object.
        /// </summary>
        public const uint Vector_Encoding_DefaultXml = 18852;

        /// <summary>
        /// The identifier for the ThreeDVector_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ThreeDVector_Encoding_DefaultXml = 18853;

        /// <summary>
        /// The identifier for the CartesianCoordinates_Encoding_DefaultXml Object.
        /// </summary>
        public const uint CartesianCoordinates_Encoding_DefaultXml = 18854;

        /// <summary>
        /// The identifier for the ThreeDCartesianCoordinates_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ThreeDCartesianCoordinates_Encoding_DefaultXml = 18855;

        /// <summary>
        /// The identifier for the Orientation_Encoding_DefaultXml Object.
        /// </summary>
        public const uint Orientation_Encoding_DefaultXml = 18856;

        /// <summary>
        /// The identifier for the ThreeDOrientation_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ThreeDOrientation_Encoding_DefaultXml = 18857;

        /// <summary>
        /// The identifier for the Frame_Encoding_DefaultXml Object.
        /// </summary>
        public const uint Frame_Encoding_DefaultXml = 18858;

        /// <summary>
        /// The identifier for the ThreeDFrame_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ThreeDFrame_Encoding_DefaultXml = 18859;

        /// <summary>
        /// The identifier for the IdentityMappingRuleType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint IdentityMappingRuleType_Encoding_DefaultXml = 15728;

        /// <summary>
        /// The identifier for the CurrencyUnitType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint CurrencyUnitType_Encoding_DefaultXml = 23520;

        /// <summary>
        /// The identifier for the TrustListDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint TrustListDataType_Encoding_DefaultXml = 12676;

        /// <summary>
        /// The identifier for the DecimalDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DecimalDataType_Encoding_DefaultXml = 17862;

        /// <summary>
        /// The identifier for the DataTypeSchemaHeader_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DataTypeSchemaHeader_Encoding_DefaultXml = 15950;

        /// <summary>
        /// The identifier for the DataTypeDescription_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DataTypeDescription_Encoding_DefaultXml = 14796;

        /// <summary>
        /// The identifier for the StructureDescription_Encoding_DefaultXml Object.
        /// </summary>
        public const uint StructureDescription_Encoding_DefaultXml = 15589;

        /// <summary>
        /// The identifier for the EnumDescription_Encoding_DefaultXml Object.
        /// </summary>
        public const uint EnumDescription_Encoding_DefaultXml = 15590;

        /// <summary>
        /// The identifier for the SimpleTypeDescription_Encoding_DefaultXml Object.
        /// </summary>
        public const uint SimpleTypeDescription_Encoding_DefaultXml = 15529;

        /// <summary>
        /// The identifier for the UABinaryFileDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint UABinaryFileDataType_Encoding_DefaultXml = 15531;

        /// <summary>
        /// The identifier for the DataSetMetaDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DataSetMetaDataType_Encoding_DefaultXml = 14794;

        /// <summary>
        /// The identifier for the FieldMetaData_Encoding_DefaultXml Object.
        /// </summary>
        public const uint FieldMetaData_Encoding_DefaultXml = 14795;

        /// <summary>
        /// The identifier for the ConfigurationVersionDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ConfigurationVersionDataType_Encoding_DefaultXml = 14803;

        /// <summary>
        /// The identifier for the PublishedDataSetDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint PublishedDataSetDataType_Encoding_DefaultXml = 15951;

        /// <summary>
        /// The identifier for the PublishedDataSetSourceDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint PublishedDataSetSourceDataType_Encoding_DefaultXml = 15952;

        /// <summary>
        /// The identifier for the PublishedVariableDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint PublishedVariableDataType_Encoding_DefaultXml = 14319;

        /// <summary>
        /// The identifier for the PublishedDataItemsDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint PublishedDataItemsDataType_Encoding_DefaultXml = 15953;

        /// <summary>
        /// The identifier for the PublishedEventsDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint PublishedEventsDataType_Encoding_DefaultXml = 15954;

        /// <summary>
        /// The identifier for the DataSetWriterDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DataSetWriterDataType_Encoding_DefaultXml = 15955;

        /// <summary>
        /// The identifier for the DataSetWriterTransportDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DataSetWriterTransportDataType_Encoding_DefaultXml = 15956;

        /// <summary>
        /// The identifier for the DataSetWriterMessageDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DataSetWriterMessageDataType_Encoding_DefaultXml = 15987;

        /// <summary>
        /// The identifier for the PubSubGroupDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint PubSubGroupDataType_Encoding_DefaultXml = 15988;

        /// <summary>
        /// The identifier for the WriterGroupDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint WriterGroupDataType_Encoding_DefaultXml = 21174;

        /// <summary>
        /// The identifier for the WriterGroupTransportDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint WriterGroupTransportDataType_Encoding_DefaultXml = 15990;

        /// <summary>
        /// The identifier for the WriterGroupMessageDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint WriterGroupMessageDataType_Encoding_DefaultXml = 15991;

        /// <summary>
        /// The identifier for the PubSubConnectionDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint PubSubConnectionDataType_Encoding_DefaultXml = 15992;

        /// <summary>
        /// The identifier for the ConnectionTransportDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ConnectionTransportDataType_Encoding_DefaultXml = 15993;

        /// <summary>
        /// The identifier for the NetworkAddressDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint NetworkAddressDataType_Encoding_DefaultXml = 21175;

        /// <summary>
        /// The identifier for the NetworkAddressUrlDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint NetworkAddressUrlDataType_Encoding_DefaultXml = 21176;

        /// <summary>
        /// The identifier for the ReaderGroupDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ReaderGroupDataType_Encoding_DefaultXml = 21177;

        /// <summary>
        /// The identifier for the ReaderGroupTransportDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ReaderGroupTransportDataType_Encoding_DefaultXml = 15995;

        /// <summary>
        /// The identifier for the ReaderGroupMessageDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ReaderGroupMessageDataType_Encoding_DefaultXml = 15996;

        /// <summary>
        /// The identifier for the DataSetReaderDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DataSetReaderDataType_Encoding_DefaultXml = 16007;

        /// <summary>
        /// The identifier for the DataSetReaderTransportDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DataSetReaderTransportDataType_Encoding_DefaultXml = 16008;

        /// <summary>
        /// The identifier for the DataSetReaderMessageDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DataSetReaderMessageDataType_Encoding_DefaultXml = 16009;

        /// <summary>
        /// The identifier for the SubscribedDataSetDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint SubscribedDataSetDataType_Encoding_DefaultXml = 16010;

        /// <summary>
        /// The identifier for the TargetVariablesDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint TargetVariablesDataType_Encoding_DefaultXml = 16011;

        /// <summary>
        /// The identifier for the FieldTargetDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint FieldTargetDataType_Encoding_DefaultXml = 14804;

        /// <summary>
        /// The identifier for the SubscribedDataSetMirrorDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint SubscribedDataSetMirrorDataType_Encoding_DefaultXml = 16012;

        /// <summary>
        /// The identifier for the PubSubConfigurationDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint PubSubConfigurationDataType_Encoding_DefaultXml = 21178;

        /// <summary>
        /// The identifier for the UadpWriterGroupMessageDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint UadpWriterGroupMessageDataType_Encoding_DefaultXml = 16014;

        /// <summary>
        /// The identifier for the UadpDataSetWriterMessageDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint UadpDataSetWriterMessageDataType_Encoding_DefaultXml = 16015;

        /// <summary>
        /// The identifier for the UadpDataSetReaderMessageDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint UadpDataSetReaderMessageDataType_Encoding_DefaultXml = 16016;

        /// <summary>
        /// The identifier for the JsonWriterGroupMessageDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint JsonWriterGroupMessageDataType_Encoding_DefaultXml = 16017;

        /// <summary>
        /// The identifier for the JsonDataSetWriterMessageDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint JsonDataSetWriterMessageDataType_Encoding_DefaultXml = 16018;

        /// <summary>
        /// The identifier for the JsonDataSetReaderMessageDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint JsonDataSetReaderMessageDataType_Encoding_DefaultXml = 16019;

        /// <summary>
        /// The identifier for the DatagramConnectionTransportDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DatagramConnectionTransportDataType_Encoding_DefaultXml = 17472;

        /// <summary>
        /// The identifier for the DatagramWriterGroupTransportDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DatagramWriterGroupTransportDataType_Encoding_DefaultXml = 21179;

        /// <summary>
        /// The identifier for the BrokerConnectionTransportDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint BrokerConnectionTransportDataType_Encoding_DefaultXml = 15579;

        /// <summary>
        /// The identifier for the BrokerWriterGroupTransportDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint BrokerWriterGroupTransportDataType_Encoding_DefaultXml = 16021;

        /// <summary>
        /// The identifier for the BrokerDataSetWriterTransportDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint BrokerDataSetWriterTransportDataType_Encoding_DefaultXml = 16022;

        /// <summary>
        /// The identifier for the BrokerDataSetReaderTransportDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint BrokerDataSetReaderTransportDataType_Encoding_DefaultXml = 16023;

        /// <summary>
        /// The identifier for the AliasNameDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint AliasNameDataType_Encoding_DefaultXml = 23505;

        /// <summary>
        /// The identifier for the UnsignedRationalNumber_Encoding_DefaultXml Object.
        /// </summary>
        public const uint UnsignedRationalNumber_Encoding_DefaultXml = 24122;

        /// <summary>
        /// The identifier for the RolePermissionType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint RolePermissionType_Encoding_DefaultXml = 16126;

        /// <summary>
        /// The identifier for the DataTypeDefinition_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DataTypeDefinition_Encoding_DefaultXml = 14797;

        /// <summary>
        /// The identifier for the StructureField_Encoding_DefaultXml Object.
        /// </summary>
        public const uint StructureField_Encoding_DefaultXml = 14800;

        /// <summary>
        /// The identifier for the StructureDefinition_Encoding_DefaultXml Object.
        /// </summary>
        public const uint StructureDefinition_Encoding_DefaultXml = 14798;

        /// <summary>
        /// The identifier for the EnumDefinition_Encoding_DefaultXml Object.
        /// </summary>
        public const uint EnumDefinition_Encoding_DefaultXml = 14799;

        /// <summary>
        /// The identifier for the Node_Encoding_DefaultXml Object.
        /// </summary>
        public const uint Node_Encoding_DefaultXml = 259;

        /// <summary>
        /// The identifier for the InstanceNode_Encoding_DefaultXml Object.
        /// </summary>
        public const uint InstanceNode_Encoding_DefaultXml = 11887;

        /// <summary>
        /// The identifier for the TypeNode_Encoding_DefaultXml Object.
        /// </summary>
        public const uint TypeNode_Encoding_DefaultXml = 11888;

        /// <summary>
        /// The identifier for the ObjectNode_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ObjectNode_Encoding_DefaultXml = 262;

        /// <summary>
        /// The identifier for the ObjectTypeNode_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ObjectTypeNode_Encoding_DefaultXml = 265;

        /// <summary>
        /// The identifier for the VariableNode_Encoding_DefaultXml Object.
        /// </summary>
        public const uint VariableNode_Encoding_DefaultXml = 268;

        /// <summary>
        /// The identifier for the VariableTypeNode_Encoding_DefaultXml Object.
        /// </summary>
        public const uint VariableTypeNode_Encoding_DefaultXml = 271;

        /// <summary>
        /// The identifier for the ReferenceTypeNode_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ReferenceTypeNode_Encoding_DefaultXml = 274;

        /// <summary>
        /// The identifier for the MethodNode_Encoding_DefaultXml Object.
        /// </summary>
        public const uint MethodNode_Encoding_DefaultXml = 277;

        /// <summary>
        /// The identifier for the ViewNode_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ViewNode_Encoding_DefaultXml = 280;

        /// <summary>
        /// The identifier for the DataTypeNode_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DataTypeNode_Encoding_DefaultXml = 283;

        /// <summary>
        /// The identifier for the ReferenceNode_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ReferenceNode_Encoding_DefaultXml = 286;

        /// <summary>
        /// The identifier for the Argument_Encoding_DefaultXml Object.
        /// </summary>
        public const uint Argument_Encoding_DefaultXml = 297;

        /// <summary>
        /// The identifier for the EnumValueType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint EnumValueType_Encoding_DefaultXml = 7616;

        /// <summary>
        /// The identifier for the EnumField_Encoding_DefaultXml Object.
        /// </summary>
        public const uint EnumField_Encoding_DefaultXml = 14801;

        /// <summary>
        /// The identifier for the OptionSet_Encoding_DefaultXml Object.
        /// </summary>
        public const uint OptionSet_Encoding_DefaultXml = 12757;

        /// <summary>
        /// The identifier for the TimeZoneDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint TimeZoneDataType_Encoding_DefaultXml = 8913;

        /// <summary>
        /// The identifier for the ApplicationDescription_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ApplicationDescription_Encoding_DefaultXml = 309;

        /// <summary>
        /// The identifier for the RequestHeader_Encoding_DefaultXml Object.
        /// </summary>
        public const uint RequestHeader_Encoding_DefaultXml = 390;

        /// <summary>
        /// The identifier for the ResponseHeader_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ResponseHeader_Encoding_DefaultXml = 393;

        /// <summary>
        /// The identifier for the ServiceFault_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ServiceFault_Encoding_DefaultXml = 396;

        /// <summary>
        /// The identifier for the SessionlessInvokeRequestType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint SessionlessInvokeRequestType_Encoding_DefaultXml = 15902;

        /// <summary>
        /// The identifier for the SessionlessInvokeResponseType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint SessionlessInvokeResponseType_Encoding_DefaultXml = 21000;

        /// <summary>
        /// The identifier for the FindServersRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint FindServersRequest_Encoding_DefaultXml = 421;

        /// <summary>
        /// The identifier for the FindServersResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint FindServersResponse_Encoding_DefaultXml = 424;

        /// <summary>
        /// The identifier for the ServerOnNetwork_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ServerOnNetwork_Encoding_DefaultXml = 12195;

        /// <summary>
        /// The identifier for the FindServersOnNetworkRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint FindServersOnNetworkRequest_Encoding_DefaultXml = 12196;

        /// <summary>
        /// The identifier for the FindServersOnNetworkResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint FindServersOnNetworkResponse_Encoding_DefaultXml = 12197;

        /// <summary>
        /// The identifier for the UserTokenPolicy_Encoding_DefaultXml Object.
        /// </summary>
        public const uint UserTokenPolicy_Encoding_DefaultXml = 305;

        /// <summary>
        /// The identifier for the EndpointDescription_Encoding_DefaultXml Object.
        /// </summary>
        public const uint EndpointDescription_Encoding_DefaultXml = 313;

        /// <summary>
        /// The identifier for the GetEndpointsRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint GetEndpointsRequest_Encoding_DefaultXml = 427;

        /// <summary>
        /// The identifier for the GetEndpointsResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint GetEndpointsResponse_Encoding_DefaultXml = 430;

        /// <summary>
        /// The identifier for the RegisteredServer_Encoding_DefaultXml Object.
        /// </summary>
        public const uint RegisteredServer_Encoding_DefaultXml = 433;

        /// <summary>
        /// The identifier for the RegisterServerRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint RegisterServerRequest_Encoding_DefaultXml = 436;

        /// <summary>
        /// The identifier for the RegisterServerResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint RegisterServerResponse_Encoding_DefaultXml = 439;

        /// <summary>
        /// The identifier for the DiscoveryConfiguration_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DiscoveryConfiguration_Encoding_DefaultXml = 12892;

        /// <summary>
        /// The identifier for the MdnsDiscoveryConfiguration_Encoding_DefaultXml Object.
        /// </summary>
        public const uint MdnsDiscoveryConfiguration_Encoding_DefaultXml = 12893;

        /// <summary>
        /// The identifier for the RegisterServer2Request_Encoding_DefaultXml Object.
        /// </summary>
        public const uint RegisterServer2Request_Encoding_DefaultXml = 12199;

        /// <summary>
        /// The identifier for the RegisterServer2Response_Encoding_DefaultXml Object.
        /// </summary>
        public const uint RegisterServer2Response_Encoding_DefaultXml = 12200;

        /// <summary>
        /// The identifier for the ChannelSecurityToken_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ChannelSecurityToken_Encoding_DefaultXml = 442;

        /// <summary>
        /// The identifier for the OpenSecureChannelRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint OpenSecureChannelRequest_Encoding_DefaultXml = 445;

        /// <summary>
        /// The identifier for the OpenSecureChannelResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint OpenSecureChannelResponse_Encoding_DefaultXml = 448;

        /// <summary>
        /// The identifier for the CloseSecureChannelRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint CloseSecureChannelRequest_Encoding_DefaultXml = 451;

        /// <summary>
        /// The identifier for the CloseSecureChannelResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint CloseSecureChannelResponse_Encoding_DefaultXml = 454;

        /// <summary>
        /// The identifier for the SignedSoftwareCertificate_Encoding_DefaultXml Object.
        /// </summary>
        public const uint SignedSoftwareCertificate_Encoding_DefaultXml = 345;

        /// <summary>
        /// The identifier for the SignatureData_Encoding_DefaultXml Object.
        /// </summary>
        public const uint SignatureData_Encoding_DefaultXml = 457;

        /// <summary>
        /// The identifier for the CreateSessionRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint CreateSessionRequest_Encoding_DefaultXml = 460;

        /// <summary>
        /// The identifier for the CreateSessionResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint CreateSessionResponse_Encoding_DefaultXml = 463;

        /// <summary>
        /// The identifier for the UserIdentityToken_Encoding_DefaultXml Object.
        /// </summary>
        public const uint UserIdentityToken_Encoding_DefaultXml = 317;

        /// <summary>
        /// The identifier for the AnonymousIdentityToken_Encoding_DefaultXml Object.
        /// </summary>
        public const uint AnonymousIdentityToken_Encoding_DefaultXml = 320;

        /// <summary>
        /// The identifier for the UserNameIdentityToken_Encoding_DefaultXml Object.
        /// </summary>
        public const uint UserNameIdentityToken_Encoding_DefaultXml = 323;

        /// <summary>
        /// The identifier for the X509IdentityToken_Encoding_DefaultXml Object.
        /// </summary>
        public const uint X509IdentityToken_Encoding_DefaultXml = 326;

        /// <summary>
        /// The identifier for the IssuedIdentityToken_Encoding_DefaultXml Object.
        /// </summary>
        public const uint IssuedIdentityToken_Encoding_DefaultXml = 939;

        /// <summary>
        /// The identifier for the ActivateSessionRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ActivateSessionRequest_Encoding_DefaultXml = 466;

        /// <summary>
        /// The identifier for the ActivateSessionResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ActivateSessionResponse_Encoding_DefaultXml = 469;

        /// <summary>
        /// The identifier for the CloseSessionRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint CloseSessionRequest_Encoding_DefaultXml = 472;

        /// <summary>
        /// The identifier for the CloseSessionResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint CloseSessionResponse_Encoding_DefaultXml = 475;

        /// <summary>
        /// The identifier for the CancelRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint CancelRequest_Encoding_DefaultXml = 478;

        /// <summary>
        /// The identifier for the CancelResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint CancelResponse_Encoding_DefaultXml = 481;

        /// <summary>
        /// The identifier for the NodeAttributes_Encoding_DefaultXml Object.
        /// </summary>
        public const uint NodeAttributes_Encoding_DefaultXml = 350;

        /// <summary>
        /// The identifier for the ObjectAttributes_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ObjectAttributes_Encoding_DefaultXml = 353;

        /// <summary>
        /// The identifier for the VariableAttributes_Encoding_DefaultXml Object.
        /// </summary>
        public const uint VariableAttributes_Encoding_DefaultXml = 356;

        /// <summary>
        /// The identifier for the MethodAttributes_Encoding_DefaultXml Object.
        /// </summary>
        public const uint MethodAttributes_Encoding_DefaultXml = 359;

        /// <summary>
        /// The identifier for the ObjectTypeAttributes_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ObjectTypeAttributes_Encoding_DefaultXml = 362;

        /// <summary>
        /// The identifier for the VariableTypeAttributes_Encoding_DefaultXml Object.
        /// </summary>
        public const uint VariableTypeAttributes_Encoding_DefaultXml = 365;

        /// <summary>
        /// The identifier for the ReferenceTypeAttributes_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ReferenceTypeAttributes_Encoding_DefaultXml = 368;

        /// <summary>
        /// The identifier for the DataTypeAttributes_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DataTypeAttributes_Encoding_DefaultXml = 371;

        /// <summary>
        /// The identifier for the ViewAttributes_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ViewAttributes_Encoding_DefaultXml = 374;

        /// <summary>
        /// The identifier for the GenericAttributeValue_Encoding_DefaultXml Object.
        /// </summary>
        public const uint GenericAttributeValue_Encoding_DefaultXml = 17608;

        /// <summary>
        /// The identifier for the GenericAttributes_Encoding_DefaultXml Object.
        /// </summary>
        public const uint GenericAttributes_Encoding_DefaultXml = 17609;

        /// <summary>
        /// The identifier for the AddNodesItem_Encoding_DefaultXml Object.
        /// </summary>
        public const uint AddNodesItem_Encoding_DefaultXml = 377;

        /// <summary>
        /// The identifier for the AddNodesResult_Encoding_DefaultXml Object.
        /// </summary>
        public const uint AddNodesResult_Encoding_DefaultXml = 484;

        /// <summary>
        /// The identifier for the AddNodesRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint AddNodesRequest_Encoding_DefaultXml = 487;

        /// <summary>
        /// The identifier for the AddNodesResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint AddNodesResponse_Encoding_DefaultXml = 490;

        /// <summary>
        /// The identifier for the AddReferencesItem_Encoding_DefaultXml Object.
        /// </summary>
        public const uint AddReferencesItem_Encoding_DefaultXml = 380;

        /// <summary>
        /// The identifier for the AddReferencesRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint AddReferencesRequest_Encoding_DefaultXml = 493;

        /// <summary>
        /// The identifier for the AddReferencesResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint AddReferencesResponse_Encoding_DefaultXml = 496;

        /// <summary>
        /// The identifier for the DeleteNodesItem_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DeleteNodesItem_Encoding_DefaultXml = 383;

        /// <summary>
        /// The identifier for the DeleteNodesRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DeleteNodesRequest_Encoding_DefaultXml = 499;

        /// <summary>
        /// The identifier for the DeleteNodesResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DeleteNodesResponse_Encoding_DefaultXml = 502;

        /// <summary>
        /// The identifier for the DeleteReferencesItem_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DeleteReferencesItem_Encoding_DefaultXml = 386;

        /// <summary>
        /// The identifier for the DeleteReferencesRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DeleteReferencesRequest_Encoding_DefaultXml = 505;

        /// <summary>
        /// The identifier for the DeleteReferencesResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DeleteReferencesResponse_Encoding_DefaultXml = 508;

        /// <summary>
        /// The identifier for the ViewDescription_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ViewDescription_Encoding_DefaultXml = 512;

        /// <summary>
        /// The identifier for the BrowseDescription_Encoding_DefaultXml Object.
        /// </summary>
        public const uint BrowseDescription_Encoding_DefaultXml = 515;

        /// <summary>
        /// The identifier for the ReferenceDescription_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ReferenceDescription_Encoding_DefaultXml = 519;

        /// <summary>
        /// The identifier for the BrowseResult_Encoding_DefaultXml Object.
        /// </summary>
        public const uint BrowseResult_Encoding_DefaultXml = 523;

        /// <summary>
        /// The identifier for the BrowseRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint BrowseRequest_Encoding_DefaultXml = 526;

        /// <summary>
        /// The identifier for the BrowseResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint BrowseResponse_Encoding_DefaultXml = 529;

        /// <summary>
        /// The identifier for the BrowseNextRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint BrowseNextRequest_Encoding_DefaultXml = 532;

        /// <summary>
        /// The identifier for the BrowseNextResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint BrowseNextResponse_Encoding_DefaultXml = 535;

        /// <summary>
        /// The identifier for the RelativePathElement_Encoding_DefaultXml Object.
        /// </summary>
        public const uint RelativePathElement_Encoding_DefaultXml = 538;

        /// <summary>
        /// The identifier for the RelativePath_Encoding_DefaultXml Object.
        /// </summary>
        public const uint RelativePath_Encoding_DefaultXml = 541;

        /// <summary>
        /// The identifier for the BrowsePath_Encoding_DefaultXml Object.
        /// </summary>
        public const uint BrowsePath_Encoding_DefaultXml = 544;

        /// <summary>
        /// The identifier for the BrowsePathTarget_Encoding_DefaultXml Object.
        /// </summary>
        public const uint BrowsePathTarget_Encoding_DefaultXml = 547;

        /// <summary>
        /// The identifier for the BrowsePathResult_Encoding_DefaultXml Object.
        /// </summary>
        public const uint BrowsePathResult_Encoding_DefaultXml = 550;

        /// <summary>
        /// The identifier for the TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultXml = 553;

        /// <summary>
        /// The identifier for the TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultXml = 556;

        /// <summary>
        /// The identifier for the RegisterNodesRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint RegisterNodesRequest_Encoding_DefaultXml = 559;

        /// <summary>
        /// The identifier for the RegisterNodesResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint RegisterNodesResponse_Encoding_DefaultXml = 562;

        /// <summary>
        /// The identifier for the UnregisterNodesRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint UnregisterNodesRequest_Encoding_DefaultXml = 565;

        /// <summary>
        /// The identifier for the UnregisterNodesResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint UnregisterNodesResponse_Encoding_DefaultXml = 568;

        /// <summary>
        /// The identifier for the EndpointConfiguration_Encoding_DefaultXml Object.
        /// </summary>
        public const uint EndpointConfiguration_Encoding_DefaultXml = 332;

        /// <summary>
        /// The identifier for the QueryDataDescription_Encoding_DefaultXml Object.
        /// </summary>
        public const uint QueryDataDescription_Encoding_DefaultXml = 571;

        /// <summary>
        /// The identifier for the NodeTypeDescription_Encoding_DefaultXml Object.
        /// </summary>
        public const uint NodeTypeDescription_Encoding_DefaultXml = 574;

        /// <summary>
        /// The identifier for the QueryDataSet_Encoding_DefaultXml Object.
        /// </summary>
        public const uint QueryDataSet_Encoding_DefaultXml = 578;

        /// <summary>
        /// The identifier for the NodeReference_Encoding_DefaultXml Object.
        /// </summary>
        public const uint NodeReference_Encoding_DefaultXml = 581;

        /// <summary>
        /// The identifier for the ContentFilterElement_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ContentFilterElement_Encoding_DefaultXml = 584;

        /// <summary>
        /// The identifier for the ContentFilter_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ContentFilter_Encoding_DefaultXml = 587;

        /// <summary>
        /// The identifier for the FilterOperand_Encoding_DefaultXml Object.
        /// </summary>
        public const uint FilterOperand_Encoding_DefaultXml = 590;

        /// <summary>
        /// The identifier for the ElementOperand_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ElementOperand_Encoding_DefaultXml = 593;

        /// <summary>
        /// The identifier for the LiteralOperand_Encoding_DefaultXml Object.
        /// </summary>
        public const uint LiteralOperand_Encoding_DefaultXml = 596;

        /// <summary>
        /// The identifier for the AttributeOperand_Encoding_DefaultXml Object.
        /// </summary>
        public const uint AttributeOperand_Encoding_DefaultXml = 599;

        /// <summary>
        /// The identifier for the SimpleAttributeOperand_Encoding_DefaultXml Object.
        /// </summary>
        public const uint SimpleAttributeOperand_Encoding_DefaultXml = 602;

        /// <summary>
        /// The identifier for the ContentFilterElementResult_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ContentFilterElementResult_Encoding_DefaultXml = 605;

        /// <summary>
        /// The identifier for the ContentFilterResult_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ContentFilterResult_Encoding_DefaultXml = 608;

        /// <summary>
        /// The identifier for the ParsingResult_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ParsingResult_Encoding_DefaultXml = 611;

        /// <summary>
        /// The identifier for the QueryFirstRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint QueryFirstRequest_Encoding_DefaultXml = 614;

        /// <summary>
        /// The identifier for the QueryFirstResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint QueryFirstResponse_Encoding_DefaultXml = 617;

        /// <summary>
        /// The identifier for the QueryNextRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint QueryNextRequest_Encoding_DefaultXml = 620;

        /// <summary>
        /// The identifier for the QueryNextResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint QueryNextResponse_Encoding_DefaultXml = 623;

        /// <summary>
        /// The identifier for the ReadValueId_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ReadValueId_Encoding_DefaultXml = 627;

        /// <summary>
        /// The identifier for the ReadRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ReadRequest_Encoding_DefaultXml = 630;

        /// <summary>
        /// The identifier for the ReadResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ReadResponse_Encoding_DefaultXml = 633;

        /// <summary>
        /// The identifier for the HistoryReadValueId_Encoding_DefaultXml Object.
        /// </summary>
        public const uint HistoryReadValueId_Encoding_DefaultXml = 636;

        /// <summary>
        /// The identifier for the HistoryReadResult_Encoding_DefaultXml Object.
        /// </summary>
        public const uint HistoryReadResult_Encoding_DefaultXml = 639;

        /// <summary>
        /// The identifier for the HistoryReadDetails_Encoding_DefaultXml Object.
        /// </summary>
        public const uint HistoryReadDetails_Encoding_DefaultXml = 642;

        /// <summary>
        /// The identifier for the ReadEventDetails_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ReadEventDetails_Encoding_DefaultXml = 645;

        /// <summary>
        /// The identifier for the ReadRawModifiedDetails_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ReadRawModifiedDetails_Encoding_DefaultXml = 648;

        /// <summary>
        /// The identifier for the ReadProcessedDetails_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ReadProcessedDetails_Encoding_DefaultXml = 651;

        /// <summary>
        /// The identifier for the ReadAtTimeDetails_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ReadAtTimeDetails_Encoding_DefaultXml = 654;

        /// <summary>
        /// The identifier for the ReadAnnotationDataDetails_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ReadAnnotationDataDetails_Encoding_DefaultXml = 23506;

        /// <summary>
        /// The identifier for the HistoryData_Encoding_DefaultXml Object.
        /// </summary>
        public const uint HistoryData_Encoding_DefaultXml = 657;

        /// <summary>
        /// The identifier for the ModificationInfo_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ModificationInfo_Encoding_DefaultXml = 11218;

        /// <summary>
        /// The identifier for the HistoryModifiedData_Encoding_DefaultXml Object.
        /// </summary>
        public const uint HistoryModifiedData_Encoding_DefaultXml = 11219;

        /// <summary>
        /// The identifier for the HistoryEvent_Encoding_DefaultXml Object.
        /// </summary>
        public const uint HistoryEvent_Encoding_DefaultXml = 660;

        /// <summary>
        /// The identifier for the HistoryReadRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint HistoryReadRequest_Encoding_DefaultXml = 663;

        /// <summary>
        /// The identifier for the HistoryReadResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint HistoryReadResponse_Encoding_DefaultXml = 666;

        /// <summary>
        /// The identifier for the WriteValue_Encoding_DefaultXml Object.
        /// </summary>
        public const uint WriteValue_Encoding_DefaultXml = 669;

        /// <summary>
        /// The identifier for the WriteRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint WriteRequest_Encoding_DefaultXml = 672;

        /// <summary>
        /// The identifier for the WriteResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint WriteResponse_Encoding_DefaultXml = 675;

        /// <summary>
        /// The identifier for the HistoryUpdateDetails_Encoding_DefaultXml Object.
        /// </summary>
        public const uint HistoryUpdateDetails_Encoding_DefaultXml = 678;

        /// <summary>
        /// The identifier for the UpdateDataDetails_Encoding_DefaultXml Object.
        /// </summary>
        public const uint UpdateDataDetails_Encoding_DefaultXml = 681;

        /// <summary>
        /// The identifier for the UpdateStructureDataDetails_Encoding_DefaultXml Object.
        /// </summary>
        public const uint UpdateStructureDataDetails_Encoding_DefaultXml = 11296;

        /// <summary>
        /// The identifier for the UpdateEventDetails_Encoding_DefaultXml Object.
        /// </summary>
        public const uint UpdateEventDetails_Encoding_DefaultXml = 684;

        /// <summary>
        /// The identifier for the DeleteRawModifiedDetails_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DeleteRawModifiedDetails_Encoding_DefaultXml = 687;

        /// <summary>
        /// The identifier for the DeleteAtTimeDetails_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DeleteAtTimeDetails_Encoding_DefaultXml = 690;

        /// <summary>
        /// The identifier for the DeleteEventDetails_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DeleteEventDetails_Encoding_DefaultXml = 693;

        /// <summary>
        /// The identifier for the HistoryUpdateResult_Encoding_DefaultXml Object.
        /// </summary>
        public const uint HistoryUpdateResult_Encoding_DefaultXml = 696;

        /// <summary>
        /// The identifier for the HistoryUpdateRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint HistoryUpdateRequest_Encoding_DefaultXml = 699;

        /// <summary>
        /// The identifier for the HistoryUpdateResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint HistoryUpdateResponse_Encoding_DefaultXml = 702;

        /// <summary>
        /// The identifier for the CallMethodRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint CallMethodRequest_Encoding_DefaultXml = 705;

        /// <summary>
        /// The identifier for the CallMethodResult_Encoding_DefaultXml Object.
        /// </summary>
        public const uint CallMethodResult_Encoding_DefaultXml = 708;

        /// <summary>
        /// The identifier for the CallRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint CallRequest_Encoding_DefaultXml = 711;

        /// <summary>
        /// The identifier for the CallResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint CallResponse_Encoding_DefaultXml = 714;

        /// <summary>
        /// The identifier for the MonitoringFilter_Encoding_DefaultXml Object.
        /// </summary>
        public const uint MonitoringFilter_Encoding_DefaultXml = 720;

        /// <summary>
        /// The identifier for the DataChangeFilter_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DataChangeFilter_Encoding_DefaultXml = 723;

        /// <summary>
        /// The identifier for the EventFilter_Encoding_DefaultXml Object.
        /// </summary>
        public const uint EventFilter_Encoding_DefaultXml = 726;

        /// <summary>
        /// The identifier for the AggregateConfiguration_Encoding_DefaultXml Object.
        /// </summary>
        public const uint AggregateConfiguration_Encoding_DefaultXml = 949;

        /// <summary>
        /// The identifier for the AggregateFilter_Encoding_DefaultXml Object.
        /// </summary>
        public const uint AggregateFilter_Encoding_DefaultXml = 729;

        /// <summary>
        /// The identifier for the MonitoringFilterResult_Encoding_DefaultXml Object.
        /// </summary>
        public const uint MonitoringFilterResult_Encoding_DefaultXml = 732;

        /// <summary>
        /// The identifier for the EventFilterResult_Encoding_DefaultXml Object.
        /// </summary>
        public const uint EventFilterResult_Encoding_DefaultXml = 735;

        /// <summary>
        /// The identifier for the AggregateFilterResult_Encoding_DefaultXml Object.
        /// </summary>
        public const uint AggregateFilterResult_Encoding_DefaultXml = 738;

        /// <summary>
        /// The identifier for the MonitoringParameters_Encoding_DefaultXml Object.
        /// </summary>
        public const uint MonitoringParameters_Encoding_DefaultXml = 741;

        /// <summary>
        /// The identifier for the MonitoredItemCreateRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint MonitoredItemCreateRequest_Encoding_DefaultXml = 744;

        /// <summary>
        /// The identifier for the MonitoredItemCreateResult_Encoding_DefaultXml Object.
        /// </summary>
        public const uint MonitoredItemCreateResult_Encoding_DefaultXml = 747;

        /// <summary>
        /// The identifier for the CreateMonitoredItemsRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint CreateMonitoredItemsRequest_Encoding_DefaultXml = 750;

        /// <summary>
        /// The identifier for the CreateMonitoredItemsResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint CreateMonitoredItemsResponse_Encoding_DefaultXml = 753;

        /// <summary>
        /// The identifier for the MonitoredItemModifyRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint MonitoredItemModifyRequest_Encoding_DefaultXml = 756;

        /// <summary>
        /// The identifier for the MonitoredItemModifyResult_Encoding_DefaultXml Object.
        /// </summary>
        public const uint MonitoredItemModifyResult_Encoding_DefaultXml = 759;

        /// <summary>
        /// The identifier for the ModifyMonitoredItemsRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ModifyMonitoredItemsRequest_Encoding_DefaultXml = 762;

        /// <summary>
        /// The identifier for the ModifyMonitoredItemsResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ModifyMonitoredItemsResponse_Encoding_DefaultXml = 765;

        /// <summary>
        /// The identifier for the SetMonitoringModeRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint SetMonitoringModeRequest_Encoding_DefaultXml = 768;

        /// <summary>
        /// The identifier for the SetMonitoringModeResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint SetMonitoringModeResponse_Encoding_DefaultXml = 771;

        /// <summary>
        /// The identifier for the SetTriggeringRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint SetTriggeringRequest_Encoding_DefaultXml = 774;

        /// <summary>
        /// The identifier for the SetTriggeringResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint SetTriggeringResponse_Encoding_DefaultXml = 777;

        /// <summary>
        /// The identifier for the DeleteMonitoredItemsRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DeleteMonitoredItemsRequest_Encoding_DefaultXml = 780;

        /// <summary>
        /// The identifier for the DeleteMonitoredItemsResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DeleteMonitoredItemsResponse_Encoding_DefaultXml = 783;

        /// <summary>
        /// The identifier for the CreateSubscriptionRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint CreateSubscriptionRequest_Encoding_DefaultXml = 786;

        /// <summary>
        /// The identifier for the CreateSubscriptionResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint CreateSubscriptionResponse_Encoding_DefaultXml = 789;

        /// <summary>
        /// The identifier for the ModifySubscriptionRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ModifySubscriptionRequest_Encoding_DefaultXml = 792;

        /// <summary>
        /// The identifier for the ModifySubscriptionResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ModifySubscriptionResponse_Encoding_DefaultXml = 795;

        /// <summary>
        /// The identifier for the SetPublishingModeRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint SetPublishingModeRequest_Encoding_DefaultXml = 798;

        /// <summary>
        /// The identifier for the SetPublishingModeResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint SetPublishingModeResponse_Encoding_DefaultXml = 801;

        /// <summary>
        /// The identifier for the NotificationMessage_Encoding_DefaultXml Object.
        /// </summary>
        public const uint NotificationMessage_Encoding_DefaultXml = 804;

        /// <summary>
        /// The identifier for the NotificationData_Encoding_DefaultXml Object.
        /// </summary>
        public const uint NotificationData_Encoding_DefaultXml = 946;

        /// <summary>
        /// The identifier for the DataChangeNotification_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DataChangeNotification_Encoding_DefaultXml = 810;

        /// <summary>
        /// The identifier for the MonitoredItemNotification_Encoding_DefaultXml Object.
        /// </summary>
        public const uint MonitoredItemNotification_Encoding_DefaultXml = 807;

        /// <summary>
        /// The identifier for the EventNotificationList_Encoding_DefaultXml Object.
        /// </summary>
        public const uint EventNotificationList_Encoding_DefaultXml = 915;

        /// <summary>
        /// The identifier for the EventFieldList_Encoding_DefaultXml Object.
        /// </summary>
        public const uint EventFieldList_Encoding_DefaultXml = 918;

        /// <summary>
        /// The identifier for the HistoryEventFieldList_Encoding_DefaultXml Object.
        /// </summary>
        public const uint HistoryEventFieldList_Encoding_DefaultXml = 921;

        /// <summary>
        /// The identifier for the StatusChangeNotification_Encoding_DefaultXml Object.
        /// </summary>
        public const uint StatusChangeNotification_Encoding_DefaultXml = 819;

        /// <summary>
        /// The identifier for the SubscriptionAcknowledgement_Encoding_DefaultXml Object.
        /// </summary>
        public const uint SubscriptionAcknowledgement_Encoding_DefaultXml = 822;

        /// <summary>
        /// The identifier for the PublishRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint PublishRequest_Encoding_DefaultXml = 825;

        /// <summary>
        /// The identifier for the PublishResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint PublishResponse_Encoding_DefaultXml = 828;

        /// <summary>
        /// The identifier for the RepublishRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint RepublishRequest_Encoding_DefaultXml = 831;

        /// <summary>
        /// The identifier for the RepublishResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint RepublishResponse_Encoding_DefaultXml = 834;

        /// <summary>
        /// The identifier for the TransferResult_Encoding_DefaultXml Object.
        /// </summary>
        public const uint TransferResult_Encoding_DefaultXml = 837;

        /// <summary>
        /// The identifier for the TransferSubscriptionsRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint TransferSubscriptionsRequest_Encoding_DefaultXml = 840;

        /// <summary>
        /// The identifier for the TransferSubscriptionsResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint TransferSubscriptionsResponse_Encoding_DefaultXml = 843;

        /// <summary>
        /// The identifier for the DeleteSubscriptionsRequest_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DeleteSubscriptionsRequest_Encoding_DefaultXml = 846;

        /// <summary>
        /// The identifier for the DeleteSubscriptionsResponse_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DeleteSubscriptionsResponse_Encoding_DefaultXml = 849;

        /// <summary>
        /// The identifier for the BuildInfo_Encoding_DefaultXml Object.
        /// </summary>
        public const uint BuildInfo_Encoding_DefaultXml = 339;

        /// <summary>
        /// The identifier for the RedundantServerDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint RedundantServerDataType_Encoding_DefaultXml = 854;

        /// <summary>
        /// The identifier for the EndpointUrlListDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint EndpointUrlListDataType_Encoding_DefaultXml = 11949;

        /// <summary>
        /// The identifier for the NetworkGroupDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint NetworkGroupDataType_Encoding_DefaultXml = 11950;

        /// <summary>
        /// The identifier for the SamplingIntervalDiagnosticsDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint SamplingIntervalDiagnosticsDataType_Encoding_DefaultXml = 857;

        /// <summary>
        /// The identifier for the ServerDiagnosticsSummaryDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ServerDiagnosticsSummaryDataType_Encoding_DefaultXml = 860;

        /// <summary>
        /// The identifier for the ServerStatusDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ServerStatusDataType_Encoding_DefaultXml = 863;

        /// <summary>
        /// The identifier for the SessionDiagnosticsDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint SessionDiagnosticsDataType_Encoding_DefaultXml = 866;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint SessionSecurityDiagnosticsDataType_Encoding_DefaultXml = 869;

        /// <summary>
        /// The identifier for the ServiceCounterDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ServiceCounterDataType_Encoding_DefaultXml = 872;

        /// <summary>
        /// The identifier for the StatusResult_Encoding_DefaultXml Object.
        /// </summary>
        public const uint StatusResult_Encoding_DefaultXml = 300;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint SubscriptionDiagnosticsDataType_Encoding_DefaultXml = 875;

        /// <summary>
        /// The identifier for the ModelChangeStructureDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ModelChangeStructureDataType_Encoding_DefaultXml = 878;

        /// <summary>
        /// The identifier for the SemanticChangeStructureDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint SemanticChangeStructureDataType_Encoding_DefaultXml = 898;

        /// <summary>
        /// The identifier for the Range_Encoding_DefaultXml Object.
        /// </summary>
        public const uint Range_Encoding_DefaultXml = 885;

        /// <summary>
        /// The identifier for the EUInformation_Encoding_DefaultXml Object.
        /// </summary>
        public const uint EUInformation_Encoding_DefaultXml = 888;

        /// <summary>
        /// The identifier for the ComplexNumberType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ComplexNumberType_Encoding_DefaultXml = 12173;

        /// <summary>
        /// The identifier for the DoubleComplexNumberType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint DoubleComplexNumberType_Encoding_DefaultXml = 12174;

        /// <summary>
        /// The identifier for the AxisInformation_Encoding_DefaultXml Object.
        /// </summary>
        public const uint AxisInformation_Encoding_DefaultXml = 12081;

        /// <summary>
        /// The identifier for the XVType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint XVType_Encoding_DefaultXml = 12082;

        /// <summary>
        /// The identifier for the ProgramDiagnosticDataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ProgramDiagnosticDataType_Encoding_DefaultXml = 895;

        /// <summary>
        /// The identifier for the ProgramDiagnostic2DataType_Encoding_DefaultXml Object.
        /// </summary>
        public const uint ProgramDiagnostic2DataType_Encoding_DefaultXml = 24038;

        /// <summary>
        /// The identifier for the Annotation_Encoding_DefaultXml Object.
        /// </summary>
        public const uint Annotation_Encoding_DefaultXml = 892;

        /// <summary>
        /// The identifier for the Union_Encoding_DefaultJson Object.
        /// </summary>
        public const uint Union_Encoding_DefaultJson = 15085;

        /// <summary>
        /// The identifier for the KeyValuePair_Encoding_DefaultJson Object.
        /// </summary>
        public const uint KeyValuePair_Encoding_DefaultJson = 15041;

        /// <summary>
        /// The identifier for the AdditionalParametersType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint AdditionalParametersType_Encoding_DefaultJson = 17547;

        /// <summary>
        /// The identifier for the EphemeralKeyType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint EphemeralKeyType_Encoding_DefaultJson = 17557;

        /// <summary>
        /// The identifier for the EndpointType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint EndpointType_Encoding_DefaultJson = 16150;

        /// <summary>
        /// The identifier for the RationalNumber_Encoding_DefaultJson Object.
        /// </summary>
        public const uint RationalNumber_Encoding_DefaultJson = 19064;

        /// <summary>
        /// The identifier for the Vector_Encoding_DefaultJson Object.
        /// </summary>
        public const uint Vector_Encoding_DefaultJson = 19065;

        /// <summary>
        /// The identifier for the ThreeDVector_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ThreeDVector_Encoding_DefaultJson = 19066;

        /// <summary>
        /// The identifier for the CartesianCoordinates_Encoding_DefaultJson Object.
        /// </summary>
        public const uint CartesianCoordinates_Encoding_DefaultJson = 19067;

        /// <summary>
        /// The identifier for the ThreeDCartesianCoordinates_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ThreeDCartesianCoordinates_Encoding_DefaultJson = 19068;

        /// <summary>
        /// The identifier for the Orientation_Encoding_DefaultJson Object.
        /// </summary>
        public const uint Orientation_Encoding_DefaultJson = 19069;

        /// <summary>
        /// The identifier for the ThreeDOrientation_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ThreeDOrientation_Encoding_DefaultJson = 19070;

        /// <summary>
        /// The identifier for the Frame_Encoding_DefaultJson Object.
        /// </summary>
        public const uint Frame_Encoding_DefaultJson = 19071;

        /// <summary>
        /// The identifier for the ThreeDFrame_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ThreeDFrame_Encoding_DefaultJson = 19072;

        /// <summary>
        /// The identifier for the IdentityMappingRuleType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint IdentityMappingRuleType_Encoding_DefaultJson = 15042;

        /// <summary>
        /// The identifier for the CurrencyUnitType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint CurrencyUnitType_Encoding_DefaultJson = 23528;

        /// <summary>
        /// The identifier for the TrustListDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint TrustListDataType_Encoding_DefaultJson = 15044;

        /// <summary>
        /// The identifier for the DecimalDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DecimalDataType_Encoding_DefaultJson = 15045;

        /// <summary>
        /// The identifier for the DataTypeSchemaHeader_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DataTypeSchemaHeader_Encoding_DefaultJson = 16151;

        /// <summary>
        /// The identifier for the DataTypeDescription_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DataTypeDescription_Encoding_DefaultJson = 15057;

        /// <summary>
        /// The identifier for the StructureDescription_Encoding_DefaultJson Object.
        /// </summary>
        public const uint StructureDescription_Encoding_DefaultJson = 15058;

        /// <summary>
        /// The identifier for the EnumDescription_Encoding_DefaultJson Object.
        /// </summary>
        public const uint EnumDescription_Encoding_DefaultJson = 15059;

        /// <summary>
        /// The identifier for the SimpleTypeDescription_Encoding_DefaultJson Object.
        /// </summary>
        public const uint SimpleTypeDescription_Encoding_DefaultJson = 15700;

        /// <summary>
        /// The identifier for the UABinaryFileDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint UABinaryFileDataType_Encoding_DefaultJson = 15714;

        /// <summary>
        /// The identifier for the DataSetMetaDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DataSetMetaDataType_Encoding_DefaultJson = 15050;

        /// <summary>
        /// The identifier for the FieldMetaData_Encoding_DefaultJson Object.
        /// </summary>
        public const uint FieldMetaData_Encoding_DefaultJson = 15051;

        /// <summary>
        /// The identifier for the ConfigurationVersionDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ConfigurationVersionDataType_Encoding_DefaultJson = 15049;

        /// <summary>
        /// The identifier for the PublishedDataSetDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint PublishedDataSetDataType_Encoding_DefaultJson = 16152;

        /// <summary>
        /// The identifier for the PublishedDataSetSourceDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint PublishedDataSetSourceDataType_Encoding_DefaultJson = 16153;

        /// <summary>
        /// The identifier for the PublishedVariableDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint PublishedVariableDataType_Encoding_DefaultJson = 15060;

        /// <summary>
        /// The identifier for the PublishedDataItemsDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint PublishedDataItemsDataType_Encoding_DefaultJson = 16154;

        /// <summary>
        /// The identifier for the PublishedEventsDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint PublishedEventsDataType_Encoding_DefaultJson = 16155;

        /// <summary>
        /// The identifier for the DataSetWriterDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DataSetWriterDataType_Encoding_DefaultJson = 16156;

        /// <summary>
        /// The identifier for the DataSetWriterTransportDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DataSetWriterTransportDataType_Encoding_DefaultJson = 16157;

        /// <summary>
        /// The identifier for the DataSetWriterMessageDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DataSetWriterMessageDataType_Encoding_DefaultJson = 16158;

        /// <summary>
        /// The identifier for the PubSubGroupDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint PubSubGroupDataType_Encoding_DefaultJson = 16159;

        /// <summary>
        /// The identifier for the WriterGroupDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint WriterGroupDataType_Encoding_DefaultJson = 21198;

        /// <summary>
        /// The identifier for the WriterGroupTransportDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint WriterGroupTransportDataType_Encoding_DefaultJson = 16161;

        /// <summary>
        /// The identifier for the WriterGroupMessageDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint WriterGroupMessageDataType_Encoding_DefaultJson = 16280;

        /// <summary>
        /// The identifier for the PubSubConnectionDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint PubSubConnectionDataType_Encoding_DefaultJson = 16281;

        /// <summary>
        /// The identifier for the ConnectionTransportDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ConnectionTransportDataType_Encoding_DefaultJson = 16282;

        /// <summary>
        /// The identifier for the NetworkAddressDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint NetworkAddressDataType_Encoding_DefaultJson = 21199;

        /// <summary>
        /// The identifier for the NetworkAddressUrlDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint NetworkAddressUrlDataType_Encoding_DefaultJson = 21200;

        /// <summary>
        /// The identifier for the ReaderGroupDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ReaderGroupDataType_Encoding_DefaultJson = 21201;

        /// <summary>
        /// The identifier for the ReaderGroupTransportDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ReaderGroupTransportDataType_Encoding_DefaultJson = 16284;

        /// <summary>
        /// The identifier for the ReaderGroupMessageDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ReaderGroupMessageDataType_Encoding_DefaultJson = 16285;

        /// <summary>
        /// The identifier for the DataSetReaderDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DataSetReaderDataType_Encoding_DefaultJson = 16286;

        /// <summary>
        /// The identifier for the DataSetReaderTransportDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DataSetReaderTransportDataType_Encoding_DefaultJson = 16287;

        /// <summary>
        /// The identifier for the DataSetReaderMessageDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DataSetReaderMessageDataType_Encoding_DefaultJson = 16288;

        /// <summary>
        /// The identifier for the SubscribedDataSetDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint SubscribedDataSetDataType_Encoding_DefaultJson = 16308;

        /// <summary>
        /// The identifier for the TargetVariablesDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint TargetVariablesDataType_Encoding_DefaultJson = 16310;

        /// <summary>
        /// The identifier for the FieldTargetDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint FieldTargetDataType_Encoding_DefaultJson = 15061;

        /// <summary>
        /// The identifier for the SubscribedDataSetMirrorDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint SubscribedDataSetMirrorDataType_Encoding_DefaultJson = 16311;

        /// <summary>
        /// The identifier for the PubSubConfigurationDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint PubSubConfigurationDataType_Encoding_DefaultJson = 21202;

        /// <summary>
        /// The identifier for the UadpWriterGroupMessageDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint UadpWriterGroupMessageDataType_Encoding_DefaultJson = 16323;

        /// <summary>
        /// The identifier for the UadpDataSetWriterMessageDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint UadpDataSetWriterMessageDataType_Encoding_DefaultJson = 16391;

        /// <summary>
        /// The identifier for the UadpDataSetReaderMessageDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint UadpDataSetReaderMessageDataType_Encoding_DefaultJson = 16392;

        /// <summary>
        /// The identifier for the JsonWriterGroupMessageDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint JsonWriterGroupMessageDataType_Encoding_DefaultJson = 16393;

        /// <summary>
        /// The identifier for the JsonDataSetWriterMessageDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint JsonDataSetWriterMessageDataType_Encoding_DefaultJson = 16394;

        /// <summary>
        /// The identifier for the JsonDataSetReaderMessageDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint JsonDataSetReaderMessageDataType_Encoding_DefaultJson = 16404;

        /// <summary>
        /// The identifier for the DatagramConnectionTransportDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DatagramConnectionTransportDataType_Encoding_DefaultJson = 17476;

        /// <summary>
        /// The identifier for the DatagramWriterGroupTransportDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DatagramWriterGroupTransportDataType_Encoding_DefaultJson = 21203;

        /// <summary>
        /// The identifier for the BrokerConnectionTransportDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint BrokerConnectionTransportDataType_Encoding_DefaultJson = 15726;

        /// <summary>
        /// The identifier for the BrokerWriterGroupTransportDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint BrokerWriterGroupTransportDataType_Encoding_DefaultJson = 16524;

        /// <summary>
        /// The identifier for the BrokerDataSetWriterTransportDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint BrokerDataSetWriterTransportDataType_Encoding_DefaultJson = 16525;

        /// <summary>
        /// The identifier for the BrokerDataSetReaderTransportDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint BrokerDataSetReaderTransportDataType_Encoding_DefaultJson = 16526;

        /// <summary>
        /// The identifier for the AliasNameDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint AliasNameDataType_Encoding_DefaultJson = 23511;

        /// <summary>
        /// The identifier for the UnsignedRationalNumber_Encoding_DefaultJson Object.
        /// </summary>
        public const uint UnsignedRationalNumber_Encoding_DefaultJson = 24134;

        /// <summary>
        /// The identifier for the RolePermissionType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint RolePermissionType_Encoding_DefaultJson = 15062;

        /// <summary>
        /// The identifier for the DataTypeDefinition_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DataTypeDefinition_Encoding_DefaultJson = 15063;

        /// <summary>
        /// The identifier for the StructureField_Encoding_DefaultJson Object.
        /// </summary>
        public const uint StructureField_Encoding_DefaultJson = 15065;

        /// <summary>
        /// The identifier for the StructureDefinition_Encoding_DefaultJson Object.
        /// </summary>
        public const uint StructureDefinition_Encoding_DefaultJson = 15066;

        /// <summary>
        /// The identifier for the EnumDefinition_Encoding_DefaultJson Object.
        /// </summary>
        public const uint EnumDefinition_Encoding_DefaultJson = 15067;

        /// <summary>
        /// The identifier for the Node_Encoding_DefaultJson Object.
        /// </summary>
        public const uint Node_Encoding_DefaultJson = 15068;

        /// <summary>
        /// The identifier for the InstanceNode_Encoding_DefaultJson Object.
        /// </summary>
        public const uint InstanceNode_Encoding_DefaultJson = 15069;

        /// <summary>
        /// The identifier for the TypeNode_Encoding_DefaultJson Object.
        /// </summary>
        public const uint TypeNode_Encoding_DefaultJson = 15070;

        /// <summary>
        /// The identifier for the ObjectNode_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ObjectNode_Encoding_DefaultJson = 15071;

        /// <summary>
        /// The identifier for the ObjectTypeNode_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ObjectTypeNode_Encoding_DefaultJson = 15073;

        /// <summary>
        /// The identifier for the VariableNode_Encoding_DefaultJson Object.
        /// </summary>
        public const uint VariableNode_Encoding_DefaultJson = 15074;

        /// <summary>
        /// The identifier for the VariableTypeNode_Encoding_DefaultJson Object.
        /// </summary>
        public const uint VariableTypeNode_Encoding_DefaultJson = 15075;

        /// <summary>
        /// The identifier for the ReferenceTypeNode_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ReferenceTypeNode_Encoding_DefaultJson = 15076;

        /// <summary>
        /// The identifier for the MethodNode_Encoding_DefaultJson Object.
        /// </summary>
        public const uint MethodNode_Encoding_DefaultJson = 15077;

        /// <summary>
        /// The identifier for the ViewNode_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ViewNode_Encoding_DefaultJson = 15078;

        /// <summary>
        /// The identifier for the DataTypeNode_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DataTypeNode_Encoding_DefaultJson = 15079;

        /// <summary>
        /// The identifier for the ReferenceNode_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ReferenceNode_Encoding_DefaultJson = 15080;

        /// <summary>
        /// The identifier for the Argument_Encoding_DefaultJson Object.
        /// </summary>
        public const uint Argument_Encoding_DefaultJson = 15081;

        /// <summary>
        /// The identifier for the EnumValueType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint EnumValueType_Encoding_DefaultJson = 15082;

        /// <summary>
        /// The identifier for the EnumField_Encoding_DefaultJson Object.
        /// </summary>
        public const uint EnumField_Encoding_DefaultJson = 15083;

        /// <summary>
        /// The identifier for the OptionSet_Encoding_DefaultJson Object.
        /// </summary>
        public const uint OptionSet_Encoding_DefaultJson = 15084;

        /// <summary>
        /// The identifier for the TimeZoneDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint TimeZoneDataType_Encoding_DefaultJson = 15086;

        /// <summary>
        /// The identifier for the ApplicationDescription_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ApplicationDescription_Encoding_DefaultJson = 15087;

        /// <summary>
        /// The identifier for the RequestHeader_Encoding_DefaultJson Object.
        /// </summary>
        public const uint RequestHeader_Encoding_DefaultJson = 15088;

        /// <summary>
        /// The identifier for the ResponseHeader_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ResponseHeader_Encoding_DefaultJson = 15089;

        /// <summary>
        /// The identifier for the ServiceFault_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ServiceFault_Encoding_DefaultJson = 15090;

        /// <summary>
        /// The identifier for the SessionlessInvokeRequestType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint SessionlessInvokeRequestType_Encoding_DefaultJson = 15091;

        /// <summary>
        /// The identifier for the SessionlessInvokeResponseType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint SessionlessInvokeResponseType_Encoding_DefaultJson = 15092;

        /// <summary>
        /// The identifier for the FindServersRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint FindServersRequest_Encoding_DefaultJson = 15093;

        /// <summary>
        /// The identifier for the FindServersResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint FindServersResponse_Encoding_DefaultJson = 15094;

        /// <summary>
        /// The identifier for the ServerOnNetwork_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ServerOnNetwork_Encoding_DefaultJson = 15095;

        /// <summary>
        /// The identifier for the FindServersOnNetworkRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint FindServersOnNetworkRequest_Encoding_DefaultJson = 15096;

        /// <summary>
        /// The identifier for the FindServersOnNetworkResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint FindServersOnNetworkResponse_Encoding_DefaultJson = 15097;

        /// <summary>
        /// The identifier for the UserTokenPolicy_Encoding_DefaultJson Object.
        /// </summary>
        public const uint UserTokenPolicy_Encoding_DefaultJson = 15098;

        /// <summary>
        /// The identifier for the EndpointDescription_Encoding_DefaultJson Object.
        /// </summary>
        public const uint EndpointDescription_Encoding_DefaultJson = 15099;

        /// <summary>
        /// The identifier for the GetEndpointsRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint GetEndpointsRequest_Encoding_DefaultJson = 15100;

        /// <summary>
        /// The identifier for the GetEndpointsResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint GetEndpointsResponse_Encoding_DefaultJson = 15101;

        /// <summary>
        /// The identifier for the RegisteredServer_Encoding_DefaultJson Object.
        /// </summary>
        public const uint RegisteredServer_Encoding_DefaultJson = 15102;

        /// <summary>
        /// The identifier for the RegisterServerRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint RegisterServerRequest_Encoding_DefaultJson = 15103;

        /// <summary>
        /// The identifier for the RegisterServerResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint RegisterServerResponse_Encoding_DefaultJson = 15104;

        /// <summary>
        /// The identifier for the DiscoveryConfiguration_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DiscoveryConfiguration_Encoding_DefaultJson = 15105;

        /// <summary>
        /// The identifier for the MdnsDiscoveryConfiguration_Encoding_DefaultJson Object.
        /// </summary>
        public const uint MdnsDiscoveryConfiguration_Encoding_DefaultJson = 15106;

        /// <summary>
        /// The identifier for the RegisterServer2Request_Encoding_DefaultJson Object.
        /// </summary>
        public const uint RegisterServer2Request_Encoding_DefaultJson = 15107;

        /// <summary>
        /// The identifier for the RegisterServer2Response_Encoding_DefaultJson Object.
        /// </summary>
        public const uint RegisterServer2Response_Encoding_DefaultJson = 15130;

        /// <summary>
        /// The identifier for the ChannelSecurityToken_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ChannelSecurityToken_Encoding_DefaultJson = 15131;

        /// <summary>
        /// The identifier for the OpenSecureChannelRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint OpenSecureChannelRequest_Encoding_DefaultJson = 15132;

        /// <summary>
        /// The identifier for the OpenSecureChannelResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint OpenSecureChannelResponse_Encoding_DefaultJson = 15133;

        /// <summary>
        /// The identifier for the CloseSecureChannelRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint CloseSecureChannelRequest_Encoding_DefaultJson = 15134;

        /// <summary>
        /// The identifier for the CloseSecureChannelResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint CloseSecureChannelResponse_Encoding_DefaultJson = 15135;

        /// <summary>
        /// The identifier for the SignedSoftwareCertificate_Encoding_DefaultJson Object.
        /// </summary>
        public const uint SignedSoftwareCertificate_Encoding_DefaultJson = 15136;

        /// <summary>
        /// The identifier for the SignatureData_Encoding_DefaultJson Object.
        /// </summary>
        public const uint SignatureData_Encoding_DefaultJson = 15137;

        /// <summary>
        /// The identifier for the CreateSessionRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint CreateSessionRequest_Encoding_DefaultJson = 15138;

        /// <summary>
        /// The identifier for the CreateSessionResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint CreateSessionResponse_Encoding_DefaultJson = 15139;

        /// <summary>
        /// The identifier for the UserIdentityToken_Encoding_DefaultJson Object.
        /// </summary>
        public const uint UserIdentityToken_Encoding_DefaultJson = 15140;

        /// <summary>
        /// The identifier for the AnonymousIdentityToken_Encoding_DefaultJson Object.
        /// </summary>
        public const uint AnonymousIdentityToken_Encoding_DefaultJson = 15141;

        /// <summary>
        /// The identifier for the UserNameIdentityToken_Encoding_DefaultJson Object.
        /// </summary>
        public const uint UserNameIdentityToken_Encoding_DefaultJson = 15142;

        /// <summary>
        /// The identifier for the X509IdentityToken_Encoding_DefaultJson Object.
        /// </summary>
        public const uint X509IdentityToken_Encoding_DefaultJson = 15143;

        /// <summary>
        /// The identifier for the IssuedIdentityToken_Encoding_DefaultJson Object.
        /// </summary>
        public const uint IssuedIdentityToken_Encoding_DefaultJson = 15144;

        /// <summary>
        /// The identifier for the ActivateSessionRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ActivateSessionRequest_Encoding_DefaultJson = 15145;

        /// <summary>
        /// The identifier for the ActivateSessionResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ActivateSessionResponse_Encoding_DefaultJson = 15146;

        /// <summary>
        /// The identifier for the CloseSessionRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint CloseSessionRequest_Encoding_DefaultJson = 15147;

        /// <summary>
        /// The identifier for the CloseSessionResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint CloseSessionResponse_Encoding_DefaultJson = 15148;

        /// <summary>
        /// The identifier for the CancelRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint CancelRequest_Encoding_DefaultJson = 15149;

        /// <summary>
        /// The identifier for the CancelResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint CancelResponse_Encoding_DefaultJson = 15150;

        /// <summary>
        /// The identifier for the NodeAttributes_Encoding_DefaultJson Object.
        /// </summary>
        public const uint NodeAttributes_Encoding_DefaultJson = 15151;

        /// <summary>
        /// The identifier for the ObjectAttributes_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ObjectAttributes_Encoding_DefaultJson = 15152;

        /// <summary>
        /// The identifier for the VariableAttributes_Encoding_DefaultJson Object.
        /// </summary>
        public const uint VariableAttributes_Encoding_DefaultJson = 15153;

        /// <summary>
        /// The identifier for the MethodAttributes_Encoding_DefaultJson Object.
        /// </summary>
        public const uint MethodAttributes_Encoding_DefaultJson = 15157;

        /// <summary>
        /// The identifier for the ObjectTypeAttributes_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ObjectTypeAttributes_Encoding_DefaultJson = 15158;

        /// <summary>
        /// The identifier for the VariableTypeAttributes_Encoding_DefaultJson Object.
        /// </summary>
        public const uint VariableTypeAttributes_Encoding_DefaultJson = 15159;

        /// <summary>
        /// The identifier for the ReferenceTypeAttributes_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ReferenceTypeAttributes_Encoding_DefaultJson = 15160;

        /// <summary>
        /// The identifier for the DataTypeAttributes_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DataTypeAttributes_Encoding_DefaultJson = 15161;

        /// <summary>
        /// The identifier for the ViewAttributes_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ViewAttributes_Encoding_DefaultJson = 15162;

        /// <summary>
        /// The identifier for the GenericAttributeValue_Encoding_DefaultJson Object.
        /// </summary>
        public const uint GenericAttributeValue_Encoding_DefaultJson = 15163;

        /// <summary>
        /// The identifier for the GenericAttributes_Encoding_DefaultJson Object.
        /// </summary>
        public const uint GenericAttributes_Encoding_DefaultJson = 15164;

        /// <summary>
        /// The identifier for the AddNodesItem_Encoding_DefaultJson Object.
        /// </summary>
        public const uint AddNodesItem_Encoding_DefaultJson = 15165;

        /// <summary>
        /// The identifier for the AddNodesResult_Encoding_DefaultJson Object.
        /// </summary>
        public const uint AddNodesResult_Encoding_DefaultJson = 15166;

        /// <summary>
        /// The identifier for the AddNodesRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint AddNodesRequest_Encoding_DefaultJson = 15167;

        /// <summary>
        /// The identifier for the AddNodesResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint AddNodesResponse_Encoding_DefaultJson = 15168;

        /// <summary>
        /// The identifier for the AddReferencesItem_Encoding_DefaultJson Object.
        /// </summary>
        public const uint AddReferencesItem_Encoding_DefaultJson = 15169;

        /// <summary>
        /// The identifier for the AddReferencesRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint AddReferencesRequest_Encoding_DefaultJson = 15170;

        /// <summary>
        /// The identifier for the AddReferencesResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint AddReferencesResponse_Encoding_DefaultJson = 15171;

        /// <summary>
        /// The identifier for the DeleteNodesItem_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DeleteNodesItem_Encoding_DefaultJson = 15172;

        /// <summary>
        /// The identifier for the DeleteNodesRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DeleteNodesRequest_Encoding_DefaultJson = 15173;

        /// <summary>
        /// The identifier for the DeleteNodesResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DeleteNodesResponse_Encoding_DefaultJson = 15174;

        /// <summary>
        /// The identifier for the DeleteReferencesItem_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DeleteReferencesItem_Encoding_DefaultJson = 15175;

        /// <summary>
        /// The identifier for the DeleteReferencesRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DeleteReferencesRequest_Encoding_DefaultJson = 15176;

        /// <summary>
        /// The identifier for the DeleteReferencesResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DeleteReferencesResponse_Encoding_DefaultJson = 15177;

        /// <summary>
        /// The identifier for the ViewDescription_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ViewDescription_Encoding_DefaultJson = 15179;

        /// <summary>
        /// The identifier for the BrowseDescription_Encoding_DefaultJson Object.
        /// </summary>
        public const uint BrowseDescription_Encoding_DefaultJson = 15180;

        /// <summary>
        /// The identifier for the ReferenceDescription_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ReferenceDescription_Encoding_DefaultJson = 15182;

        /// <summary>
        /// The identifier for the BrowseResult_Encoding_DefaultJson Object.
        /// </summary>
        public const uint BrowseResult_Encoding_DefaultJson = 15183;

        /// <summary>
        /// The identifier for the BrowseRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint BrowseRequest_Encoding_DefaultJson = 15184;

        /// <summary>
        /// The identifier for the BrowseResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint BrowseResponse_Encoding_DefaultJson = 15185;

        /// <summary>
        /// The identifier for the BrowseNextRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint BrowseNextRequest_Encoding_DefaultJson = 15186;

        /// <summary>
        /// The identifier for the BrowseNextResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint BrowseNextResponse_Encoding_DefaultJson = 15187;

        /// <summary>
        /// The identifier for the RelativePathElement_Encoding_DefaultJson Object.
        /// </summary>
        public const uint RelativePathElement_Encoding_DefaultJson = 15188;

        /// <summary>
        /// The identifier for the RelativePath_Encoding_DefaultJson Object.
        /// </summary>
        public const uint RelativePath_Encoding_DefaultJson = 15189;

        /// <summary>
        /// The identifier for the BrowsePath_Encoding_DefaultJson Object.
        /// </summary>
        public const uint BrowsePath_Encoding_DefaultJson = 15190;

        /// <summary>
        /// The identifier for the BrowsePathTarget_Encoding_DefaultJson Object.
        /// </summary>
        public const uint BrowsePathTarget_Encoding_DefaultJson = 15191;

        /// <summary>
        /// The identifier for the BrowsePathResult_Encoding_DefaultJson Object.
        /// </summary>
        public const uint BrowsePathResult_Encoding_DefaultJson = 15192;

        /// <summary>
        /// The identifier for the TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultJson = 15193;

        /// <summary>
        /// The identifier for the TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultJson = 15194;

        /// <summary>
        /// The identifier for the RegisterNodesRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint RegisterNodesRequest_Encoding_DefaultJson = 15195;

        /// <summary>
        /// The identifier for the RegisterNodesResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint RegisterNodesResponse_Encoding_DefaultJson = 15196;

        /// <summary>
        /// The identifier for the UnregisterNodesRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint UnregisterNodesRequest_Encoding_DefaultJson = 15197;

        /// <summary>
        /// The identifier for the UnregisterNodesResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint UnregisterNodesResponse_Encoding_DefaultJson = 15198;

        /// <summary>
        /// The identifier for the EndpointConfiguration_Encoding_DefaultJson Object.
        /// </summary>
        public const uint EndpointConfiguration_Encoding_DefaultJson = 15199;

        /// <summary>
        /// The identifier for the QueryDataDescription_Encoding_DefaultJson Object.
        /// </summary>
        public const uint QueryDataDescription_Encoding_DefaultJson = 15200;

        /// <summary>
        /// The identifier for the NodeTypeDescription_Encoding_DefaultJson Object.
        /// </summary>
        public const uint NodeTypeDescription_Encoding_DefaultJson = 15201;

        /// <summary>
        /// The identifier for the QueryDataSet_Encoding_DefaultJson Object.
        /// </summary>
        public const uint QueryDataSet_Encoding_DefaultJson = 15202;

        /// <summary>
        /// The identifier for the NodeReference_Encoding_DefaultJson Object.
        /// </summary>
        public const uint NodeReference_Encoding_DefaultJson = 15203;

        /// <summary>
        /// The identifier for the ContentFilterElement_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ContentFilterElement_Encoding_DefaultJson = 15204;

        /// <summary>
        /// The identifier for the ContentFilter_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ContentFilter_Encoding_DefaultJson = 15205;

        /// <summary>
        /// The identifier for the FilterOperand_Encoding_DefaultJson Object.
        /// </summary>
        public const uint FilterOperand_Encoding_DefaultJson = 15206;

        /// <summary>
        /// The identifier for the ElementOperand_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ElementOperand_Encoding_DefaultJson = 15207;

        /// <summary>
        /// The identifier for the LiteralOperand_Encoding_DefaultJson Object.
        /// </summary>
        public const uint LiteralOperand_Encoding_DefaultJson = 15208;

        /// <summary>
        /// The identifier for the AttributeOperand_Encoding_DefaultJson Object.
        /// </summary>
        public const uint AttributeOperand_Encoding_DefaultJson = 15209;

        /// <summary>
        /// The identifier for the SimpleAttributeOperand_Encoding_DefaultJson Object.
        /// </summary>
        public const uint SimpleAttributeOperand_Encoding_DefaultJson = 15210;

        /// <summary>
        /// The identifier for the ContentFilterElementResult_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ContentFilterElementResult_Encoding_DefaultJson = 15211;

        /// <summary>
        /// The identifier for the ContentFilterResult_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ContentFilterResult_Encoding_DefaultJson = 15228;

        /// <summary>
        /// The identifier for the ParsingResult_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ParsingResult_Encoding_DefaultJson = 15236;

        /// <summary>
        /// The identifier for the QueryFirstRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint QueryFirstRequest_Encoding_DefaultJson = 15244;

        /// <summary>
        /// The identifier for the QueryFirstResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint QueryFirstResponse_Encoding_DefaultJson = 15252;

        /// <summary>
        /// The identifier for the QueryNextRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint QueryNextRequest_Encoding_DefaultJson = 15254;

        /// <summary>
        /// The identifier for the QueryNextResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint QueryNextResponse_Encoding_DefaultJson = 15255;

        /// <summary>
        /// The identifier for the ReadValueId_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ReadValueId_Encoding_DefaultJson = 15256;

        /// <summary>
        /// The identifier for the ReadRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ReadRequest_Encoding_DefaultJson = 15257;

        /// <summary>
        /// The identifier for the ReadResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ReadResponse_Encoding_DefaultJson = 15258;

        /// <summary>
        /// The identifier for the HistoryReadValueId_Encoding_DefaultJson Object.
        /// </summary>
        public const uint HistoryReadValueId_Encoding_DefaultJson = 15259;

        /// <summary>
        /// The identifier for the HistoryReadResult_Encoding_DefaultJson Object.
        /// </summary>
        public const uint HistoryReadResult_Encoding_DefaultJson = 15260;

        /// <summary>
        /// The identifier for the HistoryReadDetails_Encoding_DefaultJson Object.
        /// </summary>
        public const uint HistoryReadDetails_Encoding_DefaultJson = 15261;

        /// <summary>
        /// The identifier for the ReadEventDetails_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ReadEventDetails_Encoding_DefaultJson = 15262;

        /// <summary>
        /// The identifier for the ReadRawModifiedDetails_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ReadRawModifiedDetails_Encoding_DefaultJson = 15263;

        /// <summary>
        /// The identifier for the ReadProcessedDetails_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ReadProcessedDetails_Encoding_DefaultJson = 15264;

        /// <summary>
        /// The identifier for the ReadAtTimeDetails_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ReadAtTimeDetails_Encoding_DefaultJson = 15269;

        /// <summary>
        /// The identifier for the ReadAnnotationDataDetails_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ReadAnnotationDataDetails_Encoding_DefaultJson = 23512;

        /// <summary>
        /// The identifier for the HistoryData_Encoding_DefaultJson Object.
        /// </summary>
        public const uint HistoryData_Encoding_DefaultJson = 15270;

        /// <summary>
        /// The identifier for the ModificationInfo_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ModificationInfo_Encoding_DefaultJson = 15271;

        /// <summary>
        /// The identifier for the HistoryModifiedData_Encoding_DefaultJson Object.
        /// </summary>
        public const uint HistoryModifiedData_Encoding_DefaultJson = 15272;

        /// <summary>
        /// The identifier for the HistoryEvent_Encoding_DefaultJson Object.
        /// </summary>
        public const uint HistoryEvent_Encoding_DefaultJson = 15273;

        /// <summary>
        /// The identifier for the HistoryReadRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint HistoryReadRequest_Encoding_DefaultJson = 15274;

        /// <summary>
        /// The identifier for the HistoryReadResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint HistoryReadResponse_Encoding_DefaultJson = 15275;

        /// <summary>
        /// The identifier for the WriteValue_Encoding_DefaultJson Object.
        /// </summary>
        public const uint WriteValue_Encoding_DefaultJson = 15276;

        /// <summary>
        /// The identifier for the WriteRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint WriteRequest_Encoding_DefaultJson = 15277;

        /// <summary>
        /// The identifier for the WriteResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint WriteResponse_Encoding_DefaultJson = 15278;

        /// <summary>
        /// The identifier for the HistoryUpdateDetails_Encoding_DefaultJson Object.
        /// </summary>
        public const uint HistoryUpdateDetails_Encoding_DefaultJson = 15279;

        /// <summary>
        /// The identifier for the UpdateDataDetails_Encoding_DefaultJson Object.
        /// </summary>
        public const uint UpdateDataDetails_Encoding_DefaultJson = 15280;

        /// <summary>
        /// The identifier for the UpdateStructureDataDetails_Encoding_DefaultJson Object.
        /// </summary>
        public const uint UpdateStructureDataDetails_Encoding_DefaultJson = 15281;

        /// <summary>
        /// The identifier for the UpdateEventDetails_Encoding_DefaultJson Object.
        /// </summary>
        public const uint UpdateEventDetails_Encoding_DefaultJson = 15282;

        /// <summary>
        /// The identifier for the DeleteRawModifiedDetails_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DeleteRawModifiedDetails_Encoding_DefaultJson = 15283;

        /// <summary>
        /// The identifier for the DeleteAtTimeDetails_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DeleteAtTimeDetails_Encoding_DefaultJson = 15284;

        /// <summary>
        /// The identifier for the DeleteEventDetails_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DeleteEventDetails_Encoding_DefaultJson = 15285;

        /// <summary>
        /// The identifier for the HistoryUpdateResult_Encoding_DefaultJson Object.
        /// </summary>
        public const uint HistoryUpdateResult_Encoding_DefaultJson = 15286;

        /// <summary>
        /// The identifier for the HistoryUpdateRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint HistoryUpdateRequest_Encoding_DefaultJson = 15287;

        /// <summary>
        /// The identifier for the HistoryUpdateResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint HistoryUpdateResponse_Encoding_DefaultJson = 15288;

        /// <summary>
        /// The identifier for the CallMethodRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint CallMethodRequest_Encoding_DefaultJson = 15289;

        /// <summary>
        /// The identifier for the CallMethodResult_Encoding_DefaultJson Object.
        /// </summary>
        public const uint CallMethodResult_Encoding_DefaultJson = 15290;

        /// <summary>
        /// The identifier for the CallRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint CallRequest_Encoding_DefaultJson = 15291;

        /// <summary>
        /// The identifier for the CallResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint CallResponse_Encoding_DefaultJson = 15292;

        /// <summary>
        /// The identifier for the MonitoringFilter_Encoding_DefaultJson Object.
        /// </summary>
        public const uint MonitoringFilter_Encoding_DefaultJson = 15293;

        /// <summary>
        /// The identifier for the DataChangeFilter_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DataChangeFilter_Encoding_DefaultJson = 15294;

        /// <summary>
        /// The identifier for the EventFilter_Encoding_DefaultJson Object.
        /// </summary>
        public const uint EventFilter_Encoding_DefaultJson = 15295;

        /// <summary>
        /// The identifier for the AggregateConfiguration_Encoding_DefaultJson Object.
        /// </summary>
        public const uint AggregateConfiguration_Encoding_DefaultJson = 15304;

        /// <summary>
        /// The identifier for the AggregateFilter_Encoding_DefaultJson Object.
        /// </summary>
        public const uint AggregateFilter_Encoding_DefaultJson = 15312;

        /// <summary>
        /// The identifier for the MonitoringFilterResult_Encoding_DefaultJson Object.
        /// </summary>
        public const uint MonitoringFilterResult_Encoding_DefaultJson = 15313;

        /// <summary>
        /// The identifier for the EventFilterResult_Encoding_DefaultJson Object.
        /// </summary>
        public const uint EventFilterResult_Encoding_DefaultJson = 15314;

        /// <summary>
        /// The identifier for the AggregateFilterResult_Encoding_DefaultJson Object.
        /// </summary>
        public const uint AggregateFilterResult_Encoding_DefaultJson = 15315;

        /// <summary>
        /// The identifier for the MonitoringParameters_Encoding_DefaultJson Object.
        /// </summary>
        public const uint MonitoringParameters_Encoding_DefaultJson = 15320;

        /// <summary>
        /// The identifier for the MonitoredItemCreateRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint MonitoredItemCreateRequest_Encoding_DefaultJson = 15321;

        /// <summary>
        /// The identifier for the MonitoredItemCreateResult_Encoding_DefaultJson Object.
        /// </summary>
        public const uint MonitoredItemCreateResult_Encoding_DefaultJson = 15322;

        /// <summary>
        /// The identifier for the CreateMonitoredItemsRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint CreateMonitoredItemsRequest_Encoding_DefaultJson = 15323;

        /// <summary>
        /// The identifier for the CreateMonitoredItemsResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint CreateMonitoredItemsResponse_Encoding_DefaultJson = 15324;

        /// <summary>
        /// The identifier for the MonitoredItemModifyRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint MonitoredItemModifyRequest_Encoding_DefaultJson = 15325;

        /// <summary>
        /// The identifier for the MonitoredItemModifyResult_Encoding_DefaultJson Object.
        /// </summary>
        public const uint MonitoredItemModifyResult_Encoding_DefaultJson = 15326;

        /// <summary>
        /// The identifier for the ModifyMonitoredItemsRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ModifyMonitoredItemsRequest_Encoding_DefaultJson = 15327;

        /// <summary>
        /// The identifier for the ModifyMonitoredItemsResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ModifyMonitoredItemsResponse_Encoding_DefaultJson = 15328;

        /// <summary>
        /// The identifier for the SetMonitoringModeRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint SetMonitoringModeRequest_Encoding_DefaultJson = 15329;

        /// <summary>
        /// The identifier for the SetMonitoringModeResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint SetMonitoringModeResponse_Encoding_DefaultJson = 15331;

        /// <summary>
        /// The identifier for the SetTriggeringRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint SetTriggeringRequest_Encoding_DefaultJson = 15332;

        /// <summary>
        /// The identifier for the SetTriggeringResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint SetTriggeringResponse_Encoding_DefaultJson = 15333;

        /// <summary>
        /// The identifier for the DeleteMonitoredItemsRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DeleteMonitoredItemsRequest_Encoding_DefaultJson = 15335;

        /// <summary>
        /// The identifier for the DeleteMonitoredItemsResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DeleteMonitoredItemsResponse_Encoding_DefaultJson = 15336;

        /// <summary>
        /// The identifier for the CreateSubscriptionRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint CreateSubscriptionRequest_Encoding_DefaultJson = 15337;

        /// <summary>
        /// The identifier for the CreateSubscriptionResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint CreateSubscriptionResponse_Encoding_DefaultJson = 15338;

        /// <summary>
        /// The identifier for the ModifySubscriptionRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ModifySubscriptionRequest_Encoding_DefaultJson = 15339;

        /// <summary>
        /// The identifier for the ModifySubscriptionResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ModifySubscriptionResponse_Encoding_DefaultJson = 15340;

        /// <summary>
        /// The identifier for the SetPublishingModeRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint SetPublishingModeRequest_Encoding_DefaultJson = 15341;

        /// <summary>
        /// The identifier for the SetPublishingModeResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint SetPublishingModeResponse_Encoding_DefaultJson = 15342;

        /// <summary>
        /// The identifier for the NotificationMessage_Encoding_DefaultJson Object.
        /// </summary>
        public const uint NotificationMessage_Encoding_DefaultJson = 15343;

        /// <summary>
        /// The identifier for the NotificationData_Encoding_DefaultJson Object.
        /// </summary>
        public const uint NotificationData_Encoding_DefaultJson = 15344;

        /// <summary>
        /// The identifier for the DataChangeNotification_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DataChangeNotification_Encoding_DefaultJson = 15345;

        /// <summary>
        /// The identifier for the MonitoredItemNotification_Encoding_DefaultJson Object.
        /// </summary>
        public const uint MonitoredItemNotification_Encoding_DefaultJson = 15346;

        /// <summary>
        /// The identifier for the EventNotificationList_Encoding_DefaultJson Object.
        /// </summary>
        public const uint EventNotificationList_Encoding_DefaultJson = 15347;

        /// <summary>
        /// The identifier for the EventFieldList_Encoding_DefaultJson Object.
        /// </summary>
        public const uint EventFieldList_Encoding_DefaultJson = 15348;

        /// <summary>
        /// The identifier for the HistoryEventFieldList_Encoding_DefaultJson Object.
        /// </summary>
        public const uint HistoryEventFieldList_Encoding_DefaultJson = 15349;

        /// <summary>
        /// The identifier for the StatusChangeNotification_Encoding_DefaultJson Object.
        /// </summary>
        public const uint StatusChangeNotification_Encoding_DefaultJson = 15350;

        /// <summary>
        /// The identifier for the SubscriptionAcknowledgement_Encoding_DefaultJson Object.
        /// </summary>
        public const uint SubscriptionAcknowledgement_Encoding_DefaultJson = 15351;

        /// <summary>
        /// The identifier for the PublishRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint PublishRequest_Encoding_DefaultJson = 15352;

        /// <summary>
        /// The identifier for the PublishResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint PublishResponse_Encoding_DefaultJson = 15353;

        /// <summary>
        /// The identifier for the RepublishRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint RepublishRequest_Encoding_DefaultJson = 15354;

        /// <summary>
        /// The identifier for the RepublishResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint RepublishResponse_Encoding_DefaultJson = 15355;

        /// <summary>
        /// The identifier for the TransferResult_Encoding_DefaultJson Object.
        /// </summary>
        public const uint TransferResult_Encoding_DefaultJson = 15356;

        /// <summary>
        /// The identifier for the TransferSubscriptionsRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint TransferSubscriptionsRequest_Encoding_DefaultJson = 15357;

        /// <summary>
        /// The identifier for the TransferSubscriptionsResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint TransferSubscriptionsResponse_Encoding_DefaultJson = 15358;

        /// <summary>
        /// The identifier for the DeleteSubscriptionsRequest_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DeleteSubscriptionsRequest_Encoding_DefaultJson = 15359;

        /// <summary>
        /// The identifier for the DeleteSubscriptionsResponse_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DeleteSubscriptionsResponse_Encoding_DefaultJson = 15360;

        /// <summary>
        /// The identifier for the BuildInfo_Encoding_DefaultJson Object.
        /// </summary>
        public const uint BuildInfo_Encoding_DefaultJson = 15361;

        /// <summary>
        /// The identifier for the RedundantServerDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint RedundantServerDataType_Encoding_DefaultJson = 15362;

        /// <summary>
        /// The identifier for the EndpointUrlListDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint EndpointUrlListDataType_Encoding_DefaultJson = 15363;

        /// <summary>
        /// The identifier for the NetworkGroupDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint NetworkGroupDataType_Encoding_DefaultJson = 15364;

        /// <summary>
        /// The identifier for the SamplingIntervalDiagnosticsDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint SamplingIntervalDiagnosticsDataType_Encoding_DefaultJson = 15365;

        /// <summary>
        /// The identifier for the ServerDiagnosticsSummaryDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ServerDiagnosticsSummaryDataType_Encoding_DefaultJson = 15366;

        /// <summary>
        /// The identifier for the ServerStatusDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ServerStatusDataType_Encoding_DefaultJson = 15367;

        /// <summary>
        /// The identifier for the SessionDiagnosticsDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint SessionDiagnosticsDataType_Encoding_DefaultJson = 15368;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint SessionSecurityDiagnosticsDataType_Encoding_DefaultJson = 15369;

        /// <summary>
        /// The identifier for the ServiceCounterDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ServiceCounterDataType_Encoding_DefaultJson = 15370;

        /// <summary>
        /// The identifier for the StatusResult_Encoding_DefaultJson Object.
        /// </summary>
        public const uint StatusResult_Encoding_DefaultJson = 15371;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint SubscriptionDiagnosticsDataType_Encoding_DefaultJson = 15372;

        /// <summary>
        /// The identifier for the ModelChangeStructureDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ModelChangeStructureDataType_Encoding_DefaultJson = 15373;

        /// <summary>
        /// The identifier for the SemanticChangeStructureDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint SemanticChangeStructureDataType_Encoding_DefaultJson = 15374;

        /// <summary>
        /// The identifier for the Range_Encoding_DefaultJson Object.
        /// </summary>
        public const uint Range_Encoding_DefaultJson = 15375;

        /// <summary>
        /// The identifier for the EUInformation_Encoding_DefaultJson Object.
        /// </summary>
        public const uint EUInformation_Encoding_DefaultJson = 15376;

        /// <summary>
        /// The identifier for the ComplexNumberType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ComplexNumberType_Encoding_DefaultJson = 15377;

        /// <summary>
        /// The identifier for the DoubleComplexNumberType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint DoubleComplexNumberType_Encoding_DefaultJson = 15378;

        /// <summary>
        /// The identifier for the AxisInformation_Encoding_DefaultJson Object.
        /// </summary>
        public const uint AxisInformation_Encoding_DefaultJson = 15379;

        /// <summary>
        /// The identifier for the XVType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint XVType_Encoding_DefaultJson = 15380;

        /// <summary>
        /// The identifier for the ProgramDiagnosticDataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ProgramDiagnosticDataType_Encoding_DefaultJson = 15381;

        /// <summary>
        /// The identifier for the ProgramDiagnostic2DataType_Encoding_DefaultJson Object.
        /// </summary>
        public const uint ProgramDiagnostic2DataType_Encoding_DefaultJson = 24042;

        /// <summary>
        /// The identifier for the Annotation_Encoding_DefaultJson Object.
        /// </summary>
        public const uint Annotation_Encoding_DefaultJson = 15382;
    }
    #endregion

    #region ObjectType Identifiers
    /// <summary>
    /// A class that declares constants for all ObjectTypes in the Model Design.
    /// </summary>
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class ObjectTypes
    {
        /// <summary>
        /// The identifier for the BaseObjectType ObjectType.
        /// </summary>
        public const uint BaseObjectType = 58;

        /// <summary>
        /// The identifier for the FolderType ObjectType.
        /// </summary>
        public const uint FolderType = 61;

        /// <summary>
        /// The identifier for the DataTypeSystemType ObjectType.
        /// </summary>
        public const uint DataTypeSystemType = 75;

        /// <summary>
        /// The identifier for the DataTypeEncodingType ObjectType.
        /// </summary>
        public const uint DataTypeEncodingType = 76;

        /// <summary>
        /// The identifier for the ModellingRuleType ObjectType.
        /// </summary>
        public const uint ModellingRuleType = 77;

        /// <summary>
        /// The identifier for the ServerType ObjectType.
        /// </summary>
        public const uint ServerType = 2004;

        /// <summary>
        /// The identifier for the ServerCapabilitiesType ObjectType.
        /// </summary>
        public const uint ServerCapabilitiesType = 2013;

        /// <summary>
        /// The identifier for the ServerDiagnosticsType ObjectType.
        /// </summary>
        public const uint ServerDiagnosticsType = 2020;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType ObjectType.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType = 2026;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType ObjectType.
        /// </summary>
        public const uint SessionDiagnosticsObjectType = 2029;

        /// <summary>
        /// The identifier for the VendorServerInfoType ObjectType.
        /// </summary>
        public const uint VendorServerInfoType = 2033;

        /// <summary>
        /// The identifier for the ServerRedundancyType ObjectType.
        /// </summary>
        public const uint ServerRedundancyType = 2034;

        /// <summary>
        /// The identifier for the TransparentRedundancyType ObjectType.
        /// </summary>
        public const uint TransparentRedundancyType = 2036;

        /// <summary>
        /// The identifier for the NonTransparentRedundancyType ObjectType.
        /// </summary>
        public const uint NonTransparentRedundancyType = 2039;

        /// <summary>
        /// The identifier for the NonTransparentNetworkRedundancyType ObjectType.
        /// </summary>
        public const uint NonTransparentNetworkRedundancyType = 11945;

        /// <summary>
        /// The identifier for the OperationLimitsType ObjectType.
        /// </summary>
        public const uint OperationLimitsType = 11564;

        /// <summary>
        /// The identifier for the FileType ObjectType.
        /// </summary>
        public const uint FileType = 11575;

        /// <summary>
        /// The identifier for the AddressSpaceFileType ObjectType.
        /// </summary>
        public const uint AddressSpaceFileType = 11595;

        /// <summary>
        /// The identifier for the NamespaceMetadataType ObjectType.
        /// </summary>
        public const uint NamespaceMetadataType = 11616;

        /// <summary>
        /// The identifier for the NamespacesType ObjectType.
        /// </summary>
        public const uint NamespacesType = 11645;

        /// <summary>
        /// The identifier for the BaseEventType ObjectType.
        /// </summary>
        public const uint BaseEventType = 2041;

        /// <summary>
        /// The identifier for the AuditEventType ObjectType.
        /// </summary>
        public const uint AuditEventType = 2052;

        /// <summary>
        /// The identifier for the AuditSecurityEventType ObjectType.
        /// </summary>
        public const uint AuditSecurityEventType = 2058;

        /// <summary>
        /// The identifier for the AuditChannelEventType ObjectType.
        /// </summary>
        public const uint AuditChannelEventType = 2059;

        /// <summary>
        /// The identifier for the AuditOpenSecureChannelEventType ObjectType.
        /// </summary>
        public const uint AuditOpenSecureChannelEventType = 2060;

        /// <summary>
        /// The identifier for the AuditSessionEventType ObjectType.
        /// </summary>
        public const uint AuditSessionEventType = 2069;

        /// <summary>
        /// The identifier for the AuditCreateSessionEventType ObjectType.
        /// </summary>
        public const uint AuditCreateSessionEventType = 2071;

        /// <summary>
        /// The identifier for the AuditUrlMismatchEventType ObjectType.
        /// </summary>
        public const uint AuditUrlMismatchEventType = 2748;

        /// <summary>
        /// The identifier for the AuditActivateSessionEventType ObjectType.
        /// </summary>
        public const uint AuditActivateSessionEventType = 2075;

        /// <summary>
        /// The identifier for the AuditCancelEventType ObjectType.
        /// </summary>
        public const uint AuditCancelEventType = 2078;

        /// <summary>
        /// The identifier for the AuditCertificateEventType ObjectType.
        /// </summary>
        public const uint AuditCertificateEventType = 2080;

        /// <summary>
        /// The identifier for the AuditCertificateDataMismatchEventType ObjectType.
        /// </summary>
        public const uint AuditCertificateDataMismatchEventType = 2082;

        /// <summary>
        /// The identifier for the AuditCertificateExpiredEventType ObjectType.
        /// </summary>
        public const uint AuditCertificateExpiredEventType = 2085;

        /// <summary>
        /// The identifier for the AuditCertificateInvalidEventType ObjectType.
        /// </summary>
        public const uint AuditCertificateInvalidEventType = 2086;

        /// <summary>
        /// The identifier for the AuditCertificateUntrustedEventType ObjectType.
        /// </summary>
        public const uint AuditCertificateUntrustedEventType = 2087;

        /// <summary>
        /// The identifier for the AuditCertificateRevokedEventType ObjectType.
        /// </summary>
        public const uint AuditCertificateRevokedEventType = 2088;

        /// <summary>
        /// The identifier for the AuditCertificateMismatchEventType ObjectType.
        /// </summary>
        public const uint AuditCertificateMismatchEventType = 2089;

        /// <summary>
        /// The identifier for the AuditNodeManagementEventType ObjectType.
        /// </summary>
        public const uint AuditNodeManagementEventType = 2090;

        /// <summary>
        /// The identifier for the AuditAddNodesEventType ObjectType.
        /// </summary>
        public const uint AuditAddNodesEventType = 2091;

        /// <summary>
        /// The identifier for the AuditDeleteNodesEventType ObjectType.
        /// </summary>
        public const uint AuditDeleteNodesEventType = 2093;

        /// <summary>
        /// The identifier for the AuditAddReferencesEventType ObjectType.
        /// </summary>
        public const uint AuditAddReferencesEventType = 2095;

        /// <summary>
        /// The identifier for the AuditDeleteReferencesEventType ObjectType.
        /// </summary>
        public const uint AuditDeleteReferencesEventType = 2097;

        /// <summary>
        /// The identifier for the AuditUpdateEventType ObjectType.
        /// </summary>
        public const uint AuditUpdateEventType = 2099;

        /// <summary>
        /// The identifier for the AuditWriteUpdateEventType ObjectType.
        /// </summary>
        public const uint AuditWriteUpdateEventType = 2100;

        /// <summary>
        /// The identifier for the AuditHistoryUpdateEventType ObjectType.
        /// </summary>
        public const uint AuditHistoryUpdateEventType = 2104;

        /// <summary>
        /// The identifier for the AuditUpdateMethodEventType ObjectType.
        /// </summary>
        public const uint AuditUpdateMethodEventType = 2127;

        /// <summary>
        /// The identifier for the SystemEventType ObjectType.
        /// </summary>
        public const uint SystemEventType = 2130;

        /// <summary>
        /// The identifier for the DeviceFailureEventType ObjectType.
        /// </summary>
        public const uint DeviceFailureEventType = 2131;

        /// <summary>
        /// The identifier for the SystemStatusChangeEventType ObjectType.
        /// </summary>
        public const uint SystemStatusChangeEventType = 11446;

        /// <summary>
        /// The identifier for the BaseModelChangeEventType ObjectType.
        /// </summary>
        public const uint BaseModelChangeEventType = 2132;

        /// <summary>
        /// The identifier for the GeneralModelChangeEventType ObjectType.
        /// </summary>
        public const uint GeneralModelChangeEventType = 2133;

        /// <summary>
        /// The identifier for the SemanticChangeEventType ObjectType.
        /// </summary>
        public const uint SemanticChangeEventType = 2738;

        /// <summary>
        /// The identifier for the EventQueueOverflowEventType ObjectType.
        /// </summary>
        public const uint EventQueueOverflowEventType = 3035;

        /// <summary>
        /// The identifier for the ProgressEventType ObjectType.
        /// </summary>
        public const uint ProgressEventType = 11436;

        /// <summary>
        /// The identifier for the AggregateFunctionType ObjectType.
        /// </summary>
        public const uint AggregateFunctionType = 2340;

        /// <summary>
        /// The identifier for the StateMachineType ObjectType.
        /// </summary>
        public const uint StateMachineType = 2299;

        /// <summary>
        /// The identifier for the FiniteStateMachineType ObjectType.
        /// </summary>
        public const uint FiniteStateMachineType = 2771;

        /// <summary>
        /// The identifier for the StateType ObjectType.
        /// </summary>
        public const uint StateType = 2307;

        /// <summary>
        /// The identifier for the InitialStateType ObjectType.
        /// </summary>
        public const uint InitialStateType = 2309;

        /// <summary>
        /// The identifier for the TransitionType ObjectType.
        /// </summary>
        public const uint TransitionType = 2310;

        /// <summary>
        /// The identifier for the ChoiceStateType ObjectType.
        /// </summary>
        public const uint ChoiceStateType = 15109;

        /// <summary>
        /// The identifier for the TransitionEventType ObjectType.
        /// </summary>
        public const uint TransitionEventType = 2311;

        /// <summary>
        /// The identifier for the AuditUpdateStateEventType ObjectType.
        /// </summary>
        public const uint AuditUpdateStateEventType = 2315;

        /// <summary>
        /// The identifier for the FileDirectoryType ObjectType.
        /// </summary>
        public const uint FileDirectoryType = 13353;

        /// <summary>
        /// The identifier for the TemporaryFileTransferType ObjectType.
        /// </summary>
        public const uint TemporaryFileTransferType = 15744;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType ObjectType.
        /// </summary>
        public const uint FileTransferStateMachineType = 15803;

        /// <summary>
        /// The identifier for the RoleSetType ObjectType.
        /// </summary>
        public const uint RoleSetType = 15607;

        /// <summary>
        /// The identifier for the RoleType ObjectType.
        /// </summary>
        public const uint RoleType = 15620;

        /// <summary>
        /// The identifier for the RoleMappingRuleChangedAuditEventType ObjectType.
        /// </summary>
        public const uint RoleMappingRuleChangedAuditEventType = 17641;

        /// <summary>
        /// The identifier for the DictionaryEntryType ObjectType.
        /// </summary>
        public const uint DictionaryEntryType = 17589;

        /// <summary>
        /// The identifier for the DictionaryFolderType ObjectType.
        /// </summary>
        public const uint DictionaryFolderType = 17591;

        /// <summary>
        /// The identifier for the IrdiDictionaryEntryType ObjectType.
        /// </summary>
        public const uint IrdiDictionaryEntryType = 17598;

        /// <summary>
        /// The identifier for the UriDictionaryEntryType ObjectType.
        /// </summary>
        public const uint UriDictionaryEntryType = 17600;

        /// <summary>
        /// The identifier for the BaseInterfaceType ObjectType.
        /// </summary>
        public const uint BaseInterfaceType = 17602;

        /// <summary>
        /// The identifier for the IOrderedObjectType ObjectType.
        /// </summary>
        public const uint IOrderedObjectType = 23513;

        /// <summary>
        /// The identifier for the OrderedListType ObjectType.
        /// </summary>
        public const uint OrderedListType = 23518;

        /// <summary>
        /// The identifier for the ConditionType ObjectType.
        /// </summary>
        public const uint ConditionType = 2782;

        /// <summary>
        /// The identifier for the DialogConditionType ObjectType.
        /// </summary>
        public const uint DialogConditionType = 2830;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType ObjectType.
        /// </summary>
        public const uint AcknowledgeableConditionType = 2881;

        /// <summary>
        /// The identifier for the AlarmConditionType ObjectType.
        /// </summary>
        public const uint AlarmConditionType = 2915;

        /// <summary>
        /// The identifier for the AlarmGroupType ObjectType.
        /// </summary>
        public const uint AlarmGroupType = 16405;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType ObjectType.
        /// </summary>
        public const uint ShelvedStateMachineType = 2929;

        /// <summary>
        /// The identifier for the LimitAlarmType ObjectType.
        /// </summary>
        public const uint LimitAlarmType = 2955;

        /// <summary>
        /// The identifier for the ExclusiveLimitStateMachineType ObjectType.
        /// </summary>
        public const uint ExclusiveLimitStateMachineType = 9318;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType ObjectType.
        /// </summary>
        public const uint ExclusiveLimitAlarmType = 9341;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType ObjectType.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType = 9906;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType ObjectType.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType = 10060;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType ObjectType.
        /// </summary>
        public const uint ExclusiveLevelAlarmType = 9482;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType ObjectType.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType = 10368;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType ObjectType.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType = 10214;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType ObjectType.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType = 9764;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType ObjectType.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType = 9623;

        /// <summary>
        /// The identifier for the DiscreteAlarmType ObjectType.
        /// </summary>
        public const uint DiscreteAlarmType = 10523;

        /// <summary>
        /// The identifier for the OffNormalAlarmType ObjectType.
        /// </summary>
        public const uint OffNormalAlarmType = 10637;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType ObjectType.
        /// </summary>
        public const uint SystemOffNormalAlarmType = 11753;

        /// <summary>
        /// The identifier for the TripAlarmType ObjectType.
        /// </summary>
        public const uint TripAlarmType = 10751;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType ObjectType.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType = 18347;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType ObjectType.
        /// </summary>
        public const uint SystemDiagnosticAlarmType = 18496;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType ObjectType.
        /// </summary>
        public const uint CertificateExpirationAlarmType = 13225;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType ObjectType.
        /// </summary>
        public const uint DiscrepancyAlarmType = 17080;

        /// <summary>
        /// The identifier for the BaseConditionClassType ObjectType.
        /// </summary>
        public const uint BaseConditionClassType = 11163;

        /// <summary>
        /// The identifier for the ProcessConditionClassType ObjectType.
        /// </summary>
        public const uint ProcessConditionClassType = 11164;

        /// <summary>
        /// The identifier for the MaintenanceConditionClassType ObjectType.
        /// </summary>
        public const uint MaintenanceConditionClassType = 11165;

        /// <summary>
        /// The identifier for the SystemConditionClassType ObjectType.
        /// </summary>
        public const uint SystemConditionClassType = 11166;

        /// <summary>
        /// The identifier for the SafetyConditionClassType ObjectType.
        /// </summary>
        public const uint SafetyConditionClassType = 17218;

        /// <summary>
        /// The identifier for the HighlyManagedAlarmConditionClassType ObjectType.
        /// </summary>
        public const uint HighlyManagedAlarmConditionClassType = 17219;

        /// <summary>
        /// The identifier for the TrainingConditionClassType ObjectType.
        /// </summary>
        public const uint TrainingConditionClassType = 17220;

        /// <summary>
        /// The identifier for the StatisticalConditionClassType ObjectType.
        /// </summary>
        public const uint StatisticalConditionClassType = 18665;

        /// <summary>
        /// The identifier for the TestingConditionSubClassType ObjectType.
        /// </summary>
        public const uint TestingConditionSubClassType = 17221;

        /// <summary>
        /// The identifier for the AuditConditionEventType ObjectType.
        /// </summary>
        public const uint AuditConditionEventType = 2790;

        /// <summary>
        /// The identifier for the AuditConditionEnableEventType ObjectType.
        /// </summary>
        public const uint AuditConditionEnableEventType = 2803;

        /// <summary>
        /// The identifier for the AuditConditionCommentEventType ObjectType.
        /// </summary>
        public const uint AuditConditionCommentEventType = 2829;

        /// <summary>
        /// The identifier for the AuditConditionRespondEventType ObjectType.
        /// </summary>
        public const uint AuditConditionRespondEventType = 8927;

        /// <summary>
        /// The identifier for the AuditConditionAcknowledgeEventType ObjectType.
        /// </summary>
        public const uint AuditConditionAcknowledgeEventType = 8944;

        /// <summary>
        /// The identifier for the AuditConditionConfirmEventType ObjectType.
        /// </summary>
        public const uint AuditConditionConfirmEventType = 8961;

        /// <summary>
        /// The identifier for the AuditConditionShelvingEventType ObjectType.
        /// </summary>
        public const uint AuditConditionShelvingEventType = 11093;

        /// <summary>
        /// The identifier for the AuditConditionSuppressionEventType ObjectType.
        /// </summary>
        public const uint AuditConditionSuppressionEventType = 17225;

        /// <summary>
        /// The identifier for the AuditConditionSilenceEventType ObjectType.
        /// </summary>
        public const uint AuditConditionSilenceEventType = 17242;

        /// <summary>
        /// The identifier for the AuditConditionResetEventType ObjectType.
        /// </summary>
        public const uint AuditConditionResetEventType = 15013;

        /// <summary>
        /// The identifier for the AuditConditionOutOfServiceEventType ObjectType.
        /// </summary>
        public const uint AuditConditionOutOfServiceEventType = 17259;

        /// <summary>
        /// The identifier for the RefreshStartEventType ObjectType.
        /// </summary>
        public const uint RefreshStartEventType = 2787;

        /// <summary>
        /// The identifier for the RefreshEndEventType ObjectType.
        /// </summary>
        public const uint RefreshEndEventType = 2788;

        /// <summary>
        /// The identifier for the RefreshRequiredEventType ObjectType.
        /// </summary>
        public const uint RefreshRequiredEventType = 2789;

        /// <summary>
        /// The identifier for the AlarmMetricsType ObjectType.
        /// </summary>
        public const uint AlarmMetricsType = 17279;

        /// <summary>
        /// The identifier for the ProgramStateMachineType ObjectType.
        /// </summary>
        public const uint ProgramStateMachineType = 2391;

        /// <summary>
        /// The identifier for the ProgramTransitionEventType ObjectType.
        /// </summary>
        public const uint ProgramTransitionEventType = 2378;

        /// <summary>
        /// The identifier for the AuditProgramTransitionEventType ObjectType.
        /// </summary>
        public const uint AuditProgramTransitionEventType = 11856;

        /// <summary>
        /// The identifier for the ProgramTransitionAuditEventType ObjectType.
        /// </summary>
        public const uint ProgramTransitionAuditEventType = 3806;

        /// <summary>
        /// The identifier for the HistoricalDataConfigurationType ObjectType.
        /// </summary>
        public const uint HistoricalDataConfigurationType = 2318;

        /// <summary>
        /// The identifier for the HistoryServerCapabilitiesType ObjectType.
        /// </summary>
        public const uint HistoryServerCapabilitiesType = 2330;

        /// <summary>
        /// The identifier for the AuditHistoryEventUpdateEventType ObjectType.
        /// </summary>
        public const uint AuditHistoryEventUpdateEventType = 2999;

        /// <summary>
        /// The identifier for the AuditHistoryValueUpdateEventType ObjectType.
        /// </summary>
        public const uint AuditHistoryValueUpdateEventType = 3006;

        /// <summary>
        /// The identifier for the AuditHistoryAnnotationUpdateEventType ObjectType.
        /// </summary>
        public const uint AuditHistoryAnnotationUpdateEventType = 19095;

        /// <summary>
        /// The identifier for the AuditHistoryDeleteEventType ObjectType.
        /// </summary>
        public const uint AuditHistoryDeleteEventType = 3012;

        /// <summary>
        /// The identifier for the AuditHistoryRawModifyDeleteEventType ObjectType.
        /// </summary>
        public const uint AuditHistoryRawModifyDeleteEventType = 3014;

        /// <summary>
        /// The identifier for the AuditHistoryAtTimeDeleteEventType ObjectType.
        /// </summary>
        public const uint AuditHistoryAtTimeDeleteEventType = 3019;

        /// <summary>
        /// The identifier for the AuditHistoryEventDeleteEventType ObjectType.
        /// </summary>
        public const uint AuditHistoryEventDeleteEventType = 3022;

        /// <summary>
        /// The identifier for the TrustListType ObjectType.
        /// </summary>
        public const uint TrustListType = 12522;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType ObjectType.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType = 19297;

        /// <summary>
        /// The identifier for the CertificateGroupType ObjectType.
        /// </summary>
        public const uint CertificateGroupType = 12555;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType ObjectType.
        /// </summary>
        public const uint CertificateGroupFolderType = 13813;

        /// <summary>
        /// The identifier for the CertificateType ObjectType.
        /// </summary>
        public const uint CertificateType = 12556;

        /// <summary>
        /// The identifier for the ApplicationCertificateType ObjectType.
        /// </summary>
        public const uint ApplicationCertificateType = 12557;

        /// <summary>
        /// The identifier for the HttpsCertificateType ObjectType.
        /// </summary>
        public const uint HttpsCertificateType = 12558;

        /// <summary>
        /// The identifier for the UserCredentialCertificateType ObjectType.
        /// </summary>
        public const uint UserCredentialCertificateType = 15181;

        /// <summary>
        /// The identifier for the RsaMinApplicationCertificateType ObjectType.
        /// </summary>
        public const uint RsaMinApplicationCertificateType = 12559;

        /// <summary>
        /// The identifier for the RsaSha256ApplicationCertificateType ObjectType.
        /// </summary>
        public const uint RsaSha256ApplicationCertificateType = 12560;

        /// <summary>
        /// The identifier for the EccApplicationCertificateType ObjectType.
        /// </summary>
        public const uint EccApplicationCertificateType = 23537;

        /// <summary>
        /// The identifier for the EccNistP256ApplicationCertificateType ObjectType.
        /// </summary>
        public const uint EccNistP256ApplicationCertificateType = 23538;

        /// <summary>
        /// The identifier for the EccNistP384ApplicationCertificateType ObjectType.
        /// </summary>
        public const uint EccNistP384ApplicationCertificateType = 23539;

        /// <summary>
        /// The identifier for the EccBrainpoolP256r1ApplicationCertificateType ObjectType.
        /// </summary>
        public const uint EccBrainpoolP256r1ApplicationCertificateType = 23540;

        /// <summary>
        /// The identifier for the EccBrainpoolP384r1ApplicationCertificateType ObjectType.
        /// </summary>
        public const uint EccBrainpoolP384r1ApplicationCertificateType = 23541;

        /// <summary>
        /// The identifier for the EccCurve25519ApplicationCertificateType ObjectType.
        /// </summary>
        public const uint EccCurve25519ApplicationCertificateType = 23542;

        /// <summary>
        /// The identifier for the EccCurve448ApplicationCertificateType ObjectType.
        /// </summary>
        public const uint EccCurve448ApplicationCertificateType = 23543;

        /// <summary>
        /// The identifier for the TrustListUpdatedAuditEventType ObjectType.
        /// </summary>
        public const uint TrustListUpdatedAuditEventType = 12561;

        /// <summary>
        /// The identifier for the ServerConfigurationType ObjectType.
        /// </summary>
        public const uint ServerConfigurationType = 12581;

        /// <summary>
        /// The identifier for the CertificateUpdatedAuditEventType ObjectType.
        /// </summary>
        public const uint CertificateUpdatedAuditEventType = 12620;

        /// <summary>
        /// The identifier for the KeyCredentialConfigurationFolderType ObjectType.
        /// </summary>
        public const uint KeyCredentialConfigurationFolderType = 17496;

        /// <summary>
        /// The identifier for the KeyCredentialConfigurationType ObjectType.
        /// </summary>
        public const uint KeyCredentialConfigurationType = 18001;

        /// <summary>
        /// The identifier for the KeyCredentialAuditEventType ObjectType.
        /// </summary>
        public const uint KeyCredentialAuditEventType = 18011;

        /// <summary>
        /// The identifier for the KeyCredentialUpdatedAuditEventType ObjectType.
        /// </summary>
        public const uint KeyCredentialUpdatedAuditEventType = 18029;

        /// <summary>
        /// The identifier for the KeyCredentialDeletedAuditEventType ObjectType.
        /// </summary>
        public const uint KeyCredentialDeletedAuditEventType = 18047;

        /// <summary>
        /// The identifier for the AuthorizationServicesConfigurationFolderType ObjectType.
        /// </summary>
        public const uint AuthorizationServicesConfigurationFolderType = 23556;

        /// <summary>
        /// The identifier for the AuthorizationServiceConfigurationType ObjectType.
        /// </summary>
        public const uint AuthorizationServiceConfigurationType = 17852;

        /// <summary>
        /// The identifier for the AggregateConfigurationType ObjectType.
        /// </summary>
        public const uint AggregateConfigurationType = 11187;

        /// <summary>
        /// The identifier for the PubSubKeyServiceType ObjectType.
        /// </summary>
        public const uint PubSubKeyServiceType = 15906;

        /// <summary>
        /// The identifier for the SecurityGroupFolderType ObjectType.
        /// </summary>
        public const uint SecurityGroupFolderType = 15452;

        /// <summary>
        /// The identifier for the SecurityGroupType ObjectType.
        /// </summary>
        public const uint SecurityGroupType = 15471;

        /// <summary>
        /// The identifier for the PublishSubscribeType ObjectType.
        /// </summary>
        public const uint PublishSubscribeType = 14416;

        /// <summary>
        /// The identifier for the PublishedDataSetType ObjectType.
        /// </summary>
        public const uint PublishedDataSetType = 14509;

        /// <summary>
        /// The identifier for the ExtensionFieldsType ObjectType.
        /// </summary>
        public const uint ExtensionFieldsType = 15489;

        /// <summary>
        /// The identifier for the PublishedDataItemsType ObjectType.
        /// </summary>
        public const uint PublishedDataItemsType = 14534;

        /// <summary>
        /// The identifier for the PublishedEventsType ObjectType.
        /// </summary>
        public const uint PublishedEventsType = 14572;

        /// <summary>
        /// The identifier for the DataSetFolderType ObjectType.
        /// </summary>
        public const uint DataSetFolderType = 14477;

        /// <summary>
        /// The identifier for the PubSubConnectionType ObjectType.
        /// </summary>
        public const uint PubSubConnectionType = 14209;

        /// <summary>
        /// The identifier for the ConnectionTransportType ObjectType.
        /// </summary>
        public const uint ConnectionTransportType = 17721;

        /// <summary>
        /// The identifier for the PubSubGroupType ObjectType.
        /// </summary>
        public const uint PubSubGroupType = 14232;

        /// <summary>
        /// The identifier for the WriterGroupType ObjectType.
        /// </summary>
        public const uint WriterGroupType = 17725;

        /// <summary>
        /// The identifier for the WriterGroupTransportType ObjectType.
        /// </summary>
        public const uint WriterGroupTransportType = 17997;

        /// <summary>
        /// The identifier for the WriterGroupMessageType ObjectType.
        /// </summary>
        public const uint WriterGroupMessageType = 17998;

        /// <summary>
        /// The identifier for the ReaderGroupType ObjectType.
        /// </summary>
        public const uint ReaderGroupType = 17999;

        /// <summary>
        /// The identifier for the ReaderGroupTransportType ObjectType.
        /// </summary>
        public const uint ReaderGroupTransportType = 21090;

        /// <summary>
        /// The identifier for the ReaderGroupMessageType ObjectType.
        /// </summary>
        public const uint ReaderGroupMessageType = 21091;

        /// <summary>
        /// The identifier for the DataSetWriterType ObjectType.
        /// </summary>
        public const uint DataSetWriterType = 15298;

        /// <summary>
        /// The identifier for the DataSetWriterTransportType ObjectType.
        /// </summary>
        public const uint DataSetWriterTransportType = 15305;

        /// <summary>
        /// The identifier for the DataSetWriterMessageType ObjectType.
        /// </summary>
        public const uint DataSetWriterMessageType = 21096;

        /// <summary>
        /// The identifier for the DataSetReaderType ObjectType.
        /// </summary>
        public const uint DataSetReaderType = 15306;

        /// <summary>
        /// The identifier for the DataSetReaderTransportType ObjectType.
        /// </summary>
        public const uint DataSetReaderTransportType = 15319;

        /// <summary>
        /// The identifier for the DataSetReaderMessageType ObjectType.
        /// </summary>
        public const uint DataSetReaderMessageType = 21104;

        /// <summary>
        /// The identifier for the SubscribedDataSetType ObjectType.
        /// </summary>
        public const uint SubscribedDataSetType = 15108;

        /// <summary>
        /// The identifier for the TargetVariablesType ObjectType.
        /// </summary>
        public const uint TargetVariablesType = 15111;

        /// <summary>
        /// The identifier for the SubscribedDataSetMirrorType ObjectType.
        /// </summary>
        public const uint SubscribedDataSetMirrorType = 15127;

        /// <summary>
        /// The identifier for the PubSubStatusType ObjectType.
        /// </summary>
        public const uint PubSubStatusType = 14643;

        /// <summary>
        /// The identifier for the PubSubDiagnosticsType ObjectType.
        /// </summary>
        public const uint PubSubDiagnosticsType = 19677;

        /// <summary>
        /// The identifier for the PubSubDiagnosticsRootType ObjectType.
        /// </summary>
        public const uint PubSubDiagnosticsRootType = 19732;

        /// <summary>
        /// The identifier for the PubSubDiagnosticsConnectionType ObjectType.
        /// </summary>
        public const uint PubSubDiagnosticsConnectionType = 19786;

        /// <summary>
        /// The identifier for the PubSubDiagnosticsWriterGroupType ObjectType.
        /// </summary>
        public const uint PubSubDiagnosticsWriterGroupType = 19834;

        /// <summary>
        /// The identifier for the PubSubDiagnosticsReaderGroupType ObjectType.
        /// </summary>
        public const uint PubSubDiagnosticsReaderGroupType = 19903;

        /// <summary>
        /// The identifier for the PubSubDiagnosticsDataSetWriterType ObjectType.
        /// </summary>
        public const uint PubSubDiagnosticsDataSetWriterType = 19968;

        /// <summary>
        /// The identifier for the PubSubDiagnosticsDataSetReaderType ObjectType.
        /// </summary>
        public const uint PubSubDiagnosticsDataSetReaderType = 20027;

        /// <summary>
        /// The identifier for the PubSubStatusEventType ObjectType.
        /// </summary>
        public const uint PubSubStatusEventType = 15535;

        /// <summary>
        /// The identifier for the PubSubTransportLimitsExceedEventType ObjectType.
        /// </summary>
        public const uint PubSubTransportLimitsExceedEventType = 15548;

        /// <summary>
        /// The identifier for the PubSubCommunicationFailureEventType ObjectType.
        /// </summary>
        public const uint PubSubCommunicationFailureEventType = 15563;

        /// <summary>
        /// The identifier for the UadpWriterGroupMessageType ObjectType.
        /// </summary>
        public const uint UadpWriterGroupMessageType = 21105;

        /// <summary>
        /// The identifier for the UadpDataSetWriterMessageType ObjectType.
        /// </summary>
        public const uint UadpDataSetWriterMessageType = 21111;

        /// <summary>
        /// The identifier for the UadpDataSetReaderMessageType ObjectType.
        /// </summary>
        public const uint UadpDataSetReaderMessageType = 21116;

        /// <summary>
        /// The identifier for the JsonWriterGroupMessageType ObjectType.
        /// </summary>
        public const uint JsonWriterGroupMessageType = 21126;

        /// <summary>
        /// The identifier for the JsonDataSetWriterMessageType ObjectType.
        /// </summary>
        public const uint JsonDataSetWriterMessageType = 21128;

        /// <summary>
        /// The identifier for the JsonDataSetReaderMessageType ObjectType.
        /// </summary>
        public const uint JsonDataSetReaderMessageType = 21130;

        /// <summary>
        /// The identifier for the DatagramConnectionTransportType ObjectType.
        /// </summary>
        public const uint DatagramConnectionTransportType = 15064;

        /// <summary>
        /// The identifier for the DatagramWriterGroupTransportType ObjectType.
        /// </summary>
        public const uint DatagramWriterGroupTransportType = 21133;

        /// <summary>
        /// The identifier for the BrokerConnectionTransportType ObjectType.
        /// </summary>
        public const uint BrokerConnectionTransportType = 15155;

        /// <summary>
        /// The identifier for the BrokerWriterGroupTransportType ObjectType.
        /// </summary>
        public const uint BrokerWriterGroupTransportType = 21136;

        /// <summary>
        /// The identifier for the BrokerDataSetWriterTransportType ObjectType.
        /// </summary>
        public const uint BrokerDataSetWriterTransportType = 21138;

        /// <summary>
        /// The identifier for the BrokerDataSetReaderTransportType ObjectType.
        /// </summary>
        public const uint BrokerDataSetReaderTransportType = 21142;

        /// <summary>
        /// The identifier for the NetworkAddressType ObjectType.
        /// </summary>
        public const uint NetworkAddressType = 21145;

        /// <summary>
        /// The identifier for the NetworkAddressUrlType ObjectType.
        /// </summary>
        public const uint NetworkAddressUrlType = 21147;

        /// <summary>
        /// The identifier for the AliasNameType ObjectType.
        /// </summary>
        public const uint AliasNameType = 23455;

        /// <summary>
        /// The identifier for the AliasNameCategoryType ObjectType.
        /// </summary>
        public const uint AliasNameCategoryType = 23456;

        /// <summary>
        /// The identifier for the IIetfBaseNetworkInterfaceType ObjectType.
        /// </summary>
        public const uint IIetfBaseNetworkInterfaceType = 24148;

        /// <summary>
        /// The identifier for the IIeeeBaseEthernetPortType ObjectType.
        /// </summary>
        public const uint IIeeeBaseEthernetPortType = 24158;

        /// <summary>
        /// The identifier for the IIeeeAutoNegotiationStatusType ObjectType.
        /// </summary>
        public const uint IIeeeAutoNegotiationStatusType = 24233;

        /// <summary>
        /// The identifier for the IBaseEthernetCapabilitiesType ObjectType.
        /// </summary>
        public const uint IBaseEthernetCapabilitiesType = 24167;

        /// <summary>
        /// The identifier for the ISrClassType ObjectType.
        /// </summary>
        public const uint ISrClassType = 24169;

        /// <summary>
        /// The identifier for the IIeeeBaseTsnStreamType ObjectType.
        /// </summary>
        public const uint IIeeeBaseTsnStreamType = 24173;

        /// <summary>
        /// The identifier for the IIeeeBaseTsnTrafficSpecificationType ObjectType.
        /// </summary>
        public const uint IIeeeBaseTsnTrafficSpecificationType = 24179;

        /// <summary>
        /// The identifier for the IIeeeBaseTsnStatusStreamType ObjectType.
        /// </summary>
        public const uint IIeeeBaseTsnStatusStreamType = 24183;

        /// <summary>
        /// The identifier for the IIeeeTsnInterfaceConfigurationType ObjectType.
        /// </summary>
        public const uint IIeeeTsnInterfaceConfigurationType = 24188;

        /// <summary>
        /// The identifier for the IIeeeTsnInterfaceConfigurationTalkerType ObjectType.
        /// </summary>
        public const uint IIeeeTsnInterfaceConfigurationTalkerType = 24191;

        /// <summary>
        /// The identifier for the IIeeeTsnInterfaceConfigurationListenerType ObjectType.
        /// </summary>
        public const uint IIeeeTsnInterfaceConfigurationListenerType = 24195;

        /// <summary>
        /// The identifier for the IIeeeTsnMacAddressType ObjectType.
        /// </summary>
        public const uint IIeeeTsnMacAddressType = 24199;

        /// <summary>
        /// The identifier for the IIeeeTsnVlanTagType ObjectType.
        /// </summary>
        public const uint IIeeeTsnVlanTagType = 24202;

        /// <summary>
        /// The identifier for the IPriorityMappingEntryType ObjectType.
        /// </summary>
        public const uint IPriorityMappingEntryType = 24205;
    }
    #endregion

    #region ReferenceType Identifiers
    /// <summary>
    /// A class that declares constants for all ReferenceTypes in the Model Design.
    /// </summary>
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class ReferenceTypes
    {
        /// <summary>
        /// The identifier for the References ReferenceType.
        /// </summary>
        public const uint References = 31;

        /// <summary>
        /// The identifier for the NonHierarchicalReferences ReferenceType.
        /// </summary>
        public const uint NonHierarchicalReferences = 32;

        /// <summary>
        /// The identifier for the HierarchicalReferences ReferenceType.
        /// </summary>
        public const uint HierarchicalReferences = 33;

        /// <summary>
        /// The identifier for the HasChild ReferenceType.
        /// </summary>
        public const uint HasChild = 34;

        /// <summary>
        /// The identifier for the Organizes ReferenceType.
        /// </summary>
        public const uint Organizes = 35;

        /// <summary>
        /// The identifier for the HasEventSource ReferenceType.
        /// </summary>
        public const uint HasEventSource = 36;

        /// <summary>
        /// The identifier for the HasModellingRule ReferenceType.
        /// </summary>
        public const uint HasModellingRule = 37;

        /// <summary>
        /// The identifier for the HasEncoding ReferenceType.
        /// </summary>
        public const uint HasEncoding = 38;

        /// <summary>
        /// The identifier for the HasDescription ReferenceType.
        /// </summary>
        public const uint HasDescription = 39;

        /// <summary>
        /// The identifier for the HasTypeDefinition ReferenceType.
        /// </summary>
        public const uint HasTypeDefinition = 40;

        /// <summary>
        /// The identifier for the GeneratesEvent ReferenceType.
        /// </summary>
        public const uint GeneratesEvent = 41;

        /// <summary>
        /// The identifier for the AlwaysGeneratesEvent ReferenceType.
        /// </summary>
        public const uint AlwaysGeneratesEvent = 3065;

        /// <summary>
        /// The identifier for the Aggregates ReferenceType.
        /// </summary>
        public const uint Aggregates = 44;

        /// <summary>
        /// The identifier for the HasSubtype ReferenceType.
        /// </summary>
        public const uint HasSubtype = 45;

        /// <summary>
        /// The identifier for the HasProperty ReferenceType.
        /// </summary>
        public const uint HasProperty = 46;

        /// <summary>
        /// The identifier for the HasComponent ReferenceType.
        /// </summary>
        public const uint HasComponent = 47;

        /// <summary>
        /// The identifier for the HasNotifier ReferenceType.
        /// </summary>
        public const uint HasNotifier = 48;

        /// <summary>
        /// The identifier for the HasOrderedComponent ReferenceType.
        /// </summary>
        public const uint HasOrderedComponent = 49;

        /// <summary>
        /// The identifier for the FromState ReferenceType.
        /// </summary>
        public const uint FromState = 51;

        /// <summary>
        /// The identifier for the ToState ReferenceType.
        /// </summary>
        public const uint ToState = 52;

        /// <summary>
        /// The identifier for the HasCause ReferenceType.
        /// </summary>
        public const uint HasCause = 53;

        /// <summary>
        /// The identifier for the HasEffect ReferenceType.
        /// </summary>
        public const uint HasEffect = 54;

        /// <summary>
        /// The identifier for the HasSubStateMachine ReferenceType.
        /// </summary>
        public const uint HasSubStateMachine = 117;

        /// <summary>
        /// The identifier for the HasHistoricalConfiguration ReferenceType.
        /// </summary>
        public const uint HasHistoricalConfiguration = 56;

        /// <summary>
        /// The identifier for the HasArgumentDescription ReferenceType.
        /// </summary>
        public const uint HasArgumentDescription = 129;

        /// <summary>
        /// The identifier for the HasOptionalInputArgumentDescription ReferenceType.
        /// </summary>
        public const uint HasOptionalInputArgumentDescription = 131;

        /// <summary>
        /// The identifier for the HasGuard ReferenceType.
        /// </summary>
        public const uint HasGuard = 15112;

        /// <summary>
        /// The identifier for the HasDictionaryEntry ReferenceType.
        /// </summary>
        public const uint HasDictionaryEntry = 17597;

        /// <summary>
        /// The identifier for the HasInterface ReferenceType.
        /// </summary>
        public const uint HasInterface = 17603;

        /// <summary>
        /// The identifier for the HasAddIn ReferenceType.
        /// </summary>
        public const uint HasAddIn = 17604;

        /// <summary>
        /// The identifier for the HasTrueSubState ReferenceType.
        /// </summary>
        public const uint HasTrueSubState = 9004;

        /// <summary>
        /// The identifier for the HasFalseSubState ReferenceType.
        /// </summary>
        public const uint HasFalseSubState = 9005;

        /// <summary>
        /// The identifier for the HasAlarmSuppressionGroup ReferenceType.
        /// </summary>
        public const uint HasAlarmSuppressionGroup = 16361;

        /// <summary>
        /// The identifier for the AlarmGroupMember ReferenceType.
        /// </summary>
        public const uint AlarmGroupMember = 16362;

        /// <summary>
        /// The identifier for the HasCondition ReferenceType.
        /// </summary>
        public const uint HasCondition = 9006;

        /// <summary>
        /// The identifier for the HasEffectDisable ReferenceType.
        /// </summary>
        public const uint HasEffectDisable = 17276;

        /// <summary>
        /// The identifier for the HasEffectEnable ReferenceType.
        /// </summary>
        public const uint HasEffectEnable = 17983;

        /// <summary>
        /// The identifier for the HasEffectSuppressed ReferenceType.
        /// </summary>
        public const uint HasEffectSuppressed = 17984;

        /// <summary>
        /// The identifier for the HasEffectUnsuppressed ReferenceType.
        /// </summary>
        public const uint HasEffectUnsuppressed = 17985;

        /// <summary>
        /// The identifier for the HasPubSubConnection ReferenceType.
        /// </summary>
        public const uint HasPubSubConnection = 14476;

        /// <summary>
        /// The identifier for the DataSetToWriter ReferenceType.
        /// </summary>
        public const uint DataSetToWriter = 14936;

        /// <summary>
        /// The identifier for the HasDataSetWriter ReferenceType.
        /// </summary>
        public const uint HasDataSetWriter = 15296;

        /// <summary>
        /// The identifier for the HasWriterGroup ReferenceType.
        /// </summary>
        public const uint HasWriterGroup = 18804;

        /// <summary>
        /// The identifier for the HasDataSetReader ReferenceType.
        /// </summary>
        public const uint HasDataSetReader = 15297;

        /// <summary>
        /// The identifier for the HasReaderGroup ReferenceType.
        /// </summary>
        public const uint HasReaderGroup = 18805;

        /// <summary>
        /// The identifier for the AliasFor ReferenceType.
        /// </summary>
        public const uint AliasFor = 23469;
    }
    #endregion

    #region Variable Identifiers
    /// <summary>
    /// A class that declares constants for all Variables in the Model Design.
    /// </summary>
    /// <exclude />
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Opc.Ua.ModelCompiler", "1.0.0.0")]
    public static partial class Variables
    {
        /// <summary>
        /// The identifier for the DataTypeDescriptionType_DataTypeVersion Variable.
        /// </summary>
        public const uint DataTypeDescriptionType_DataTypeVersion = 104;

        /// <summary>
        /// The identifier for the DataTypeDescriptionType_DictionaryFragment Variable.
        /// </summary>
        public const uint DataTypeDescriptionType_DictionaryFragment = 105;

        /// <summary>
        /// The identifier for the DataTypeDictionaryType_DataTypeVersion Variable.
        /// </summary>
        public const uint DataTypeDictionaryType_DataTypeVersion = 106;

        /// <summary>
        /// The identifier for the DataTypeDictionaryType_NamespaceUri Variable.
        /// </summary>
        public const uint DataTypeDictionaryType_NamespaceUri = 107;

        /// <summary>
        /// The identifier for the DataTypeDictionaryType_Deprecated Variable.
        /// </summary>
        public const uint DataTypeDictionaryType_Deprecated = 15001;

        /// <summary>
        /// The identifier for the NamingRuleType_EnumValues Variable.
        /// </summary>
        public const uint NamingRuleType_EnumValues = 12169;

        /// <summary>
        /// The identifier for the ModellingRuleType_NamingRule Variable.
        /// </summary>
        public const uint ModellingRuleType_NamingRule = 111;

        /// <summary>
        /// The identifier for the ModellingRule_Mandatory_NamingRule Variable.
        /// </summary>
        public const uint ModellingRule_Mandatory_NamingRule = 112;

        /// <summary>
        /// The identifier for the ModellingRule_Optional_NamingRule Variable.
        /// </summary>
        public const uint ModellingRule_Optional_NamingRule = 113;

        /// <summary>
        /// The identifier for the ModellingRule_ExposesItsArray_NamingRule Variable.
        /// </summary>
        public const uint ModellingRule_ExposesItsArray_NamingRule = 114;

        /// <summary>
        /// The identifier for the ModellingRule_OptionalPlaceholder_NamingRule Variable.
        /// </summary>
        public const uint ModellingRule_OptionalPlaceholder_NamingRule = 11509;

        /// <summary>
        /// The identifier for the ModellingRule_MandatoryPlaceholder_NamingRule Variable.
        /// </summary>
        public const uint ModellingRule_MandatoryPlaceholder_NamingRule = 11511;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespaceUri Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespaceUri = 15958;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespaceVersion Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespaceVersion = 15959;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespacePublicationDate Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespacePublicationDate = 15960;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_IsNamespaceSubset Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_IsNamespaceSubset = 15961;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_StaticNodeIdTypes Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_StaticNodeIdTypes = 15962;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_StaticNumericNodeIdRange Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_StaticNumericNodeIdRange = 15963;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_StaticStringNodeIdPattern Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_StaticStringNodeIdPattern = 15964;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespaceFile_Size Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespaceFile_Size = 15966;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespaceFile_Writable Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespaceFile_Writable = 15967;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespaceFile_UserWritable Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespaceFile_UserWritable = 15968;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespaceFile_OpenCount Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespaceFile_OpenCount = 15969;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespaceFile_Open_InputArguments Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespaceFile_Open_InputArguments = 15972;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespaceFile_Open_OutputArguments Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespaceFile_Open_OutputArguments = 15973;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespaceFile_Close_InputArguments Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespaceFile_Close_InputArguments = 15975;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespaceFile_Read_InputArguments Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespaceFile_Read_InputArguments = 15977;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespaceFile_Read_OutputArguments Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespaceFile_Read_OutputArguments = 15978;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespaceFile_Write_InputArguments Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespaceFile_Write_InputArguments = 15980;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespaceFile_GetPosition_InputArguments Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespaceFile_GetPosition_InputArguments = 15982;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespaceFile_GetPosition_OutputArguments Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespaceFile_GetPosition_OutputArguments = 15983;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_NamespaceFile_SetPosition_InputArguments Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_NamespaceFile_SetPosition_InputArguments = 15985;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_DefaultRolePermissions Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_DefaultRolePermissions = 16134;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_DefaultUserRolePermissions Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_DefaultUserRolePermissions = 16135;

        /// <summary>
        /// The identifier for the OPCUANamespaceMetadata_DefaultAccessRestrictions Variable.
        /// </summary>
        public const uint OPCUANamespaceMetadata_DefaultAccessRestrictions = 16136;

        /// <summary>
        /// The identifier for the NodeVersion Variable.
        /// </summary>
        public const uint NodeVersion = 3068;

        /// <summary>
        /// The identifier for the ViewVersion Variable.
        /// </summary>
        public const uint ViewVersion = 12170;

        /// <summary>
        /// The identifier for the Icon Variable.
        /// </summary>
        public const uint Icon = 3067;

        /// <summary>
        /// The identifier for the LocalTime Variable.
        /// </summary>
        public const uint LocalTime = 3069;

        /// <summary>
        /// The identifier for the AllowNulls Variable.
        /// </summary>
        public const uint AllowNulls = 3070;

        /// <summary>
        /// The identifier for the ValueAsText Variable.
        /// </summary>
        public const uint ValueAsText = 11433;

        /// <summary>
        /// The identifier for the MaxStringLength Variable.
        /// </summary>
        public const uint MaxStringLength = 11498;

        /// <summary>
        /// The identifier for the MaxCharacters Variable.
        /// </summary>
        public const uint MaxCharacters = 15002;

        /// <summary>
        /// The identifier for the MaxByteStringLength Variable.
        /// </summary>
        public const uint MaxByteStringLength = 12908;

        /// <summary>
        /// The identifier for the MaxArrayLength Variable.
        /// </summary>
        public const uint MaxArrayLength = 11512;

        /// <summary>
        /// The identifier for the EngineeringUnits Variable.
        /// </summary>
        public const uint EngineeringUnits = 11513;

        /// <summary>
        /// The identifier for the EnumStrings Variable.
        /// </summary>
        public const uint EnumStrings = 11432;

        /// <summary>
        /// The identifier for the EnumValues Variable.
        /// </summary>
        public const uint EnumValues = 3071;

        /// <summary>
        /// The identifier for the OptionSetValues Variable.
        /// </summary>
        public const uint OptionSetValues = 12745;

        /// <summary>
        /// The identifier for the InputArguments Variable.
        /// </summary>
        public const uint InputArguments = 3072;

        /// <summary>
        /// The identifier for the OutputArguments Variable.
        /// </summary>
        public const uint OutputArguments = 3073;

        /// <summary>
        /// The identifier for the DefaultInstanceBrowseName Variable.
        /// </summary>
        public const uint DefaultInstanceBrowseName = 17605;

        /// <summary>
        /// The identifier for the ServerType_ServerArray Variable.
        /// </summary>
        public const uint ServerType_ServerArray = 2005;

        /// <summary>
        /// The identifier for the ServerType_NamespaceArray Variable.
        /// </summary>
        public const uint ServerType_NamespaceArray = 2006;

        /// <summary>
        /// The identifier for the ServerType_UrisVersion Variable.
        /// </summary>
        public const uint ServerType_UrisVersion = 15003;

        /// <summary>
        /// The identifier for the ServerType_ServerStatus Variable.
        /// </summary>
        public const uint ServerType_ServerStatus = 2007;

        /// <summary>
        /// The identifier for the ServerType_ServerStatus_StartTime Variable.
        /// </summary>
        public const uint ServerType_ServerStatus_StartTime = 3074;

        /// <summary>
        /// The identifier for the ServerType_ServerStatus_CurrentTime Variable.
        /// </summary>
        public const uint ServerType_ServerStatus_CurrentTime = 3075;

        /// <summary>
        /// The identifier for the ServerType_ServerStatus_State Variable.
        /// </summary>
        public const uint ServerType_ServerStatus_State = 3076;

        /// <summary>
        /// The identifier for the ServerType_ServerStatus_BuildInfo Variable.
        /// </summary>
        public const uint ServerType_ServerStatus_BuildInfo = 3077;

        /// <summary>
        /// The identifier for the ServerType_ServerStatus_BuildInfo_ProductUri Variable.
        /// </summary>
        public const uint ServerType_ServerStatus_BuildInfo_ProductUri = 3078;

        /// <summary>
        /// The identifier for the ServerType_ServerStatus_BuildInfo_ManufacturerName Variable.
        /// </summary>
        public const uint ServerType_ServerStatus_BuildInfo_ManufacturerName = 3079;

        /// <summary>
        /// The identifier for the ServerType_ServerStatus_BuildInfo_ProductName Variable.
        /// </summary>
        public const uint ServerType_ServerStatus_BuildInfo_ProductName = 3080;

        /// <summary>
        /// The identifier for the ServerType_ServerStatus_BuildInfo_SoftwareVersion Variable.
        /// </summary>
        public const uint ServerType_ServerStatus_BuildInfo_SoftwareVersion = 3081;

        /// <summary>
        /// The identifier for the ServerType_ServerStatus_BuildInfo_BuildNumber Variable.
        /// </summary>
        public const uint ServerType_ServerStatus_BuildInfo_BuildNumber = 3082;

        /// <summary>
        /// The identifier for the ServerType_ServerStatus_BuildInfo_BuildDate Variable.
        /// </summary>
        public const uint ServerType_ServerStatus_BuildInfo_BuildDate = 3083;

        /// <summary>
        /// The identifier for the ServerType_ServerStatus_SecondsTillShutdown Variable.
        /// </summary>
        public const uint ServerType_ServerStatus_SecondsTillShutdown = 3084;

        /// <summary>
        /// The identifier for the ServerType_ServerStatus_ShutdownReason Variable.
        /// </summary>
        public const uint ServerType_ServerStatus_ShutdownReason = 3085;

        /// <summary>
        /// The identifier for the ServerType_ServiceLevel Variable.
        /// </summary>
        public const uint ServerType_ServiceLevel = 2008;

        /// <summary>
        /// The identifier for the ServerType_Auditing Variable.
        /// </summary>
        public const uint ServerType_Auditing = 2742;

        /// <summary>
        /// The identifier for the ServerType_EstimatedReturnTime Variable.
        /// </summary>
        public const uint ServerType_EstimatedReturnTime = 12882;

        /// <summary>
        /// The identifier for the ServerType_LocalTime Variable.
        /// </summary>
        public const uint ServerType_LocalTime = 17612;

        /// <summary>
        /// The identifier for the ServerType_ServerCapabilities_ServerProfileArray Variable.
        /// </summary>
        public const uint ServerType_ServerCapabilities_ServerProfileArray = 3086;

        /// <summary>
        /// The identifier for the ServerType_ServerCapabilities_LocaleIdArray Variable.
        /// </summary>
        public const uint ServerType_ServerCapabilities_LocaleIdArray = 3087;

        /// <summary>
        /// The identifier for the ServerType_ServerCapabilities_MinSupportedSampleRate Variable.
        /// </summary>
        public const uint ServerType_ServerCapabilities_MinSupportedSampleRate = 3088;

        /// <summary>
        /// The identifier for the ServerType_ServerCapabilities_MaxBrowseContinuationPoints Variable.
        /// </summary>
        public const uint ServerType_ServerCapabilities_MaxBrowseContinuationPoints = 3089;

        /// <summary>
        /// The identifier for the ServerType_ServerCapabilities_MaxQueryContinuationPoints Variable.
        /// </summary>
        public const uint ServerType_ServerCapabilities_MaxQueryContinuationPoints = 3090;

        /// <summary>
        /// The identifier for the ServerType_ServerCapabilities_MaxHistoryContinuationPoints Variable.
        /// </summary>
        public const uint ServerType_ServerCapabilities_MaxHistoryContinuationPoints = 3091;

        /// <summary>
        /// The identifier for the ServerType_ServerCapabilities_SoftwareCertificates Variable.
        /// </summary>
        public const uint ServerType_ServerCapabilities_SoftwareCertificates = 3092;

        /// <summary>
        /// The identifier for the ServerType_ServerCapabilities_RoleSet_AddRole_InputArguments Variable.
        /// </summary>
        public const uint ServerType_ServerCapabilities_RoleSet_AddRole_InputArguments = 16291;

        /// <summary>
        /// The identifier for the ServerType_ServerCapabilities_RoleSet_AddRole_OutputArguments Variable.
        /// </summary>
        public const uint ServerType_ServerCapabilities_RoleSet_AddRole_OutputArguments = 16292;

        /// <summary>
        /// The identifier for the ServerType_ServerCapabilities_RoleSet_RemoveRole_InputArguments Variable.
        /// </summary>
        public const uint ServerType_ServerCapabilities_RoleSet_RemoveRole_InputArguments = 16294;

        /// <summary>
        /// The identifier for the ServerType_ServerDiagnostics_ServerDiagnosticsSummary Variable.
        /// </summary>
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary = 3095;

        /// <summary>
        /// The identifier for the ServerType_ServerDiagnostics_ServerDiagnosticsSummary_ServerViewCount Variable.
        /// </summary>
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_ServerViewCount = 3096;

        /// <summary>
        /// The identifier for the ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSessionCount Variable.
        /// </summary>
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSessionCount = 3097;

        /// <summary>
        /// The identifier for the ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSessionCount Variable.
        /// </summary>
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSessionCount = 3098;

        /// <summary>
        /// The identifier for the ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedSessionCount Variable.
        /// </summary>
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedSessionCount = 3099;

        /// <summary>
        /// The identifier for the ServerType_ServerDiagnostics_ServerDiagnosticsSummary_RejectedSessionCount Variable.
        /// </summary>
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_RejectedSessionCount = 3100;

        /// <summary>
        /// The identifier for the ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SessionTimeoutCount Variable.
        /// </summary>
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SessionTimeoutCount = 3101;

        /// <summary>
        /// The identifier for the ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SessionAbortCount Variable.
        /// </summary>
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SessionAbortCount = 3102;

        /// <summary>
        /// The identifier for the ServerType_ServerDiagnostics_ServerDiagnosticsSummary_PublishingIntervalCount Variable.
        /// </summary>
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_PublishingIntervalCount = 3104;

        /// <summary>
        /// The identifier for the ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSubscriptionCount Variable.
        /// </summary>
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSubscriptionCount = 3105;

        /// <summary>
        /// The identifier for the ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSubscriptionCount Variable.
        /// </summary>
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSubscriptionCount = 3106;

        /// <summary>
        /// The identifier for the ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedRequestsCount Variable.
        /// </summary>
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedRequestsCount = 3107;

        /// <summary>
        /// The identifier for the ServerType_ServerDiagnostics_ServerDiagnosticsSummary_RejectedRequestsCount Variable.
        /// </summary>
        public const uint ServerType_ServerDiagnostics_ServerDiagnosticsSummary_RejectedRequestsCount = 3108;

        /// <summary>
        /// The identifier for the ServerType_ServerDiagnostics_SubscriptionDiagnosticsArray Variable.
        /// </summary>
        public const uint ServerType_ServerDiagnostics_SubscriptionDiagnosticsArray = 3110;

        /// <summary>
        /// The identifier for the ServerType_ServerDiagnostics_SessionsDiagnosticsSummary_SessionDiagnosticsArray Variable.
        /// </summary>
        public const uint ServerType_ServerDiagnostics_SessionsDiagnosticsSummary_SessionDiagnosticsArray = 3112;

        /// <summary>
        /// The identifier for the ServerType_ServerDiagnostics_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray Variable.
        /// </summary>
        public const uint ServerType_ServerDiagnostics_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray = 3113;

        /// <summary>
        /// The identifier for the ServerType_ServerDiagnostics_EnabledFlag Variable.
        /// </summary>
        public const uint ServerType_ServerDiagnostics_EnabledFlag = 3114;

        /// <summary>
        /// The identifier for the ServerType_ServerRedundancy_RedundancySupport Variable.
        /// </summary>
        public const uint ServerType_ServerRedundancy_RedundancySupport = 3115;

        /// <summary>
        /// The identifier for the ServerType_GetMonitoredItems_InputArguments Variable.
        /// </summary>
        public const uint ServerType_GetMonitoredItems_InputArguments = 11490;

        /// <summary>
        /// The identifier for the ServerType_GetMonitoredItems_OutputArguments Variable.
        /// </summary>
        public const uint ServerType_GetMonitoredItems_OutputArguments = 11491;

        /// <summary>
        /// The identifier for the ServerType_ResendData_InputArguments Variable.
        /// </summary>
        public const uint ServerType_ResendData_InputArguments = 12872;

        /// <summary>
        /// The identifier for the ServerType_SetSubscriptionDurable_InputArguments Variable.
        /// </summary>
        public const uint ServerType_SetSubscriptionDurable_InputArguments = 12747;

        /// <summary>
        /// The identifier for the ServerType_SetSubscriptionDurable_OutputArguments Variable.
        /// </summary>
        public const uint ServerType_SetSubscriptionDurable_OutputArguments = 12748;

        /// <summary>
        /// The identifier for the ServerType_RequestServerStateChange_InputArguments Variable.
        /// </summary>
        public const uint ServerType_RequestServerStateChange_InputArguments = 12884;

        /// <summary>
        /// The identifier for the ServerCapabilitiesType_ServerProfileArray Variable.
        /// </summary>
        public const uint ServerCapabilitiesType_ServerProfileArray = 2014;

        /// <summary>
        /// The identifier for the ServerCapabilitiesType_LocaleIdArray Variable.
        /// </summary>
        public const uint ServerCapabilitiesType_LocaleIdArray = 2016;

        /// <summary>
        /// The identifier for the ServerCapabilitiesType_MinSupportedSampleRate Variable.
        /// </summary>
        public const uint ServerCapabilitiesType_MinSupportedSampleRate = 2017;

        /// <summary>
        /// The identifier for the ServerCapabilitiesType_MaxBrowseContinuationPoints Variable.
        /// </summary>
        public const uint ServerCapabilitiesType_MaxBrowseContinuationPoints = 2732;

        /// <summary>
        /// The identifier for the ServerCapabilitiesType_MaxQueryContinuationPoints Variable.
        /// </summary>
        public const uint ServerCapabilitiesType_MaxQueryContinuationPoints = 2733;

        /// <summary>
        /// The identifier for the ServerCapabilitiesType_MaxHistoryContinuationPoints Variable.
        /// </summary>
        public const uint ServerCapabilitiesType_MaxHistoryContinuationPoints = 2734;

        /// <summary>
        /// The identifier for the ServerCapabilitiesType_SoftwareCertificates Variable.
        /// </summary>
        public const uint ServerCapabilitiesType_SoftwareCertificates = 3049;

        /// <summary>
        /// The identifier for the ServerCapabilitiesType_MaxArrayLength Variable.
        /// </summary>
        public const uint ServerCapabilitiesType_MaxArrayLength = 11549;

        /// <summary>
        /// The identifier for the ServerCapabilitiesType_MaxStringLength Variable.
        /// </summary>
        public const uint ServerCapabilitiesType_MaxStringLength = 11550;

        /// <summary>
        /// The identifier for the ServerCapabilitiesType_MaxByteStringLength Variable.
        /// </summary>
        public const uint ServerCapabilitiesType_MaxByteStringLength = 12910;

        /// <summary>
        /// The identifier for the ServerCapabilitiesType_VendorCapability_Placeholder Variable.
        /// </summary>
        public const uint ServerCapabilitiesType_VendorCapability_Placeholder = 11562;

        /// <summary>
        /// The identifier for the ServerCapabilitiesType_RoleSet_AddRole_InputArguments Variable.
        /// </summary>
        public const uint ServerCapabilitiesType_RoleSet_AddRole_InputArguments = 16297;

        /// <summary>
        /// The identifier for the ServerCapabilitiesType_RoleSet_AddRole_OutputArguments Variable.
        /// </summary>
        public const uint ServerCapabilitiesType_RoleSet_AddRole_OutputArguments = 16298;

        /// <summary>
        /// The identifier for the ServerCapabilitiesType_RoleSet_RemoveRole_InputArguments Variable.
        /// </summary>
        public const uint ServerCapabilitiesType_RoleSet_RemoveRole_InputArguments = 16300;

        /// <summary>
        /// The identifier for the ServerDiagnosticsType_ServerDiagnosticsSummary Variable.
        /// </summary>
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary = 2021;

        /// <summary>
        /// The identifier for the ServerDiagnosticsType_ServerDiagnosticsSummary_ServerViewCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_ServerViewCount = 3116;

        /// <summary>
        /// The identifier for the ServerDiagnosticsType_ServerDiagnosticsSummary_CurrentSessionCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_CurrentSessionCount = 3117;

        /// <summary>
        /// The identifier for the ServerDiagnosticsType_ServerDiagnosticsSummary_CumulatedSessionCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_CumulatedSessionCount = 3118;

        /// <summary>
        /// The identifier for the ServerDiagnosticsType_ServerDiagnosticsSummary_SecurityRejectedSessionCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_SecurityRejectedSessionCount = 3119;

        /// <summary>
        /// The identifier for the ServerDiagnosticsType_ServerDiagnosticsSummary_RejectedSessionCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_RejectedSessionCount = 3120;

        /// <summary>
        /// The identifier for the ServerDiagnosticsType_ServerDiagnosticsSummary_SessionTimeoutCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_SessionTimeoutCount = 3121;

        /// <summary>
        /// The identifier for the ServerDiagnosticsType_ServerDiagnosticsSummary_SessionAbortCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_SessionAbortCount = 3122;

        /// <summary>
        /// The identifier for the ServerDiagnosticsType_ServerDiagnosticsSummary_PublishingIntervalCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_PublishingIntervalCount = 3124;

        /// <summary>
        /// The identifier for the ServerDiagnosticsType_ServerDiagnosticsSummary_CurrentSubscriptionCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_CurrentSubscriptionCount = 3125;

        /// <summary>
        /// The identifier for the ServerDiagnosticsType_ServerDiagnosticsSummary_CumulatedSubscriptionCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_CumulatedSubscriptionCount = 3126;

        /// <summary>
        /// The identifier for the ServerDiagnosticsType_ServerDiagnosticsSummary_SecurityRejectedRequestsCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_SecurityRejectedRequestsCount = 3127;

        /// <summary>
        /// The identifier for the ServerDiagnosticsType_ServerDiagnosticsSummary_RejectedRequestsCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsType_ServerDiagnosticsSummary_RejectedRequestsCount = 3128;

        /// <summary>
        /// The identifier for the ServerDiagnosticsType_SamplingIntervalDiagnosticsArray Variable.
        /// </summary>
        public const uint ServerDiagnosticsType_SamplingIntervalDiagnosticsArray = 2022;

        /// <summary>
        /// The identifier for the ServerDiagnosticsType_SubscriptionDiagnosticsArray Variable.
        /// </summary>
        public const uint ServerDiagnosticsType_SubscriptionDiagnosticsArray = 2023;

        /// <summary>
        /// The identifier for the ServerDiagnosticsType_SessionsDiagnosticsSummary_SessionDiagnosticsArray Variable.
        /// </summary>
        public const uint ServerDiagnosticsType_SessionsDiagnosticsSummary_SessionDiagnosticsArray = 3129;

        /// <summary>
        /// The identifier for the ServerDiagnosticsType_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray Variable.
        /// </summary>
        public const uint ServerDiagnosticsType_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray = 3130;

        /// <summary>
        /// The identifier for the ServerDiagnosticsType_EnabledFlag Variable.
        /// </summary>
        public const uint ServerDiagnosticsType_EnabledFlag = 2025;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_SessionDiagnosticsArray Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_SessionDiagnosticsArray = 2027;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_SessionSecurityDiagnosticsArray Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_SessionSecurityDiagnosticsArray = 2028;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics = 12098;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionId Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionId = 12099;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionName Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionName = 12100;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientDescription Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientDescription = 12101;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ServerUri Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ServerUri = 12102;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_EndpointUrl Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_EndpointUrl = 12103;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_LocaleIds Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_LocaleIds = 12104;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ActualSessionTimeout Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ActualSessionTimeout = 12105;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_MaxResponseMessageSize Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_MaxResponseMessageSize = 12106;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientConnectionTime Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientConnectionTime = 12107;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientLastContactTime Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientLastContactTime = 12108;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentSubscriptionsCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentSubscriptionsCount = 12109;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentMonitoredItemsCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentMonitoredItemsCount = 12110;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentPublishRequestsInQueue Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentPublishRequestsInQueue = 12111;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TotalRequestCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TotalRequestCount = 12112;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnauthorizedRequestCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnauthorizedRequestCount = 12113;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ReadCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ReadCount = 12114;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryReadCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryReadCount = 12115;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_WriteCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_WriteCount = 12116;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryUpdateCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryUpdateCount = 12117;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CallCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CallCount = 12118;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateMonitoredItemsCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateMonitoredItemsCount = 12119;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifyMonitoredItemsCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifyMonitoredItemsCount = 12120;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetMonitoringModeCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetMonitoringModeCount = 12121;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetTriggeringCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetTriggeringCount = 12122;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteMonitoredItemsCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteMonitoredItemsCount = 12123;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateSubscriptionCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateSubscriptionCount = 12124;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifySubscriptionCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifySubscriptionCount = 12125;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetPublishingModeCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetPublishingModeCount = 12126;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_PublishCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_PublishCount = 12127;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RepublishCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RepublishCount = 12128;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TransferSubscriptionsCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TransferSubscriptionsCount = 12129;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteSubscriptionsCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteSubscriptionsCount = 12130;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddNodesCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddNodesCount = 12131;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddReferencesCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddReferencesCount = 12132;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteNodesCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteNodesCount = 12133;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteReferencesCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteReferencesCount = 12134;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseCount = 12135;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseNextCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseNextCount = 12136;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount = 12137;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryFirstCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryFirstCount = 12138;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryNextCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryNextCount = 12139;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RegisterNodesCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RegisterNodesCount = 12140;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnregisterNodesCount Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnregisterNodesCount = 12141;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics = 12142;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SessionId Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SessionId = 12143;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdOfSession Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdOfSession = 12144;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdHistory Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdHistory = 12145;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_AuthenticationMechanism Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_AuthenticationMechanism = 12146;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_Encoding Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_Encoding = 12147;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_TransportProtocol Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_TransportProtocol = 12148;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityMode Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityMode = 12149;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityPolicyUri Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityPolicyUri = 12150;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientCertificate Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientCertificate = 12151;

        /// <summary>
        /// The identifier for the SessionsDiagnosticsSummaryType_ClientName_Placeholder_SubscriptionDiagnosticsArray Variable.
        /// </summary>
        public const uint SessionsDiagnosticsSummaryType_ClientName_Placeholder_SubscriptionDiagnosticsArray = 12152;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics = 2030;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_SessionId Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_SessionId = 3131;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_SessionName Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_SessionName = 3132;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_ClientDescription Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_ClientDescription = 3133;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_ServerUri Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_ServerUri = 3134;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_EndpointUrl Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_EndpointUrl = 3135;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_LocaleIds Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_LocaleIds = 3136;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_ActualSessionTimeout Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_ActualSessionTimeout = 3137;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_MaxResponseMessageSize Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_MaxResponseMessageSize = 3138;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_ClientConnectionTime Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_ClientConnectionTime = 3139;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_ClientLastContactTime Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_ClientLastContactTime = 3140;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_CurrentSubscriptionsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_CurrentSubscriptionsCount = 3141;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_CurrentMonitoredItemsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_CurrentMonitoredItemsCount = 3142;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_CurrentPublishRequestsInQueue Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_CurrentPublishRequestsInQueue = 3143;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_TotalRequestCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_TotalRequestCount = 8898;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_UnauthorizedRequestCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_UnauthorizedRequestCount = 11891;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_ReadCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_ReadCount = 3151;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_HistoryReadCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_HistoryReadCount = 3152;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_WriteCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_WriteCount = 3153;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_HistoryUpdateCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_HistoryUpdateCount = 3154;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_CallCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_CallCount = 3155;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_CreateMonitoredItemsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_CreateMonitoredItemsCount = 3156;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_ModifyMonitoredItemsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_ModifyMonitoredItemsCount = 3157;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_SetMonitoringModeCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_SetMonitoringModeCount = 3158;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_SetTriggeringCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_SetTriggeringCount = 3159;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_DeleteMonitoredItemsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_DeleteMonitoredItemsCount = 3160;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_CreateSubscriptionCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_CreateSubscriptionCount = 3161;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_ModifySubscriptionCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_ModifySubscriptionCount = 3162;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_SetPublishingModeCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_SetPublishingModeCount = 3163;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_PublishCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_PublishCount = 3164;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_RepublishCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_RepublishCount = 3165;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_TransferSubscriptionsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_TransferSubscriptionsCount = 3166;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_DeleteSubscriptionsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_DeleteSubscriptionsCount = 3167;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_AddNodesCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_AddNodesCount = 3168;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_AddReferencesCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_AddReferencesCount = 3169;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_DeleteNodesCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_DeleteNodesCount = 3170;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_DeleteReferencesCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_DeleteReferencesCount = 3171;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_BrowseCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_BrowseCount = 3172;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_BrowseNextCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_BrowseNextCount = 3173;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount = 3174;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_QueryFirstCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_QueryFirstCount = 3175;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_QueryNextCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_QueryNextCount = 3176;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_RegisterNodesCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_RegisterNodesCount = 3177;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionDiagnostics_UnregisterNodesCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionDiagnostics_UnregisterNodesCount = 3178;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionSecurityDiagnostics Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionSecurityDiagnostics = 2031;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SessionId Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SessionId = 3179;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdOfSession Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdOfSession = 3180;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdHistory Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdHistory = 3181;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionSecurityDiagnostics_AuthenticationMechanism Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionSecurityDiagnostics_AuthenticationMechanism = 3182;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionSecurityDiagnostics_Encoding Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionSecurityDiagnostics_Encoding = 3183;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionSecurityDiagnostics_TransportProtocol Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionSecurityDiagnostics_TransportProtocol = 3184;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityMode Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityMode = 3185;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityPolicyUri Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityPolicyUri = 3186;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientCertificate Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientCertificate = 3187;

        /// <summary>
        /// The identifier for the SessionDiagnosticsObjectType_SubscriptionDiagnosticsArray Variable.
        /// </summary>
        public const uint SessionDiagnosticsObjectType_SubscriptionDiagnosticsArray = 2032;

        /// <summary>
        /// The identifier for the ServerRedundancyType_RedundancySupport Variable.
        /// </summary>
        public const uint ServerRedundancyType_RedundancySupport = 2035;

        /// <summary>
        /// The identifier for the TransparentRedundancyType_CurrentServerId Variable.
        /// </summary>
        public const uint TransparentRedundancyType_CurrentServerId = 2037;

        /// <summary>
        /// The identifier for the TransparentRedundancyType_RedundantServerArray Variable.
        /// </summary>
        public const uint TransparentRedundancyType_RedundantServerArray = 2038;

        /// <summary>
        /// The identifier for the NonTransparentRedundancyType_ServerUriArray Variable.
        /// </summary>
        public const uint NonTransparentRedundancyType_ServerUriArray = 2040;

        /// <summary>
        /// The identifier for the NonTransparentNetworkRedundancyType_ServerNetworkGroups Variable.
        /// </summary>
        public const uint NonTransparentNetworkRedundancyType_ServerNetworkGroups = 11948;

        /// <summary>
        /// The identifier for the OperationLimitsType_MaxNodesPerRead Variable.
        /// </summary>
        public const uint OperationLimitsType_MaxNodesPerRead = 11565;

        /// <summary>
        /// The identifier for the OperationLimitsType_MaxNodesPerHistoryReadData Variable.
        /// </summary>
        public const uint OperationLimitsType_MaxNodesPerHistoryReadData = 12161;

        /// <summary>
        /// The identifier for the OperationLimitsType_MaxNodesPerHistoryReadEvents Variable.
        /// </summary>
        public const uint OperationLimitsType_MaxNodesPerHistoryReadEvents = 12162;

        /// <summary>
        /// The identifier for the OperationLimitsType_MaxNodesPerWrite Variable.
        /// </summary>
        public const uint OperationLimitsType_MaxNodesPerWrite = 11567;

        /// <summary>
        /// The identifier for the OperationLimitsType_MaxNodesPerHistoryUpdateData Variable.
        /// </summary>
        public const uint OperationLimitsType_MaxNodesPerHistoryUpdateData = 12163;

        /// <summary>
        /// The identifier for the OperationLimitsType_MaxNodesPerHistoryUpdateEvents Variable.
        /// </summary>
        public const uint OperationLimitsType_MaxNodesPerHistoryUpdateEvents = 12164;

        /// <summary>
        /// The identifier for the OperationLimitsType_MaxNodesPerMethodCall Variable.
        /// </summary>
        public const uint OperationLimitsType_MaxNodesPerMethodCall = 11569;

        /// <summary>
        /// The identifier for the OperationLimitsType_MaxNodesPerBrowse Variable.
        /// </summary>
        public const uint OperationLimitsType_MaxNodesPerBrowse = 11570;

        /// <summary>
        /// The identifier for the OperationLimitsType_MaxNodesPerRegisterNodes Variable.
        /// </summary>
        public const uint OperationLimitsType_MaxNodesPerRegisterNodes = 11571;

        /// <summary>
        /// The identifier for the OperationLimitsType_MaxNodesPerTranslateBrowsePathsToNodeIds Variable.
        /// </summary>
        public const uint OperationLimitsType_MaxNodesPerTranslateBrowsePathsToNodeIds = 11572;

        /// <summary>
        /// The identifier for the OperationLimitsType_MaxNodesPerNodeManagement Variable.
        /// </summary>
        public const uint OperationLimitsType_MaxNodesPerNodeManagement = 11573;

        /// <summary>
        /// The identifier for the OperationLimitsType_MaxMonitoredItemsPerCall Variable.
        /// </summary>
        public const uint OperationLimitsType_MaxMonitoredItemsPerCall = 11574;

        /// <summary>
        /// The identifier for the FileType_Size Variable.
        /// </summary>
        public const uint FileType_Size = 11576;

        /// <summary>
        /// The identifier for the FileType_Writable Variable.
        /// </summary>
        public const uint FileType_Writable = 12686;

        /// <summary>
        /// The identifier for the FileType_UserWritable Variable.
        /// </summary>
        public const uint FileType_UserWritable = 12687;

        /// <summary>
        /// The identifier for the FileType_OpenCount Variable.
        /// </summary>
        public const uint FileType_OpenCount = 11579;

        /// <summary>
        /// The identifier for the FileType_MimeType Variable.
        /// </summary>
        public const uint FileType_MimeType = 13341;

        /// <summary>
        /// The identifier for the FileType_MaxByteStringLength Variable.
        /// </summary>
        public const uint FileType_MaxByteStringLength = 24244;

        /// <summary>
        /// The identifier for the FileType_Open_InputArguments Variable.
        /// </summary>
        public const uint FileType_Open_InputArguments = 11581;

        /// <summary>
        /// The identifier for the FileType_Open_OutputArguments Variable.
        /// </summary>
        public const uint FileType_Open_OutputArguments = 11582;

        /// <summary>
        /// The identifier for the FileType_Close_InputArguments Variable.
        /// </summary>
        public const uint FileType_Close_InputArguments = 11584;

        /// <summary>
        /// The identifier for the FileType_Read_InputArguments Variable.
        /// </summary>
        public const uint FileType_Read_InputArguments = 11586;

        /// <summary>
        /// The identifier for the FileType_Read_OutputArguments Variable.
        /// </summary>
        public const uint FileType_Read_OutputArguments = 11587;

        /// <summary>
        /// The identifier for the FileType_Write_InputArguments Variable.
        /// </summary>
        public const uint FileType_Write_InputArguments = 11589;

        /// <summary>
        /// The identifier for the FileType_GetPosition_InputArguments Variable.
        /// </summary>
        public const uint FileType_GetPosition_InputArguments = 11591;

        /// <summary>
        /// The identifier for the FileType_GetPosition_OutputArguments Variable.
        /// </summary>
        public const uint FileType_GetPosition_OutputArguments = 11592;

        /// <summary>
        /// The identifier for the FileType_SetPosition_InputArguments Variable.
        /// </summary>
        public const uint FileType_SetPosition_InputArguments = 11594;

        /// <summary>
        /// The identifier for the AddressSpaceFileType_Open_InputArguments Variable.
        /// </summary>
        public const uint AddressSpaceFileType_Open_InputArguments = 11601;

        /// <summary>
        /// The identifier for the AddressSpaceFileType_Open_OutputArguments Variable.
        /// </summary>
        public const uint AddressSpaceFileType_Open_OutputArguments = 11602;

        /// <summary>
        /// The identifier for the AddressSpaceFileType_Close_InputArguments Variable.
        /// </summary>
        public const uint AddressSpaceFileType_Close_InputArguments = 11604;

        /// <summary>
        /// The identifier for the AddressSpaceFileType_Read_InputArguments Variable.
        /// </summary>
        public const uint AddressSpaceFileType_Read_InputArguments = 11606;

        /// <summary>
        /// The identifier for the AddressSpaceFileType_Read_OutputArguments Variable.
        /// </summary>
        public const uint AddressSpaceFileType_Read_OutputArguments = 11607;

        /// <summary>
        /// The identifier for the AddressSpaceFileType_Write_InputArguments Variable.
        /// </summary>
        public const uint AddressSpaceFileType_Write_InputArguments = 11609;

        /// <summary>
        /// The identifier for the AddressSpaceFileType_GetPosition_InputArguments Variable.
        /// </summary>
        public const uint AddressSpaceFileType_GetPosition_InputArguments = 11611;

        /// <summary>
        /// The identifier for the AddressSpaceFileType_GetPosition_OutputArguments Variable.
        /// </summary>
        public const uint AddressSpaceFileType_GetPosition_OutputArguments = 11612;

        /// <summary>
        /// The identifier for the AddressSpaceFileType_SetPosition_InputArguments Variable.
        /// </summary>
        public const uint AddressSpaceFileType_SetPosition_InputArguments = 11614;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceUri Variable.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceUri = 11617;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceVersion Variable.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceVersion = 11618;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespacePublicationDate Variable.
        /// </summary>
        public const uint NamespaceMetadataType_NamespacePublicationDate = 11619;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_IsNamespaceSubset Variable.
        /// </summary>
        public const uint NamespaceMetadataType_IsNamespaceSubset = 11620;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_StaticNodeIdTypes Variable.
        /// </summary>
        public const uint NamespaceMetadataType_StaticNodeIdTypes = 11621;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_StaticNumericNodeIdRange Variable.
        /// </summary>
        public const uint NamespaceMetadataType_StaticNumericNodeIdRange = 11622;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_StaticStringNodeIdPattern Variable.
        /// </summary>
        public const uint NamespaceMetadataType_StaticStringNodeIdPattern = 11623;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceFile_Size Variable.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceFile_Size = 11625;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceFile_Writable Variable.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceFile_Writable = 12690;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceFile_UserWritable Variable.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceFile_UserWritable = 12691;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceFile_OpenCount Variable.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceFile_OpenCount = 11628;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceFile_Open_InputArguments Variable.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceFile_Open_InputArguments = 11630;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceFile_Open_OutputArguments Variable.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceFile_Open_OutputArguments = 11631;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceFile_Close_InputArguments Variable.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceFile_Close_InputArguments = 11633;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceFile_Read_InputArguments Variable.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceFile_Read_InputArguments = 11635;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceFile_Read_OutputArguments Variable.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceFile_Read_OutputArguments = 11636;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceFile_Write_InputArguments Variable.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceFile_Write_InputArguments = 11638;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceFile_GetPosition_InputArguments Variable.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceFile_GetPosition_InputArguments = 11640;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceFile_GetPosition_OutputArguments Variable.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceFile_GetPosition_OutputArguments = 11641;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_NamespaceFile_SetPosition_InputArguments Variable.
        /// </summary>
        public const uint NamespaceMetadataType_NamespaceFile_SetPosition_InputArguments = 11643;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_DefaultRolePermissions Variable.
        /// </summary>
        public const uint NamespaceMetadataType_DefaultRolePermissions = 16137;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_DefaultUserRolePermissions Variable.
        /// </summary>
        public const uint NamespaceMetadataType_DefaultUserRolePermissions = 16138;

        /// <summary>
        /// The identifier for the NamespaceMetadataType_DefaultAccessRestrictions Variable.
        /// </summary>
        public const uint NamespaceMetadataType_DefaultAccessRestrictions = 16139;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespaceUri Variable.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceUri = 11647;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespaceVersion Variable.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceVersion = 11648;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespacePublicationDate Variable.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespacePublicationDate = 11649;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_IsNamespaceSubset Variable.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_IsNamespaceSubset = 11650;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_StaticNodeIdTypes Variable.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_StaticNodeIdTypes = 11651;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_StaticNumericNodeIdRange Variable.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_StaticNumericNodeIdRange = 11652;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_StaticStringNodeIdPattern Variable.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_StaticStringNodeIdPattern = 11653;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Size Variable.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Size = 11655;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Writable Variable.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Writable = 12692;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_UserWritable Variable.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_UserWritable = 12693;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_OpenCount Variable.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_OpenCount = 11658;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open_InputArguments Variable.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open_InputArguments = 11660;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open_OutputArguments Variable.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open_OutputArguments = 11661;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close_InputArguments Variable.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close_InputArguments = 11663;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read_InputArguments Variable.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read_InputArguments = 11665;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read_OutputArguments Variable.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read_OutputArguments = 11666;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write_InputArguments Variable.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write_InputArguments = 11668;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition_InputArguments Variable.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition_InputArguments = 11670;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition_OutputArguments Variable.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition_OutputArguments = 11671;

        /// <summary>
        /// The identifier for the NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition_InputArguments Variable.
        /// </summary>
        public const uint NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition_InputArguments = 11673;

        /// <summary>
        /// The identifier for the BaseEventType_EventId Variable.
        /// </summary>
        public const uint BaseEventType_EventId = 2042;

        /// <summary>
        /// The identifier for the BaseEventType_EventType Variable.
        /// </summary>
        public const uint BaseEventType_EventType = 2043;

        /// <summary>
        /// The identifier for the BaseEventType_SourceNode Variable.
        /// </summary>
        public const uint BaseEventType_SourceNode = 2044;

        /// <summary>
        /// The identifier for the BaseEventType_SourceName Variable.
        /// </summary>
        public const uint BaseEventType_SourceName = 2045;

        /// <summary>
        /// The identifier for the BaseEventType_Time Variable.
        /// </summary>
        public const uint BaseEventType_Time = 2046;

        /// <summary>
        /// The identifier for the BaseEventType_ReceiveTime Variable.
        /// </summary>
        public const uint BaseEventType_ReceiveTime = 2047;

        /// <summary>
        /// The identifier for the BaseEventType_LocalTime Variable.
        /// </summary>
        public const uint BaseEventType_LocalTime = 3190;

        /// <summary>
        /// The identifier for the BaseEventType_Message Variable.
        /// </summary>
        public const uint BaseEventType_Message = 2050;

        /// <summary>
        /// The identifier for the BaseEventType_Severity Variable.
        /// </summary>
        public const uint BaseEventType_Severity = 2051;

        /// <summary>
        /// The identifier for the AuditEventType_ActionTimeStamp Variable.
        /// </summary>
        public const uint AuditEventType_ActionTimeStamp = 2053;

        /// <summary>
        /// The identifier for the AuditEventType_Status Variable.
        /// </summary>
        public const uint AuditEventType_Status = 2054;

        /// <summary>
        /// The identifier for the AuditEventType_ServerId Variable.
        /// </summary>
        public const uint AuditEventType_ServerId = 2055;

        /// <summary>
        /// The identifier for the AuditEventType_ClientAuditEntryId Variable.
        /// </summary>
        public const uint AuditEventType_ClientAuditEntryId = 2056;

        /// <summary>
        /// The identifier for the AuditEventType_ClientUserId Variable.
        /// </summary>
        public const uint AuditEventType_ClientUserId = 2057;

        /// <summary>
        /// The identifier for the AuditSecurityEventType_StatusCodeId Variable.
        /// </summary>
        public const uint AuditSecurityEventType_StatusCodeId = 17615;

        /// <summary>
        /// The identifier for the AuditChannelEventType_SecureChannelId Variable.
        /// </summary>
        public const uint AuditChannelEventType_SecureChannelId = 2745;

        /// <summary>
        /// The identifier for the AuditOpenSecureChannelEventType_ClientCertificate Variable.
        /// </summary>
        public const uint AuditOpenSecureChannelEventType_ClientCertificate = 2061;

        /// <summary>
        /// The identifier for the AuditOpenSecureChannelEventType_ClientCertificateThumbprint Variable.
        /// </summary>
        public const uint AuditOpenSecureChannelEventType_ClientCertificateThumbprint = 2746;

        /// <summary>
        /// The identifier for the AuditOpenSecureChannelEventType_RequestType Variable.
        /// </summary>
        public const uint AuditOpenSecureChannelEventType_RequestType = 2062;

        /// <summary>
        /// The identifier for the AuditOpenSecureChannelEventType_SecurityPolicyUri Variable.
        /// </summary>
        public const uint AuditOpenSecureChannelEventType_SecurityPolicyUri = 2063;

        /// <summary>
        /// The identifier for the AuditOpenSecureChannelEventType_SecurityMode Variable.
        /// </summary>
        public const uint AuditOpenSecureChannelEventType_SecurityMode = 2065;

        /// <summary>
        /// The identifier for the AuditOpenSecureChannelEventType_RequestedLifetime Variable.
        /// </summary>
        public const uint AuditOpenSecureChannelEventType_RequestedLifetime = 2066;

        /// <summary>
        /// The identifier for the AuditSessionEventType_SessionId Variable.
        /// </summary>
        public const uint AuditSessionEventType_SessionId = 2070;

        /// <summary>
        /// The identifier for the AuditCreateSessionEventType_SecureChannelId Variable.
        /// </summary>
        public const uint AuditCreateSessionEventType_SecureChannelId = 2072;

        /// <summary>
        /// The identifier for the AuditCreateSessionEventType_ClientCertificate Variable.
        /// </summary>
        public const uint AuditCreateSessionEventType_ClientCertificate = 2073;

        /// <summary>
        /// The identifier for the AuditCreateSessionEventType_ClientCertificateThumbprint Variable.
        /// </summary>
        public const uint AuditCreateSessionEventType_ClientCertificateThumbprint = 2747;

        /// <summary>
        /// The identifier for the AuditCreateSessionEventType_RevisedSessionTimeout Variable.
        /// </summary>
        public const uint AuditCreateSessionEventType_RevisedSessionTimeout = 2074;

        /// <summary>
        /// The identifier for the AuditUrlMismatchEventType_EndpointUrl Variable.
        /// </summary>
        public const uint AuditUrlMismatchEventType_EndpointUrl = 2749;

        /// <summary>
        /// The identifier for the AuditActivateSessionEventType_ClientSoftwareCertificates Variable.
        /// </summary>
        public const uint AuditActivateSessionEventType_ClientSoftwareCertificates = 2076;

        /// <summary>
        /// The identifier for the AuditActivateSessionEventType_UserIdentityToken Variable.
        /// </summary>
        public const uint AuditActivateSessionEventType_UserIdentityToken = 2077;

        /// <summary>
        /// The identifier for the AuditActivateSessionEventType_SecureChannelId Variable.
        /// </summary>
        public const uint AuditActivateSessionEventType_SecureChannelId = 11485;

        /// <summary>
        /// The identifier for the AuditCancelEventType_RequestHandle Variable.
        /// </summary>
        public const uint AuditCancelEventType_RequestHandle = 2079;

        /// <summary>
        /// The identifier for the AuditCertificateEventType_Certificate Variable.
        /// </summary>
        public const uint AuditCertificateEventType_Certificate = 2081;

        /// <summary>
        /// The identifier for the AuditCertificateDataMismatchEventType_InvalidHostname Variable.
        /// </summary>
        public const uint AuditCertificateDataMismatchEventType_InvalidHostname = 2083;

        /// <summary>
        /// The identifier for the AuditCertificateDataMismatchEventType_InvalidUri Variable.
        /// </summary>
        public const uint AuditCertificateDataMismatchEventType_InvalidUri = 2084;

        /// <summary>
        /// The identifier for the AuditAddNodesEventType_NodesToAdd Variable.
        /// </summary>
        public const uint AuditAddNodesEventType_NodesToAdd = 2092;

        /// <summary>
        /// The identifier for the AuditDeleteNodesEventType_NodesToDelete Variable.
        /// </summary>
        public const uint AuditDeleteNodesEventType_NodesToDelete = 2094;

        /// <summary>
        /// The identifier for the AuditAddReferencesEventType_ReferencesToAdd Variable.
        /// </summary>
        public const uint AuditAddReferencesEventType_ReferencesToAdd = 2096;

        /// <summary>
        /// The identifier for the AuditDeleteReferencesEventType_ReferencesToDelete Variable.
        /// </summary>
        public const uint AuditDeleteReferencesEventType_ReferencesToDelete = 2098;

        /// <summary>
        /// The identifier for the AuditWriteUpdateEventType_AttributeId Variable.
        /// </summary>
        public const uint AuditWriteUpdateEventType_AttributeId = 2750;

        /// <summary>
        /// The identifier for the AuditWriteUpdateEventType_IndexRange Variable.
        /// </summary>
        public const uint AuditWriteUpdateEventType_IndexRange = 2101;

        /// <summary>
        /// The identifier for the AuditWriteUpdateEventType_OldValue Variable.
        /// </summary>
        public const uint AuditWriteUpdateEventType_OldValue = 2102;

        /// <summary>
        /// The identifier for the AuditWriteUpdateEventType_NewValue Variable.
        /// </summary>
        public const uint AuditWriteUpdateEventType_NewValue = 2103;

        /// <summary>
        /// The identifier for the AuditHistoryUpdateEventType_ParameterDataTypeId Variable.
        /// </summary>
        public const uint AuditHistoryUpdateEventType_ParameterDataTypeId = 2751;

        /// <summary>
        /// The identifier for the AuditUpdateMethodEventType_MethodId Variable.
        /// </summary>
        public const uint AuditUpdateMethodEventType_MethodId = 2128;

        /// <summary>
        /// The identifier for the AuditUpdateMethodEventType_InputArguments Variable.
        /// </summary>
        public const uint AuditUpdateMethodEventType_InputArguments = 2129;

        /// <summary>
        /// The identifier for the SystemStatusChangeEventType_SystemState Variable.
        /// </summary>
        public const uint SystemStatusChangeEventType_SystemState = 11696;

        /// <summary>
        /// The identifier for the GeneralModelChangeEventType_Changes Variable.
        /// </summary>
        public const uint GeneralModelChangeEventType_Changes = 2134;

        /// <summary>
        /// The identifier for the SemanticChangeEventType_Changes Variable.
        /// </summary>
        public const uint SemanticChangeEventType_Changes = 2739;

        /// <summary>
        /// The identifier for the ProgressEventType_Context Variable.
        /// </summary>
        public const uint ProgressEventType_Context = 12502;

        /// <summary>
        /// The identifier for the ProgressEventType_Progress Variable.
        /// </summary>
        public const uint ProgressEventType_Progress = 12503;

        /// <summary>
        /// The identifier for the ServerStatusType_StartTime Variable.
        /// </summary>
        public const uint ServerStatusType_StartTime = 2139;

        /// <summary>
        /// The identifier for the ServerStatusType_CurrentTime Variable.
        /// </summary>
        public const uint ServerStatusType_CurrentTime = 2140;

        /// <summary>
        /// The identifier for the ServerStatusType_State Variable.
        /// </summary>
        public const uint ServerStatusType_State = 2141;

        /// <summary>
        /// The identifier for the ServerStatusType_BuildInfo Variable.
        /// </summary>
        public const uint ServerStatusType_BuildInfo = 2142;

        /// <summary>
        /// The identifier for the ServerStatusType_BuildInfo_ProductUri Variable.
        /// </summary>
        public const uint ServerStatusType_BuildInfo_ProductUri = 3698;

        /// <summary>
        /// The identifier for the ServerStatusType_BuildInfo_ManufacturerName Variable.
        /// </summary>
        public const uint ServerStatusType_BuildInfo_ManufacturerName = 3699;

        /// <summary>
        /// The identifier for the ServerStatusType_BuildInfo_ProductName Variable.
        /// </summary>
        public const uint ServerStatusType_BuildInfo_ProductName = 3700;

        /// <summary>
        /// The identifier for the ServerStatusType_BuildInfo_SoftwareVersion Variable.
        /// </summary>
        public const uint ServerStatusType_BuildInfo_SoftwareVersion = 3701;

        /// <summary>
        /// The identifier for the ServerStatusType_BuildInfo_BuildNumber Variable.
        /// </summary>
        public const uint ServerStatusType_BuildInfo_BuildNumber = 3702;

        /// <summary>
        /// The identifier for the ServerStatusType_BuildInfo_BuildDate Variable.
        /// </summary>
        public const uint ServerStatusType_BuildInfo_BuildDate = 3703;

        /// <summary>
        /// The identifier for the ServerStatusType_SecondsTillShutdown Variable.
        /// </summary>
        public const uint ServerStatusType_SecondsTillShutdown = 2752;

        /// <summary>
        /// The identifier for the ServerStatusType_ShutdownReason Variable.
        /// </summary>
        public const uint ServerStatusType_ShutdownReason = 2753;

        /// <summary>
        /// The identifier for the BuildInfoType_ProductUri Variable.
        /// </summary>
        public const uint BuildInfoType_ProductUri = 3052;

        /// <summary>
        /// The identifier for the BuildInfoType_ManufacturerName Variable.
        /// </summary>
        public const uint BuildInfoType_ManufacturerName = 3053;

        /// <summary>
        /// The identifier for the BuildInfoType_ProductName Variable.
        /// </summary>
        public const uint BuildInfoType_ProductName = 3054;

        /// <summary>
        /// The identifier for the BuildInfoType_SoftwareVersion Variable.
        /// </summary>
        public const uint BuildInfoType_SoftwareVersion = 3055;

        /// <summary>
        /// The identifier for the BuildInfoType_BuildNumber Variable.
        /// </summary>
        public const uint BuildInfoType_BuildNumber = 3056;

        /// <summary>
        /// The identifier for the BuildInfoType_BuildDate Variable.
        /// </summary>
        public const uint BuildInfoType_BuildDate = 3057;

        /// <summary>
        /// The identifier for the ServerDiagnosticsSummaryType_ServerViewCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsSummaryType_ServerViewCount = 2151;

        /// <summary>
        /// The identifier for the ServerDiagnosticsSummaryType_CurrentSessionCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsSummaryType_CurrentSessionCount = 2152;

        /// <summary>
        /// The identifier for the ServerDiagnosticsSummaryType_CumulatedSessionCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsSummaryType_CumulatedSessionCount = 2153;

        /// <summary>
        /// The identifier for the ServerDiagnosticsSummaryType_SecurityRejectedSessionCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsSummaryType_SecurityRejectedSessionCount = 2154;

        /// <summary>
        /// The identifier for the ServerDiagnosticsSummaryType_RejectedSessionCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsSummaryType_RejectedSessionCount = 2155;

        /// <summary>
        /// The identifier for the ServerDiagnosticsSummaryType_SessionTimeoutCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsSummaryType_SessionTimeoutCount = 2156;

        /// <summary>
        /// The identifier for the ServerDiagnosticsSummaryType_SessionAbortCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsSummaryType_SessionAbortCount = 2157;

        /// <summary>
        /// The identifier for the ServerDiagnosticsSummaryType_PublishingIntervalCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsSummaryType_PublishingIntervalCount = 2159;

        /// <summary>
        /// The identifier for the ServerDiagnosticsSummaryType_CurrentSubscriptionCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsSummaryType_CurrentSubscriptionCount = 2160;

        /// <summary>
        /// The identifier for the ServerDiagnosticsSummaryType_CumulatedSubscriptionCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsSummaryType_CumulatedSubscriptionCount = 2161;

        /// <summary>
        /// The identifier for the ServerDiagnosticsSummaryType_SecurityRejectedRequestsCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsSummaryType_SecurityRejectedRequestsCount = 2162;

        /// <summary>
        /// The identifier for the ServerDiagnosticsSummaryType_RejectedRequestsCount Variable.
        /// </summary>
        public const uint ServerDiagnosticsSummaryType_RejectedRequestsCount = 2163;

        /// <summary>
        /// The identifier for the SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics Variable.
        /// </summary>
        public const uint SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics = 12779;

        /// <summary>
        /// The identifier for the SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SamplingInterval Variable.
        /// </summary>
        public const uint SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SamplingInterval = 12780;

        /// <summary>
        /// The identifier for the SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SampledMonitoredItemsCount Variable.
        /// </summary>
        public const uint SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SampledMonitoredItemsCount = 12781;

        /// <summary>
        /// The identifier for the SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_MaxSampledMonitoredItemsCount Variable.
        /// </summary>
        public const uint SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_MaxSampledMonitoredItemsCount = 12782;

        /// <summary>
        /// The identifier for the SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_DisabledMonitoredItemsSamplingCount Variable.
        /// </summary>
        public const uint SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_DisabledMonitoredItemsSamplingCount = 12783;

        /// <summary>
        /// The identifier for the SamplingIntervalDiagnosticsType_SamplingInterval Variable.
        /// </summary>
        public const uint SamplingIntervalDiagnosticsType_SamplingInterval = 2166;

        /// <summary>
        /// The identifier for the SamplingIntervalDiagnosticsType_SampledMonitoredItemsCount Variable.
        /// </summary>
        public const uint SamplingIntervalDiagnosticsType_SampledMonitoredItemsCount = 11697;

        /// <summary>
        /// The identifier for the SamplingIntervalDiagnosticsType_MaxSampledMonitoredItemsCount Variable.
        /// </summary>
        public const uint SamplingIntervalDiagnosticsType_MaxSampledMonitoredItemsCount = 11698;

        /// <summary>
        /// The identifier for the SamplingIntervalDiagnosticsType_DisabledMonitoredItemsSamplingCount Variable.
        /// </summary>
        public const uint SamplingIntervalDiagnosticsType_DisabledMonitoredItemsSamplingCount = 11699;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics = 12784;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SessionId Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SessionId = 12785;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SubscriptionId Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SubscriptionId = 12786;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_Priority Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_Priority = 12787;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingInterval Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingInterval = 12788;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxKeepAliveCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxKeepAliveCount = 12789;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxLifetimeCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxLifetimeCount = 12790;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxNotificationsPerPublish Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxNotificationsPerPublish = 12791;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingEnabled Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingEnabled = 12792;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_ModifyCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_ModifyCount = 12793;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EnableCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EnableCount = 12794;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisableCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisableCount = 12795;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishRequestCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishRequestCount = 12796;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageRequestCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageRequestCount = 12797;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageCount = 12798;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferRequestCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferRequestCount = 12799;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToAltClientCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToAltClientCount = 12800;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToSameClientCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToSameClientCount = 12801;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishRequestCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishRequestCount = 12802;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DataChangeNotificationsCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DataChangeNotificationsCount = 12803;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventNotificationsCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventNotificationsCount = 12804;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NotificationsCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NotificationsCount = 12805;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_LatePublishRequestCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_LatePublishRequestCount = 12806;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentKeepAliveCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentKeepAliveCount = 12807;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentLifetimeCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentLifetimeCount = 12808;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_UnacknowledgedMessageCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_UnacknowledgedMessageCount = 12809;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DiscardedMessageCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DiscardedMessageCount = 12810;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoredItemCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoredItemCount = 12811;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisabledMonitoredItemCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisabledMonitoredItemCount = 12812;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoringQueueOverflowCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoringQueueOverflowCount = 12813;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NextSequenceNumber Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NextSequenceNumber = 12814;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventQueueOverflowCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventQueueOverflowCount = 12815;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_SessionId Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_SessionId = 2173;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_SubscriptionId Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_SubscriptionId = 2174;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_Priority Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_Priority = 2175;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_PublishingInterval Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_PublishingInterval = 2176;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_MaxKeepAliveCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_MaxKeepAliveCount = 2177;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_MaxLifetimeCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_MaxLifetimeCount = 8888;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_MaxNotificationsPerPublish Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_MaxNotificationsPerPublish = 2179;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_PublishingEnabled Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_PublishingEnabled = 2180;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_ModifyCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_ModifyCount = 2181;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_EnableCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_EnableCount = 2182;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_DisableCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_DisableCount = 2183;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_RepublishRequestCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_RepublishRequestCount = 2184;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_RepublishMessageRequestCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_RepublishMessageRequestCount = 2185;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_RepublishMessageCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_RepublishMessageCount = 2186;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_TransferRequestCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_TransferRequestCount = 2187;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_TransferredToAltClientCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_TransferredToAltClientCount = 2188;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_TransferredToSameClientCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_TransferredToSameClientCount = 2189;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_PublishRequestCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_PublishRequestCount = 2190;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_DataChangeNotificationsCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_DataChangeNotificationsCount = 2191;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_EventNotificationsCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_EventNotificationsCount = 2998;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_NotificationsCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_NotificationsCount = 2193;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_LatePublishRequestCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_LatePublishRequestCount = 8889;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_CurrentKeepAliveCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_CurrentKeepAliveCount = 8890;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_CurrentLifetimeCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_CurrentLifetimeCount = 8891;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_UnacknowledgedMessageCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_UnacknowledgedMessageCount = 8892;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_DiscardedMessageCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_DiscardedMessageCount = 8893;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_MonitoredItemCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_MonitoredItemCount = 8894;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_DisabledMonitoredItemCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_DisabledMonitoredItemCount = 8895;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_MonitoringQueueOverflowCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_MonitoringQueueOverflowCount = 8896;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_NextSequenceNumber Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_NextSequenceNumber = 8897;

        /// <summary>
        /// The identifier for the SubscriptionDiagnosticsType_EventQueueOverflowCount Variable.
        /// </summary>
        public const uint SubscriptionDiagnosticsType_EventQueueOverflowCount = 8902;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics = 12816;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_SessionId Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_SessionId = 12817;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_SessionName Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_SessionName = 12818;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_ClientDescription Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_ClientDescription = 12819;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_ServerUri Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_ServerUri = 12820;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_EndpointUrl Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_EndpointUrl = 12821;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_LocaleIds Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_LocaleIds = 12822;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_ActualSessionTimeout Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_ActualSessionTimeout = 12823;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_MaxResponseMessageSize Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_MaxResponseMessageSize = 12824;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_ClientConnectionTime Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_ClientConnectionTime = 12825;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_ClientLastContactTime Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_ClientLastContactTime = 12826;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_CurrentSubscriptionsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_CurrentSubscriptionsCount = 12827;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_CurrentMonitoredItemsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_CurrentMonitoredItemsCount = 12828;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_CurrentPublishRequestsInQueue Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_CurrentPublishRequestsInQueue = 12829;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_TotalRequestCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_TotalRequestCount = 12830;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_UnauthorizedRequestCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_UnauthorizedRequestCount = 12831;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_ReadCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_ReadCount = 12832;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_HistoryReadCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_HistoryReadCount = 12833;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_WriteCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_WriteCount = 12834;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_HistoryUpdateCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_HistoryUpdateCount = 12835;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_CallCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_CallCount = 12836;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_CreateMonitoredItemsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_CreateMonitoredItemsCount = 12837;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_ModifyMonitoredItemsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_ModifyMonitoredItemsCount = 12838;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_SetMonitoringModeCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_SetMonitoringModeCount = 12839;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_SetTriggeringCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_SetTriggeringCount = 12840;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_DeleteMonitoredItemsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_DeleteMonitoredItemsCount = 12841;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_CreateSubscriptionCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_CreateSubscriptionCount = 12842;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_ModifySubscriptionCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_ModifySubscriptionCount = 12843;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_SetPublishingModeCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_SetPublishingModeCount = 12844;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_PublishCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_PublishCount = 12845;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_RepublishCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_RepublishCount = 12846;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_TransferSubscriptionsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_TransferSubscriptionsCount = 12847;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_DeleteSubscriptionsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_DeleteSubscriptionsCount = 12848;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_AddNodesCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_AddNodesCount = 12849;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_AddReferencesCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_AddReferencesCount = 12850;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_DeleteNodesCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_DeleteNodesCount = 12851;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_DeleteReferencesCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_DeleteReferencesCount = 12852;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_BrowseCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_BrowseCount = 12853;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_BrowseNextCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_BrowseNextCount = 12854;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount = 12855;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_QueryFirstCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_QueryFirstCount = 12856;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_QueryNextCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_QueryNextCount = 12857;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_RegisterNodesCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_RegisterNodesCount = 12858;

        /// <summary>
        /// The identifier for the SessionDiagnosticsArrayType_SessionDiagnostics_UnregisterNodesCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsArrayType_SessionDiagnostics_UnregisterNodesCount = 12859;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_SessionId Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_SessionId = 2198;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_SessionName Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_SessionName = 2199;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_ClientDescription Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_ClientDescription = 2200;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_ServerUri Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_ServerUri = 2201;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_EndpointUrl Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_EndpointUrl = 2202;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_LocaleIds Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_LocaleIds = 2203;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_ActualSessionTimeout Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_ActualSessionTimeout = 2204;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_MaxResponseMessageSize Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_MaxResponseMessageSize = 3050;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_ClientConnectionTime Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_ClientConnectionTime = 2205;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_ClientLastContactTime Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_ClientLastContactTime = 2206;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_CurrentSubscriptionsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_CurrentSubscriptionsCount = 2207;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_CurrentMonitoredItemsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_CurrentMonitoredItemsCount = 2208;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_CurrentPublishRequestsInQueue Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_CurrentPublishRequestsInQueue = 2209;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_TotalRequestCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_TotalRequestCount = 8900;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_UnauthorizedRequestCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_UnauthorizedRequestCount = 11892;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_ReadCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_ReadCount = 2217;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_HistoryReadCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_HistoryReadCount = 2218;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_WriteCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_WriteCount = 2219;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_HistoryUpdateCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_HistoryUpdateCount = 2220;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_CallCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_CallCount = 2221;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_CreateMonitoredItemsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_CreateMonitoredItemsCount = 2222;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_ModifyMonitoredItemsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_ModifyMonitoredItemsCount = 2223;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_SetMonitoringModeCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_SetMonitoringModeCount = 2224;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_SetTriggeringCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_SetTriggeringCount = 2225;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_DeleteMonitoredItemsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_DeleteMonitoredItemsCount = 2226;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_CreateSubscriptionCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_CreateSubscriptionCount = 2227;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_ModifySubscriptionCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_ModifySubscriptionCount = 2228;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_SetPublishingModeCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_SetPublishingModeCount = 2229;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_PublishCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_PublishCount = 2230;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_RepublishCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_RepublishCount = 2231;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_TransferSubscriptionsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_TransferSubscriptionsCount = 2232;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_DeleteSubscriptionsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_DeleteSubscriptionsCount = 2233;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_AddNodesCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_AddNodesCount = 2234;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_AddReferencesCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_AddReferencesCount = 2235;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_DeleteNodesCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_DeleteNodesCount = 2236;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_DeleteReferencesCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_DeleteReferencesCount = 2237;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_BrowseCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_BrowseCount = 2238;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_BrowseNextCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_BrowseNextCount = 2239;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_TranslateBrowsePathsToNodeIdsCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_TranslateBrowsePathsToNodeIdsCount = 2240;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_QueryFirstCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_QueryFirstCount = 2241;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_QueryNextCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_QueryNextCount = 2242;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_RegisterNodesCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_RegisterNodesCount = 2730;

        /// <summary>
        /// The identifier for the SessionDiagnosticsVariableType_UnregisterNodesCount Variable.
        /// </summary>
        public const uint SessionDiagnosticsVariableType_UnregisterNodesCount = 2731;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics Variable.
        /// </summary>
        public const uint SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics = 12860;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SessionId Variable.
        /// </summary>
        public const uint SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SessionId = 12861;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdOfSession Variable.
        /// </summary>
        public const uint SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdOfSession = 12862;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdHistory Variable.
        /// </summary>
        public const uint SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdHistory = 12863;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_AuthenticationMechanism Variable.
        /// </summary>
        public const uint SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_AuthenticationMechanism = 12864;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_Encoding Variable.
        /// </summary>
        public const uint SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_Encoding = 12865;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_TransportProtocol Variable.
        /// </summary>
        public const uint SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_TransportProtocol = 12866;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityMode Variable.
        /// </summary>
        public const uint SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityMode = 12867;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityPolicyUri Variable.
        /// </summary>
        public const uint SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityPolicyUri = 12868;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientCertificate Variable.
        /// </summary>
        public const uint SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientCertificate = 12869;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsType_SessionId Variable.
        /// </summary>
        public const uint SessionSecurityDiagnosticsType_SessionId = 2245;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsType_ClientUserIdOfSession Variable.
        /// </summary>
        public const uint SessionSecurityDiagnosticsType_ClientUserIdOfSession = 2246;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsType_ClientUserIdHistory Variable.
        /// </summary>
        public const uint SessionSecurityDiagnosticsType_ClientUserIdHistory = 2247;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsType_AuthenticationMechanism Variable.
        /// </summary>
        public const uint SessionSecurityDiagnosticsType_AuthenticationMechanism = 2248;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsType_Encoding Variable.
        /// </summary>
        public const uint SessionSecurityDiagnosticsType_Encoding = 2249;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsType_TransportProtocol Variable.
        /// </summary>
        public const uint SessionSecurityDiagnosticsType_TransportProtocol = 2250;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsType_SecurityMode Variable.
        /// </summary>
        public const uint SessionSecurityDiagnosticsType_SecurityMode = 2251;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsType_SecurityPolicyUri Variable.
        /// </summary>
        public const uint SessionSecurityDiagnosticsType_SecurityPolicyUri = 2252;

        /// <summary>
        /// The identifier for the SessionSecurityDiagnosticsType_ClientCertificate Variable.
        /// </summary>
        public const uint SessionSecurityDiagnosticsType_ClientCertificate = 3058;

        /// <summary>
        /// The identifier for the OptionSetType_OptionSetValues Variable.
        /// </summary>
        public const uint OptionSetType_OptionSetValues = 11488;

        /// <summary>
        /// The identifier for the OptionSetType_BitMask Variable.
        /// </summary>
        public const uint OptionSetType_BitMask = 11701;

        /// <summary>
        /// The identifier for the SelectionListType_Selections Variable.
        /// </summary>
        public const uint SelectionListType_Selections = 17632;

        /// <summary>
        /// The identifier for the SelectionListType_SelectionDescriptions Variable.
        /// </summary>
        public const uint SelectionListType_SelectionDescriptions = 17633;

        /// <summary>
        /// The identifier for the SelectionListType_RestrictToList Variable.
        /// </summary>
        public const uint SelectionListType_RestrictToList = 16312;

        /// <summary>
        /// The identifier for the AudioVariableType_ListId Variable.
        /// </summary>
        public const uint AudioVariableType_ListId = 17988;

        /// <summary>
        /// The identifier for the AudioVariableType_AgencyId Variable.
        /// </summary>
        public const uint AudioVariableType_AgencyId = 17989;

        /// <summary>
        /// The identifier for the AudioVariableType_VersionId Variable.
        /// </summary>
        public const uint AudioVariableType_VersionId = 17990;

        /// <summary>
        /// The identifier for the Server_ServerArray Variable.
        /// </summary>
        public const uint Server_ServerArray = 2254;

        /// <summary>
        /// The identifier for the Server_NamespaceArray Variable.
        /// </summary>
        public const uint Server_NamespaceArray = 2255;

        /// <summary>
        /// The identifier for the Server_ServerStatus Variable.
        /// </summary>
        public const uint Server_ServerStatus = 2256;

        /// <summary>
        /// The identifier for the Server_ServerStatus_StartTime Variable.
        /// </summary>
        public const uint Server_ServerStatus_StartTime = 2257;

        /// <summary>
        /// The identifier for the Server_ServerStatus_CurrentTime Variable.
        /// </summary>
        public const uint Server_ServerStatus_CurrentTime = 2258;

        /// <summary>
        /// The identifier for the Server_ServerStatus_State Variable.
        /// </summary>
        public const uint Server_ServerStatus_State = 2259;

        /// <summary>
        /// The identifier for the Server_ServerStatus_BuildInfo Variable.
        /// </summary>
        public const uint Server_ServerStatus_BuildInfo = 2260;

        /// <summary>
        /// The identifier for the Server_ServerStatus_BuildInfo_ProductUri Variable.
        /// </summary>
        public const uint Server_ServerStatus_BuildInfo_ProductUri = 2262;

        /// <summary>
        /// The identifier for the Server_ServerStatus_BuildInfo_ManufacturerName Variable.
        /// </summary>
        public const uint Server_ServerStatus_BuildInfo_ManufacturerName = 2263;

        /// <summary>
        /// The identifier for the Server_ServerStatus_BuildInfo_ProductName Variable.
        /// </summary>
        public const uint Server_ServerStatus_BuildInfo_ProductName = 2261;

        /// <summary>
        /// The identifier for the Server_ServerStatus_BuildInfo_SoftwareVersion Variable.
        /// </summary>
        public const uint Server_ServerStatus_BuildInfo_SoftwareVersion = 2264;

        /// <summary>
        /// The identifier for the Server_ServerStatus_BuildInfo_BuildNumber Variable.
        /// </summary>
        public const uint Server_ServerStatus_BuildInfo_BuildNumber = 2265;

        /// <summary>
        /// The identifier for the Server_ServerStatus_BuildInfo_BuildDate Variable.
        /// </summary>
        public const uint Server_ServerStatus_BuildInfo_BuildDate = 2266;

        /// <summary>
        /// The identifier for the Server_ServerStatus_SecondsTillShutdown Variable.
        /// </summary>
        public const uint Server_ServerStatus_SecondsTillShutdown = 2992;

        /// <summary>
        /// The identifier for the Server_ServerStatus_ShutdownReason Variable.
        /// </summary>
        public const uint Server_ServerStatus_ShutdownReason = 2993;

        /// <summary>
        /// The identifier for the Server_ServiceLevel Variable.
        /// </summary>
        public const uint Server_ServiceLevel = 2267;

        /// <summary>
        /// The identifier for the Server_Auditing Variable.
        /// </summary>
        public const uint Server_Auditing = 2994;

        /// <summary>
        /// The identifier for the Server_EstimatedReturnTime Variable.
        /// </summary>
        public const uint Server_EstimatedReturnTime = 12885;

        /// <summary>
        /// The identifier for the Server_LocalTime Variable.
        /// </summary>
        public const uint Server_LocalTime = 17634;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_ServerProfileArray Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_ServerProfileArray = 2269;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_LocaleIdArray Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_LocaleIdArray = 2271;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_MinSupportedSampleRate Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_MinSupportedSampleRate = 2272;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_MaxBrowseContinuationPoints Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_MaxBrowseContinuationPoints = 2735;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_MaxQueryContinuationPoints Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_MaxQueryContinuationPoints = 2736;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_MaxHistoryContinuationPoints Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_MaxHistoryContinuationPoints = 2737;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_SoftwareCertificates Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_SoftwareCertificates = 3704;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_MaxArrayLength Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_MaxArrayLength = 11702;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_MaxStringLength Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_MaxStringLength = 11703;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_MaxByteStringLength Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_MaxByteStringLength = 12911;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_OperationLimits_MaxNodesPerRead Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerRead = 11705;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData = 12165;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents = 12166;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_OperationLimits_MaxNodesPerWrite Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerWrite = 11707;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData = 12167;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents = 12168;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall = 11709;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_OperationLimits_MaxNodesPerBrowse Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerBrowse = 11710;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes = 11711;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds = 11712;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement = 11713;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall = 11714;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_RoleSet_AddRole_InputArguments Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_RoleSet_AddRole_InputArguments = 16302;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_RoleSet_AddRole_OutputArguments Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_RoleSet_AddRole_OutputArguments = 16303;

        /// <summary>
        /// The identifier for the Server_ServerCapabilities_RoleSet_RemoveRole_InputArguments Variable.
        /// </summary>
        public const uint Server_ServerCapabilities_RoleSet_RemoveRole_InputArguments = 16305;

        /// <summary>
        /// The identifier for the Server_ServerDiagnostics_ServerDiagnosticsSummary Variable.
        /// </summary>
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary = 2275;

        /// <summary>
        /// The identifier for the Server_ServerDiagnostics_ServerDiagnosticsSummary_ServerViewCount Variable.
        /// </summary>
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_ServerViewCount = 2276;

        /// <summary>
        /// The identifier for the Server_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSessionCount Variable.
        /// </summary>
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSessionCount = 2277;

        /// <summary>
        /// The identifier for the Server_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSessionCount Variable.
        /// </summary>
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSessionCount = 2278;

        /// <summary>
        /// The identifier for the Server_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedSessionCount Variable.
        /// </summary>
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedSessionCount = 2279;

        /// <summary>
        /// The identifier for the Server_ServerDiagnostics_ServerDiagnosticsSummary_RejectedSessionCount Variable.
        /// </summary>
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_RejectedSessionCount = 3705;

        /// <summary>
        /// The identifier for the Server_ServerDiagnostics_ServerDiagnosticsSummary_SessionTimeoutCount Variable.
        /// </summary>
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_SessionTimeoutCount = 2281;

        /// <summary>
        /// The identifier for the Server_ServerDiagnostics_ServerDiagnosticsSummary_SessionAbortCount Variable.
        /// </summary>
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_SessionAbortCount = 2282;

        /// <summary>
        /// The identifier for the Server_ServerDiagnostics_ServerDiagnosticsSummary_PublishingIntervalCount Variable.
        /// </summary>
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_PublishingIntervalCount = 2284;

        /// <summary>
        /// The identifier for the Server_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSubscriptionCount Variable.
        /// </summary>
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSubscriptionCount = 2285;

        /// <summary>
        /// The identifier for the Server_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSubscriptionCount Variable.
        /// </summary>
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSubscriptionCount = 2286;

        /// <summary>
        /// The identifier for the Server_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedRequestsCount Variable.
        /// </summary>
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedRequestsCount = 2287;

        /// <summary>
        /// The identifier for the Server_ServerDiagnostics_ServerDiagnosticsSummary_RejectedRequestsCount Variable.
        /// </summary>
        public const uint Server_ServerDiagnostics_ServerDiagnosticsSummary_RejectedRequestsCount = 2288;

        /// <summary>
        /// The identifier for the Server_ServerDiagnostics_SamplingIntervalDiagnosticsArray Variable.
        /// </summary>
        public const uint Server_ServerDiagnostics_SamplingIntervalDiagnosticsArray = 2289;

        /// <summary>
        /// The identifier for the Server_ServerDiagnostics_SubscriptionDiagnosticsArray Variable.
        /// </summary>
        public const uint Server_ServerDiagnostics_SubscriptionDiagnosticsArray = 2290;

        /// <summary>
        /// The identifier for the Server_ServerDiagnostics_SessionsDiagnosticsSummary_SessionDiagnosticsArray Variable.
        /// </summary>
        public const uint Server_ServerDiagnostics_SessionsDiagnosticsSummary_SessionDiagnosticsArray = 3707;

        /// <summary>
        /// The identifier for the Server_ServerDiagnostics_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray Variable.
        /// </summary>
        public const uint Server_ServerDiagnostics_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray = 3708;

        /// <summary>
        /// The identifier for the Server_ServerDiagnostics_EnabledFlag Variable.
        /// </summary>
        public const uint Server_ServerDiagnostics_EnabledFlag = 2294;

        /// <summary>
        /// The identifier for the Server_ServerRedundancy_RedundancySupport Variable.
        /// </summary>
        public const uint Server_ServerRedundancy_RedundancySupport = 3709;

        /// <summary>
        /// The identifier for the Server_GetMonitoredItems_InputArguments Variable.
        /// </summary>
        public const uint Server_GetMonitoredItems_InputArguments = 11493;

        /// <summary>
        /// The identifier for the Server_GetMonitoredItems_OutputArguments Variable.
        /// </summary>
        public const uint Server_GetMonitoredItems_OutputArguments = 11494;

        /// <summary>
        /// The identifier for the Server_ResendData_InputArguments Variable.
        /// </summary>
        public const uint Server_ResendData_InputArguments = 12874;

        /// <summary>
        /// The identifier for the Server_SetSubscriptionDurable_InputArguments Variable.
        /// </summary>
        public const uint Server_SetSubscriptionDurable_InputArguments = 12750;

        /// <summary>
        /// The identifier for the Server_SetSubscriptionDurable_OutputArguments Variable.
        /// </summary>
        public const uint Server_SetSubscriptionDurable_OutputArguments = 12751;

        /// <summary>
        /// The identifier for the Server_RequestServerStateChange_InputArguments Variable.
        /// </summary>
        public const uint Server_RequestServerStateChange_InputArguments = 12887;

        /// <summary>
        /// The identifier for the Server_ServerRedundancy_CurrentServerId Variable.
        /// </summary>
        public const uint Server_ServerRedundancy_CurrentServerId = 11312;

        /// <summary>
        /// The identifier for the Server_ServerRedundancy_RedundantServerArray Variable.
        /// </summary>
        public const uint Server_ServerRedundancy_RedundantServerArray = 11313;

        /// <summary>
        /// The identifier for the Server_ServerRedundancy_ServerUriArray Variable.
        /// </summary>
        public const uint Server_ServerRedundancy_ServerUriArray = 11314;

        /// <summary>
        /// The identifier for the Server_ServerRedundancy_ServerNetworkGroups Variable.
        /// </summary>
        public const uint Server_ServerRedundancy_ServerNetworkGroups = 14415;

        /// <summary>
        /// The identifier for the HistoryServerCapabilities_AccessHistoryDataCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilities_AccessHistoryDataCapability = 11193;

        /// <summary>
        /// The identifier for the HistoryServerCapabilities_AccessHistoryEventsCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilities_AccessHistoryEventsCapability = 11242;

        /// <summary>
        /// The identifier for the HistoryServerCapabilities_MaxReturnDataValues Variable.
        /// </summary>
        public const uint HistoryServerCapabilities_MaxReturnDataValues = 11273;

        /// <summary>
        /// The identifier for the HistoryServerCapabilities_MaxReturnEventValues Variable.
        /// </summary>
        public const uint HistoryServerCapabilities_MaxReturnEventValues = 11274;

        /// <summary>
        /// The identifier for the HistoryServerCapabilities_InsertDataCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilities_InsertDataCapability = 11196;

        /// <summary>
        /// The identifier for the HistoryServerCapabilities_ReplaceDataCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilities_ReplaceDataCapability = 11197;

        /// <summary>
        /// The identifier for the HistoryServerCapabilities_UpdateDataCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilities_UpdateDataCapability = 11198;

        /// <summary>
        /// The identifier for the HistoryServerCapabilities_DeleteRawCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilities_DeleteRawCapability = 11199;

        /// <summary>
        /// The identifier for the HistoryServerCapabilities_DeleteAtTimeCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilities_DeleteAtTimeCapability = 11200;

        /// <summary>
        /// The identifier for the HistoryServerCapabilities_InsertEventCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilities_InsertEventCapability = 11281;

        /// <summary>
        /// The identifier for the HistoryServerCapabilities_ReplaceEventCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilities_ReplaceEventCapability = 11282;

        /// <summary>
        /// The identifier for the HistoryServerCapabilities_UpdateEventCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilities_UpdateEventCapability = 11283;

        /// <summary>
        /// The identifier for the HistoryServerCapabilities_DeleteEventCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilities_DeleteEventCapability = 11502;

        /// <summary>
        /// The identifier for the HistoryServerCapabilities_InsertAnnotationCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilities_InsertAnnotationCapability = 11275;

        /// <summary>
        /// The identifier for the HistoryServerCapabilities_ServerTimestampSupported Variable.
        /// </summary>
        public const uint HistoryServerCapabilities_ServerTimestampSupported = 19091;

        /// <summary>
        /// The identifier for the StateMachineType_CurrentState Variable.
        /// </summary>
        public const uint StateMachineType_CurrentState = 2769;

        /// <summary>
        /// The identifier for the StateMachineType_CurrentState_Id Variable.
        /// </summary>
        public const uint StateMachineType_CurrentState_Id = 3720;

        /// <summary>
        /// The identifier for the StateMachineType_LastTransition Variable.
        /// </summary>
        public const uint StateMachineType_LastTransition = 2770;

        /// <summary>
        /// The identifier for the StateMachineType_LastTransition_Id Variable.
        /// </summary>
        public const uint StateMachineType_LastTransition_Id = 3724;

        /// <summary>
        /// The identifier for the StateVariableType_Id Variable.
        /// </summary>
        public const uint StateVariableType_Id = 2756;

        /// <summary>
        /// The identifier for the StateVariableType_Name Variable.
        /// </summary>
        public const uint StateVariableType_Name = 2757;

        /// <summary>
        /// The identifier for the StateVariableType_Number Variable.
        /// </summary>
        public const uint StateVariableType_Number = 2758;

        /// <summary>
        /// The identifier for the StateVariableType_EffectiveDisplayName Variable.
        /// </summary>
        public const uint StateVariableType_EffectiveDisplayName = 2759;

        /// <summary>
        /// The identifier for the TransitionVariableType_Id Variable.
        /// </summary>
        public const uint TransitionVariableType_Id = 2763;

        /// <summary>
        /// The identifier for the TransitionVariableType_Name Variable.
        /// </summary>
        public const uint TransitionVariableType_Name = 2764;

        /// <summary>
        /// The identifier for the TransitionVariableType_Number Variable.
        /// </summary>
        public const uint TransitionVariableType_Number = 2765;

        /// <summary>
        /// The identifier for the TransitionVariableType_TransitionTime Variable.
        /// </summary>
        public const uint TransitionVariableType_TransitionTime = 2766;

        /// <summary>
        /// The identifier for the TransitionVariableType_EffectiveTransitionTime Variable.
        /// </summary>
        public const uint TransitionVariableType_EffectiveTransitionTime = 11456;

        /// <summary>
        /// The identifier for the FiniteStateMachineType_CurrentState Variable.
        /// </summary>
        public const uint FiniteStateMachineType_CurrentState = 2772;

        /// <summary>
        /// The identifier for the FiniteStateMachineType_CurrentState_Id Variable.
        /// </summary>
        public const uint FiniteStateMachineType_CurrentState_Id = 3728;

        /// <summary>
        /// The identifier for the FiniteStateMachineType_LastTransition Variable.
        /// </summary>
        public const uint FiniteStateMachineType_LastTransition = 2773;

        /// <summary>
        /// The identifier for the FiniteStateMachineType_LastTransition_Id Variable.
        /// </summary>
        public const uint FiniteStateMachineType_LastTransition_Id = 3732;

        /// <summary>
        /// The identifier for the FiniteStateMachineType_AvailableStates Variable.
        /// </summary>
        public const uint FiniteStateMachineType_AvailableStates = 17635;

        /// <summary>
        /// The identifier for the FiniteStateMachineType_AvailableTransitions Variable.
        /// </summary>
        public const uint FiniteStateMachineType_AvailableTransitions = 17636;

        /// <summary>
        /// The identifier for the FiniteStateVariableType_Id Variable.
        /// </summary>
        public const uint FiniteStateVariableType_Id = 2761;

        /// <summary>
        /// The identifier for the FiniteTransitionVariableType_Id Variable.
        /// </summary>
        public const uint FiniteTransitionVariableType_Id = 2768;

        /// <summary>
        /// The identifier for the StateType_StateNumber Variable.
        /// </summary>
        public const uint StateType_StateNumber = 2308;

        /// <summary>
        /// The identifier for the TransitionType_TransitionNumber Variable.
        /// </summary>
        public const uint TransitionType_TransitionNumber = 2312;

        /// <summary>
        /// The identifier for the ExpressionGuardVariableType_Expression Variable.
        /// </summary>
        public const uint ExpressionGuardVariableType_Expression = 15129;

        /// <summary>
        /// The identifier for the RationalNumberType_Numerator Variable.
        /// </summary>
        public const uint RationalNumberType_Numerator = 17712;

        /// <summary>
        /// The identifier for the RationalNumberType_Denominator Variable.
        /// </summary>
        public const uint RationalNumberType_Denominator = 17713;

        /// <summary>
        /// The identifier for the VectorType_VectorUnit Variable.
        /// </summary>
        public const uint VectorType_VectorUnit = 17715;

        /// <summary>
        /// The identifier for the ThreeDVectorType_X Variable.
        /// </summary>
        public const uint ThreeDVectorType_X = 18769;

        /// <summary>
        /// The identifier for the ThreeDVectorType_Y Variable.
        /// </summary>
        public const uint ThreeDVectorType_Y = 18770;

        /// <summary>
        /// The identifier for the ThreeDVectorType_Z Variable.
        /// </summary>
        public const uint ThreeDVectorType_Z = 18771;

        /// <summary>
        /// The identifier for the CartesianCoordinatesType_LengthUnit Variable.
        /// </summary>
        public const uint CartesianCoordinatesType_LengthUnit = 18773;

        /// <summary>
        /// The identifier for the ThreeDCartesianCoordinatesType_X Variable.
        /// </summary>
        public const uint ThreeDCartesianCoordinatesType_X = 18776;

        /// <summary>
        /// The identifier for the ThreeDCartesianCoordinatesType_Y Variable.
        /// </summary>
        public const uint ThreeDCartesianCoordinatesType_Y = 18777;

        /// <summary>
        /// The identifier for the ThreeDCartesianCoordinatesType_Z Variable.
        /// </summary>
        public const uint ThreeDCartesianCoordinatesType_Z = 18778;

        /// <summary>
        /// The identifier for the OrientationType_AngleUnit Variable.
        /// </summary>
        public const uint OrientationType_AngleUnit = 18780;

        /// <summary>
        /// The identifier for the ThreeDOrientationType_A Variable.
        /// </summary>
        public const uint ThreeDOrientationType_A = 18783;

        /// <summary>
        /// The identifier for the ThreeDOrientationType_B Variable.
        /// </summary>
        public const uint ThreeDOrientationType_B = 18784;

        /// <summary>
        /// The identifier for the ThreeDOrientationType_C Variable.
        /// </summary>
        public const uint ThreeDOrientationType_C = 18785;

        /// <summary>
        /// The identifier for the FrameType_CartesianCoordinates Variable.
        /// </summary>
        public const uint FrameType_CartesianCoordinates = 18801;

        /// <summary>
        /// The identifier for the FrameType_Orientation Variable.
        /// </summary>
        public const uint FrameType_Orientation = 18787;

        /// <summary>
        /// The identifier for the FrameType_Constant Variable.
        /// </summary>
        public const uint FrameType_Constant = 18788;

        /// <summary>
        /// The identifier for the FrameType_BaseFrame Variable.
        /// </summary>
        public const uint FrameType_BaseFrame = 18789;

        /// <summary>
        /// The identifier for the FrameType_FixedBase Variable.
        /// </summary>
        public const uint FrameType_FixedBase = 18790;

        /// <summary>
        /// The identifier for the ThreeDFrameType_CartesianCoordinates Variable.
        /// </summary>
        public const uint ThreeDFrameType_CartesianCoordinates = 18796;

        /// <summary>
        /// The identifier for the ThreeDFrameType_Orientation Variable.
        /// </summary>
        public const uint ThreeDFrameType_Orientation = 18792;

        /// <summary>
        /// The identifier for the ThreeDFrameType_CartesianCoordinates_X Variable.
        /// </summary>
        public const uint ThreeDFrameType_CartesianCoordinates_X = 18798;

        /// <summary>
        /// The identifier for the ThreeDFrameType_CartesianCoordinates_Y Variable.
        /// </summary>
        public const uint ThreeDFrameType_CartesianCoordinates_Y = 18799;

        /// <summary>
        /// The identifier for the ThreeDFrameType_CartesianCoordinates_Z Variable.
        /// </summary>
        public const uint ThreeDFrameType_CartesianCoordinates_Z = 18800;

        /// <summary>
        /// The identifier for the ThreeDFrameType_Orientation_A Variable.
        /// </summary>
        public const uint ThreeDFrameType_Orientation_A = 19074;

        /// <summary>
        /// The identifier for the ThreeDFrameType_Orientation_B Variable.
        /// </summary>
        public const uint ThreeDFrameType_Orientation_B = 19075;

        /// <summary>
        /// The identifier for the ThreeDFrameType_Orientation_C Variable.
        /// </summary>
        public const uint ThreeDFrameType_Orientation_C = 19076;

        /// <summary>
        /// The identifier for the TransitionEventType_Transition Variable.
        /// </summary>
        public const uint TransitionEventType_Transition = 2774;

        /// <summary>
        /// The identifier for the TransitionEventType_Transition_Id Variable.
        /// </summary>
        public const uint TransitionEventType_Transition_Id = 3754;

        /// <summary>
        /// The identifier for the TransitionEventType_FromState Variable.
        /// </summary>
        public const uint TransitionEventType_FromState = 2775;

        /// <summary>
        /// The identifier for the TransitionEventType_FromState_Id Variable.
        /// </summary>
        public const uint TransitionEventType_FromState_Id = 3746;

        /// <summary>
        /// The identifier for the TransitionEventType_ToState Variable.
        /// </summary>
        public const uint TransitionEventType_ToState = 2776;

        /// <summary>
        /// The identifier for the TransitionEventType_ToState_Id Variable.
        /// </summary>
        public const uint TransitionEventType_ToState_Id = 3750;

        /// <summary>
        /// The identifier for the AuditUpdateStateEventType_OldStateId Variable.
        /// </summary>
        public const uint AuditUpdateStateEventType_OldStateId = 2777;

        /// <summary>
        /// The identifier for the AuditUpdateStateEventType_NewStateId Variable.
        /// </summary>
        public const uint AuditUpdateStateEventType_NewStateId = 2778;

        /// <summary>
        /// The identifier for the OpenFileMode_EnumValues Variable.
        /// </summary>
        public const uint OpenFileMode_EnumValues = 11940;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_InputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_InputArguments = 13356;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments = 13357;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_InputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_InputArguments = 13359;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_OutputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_OutputArguments = 13360;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments = 17719;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments = 13364;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments = 13365;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileName_Placeholder_Size Variable.
        /// </summary>
        public const uint FileDirectoryType_FileName_Placeholder_Size = 13367;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileName_Placeholder_Writable Variable.
        /// </summary>
        public const uint FileDirectoryType_FileName_Placeholder_Writable = 13368;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileName_Placeholder_UserWritable Variable.
        /// </summary>
        public const uint FileDirectoryType_FileName_Placeholder_UserWritable = 13369;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileName_Placeholder_OpenCount Variable.
        /// </summary>
        public const uint FileDirectoryType_FileName_Placeholder_OpenCount = 13370;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileName_Placeholder_Open_InputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_FileName_Placeholder_Open_InputArguments = 13373;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileName_Placeholder_Open_OutputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_FileName_Placeholder_Open_OutputArguments = 13374;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileName_Placeholder_Close_InputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_FileName_Placeholder_Close_InputArguments = 13376;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileName_Placeholder_Read_InputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_FileName_Placeholder_Read_InputArguments = 13378;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileName_Placeholder_Read_OutputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_FileName_Placeholder_Read_OutputArguments = 13379;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileName_Placeholder_Write_InputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_FileName_Placeholder_Write_InputArguments = 13381;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileName_Placeholder_GetPosition_InputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_FileName_Placeholder_GetPosition_InputArguments = 13383;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileName_Placeholder_GetPosition_OutputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_FileName_Placeholder_GetPosition_OutputArguments = 13384;

        /// <summary>
        /// The identifier for the FileDirectoryType_FileName_Placeholder_SetPosition_InputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_FileName_Placeholder_SetPosition_InputArguments = 13386;

        /// <summary>
        /// The identifier for the FileDirectoryType_CreateDirectory_InputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_CreateDirectory_InputArguments = 13388;

        /// <summary>
        /// The identifier for the FileDirectoryType_CreateDirectory_OutputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_CreateDirectory_OutputArguments = 13389;

        /// <summary>
        /// The identifier for the FileDirectoryType_CreateFile_InputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_CreateFile_InputArguments = 13391;

        /// <summary>
        /// The identifier for the FileDirectoryType_CreateFile_OutputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_CreateFile_OutputArguments = 13392;

        /// <summary>
        /// The identifier for the FileDirectoryType_DeleteFileSystemObject_InputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_DeleteFileSystemObject_InputArguments = 13394;

        /// <summary>
        /// The identifier for the FileDirectoryType_MoveOrCopy_InputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_MoveOrCopy_InputArguments = 13396;

        /// <summary>
        /// The identifier for the FileDirectoryType_MoveOrCopy_OutputArguments Variable.
        /// </summary>
        public const uint FileDirectoryType_MoveOrCopy_OutputArguments = 13397;

        /// <summary>
        /// The identifier for the FileSystem_FileDirectoryName_Placeholder_CreateDirectory_InputArguments Variable.
        /// </summary>
        public const uint FileSystem_FileDirectoryName_Placeholder_CreateDirectory_InputArguments = 16317;

        /// <summary>
        /// The identifier for the FileSystem_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments Variable.
        /// </summary>
        public const uint FileSystem_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments = 16318;

        /// <summary>
        /// The identifier for the FileSystem_FileDirectoryName_Placeholder_CreateFile_InputArguments Variable.
        /// </summary>
        public const uint FileSystem_FileDirectoryName_Placeholder_CreateFile_InputArguments = 16320;

        /// <summary>
        /// The identifier for the FileSystem_FileDirectoryName_Placeholder_CreateFile_OutputArguments Variable.
        /// </summary>
        public const uint FileSystem_FileDirectoryName_Placeholder_CreateFile_OutputArguments = 16321;

        /// <summary>
        /// The identifier for the FileSystem_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments Variable.
        /// </summary>
        public const uint FileSystem_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments = 17723;

        /// <summary>
        /// The identifier for the FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments Variable.
        /// </summary>
        public const uint FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments = 16325;

        /// <summary>
        /// The identifier for the FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments Variable.
        /// </summary>
        public const uint FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments = 16326;

        /// <summary>
        /// The identifier for the FileSystem_FileName_Placeholder_Size Variable.
        /// </summary>
        public const uint FileSystem_FileName_Placeholder_Size = 16328;

        /// <summary>
        /// The identifier for the FileSystem_FileName_Placeholder_Writable Variable.
        /// </summary>
        public const uint FileSystem_FileName_Placeholder_Writable = 16329;

        /// <summary>
        /// The identifier for the FileSystem_FileName_Placeholder_UserWritable Variable.
        /// </summary>
        public const uint FileSystem_FileName_Placeholder_UserWritable = 16330;

        /// <summary>
        /// The identifier for the FileSystem_FileName_Placeholder_OpenCount Variable.
        /// </summary>
        public const uint FileSystem_FileName_Placeholder_OpenCount = 16331;

        /// <summary>
        /// The identifier for the FileSystem_FileName_Placeholder_Open_InputArguments Variable.
        /// </summary>
        public const uint FileSystem_FileName_Placeholder_Open_InputArguments = 16334;

        /// <summary>
        /// The identifier for the FileSystem_FileName_Placeholder_Open_OutputArguments Variable.
        /// </summary>
        public const uint FileSystem_FileName_Placeholder_Open_OutputArguments = 16335;

        /// <summary>
        /// The identifier for the FileSystem_FileName_Placeholder_Close_InputArguments Variable.
        /// </summary>
        public const uint FileSystem_FileName_Placeholder_Close_InputArguments = 16337;

        /// <summary>
        /// The identifier for the FileSystem_FileName_Placeholder_Read_InputArguments Variable.
        /// </summary>
        public const uint FileSystem_FileName_Placeholder_Read_InputArguments = 16339;

        /// <summary>
        /// The identifier for the FileSystem_FileName_Placeholder_Read_OutputArguments Variable.
        /// </summary>
        public const uint FileSystem_FileName_Placeholder_Read_OutputArguments = 16340;

        /// <summary>
        /// The identifier for the FileSystem_FileName_Placeholder_Write_InputArguments Variable.
        /// </summary>
        public const uint FileSystem_FileName_Placeholder_Write_InputArguments = 16342;

        /// <summary>
        /// The identifier for the FileSystem_FileName_Placeholder_GetPosition_InputArguments Variable.
        /// </summary>
        public const uint FileSystem_FileName_Placeholder_GetPosition_InputArguments = 16344;

        /// <summary>
        /// The identifier for the FileSystem_FileName_Placeholder_GetPosition_OutputArguments Variable.
        /// </summary>
        public const uint FileSystem_FileName_Placeholder_GetPosition_OutputArguments = 16345;

        /// <summary>
        /// The identifier for the FileSystem_FileName_Placeholder_SetPosition_InputArguments Variable.
        /// </summary>
        public const uint FileSystem_FileName_Placeholder_SetPosition_InputArguments = 16347;

        /// <summary>
        /// The identifier for the FileSystem_CreateDirectory_InputArguments Variable.
        /// </summary>
        public const uint FileSystem_CreateDirectory_InputArguments = 16349;

        /// <summary>
        /// The identifier for the FileSystem_CreateDirectory_OutputArguments Variable.
        /// </summary>
        public const uint FileSystem_CreateDirectory_OutputArguments = 16350;

        /// <summary>
        /// The identifier for the FileSystem_CreateFile_InputArguments Variable.
        /// </summary>
        public const uint FileSystem_CreateFile_InputArguments = 16352;

        /// <summary>
        /// The identifier for the FileSystem_CreateFile_OutputArguments Variable.
        /// </summary>
        public const uint FileSystem_CreateFile_OutputArguments = 16353;

        /// <summary>
        /// The identifier for the FileSystem_DeleteFileSystemObject_InputArguments Variable.
        /// </summary>
        public const uint FileSystem_DeleteFileSystemObject_InputArguments = 16355;

        /// <summary>
        /// The identifier for the FileSystem_MoveOrCopy_InputArguments Variable.
        /// </summary>
        public const uint FileSystem_MoveOrCopy_InputArguments = 16357;

        /// <summary>
        /// The identifier for the FileSystem_MoveOrCopy_OutputArguments Variable.
        /// </summary>
        public const uint FileSystem_MoveOrCopy_OutputArguments = 16358;

        /// <summary>
        /// The identifier for the TemporaryFileTransferType_ClientProcessingTimeout Variable.
        /// </summary>
        public const uint TemporaryFileTransferType_ClientProcessingTimeout = 15745;

        /// <summary>
        /// The identifier for the TemporaryFileTransferType_GenerateFileForRead_InputArguments Variable.
        /// </summary>
        public const uint TemporaryFileTransferType_GenerateFileForRead_InputArguments = 15747;

        /// <summary>
        /// The identifier for the TemporaryFileTransferType_GenerateFileForRead_OutputArguments Variable.
        /// </summary>
        public const uint TemporaryFileTransferType_GenerateFileForRead_OutputArguments = 15748;

        /// <summary>
        /// The identifier for the TemporaryFileTransferType_GenerateFileForWrite_InputArguments Variable.
        /// </summary>
        public const uint TemporaryFileTransferType_GenerateFileForWrite_InputArguments = 16359;

        /// <summary>
        /// The identifier for the TemporaryFileTransferType_GenerateFileForWrite_OutputArguments Variable.
        /// </summary>
        public const uint TemporaryFileTransferType_GenerateFileForWrite_OutputArguments = 15750;

        /// <summary>
        /// The identifier for the TemporaryFileTransferType_CloseAndCommit_InputArguments Variable.
        /// </summary>
        public const uint TemporaryFileTransferType_CloseAndCommit_InputArguments = 15752;

        /// <summary>
        /// The identifier for the TemporaryFileTransferType_CloseAndCommit_OutputArguments Variable.
        /// </summary>
        public const uint TemporaryFileTransferType_CloseAndCommit_OutputArguments = 15753;

        /// <summary>
        /// The identifier for the TemporaryFileTransferType_TransferState_Placeholder_CurrentState Variable.
        /// </summary>
        public const uint TemporaryFileTransferType_TransferState_Placeholder_CurrentState = 15755;

        /// <summary>
        /// The identifier for the TemporaryFileTransferType_TransferState_Placeholder_CurrentState_Id Variable.
        /// </summary>
        public const uint TemporaryFileTransferType_TransferState_Placeholder_CurrentState_Id = 15756;

        /// <summary>
        /// The identifier for the TemporaryFileTransferType_TransferState_Placeholder_LastTransition_Id Variable.
        /// </summary>
        public const uint TemporaryFileTransferType_TransferState_Placeholder_LastTransition_Id = 15761;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_CurrentState_Id Variable.
        /// </summary>
        public const uint FileTransferStateMachineType_CurrentState_Id = 15805;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_LastTransition_Id Variable.
        /// </summary>
        public const uint FileTransferStateMachineType_LastTransition_Id = 15810;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_Idle_StateNumber Variable.
        /// </summary>
        public const uint FileTransferStateMachineType_Idle_StateNumber = 15816;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_ReadPrepare_StateNumber Variable.
        /// </summary>
        public const uint FileTransferStateMachineType_ReadPrepare_StateNumber = 15818;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_ReadTransfer_StateNumber Variable.
        /// </summary>
        public const uint FileTransferStateMachineType_ReadTransfer_StateNumber = 15820;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_ApplyWrite_StateNumber Variable.
        /// </summary>
        public const uint FileTransferStateMachineType_ApplyWrite_StateNumber = 15822;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_Error_StateNumber Variable.
        /// </summary>
        public const uint FileTransferStateMachineType_Error_StateNumber = 15824;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_IdleToReadPrepare_TransitionNumber Variable.
        /// </summary>
        public const uint FileTransferStateMachineType_IdleToReadPrepare_TransitionNumber = 15826;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_ReadPrepareToReadTransfer_TransitionNumber Variable.
        /// </summary>
        public const uint FileTransferStateMachineType_ReadPrepareToReadTransfer_TransitionNumber = 15828;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_ReadTransferToIdle_TransitionNumber Variable.
        /// </summary>
        public const uint FileTransferStateMachineType_ReadTransferToIdle_TransitionNumber = 15830;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_IdleToApplyWrite_TransitionNumber Variable.
        /// </summary>
        public const uint FileTransferStateMachineType_IdleToApplyWrite_TransitionNumber = 15832;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_ApplyWriteToIdle_TransitionNumber Variable.
        /// </summary>
        public const uint FileTransferStateMachineType_ApplyWriteToIdle_TransitionNumber = 15834;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_ReadPrepareToError_TransitionNumber Variable.
        /// </summary>
        public const uint FileTransferStateMachineType_ReadPrepareToError_TransitionNumber = 15836;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_ReadTransferToError_TransitionNumber Variable.
        /// </summary>
        public const uint FileTransferStateMachineType_ReadTransferToError_TransitionNumber = 15838;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_ApplyWriteToError_TransitionNumber Variable.
        /// </summary>
        public const uint FileTransferStateMachineType_ApplyWriteToError_TransitionNumber = 15840;

        /// <summary>
        /// The identifier for the FileTransferStateMachineType_ErrorToIdle_TransitionNumber Variable.
        /// </summary>
        public const uint FileTransferStateMachineType_ErrorToIdle_TransitionNumber = 15842;

        /// <summary>
        /// The identifier for the RoleSetType_RoleName_Placeholder_Identities Variable.
        /// </summary>
        public const uint RoleSetType_RoleName_Placeholder_Identities = 16162;

        /// <summary>
        /// The identifier for the RoleSetType_RoleName_Placeholder_AddIdentity_InputArguments Variable.
        /// </summary>
        public const uint RoleSetType_RoleName_Placeholder_AddIdentity_InputArguments = 15613;

        /// <summary>
        /// The identifier for the RoleSetType_RoleName_Placeholder_RemoveIdentity_InputArguments Variable.
        /// </summary>
        public const uint RoleSetType_RoleName_Placeholder_RemoveIdentity_InputArguments = 15615;

        /// <summary>
        /// The identifier for the RoleSetType_RoleName_Placeholder_AddApplication_InputArguments Variable.
        /// </summary>
        public const uint RoleSetType_RoleName_Placeholder_AddApplication_InputArguments = 16166;

        /// <summary>
        /// The identifier for the RoleSetType_RoleName_Placeholder_RemoveApplication_InputArguments Variable.
        /// </summary>
        public const uint RoleSetType_RoleName_Placeholder_RemoveApplication_InputArguments = 16168;

        /// <summary>
        /// The identifier for the RoleSetType_RoleName_Placeholder_AddEndpoint_InputArguments Variable.
        /// </summary>
        public const uint RoleSetType_RoleName_Placeholder_AddEndpoint_InputArguments = 16170;

        /// <summary>
        /// The identifier for the RoleSetType_RoleName_Placeholder_RemoveEndpoint_InputArguments Variable.
        /// </summary>
        public const uint RoleSetType_RoleName_Placeholder_RemoveEndpoint_InputArguments = 16172;

        /// <summary>
        /// The identifier for the RoleSetType_AddRole_InputArguments Variable.
        /// </summary>
        public const uint RoleSetType_AddRole_InputArguments = 15998;

        /// <summary>
        /// The identifier for the RoleSetType_AddRole_OutputArguments Variable.
        /// </summary>
        public const uint RoleSetType_AddRole_OutputArguments = 15999;

        /// <summary>
        /// The identifier for the RoleSetType_RemoveRole_InputArguments Variable.
        /// </summary>
        public const uint RoleSetType_RemoveRole_InputArguments = 16001;

        /// <summary>
        /// The identifier for the RoleType_Identities Variable.
        /// </summary>
        public const uint RoleType_Identities = 16173;

        /// <summary>
        /// The identifier for the RoleType_Applications Variable.
        /// </summary>
        public const uint RoleType_Applications = 16174;

        /// <summary>
        /// The identifier for the RoleType_ApplicationsExclude Variable.
        /// </summary>
        public const uint RoleType_ApplicationsExclude = 15410;

        /// <summary>
        /// The identifier for the RoleType_Endpoints Variable.
        /// </summary>
        public const uint RoleType_Endpoints = 16175;

        /// <summary>
        /// The identifier for the RoleType_EndpointsExclude Variable.
        /// </summary>
        public const uint RoleType_EndpointsExclude = 15411;

        /// <summary>
        /// The identifier for the RoleType_AddIdentity_InputArguments Variable.
        /// </summary>
        public const uint RoleType_AddIdentity_InputArguments = 15625;

        /// <summary>
        /// The identifier for the RoleType_RemoveIdentity_InputArguments Variable.
        /// </summary>
        public const uint RoleType_RemoveIdentity_InputArguments = 15627;

        /// <summary>
        /// The identifier for the RoleType_AddApplication_InputArguments Variable.
        /// </summary>
        public const uint RoleType_AddApplication_InputArguments = 16177;

        /// <summary>
        /// The identifier for the RoleType_RemoveApplication_InputArguments Variable.
        /// </summary>
        public const uint RoleType_RemoveApplication_InputArguments = 16179;

        /// <summary>
        /// The identifier for the RoleType_AddEndpoint_InputArguments Variable.
        /// </summary>
        public const uint RoleType_AddEndpoint_InputArguments = 16181;

        /// <summary>
        /// The identifier for the RoleType_RemoveEndpoint_InputArguments Variable.
        /// </summary>
        public const uint RoleType_RemoveEndpoint_InputArguments = 16183;

        /// <summary>
        /// The identifier for the IdentityCriteriaType_EnumValues Variable.
        /// </summary>
        public const uint IdentityCriteriaType_EnumValues = 15633;

        /// <summary>
        /// The identifier for the WellKnownRole_Anonymous_Identities Variable.
        /// </summary>
        public const uint WellKnownRole_Anonymous_Identities = 16192;

        /// <summary>
        /// The identifier for the WellKnownRole_Anonymous_Applications Variable.
        /// </summary>
        public const uint WellKnownRole_Anonymous_Applications = 16193;

        /// <summary>
        /// The identifier for the WellKnownRole_Anonymous_ApplicationsExclude Variable.
        /// </summary>
        public const uint WellKnownRole_Anonymous_ApplicationsExclude = 15412;

        /// <summary>
        /// The identifier for the WellKnownRole_Anonymous_Endpoints Variable.
        /// </summary>
        public const uint WellKnownRole_Anonymous_Endpoints = 16194;

        /// <summary>
        /// The identifier for the WellKnownRole_Anonymous_EndpointsExclude Variable.
        /// </summary>
        public const uint WellKnownRole_Anonymous_EndpointsExclude = 15413;

        /// <summary>
        /// The identifier for the WellKnownRole_Anonymous_AddIdentity_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Anonymous_AddIdentity_InputArguments = 15649;

        /// <summary>
        /// The identifier for the WellKnownRole_Anonymous_RemoveIdentity_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Anonymous_RemoveIdentity_InputArguments = 15651;

        /// <summary>
        /// The identifier for the WellKnownRole_Anonymous_AddApplication_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Anonymous_AddApplication_InputArguments = 16196;

        /// <summary>
        /// The identifier for the WellKnownRole_Anonymous_RemoveApplication_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Anonymous_RemoveApplication_InputArguments = 16198;

        /// <summary>
        /// The identifier for the WellKnownRole_Anonymous_AddEndpoint_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Anonymous_AddEndpoint_InputArguments = 16200;

        /// <summary>
        /// The identifier for the WellKnownRole_Anonymous_RemoveEndpoint_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Anonymous_RemoveEndpoint_InputArguments = 16202;

        /// <summary>
        /// The identifier for the WellKnownRole_AuthenticatedUser_Identities Variable.
        /// </summary>
        public const uint WellKnownRole_AuthenticatedUser_Identities = 16203;

        /// <summary>
        /// The identifier for the WellKnownRole_AuthenticatedUser_Applications Variable.
        /// </summary>
        public const uint WellKnownRole_AuthenticatedUser_Applications = 16204;

        /// <summary>
        /// The identifier for the WellKnownRole_AuthenticatedUser_ApplicationsExclude Variable.
        /// </summary>
        public const uint WellKnownRole_AuthenticatedUser_ApplicationsExclude = 15414;

        /// <summary>
        /// The identifier for the WellKnownRole_AuthenticatedUser_Endpoints Variable.
        /// </summary>
        public const uint WellKnownRole_AuthenticatedUser_Endpoints = 16205;

        /// <summary>
        /// The identifier for the WellKnownRole_AuthenticatedUser_EndpointsExclude Variable.
        /// </summary>
        public const uint WellKnownRole_AuthenticatedUser_EndpointsExclude = 15415;

        /// <summary>
        /// The identifier for the WellKnownRole_AuthenticatedUser_AddIdentity_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_AuthenticatedUser_AddIdentity_InputArguments = 15661;

        /// <summary>
        /// The identifier for the WellKnownRole_AuthenticatedUser_RemoveIdentity_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_AuthenticatedUser_RemoveIdentity_InputArguments = 15663;

        /// <summary>
        /// The identifier for the WellKnownRole_AuthenticatedUser_AddApplication_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_AuthenticatedUser_AddApplication_InputArguments = 16207;

        /// <summary>
        /// The identifier for the WellKnownRole_AuthenticatedUser_RemoveApplication_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_AuthenticatedUser_RemoveApplication_InputArguments = 16209;

        /// <summary>
        /// The identifier for the WellKnownRole_AuthenticatedUser_AddEndpoint_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_AuthenticatedUser_AddEndpoint_InputArguments = 16211;

        /// <summary>
        /// The identifier for the WellKnownRole_AuthenticatedUser_RemoveEndpoint_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_AuthenticatedUser_RemoveEndpoint_InputArguments = 16213;

        /// <summary>
        /// The identifier for the WellKnownRole_Observer_Identities Variable.
        /// </summary>
        public const uint WellKnownRole_Observer_Identities = 16214;

        /// <summary>
        /// The identifier for the WellKnownRole_Observer_Applications Variable.
        /// </summary>
        public const uint WellKnownRole_Observer_Applications = 16215;

        /// <summary>
        /// The identifier for the WellKnownRole_Observer_ApplicationsExclude Variable.
        /// </summary>
        public const uint WellKnownRole_Observer_ApplicationsExclude = 15416;

        /// <summary>
        /// The identifier for the WellKnownRole_Observer_Endpoints Variable.
        /// </summary>
        public const uint WellKnownRole_Observer_Endpoints = 16216;

        /// <summary>
        /// The identifier for the WellKnownRole_Observer_EndpointsExclude Variable.
        /// </summary>
        public const uint WellKnownRole_Observer_EndpointsExclude = 15417;

        /// <summary>
        /// The identifier for the WellKnownRole_Observer_AddIdentity_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Observer_AddIdentity_InputArguments = 15673;

        /// <summary>
        /// The identifier for the WellKnownRole_Observer_RemoveIdentity_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Observer_RemoveIdentity_InputArguments = 15675;

        /// <summary>
        /// The identifier for the WellKnownRole_Observer_AddApplication_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Observer_AddApplication_InputArguments = 16218;

        /// <summary>
        /// The identifier for the WellKnownRole_Observer_RemoveApplication_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Observer_RemoveApplication_InputArguments = 16220;

        /// <summary>
        /// The identifier for the WellKnownRole_Observer_AddEndpoint_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Observer_AddEndpoint_InputArguments = 16222;

        /// <summary>
        /// The identifier for the WellKnownRole_Observer_RemoveEndpoint_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Observer_RemoveEndpoint_InputArguments = 16224;

        /// <summary>
        /// The identifier for the WellKnownRole_Operator_Identities Variable.
        /// </summary>
        public const uint WellKnownRole_Operator_Identities = 16225;

        /// <summary>
        /// The identifier for the WellKnownRole_Operator_Applications Variable.
        /// </summary>
        public const uint WellKnownRole_Operator_Applications = 16226;

        /// <summary>
        /// The identifier for the WellKnownRole_Operator_ApplicationsExclude Variable.
        /// </summary>
        public const uint WellKnownRole_Operator_ApplicationsExclude = 15418;

        /// <summary>
        /// The identifier for the WellKnownRole_Operator_Endpoints Variable.
        /// </summary>
        public const uint WellKnownRole_Operator_Endpoints = 16227;

        /// <summary>
        /// The identifier for the WellKnownRole_Operator_EndpointsExclude Variable.
        /// </summary>
        public const uint WellKnownRole_Operator_EndpointsExclude = 15423;

        /// <summary>
        /// The identifier for the WellKnownRole_Operator_AddIdentity_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Operator_AddIdentity_InputArguments = 15685;

        /// <summary>
        /// The identifier for the WellKnownRole_Operator_RemoveIdentity_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Operator_RemoveIdentity_InputArguments = 15687;

        /// <summary>
        /// The identifier for the WellKnownRole_Operator_AddApplication_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Operator_AddApplication_InputArguments = 16229;

        /// <summary>
        /// The identifier for the WellKnownRole_Operator_RemoveApplication_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Operator_RemoveApplication_InputArguments = 16231;

        /// <summary>
        /// The identifier for the WellKnownRole_Operator_AddEndpoint_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Operator_AddEndpoint_InputArguments = 16233;

        /// <summary>
        /// The identifier for the WellKnownRole_Operator_RemoveEndpoint_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Operator_RemoveEndpoint_InputArguments = 16235;

        /// <summary>
        /// The identifier for the WellKnownRole_Engineer_Identities Variable.
        /// </summary>
        public const uint WellKnownRole_Engineer_Identities = 16236;

        /// <summary>
        /// The identifier for the WellKnownRole_Engineer_Applications Variable.
        /// </summary>
        public const uint WellKnownRole_Engineer_Applications = 16237;

        /// <summary>
        /// The identifier for the WellKnownRole_Engineer_ApplicationsExclude Variable.
        /// </summary>
        public const uint WellKnownRole_Engineer_ApplicationsExclude = 15424;

        /// <summary>
        /// The identifier for the WellKnownRole_Engineer_Endpoints Variable.
        /// </summary>
        public const uint WellKnownRole_Engineer_Endpoints = 16238;

        /// <summary>
        /// The identifier for the WellKnownRole_Engineer_EndpointsExclude Variable.
        /// </summary>
        public const uint WellKnownRole_Engineer_EndpointsExclude = 15425;

        /// <summary>
        /// The identifier for the WellKnownRole_Engineer_AddIdentity_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Engineer_AddIdentity_InputArguments = 16042;

        /// <summary>
        /// The identifier for the WellKnownRole_Engineer_RemoveIdentity_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Engineer_RemoveIdentity_InputArguments = 16044;

        /// <summary>
        /// The identifier for the WellKnownRole_Engineer_AddApplication_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Engineer_AddApplication_InputArguments = 16240;

        /// <summary>
        /// The identifier for the WellKnownRole_Engineer_RemoveApplication_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Engineer_RemoveApplication_InputArguments = 16242;

        /// <summary>
        /// The identifier for the WellKnownRole_Engineer_AddEndpoint_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Engineer_AddEndpoint_InputArguments = 16244;

        /// <summary>
        /// The identifier for the WellKnownRole_Engineer_RemoveEndpoint_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Engineer_RemoveEndpoint_InputArguments = 16246;

        /// <summary>
        /// The identifier for the WellKnownRole_Supervisor_Identities Variable.
        /// </summary>
        public const uint WellKnownRole_Supervisor_Identities = 16247;

        /// <summary>
        /// The identifier for the WellKnownRole_Supervisor_Applications Variable.
        /// </summary>
        public const uint WellKnownRole_Supervisor_Applications = 16248;

        /// <summary>
        /// The identifier for the WellKnownRole_Supervisor_ApplicationsExclude Variable.
        /// </summary>
        public const uint WellKnownRole_Supervisor_ApplicationsExclude = 15426;

        /// <summary>
        /// The identifier for the WellKnownRole_Supervisor_Endpoints Variable.
        /// </summary>
        public const uint WellKnownRole_Supervisor_Endpoints = 16249;

        /// <summary>
        /// The identifier for the WellKnownRole_Supervisor_EndpointsExclude Variable.
        /// </summary>
        public const uint WellKnownRole_Supervisor_EndpointsExclude = 15427;

        /// <summary>
        /// The identifier for the WellKnownRole_Supervisor_AddIdentity_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Supervisor_AddIdentity_InputArguments = 15697;

        /// <summary>
        /// The identifier for the WellKnownRole_Supervisor_RemoveIdentity_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Supervisor_RemoveIdentity_InputArguments = 15699;

        /// <summary>
        /// The identifier for the WellKnownRole_Supervisor_AddApplication_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Supervisor_AddApplication_InputArguments = 16251;

        /// <summary>
        /// The identifier for the WellKnownRole_Supervisor_RemoveApplication_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Supervisor_RemoveApplication_InputArguments = 16253;

        /// <summary>
        /// The identifier for the WellKnownRole_Supervisor_AddEndpoint_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Supervisor_AddEndpoint_InputArguments = 16255;

        /// <summary>
        /// The identifier for the WellKnownRole_Supervisor_RemoveEndpoint_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_Supervisor_RemoveEndpoint_InputArguments = 16257;

        /// <summary>
        /// The identifier for the WellKnownRole_ConfigureAdmin_Identities Variable.
        /// </summary>
        public const uint WellKnownRole_ConfigureAdmin_Identities = 16269;

        /// <summary>
        /// The identifier for the WellKnownRole_ConfigureAdmin_Applications Variable.
        /// </summary>
        public const uint WellKnownRole_ConfigureAdmin_Applications = 16270;

        /// <summary>
        /// The identifier for the WellKnownRole_ConfigureAdmin_ApplicationsExclude Variable.
        /// </summary>
        public const uint WellKnownRole_ConfigureAdmin_ApplicationsExclude = 15428;

        /// <summary>
        /// The identifier for the WellKnownRole_ConfigureAdmin_Endpoints Variable.
        /// </summary>
        public const uint WellKnownRole_ConfigureAdmin_Endpoints = 16271;

        /// <summary>
        /// The identifier for the WellKnownRole_ConfigureAdmin_EndpointsExclude Variable.
        /// </summary>
        public const uint WellKnownRole_ConfigureAdmin_EndpointsExclude = 15429;

        /// <summary>
        /// The identifier for the WellKnownRole_ConfigureAdmin_AddIdentity_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_ConfigureAdmin_AddIdentity_InputArguments = 15721;

        /// <summary>
        /// The identifier for the WellKnownRole_ConfigureAdmin_RemoveIdentity_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_ConfigureAdmin_RemoveIdentity_InputArguments = 15723;

        /// <summary>
        /// The identifier for the WellKnownRole_ConfigureAdmin_AddApplication_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_ConfigureAdmin_AddApplication_InputArguments = 16273;

        /// <summary>
        /// The identifier for the WellKnownRole_ConfigureAdmin_RemoveApplication_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_ConfigureAdmin_RemoveApplication_InputArguments = 16275;

        /// <summary>
        /// The identifier for the WellKnownRole_ConfigureAdmin_AddEndpoint_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_ConfigureAdmin_AddEndpoint_InputArguments = 16277;

        /// <summary>
        /// The identifier for the WellKnownRole_ConfigureAdmin_RemoveEndpoint_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_ConfigureAdmin_RemoveEndpoint_InputArguments = 16279;

        /// <summary>
        /// The identifier for the WellKnownRole_SecurityAdmin_Identities Variable.
        /// </summary>
        public const uint WellKnownRole_SecurityAdmin_Identities = 16258;

        /// <summary>
        /// The identifier for the WellKnownRole_SecurityAdmin_Applications Variable.
        /// </summary>
        public const uint WellKnownRole_SecurityAdmin_Applications = 16259;

        /// <summary>
        /// The identifier for the WellKnownRole_SecurityAdmin_ApplicationsExclude Variable.
        /// </summary>
        public const uint WellKnownRole_SecurityAdmin_ApplicationsExclude = 15430;

        /// <summary>
        /// The identifier for the WellKnownRole_SecurityAdmin_Endpoints Variable.
        /// </summary>
        public const uint WellKnownRole_SecurityAdmin_Endpoints = 16260;

        /// <summary>
        /// The identifier for the WellKnownRole_SecurityAdmin_EndpointsExclude Variable.
        /// </summary>
        public const uint WellKnownRole_SecurityAdmin_EndpointsExclude = 15527;

        /// <summary>
        /// The identifier for the WellKnownRole_SecurityAdmin_AddIdentity_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_SecurityAdmin_AddIdentity_InputArguments = 15709;

        /// <summary>
        /// The identifier for the WellKnownRole_SecurityAdmin_RemoveIdentity_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_SecurityAdmin_RemoveIdentity_InputArguments = 15711;

        /// <summary>
        /// The identifier for the WellKnownRole_SecurityAdmin_AddApplication_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_SecurityAdmin_AddApplication_InputArguments = 16262;

        /// <summary>
        /// The identifier for the WellKnownRole_SecurityAdmin_RemoveApplication_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_SecurityAdmin_RemoveApplication_InputArguments = 16264;

        /// <summary>
        /// The identifier for the WellKnownRole_SecurityAdmin_AddEndpoint_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_SecurityAdmin_AddEndpoint_InputArguments = 16266;

        /// <summary>
        /// The identifier for the WellKnownRole_SecurityAdmin_RemoveEndpoint_InputArguments Variable.
        /// </summary>
        public const uint WellKnownRole_SecurityAdmin_RemoveEndpoint_InputArguments = 16268;

        /// <summary>
        /// The identifier for the CurrencyUnit Variable.
        /// </summary>
        public const uint CurrencyUnit = 23501;

        /// <summary>
        /// The identifier for the IOrderedObjectType_NumberInList Variable.
        /// </summary>
        public const uint IOrderedObjectType_NumberInList = 23517;

        /// <summary>
        /// The identifier for the OrderedListType_OrderedObject_Placeholder_NumberInList Variable.
        /// </summary>
        public const uint OrderedListType_OrderedObject_Placeholder_NumberInList = 23521;

        /// <summary>
        /// The identifier for the OrderedListType_NodeVersion Variable.
        /// </summary>
        public const uint OrderedListType_NodeVersion = 23525;

        /// <summary>
        /// The identifier for the DataItemType_Definition Variable.
        /// </summary>
        public const uint DataItemType_Definition = 2366;

        /// <summary>
        /// The identifier for the DataItemType_ValuePrecision Variable.
        /// </summary>
        public const uint DataItemType_ValuePrecision = 2367;

        /// <summary>
        /// The identifier for the BaseAnalogType_InstrumentRange Variable.
        /// </summary>
        public const uint BaseAnalogType_InstrumentRange = 17567;

        /// <summary>
        /// The identifier for the BaseAnalogType_EURange Variable.
        /// </summary>
        public const uint BaseAnalogType_EURange = 17568;

        /// <summary>
        /// The identifier for the BaseAnalogType_EngineeringUnits Variable.
        /// </summary>
        public const uint BaseAnalogType_EngineeringUnits = 17569;

        /// <summary>
        /// The identifier for the AnalogItemType_EURange Variable.
        /// </summary>
        public const uint AnalogItemType_EURange = 2369;

        /// <summary>
        /// The identifier for the AnalogUnitType_EngineeringUnits Variable.
        /// </summary>
        public const uint AnalogUnitType_EngineeringUnits = 17502;

        /// <summary>
        /// The identifier for the AnalogUnitRangeType_EngineeringUnits Variable.
        /// </summary>
        public const uint AnalogUnitRangeType_EngineeringUnits = 17575;

        /// <summary>
        /// The identifier for the TwoStateDiscreteType_FalseState Variable.
        /// </summary>
        public const uint TwoStateDiscreteType_FalseState = 2374;

        /// <summary>
        /// The identifier for the TwoStateDiscreteType_TrueState Variable.
        /// </summary>
        public const uint TwoStateDiscreteType_TrueState = 2375;

        /// <summary>
        /// The identifier for the MultiStateDiscreteType_EnumStrings Variable.
        /// </summary>
        public const uint MultiStateDiscreteType_EnumStrings = 2377;

        /// <summary>
        /// The identifier for the MultiStateValueDiscreteType_EnumValues Variable.
        /// </summary>
        public const uint MultiStateValueDiscreteType_EnumValues = 11241;

        /// <summary>
        /// The identifier for the MultiStateValueDiscreteType_ValueAsText Variable.
        /// </summary>
        public const uint MultiStateValueDiscreteType_ValueAsText = 11461;

        /// <summary>
        /// The identifier for the ArrayItemType_InstrumentRange Variable.
        /// </summary>
        public const uint ArrayItemType_InstrumentRange = 12024;

        /// <summary>
        /// The identifier for the ArrayItemType_EURange Variable.
        /// </summary>
        public const uint ArrayItemType_EURange = 12025;

        /// <summary>
        /// The identifier for the ArrayItemType_EngineeringUnits Variable.
        /// </summary>
        public const uint ArrayItemType_EngineeringUnits = 12026;

        /// <summary>
        /// The identifier for the ArrayItemType_Title Variable.
        /// </summary>
        public const uint ArrayItemType_Title = 12027;

        /// <summary>
        /// The identifier for the ArrayItemType_AxisScaleType Variable.
        /// </summary>
        public const uint ArrayItemType_AxisScaleType = 12028;

        /// <summary>
        /// The identifier for the YArrayItemType_XAxisDefinition Variable.
        /// </summary>
        public const uint YArrayItemType_XAxisDefinition = 12037;

        /// <summary>
        /// The identifier for the XYArrayItemType_XAxisDefinition Variable.
        /// </summary>
        public const uint XYArrayItemType_XAxisDefinition = 12046;

        /// <summary>
        /// The identifier for the ImageItemType_XAxisDefinition Variable.
        /// </summary>
        public const uint ImageItemType_XAxisDefinition = 12055;

        /// <summary>
        /// The identifier for the ImageItemType_YAxisDefinition Variable.
        /// </summary>
        public const uint ImageItemType_YAxisDefinition = 12056;

        /// <summary>
        /// The identifier for the CubeItemType_XAxisDefinition Variable.
        /// </summary>
        public const uint CubeItemType_XAxisDefinition = 12065;

        /// <summary>
        /// The identifier for the CubeItemType_YAxisDefinition Variable.
        /// </summary>
        public const uint CubeItemType_YAxisDefinition = 12066;

        /// <summary>
        /// The identifier for the CubeItemType_ZAxisDefinition Variable.
        /// </summary>
        public const uint CubeItemType_ZAxisDefinition = 12067;

        /// <summary>
        /// The identifier for the NDimensionArrayItemType_AxisDefinition Variable.
        /// </summary>
        public const uint NDimensionArrayItemType_AxisDefinition = 12076;

        /// <summary>
        /// The identifier for the TwoStateVariableType_Id Variable.
        /// </summary>
        public const uint TwoStateVariableType_Id = 8996;

        /// <summary>
        /// The identifier for the TwoStateVariableType_TransitionTime Variable.
        /// </summary>
        public const uint TwoStateVariableType_TransitionTime = 9000;

        /// <summary>
        /// The identifier for the TwoStateVariableType_EffectiveTransitionTime Variable.
        /// </summary>
        public const uint TwoStateVariableType_EffectiveTransitionTime = 9001;

        /// <summary>
        /// The identifier for the TwoStateVariableType_TrueState Variable.
        /// </summary>
        public const uint TwoStateVariableType_TrueState = 11110;

        /// <summary>
        /// The identifier for the TwoStateVariableType_FalseState Variable.
        /// </summary>
        public const uint TwoStateVariableType_FalseState = 11111;

        /// <summary>
        /// The identifier for the ConditionVariableType_SourceTimestamp Variable.
        /// </summary>
        public const uint ConditionVariableType_SourceTimestamp = 9003;

        /// <summary>
        /// The identifier for the ConditionType_ConditionClassId Variable.
        /// </summary>
        public const uint ConditionType_ConditionClassId = 11112;

        /// <summary>
        /// The identifier for the ConditionType_ConditionClassName Variable.
        /// </summary>
        public const uint ConditionType_ConditionClassName = 11113;

        /// <summary>
        /// The identifier for the ConditionType_ConditionSubClassId Variable.
        /// </summary>
        public const uint ConditionType_ConditionSubClassId = 16363;

        /// <summary>
        /// The identifier for the ConditionType_ConditionSubClassName Variable.
        /// </summary>
        public const uint ConditionType_ConditionSubClassName = 16364;

        /// <summary>
        /// The identifier for the ConditionType_ConditionName Variable.
        /// </summary>
        public const uint ConditionType_ConditionName = 9009;

        /// <summary>
        /// The identifier for the ConditionType_BranchId Variable.
        /// </summary>
        public const uint ConditionType_BranchId = 9010;

        /// <summary>
        /// The identifier for the ConditionType_Retain Variable.
        /// </summary>
        public const uint ConditionType_Retain = 3874;

        /// <summary>
        /// The identifier for the ConditionType_EnabledState Variable.
        /// </summary>
        public const uint ConditionType_EnabledState = 9011;

        /// <summary>
        /// The identifier for the ConditionType_EnabledState_Id Variable.
        /// </summary>
        public const uint ConditionType_EnabledState_Id = 9012;

        /// <summary>
        /// The identifier for the ConditionType_EnabledState_EffectiveDisplayName Variable.
        /// </summary>
        public const uint ConditionType_EnabledState_EffectiveDisplayName = 9015;

        /// <summary>
        /// The identifier for the ConditionType_EnabledState_TransitionTime Variable.
        /// </summary>
        public const uint ConditionType_EnabledState_TransitionTime = 9016;

        /// <summary>
        /// The identifier for the ConditionType_EnabledState_EffectiveTransitionTime Variable.
        /// </summary>
        public const uint ConditionType_EnabledState_EffectiveTransitionTime = 9017;

        /// <summary>
        /// The identifier for the ConditionType_EnabledState_TrueState Variable.
        /// </summary>
        public const uint ConditionType_EnabledState_TrueState = 9018;

        /// <summary>
        /// The identifier for the ConditionType_EnabledState_FalseState Variable.
        /// </summary>
        public const uint ConditionType_EnabledState_FalseState = 9019;

        /// <summary>
        /// The identifier for the ConditionType_Quality Variable.
        /// </summary>
        public const uint ConditionType_Quality = 9020;

        /// <summary>
        /// The identifier for the ConditionType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint ConditionType_Quality_SourceTimestamp = 9021;

        /// <summary>
        /// The identifier for the ConditionType_LastSeverity Variable.
        /// </summary>
        public const uint ConditionType_LastSeverity = 9022;

        /// <summary>
        /// The identifier for the ConditionType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint ConditionType_LastSeverity_SourceTimestamp = 9023;

        /// <summary>
        /// The identifier for the ConditionType_Comment Variable.
        /// </summary>
        public const uint ConditionType_Comment = 9024;

        /// <summary>
        /// The identifier for the ConditionType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint ConditionType_Comment_SourceTimestamp = 9025;

        /// <summary>
        /// The identifier for the ConditionType_ClientUserId Variable.
        /// </summary>
        public const uint ConditionType_ClientUserId = 9026;

        /// <summary>
        /// The identifier for the ConditionType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint ConditionType_AddComment_InputArguments = 9030;

        /// <summary>
        /// The identifier for the ConditionType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint ConditionType_ConditionRefresh_InputArguments = 3876;

        /// <summary>
        /// The identifier for the ConditionType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint ConditionType_ConditionRefresh2_InputArguments = 12913;

        /// <summary>
        /// The identifier for the DialogConditionType_EnabledState Variable.
        /// </summary>
        public const uint DialogConditionType_EnabledState = 9035;

        /// <summary>
        /// The identifier for the DialogConditionType_EnabledState_Id Variable.
        /// </summary>
        public const uint DialogConditionType_EnabledState_Id = 9036;

        /// <summary>
        /// The identifier for the DialogConditionType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint DialogConditionType_Quality_SourceTimestamp = 9045;

        /// <summary>
        /// The identifier for the DialogConditionType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint DialogConditionType_LastSeverity_SourceTimestamp = 9047;

        /// <summary>
        /// The identifier for the DialogConditionType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint DialogConditionType_Comment_SourceTimestamp = 9049;

        /// <summary>
        /// The identifier for the DialogConditionType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint DialogConditionType_AddComment_InputArguments = 9054;

        /// <summary>
        /// The identifier for the DialogConditionType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint DialogConditionType_ConditionRefresh_InputArguments = 4199;

        /// <summary>
        /// The identifier for the DialogConditionType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint DialogConditionType_ConditionRefresh2_InputArguments = 12917;

        /// <summary>
        /// The identifier for the DialogConditionType_DialogState Variable.
        /// </summary>
        public const uint DialogConditionType_DialogState = 9055;

        /// <summary>
        /// The identifier for the DialogConditionType_DialogState_Id Variable.
        /// </summary>
        public const uint DialogConditionType_DialogState_Id = 9056;

        /// <summary>
        /// The identifier for the DialogConditionType_DialogState_TransitionTime Variable.
        /// </summary>
        public const uint DialogConditionType_DialogState_TransitionTime = 9060;

        /// <summary>
        /// The identifier for the DialogConditionType_DialogState_TrueState Variable.
        /// </summary>
        public const uint DialogConditionType_DialogState_TrueState = 9062;

        /// <summary>
        /// The identifier for the DialogConditionType_DialogState_FalseState Variable.
        /// </summary>
        public const uint DialogConditionType_DialogState_FalseState = 9063;

        /// <summary>
        /// The identifier for the DialogConditionType_Prompt Variable.
        /// </summary>
        public const uint DialogConditionType_Prompt = 2831;

        /// <summary>
        /// The identifier for the DialogConditionType_ResponseOptionSet Variable.
        /// </summary>
        public const uint DialogConditionType_ResponseOptionSet = 9064;

        /// <summary>
        /// The identifier for the DialogConditionType_DefaultResponse Variable.
        /// </summary>
        public const uint DialogConditionType_DefaultResponse = 9065;

        /// <summary>
        /// The identifier for the DialogConditionType_OkResponse Variable.
        /// </summary>
        public const uint DialogConditionType_OkResponse = 9066;

        /// <summary>
        /// The identifier for the DialogConditionType_CancelResponse Variable.
        /// </summary>
        public const uint DialogConditionType_CancelResponse = 9067;

        /// <summary>
        /// The identifier for the DialogConditionType_LastResponse Variable.
        /// </summary>
        public const uint DialogConditionType_LastResponse = 9068;

        /// <summary>
        /// The identifier for the DialogConditionType_Respond_InputArguments Variable.
        /// </summary>
        public const uint DialogConditionType_Respond_InputArguments = 9070;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_EnabledState Variable.
        /// </summary>
        public const uint AcknowledgeableConditionType_EnabledState = 9073;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_EnabledState_Id Variable.
        /// </summary>
        public const uint AcknowledgeableConditionType_EnabledState_Id = 9074;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint AcknowledgeableConditionType_Quality_SourceTimestamp = 9083;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint AcknowledgeableConditionType_LastSeverity_SourceTimestamp = 9085;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint AcknowledgeableConditionType_Comment_SourceTimestamp = 9087;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint AcknowledgeableConditionType_AddComment_InputArguments = 9092;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint AcknowledgeableConditionType_ConditionRefresh_InputArguments = 5124;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint AcknowledgeableConditionType_ConditionRefresh2_InputArguments = 12919;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_AckedState Variable.
        /// </summary>
        public const uint AcknowledgeableConditionType_AckedState = 9093;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_AckedState_Id Variable.
        /// </summary>
        public const uint AcknowledgeableConditionType_AckedState_Id = 9094;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_AckedState_TransitionTime Variable.
        /// </summary>
        public const uint AcknowledgeableConditionType_AckedState_TransitionTime = 9098;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_AckedState_TrueState Variable.
        /// </summary>
        public const uint AcknowledgeableConditionType_AckedState_TrueState = 9100;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_AckedState_FalseState Variable.
        /// </summary>
        public const uint AcknowledgeableConditionType_AckedState_FalseState = 9101;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_ConfirmedState Variable.
        /// </summary>
        public const uint AcknowledgeableConditionType_ConfirmedState = 9102;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_ConfirmedState_Id Variable.
        /// </summary>
        public const uint AcknowledgeableConditionType_ConfirmedState_Id = 9103;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_ConfirmedState_TransitionTime Variable.
        /// </summary>
        public const uint AcknowledgeableConditionType_ConfirmedState_TransitionTime = 9107;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_ConfirmedState_TrueState Variable.
        /// </summary>
        public const uint AcknowledgeableConditionType_ConfirmedState_TrueState = 9109;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_ConfirmedState_FalseState Variable.
        /// </summary>
        public const uint AcknowledgeableConditionType_ConfirmedState_FalseState = 9110;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint AcknowledgeableConditionType_Acknowledge_InputArguments = 9112;

        /// <summary>
        /// The identifier for the AcknowledgeableConditionType_Confirm_InputArguments Variable.
        /// </summary>
        public const uint AcknowledgeableConditionType_Confirm_InputArguments = 9114;

        /// <summary>
        /// The identifier for the AlarmConditionType_EnabledState Variable.
        /// </summary>
        public const uint AlarmConditionType_EnabledState = 9118;

        /// <summary>
        /// The identifier for the AlarmConditionType_EnabledState_Id Variable.
        /// </summary>
        public const uint AlarmConditionType_EnabledState_Id = 9119;

        /// <summary>
        /// The identifier for the AlarmConditionType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint AlarmConditionType_Quality_SourceTimestamp = 9128;

        /// <summary>
        /// The identifier for the AlarmConditionType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint AlarmConditionType_LastSeverity_SourceTimestamp = 9130;

        /// <summary>
        /// The identifier for the AlarmConditionType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint AlarmConditionType_Comment_SourceTimestamp = 9132;

        /// <summary>
        /// The identifier for the AlarmConditionType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint AlarmConditionType_AddComment_InputArguments = 9137;

        /// <summary>
        /// The identifier for the AlarmConditionType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint AlarmConditionType_ConditionRefresh_InputArguments = 5551;

        /// <summary>
        /// The identifier for the AlarmConditionType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint AlarmConditionType_ConditionRefresh2_InputArguments = 12985;

        /// <summary>
        /// The identifier for the AlarmConditionType_AckedState_Id Variable.
        /// </summary>
        public const uint AlarmConditionType_AckedState_Id = 9139;

        /// <summary>
        /// The identifier for the AlarmConditionType_ConfirmedState_Id Variable.
        /// </summary>
        public const uint AlarmConditionType_ConfirmedState_Id = 9148;

        /// <summary>
        /// The identifier for the AlarmConditionType_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint AlarmConditionType_Acknowledge_InputArguments = 9157;

        /// <summary>
        /// The identifier for the AlarmConditionType_Confirm_InputArguments Variable.
        /// </summary>
        public const uint AlarmConditionType_Confirm_InputArguments = 9159;

        /// <summary>
        /// The identifier for the AlarmConditionType_ActiveState Variable.
        /// </summary>
        public const uint AlarmConditionType_ActiveState = 9160;

        /// <summary>
        /// The identifier for the AlarmConditionType_ActiveState_Id Variable.
        /// </summary>
        public const uint AlarmConditionType_ActiveState_Id = 9161;

        /// <summary>
        /// The identifier for the AlarmConditionType_ActiveState_EffectiveDisplayName Variable.
        /// </summary>
        public const uint AlarmConditionType_ActiveState_EffectiveDisplayName = 9164;

        /// <summary>
        /// The identifier for the AlarmConditionType_ActiveState_TransitionTime Variable.
        /// </summary>
        public const uint AlarmConditionType_ActiveState_TransitionTime = 9165;

        /// <summary>
        /// The identifier for the AlarmConditionType_ActiveState_EffectiveTransitionTime Variable.
        /// </summary>
        public const uint AlarmConditionType_ActiveState_EffectiveTransitionTime = 9166;

        /// <summary>
        /// The identifier for the AlarmConditionType_ActiveState_TrueState Variable.
        /// </summary>
        public const uint AlarmConditionType_ActiveState_TrueState = 9167;

        /// <summary>
        /// The identifier for the AlarmConditionType_ActiveState_FalseState Variable.
        /// </summary>
        public const uint AlarmConditionType_ActiveState_FalseState = 9168;

        /// <summary>
        /// The identifier for the AlarmConditionType_InputNode Variable.
        /// </summary>
        public const uint AlarmConditionType_InputNode = 11120;

        /// <summary>
        /// The identifier for the AlarmConditionType_SuppressedState Variable.
        /// </summary>
        public const uint AlarmConditionType_SuppressedState = 9169;

        /// <summary>
        /// The identifier for the AlarmConditionType_SuppressedState_Id Variable.
        /// </summary>
        public const uint AlarmConditionType_SuppressedState_Id = 9170;

        /// <summary>
        /// The identifier for the AlarmConditionType_SuppressedState_TransitionTime Variable.
        /// </summary>
        public const uint AlarmConditionType_SuppressedState_TransitionTime = 9174;

        /// <summary>
        /// The identifier for the AlarmConditionType_SuppressedState_TrueState Variable.
        /// </summary>
        public const uint AlarmConditionType_SuppressedState_TrueState = 9176;

        /// <summary>
        /// The identifier for the AlarmConditionType_SuppressedState_FalseState Variable.
        /// </summary>
        public const uint AlarmConditionType_SuppressedState_FalseState = 9177;

        /// <summary>
        /// The identifier for the AlarmConditionType_OutOfServiceState Variable.
        /// </summary>
        public const uint AlarmConditionType_OutOfServiceState = 16371;

        /// <summary>
        /// The identifier for the AlarmConditionType_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint AlarmConditionType_OutOfServiceState_Id = 16372;

        /// <summary>
        /// The identifier for the AlarmConditionType_OutOfServiceState_TransitionTime Variable.
        /// </summary>
        public const uint AlarmConditionType_OutOfServiceState_TransitionTime = 16376;

        /// <summary>
        /// The identifier for the AlarmConditionType_OutOfServiceState_TrueState Variable.
        /// </summary>
        public const uint AlarmConditionType_OutOfServiceState_TrueState = 16378;

        /// <summary>
        /// The identifier for the AlarmConditionType_OutOfServiceState_FalseState Variable.
        /// </summary>
        public const uint AlarmConditionType_OutOfServiceState_FalseState = 16379;

        /// <summary>
        /// The identifier for the AlarmConditionType_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint AlarmConditionType_ShelvingState_CurrentState = 9179;

        /// <summary>
        /// The identifier for the AlarmConditionType_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint AlarmConditionType_ShelvingState_CurrentState_Id = 9180;

        /// <summary>
        /// The identifier for the AlarmConditionType_ShelvingState_LastTransition Variable.
        /// </summary>
        public const uint AlarmConditionType_ShelvingState_LastTransition = 9184;

        /// <summary>
        /// The identifier for the AlarmConditionType_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint AlarmConditionType_ShelvingState_LastTransition_Id = 9185;

        /// <summary>
        /// The identifier for the AlarmConditionType_ShelvingState_LastTransition_TransitionTime Variable.
        /// </summary>
        public const uint AlarmConditionType_ShelvingState_LastTransition_TransitionTime = 9188;

        /// <summary>
        /// The identifier for the AlarmConditionType_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint AlarmConditionType_ShelvingState_UnshelveTime = 9189;

        /// <summary>
        /// The identifier for the AlarmConditionType_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint AlarmConditionType_ShelvingState_TimedShelve_InputArguments = 9214;

        /// <summary>
        /// The identifier for the AlarmConditionType_SuppressedOrShelved Variable.
        /// </summary>
        public const uint AlarmConditionType_SuppressedOrShelved = 9215;

        /// <summary>
        /// The identifier for the AlarmConditionType_MaxTimeShelved Variable.
        /// </summary>
        public const uint AlarmConditionType_MaxTimeShelved = 9216;

        /// <summary>
        /// The identifier for the AlarmConditionType_AudibleEnabled Variable.
        /// </summary>
        public const uint AlarmConditionType_AudibleEnabled = 16389;

        /// <summary>
        /// The identifier for the AlarmConditionType_AudibleSound Variable.
        /// </summary>
        public const uint AlarmConditionType_AudibleSound = 16390;

        /// <summary>
        /// The identifier for the AlarmConditionType_SilenceState Variable.
        /// </summary>
        public const uint AlarmConditionType_SilenceState = 16380;

        /// <summary>
        /// The identifier for the AlarmConditionType_SilenceState_Id Variable.
        /// </summary>
        public const uint AlarmConditionType_SilenceState_Id = 16381;

        /// <summary>
        /// The identifier for the AlarmConditionType_SilenceState_TransitionTime Variable.
        /// </summary>
        public const uint AlarmConditionType_SilenceState_TransitionTime = 16385;

        /// <summary>
        /// The identifier for the AlarmConditionType_SilenceState_TrueState Variable.
        /// </summary>
        public const uint AlarmConditionType_SilenceState_TrueState = 16387;

        /// <summary>
        /// The identifier for the AlarmConditionType_SilenceState_FalseState Variable.
        /// </summary>
        public const uint AlarmConditionType_SilenceState_FalseState = 16388;

        /// <summary>
        /// The identifier for the AlarmConditionType_OnDelay Variable.
        /// </summary>
        public const uint AlarmConditionType_OnDelay = 16395;

        /// <summary>
        /// The identifier for the AlarmConditionType_OffDelay Variable.
        /// </summary>
        public const uint AlarmConditionType_OffDelay = 16396;

        /// <summary>
        /// The identifier for the AlarmConditionType_FirstInGroupFlag Variable.
        /// </summary>
        public const uint AlarmConditionType_FirstInGroupFlag = 16397;

        /// <summary>
        /// The identifier for the AlarmConditionType_LatchedState Variable.
        /// </summary>
        public const uint AlarmConditionType_LatchedState = 18190;

        /// <summary>
        /// The identifier for the AlarmConditionType_LatchedState_Id Variable.
        /// </summary>
        public const uint AlarmConditionType_LatchedState_Id = 18191;

        /// <summary>
        /// The identifier for the AlarmConditionType_LatchedState_TransitionTime Variable.
        /// </summary>
        public const uint AlarmConditionType_LatchedState_TransitionTime = 18195;

        /// <summary>
        /// The identifier for the AlarmConditionType_LatchedState_TrueState Variable.
        /// </summary>
        public const uint AlarmConditionType_LatchedState_TrueState = 18197;

        /// <summary>
        /// The identifier for the AlarmConditionType_LatchedState_FalseState Variable.
        /// </summary>
        public const uint AlarmConditionType_LatchedState_FalseState = 18198;

        /// <summary>
        /// The identifier for the AlarmConditionType_ReAlarmTime Variable.
        /// </summary>
        public const uint AlarmConditionType_ReAlarmTime = 16400;

        /// <summary>
        /// The identifier for the AlarmConditionType_ReAlarmRepeatCount Variable.
        /// </summary>
        public const uint AlarmConditionType_ReAlarmRepeatCount = 16401;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_EventId Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_EventId = 16407;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_EventType Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_EventType = 16408;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_SourceNode Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_SourceNode = 16409;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_SourceName Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_SourceName = 16410;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_Time Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Time = 16411;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_ReceiveTime Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ReceiveTime = 16412;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_Message Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Message = 16414;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_Severity Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Severity = 16415;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionClassId Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionClassId = 16416;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionClassName Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionClassName = 16417;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionName Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionName = 16420;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_BranchId Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_BranchId = 16421;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_Retain Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Retain = 16422;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState = 16423;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_Id Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_Id = 16424;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_Quality Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Quality = 16432;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Quality_SourceTimestamp = 16433;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_LastSeverity Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_LastSeverity = 16434;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_LastSeverity_SourceTimestamp = 16435;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_Comment Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Comment = 16436;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Comment_SourceTimestamp = 16437;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_ClientUserId Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ClientUserId = 16438;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment_InputArguments Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment_InputArguments = 16442;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState = 16443;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_Id Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_Id = 16444;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_Id Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_Id = 16453;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge_InputArguments = 16462;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_Confirm_InputArguments Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_Confirm_InputArguments = 16464;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState = 16465;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_Id Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_Id = 16466;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_InputNode Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_InputNode = 16474;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_Id Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_Id = 16476;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_Id = 16485;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState = 16503;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_Id = 16504;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_Id = 16509;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_UnshelveTime = 16514;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve_InputArguments = 16518;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedOrShelved Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedOrShelved = 16519;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_Id Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_Id = 16494;

        /// <summary>
        /// The identifier for the AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState_Id Variable.
        /// </summary>
        public const uint AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState_Id = 18204;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_CurrentState_Id Variable.
        /// </summary>
        public const uint ShelvedStateMachineType_CurrentState_Id = 6089;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_LastTransition_Id Variable.
        /// </summary>
        public const uint ShelvedStateMachineType_LastTransition_Id = 6094;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_UnshelveTime Variable.
        /// </summary>
        public const uint ShelvedStateMachineType_UnshelveTime = 9115;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_Unshelved_StateNumber Variable.
        /// </summary>
        public const uint ShelvedStateMachineType_Unshelved_StateNumber = 6098;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_TimedShelved_StateNumber Variable.
        /// </summary>
        public const uint ShelvedStateMachineType_TimedShelved_StateNumber = 6100;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_OneShotShelved_StateNumber Variable.
        /// </summary>
        public const uint ShelvedStateMachineType_OneShotShelved_StateNumber = 6101;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_UnshelvedToTimedShelved_TransitionNumber Variable.
        /// </summary>
        public const uint ShelvedStateMachineType_UnshelvedToTimedShelved_TransitionNumber = 11322;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_UnshelvedToOneShotShelved_TransitionNumber Variable.
        /// </summary>
        public const uint ShelvedStateMachineType_UnshelvedToOneShotShelved_TransitionNumber = 11323;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_TimedShelvedToUnshelved_TransitionNumber Variable.
        /// </summary>
        public const uint ShelvedStateMachineType_TimedShelvedToUnshelved_TransitionNumber = 11324;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_TimedShelvedToOneShotShelved_TransitionNumber Variable.
        /// </summary>
        public const uint ShelvedStateMachineType_TimedShelvedToOneShotShelved_TransitionNumber = 11325;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_OneShotShelvedToUnshelved_TransitionNumber Variable.
        /// </summary>
        public const uint ShelvedStateMachineType_OneShotShelvedToUnshelved_TransitionNumber = 11326;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_OneShotShelvedToTimedShelved_TransitionNumber Variable.
        /// </summary>
        public const uint ShelvedStateMachineType_OneShotShelvedToTimedShelved_TransitionNumber = 11327;

        /// <summary>
        /// The identifier for the ShelvedStateMachineType_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint ShelvedStateMachineType_TimedShelve_InputArguments = 2991;

        /// <summary>
        /// The identifier for the LimitAlarmType_EnabledState_Id Variable.
        /// </summary>
        public const uint LimitAlarmType_EnabledState_Id = 9220;

        /// <summary>
        /// The identifier for the LimitAlarmType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint LimitAlarmType_Quality_SourceTimestamp = 9229;

        /// <summary>
        /// The identifier for the LimitAlarmType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint LimitAlarmType_LastSeverity_SourceTimestamp = 9231;

        /// <summary>
        /// The identifier for the LimitAlarmType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint LimitAlarmType_Comment_SourceTimestamp = 9233;

        /// <summary>
        /// The identifier for the LimitAlarmType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint LimitAlarmType_AddComment_InputArguments = 9238;

        /// <summary>
        /// The identifier for the LimitAlarmType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint LimitAlarmType_ConditionRefresh_InputArguments = 6127;

        /// <summary>
        /// The identifier for the LimitAlarmType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint LimitAlarmType_ConditionRefresh2_InputArguments = 12987;

        /// <summary>
        /// The identifier for the LimitAlarmType_AckedState_Id Variable.
        /// </summary>
        public const uint LimitAlarmType_AckedState_Id = 9240;

        /// <summary>
        /// The identifier for the LimitAlarmType_ConfirmedState_Id Variable.
        /// </summary>
        public const uint LimitAlarmType_ConfirmedState_Id = 9249;

        /// <summary>
        /// The identifier for the LimitAlarmType_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint LimitAlarmType_Acknowledge_InputArguments = 9258;

        /// <summary>
        /// The identifier for the LimitAlarmType_Confirm_InputArguments Variable.
        /// </summary>
        public const uint LimitAlarmType_Confirm_InputArguments = 9260;

        /// <summary>
        /// The identifier for the LimitAlarmType_ActiveState_Id Variable.
        /// </summary>
        public const uint LimitAlarmType_ActiveState_Id = 9262;

        /// <summary>
        /// The identifier for the LimitAlarmType_SuppressedState_Id Variable.
        /// </summary>
        public const uint LimitAlarmType_SuppressedState_Id = 9271;

        /// <summary>
        /// The identifier for the LimitAlarmType_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint LimitAlarmType_OutOfServiceState_Id = 16539;

        /// <summary>
        /// The identifier for the LimitAlarmType_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint LimitAlarmType_ShelvingState_CurrentState = 9280;

        /// <summary>
        /// The identifier for the LimitAlarmType_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint LimitAlarmType_ShelvingState_CurrentState_Id = 9281;

        /// <summary>
        /// The identifier for the LimitAlarmType_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint LimitAlarmType_ShelvingState_LastTransition_Id = 9286;

        /// <summary>
        /// The identifier for the LimitAlarmType_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint LimitAlarmType_ShelvingState_UnshelveTime = 9290;

        /// <summary>
        /// The identifier for the LimitAlarmType_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint LimitAlarmType_ShelvingState_TimedShelve_InputArguments = 9315;

        /// <summary>
        /// The identifier for the LimitAlarmType_SilenceState_Id Variable.
        /// </summary>
        public const uint LimitAlarmType_SilenceState_Id = 16548;

        /// <summary>
        /// The identifier for the LimitAlarmType_LatchedState_Id Variable.
        /// </summary>
        public const uint LimitAlarmType_LatchedState_Id = 18214;

        /// <summary>
        /// The identifier for the LimitAlarmType_HighHighLimit Variable.
        /// </summary>
        public const uint LimitAlarmType_HighHighLimit = 11124;

        /// <summary>
        /// The identifier for the LimitAlarmType_HighLimit Variable.
        /// </summary>
        public const uint LimitAlarmType_HighLimit = 11125;

        /// <summary>
        /// The identifier for the LimitAlarmType_LowLimit Variable.
        /// </summary>
        public const uint LimitAlarmType_LowLimit = 11126;

        /// <summary>
        /// The identifier for the LimitAlarmType_LowLowLimit Variable.
        /// </summary>
        public const uint LimitAlarmType_LowLowLimit = 11127;

        /// <summary>
        /// The identifier for the LimitAlarmType_BaseHighHighLimit Variable.
        /// </summary>
        public const uint LimitAlarmType_BaseHighHighLimit = 16572;

        /// <summary>
        /// The identifier for the LimitAlarmType_BaseHighLimit Variable.
        /// </summary>
        public const uint LimitAlarmType_BaseHighLimit = 16573;

        /// <summary>
        /// The identifier for the LimitAlarmType_BaseLowLimit Variable.
        /// </summary>
        public const uint LimitAlarmType_BaseLowLimit = 16574;

        /// <summary>
        /// The identifier for the LimitAlarmType_BaseLowLowLimit Variable.
        /// </summary>
        public const uint LimitAlarmType_BaseLowLowLimit = 16575;

        /// <summary>
        /// The identifier for the ExclusiveLimitStateMachineType_CurrentState_Id Variable.
        /// </summary>
        public const uint ExclusiveLimitStateMachineType_CurrentState_Id = 9320;

        /// <summary>
        /// The identifier for the ExclusiveLimitStateMachineType_LastTransition_Id Variable.
        /// </summary>
        public const uint ExclusiveLimitStateMachineType_LastTransition_Id = 9325;

        /// <summary>
        /// The identifier for the ExclusiveLimitStateMachineType_HighHigh_StateNumber Variable.
        /// </summary>
        public const uint ExclusiveLimitStateMachineType_HighHigh_StateNumber = 9330;

        /// <summary>
        /// The identifier for the ExclusiveLimitStateMachineType_High_StateNumber Variable.
        /// </summary>
        public const uint ExclusiveLimitStateMachineType_High_StateNumber = 9332;

        /// <summary>
        /// The identifier for the ExclusiveLimitStateMachineType_Low_StateNumber Variable.
        /// </summary>
        public const uint ExclusiveLimitStateMachineType_Low_StateNumber = 9334;

        /// <summary>
        /// The identifier for the ExclusiveLimitStateMachineType_LowLow_StateNumber Variable.
        /// </summary>
        public const uint ExclusiveLimitStateMachineType_LowLow_StateNumber = 9336;

        /// <summary>
        /// The identifier for the ExclusiveLimitStateMachineType_LowLowToLow_TransitionNumber Variable.
        /// </summary>
        public const uint ExclusiveLimitStateMachineType_LowLowToLow_TransitionNumber = 11340;

        /// <summary>
        /// The identifier for the ExclusiveLimitStateMachineType_LowToLowLow_TransitionNumber Variable.
        /// </summary>
        public const uint ExclusiveLimitStateMachineType_LowToLowLow_TransitionNumber = 11341;

        /// <summary>
        /// The identifier for the ExclusiveLimitStateMachineType_HighHighToHigh_TransitionNumber Variable.
        /// </summary>
        public const uint ExclusiveLimitStateMachineType_HighHighToHigh_TransitionNumber = 11342;

        /// <summary>
        /// The identifier for the ExclusiveLimitStateMachineType_HighToHighHigh_TransitionNumber Variable.
        /// </summary>
        public const uint ExclusiveLimitStateMachineType_HighToHighHigh_TransitionNumber = 11343;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_EnabledState_Id Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_EnabledState_Id = 9355;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_Quality_SourceTimestamp = 9364;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_LastSeverity_SourceTimestamp = 9366;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_Comment_SourceTimestamp = 9368;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_AddComment_InputArguments = 9373;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_ConditionRefresh_InputArguments = 9375;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_ConditionRefresh2_InputArguments = 12989;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_AckedState_Id Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_AckedState_Id = 9377;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_ConfirmedState_Id Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_ConfirmedState_Id = 9386;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_Acknowledge_InputArguments = 9395;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_Confirm_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_Confirm_InputArguments = 9397;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_ActiveState Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_ActiveState = 9398;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_ActiveState_Id Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_ActiveState_Id = 9399;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_SuppressedState_Id Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_SuppressedState_Id = 9408;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_OutOfServiceState_Id = 16579;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_ShelvingState_CurrentState = 9417;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_ShelvingState_CurrentState_Id = 9418;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_ShelvingState_LastTransition_Id = 9423;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_ShelvingState_UnshelveTime = 9427;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments = 9452;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_SilenceState_Id Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_SilenceState_Id = 16588;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_LatchedState_Id Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_LatchedState_Id = 18224;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_LimitState_CurrentState Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_LimitState_CurrentState = 9456;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_LimitState_CurrentState_Id Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_LimitState_CurrentState_Id = 9457;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_LimitState_LastTransition Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_LimitState_LastTransition = 9461;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_LimitState_LastTransition_Id Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_LimitState_LastTransition_Id = 9462;

        /// <summary>
        /// The identifier for the ExclusiveLimitAlarmType_LimitState_LastTransition_TransitionTime Variable.
        /// </summary>
        public const uint ExclusiveLimitAlarmType_LimitState_LastTransition_TransitionTime = 9465;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_EnabledState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_EnabledState_Id = 9920;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_Quality_SourceTimestamp = 9929;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_LastSeverity_SourceTimestamp = 9931;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_Comment_SourceTimestamp = 9933;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_AddComment_InputArguments = 9938;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_ConditionRefresh_InputArguments = 9940;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_ConditionRefresh2_InputArguments = 12991;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_AckedState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_AckedState_Id = 9942;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_ConfirmedState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_ConfirmedState_Id = 9951;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_Acknowledge_InputArguments = 9960;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_Confirm_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_Confirm_InputArguments = 9962;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_ActiveState Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_ActiveState = 9963;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_ActiveState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_ActiveState_Id = 9964;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_SuppressedState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_SuppressedState_Id = 9973;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_OutOfServiceState_Id = 16619;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_ShelvingState_CurrentState = 9982;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Id = 9983;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Id = 9988;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_ShelvingState_UnshelveTime = 9992;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments = 10017;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_SilenceState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_SilenceState_Id = 16628;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_LatchedState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_LatchedState_Id = 18234;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_HighHighState Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_HighHighState = 10020;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_HighHighState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_HighHighState_Id = 10021;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_HighHighState_TransitionTime Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_HighHighState_TransitionTime = 10025;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_HighHighState_TrueState Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_HighHighState_TrueState = 10027;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_HighHighState_FalseState Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_HighHighState_FalseState = 10028;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_HighState Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_HighState = 10029;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_HighState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_HighState_Id = 10030;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_HighState_TransitionTime Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_HighState_TransitionTime = 10034;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_HighState_TrueState Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_HighState_TrueState = 10036;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_HighState_FalseState Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_HighState_FalseState = 10037;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_LowState Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_LowState = 10038;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_LowState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_LowState_Id = 10039;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_LowState_TransitionTime Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_LowState_TransitionTime = 10043;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_LowState_TrueState Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_LowState_TrueState = 10045;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_LowState_FalseState Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_LowState_FalseState = 10046;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_LowLowState Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_LowLowState = 10047;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_LowLowState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_LowLowState_Id = 10048;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_LowLowState_TransitionTime Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_LowLowState_TransitionTime = 10052;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_LowLowState_TrueState Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_LowLowState_TrueState = 10054;

        /// <summary>
        /// The identifier for the NonExclusiveLimitAlarmType_LowLowState_FalseState Variable.
        /// </summary>
        public const uint NonExclusiveLimitAlarmType_LowLowState_FalseState = 10055;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_EnabledState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_EnabledState_Id = 10074;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_Quality_SourceTimestamp = 10083;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_LastSeverity_SourceTimestamp = 10085;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_Comment_SourceTimestamp = 10087;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_AddComment_InputArguments = 10092;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_ConditionRefresh_InputArguments = 10094;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_ConditionRefresh2_InputArguments = 12993;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_AckedState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_AckedState_Id = 10096;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_ConfirmedState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_ConfirmedState_Id = 10105;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_Acknowledge_InputArguments = 10114;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_Confirm_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_Confirm_InputArguments = 10116;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_ActiveState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_ActiveState_Id = 10118;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_SuppressedState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_SuppressedState_Id = 10127;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_OutOfServiceState_Id = 16659;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_ShelvingState_CurrentState = 10136;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Id = 10137;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Id = 10142;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_ShelvingState_UnshelveTime = 10146;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments = 10171;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_SilenceState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_SilenceState_Id = 16668;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_LatchedState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_LatchedState_Id = 18247;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_HighHighState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_HighHighState_Id = 10175;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_HighState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_HighState_Id = 10184;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_LowState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_LowState_Id = 10193;

        /// <summary>
        /// The identifier for the NonExclusiveLevelAlarmType_LowLowState_Id Variable.
        /// </summary>
        public const uint NonExclusiveLevelAlarmType_LowLowState_Id = 10202;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_EnabledState_Id Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_EnabledState_Id = 9496;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_Quality_SourceTimestamp = 9505;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_LastSeverity_SourceTimestamp = 9507;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_Comment_SourceTimestamp = 9509;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_AddComment_InputArguments = 9514;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_ConditionRefresh_InputArguments = 9516;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_ConditionRefresh2_InputArguments = 12995;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_AckedState_Id Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_AckedState_Id = 9518;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_ConfirmedState_Id Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_ConfirmedState_Id = 9527;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_Acknowledge_InputArguments = 9536;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_Confirm_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_Confirm_InputArguments = 9538;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_ActiveState_Id Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_ActiveState_Id = 9540;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_SuppressedState_Id Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_SuppressedState_Id = 9549;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_OutOfServiceState_Id = 16699;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_ShelvingState_CurrentState = 9558;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_ShelvingState_CurrentState_Id = 9559;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_ShelvingState_LastTransition_Id = 9564;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_ShelvingState_UnshelveTime = 9568;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments = 9593;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_SilenceState_Id Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_SilenceState_Id = 16708;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_LatchedState_Id Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_LatchedState_Id = 18258;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_LimitState_CurrentState Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_LimitState_CurrentState = 9597;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_LimitState_CurrentState_Id Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_LimitState_CurrentState_Id = 9598;

        /// <summary>
        /// The identifier for the ExclusiveLevelAlarmType_LimitState_LastTransition_Id Variable.
        /// </summary>
        public const uint ExclusiveLevelAlarmType_LimitState_LastTransition_Id = 9603;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_EnabledState_Id Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_EnabledState_Id = 10382;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_Quality_SourceTimestamp = 10391;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp = 10393;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_Comment_SourceTimestamp = 10395;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_AddComment_InputArguments = 10400;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_ConditionRefresh_InputArguments = 10402;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments = 12997;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_AckedState_Id Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_AckedState_Id = 10404;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_ConfirmedState_Id Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_ConfirmedState_Id = 10413;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_Acknowledge_InputArguments = 10422;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_Confirm_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_Confirm_InputArguments = 10424;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_ActiveState_Id Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_ActiveState_Id = 10426;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_SuppressedState_Id Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_SuppressedState_Id = 10435;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_OutOfServiceState_Id = 16739;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_ShelvingState_CurrentState = 10444;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id = 10445;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id = 10450;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_ShelvingState_UnshelveTime = 10454;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments = 10479;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_SilenceState_Id Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_SilenceState_Id = 16748;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_LatchedState_Id Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_LatchedState_Id = 18268;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_HighHighState_Id Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_HighHighState_Id = 10483;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_HighState_Id Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_HighState_Id = 10492;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_LowState_Id Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_LowState_Id = 10501;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_LowLowState_Id Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_LowLowState_Id = 10510;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_SetpointNode Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_SetpointNode = 10522;

        /// <summary>
        /// The identifier for the NonExclusiveDeviationAlarmType_BaseSetpointNode Variable.
        /// </summary>
        public const uint NonExclusiveDeviationAlarmType_BaseSetpointNode = 16776;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_EnabledState_Id Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_EnabledState_Id = 10228;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp = 10237;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp = 10239;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp = 10241;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_AddComment_InputArguments = 10246;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments = 10248;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments = 13001;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_AckedState_Id Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_AckedState_Id = 10250;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_ConfirmedState_Id Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_ConfirmedState_Id = 10259;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments = 10268;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_Confirm_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_Confirm_InputArguments = 10270;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_ActiveState_Id Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_ActiveState_Id = 10272;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_SuppressedState_Id Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_SuppressedState_Id = 10281;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Id = 16821;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState = 10290;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id = 10291;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id = 10296;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime = 10300;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments = 10325;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_SilenceState_Id Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_SilenceState_Id = 16830;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_LatchedState_Id Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_LatchedState_Id = 18278;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_HighHighState_Id Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_HighHighState_Id = 10329;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_HighState_Id Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_HighState_Id = 10338;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_LowState_Id Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_LowState_Id = 10347;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_LowLowState_Id Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_LowLowState_Id = 10356;

        /// <summary>
        /// The identifier for the NonExclusiveRateOfChangeAlarmType_EngineeringUnits Variable.
        /// </summary>
        public const uint NonExclusiveRateOfChangeAlarmType_EngineeringUnits = 16858;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_EnabledState_Id Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_EnabledState_Id = 9778;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_Quality_SourceTimestamp = 9787;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp = 9789;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_Comment_SourceTimestamp = 9791;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_AddComment_InputArguments = 9796;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_ConditionRefresh_InputArguments = 9798;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments = 12999;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_AckedState_Id Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_AckedState_Id = 9800;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_ConfirmedState_Id Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_ConfirmedState_Id = 9809;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_Acknowledge_InputArguments = 9818;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_Confirm_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_Confirm_InputArguments = 9820;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_ActiveState_Id Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_ActiveState_Id = 9822;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_SuppressedState_Id Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_SuppressedState_Id = 9831;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_OutOfServiceState_Id = 16780;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_ShelvingState_CurrentState = 9840;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id = 9841;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id = 9846;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_ShelvingState_UnshelveTime = 9850;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments = 9875;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_SilenceState_Id Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_SilenceState_Id = 16789;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_LatchedState_Id Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_LatchedState_Id = 18288;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_LimitState_CurrentState Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_LimitState_CurrentState = 9879;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_LimitState_CurrentState_Id Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_LimitState_CurrentState_Id = 9880;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_LimitState_LastTransition_Id Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_LimitState_LastTransition_Id = 9885;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_SetpointNode Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_SetpointNode = 9905;

        /// <summary>
        /// The identifier for the ExclusiveDeviationAlarmType_BaseSetpointNode Variable.
        /// </summary>
        public const uint ExclusiveDeviationAlarmType_BaseSetpointNode = 16817;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_EnabledState_Id Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_EnabledState_Id = 9637;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp = 9646;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp = 9648;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp = 9650;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_AddComment_InputArguments = 9655;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments = 9657;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments = 13003;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_AckedState_Id Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_AckedState_Id = 9659;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_ConfirmedState_Id Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_ConfirmedState_Id = 9668;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments = 9677;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_Confirm_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_Confirm_InputArguments = 9679;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_ActiveState_Id Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_ActiveState_Id = 9681;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_SuppressedState_Id Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_SuppressedState_Id = 9690;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_OutOfServiceState_Id = 16862;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState = 9699;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id = 9700;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id = 9705;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime = 9709;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments = 9734;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_SilenceState_Id Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_SilenceState_Id = 16871;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_LatchedState_Id Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_LatchedState_Id = 18298;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_LimitState_CurrentState Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_LimitState_CurrentState = 9738;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Id Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Id = 9739;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Id Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Id = 9744;

        /// <summary>
        /// The identifier for the ExclusiveRateOfChangeAlarmType_EngineeringUnits Variable.
        /// </summary>
        public const uint ExclusiveRateOfChangeAlarmType_EngineeringUnits = 16899;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_EnabledState_Id Variable.
        /// </summary>
        public const uint DiscreteAlarmType_EnabledState_Id = 10537;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint DiscreteAlarmType_Quality_SourceTimestamp = 10546;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint DiscreteAlarmType_LastSeverity_SourceTimestamp = 10548;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint DiscreteAlarmType_Comment_SourceTimestamp = 10550;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint DiscreteAlarmType_AddComment_InputArguments = 10555;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint DiscreteAlarmType_ConditionRefresh_InputArguments = 10557;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint DiscreteAlarmType_ConditionRefresh2_InputArguments = 13005;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_AckedState_Id Variable.
        /// </summary>
        public const uint DiscreteAlarmType_AckedState_Id = 10559;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_ConfirmedState_Id Variable.
        /// </summary>
        public const uint DiscreteAlarmType_ConfirmedState_Id = 10568;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint DiscreteAlarmType_Acknowledge_InputArguments = 10577;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_Confirm_InputArguments Variable.
        /// </summary>
        public const uint DiscreteAlarmType_Confirm_InputArguments = 10579;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_ActiveState_Id Variable.
        /// </summary>
        public const uint DiscreteAlarmType_ActiveState_Id = 10581;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_SuppressedState_Id Variable.
        /// </summary>
        public const uint DiscreteAlarmType_SuppressedState_Id = 10590;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint DiscreteAlarmType_OutOfServiceState_Id = 16903;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint DiscreteAlarmType_ShelvingState_CurrentState = 10599;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint DiscreteAlarmType_ShelvingState_CurrentState_Id = 10600;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint DiscreteAlarmType_ShelvingState_LastTransition_Id = 10605;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint DiscreteAlarmType_ShelvingState_UnshelveTime = 10609;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint DiscreteAlarmType_ShelvingState_TimedShelve_InputArguments = 10634;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_SilenceState_Id Variable.
        /// </summary>
        public const uint DiscreteAlarmType_SilenceState_Id = 16912;

        /// <summary>
        /// The identifier for the DiscreteAlarmType_LatchedState_Id Variable.
        /// </summary>
        public const uint DiscreteAlarmType_LatchedState_Id = 18308;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_EnabledState_Id Variable.
        /// </summary>
        public const uint OffNormalAlarmType_EnabledState_Id = 10651;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint OffNormalAlarmType_Quality_SourceTimestamp = 10660;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint OffNormalAlarmType_LastSeverity_SourceTimestamp = 10662;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint OffNormalAlarmType_Comment_SourceTimestamp = 10664;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint OffNormalAlarmType_AddComment_InputArguments = 10669;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint OffNormalAlarmType_ConditionRefresh_InputArguments = 10671;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint OffNormalAlarmType_ConditionRefresh2_InputArguments = 13007;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_AckedState_Id Variable.
        /// </summary>
        public const uint OffNormalAlarmType_AckedState_Id = 10673;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_ConfirmedState_Id Variable.
        /// </summary>
        public const uint OffNormalAlarmType_ConfirmedState_Id = 10682;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint OffNormalAlarmType_Acknowledge_InputArguments = 10691;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_Confirm_InputArguments Variable.
        /// </summary>
        public const uint OffNormalAlarmType_Confirm_InputArguments = 10693;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_ActiveState_Id Variable.
        /// </summary>
        public const uint OffNormalAlarmType_ActiveState_Id = 10695;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_SuppressedState_Id Variable.
        /// </summary>
        public const uint OffNormalAlarmType_SuppressedState_Id = 10704;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint OffNormalAlarmType_OutOfServiceState_Id = 16939;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint OffNormalAlarmType_ShelvingState_CurrentState = 10713;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint OffNormalAlarmType_ShelvingState_CurrentState_Id = 10714;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint OffNormalAlarmType_ShelvingState_LastTransition_Id = 10719;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint OffNormalAlarmType_ShelvingState_UnshelveTime = 10723;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint OffNormalAlarmType_ShelvingState_TimedShelve_InputArguments = 10748;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_SilenceState_Id Variable.
        /// </summary>
        public const uint OffNormalAlarmType_SilenceState_Id = 16948;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_LatchedState_Id Variable.
        /// </summary>
        public const uint OffNormalAlarmType_LatchedState_Id = 18318;

        /// <summary>
        /// The identifier for the OffNormalAlarmType_NormalState Variable.
        /// </summary>
        public const uint OffNormalAlarmType_NormalState = 11158;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_EnabledState_Id Variable.
        /// </summary>
        public const uint SystemOffNormalAlarmType_EnabledState_Id = 11769;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint SystemOffNormalAlarmType_Quality_SourceTimestamp = 11778;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint SystemOffNormalAlarmType_LastSeverity_SourceTimestamp = 11780;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint SystemOffNormalAlarmType_Comment_SourceTimestamp = 11782;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint SystemOffNormalAlarmType_AddComment_InputArguments = 11787;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint SystemOffNormalAlarmType_ConditionRefresh_InputArguments = 11789;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint SystemOffNormalAlarmType_ConditionRefresh2_InputArguments = 13009;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_AckedState_Id Variable.
        /// </summary>
        public const uint SystemOffNormalAlarmType_AckedState_Id = 11791;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_ConfirmedState_Id Variable.
        /// </summary>
        public const uint SystemOffNormalAlarmType_ConfirmedState_Id = 11800;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint SystemOffNormalAlarmType_Acknowledge_InputArguments = 11809;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_Confirm_InputArguments Variable.
        /// </summary>
        public const uint SystemOffNormalAlarmType_Confirm_InputArguments = 11811;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_ActiveState_Id Variable.
        /// </summary>
        public const uint SystemOffNormalAlarmType_ActiveState_Id = 11813;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_SuppressedState_Id Variable.
        /// </summary>
        public const uint SystemOffNormalAlarmType_SuppressedState_Id = 11823;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint SystemOffNormalAlarmType_OutOfServiceState_Id = 16975;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint SystemOffNormalAlarmType_ShelvingState_CurrentState = 11832;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint SystemOffNormalAlarmType_ShelvingState_CurrentState_Id = 11833;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint SystemOffNormalAlarmType_ShelvingState_LastTransition_Id = 11838;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint SystemOffNormalAlarmType_ShelvingState_UnshelveTime = 11843;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint SystemOffNormalAlarmType_ShelvingState_TimedShelve_InputArguments = 11847;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_SilenceState_Id Variable.
        /// </summary>
        public const uint SystemOffNormalAlarmType_SilenceState_Id = 16984;

        /// <summary>
        /// The identifier for the SystemOffNormalAlarmType_LatchedState_Id Variable.
        /// </summary>
        public const uint SystemOffNormalAlarmType_LatchedState_Id = 18328;

        /// <summary>
        /// The identifier for the TripAlarmType_EnabledState_Id Variable.
        /// </summary>
        public const uint TripAlarmType_EnabledState_Id = 10765;

        /// <summary>
        /// The identifier for the TripAlarmType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint TripAlarmType_Quality_SourceTimestamp = 10774;

        /// <summary>
        /// The identifier for the TripAlarmType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint TripAlarmType_LastSeverity_SourceTimestamp = 10776;

        /// <summary>
        /// The identifier for the TripAlarmType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint TripAlarmType_Comment_SourceTimestamp = 10778;

        /// <summary>
        /// The identifier for the TripAlarmType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint TripAlarmType_AddComment_InputArguments = 10783;

        /// <summary>
        /// The identifier for the TripAlarmType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint TripAlarmType_ConditionRefresh_InputArguments = 10785;

        /// <summary>
        /// The identifier for the TripAlarmType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint TripAlarmType_ConditionRefresh2_InputArguments = 13011;

        /// <summary>
        /// The identifier for the TripAlarmType_AckedState_Id Variable.
        /// </summary>
        public const uint TripAlarmType_AckedState_Id = 10787;

        /// <summary>
        /// The identifier for the TripAlarmType_ConfirmedState_Id Variable.
        /// </summary>
        public const uint TripAlarmType_ConfirmedState_Id = 10796;

        /// <summary>
        /// The identifier for the TripAlarmType_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint TripAlarmType_Acknowledge_InputArguments = 10805;

        /// <summary>
        /// The identifier for the TripAlarmType_Confirm_InputArguments Variable.
        /// </summary>
        public const uint TripAlarmType_Confirm_InputArguments = 10807;

        /// <summary>
        /// The identifier for the TripAlarmType_ActiveState_Id Variable.
        /// </summary>
        public const uint TripAlarmType_ActiveState_Id = 10809;

        /// <summary>
        /// The identifier for the TripAlarmType_SuppressedState_Id Variable.
        /// </summary>
        public const uint TripAlarmType_SuppressedState_Id = 10818;

        /// <summary>
        /// The identifier for the TripAlarmType_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint TripAlarmType_OutOfServiceState_Id = 17011;

        /// <summary>
        /// The identifier for the TripAlarmType_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint TripAlarmType_ShelvingState_CurrentState = 10827;

        /// <summary>
        /// The identifier for the TripAlarmType_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint TripAlarmType_ShelvingState_CurrentState_Id = 10828;

        /// <summary>
        /// The identifier for the TripAlarmType_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint TripAlarmType_ShelvingState_LastTransition_Id = 10833;

        /// <summary>
        /// The identifier for the TripAlarmType_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint TripAlarmType_ShelvingState_UnshelveTime = 10837;

        /// <summary>
        /// The identifier for the TripAlarmType_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint TripAlarmType_ShelvingState_TimedShelve_InputArguments = 10862;

        /// <summary>
        /// The identifier for the TripAlarmType_SilenceState_Id Variable.
        /// </summary>
        public const uint TripAlarmType_SilenceState_Id = 17020;

        /// <summary>
        /// The identifier for the TripAlarmType_LatchedState_Id Variable.
        /// </summary>
        public const uint TripAlarmType_LatchedState_Id = 18338;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_EnabledState_Id Variable.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_EnabledState_Id = 18365;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_Quality_SourceTimestamp = 18374;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_LastSeverity_SourceTimestamp = 18376;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_Comment_SourceTimestamp = 18378;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_AddComment_InputArguments = 18383;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_ConditionRefresh_InputArguments = 18385;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_ConditionRefresh2_InputArguments = 18387;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_AckedState_Id Variable.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_AckedState_Id = 18389;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_ConfirmedState_Id Variable.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_ConfirmedState_Id = 18398;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_Acknowledge_InputArguments = 18407;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_Confirm_InputArguments Variable.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_Confirm_InputArguments = 18409;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_ActiveState_Id Variable.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_ActiveState_Id = 18411;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_SuppressedState_Id Variable.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_SuppressedState_Id = 18421;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_OutOfServiceState_Id = 18430;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_ShelvingState_CurrentState = 18439;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Id = 18440;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Id = 18445;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_ShelvingState_UnshelveTime = 18452;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve_InputArguments = 18454;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_SilenceState_Id Variable.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_SilenceState_Id = 18465;

        /// <summary>
        /// The identifier for the InstrumentDiagnosticAlarmType_LatchedState_Id Variable.
        /// </summary>
        public const uint InstrumentDiagnosticAlarmType_LatchedState_Id = 18478;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_EnabledState_Id Variable.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_EnabledState_Id = 18514;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_Quality_SourceTimestamp = 18523;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_LastSeverity_SourceTimestamp = 18525;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_Comment_SourceTimestamp = 18527;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_AddComment_InputArguments = 18532;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_ConditionRefresh_InputArguments = 18534;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_ConditionRefresh2_InputArguments = 18536;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_AckedState_Id Variable.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_AckedState_Id = 18538;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_ConfirmedState_Id Variable.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_ConfirmedState_Id = 18547;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_Acknowledge_InputArguments = 18556;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_Confirm_InputArguments Variable.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_Confirm_InputArguments = 18558;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_ActiveState_Id Variable.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_ActiveState_Id = 18560;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_SuppressedState_Id Variable.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_SuppressedState_Id = 18570;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_OutOfServiceState_Id = 18579;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_ShelvingState_CurrentState = 18588;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_ShelvingState_CurrentState_Id = 18589;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_ShelvingState_LastTransition_Id = 18594;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_ShelvingState_UnshelveTime = 18601;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_ShelvingState_TimedShelve_InputArguments = 18603;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_SilenceState_Id Variable.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_SilenceState_Id = 18614;

        /// <summary>
        /// The identifier for the SystemDiagnosticAlarmType_LatchedState_Id Variable.
        /// </summary>
        public const uint SystemDiagnosticAlarmType_LatchedState_Id = 18627;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_EnabledState_Id Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_EnabledState_Id = 13241;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_Quality_SourceTimestamp = 13250;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_LastSeverity_SourceTimestamp = 13252;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_Comment_SourceTimestamp = 13254;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_AddComment_InputArguments = 13259;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_ConditionRefresh_InputArguments = 13261;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_ConditionRefresh2_InputArguments = 13263;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_AckedState_Id Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_AckedState_Id = 13265;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_ConfirmedState_Id Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_ConfirmedState_Id = 13274;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_Acknowledge_InputArguments = 13283;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_Confirm_InputArguments Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_Confirm_InputArguments = 13285;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_ActiveState_Id Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_ActiveState_Id = 13287;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_SuppressedState_Id Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_SuppressedState_Id = 13297;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_OutOfServiceState_Id = 17047;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_ShelvingState_CurrentState = 13306;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_ShelvingState_CurrentState_Id = 13307;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_ShelvingState_LastTransition_Id = 13312;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_ShelvingState_UnshelveTime = 13317;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_ShelvingState_TimedShelve_InputArguments = 13321;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_SilenceState_Id Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_SilenceState_Id = 17056;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_LatchedState_Id Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_LatchedState_Id = 18646;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_ExpirationDate Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_ExpirationDate = 13325;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_ExpirationLimit Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_ExpirationLimit = 14900;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_CertificateType Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_CertificateType = 13326;

        /// <summary>
        /// The identifier for the CertificateExpirationAlarmType_Certificate Variable.
        /// </summary>
        public const uint CertificateExpirationAlarmType_Certificate = 13327;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_EnabledState_Id Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_EnabledState_Id = 17098;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_Quality_SourceTimestamp = 17107;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_LastSeverity_SourceTimestamp = 17109;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_Comment_SourceTimestamp = 17111;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_AddComment_InputArguments = 17116;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_ConditionRefresh_InputArguments = 17118;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_ConditionRefresh2_InputArguments = 17120;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_AckedState_Id Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_AckedState_Id = 17122;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_ConfirmedState_Id Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_ConfirmedState_Id = 17131;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_Acknowledge_InputArguments = 17140;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_Confirm_InputArguments Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_Confirm_InputArguments = 17142;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_ActiveState_Id Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_ActiveState_Id = 17144;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_SuppressedState_Id Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_SuppressedState_Id = 17154;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_OutOfServiceState_Id = 17163;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_ShelvingState_CurrentState = 17181;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_ShelvingState_CurrentState_Id = 17182;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_ShelvingState_LastTransition_Id = 17187;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_ShelvingState_UnshelveTime = 17192;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_ShelvingState_TimedShelve_InputArguments = 17196;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_SilenceState_Id Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_SilenceState_Id = 17172;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_LatchedState_Id Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_LatchedState_Id = 18656;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_TargetValueNode Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_TargetValueNode = 17215;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_ExpectedTime Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_ExpectedTime = 17216;

        /// <summary>
        /// The identifier for the DiscrepancyAlarmType_Tolerance Variable.
        /// </summary>
        public const uint DiscrepancyAlarmType_Tolerance = 17217;

        /// <summary>
        /// The identifier for the AuditConditionCommentEventType_ConditionEventId Variable.
        /// </summary>
        public const uint AuditConditionCommentEventType_ConditionEventId = 17222;

        /// <summary>
        /// The identifier for the AuditConditionCommentEventType_Comment Variable.
        /// </summary>
        public const uint AuditConditionCommentEventType_Comment = 11851;

        /// <summary>
        /// The identifier for the AuditConditionRespondEventType_SelectedResponse Variable.
        /// </summary>
        public const uint AuditConditionRespondEventType_SelectedResponse = 11852;

        /// <summary>
        /// The identifier for the AuditConditionAcknowledgeEventType_ConditionEventId Variable.
        /// </summary>
        public const uint AuditConditionAcknowledgeEventType_ConditionEventId = 17223;

        /// <summary>
        /// The identifier for the AuditConditionAcknowledgeEventType_Comment Variable.
        /// </summary>
        public const uint AuditConditionAcknowledgeEventType_Comment = 11853;

        /// <summary>
        /// The identifier for the AuditConditionConfirmEventType_ConditionEventId Variable.
        /// </summary>
        public const uint AuditConditionConfirmEventType_ConditionEventId = 17224;

        /// <summary>
        /// The identifier for the AuditConditionConfirmEventType_Comment Variable.
        /// </summary>
        public const uint AuditConditionConfirmEventType_Comment = 11854;

        /// <summary>
        /// The identifier for the AuditConditionShelvingEventType_ShelvingTime Variable.
        /// </summary>
        public const uint AuditConditionShelvingEventType_ShelvingTime = 11855;

        /// <summary>
        /// The identifier for the AlarmMetricsType_AlarmCount Variable.
        /// </summary>
        public const uint AlarmMetricsType_AlarmCount = 17280;

        /// <summary>
        /// The identifier for the AlarmMetricsType_StartTime Variable.
        /// </summary>
        public const uint AlarmMetricsType_StartTime = 17991;

        /// <summary>
        /// The identifier for the AlarmMetricsType_MaximumActiveState Variable.
        /// </summary>
        public const uint AlarmMetricsType_MaximumActiveState = 17281;

        /// <summary>
        /// The identifier for the AlarmMetricsType_MaximumUnAck Variable.
        /// </summary>
        public const uint AlarmMetricsType_MaximumUnAck = 17282;

        /// <summary>
        /// The identifier for the AlarmMetricsType_CurrentAlarmRate Variable.
        /// </summary>
        public const uint AlarmMetricsType_CurrentAlarmRate = 17284;

        /// <summary>
        /// The identifier for the AlarmMetricsType_CurrentAlarmRate_Rate Variable.
        /// </summary>
        public const uint AlarmMetricsType_CurrentAlarmRate_Rate = 17285;

        /// <summary>
        /// The identifier for the AlarmMetricsType_MaximumAlarmRate Variable.
        /// </summary>
        public const uint AlarmMetricsType_MaximumAlarmRate = 17286;

        /// <summary>
        /// The identifier for the AlarmMetricsType_MaximumAlarmRate_Rate Variable.
        /// </summary>
        public const uint AlarmMetricsType_MaximumAlarmRate_Rate = 17287;

        /// <summary>
        /// The identifier for the AlarmMetricsType_MaximumReAlarmCount Variable.
        /// </summary>
        public const uint AlarmMetricsType_MaximumReAlarmCount = 17283;

        /// <summary>
        /// The identifier for the AlarmMetricsType_AverageAlarmRate Variable.
        /// </summary>
        public const uint AlarmMetricsType_AverageAlarmRate = 17288;

        /// <summary>
        /// The identifier for the AlarmMetricsType_AverageAlarmRate_Rate Variable.
        /// </summary>
        public const uint AlarmMetricsType_AverageAlarmRate_Rate = 17289;

        /// <summary>
        /// The identifier for the AlarmRateVariableType_Rate Variable.
        /// </summary>
        public const uint AlarmRateVariableType_Rate = 17278;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_CurrentState Variable.
        /// </summary>
        public const uint ProgramStateMachineType_CurrentState = 3830;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_CurrentState_Id Variable.
        /// </summary>
        public const uint ProgramStateMachineType_CurrentState_Id = 3831;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_CurrentState_Number Variable.
        /// </summary>
        public const uint ProgramStateMachineType_CurrentState_Number = 3833;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_LastTransition Variable.
        /// </summary>
        public const uint ProgramStateMachineType_LastTransition = 3835;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_LastTransition_Id Variable.
        /// </summary>
        public const uint ProgramStateMachineType_LastTransition_Id = 3836;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_LastTransition_Number Variable.
        /// </summary>
        public const uint ProgramStateMachineType_LastTransition_Number = 3838;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_LastTransition_TransitionTime Variable.
        /// </summary>
        public const uint ProgramStateMachineType_LastTransition_TransitionTime = 3839;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_Creatable Variable.
        /// </summary>
        public const uint ProgramStateMachineType_Creatable = 2392;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_Deletable Variable.
        /// </summary>
        public const uint ProgramStateMachineType_Deletable = 2393;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_AutoDelete Variable.
        /// </summary>
        public const uint ProgramStateMachineType_AutoDelete = 2394;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_RecycleCount Variable.
        /// </summary>
        public const uint ProgramStateMachineType_RecycleCount = 2395;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_InstanceCount Variable.
        /// </summary>
        public const uint ProgramStateMachineType_InstanceCount = 2396;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_MaxInstanceCount Variable.
        /// </summary>
        public const uint ProgramStateMachineType_MaxInstanceCount = 2397;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_MaxRecycleCount Variable.
        /// </summary>
        public const uint ProgramStateMachineType_MaxRecycleCount = 2398;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_ProgramDiagnostic Variable.
        /// </summary>
        public const uint ProgramStateMachineType_ProgramDiagnostic = 2399;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_ProgramDiagnostic_CreateSessionId Variable.
        /// </summary>
        public const uint ProgramStateMachineType_ProgramDiagnostic_CreateSessionId = 3840;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_ProgramDiagnostic_CreateClientName Variable.
        /// </summary>
        public const uint ProgramStateMachineType_ProgramDiagnostic_CreateClientName = 3841;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_ProgramDiagnostic_InvocationCreationTime Variable.
        /// </summary>
        public const uint ProgramStateMachineType_ProgramDiagnostic_InvocationCreationTime = 3842;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_ProgramDiagnostic_LastTransitionTime Variable.
        /// </summary>
        public const uint ProgramStateMachineType_ProgramDiagnostic_LastTransitionTime = 3843;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_ProgramDiagnostic_LastMethodCall Variable.
        /// </summary>
        public const uint ProgramStateMachineType_ProgramDiagnostic_LastMethodCall = 3844;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_ProgramDiagnostic_LastMethodSessionId Variable.
        /// </summary>
        public const uint ProgramStateMachineType_ProgramDiagnostic_LastMethodSessionId = 3845;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_ProgramDiagnostic_LastMethodInputArguments Variable.
        /// </summary>
        public const uint ProgramStateMachineType_ProgramDiagnostic_LastMethodInputArguments = 3846;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputArguments Variable.
        /// </summary>
        public const uint ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputArguments = 3847;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_ProgramDiagnostic_LastMethodInputValues Variable.
        /// </summary>
        public const uint ProgramStateMachineType_ProgramDiagnostic_LastMethodInputValues = 15038;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputValues Variable.
        /// </summary>
        public const uint ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputValues = 15040;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_ProgramDiagnostic_LastMethodCallTime Variable.
        /// </summary>
        public const uint ProgramStateMachineType_ProgramDiagnostic_LastMethodCallTime = 3848;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_ProgramDiagnostic_LastMethodReturnStatus Variable.
        /// </summary>
        public const uint ProgramStateMachineType_ProgramDiagnostic_LastMethodReturnStatus = 3849;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_Halted_StateNumber Variable.
        /// </summary>
        public const uint ProgramStateMachineType_Halted_StateNumber = 2407;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_Ready_StateNumber Variable.
        /// </summary>
        public const uint ProgramStateMachineType_Ready_StateNumber = 2401;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_Running_StateNumber Variable.
        /// </summary>
        public const uint ProgramStateMachineType_Running_StateNumber = 2403;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_Suspended_StateNumber Variable.
        /// </summary>
        public const uint ProgramStateMachineType_Suspended_StateNumber = 2405;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_HaltedToReady_TransitionNumber Variable.
        /// </summary>
        public const uint ProgramStateMachineType_HaltedToReady_TransitionNumber = 2409;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_ReadyToRunning_TransitionNumber Variable.
        /// </summary>
        public const uint ProgramStateMachineType_ReadyToRunning_TransitionNumber = 2411;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_RunningToHalted_TransitionNumber Variable.
        /// </summary>
        public const uint ProgramStateMachineType_RunningToHalted_TransitionNumber = 2413;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_RunningToReady_TransitionNumber Variable.
        /// </summary>
        public const uint ProgramStateMachineType_RunningToReady_TransitionNumber = 2415;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_RunningToSuspended_TransitionNumber Variable.
        /// </summary>
        public const uint ProgramStateMachineType_RunningToSuspended_TransitionNumber = 2417;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_SuspendedToRunning_TransitionNumber Variable.
        /// </summary>
        public const uint ProgramStateMachineType_SuspendedToRunning_TransitionNumber = 2419;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_SuspendedToHalted_TransitionNumber Variable.
        /// </summary>
        public const uint ProgramStateMachineType_SuspendedToHalted_TransitionNumber = 2421;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_SuspendedToReady_TransitionNumber Variable.
        /// </summary>
        public const uint ProgramStateMachineType_SuspendedToReady_TransitionNumber = 2423;

        /// <summary>
        /// The identifier for the ProgramStateMachineType_ReadyToHalted_TransitionNumber Variable.
        /// </summary>
        public const uint ProgramStateMachineType_ReadyToHalted_TransitionNumber = 2425;

        /// <summary>
        /// The identifier for the ProgramTransitionEventType_Transition_Id Variable.
        /// </summary>
        public const uint ProgramTransitionEventType_Transition_Id = 3802;

        /// <summary>
        /// The identifier for the ProgramTransitionEventType_FromState_Id Variable.
        /// </summary>
        public const uint ProgramTransitionEventType_FromState_Id = 3792;

        /// <summary>
        /// The identifier for the ProgramTransitionEventType_ToState_Id Variable.
        /// </summary>
        public const uint ProgramTransitionEventType_ToState_Id = 3797;

        /// <summary>
        /// The identifier for the ProgramTransitionEventType_IntermediateResult Variable.
        /// </summary>
        public const uint ProgramTransitionEventType_IntermediateResult = 2379;

        /// <summary>
        /// The identifier for the AuditProgramTransitionEventType_TransitionNumber Variable.
        /// </summary>
        public const uint AuditProgramTransitionEventType_TransitionNumber = 11875;

        /// <summary>
        /// The identifier for the ProgramTransitionAuditEventType_Transition Variable.
        /// </summary>
        public const uint ProgramTransitionAuditEventType_Transition = 3825;

        /// <summary>
        /// The identifier for the ProgramTransitionAuditEventType_Transition_Id Variable.
        /// </summary>
        public const uint ProgramTransitionAuditEventType_Transition_Id = 3826;

        /// <summary>
        /// The identifier for the ProgramDiagnosticType_CreateSessionId Variable.
        /// </summary>
        public const uint ProgramDiagnosticType_CreateSessionId = 2381;

        /// <summary>
        /// The identifier for the ProgramDiagnosticType_CreateClientName Variable.
        /// </summary>
        public const uint ProgramDiagnosticType_CreateClientName = 2382;

        /// <summary>
        /// The identifier for the ProgramDiagnosticType_InvocationCreationTime Variable.
        /// </summary>
        public const uint ProgramDiagnosticType_InvocationCreationTime = 2383;

        /// <summary>
        /// The identifier for the ProgramDiagnosticType_LastTransitionTime Variable.
        /// </summary>
        public const uint ProgramDiagnosticType_LastTransitionTime = 2384;

        /// <summary>
        /// The identifier for the ProgramDiagnosticType_LastMethodCall Variable.
        /// </summary>
        public const uint ProgramDiagnosticType_LastMethodCall = 2385;

        /// <summary>
        /// The identifier for the ProgramDiagnosticType_LastMethodSessionId Variable.
        /// </summary>
        public const uint ProgramDiagnosticType_LastMethodSessionId = 2386;

        /// <summary>
        /// The identifier for the ProgramDiagnosticType_LastMethodInputArguments Variable.
        /// </summary>
        public const uint ProgramDiagnosticType_LastMethodInputArguments = 2387;

        /// <summary>
        /// The identifier for the ProgramDiagnosticType_LastMethodOutputArguments Variable.
        /// </summary>
        public const uint ProgramDiagnosticType_LastMethodOutputArguments = 2388;

        /// <summary>
        /// The identifier for the ProgramDiagnosticType_LastMethodCallTime Variable.
        /// </summary>
        public const uint ProgramDiagnosticType_LastMethodCallTime = 2389;

        /// <summary>
        /// The identifier for the ProgramDiagnosticType_LastMethodReturnStatus Variable.
        /// </summary>
        public const uint ProgramDiagnosticType_LastMethodReturnStatus = 2390;

        /// <summary>
        /// The identifier for the ProgramDiagnostic2Type_CreateSessionId Variable.
        /// </summary>
        public const uint ProgramDiagnostic2Type_CreateSessionId = 15384;

        /// <summary>
        /// The identifier for the ProgramDiagnostic2Type_CreateClientName Variable.
        /// </summary>
        public const uint ProgramDiagnostic2Type_CreateClientName = 15385;

        /// <summary>
        /// The identifier for the ProgramDiagnostic2Type_InvocationCreationTime Variable.
        /// </summary>
        public const uint ProgramDiagnostic2Type_InvocationCreationTime = 15386;

        /// <summary>
        /// The identifier for the ProgramDiagnostic2Type_LastTransitionTime Variable.
        /// </summary>
        public const uint ProgramDiagnostic2Type_LastTransitionTime = 15387;

        /// <summary>
        /// The identifier for the ProgramDiagnostic2Type_LastMethodCall Variable.
        /// </summary>
        public const uint ProgramDiagnostic2Type_LastMethodCall = 15388;

        /// <summary>
        /// The identifier for the ProgramDiagnostic2Type_LastMethodSessionId Variable.
        /// </summary>
        public const uint ProgramDiagnostic2Type_LastMethodSessionId = 15389;

        /// <summary>
        /// The identifier for the ProgramDiagnostic2Type_LastMethodInputArguments Variable.
        /// </summary>
        public const uint ProgramDiagnostic2Type_LastMethodInputArguments = 15390;

        /// <summary>
        /// The identifier for the ProgramDiagnostic2Type_LastMethodOutputArguments Variable.
        /// </summary>
        public const uint ProgramDiagnostic2Type_LastMethodOutputArguments = 15391;

        /// <summary>
        /// The identifier for the ProgramDiagnostic2Type_LastMethodInputValues Variable.
        /// </summary>
        public const uint ProgramDiagnostic2Type_LastMethodInputValues = 15392;

        /// <summary>
        /// The identifier for the ProgramDiagnostic2Type_LastMethodOutputValues Variable.
        /// </summary>
        public const uint ProgramDiagnostic2Type_LastMethodOutputValues = 15393;

        /// <summary>
        /// The identifier for the ProgramDiagnostic2Type_LastMethodCallTime Variable.
        /// </summary>
        public const uint ProgramDiagnostic2Type_LastMethodCallTime = 15394;

        /// <summary>
        /// The identifier for the ProgramDiagnostic2Type_LastMethodReturnStatus Variable.
        /// </summary>
        public const uint ProgramDiagnostic2Type_LastMethodReturnStatus = 15395;

        /// <summary>
        /// The identifier for the Annotations Variable.
        /// </summary>
        public const uint Annotations = 11214;

        /// <summary>
        /// The identifier for the HistoricalDataConfigurationType_AggregateConfiguration_TreatUncertainAsBad Variable.
        /// </summary>
        public const uint HistoricalDataConfigurationType_AggregateConfiguration_TreatUncertainAsBad = 11168;

        /// <summary>
        /// The identifier for the HistoricalDataConfigurationType_AggregateConfiguration_PercentDataBad Variable.
        /// </summary>
        public const uint HistoricalDataConfigurationType_AggregateConfiguration_PercentDataBad = 11169;

        /// <summary>
        /// The identifier for the HistoricalDataConfigurationType_AggregateConfiguration_PercentDataGood Variable.
        /// </summary>
        public const uint HistoricalDataConfigurationType_AggregateConfiguration_PercentDataGood = 11170;

        /// <summary>
        /// The identifier for the HistoricalDataConfigurationType_AggregateConfiguration_UseSlopedExtrapolation Variable.
        /// </summary>
        public const uint HistoricalDataConfigurationType_AggregateConfiguration_UseSlopedExtrapolation = 11171;

        /// <summary>
        /// The identifier for the HistoricalDataConfigurationType_Stepped Variable.
        /// </summary>
        public const uint HistoricalDataConfigurationType_Stepped = 2323;

        /// <summary>
        /// The identifier for the HistoricalDataConfigurationType_Definition Variable.
        /// </summary>
        public const uint HistoricalDataConfigurationType_Definition = 2324;

        /// <summary>
        /// The identifier for the HistoricalDataConfigurationType_MaxTimeInterval Variable.
        /// </summary>
        public const uint HistoricalDataConfigurationType_MaxTimeInterval = 2325;

        /// <summary>
        /// The identifier for the HistoricalDataConfigurationType_MinTimeInterval Variable.
        /// </summary>
        public const uint HistoricalDataConfigurationType_MinTimeInterval = 2326;

        /// <summary>
        /// The identifier for the HistoricalDataConfigurationType_ExceptionDeviation Variable.
        /// </summary>
        public const uint HistoricalDataConfigurationType_ExceptionDeviation = 2327;

        /// <summary>
        /// The identifier for the HistoricalDataConfigurationType_ExceptionDeviationFormat Variable.
        /// </summary>
        public const uint HistoricalDataConfigurationType_ExceptionDeviationFormat = 2328;

        /// <summary>
        /// The identifier for the HistoricalDataConfigurationType_StartOfArchive Variable.
        /// </summary>
        public const uint HistoricalDataConfigurationType_StartOfArchive = 11499;

        /// <summary>
        /// The identifier for the HistoricalDataConfigurationType_StartOfOnlineArchive Variable.
        /// </summary>
        public const uint HistoricalDataConfigurationType_StartOfOnlineArchive = 11500;

        /// <summary>
        /// The identifier for the HistoricalDataConfigurationType_ServerTimestampSupported Variable.
        /// </summary>
        public const uint HistoricalDataConfigurationType_ServerTimestampSupported = 19092;

        /// <summary>
        /// The identifier for the HAConfiguration_AggregateConfiguration_TreatUncertainAsBad Variable.
        /// </summary>
        public const uint HAConfiguration_AggregateConfiguration_TreatUncertainAsBad = 11204;

        /// <summary>
        /// The identifier for the HAConfiguration_AggregateConfiguration_PercentDataBad Variable.
        /// </summary>
        public const uint HAConfiguration_AggregateConfiguration_PercentDataBad = 11205;

        /// <summary>
        /// The identifier for the HAConfiguration_AggregateConfiguration_PercentDataGood Variable.
        /// </summary>
        public const uint HAConfiguration_AggregateConfiguration_PercentDataGood = 11206;

        /// <summary>
        /// The identifier for the HAConfiguration_AggregateConfiguration_UseSlopedExtrapolation Variable.
        /// </summary>
        public const uint HAConfiguration_AggregateConfiguration_UseSlopedExtrapolation = 11207;

        /// <summary>
        /// The identifier for the HAConfiguration_Stepped Variable.
        /// </summary>
        public const uint HAConfiguration_Stepped = 11208;

        /// <summary>
        /// The identifier for the HistoricalEventFilter Variable.
        /// </summary>
        public const uint HistoricalEventFilter = 11215;

        /// <summary>
        /// The identifier for the HistoryServerCapabilitiesType_AccessHistoryDataCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilitiesType_AccessHistoryDataCapability = 2331;

        /// <summary>
        /// The identifier for the HistoryServerCapabilitiesType_AccessHistoryEventsCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilitiesType_AccessHistoryEventsCapability = 2332;

        /// <summary>
        /// The identifier for the HistoryServerCapabilitiesType_MaxReturnDataValues Variable.
        /// </summary>
        public const uint HistoryServerCapabilitiesType_MaxReturnDataValues = 11268;

        /// <summary>
        /// The identifier for the HistoryServerCapabilitiesType_MaxReturnEventValues Variable.
        /// </summary>
        public const uint HistoryServerCapabilitiesType_MaxReturnEventValues = 11269;

        /// <summary>
        /// The identifier for the HistoryServerCapabilitiesType_InsertDataCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilitiesType_InsertDataCapability = 2334;

        /// <summary>
        /// The identifier for the HistoryServerCapabilitiesType_ReplaceDataCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilitiesType_ReplaceDataCapability = 2335;

        /// <summary>
        /// The identifier for the HistoryServerCapabilitiesType_UpdateDataCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilitiesType_UpdateDataCapability = 2336;

        /// <summary>
        /// The identifier for the HistoryServerCapabilitiesType_DeleteRawCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilitiesType_DeleteRawCapability = 2337;

        /// <summary>
        /// The identifier for the HistoryServerCapabilitiesType_DeleteAtTimeCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilitiesType_DeleteAtTimeCapability = 2338;

        /// <summary>
        /// The identifier for the HistoryServerCapabilitiesType_InsertEventCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilitiesType_InsertEventCapability = 11278;

        /// <summary>
        /// The identifier for the HistoryServerCapabilitiesType_ReplaceEventCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilitiesType_ReplaceEventCapability = 11279;

        /// <summary>
        /// The identifier for the HistoryServerCapabilitiesType_UpdateEventCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilitiesType_UpdateEventCapability = 11280;

        /// <summary>
        /// The identifier for the HistoryServerCapabilitiesType_DeleteEventCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilitiesType_DeleteEventCapability = 11501;

        /// <summary>
        /// The identifier for the HistoryServerCapabilitiesType_InsertAnnotationCapability Variable.
        /// </summary>
        public const uint HistoryServerCapabilitiesType_InsertAnnotationCapability = 11270;

        /// <summary>
        /// The identifier for the HistoryServerCapabilitiesType_ServerTimestampSupported Variable.
        /// </summary>
        public const uint HistoryServerCapabilitiesType_ServerTimestampSupported = 19094;

        /// <summary>
        /// The identifier for the AuditHistoryEventUpdateEventType_UpdatedNode Variable.
        /// </summary>
        public const uint AuditHistoryEventUpdateEventType_UpdatedNode = 3025;

        /// <summary>
        /// The identifier for the AuditHistoryEventUpdateEventType_PerformInsertReplace Variable.
        /// </summary>
        public const uint AuditHistoryEventUpdateEventType_PerformInsertReplace = 3028;

        /// <summary>
        /// The identifier for the AuditHistoryEventUpdateEventType_Filter Variable.
        /// </summary>
        public const uint AuditHistoryEventUpdateEventType_Filter = 3003;

        /// <summary>
        /// The identifier for the AuditHistoryEventUpdateEventType_NewValues Variable.
        /// </summary>
        public const uint AuditHistoryEventUpdateEventType_NewValues = 3029;

        /// <summary>
        /// The identifier for the AuditHistoryEventUpdateEventType_OldValues Variable.
        /// </summary>
        public const uint AuditHistoryEventUpdateEventType_OldValues = 3030;

        /// <summary>
        /// The identifier for the AuditHistoryValueUpdateEventType_UpdatedNode Variable.
        /// </summary>
        public const uint AuditHistoryValueUpdateEventType_UpdatedNode = 3026;

        /// <summary>
        /// The identifier for the AuditHistoryValueUpdateEventType_PerformInsertReplace Variable.
        /// </summary>
        public const uint AuditHistoryValueUpdateEventType_PerformInsertReplace = 3031;

        /// <summary>
        /// The identifier for the AuditHistoryValueUpdateEventType_NewValues Variable.
        /// </summary>
        public const uint AuditHistoryValueUpdateEventType_NewValues = 3032;

        /// <summary>
        /// The identifier for the AuditHistoryValueUpdateEventType_OldValues Variable.
        /// </summary>
        public const uint AuditHistoryValueUpdateEventType_OldValues = 3033;

        /// <summary>
        /// The identifier for the AuditHistoryAnnotationUpdateEventType_PerformInsertReplace Variable.
        /// </summary>
        public const uint AuditHistoryAnnotationUpdateEventType_PerformInsertReplace = 19293;

        /// <summary>
        /// The identifier for the AuditHistoryAnnotationUpdateEventType_NewValues Variable.
        /// </summary>
        public const uint AuditHistoryAnnotationUpdateEventType_NewValues = 19294;

        /// <summary>
        /// The identifier for the AuditHistoryAnnotationUpdateEventType_OldValues Variable.
        /// </summary>
        public const uint AuditHistoryAnnotationUpdateEventType_OldValues = 19295;

        /// <summary>
        /// The identifier for the AuditHistoryDeleteEventType_UpdatedNode Variable.
        /// </summary>
        public const uint AuditHistoryDeleteEventType_UpdatedNode = 3027;

        /// <summary>
        /// The identifier for the AuditHistoryRawModifyDeleteEventType_IsDeleteModified Variable.
        /// </summary>
        public const uint AuditHistoryRawModifyDeleteEventType_IsDeleteModified = 3015;

        /// <summary>
        /// The identifier for the AuditHistoryRawModifyDeleteEventType_StartTime Variable.
        /// </summary>
        public const uint AuditHistoryRawModifyDeleteEventType_StartTime = 3016;

        /// <summary>
        /// The identifier for the AuditHistoryRawModifyDeleteEventType_EndTime Variable.
        /// </summary>
        public const uint AuditHistoryRawModifyDeleteEventType_EndTime = 3017;

        /// <summary>
        /// The identifier for the AuditHistoryRawModifyDeleteEventType_OldValues Variable.
        /// </summary>
        public const uint AuditHistoryRawModifyDeleteEventType_OldValues = 3034;

        /// <summary>
        /// The identifier for the AuditHistoryAtTimeDeleteEventType_ReqTimes Variable.
        /// </summary>
        public const uint AuditHistoryAtTimeDeleteEventType_ReqTimes = 3020;

        /// <summary>
        /// The identifier for the AuditHistoryAtTimeDeleteEventType_OldValues Variable.
        /// </summary>
        public const uint AuditHistoryAtTimeDeleteEventType_OldValues = 3021;

        /// <summary>
        /// The identifier for the AuditHistoryEventDeleteEventType_EventIds Variable.
        /// </summary>
        public const uint AuditHistoryEventDeleteEventType_EventIds = 3023;

        /// <summary>
        /// The identifier for the AuditHistoryEventDeleteEventType_OldValues Variable.
        /// </summary>
        public const uint AuditHistoryEventDeleteEventType_OldValues = 3024;

        /// <summary>
        /// The identifier for the TrustListType_Open_InputArguments Variable.
        /// </summary>
        public const uint TrustListType_Open_InputArguments = 12528;

        /// <summary>
        /// The identifier for the TrustListType_Open_OutputArguments Variable.
        /// </summary>
        public const uint TrustListType_Open_OutputArguments = 12529;

        /// <summary>
        /// The identifier for the TrustListType_Close_InputArguments Variable.
        /// </summary>
        public const uint TrustListType_Close_InputArguments = 12531;

        /// <summary>
        /// The identifier for the TrustListType_Read_InputArguments Variable.
        /// </summary>
        public const uint TrustListType_Read_InputArguments = 12533;

        /// <summary>
        /// The identifier for the TrustListType_Read_OutputArguments Variable.
        /// </summary>
        public const uint TrustListType_Read_OutputArguments = 12534;

        /// <summary>
        /// The identifier for the TrustListType_Write_InputArguments Variable.
        /// </summary>
        public const uint TrustListType_Write_InputArguments = 12536;

        /// <summary>
        /// The identifier for the TrustListType_GetPosition_InputArguments Variable.
        /// </summary>
        public const uint TrustListType_GetPosition_InputArguments = 12538;

        /// <summary>
        /// The identifier for the TrustListType_GetPosition_OutputArguments Variable.
        /// </summary>
        public const uint TrustListType_GetPosition_OutputArguments = 12539;

        /// <summary>
        /// The identifier for the TrustListType_SetPosition_InputArguments Variable.
        /// </summary>
        public const uint TrustListType_SetPosition_InputArguments = 12541;

        /// <summary>
        /// The identifier for the TrustListType_LastUpdateTime Variable.
        /// </summary>
        public const uint TrustListType_LastUpdateTime = 12542;

        /// <summary>
        /// The identifier for the TrustListType_UpdateFrequency Variable.
        /// </summary>
        public const uint TrustListType_UpdateFrequency = 19296;

        /// <summary>
        /// The identifier for the TrustListType_OpenWithMasks_InputArguments Variable.
        /// </summary>
        public const uint TrustListType_OpenWithMasks_InputArguments = 12544;

        /// <summary>
        /// The identifier for the TrustListType_OpenWithMasks_OutputArguments Variable.
        /// </summary>
        public const uint TrustListType_OpenWithMasks_OutputArguments = 12545;

        /// <summary>
        /// The identifier for the TrustListType_CloseAndUpdate_InputArguments Variable.
        /// </summary>
        public const uint TrustListType_CloseAndUpdate_InputArguments = 12705;

        /// <summary>
        /// The identifier for the TrustListType_CloseAndUpdate_OutputArguments Variable.
        /// </summary>
        public const uint TrustListType_CloseAndUpdate_OutputArguments = 12547;

        /// <summary>
        /// The identifier for the TrustListType_AddCertificate_InputArguments Variable.
        /// </summary>
        public const uint TrustListType_AddCertificate_InputArguments = 12549;

        /// <summary>
        /// The identifier for the TrustListType_RemoveCertificate_InputArguments Variable.
        /// </summary>
        public const uint TrustListType_RemoveCertificate_InputArguments = 12551;

        /// <summary>
        /// The identifier for the TrustListMasks_EnumValues Variable.
        /// </summary>
        public const uint TrustListMasks_EnumValues = 12553;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_EnabledState_Id Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_EnabledState_Id = 19315;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_Quality_SourceTimestamp = 19324;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_LastSeverity_SourceTimestamp = 19326;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_Comment_SourceTimestamp = 19328;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_AddComment_InputArguments Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_AddComment_InputArguments = 19333;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_ConditionRefresh_InputArguments Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_ConditionRefresh_InputArguments = 19335;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_ConditionRefresh2_InputArguments Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_ConditionRefresh2_InputArguments = 19337;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_AckedState_Id Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_AckedState_Id = 19339;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_ConfirmedState_Id Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_ConfirmedState_Id = 19348;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_Acknowledge_InputArguments = 19357;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_Confirm_InputArguments Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_Confirm_InputArguments = 19359;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_ActiveState_Id Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_ActiveState_Id = 19361;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_SuppressedState_Id Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_SuppressedState_Id = 19371;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_OutOfServiceState_Id = 19380;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_ShelvingState_CurrentState = 19389;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Id = 19390;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Id = 19395;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_ShelvingState_UnshelveTime = 19402;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_ShelvingState_TimedShelve_InputArguments = 19404;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_SilenceState_Id Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_SilenceState_Id = 19415;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_LatchedState_Id Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_LatchedState_Id = 19428;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_TrustListId Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_TrustListId = 19446;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_LastUpdateTime Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_LastUpdateTime = 19447;

        /// <summary>
        /// The identifier for the TrustListOutOfDateAlarmType_UpdateFrequency Variable.
        /// </summary>
        public const uint TrustListOutOfDateAlarmType_UpdateFrequency = 19448;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_Size Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustList_Size = 13600;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_Writable Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustList_Writable = 13601;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_UserWritable Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustList_UserWritable = 13602;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_OpenCount Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustList_OpenCount = 13603;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_Open_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustList_Open_InputArguments = 13606;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_Open_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustList_Open_OutputArguments = 13607;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_Close_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustList_Close_InputArguments = 13609;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_Read_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustList_Read_InputArguments = 13611;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_Read_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustList_Read_OutputArguments = 13612;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_Write_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustList_Write_InputArguments = 13614;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_GetPosition_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustList_GetPosition_InputArguments = 13616;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_GetPosition_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustList_GetPosition_OutputArguments = 13617;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_SetPosition_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustList_SetPosition_InputArguments = 13619;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_LastUpdateTime Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustList_LastUpdateTime = 13620;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_OpenWithMasks_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustList_OpenWithMasks_InputArguments = 13622;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_OpenWithMasks_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustList_OpenWithMasks_OutputArguments = 13623;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_CloseAndUpdate_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustList_CloseAndUpdate_InputArguments = 13625;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_CloseAndUpdate_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustList_CloseAndUpdate_OutputArguments = 13626;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_AddCertificate_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustList_AddCertificate_InputArguments = 13628;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustList_RemoveCertificate_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustList_RemoveCertificate_InputArguments = 13630;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateTypes Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateTypes = 13631;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_EventId Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_EventId = 19451;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_EventType Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_EventType = 19452;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_SourceNode Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_SourceNode = 19453;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_SourceName Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_SourceName = 19454;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_Time Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_Time = 19455;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_ReceiveTime Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_ReceiveTime = 19456;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_Message Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_Message = 19458;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_Severity Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_Severity = 19459;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_ConditionClassId Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_ConditionClassId = 19460;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_ConditionClassName Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_ConditionClassName = 19461;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_ConditionName Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_ConditionName = 19464;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_BranchId Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_BranchId = 19465;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_Retain Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_Retain = 19466;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_EnabledState Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_EnabledState = 19467;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_EnabledState_Id Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_EnabledState_Id = 19468;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_Quality Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_Quality = 19476;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_Quality_SourceTimestamp = 19477;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_LastSeverity Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_LastSeverity = 19478;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_LastSeverity_SourceTimestamp = 19479;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_Comment Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_Comment = 19480;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_Comment_SourceTimestamp = 19481;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_ClientUserId Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_ClientUserId = 19482;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_AddComment_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_AddComment_InputArguments = 19486;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_AckedState Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_AckedState = 19487;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_AckedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_AckedState_Id = 19488;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_ConfirmedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_ConfirmedState_Id = 19497;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_Acknowledge_InputArguments = 19506;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_Confirm_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_Confirm_InputArguments = 19508;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_ActiveState Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_ActiveState = 19509;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_ActiveState_Id Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_ActiveState_Id = 19510;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_InputNode Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_InputNode = 19518;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_SuppressedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_SuppressedState_Id = 19520;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_OutOfServiceState_Id = 19529;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_ShelvingState_CurrentState = 19538;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Id = 19539;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Id = 19544;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_ShelvingState_UnshelveTime = 20096;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve_InputArguments = 20098;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_SuppressedOrShelved Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_SuppressedOrShelved = 20101;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_SilenceState_Id Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_SilenceState_Id = 20109;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_LatchedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_LatchedState_Id = 20122;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_NormalState Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_NormalState = 20138;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_ExpirationDate Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_ExpirationDate = 20139;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_CertificateType Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_CertificateType = 20141;

        /// <summary>
        /// The identifier for the CertificateGroupType_CertificateExpired_Certificate Variable.
        /// </summary>
        public const uint CertificateGroupType_CertificateExpired_Certificate = 20142;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_EventId Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_EventId = 20144;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_EventType Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_EventType = 20145;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_SourceNode Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_SourceNode = 20146;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_SourceName Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_SourceName = 20147;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_Time Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_Time = 20148;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_ReceiveTime Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_ReceiveTime = 20149;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_Message Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_Message = 20151;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_Severity Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_Severity = 20152;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_ConditionClassId Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_ConditionClassId = 20153;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_ConditionClassName Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_ConditionClassName = 20154;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_ConditionName Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_ConditionName = 20157;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_BranchId Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_BranchId = 20158;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_Retain Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_Retain = 20159;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_EnabledState Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_EnabledState = 20160;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_EnabledState_Id Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_EnabledState_Id = 20161;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_Quality Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_Quality = 20169;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_Quality_SourceTimestamp = 20170;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_LastSeverity Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_LastSeverity = 20171;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_LastSeverity_SourceTimestamp = 20172;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_Comment Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_Comment = 20173;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_Comment_SourceTimestamp = 20174;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_ClientUserId Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_ClientUserId = 20175;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_AddComment_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_AddComment_InputArguments = 20179;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_AckedState Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_AckedState = 20180;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_AckedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_AckedState_Id = 20181;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_ConfirmedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_ConfirmedState_Id = 20190;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_Acknowledge_InputArguments = 20199;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_Confirm_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_Confirm_InputArguments = 20201;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_ActiveState Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_ActiveState = 20202;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_ActiveState_Id Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_ActiveState_Id = 20203;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_InputNode Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_InputNode = 20211;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_SuppressedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_SuppressedState_Id = 20213;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Id = 20222;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState = 20231;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Id = 20232;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Id = 20237;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_ShelvingState_UnshelveTime = 20244;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments = 20246;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_SuppressedOrShelved Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_SuppressedOrShelved = 20249;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_SilenceState_Id Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_SilenceState_Id = 20257;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_LatchedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_LatchedState_Id = 20270;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_NormalState Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_NormalState = 20286;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_TrustListId Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_TrustListId = 20287;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_LastUpdateTime Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_LastUpdateTime = 20288;

        /// <summary>
        /// The identifier for the CertificateGroupType_TrustListOutOfDate_UpdateFrequency Variable.
        /// </summary>
        public const uint CertificateGroupType_TrustListOutOfDate_UpdateFrequency = 20289;

        /// <summary>
        /// The identifier for the CertificateGroupType_GetRejectedList_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupType_GetRejectedList_OutputArguments = 23527;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Size Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Size = 13816;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Writable Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Writable = 13817;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_UserWritable Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_UserWritable = 13818;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenCount Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenCount = 13819;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_InputArguments = 13822;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_OutputArguments = 13823;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close_InputArguments = 13825;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_InputArguments = 13827;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_OutputArguments = 13828;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write_InputArguments = 13830;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_InputArguments = 13832;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments = 13833;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition_InputArguments = 13835;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_LastUpdateTime Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_LastUpdateTime = 13836;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments = 13838;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments = 13839;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments = 13841;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments = 13842;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments = 13844;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments = 13846;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateTypes Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateTypes = 13847;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EventId Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EventId = 20292;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EventType Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EventType = 20293;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SourceNode Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SourceNode = 20294;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SourceName Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SourceName = 20295;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Time Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Time = 20296;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReceiveTime Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReceiveTime = 20297;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Message Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Message = 20299;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Severity Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Severity = 20300;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionClassId Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionClassId = 20301;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionClassName Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionClassName = 20302;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionName Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionName = 20305;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_BranchId Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_BranchId = 20306;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Retain Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Retain = 20307;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState = 20308;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Id = 20309;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Quality Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Quality = 20317;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp = 20318;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LastSeverity Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LastSeverity = 20319;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp = 20320;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Comment Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Comment = 20321;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp = 20322;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ClientUserId Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ClientUserId = 20323;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments = 20327;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState = 20328;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Id = 20329;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id = 20338;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments = 20347;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments = 20349;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState = 20350;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Id = 20351;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_InputNode Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_InputNode = 20359;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id = 20361;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id = 20370;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState = 20379;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id = 20380;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id = 20385;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime = 20392;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments = 20394;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved = 20397;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Id = 20405;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Id = 20420;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_NormalState Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_NormalState = 20436;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ExpirationDate Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ExpirationDate = 20437;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_CertificateType Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_CertificateType = 20439;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Certificate Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Certificate = 20440;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EventId Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EventId = 20442;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EventType Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EventType = 20443;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SourceNode Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SourceNode = 20444;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SourceName Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SourceName = 20445;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Time Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Time = 20446;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime = 20447;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Message Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Message = 20449;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Severity Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Severity = 20450;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId = 20451;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName = 20452;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionName Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionName = 20455;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_BranchId Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_BranchId = 20456;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Retain Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Retain = 20457;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState = 20458;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id = 20459;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Quality Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Quality = 20467;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp = 20468;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity = 20469;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp = 20470;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Comment Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Comment = 20471;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp = 20472;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId = 20473;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments = 20477;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState = 20478;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id = 20479;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id = 20488;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments = 20497;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments = 20499;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState = 20500;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id = 20501;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_InputNode Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_InputNode = 20509;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id = 20511;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id = 20520;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState = 20529;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id = 20530;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id = 20535;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime = 20542;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments = 20544;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved = 20547;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id = 20555;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id = 20568;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_NormalState Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_NormalState = 20584;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_TrustListId Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_TrustListId = 20585;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime = 20586;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency = 20587;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultApplicationGroup_GetRejectedList_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultApplicationGroup_GetRejectedList_OutputArguments = 23530;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Size Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Size = 13850;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Writable Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Writable = 13851;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_UserWritable Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_UserWritable = 13852;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenCount Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenCount = 13853;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_InputArguments = 13856;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_OutputArguments = 13857;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close_InputArguments = 13859;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_InputArguments = 13861;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_OutputArguments = 13862;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write_InputArguments = 13864;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_InputArguments = 13866;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments = 13867;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition_InputArguments = 13869;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_LastUpdateTime Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_LastUpdateTime = 13870;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments = 13872;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments = 13873;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments = 13875;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments = 13876;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments = 13878;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments = 13880;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateTypes Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateTypes = 13881;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EventId Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EventId = 20590;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EventType Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EventType = 20591;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SourceNode Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SourceNode = 20592;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SourceName Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SourceName = 20593;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Time Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Time = 20594;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ReceiveTime Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ReceiveTime = 20595;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Message Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Message = 20597;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Severity Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Severity = 20598;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionClassId Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionClassId = 20599;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionClassName Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionClassName = 20600;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionName Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionName = 20603;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_BranchId Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_BranchId = 20604;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Retain Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Retain = 20605;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState = 20606;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_Id = 20607;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Quality Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Quality = 20615;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp = 20616;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LastSeverity Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LastSeverity = 20617;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp = 20618;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Comment Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Comment = 20619;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp = 20620;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ClientUserId Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ClientUserId = 20621;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments = 20625;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState = 20626;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_Id = 20627;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id = 20636;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments = 20645;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments = 20647;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState = 20648;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_Id = 20649;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_InputNode Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_InputNode = 20657;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id = 20659;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id = 20668;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState = 20677;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id = 20678;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id = 20683;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime = 20690;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments = 20692;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved = 20695;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_Id = 20703;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_Id = 20716;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_NormalState Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_NormalState = 20732;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ExpirationDate Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ExpirationDate = 20733;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_CertificateType Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_CertificateType = 20735;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Certificate Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Certificate = 20736;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EventId Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EventId = 20738;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EventType Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EventType = 20739;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SourceNode Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SourceNode = 20740;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SourceName Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SourceName = 20741;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Time Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Time = 20742;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime = 20743;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Message Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Message = 20745;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Severity Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Severity = 20746;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId = 20747;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName = 20748;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionName Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionName = 20751;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_BranchId Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_BranchId = 20752;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Retain Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Retain = 20753;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState = 20754;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id = 20755;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Quality Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Quality = 20763;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp = 20764;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity = 20765;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp = 20766;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Comment Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Comment = 20767;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp = 20768;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId = 20769;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments = 20773;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState = 20774;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id = 20775;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id = 20784;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments = 20793;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments = 20795;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState = 20796;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id = 20797;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_InputNode Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_InputNode = 20805;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id = 20807;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id = 20816;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState = 20825;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id = 20826;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id = 20831;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime = 20838;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments = 20840;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved = 20843;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id = 20851;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id = 20864;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_NormalState Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_NormalState = 20880;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_TrustListId Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_TrustListId = 20881;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime = 20882;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency = 20883;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultHttpsGroup_GetRejectedList_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultHttpsGroup_GetRejectedList_OutputArguments = 23532;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Size Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Size = 13884;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Writable Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Writable = 13885;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_UserWritable Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_UserWritable = 13886;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenCount Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenCount = 13887;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_InputArguments = 13890;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_OutputArguments = 13891;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close_InputArguments = 13893;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_InputArguments = 13895;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_OutputArguments = 13896;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write_InputArguments = 13898;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments = 13900;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments = 13901;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments = 13903;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_LastUpdateTime Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_LastUpdateTime = 13904;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments = 13906;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments = 13907;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments Variable.
        /// </summary>
        public const uint CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments = 13909;

        /// <summary>
        /// The identifier for the CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments Variable.
        /// </summary>
 