# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.model.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class ALBAuthToken(VapiStruct):
    """
    ALB Auth Token

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'expires_at': 'expires_at',
                            'hours': 'hours',
                            'token': 'token',
                            'username': 'username',
                            }

    def __init__(self,
                 expires_at=None,
                 hours=None,
                 token=None,
                 username=None,
                ):
        """
        :type  expires_at: :class:`str` or ``None``
        :param expires_at: Expiry time of the token will be set by LCM at the time of
            Enforcement Point Creation.
        :type  hours: :class:`str` or ``None``
        :param hours: Hours to validate the token
        :type  token: :class:`str` or ``None``
        :param token: Token for Avi Controller.
        :type  username: :class:`str` or ``None``
        :param username: controller username.
        """
        self.expires_at = expires_at
        self.hours = hours
        self.token = token
        self.username = username
        VapiStruct.__init__(self)


ALBAuthToken._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_auth_token', {
        'expires_at': type.OptionalType(type.StringType()),
        'hours': type.OptionalType(type.StringType()),
        'token': type.OptionalType(type.StringType()),
        'username': type.OptionalType(type.StringType()),
    },
    ALBAuthToken,
    False,
    None))



class ALBControllerAdminCredential(VapiStruct):
    """
    Advanced Load Balancer Controller admin user credential for validation.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'clustering_id': 'clustering_id',
                            'password': 'password',
                            }

    def __init__(self,
                 clustering_id=None,
                 password=None,
                ):
        """
        :type  clustering_id: :class:`str` or ``None``
        :param clustering_id: Unique Id for NSX Advanced Load Balancer Controller Cluster used in
            VCF managed NSX.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  password: :class:`str` or ``None``
        :param password: Password for the NSX Advanced Load Balancer Controller Cluster
            admin user.
        """
        self.clustering_id = clustering_id
        self.password = password
        VapiStruct.__init__(self)


ALBControllerAdminCredential._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_admin_credential', {
        'clustering_id': type.OptionalType(type.StringType()),
        'password': type.OptionalType(type.StringType()),
    },
    ALBControllerAdminCredential,
    False,
    None))



class ALBControllerBackupConfiguration(VapiStruct):
    """
    Advanced Load Balancer Controller Backup Configuration

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'backup_location': 'backup_location',
                            'backup_passphrase': 'backup_passphrase',
                            'clustering_id': 'clustering_id',
                            'password': 'password',
                            'server_address': 'server_address',
                            'username': 'username',
                            }

    def __init__(self,
                 backup_location=None,
                 backup_passphrase=None,
                 clustering_id=None,
                 password=None,
                 server_address=None,
                 username=None,
                ):
        """
        :type  backup_location: :class:`str` or ``None``
        :param backup_location: Directory in backup server.
        :type  backup_passphrase: :class:`str` or ``None``
        :param backup_passphrase: Passphrase for in the backup.
        :type  clustering_id: :class:`str` or ``None``
        :param clustering_id: Unique Id for NSX Advanced Load Balancer Controller Cluster used in
            VCF managed NSX.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  password: :class:`str` or ``None``
        :param password: Backup server password.
        :type  server_address: :class:`str` or ``None``
        :param server_address: Backup server address. format: hostname-or-ipv4
        :type  username: :class:`str` or ``None``
        :param username: Backup server username.
        """
        self.backup_location = backup_location
        self.backup_passphrase = backup_passphrase
        self.clustering_id = clustering_id
        self.password = password
        self.server_address = server_address
        self.username = username
        VapiStruct.__init__(self)


ALBControllerBackupConfiguration._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_backup_configuration', {
        'backup_location': type.OptionalType(type.StringType()),
        'backup_passphrase': type.OptionalType(type.StringType()),
        'clustering_id': type.OptionalType(type.StringType()),
        'password': type.OptionalType(type.StringType()),
        'server_address': type.OptionalType(type.StringType()),
        'username': type.OptionalType(type.StringType()),
    },
    ALBControllerBackupConfiguration,
    False,
    None))



class ALBControllerCertificate(VapiStruct):
    """
    Advanced Load Balancer Controller portal certificate

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'cert': 'cert',
                            'clustering_id': 'clustering_id',
                            'csr': 'csr',
                            'name': 'name',
                            }

    def __init__(self,
                 cert=None,
                 clustering_id=None,
                 csr=None,
                 name=None,
                ):
        """
        :type  cert: :class:`str` or ``None``
        :param cert: Advanced Load Balancer Controller portal certificate or CSR.
        :type  clustering_id: :class:`str` or ``None``
        :param clustering_id: Unique Id for NSX Advanced Load Balancer Controller Cluster used in
            VCF managed NSX.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  csr: :class:`str` or ``None``
        :param csr: Advanced Load Balancer Controller portal certificate or CSR.
        :type  name: :class:`str` or ``None``
        :param name: Name of Advanced Load Balancer Controller portal certificate or
            CSR.
        """
        self.cert = cert
        self.clustering_id = clustering_id
        self.csr = csr
        self.name = name
        VapiStruct.__init__(self)


ALBControllerCertificate._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_certificate', {
        'cert': type.OptionalType(type.StringType()),
        'clustering_id': type.OptionalType(type.StringType()),
        'csr': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
    },
    ALBControllerCertificate,
    False,
    None))



class ALBControllerCertificateCsr(VapiStruct):
    """
    CSR for Advanced Load Balancer Controller portal certificate

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'algorithm': 'algorithm',
                            'clustering_id': 'clustering_id',
                            'common_name': 'common_name',
                            'country': 'country',
                            'email': 'email',
                            'key_size': 'key_size',
                            'locality': 'locality',
                            'organization': 'organization',
                            'organization_unit': 'organization_unit',
                            'state_name': 'state_name',
                            'subject_alt_names': 'subject_alt_names',
                            }

    def __init__(self,
                 algorithm=None,
                 clustering_id=None,
                 common_name=None,
                 country=None,
                 email=None,
                 key_size=None,
                 locality=None,
                 organization=None,
                 organization_unit=None,
                 state_name=None,
                 subject_alt_names=None,
                ):
        """
        :type  algorithm: :class:`str` or ``None``
        :param algorithm: Algorithm for Advanced Load Balancer Controller portal certificate.
        :type  clustering_id: :class:`str` or ``None``
        :param clustering_id: Unique Id for NSX Advanced Load Balancer Controller Cluster used in
            VCF managed NSX.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  common_name: :class:`str` or ``None``
        :param common_name: Common name for Advanced Load Balancer Controller portal
            certificate.
        :type  country: :class:`str` or ``None``
        :param country: Country name for Advanced Load Balancer Controller portal
            certificate.
        :type  email: :class:`str` or ``None``
        :param email: Email for Advanced Load Balancer Controller portal certificate.
        :type  key_size: :class:`str` or ``None``
        :param key_size: Key size for Advanced Load Balancer Controller portal certificate.
        :type  locality: :class:`str` or ``None``
        :param locality: Location or region for Advanced Load Balancer Controller portal
            certificate.
        :type  organization: :class:`str` or ``None``
        :param organization: Organization for Advanced Load Balancer Controller portal
            certificate.
        :type  organization_unit: :class:`str` or ``None``
        :param organization_unit: Organization unit for Advanced Load Balancer Controller portal
            certificate.
        :type  state_name: :class:`str` or ``None``
        :param state_name: State name for Advanced Load Balancer Controller portal
            certificate.
        :type  subject_alt_names: :class:`list` of :class:`str` or ``None``
        :param subject_alt_names: List of SAN for Advanced Load Balancer Controller portal
            certificate.
        """
        self.algorithm = algorithm
        self.clustering_id = clustering_id
        self.common_name = common_name
        self.country = country
        self.email = email
        self.key_size = key_size
        self.locality = locality
        self.organization = organization
        self.organization_unit = organization_unit
        self.state_name = state_name
        self.subject_alt_names = subject_alt_names
        VapiStruct.__init__(self)


ALBControllerCertificateCsr._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_certificate_csr', {
        'algorithm': type.OptionalType(type.StringType()),
        'clustering_id': type.OptionalType(type.StringType()),
        'common_name': type.OptionalType(type.StringType()),
        'country': type.OptionalType(type.StringType()),
        'email': type.OptionalType(type.StringType()),
        'key_size': type.OptionalType(type.StringType()),
        'locality': type.OptionalType(type.StringType()),
        'organization': type.OptionalType(type.StringType()),
        'organization_unit': type.OptionalType(type.StringType()),
        'state_name': type.OptionalType(type.StringType()),
        'subject_alt_names': type.OptionalType(type.ListType(type.StringType())),
    },
    ALBControllerCertificateCsr,
    False,
    None))



class ALBControllerClusterInfo(VapiStruct):
    """
    Advanced Load Balancer controller cluster information about nodes in the
    cluster and cluster information.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'cluster_name': 'cluster_name',
                            'cluster_state': 'cluster_state',
                            'cluster_uuid': 'cluster_uuid',
                            'clustering_id': 'clustering_id',
                            'error': 'error',
                            'nodes': 'nodes',
                            'reason': 'reason',
                            'version': 'version',
                            'virtual_ip': 'virtual_ip',
                            }

    def __init__(self,
                 cluster_name=None,
                 cluster_state=None,
                 cluster_uuid=None,
                 clustering_id=None,
                 error=None,
                 nodes=None,
                 reason=None,
                 version=None,
                 virtual_ip=None,
                ):
        """
        :type  cluster_name: :class:`str` or ``None``
        :param cluster_name: Advanced Load Balancer controller cluster name.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  cluster_state: :class:`str` or ``None``
        :param cluster_state: Advanced Load Balancer controller cluster state.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  cluster_uuid: :class:`str` or ``None``
        :param cluster_uuid: ID of the Cluster maintained internally. Note: This is
            automatically generated and cannot be modified.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  clustering_id: :class:`str` or ``None``
        :param clustering_id: Unique Id for NSX Advanced Load Balancer Controller Cluster used in
            VCF managed NSX.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  error: :class:`AlbControllerClusterRuntimeError` or ``None``
        :param error: 
        :type  nodes: :class:`list` of :class:`ALBControllerNodeInfo` or ``None``
        :param nodes: Advanced Load Balancer controller node information
        :type  reason: :class:`str` or ``None``
        :param reason: Advanced Load Balancer cluster state not STABLE reason.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  version: :class:`str` or ``None``
        :param version: Advanced Load Balancer controller cluster version.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  virtual_ip: :class:`str` or ``None``
        :param virtual_ip: Advanced Load Balancer controller cluster virtual_ip. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.cluster_name = cluster_name
        self.cluster_state = cluster_state
        self.cluster_uuid = cluster_uuid
        self.clustering_id = clustering_id
        self.error = error
        self.nodes = nodes
        self.reason = reason
        self.version = version
        self.virtual_ip = virtual_ip
        VapiStruct.__init__(self)


ALBControllerClusterInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_cluster_info', {
        'cluster_name': type.OptionalType(type.StringType()),
        'cluster_state': type.OptionalType(type.StringType()),
        'cluster_uuid': type.OptionalType(type.StringType()),
        'clustering_id': type.OptionalType(type.StringType()),
        'error': type.OptionalType(type.ReferenceType(__name__, 'AlbControllerClusterRuntimeError')),
        'nodes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBControllerNodeInfo'))),
        'reason': type.OptionalType(type.StringType()),
        'version': type.OptionalType(type.StringType()),
        'virtual_ip': type.OptionalType(type.StringType()),
    },
    ALBControllerClusterInfo,
    False,
    None))



class ALBControllerClusterTrigger(VapiStruct):
    """
    Advanced Load Balancer controller node clustering trigger response.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'status': 'status',
                            }

    def __init__(self,
                 status=None,
                ):
        """
        :type  status: :class:`str` or ``None``
        :param status: Advanced Load Balancer controller node clustering trigger status.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.status = status
        VapiStruct.__init__(self)


ALBControllerClusterTrigger._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_cluster_trigger', {
        'status': type.OptionalType(type.StringType()),
    },
    ALBControllerClusterTrigger,
    False,
    None))



class ALBControllerConfiguration(VapiStruct):
    """
    Alb Controller config details

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    OWNED_BY_LCM = "LCM"
    """


    """
    OWNED_BY_VCF = "VCF"
    """


    """



    _canonical_to_pep_names = {
                            'cluster_ip': 'cluster_ip',
                            'dns_servers': 'dns_servers',
                            'infra_admin_password': 'infra_admin_password',
                            'infra_admin_username': 'infra_admin_username',
                            'ntp_servers': 'ntp_servers',
                            'owned_by': 'owned_by',
                            }

    def __init__(self,
                 cluster_ip=None,
                 dns_servers=None,
                 infra_admin_password=None,
                 infra_admin_username=None,
                 ntp_servers=None,
                 owned_by=None,
                ):
        """
        :type  cluster_ip: :class:`str` or ``None``
        :param cluster_ip: The cluster IP of the Advanced Load Balancer controller node
            cluster. This is mandatory parameter and required for single node
            controller deployments as well. format: ip
        :type  dns_servers: :class:`list` of :class:`str` or ``None``
        :param dns_servers: List of DNS servers. format: ipv4
        :type  infra_admin_password: :class:`str` or ``None``
        :param infra_admin_password: Password for the controller node admin user. For deployment, this
            property is required. The password specified must be at least 8
            characters in length.
        :type  infra_admin_username: :class:`str` or ``None``
        :param infra_admin_username: Username for server authentication.
        :type  ntp_servers: :class:`list` of :class:`str` or ``None``
        :param ntp_servers: List of NTP servers. format: hostname-or-ipv4
        :type  owned_by: :class:`str` or ``None``
        :param owned_by: Possible values are: 
            
            * :attr:`ALBControllerConfiguration.OWNED_BY_LCM`
            * :attr:`ALBControllerConfiguration.OWNED_BY_VCF`
            
            OnBoarding workflow initiates by VCF/Others.
        """
        self.cluster_ip = cluster_ip
        self.dns_servers = dns_servers
        self.infra_admin_password = infra_admin_password
        self.infra_admin_username = infra_admin_username
        self.ntp_servers = ntp_servers
        self.owned_by = owned_by
        VapiStruct.__init__(self)


ALBControllerConfiguration._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_configuration', {
        'cluster_ip': type.OptionalType(type.StringType()),
        'dns_servers': type.OptionalType(type.ListType(type.StringType())),
        'infra_admin_password': type.OptionalType(type.StringType()),
        'infra_admin_username': type.OptionalType(type.StringType()),
        'ntp_servers': type.OptionalType(type.ListType(type.StringType())),
        'owned_by': type.OptionalType(type.StringType()),
    },
    ALBControllerConfiguration,
    False,
    None))



class ALBControllerNodeFormFactor(VapiStruct):
    """
    Advanced Load Balancer node form factor.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_SMALL = "SMALL"
    """


    """
    TYPE_MEDIUM = "MEDIUM"
    """


    """
    TYPE_LARGE = "LARGE"
    """


    """



    _canonical_to_pep_names = {
                            'disk': 'disk',
                            'memory': 'memory',
                            'type': 'type',
                            'vcpu': 'vcpu',
                            }

    def __init__(self,
                 disk=None,
                 memory=None,
                 type=None,
                 vcpu=None,
                ):
        """
        :type  disk: :class:`long` or ``None``
        :param disk: Disk size of the Advanced Load Balancer controller node in Bytes.
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  memory: :class:`long` or ``None``
        :param memory: Memory size of the Advanced Load Balancer controller node in Bytes.
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ALBControllerNodeFormFactor.TYPE_SMALL`
            * :attr:`ALBControllerNodeFormFactor.TYPE_MEDIUM`
            * :attr:`ALBControllerNodeFormFactor.TYPE_LARGE`
            
            Advanced Load Balancer controller node form factor type.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  vcpu: :class:`long` or ``None``
        :param vcpu: Number of virtual cpus on the Advanced Load Balancer controller
            node. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.disk = disk
        self.memory = memory
        self.type = type
        self.vcpu = vcpu
        VapiStruct.__init__(self)


ALBControllerNodeFormFactor._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_node_form_factor', {
        'disk': type.OptionalType(type.IntegerType()),
        'memory': type.OptionalType(type.IntegerType()),
        'type': type.OptionalType(type.StringType()),
        'vcpu': type.OptionalType(type.IntegerType()),
    },
    ALBControllerNodeFormFactor,
    False,
    None))



class ALBControllerNodeFormFactors(VapiStruct):
    """
    Advanced Load Balancer controller form factors list result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'form_factors': 'form_factors',
                            }

    def __init__(self,
                 form_factors=None,
                ):
        """
        :type  form_factors: :class:`list` of :class:`ALBControllerNodeFormFactor` or ``None``
        :param form_factors: Advanced Load Balancer controller form factor list
        """
        self.form_factors = form_factors
        VapiStruct.__init__(self)


ALBControllerNodeFormFactors._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_node_form_factors', {
        'form_factors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBControllerNodeFormFactor'))),
    },
    ALBControllerNodeFormFactors,
    False,
    None))



class ALBControllerNodeInfo(VapiStruct):
    """
    Advanced Load Balancer controller node information like node IP and node
    name.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'is_dhcp': 'is_dhcp',
                            'node_ip': 'node_ip',
                            'node_name': 'node_name',
                            'node_role': 'node_role',
                            'node_start_time': 'node_start_time',
                            'node_state': 'node_state',
                            'vm_id': 'vm_id',
                            }

    def __init__(self,
                 is_dhcp=None,
                 node_ip=None,
                 node_name=None,
                 node_role=None,
                 node_start_time=None,
                 node_state=None,
                 vm_id=None,
                ):
        """
        :type  is_dhcp: :class:`bool` or ``None``
        :param is_dhcp: Advanced Load Balancer controller node IP configuration is static
            or DHCP.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_ip: :class:`str` or ``None``
        :param node_ip: Advanced Load Balancer controller node IP. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_name: :class:`str` or ``None``
        :param node_name: Advanced Load Balancer controller node name.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_role: :class:`str` or ``None``
        :param node_role: Advanced Load Balancer controller node role in cluster.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_start_time: :class:`long` or ``None``
        :param node_start_time: Advanced Load Balancer controller node start time in its local
            timezone. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_state: :class:`str` or ``None``
        :param node_state: Advanced Load Balancer controller node current state in the
            cluster.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  vm_id: :class:`str` or ``None``
        :param vm_id: ID of the VM maintained internally. Note: This is automatically
            generated and cannot be modified.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.is_dhcp = is_dhcp
        self.node_ip = node_ip
        self.node_name = node_name
        self.node_role = node_role
        self.node_start_time = node_start_time
        self.node_state = node_state
        self.vm_id = vm_id
        VapiStruct.__init__(self)


ALBControllerNodeInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_node_info', {
        'is_dhcp': type.OptionalType(type.BooleanType()),
        'node_ip': type.OptionalType(type.StringType()),
        'node_name': type.OptionalType(type.StringType()),
        'node_role': type.OptionalType(type.StringType()),
        'node_start_time': type.OptionalType(type.IntegerType()),
        'node_state': type.OptionalType(type.StringType()),
        'vm_id': type.OptionalType(type.StringType()),
    },
    ALBControllerNodeInfo,
    False,
    None))



class ALBControllerNodeUserSettings(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'admin_password': 'admin_password',
                            'admin_ssh_key': 'admin_ssh_key',
                            }

    def __init__(self,
                 admin_password=None,
                 admin_ssh_key=None,
                ):
        """
        :type  admin_password: :class:`str` or ``None``
        :param admin_password: Password for the controller node admin user. For deployment, this
            property is required. The password specified must be at least 8
            characters in length.
        :type  admin_ssh_key: :class:`str` or ``None``
        :param admin_ssh_key: To configure ssh into the Advanced Load Balancer controller, this
            property is required.
        """
        self.admin_password = admin_password
        self.admin_ssh_key = admin_ssh_key
        VapiStruct.__init__(self)


ALBControllerNodeUserSettings._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_node_user_settings', {
        'admin_password': type.OptionalType(type.StringType()),
        'admin_ssh_key': type.OptionalType(type.StringType()),
    },
    ALBControllerNodeUserSettings,
    False,
    None))



class ALBControllerNodeVMClusterConfig(VapiStruct):
    """
    Contains the cluster configuration for a Advanced Load Balancer controller
    node VM cluster.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'cluster_ip': 'cluster_ip',
                            'cluster_name': 'cluster_name',
                            'cluster_uuid': 'cluster_uuid',
                            'clustering_id': 'clustering_id',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 cluster_ip=None,
                 cluster_name=None,
                 cluster_uuid=None,
                 clustering_id=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  cluster_ip: :class:`str` or ``None``
        :param cluster_ip: The cluster IP of the Advanced Load Balancer controller node
            cluster. This is mandatory parameter and required for single node
            controller deployments as well. format: ip
        :type  cluster_name: :class:`str` or ``None``
        :param cluster_name: The cluster name of the Advanced Load Balancer controller node
            cluster.
        :type  cluster_uuid: :class:`str` or ``None``
        :param cluster_uuid: ID of the Cluster maintained internally. This is different from
            cluster_uuid internal to Advanced Load Balancer controller. Note:
            This is automatically generated and cannot be modified.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  clustering_id: :class:`str` or ``None``
        :param clustering_id: Unique Id for NSX Advanced Load Balancer Controller Cluster used in
            VCF managed NSX.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.cluster_ip = cluster_ip
        self.cluster_name = cluster_name
        self.cluster_uuid = cluster_uuid
        self.clustering_id = clustering_id
        VapiStruct.__init__(self)


ALBControllerNodeVMClusterConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_node_VM_cluster_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'cluster_ip': type.OptionalType(type.StringType()),
        'cluster_name': type.OptionalType(type.StringType()),
        'cluster_uuid': type.OptionalType(type.StringType()),
        'clustering_id': type.OptionalType(type.StringType()),
    },
    ALBControllerNodeVMClusterConfig,
    False,
    None))



class ALBControllerNodeVMDeploymentConfig(VapiStruct):
    """
    Contains info used to configure the VM on deployment.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ALBControllerNodeVMDeploymentConfig"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    PLACEMENT_TYPE_ALBCONTROLLERVSPHERECLUSTERNODEVMDEPLOYMENTCONFIG = "AlbControllerVsphereClusterNodeVmDeploymentConfig"
    """


    """



    _canonical_to_pep_names = {
                            'placement_type': 'placement_type',
                            }

    def __init__(self,
                 placement_type='ALBControllerNodeVMDeploymentConfig',
                ):
        """
        :type  placement_type: :class:`str`
        :param placement_type: Possible values are: 
            
            *
              :attr:`ALBControllerNodeVMDeploymentConfig.PLACEMENT_TYPE_ALBCONTROLLERVSPHERECLUSTERNODEVMDEPLOYMENTCONFIG`
            
            Specifies the config for the platform through which to deploy the
            VM.
        """
        self._placement_type = placement_type
        VapiStruct.__init__(self)

    @property
    def placement_type(self):
        """
        Return the discriminator value
        """
        return self._placement_type

ALBControllerNodeVMDeploymentConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_node_VM_deployment_config', {
        'placement_type': type.StringType(),
    },
    ALBControllerNodeVMDeploymentConfig,
    False,
    None))



class ALBControllerNodeVMDeploymentProgressState(VapiStruct):
    """
    Deployment progress state of Advanced Load Balancer controller VM. This
    Object contains name of current deployment step and overall progress
    percentage.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'current_step_title': 'current_step_title',
                            'progress': 'progress',
                            }

    def __init__(self,
                 current_step_title=None,
                 progress=None,
                ):
        """
        :type  current_step_title: :class:`str` or ``None``
        :param current_step_title: Name of the current running step of deployment
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  progress: :class:`long` or ``None``
        :param progress: Overall progress percentage of deployment completed format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.current_step_title = current_step_title
        self.progress = progress
        VapiStruct.__init__(self)


ALBControllerNodeVMDeploymentProgressState._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_node_VM_deployment_progress_state', {
        'current_step_title': type.OptionalType(type.StringType()),
        'progress': type.OptionalType(type.IntegerType()),
    },
    ALBControllerNodeVMDeploymentProgressState,
    False,
    None))



class ALBControllerNodeVMDeploymentRequest(VapiStruct):
    """
    Contains the deployment information for a Advanced Load Balancer controller
    node VM.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    FORM_FACTOR_SMALL = "SMALL"
    """


    """
    FORM_FACTOR_MEDIUM = "MEDIUM"
    """


    """
    FORM_FACTOR_LARGE = "LARGE"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'clustering_id': 'clustering_id',
                            'deployment_config': 'deployment_config',
                            'form_factor': 'form_factor',
                            'sddc_manager': 'sddc_manager',
                            'user_settings': 'user_settings',
                            'vm_id': 'vm_id',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 clustering_id=None,
                 deployment_config=None,
                 form_factor=None,
                 sddc_manager=None,
                 user_settings=None,
                 vm_id=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  clustering_id: :class:`str` or ``None``
        :param clustering_id: Unique Id for NSX Advanced Load Balancer Controller Cluster used in
            VCF managed NSX.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  deployment_config: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param deployment_config: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ALBControllerNodeVMDeploymentConfig`. When methods return a
            value of this class as a return value, the attribute will contain
            all the attributes defined in
            :class:`ALBControllerNodeVMDeploymentConfig`.
        :type  form_factor: :class:`str` or ``None``
        :param form_factor: Possible values are: 
            
            * :attr:`ALBControllerNodeVMDeploymentRequest.FORM_FACTOR_SMALL`
            * :attr:`ALBControllerNodeVMDeploymentRequest.FORM_FACTOR_MEDIUM`
            * :attr:`ALBControllerNodeVMDeploymentRequest.FORM_FACTOR_LARGE`
            
            Specifies the desired \"size\" of the VM
        :type  sddc_manager: :class:`str` or ``None``
        :param sddc_manager: FQDN or IP of SDDC Manager for VCF workflow format:
            hostname-or-ipv4
        :type  user_settings: :class:`ALBControllerNodeUserSettings` or ``None``
        :param user_settings: 
        :type  vm_id: :class:`str` or ``None``
        :param vm_id: ID of the VM maintained internally. Note: This is automatically
            generated and cannot be modified.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.clustering_id = clustering_id
        self.deployment_config = deployment_config
        self.form_factor = form_factor
        self.sddc_manager = sddc_manager
        self.user_settings = user_settings
        self.vm_id = vm_id
        VapiStruct.__init__(self)


ALBControllerNodeVMDeploymentRequest._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_node_VM_deployment_request', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'clustering_id': type.OptionalType(type.StringType()),
        'deployment_config': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ALBControllerNodeVMDeploymentConfig')])),
        'form_factor': type.OptionalType(type.StringType()),
        'sddc_manager': type.OptionalType(type.StringType()),
        'user_settings': type.OptionalType(type.ReferenceType(__name__, 'ALBControllerNodeUserSettings')),
        'vm_id': type.OptionalType(type.StringType()),
    },
    ALBControllerNodeVMDeploymentRequest,
    False,
    None))



class ALBControllerNodeVMDeploymentRequestList(VapiStruct):
    """
    List of Advanced Load Balancer Controller Deployment Requests.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'clustering_id': 'clustering_id',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 clustering_id=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  clustering_id: :class:`str` or ``None``
        :param clustering_id: Id to filter NSX Advanced Load Balancer Controllers, if not
            provided NSX ALB Controllers without clustering Id will be
            returned.
        :type  results: :class:`list` of :class:`ALBControllerNodeVMDeploymentRequest` or ``None``
        :param results: Array of existing Advanced Load Balancer Controller Deployment
            Requests.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.clustering_id = clustering_id
        self.results = results
        VapiStruct.__init__(self)


ALBControllerNodeVMDeploymentRequestList._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_node_VM_deployment_request_list', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'clustering_id': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBControllerNodeVMDeploymentRequest'))),
    },
    ALBControllerNodeVMDeploymentRequestList,
    False,
    None))



class ALBControllerNodeVMDeploymentStatusReport(VapiStruct):
    """
    Contains up-to-date information relating to an auto-deployed VM, including
    its status and (potentially) an error message.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_NOT_AVAILABLE = "NOT_AVAILABLE"
    """


    """
    STATUS_VM_DEPLOYMENT_QUEUED = "VM_DEPLOYMENT_QUEUED"
    """


    """
    STATUS_VM_DEPLOYMENT_IN_PROGRESS = "VM_DEPLOYMENT_IN_PROGRESS"
    """


    """
    STATUS_VM_DEPLOYMENT_FAILED = "VM_DEPLOYMENT_FAILED"
    """


    """
    STATUS_VM_POWER_ON_IN_PROGRESS = "VM_POWER_ON_IN_PROGRESS"
    """


    """
    STATUS_VM_POWER_ON_FAILED = "VM_POWER_ON_FAILED"
    """


    """
    STATUS_VM_POWER_ON_SUCCESSFUL = "VM_POWER_ON_SUCCESSFUL"
    """


    """
    STATUS_VM_REGISTRATION_IN_PROGRESS = "VM_REGISTRATION_IN_PROGRESS"
    """


    """
    STATUS_VM_REGISTRATION_SUCCESSFUL = "VM_REGISTRATION_SUCCESSFUL"
    """


    """
    STATUS_VM_REGISTRATION_FAILED = "VM_REGISTRATION_FAILED"
    """


    """
    STATUS_VM_WAITING_TO_COME_ONLINE = "VM_WAITING_TO_COME_ONLINE"
    """


    """
    STATUS_VM_ONLINE_FAILED = "VM_ONLINE_FAILED"
    """


    """
    STATUS_VM_CONFIGURATION_IN_PROGRESS = "VM_CONFIGURATION_IN_PROGRESS"
    """


    """
    STATUS_VM_CONFIGURATION_SUCCESSFUL = "VM_CONFIGURATION_SUCCESSFUL"
    """


    """
    STATUS_VM_CONFIGURATION_FAILED = "VM_CONFIGURATION_FAILED"
    """


    """
    STATUS_VM_CLUSTERING_QUEUED = "VM_CLUSTERING_QUEUED"
    """


    """
    STATUS_VM_CLUSTERING_IN_PROGRESS = "VM_CLUSTERING_IN_PROGRESS"
    """


    """
    STATUS_VM_CLUSTERING_SUCCESSFUL = "VM_CLUSTERING_SUCCESSFUL"
    """


    """
    STATUS_VM_CLUSTERING_FAILED = "VM_CLUSTERING_FAILED"
    """


    """
    STATUS_VM_POWER_OFF_IN_PROGRESS = "VM_POWER_OFF_IN_PROGRESS"
    """


    """
    STATUS_VM_POWER_OFF_FAILED = "VM_POWER_OFF_FAILED"
    """


    """
    STATUS_WAITING_TO_UNDEPLOY_VM = "WAITING_TO_UNDEPLOY_VM"
    """


    """
    STATUS_VM_UNDEPLOY_IN_PROGRESS = "VM_UNDEPLOY_IN_PROGRESS"
    """


    """
    STATUS_VM_UNDEPLOY_FAILED = "VM_UNDEPLOY_FAILED"
    """


    """
    STATUS_VM_UNDEPLOY_SUCCESSFUL = "VM_UNDEPLOY_SUCCESSFUL"
    """


    """
    STATUS_UNKNOWN_STATE = "UNKNOWN_STATE"
    """


    """



    _canonical_to_pep_names = {
                            'deployment_progress_state': 'deployment_progress_state',
                            'failure_code': 'failure_code',
                            'failure_message': 'failure_message',
                            'status': 'status',
                            }

    def __init__(self,
                 deployment_progress_state=None,
                 failure_code=None,
                 failure_message=None,
                 status=None,
                ):
        """
        :type  deployment_progress_state: :class:`ALBControllerNodeVMDeploymentProgressState` or ``None``
        :param deployment_progress_state: 
        :type  failure_code: :class:`long` or ``None``
        :param failure_code: In case of auto-deployment-related failure, the code for the error
            will be stored here. format: int64
        :type  failure_message: :class:`str` or ``None``
        :param failure_message: In case of auto-deployment-related failure, an error message will
            be stored here.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_NOT_AVAILABLE`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_DEPLOYMENT_QUEUED`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_DEPLOYMENT_IN_PROGRESS`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_DEPLOYMENT_FAILED`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_POWER_ON_IN_PROGRESS`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_POWER_ON_FAILED`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_POWER_ON_SUCCESSFUL`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_REGISTRATION_IN_PROGRESS`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_REGISTRATION_SUCCESSFUL`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_REGISTRATION_FAILED`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_WAITING_TO_COME_ONLINE`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_ONLINE_FAILED`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_CONFIGURATION_IN_PROGRESS`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_CONFIGURATION_SUCCESSFUL`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_CONFIGURATION_FAILED`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_CLUSTERING_QUEUED`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_CLUSTERING_IN_PROGRESS`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_CLUSTERING_SUCCESSFUL`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_CLUSTERING_FAILED`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_POWER_OFF_IN_PROGRESS`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_POWER_OFF_FAILED`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_WAITING_TO_UNDEPLOY_VM`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_UNDEPLOY_IN_PROGRESS`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_UNDEPLOY_FAILED`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_UNDEPLOY_SUCCESSFUL`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_UNKNOWN_STATE`
            
            Status of the addition or deletion of an auto-deployed Advanced
            Load Balancer controller node VM.
        """
        self.deployment_progress_state = deployment_progress_state
        self.failure_code = failure_code
        self.failure_message = failure_message
        self.status = status
        VapiStruct.__init__(self)


ALBControllerNodeVMDeploymentStatusReport._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_node_VM_deployment_status_report', {
        'deployment_progress_state': type.OptionalType(type.ReferenceType(__name__, 'ALBControllerNodeVMDeploymentProgressState')),
        'failure_code': type.OptionalType(type.IntegerType()),
        'failure_message': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
    },
    ALBControllerNodeVMDeploymentStatusReport,
    False,
    None))



class ALBControllerSystemConfiguration(VapiStruct):
    """
    Advanced Load Balancer Controller System Configuration

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'backup_server_config': 'backup_server_config',
                            'clustering_id': 'clustering_id',
                            'dns_servers': 'dns_servers',
                            'ntp_servers': 'ntp_servers',
                            }

    def __init__(self,
                 backup_server_config=None,
                 clustering_id=None,
                 dns_servers=None,
                 ntp_servers=None,
                ):
        """
        :type  backup_server_config: :class:`ALBControllerBackupConfiguration` or ``None``
        :param backup_server_config: 
        :type  clustering_id: :class:`str` or ``None``
        :param clustering_id: Unique Id for NSX Advanced Load Balancer Controller Cluster used in
            VCF managed NSX.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  dns_servers: :class:`list` of :class:`str` or ``None``
        :param dns_servers: List of DNS servers. format: ipv4
        :type  ntp_servers: :class:`list` of :class:`str` or ``None``
        :param ntp_servers: List of NTP servers. format: hostname-or-ipv4
        """
        self.backup_server_config = backup_server_config
        self.clustering_id = clustering_id
        self.dns_servers = dns_servers
        self.ntp_servers = ntp_servers
        VapiStruct.__init__(self)


ALBControllerSystemConfiguration._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_system_configuration', {
        'backup_server_config': type.OptionalType(type.ReferenceType(__name__, 'ALBControllerBackupConfiguration')),
        'clustering_id': type.OptionalType(type.StringType()),
        'dns_servers': type.OptionalType(type.ListType(type.StringType())),
        'ntp_servers': type.OptionalType(type.ListType(type.StringType())),
    },
    ALBControllerSystemConfiguration,
    False,
    None))



class ALBControllerSystemConfigurationResponse(VapiStruct):
    """
    Advanced Load Balancer controller node system configuration update
    response.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'status': 'status',
                            }

    def __init__(self,
                 status=None,
                ):
        """
        :type  status: :class:`str` or ``None``
        :param status: Advanced Load Balancer controller node system configuration update
            status.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.status = status
        VapiStruct.__init__(self)


ALBControllerSystemConfigurationResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_system_configuration_response', {
        'status': type.OptionalType(type.StringType()),
    },
    ALBControllerSystemConfigurationResponse,
    False,
    None))



class ALBControllerUserCredential(VapiStruct):
    """
    Advanced Load Balancer Controller service user credential.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    USER_CREDENTIAL_TYPE_CONTROLLER_ADMIN_USER_CREDENTIAL = "CONTROLLER_ADMIN_USER_CREDENTIAL"
    """


    """
    USER_CREDENTIAL_TYPE_VCENTER_SERVICE_USER_CREDENTIAL = "VCENTER_SERVICE_USER_CREDENTIAL"
    """


    """
    USER_CREDENTIAL_TYPE_NSX_SERVICE_USER_CREDENTIAL = "NSX_SERVICE_USER_CREDENTIAL"
    """


    """



    _canonical_to_pep_names = {
                            'clustering_id': 'clustering_id',
                            'password': 'password',
                            'user_credential_type': 'user_credential_type',
                            'username': 'username',
                            }

    def __init__(self,
                 clustering_id=None,
                 password=None,
                 user_credential_type=None,
                 username=None,
                ):
        """
        :type  clustering_id: :class:`str` or ``None``
        :param clustering_id: Unique Id for NSX Advanced Load Balancer Controller Cluster used in
            VCF managed NSX.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  password: :class:`str` or ``None``
        :param password: Password for the user credential object.
        :type  user_credential_type: :class:`str` or ``None``
        :param user_credential_type: Possible values are: 
            
            *
              :attr:`ALBControllerUserCredential.USER_CREDENTIAL_TYPE_CONTROLLER_ADMIN_USER_CREDENTIAL`
            *
              :attr:`ALBControllerUserCredential.USER_CREDENTIAL_TYPE_VCENTER_SERVICE_USER_CREDENTIAL`
            *
              :attr:`ALBControllerUserCredential.USER_CREDENTIAL_TYPE_NSX_SERVICE_USER_CREDENTIAL`
            
            Type of user credential.
        :type  username: :class:`str` or ``None``
        :param username: Username for the credential object.
        """
        self.clustering_id = clustering_id
        self.password = password
        self.user_credential_type = user_credential_type
        self.username = username
        VapiStruct.__init__(self)


ALBControllerUserCredential._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_user_credential', {
        'clustering_id': type.OptionalType(type.StringType()),
        'password': type.OptionalType(type.StringType()),
        'user_credential_type': type.OptionalType(type.StringType()),
        'username': type.OptionalType(type.StringType()),
    },
    ALBControllerUserCredential,
    False,
    None))



class ALBControllerUserCredentialResponse(VapiStruct):
    """
    Advanced Load Balancer Controller service user credential response

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    USER_CREDENTIAL_TYPE_CONTROLLER_ADMIN_USER_CREDENTIAL = "CONTROLLER_ADMIN_USER_CREDENTIAL"
    """


    """
    USER_CREDENTIAL_TYPE_VCENTER_SERVICE_USER_CREDENTIAL = "VCENTER_SERVICE_USER_CREDENTIAL"
    """


    """
    USER_CREDENTIAL_TYPE_NSX_SERVICE_USER_CREDENTIAL = "NSX_SERVICE_USER_CREDENTIAL"
    """


    """



    _canonical_to_pep_names = {
                            'user_credential_type': 'user_credential_type',
                            'username': 'username',
                            }

    def __init__(self,
                 user_credential_type=None,
                 username=None,
                ):
        """
        :type  user_credential_type: :class:`str` or ``None``
        :param user_credential_type: Possible values are: 
            
            *
              :attr:`ALBControllerUserCredentialResponse.USER_CREDENTIAL_TYPE_CONTROLLER_ADMIN_USER_CREDENTIAL`
            *
              :attr:`ALBControllerUserCredentialResponse.USER_CREDENTIAL_TYPE_VCENTER_SERVICE_USER_CREDENTIAL`
            *
              :attr:`ALBControllerUserCredentialResponse.USER_CREDENTIAL_TYPE_NSX_SERVICE_USER_CREDENTIAL`
            
            Type of user credential.
        :type  username: :class:`str` or ``None``
        :param username: Username for the user credential object.
        """
        self.user_credential_type = user_credential_type
        self.username = username
        VapiStruct.__init__(self)


ALBControllerUserCredentialResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_user_credential_response', {
        'user_credential_type': type.OptionalType(type.StringType()),
        'username': type.OptionalType(type.StringType()),
    },
    ALBControllerUserCredentialResponse,
    False,
    None))



class ALGTypeServiceEntry(VapiStruct):
    """
    An ServiceEntry that represents an ALG protocol

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ALGTypeServiceEntry"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    ALG_ORACLE_TNS = "ORACLE_TNS"
    """


    """
    ALG_FTP = "FTP"
    """


    """
    ALG_SUN_RPC_TCP = "SUN_RPC_TCP"
    """


    """
    ALG_SUN_RPC_UDP = "SUN_RPC_UDP"
    """


    """
    ALG_MS_RPC_TCP = "MS_RPC_TCP"
    """


    """
    ALG_MS_RPC_UDP = "MS_RPC_UDP"
    """


    """
    ALG_NBNS_BROADCAST = "NBNS_BROADCAST"
    """


    """
    ALG_NBDG_BROADCAST = "NBDG_BROADCAST"
    """


    """
    ALG_TFTP = "TFTP"
    """


    """



    _canonical_to_pep_names = {
                            'alg': 'alg',
                            'destination_ports': 'destination_ports',
                            'source_ports': 'source_ports',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'origin_site_id': 'origin_site_id',
                            'owner_id': 'owner_id',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'remote_path': 'remote_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            }

    def __init__(self,
                 alg=None,
                 destination_ports=None,
                 source_ports=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='ALGTypeServiceEntry',
                 tags=None,
                 origin_site_id=None,
                 owner_id=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 remote_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                ):
        """
        :type  alg: :class:`str` or ``None``
        :param alg: Possible values are: 
            
            * :attr:`ALGTypeServiceEntry.ALG_ORACLE_TNS`
            * :attr:`ALGTypeServiceEntry.ALG_FTP`
            * :attr:`ALGTypeServiceEntry.ALG_SUN_RPC_TCP`
            * :attr:`ALGTypeServiceEntry.ALG_SUN_RPC_UDP`
            * :attr:`ALGTypeServiceEntry.ALG_MS_RPC_TCP`
            * :attr:`ALGTypeServiceEntry.ALG_MS_RPC_UDP`
            * :attr:`ALGTypeServiceEntry.ALG_NBNS_BROADCAST`
            * :attr:`ALGTypeServiceEntry.ALG_NBDG_BROADCAST`
            * :attr:`ALGTypeServiceEntry.ALG_TFTP`
            
            The Application Layer Gateway (ALG) protocol. Please note, protocol
            NBNS_BROADCAST and NBDG_BROADCAST are deprecated. Please use UDP
            protocol and create L4 Port Set type of service instead.
        :type  destination_ports: :class:`list` of :class:`str` or ``None``
        :param destination_ports: The destination_port cannot be empty and must be a single value.
            format: port-or-range
        :type  source_ports: :class:`list` of :class:`str` or ``None``
        :param source_ports: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`ServiceEntry.RESOURCE_TYPE_IPPROTOCOLSERVICEENTRY`
            * :attr:`ServiceEntry.RESOURCE_TYPE_IGMPTYPESERVICEENTRY`
            * :attr:`ServiceEntry.RESOURCE_TYPE_ICMPTYPESERVICEENTRY`
            * :attr:`ServiceEntry.RESOURCE_TYPE_ALGTYPESERVICEENTRY`
            * :attr:`ServiceEntry.RESOURCE_TYPE_L4PORTSETSERVICEENTRY`
            * :attr:`ServiceEntry.RESOURCE_TYPE_ETHERTYPESERVICEENTRY`
            * :attr:`ServiceEntry.RESOURCE_TYPE_NESTEDSERVICESERVICEENTRY`
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  origin_site_id: :class:`str` or ``None``
        :param origin_site_id: This is a UUID generated by the system for knowing which site owns
            an object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  owner_id: :class:`str` or ``None``
        :param owner_id: This is a UUID generated by the system for knowing who owns this
            object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated their unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_path: :class:`str` or ``None``
        :param remote_path: This is the path of the object on the local managers when queried
            on the NSX+ service, and path of the object on NSX+ service when
            queried from the local managers.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entities
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: Subtree for this type within policy tree containing nested
            elements. Note that this type is applicable to be used in
            Hierarchical API only.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.alg = alg
        self.destination_ports = destination_ports
        self.source_ports = source_ports
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.origin_site_id = origin_site_id
        self.owner_id = owner_id
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.remote_path = remote_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ALGTypeServiceEntry._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALG_type_service_entry', {
        'alg': type.OptionalType(type.StringType()),
        'destination_ports': type.OptionalType(type.ListType(type.StringType())),
        'source_ports': type.OptionalType(type.ListType(type.StringType())),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'origin_site_id': type.OptionalType(type.StringType()),
        'owner_id': type.OptionalType(type.StringType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'remote_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
    },
    ALGTypeServiceEntry,
    False,
    None))



class AbstractSpace(VapiStruct):
    """
    Represents the space in which the policy is being defined.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CONNECTIVITY_STRATEGY_WHITELIST = "WHITELIST"
    """


    """
    CONNECTIVITY_STRATEGY_BLACKLIST = "BLACKLIST"
    """


    """
    CONNECTIVITY_STRATEGY_WHITELIST_ENABLE_LOGGING = "WHITELIST_ENABLE_LOGGING"
    """


    """
    CONNECTIVITY_STRATEGY_BLACKLIST_ENABLE_LOGGING = "BLACKLIST_ENABLE_LOGGING"
    """


    """
    CONNECTIVITY_STRATEGY_NONE = "NONE"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'origin_site_id': 'origin_site_id',
                            'owner_id': 'owner_id',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'remote_path': 'remote_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'connectivity_strategy': 'connectivity_strategy',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 origin_site_id=None,
                 owner_id=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 remote_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 connectivity_strategy=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  origin_site_id: :class:`str` or ``None``
        :param origin_site_id: This is a UUID generated by the system for knowing which site owns
            an object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  owner_id: :class:`str` or ``None``
        :param owner_id: This is a UUID generated by the system for knowing who owns this
            object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated their unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_path: :class:`str` or ``None``
        :param remote_path: This is the path of the object on the local managers when queried
            on the NSX+ service, and path of the object on NSX+ service when
            queried from the local managers.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entities
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: Subtree for this type within policy tree containing nested
            elements. Note that this type is applicable to be used in
            Hierarchical API only.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  connectivity_strategy: :class:`str` or ``None``
        :param connectivity_strategy: Possible values are: 
            
            * :attr:`AbstractSpace.CONNECTIVITY_STRATEGY_WHITELIST`
            * :attr:`AbstractSpace.CONNECTIVITY_STRATEGY_BLACKLIST`
            *
              :attr:`AbstractSpace.CONNECTIVITY_STRATEGY_WHITELIST_ENABLE_LOGGING`
            *
              :attr:`AbstractSpace.CONNECTIVITY_STRATEGY_BLACKLIST_ENABLE_LOGGING`
            * :attr:`AbstractSpace.CONNECTIVITY_STRATEGY_NONE`
            
            The connectivity strategy is deprecated. Use default layer3 rule,
            /infra/domains/default/security-policies/default-layer3-security-policy/rules/default-layer3-rule.
            This field indicates the default connectivity policy for the infra
            or tenant space WHITELIST - Adds a default drop rule. Administrator
            can then use \"allow\" rules (aka whitelist) to allow traffic
            between groups BLACKLIST - Adds a default allow rule. Admin can
            then use \"drop\" rules (aka blacklist) to block traffic between
            groups WHITELIST_ENABLE_LOGGING - Whitelisting with logging enabled
            BLACKLIST_ENABLE_LOGGING - Blacklisting with logging enabled NONE -
            No default rules are added.

            .. deprecated:: unknown
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.origin_site_id = origin_site_id
        self.owner_id = owner_id
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.remote_path = remote_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.connectivity_strategy = connectivity_strategy
        VapiStruct.__init__(self)


AbstractSpace._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.abstract_space', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'origin_site_id': type.OptionalType(type.StringType()),
        'owner_id': type.OptionalType(type.StringType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'remote_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'connectivity_strategy': type.OptionalType(type.StringType()),
    },
    AbstractSpace,
    False,
    None))



class AcceptableComponentVersion(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    COMPONENT_TYPE_HOST = "HOST"
    """


    """
    COMPONENT_TYPE_EDGE = "EDGE"
    """


    """
    COMPONENT_TYPE_CCP = "CCP"
    """


    """
    COMPONENT_TYPE_MP = "MP"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'acceptable_versions': 'acceptable_versions',
                            'component_type': 'component_type',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 acceptable_versions=None,
                 component_type=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  acceptable_versions: :class:`list` of :class:`str` or ``None``
        :param acceptable_versions: List of component versions
        :type  component_type: :class:`str` or ``None``
        :param component_type: Possible values are: 
            
            * :attr:`AcceptableComponentVersion.COMPONENT_TYPE_HOST`
            * :attr:`AcceptableComponentVersion.COMPONENT_TYPE_EDGE`
            * :attr:`AcceptableComponentVersion.COMPONENT_TYPE_CCP`
            * :attr:`AcceptableComponentVersion.COMPONENT_TYPE_MP`
            
            Node type
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.acceptable_versions = acceptable_versions
        self.component_type = component_type
        VapiStruct.__init__(self)


AcceptableComponentVersion._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.acceptable_component_version', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'acceptable_versions': type.OptionalType(type.ListType(type.StringType())),
        'component_type': type.OptionalType(type.StringType()),
    },
    AcceptableComponentVersion,
    False,
    None))



class AcceptableComponentVersionList(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'results': 'results',
                            }

    def __init__(self,
                 results=None,
                ):
        """
        :type  results: :class:`list` of :class:`AcceptableComponentVersion` or ``None``
        :param results: Acceptable version whitelist for different components
        """
        self.results = results
        VapiStruct.__init__(self)


AcceptableComponentVersionList._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.acceptable_component_version_list', {
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AcceptableComponentVersion'))),
    },
    AcceptableComponentVersionList,
    False,
    None))



class Action(VapiStruct):
    """
    Reaction Action is the action to take when the stipulated criteria
    specified in the event exist over the source. Some example actions include:
    - Notify Admin (or VMC's SRE) via email. - Populate a specific label with
    the IPSec VPN Session. - Remove the IPSec VPN Session from a specific
    label.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "Action"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    RESOURCE_TYPE_PATCHRESOURCES = "PatchResources"
    """


    """
    RESOURCE_TYPE_SETFIELDS = "SetFields"
    """


    """



    _canonical_to_pep_names = {
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 resource_type='Action',
                ):
        """
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`Action.RESOURCE_TYPE_PATCHRESOURCES`
            * :attr:`Action.RESOURCE_TYPE_SETFIELDS`
            
            Reaction Action resource type.
        """
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

Action._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.action', {
        'resource_type': type.StringType(),
    },
    Action,
    False,
    None))



class ActionableResource(VapiStruct):
    """
    Resources managed during restore process

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'ip_address': 'ip_address',
                            'ipv6_address': 'ipv6_address',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 ip_address=None,
                 ipv6_address=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  ip_address: :class:`str` or ``None``
        :param ip_address: A resource reference on which actions can be performed format:
            hostname-or-ip
        :type  ipv6_address: :class:`str` or ``None``
        :param ipv6_address: IPv6 address of the current node format: hostname-or-ip
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.ip_address = ip_address
        self.ipv6_address = ipv6_address
        VapiStruct.__init__(self)


ActionableResource._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.actionable_resource', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'ip_address': type.OptionalType(type.StringType()),
        'ipv6_address': type.OptionalType(type.StringType()),
    },
    ActionableResource,
    False,
    None))



class ActionableResourceListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ActionableResource` or ``None``
        :param results: List results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ActionableResourceListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.actionable_resource_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ActionableResource'))),
    },
    ActionableResourceListResult,
    False,
    None))



class ActiveDirectoryIdentitySource(VapiStruct):
    """
    An identity source service that runs Microsoft Active Directory. The
    service allows selected user accounts defined in Active Directory to log
    into and access NSX-T.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ActiveDirectoryIdentitySource"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'alternative_domain_names': 'alternative_domain_names',
                            'base_dn': 'base_dn',
                            'domain_name': 'domain_name',
                            'ldap_servers': 'ldap_servers',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='ActiveDirectoryIdentitySource',
                 tags=None,
                 alternative_domain_names=None,
                 base_dn=None,
                 domain_name=None,
                 ldap_servers=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            *
              :attr:`LdapIdentitySource.RESOURCE_TYPE_ACTIVEDIRECTORYIDENTITYSOURCE`
            * :attr:`LdapIdentitySource.RESOURCE_TYPE_OPENLDAPIDENTITYSOURCE`
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  alternative_domain_names: :class:`list` of :class:`str` or ``None``
        :param alternative_domain_names: After parsing the \"user\\\\@domain\", the domain portion is used
            to select the LDAP identity source to use. Additional domains
            listed here will also be directed to this LDAP identity source. In
            Active Directory these are sometimes referred to as Alternative UPN
            Suffixes.
        :type  base_dn: :class:`str` or ``None``
        :param base_dn: The subtree of the LDAP identity source to search when locating
            users and groups.
        :type  domain_name: :class:`str` or ``None``
        :param domain_name: The name of the authentication domain. When users log into NSX
            using an identity of the form \"user\\\\@domain\", NSX uses the
            domain portion to determine which LDAP identity source to use.
        :type  ldap_servers: :class:`list` of :class:`IdentitySourceLdapServer` or ``None``
        :param ldap_servers: The list of LDAP servers that provide LDAP service for this
            identity source. Currently, only one LDAP server is supported.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.alternative_domain_names = alternative_domain_names
        self.base_dn = base_dn
        self.domain_name = domain_name
        self.ldap_servers = ldap_servers
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ActiveDirectoryIdentitySource._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.active_directory_identity_source', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'alternative_domain_names': type.OptionalType(type.ListType(type.StringType())),
        'base_dn': type.OptionalType(type.StringType()),
        'domain_name': type.OptionalType(type.StringType()),
        'ldap_servers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'IdentitySourceLdapServer'))),
    },
    ActiveDirectoryIdentitySource,
    False,
    None))



class AddALBControllerNodeVMInfo(VapiStruct):
    """
    Contains a list of Advanced Load Balancer controller node VM deployment
    requests.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'deployment_requests': 'deployment_requests',
                            }

    def __init__(self,
                 deployment_requests=None,
                ):
        """
        :type  deployment_requests: :class:`list` of :class:`ALBControllerNodeVMDeploymentRequest` or ``None``
        :param deployment_requests: Advanced Load Balancer Controller deployment requests to be
            deployed by NSX.
        """
        self.deployment_requests = deployment_requests
        VapiStruct.__init__(self)


AddALBControllerNodeVMInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.add_ALB_controller_node_VM_info', {
        'deployment_requests': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBControllerNodeVMDeploymentRequest'))),
    },
    AddALBControllerNodeVMInfo,
    False,
    None))



class AddressBindingEntry(VapiStruct):
    """
    An address binding entry is a combination of the IP-MAC-VLAN binding for a
    logical port. The address bindings can be obtained via various methods like
    ARP snooping, DHCP snooping etc. or by user configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    SOURCE_INVALID = "INVALID"
    """


    """
    SOURCE_UNKNOWN = "UNKNOWN"
    """


    """
    SOURCE_USER_DEFINED = "USER_DEFINED"
    """


    """
    SOURCE_ARP_SNOOPING = "ARP_SNOOPING"
    """


    """
    SOURCE_DHCP_SNOOPING = "DHCP_SNOOPING"
    """


    """
    SOURCE_VM_TOOLS = "VM_TOOLS"
    """


    """
    SOURCE_ND_SNOOPING = "ND_SNOOPING"
    """


    """
    SOURCE_DHCPV6_SNOOPING = "DHCPV6_SNOOPING"
    """


    """
    SOURCE_VM_TOOLS_V6 = "VM_TOOLS_V6"
    """


    """



    _canonical_to_pep_names = {
                            'binding': 'binding',
                            'binding_timestamp': 'binding_timestamp',
                            'source': 'source',
                            }

    def __init__(self,
                 binding=None,
                 binding_timestamp=None,
                 source=None,
                ):
        """
        :type  binding: :class:`PacketAddressClassifier` or ``None``
        :param binding: 
        :type  binding_timestamp: :class:`long` or ``None``
        :param binding_timestamp: Timestamp at which the binding was discovered via snooping or
            manually specified by the user format: int64
        :type  source: :class:`str` or ``None``
        :param source: Possible values are: 
            
            * :attr:`AddressBindingEntry.SOURCE_INVALID`
            * :attr:`AddressBindingEntry.SOURCE_UNKNOWN`
            * :attr:`AddressBindingEntry.SOURCE_USER_DEFINED`
            * :attr:`AddressBindingEntry.SOURCE_ARP_SNOOPING`
            * :attr:`AddressBindingEntry.SOURCE_DHCP_SNOOPING`
            * :attr:`AddressBindingEntry.SOURCE_VM_TOOLS`
            * :attr:`AddressBindingEntry.SOURCE_ND_SNOOPING`
            * :attr:`AddressBindingEntry.SOURCE_DHCPV6_SNOOPING`
            * :attr:`AddressBindingEntry.SOURCE_VM_TOOLS_V6`
            
            Source from which the address binding entry was obtained
        """
        self.binding = binding
        self.binding_timestamp = binding_timestamp
        self.source = source
        VapiStruct.__init__(self)


AddressBindingEntry._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.address_binding_entry', {
        'binding': type.OptionalType(type.ReferenceType(__name__, 'PacketAddressClassifier')),
        'binding_timestamp': type.OptionalType(type.IntegerType()),
        'source': type.OptionalType(type.StringType()),
    },
    AddressBindingEntry,
    False,
    None))



class AdvanceClusterRestoreInput(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'id': 'id',
                            'resources': 'resources',
                            }

    def __init__(self,
                 id=None,
                 resources=None,
                ):
        """
        :type  id: :class:`str` or ``None``
        :param id: Unique id of an instruction (as returned by the GET /restore/status
            call) for which input is to be provided
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  resources: :class:`list` of :class:`SelectableResourceReference` or ``None``
        :param resources: List of resources for which the instruction is applicable.
        """
        self.id = id
        self.resources = resources
        VapiStruct.__init__(self)


AdvanceClusterRestoreInput._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.advance_cluster_restore_input', {
        'id': type.OptionalType(type.StringType()),
        'resources': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'SelectableResourceReference'))),
    },
    AdvanceClusterRestoreInput,
    False,
    None))



class AdvanceClusterRestoreRequest(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'data': 'data',
                            }

    def __init__(self,
                 data=None,
                ):
        """
        :type  data: :class:`list` of :class:`AdvanceClusterRestoreInput` or ``None``
        :param data: List of instructions and their associated data
        """
        self.data = data
        VapiStruct.__init__(self)


AdvanceClusterRestoreRequest._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.advance_cluster_restore_request', {
        'data': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AdvanceClusterRestoreInput'))),
    },
    AdvanceClusterRestoreRequest,
    False,
    None))



class AdvanceServiceConfig(VapiStruct):
    """
    Contain optional configuration for deployment.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'kubectl_tool': 'kubectl_tool',
                            'messaging_service_name': 'messaging_service_name',
                            'service_name': 'service_name',
                            }

    def __init__(self,
                 kubectl_tool=None,
                 messaging_service_name=None,
                 service_name=None,
                ):
        """
        :type  kubectl_tool: :class:`str` or ``None``
        :param kubectl_tool: Filename of uploaded Kubernetes tools
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  messaging_service_name: :class:`str` or ``None``
        :param messaging_service_name: FQDN to access kafka messaging service pod.
        :type  service_name: :class:`str` or ``None``
        :param service_name: FQDN to access deployment pod.
        """
        self.kubectl_tool = kubectl_tool
        self.messaging_service_name = messaging_service_name
        self.service_name = service_name
        VapiStruct.__init__(self)


AdvanceServiceConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.advance_service_config', {
        'kubectl_tool': type.OptionalType(type.StringType()),
        'messaging_service_name': type.OptionalType(type.StringType()),
        'service_name': type.OptionalType(type.StringType()),
    },
    AdvanceServiceConfig,
    False,
    None))



class AdvancedConfig(VapiStruct):
    """
    These are advanced configuration options.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AdvancedConfig"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'high_performance_config_params': 'high_performance_config_params',
                            'high_performance_config_type': 'high_performance_config_type',
                            'version': 'version',
                            }

    def __init__(self,
                 high_performance_config_params=None,
                 high_performance_config_type='AdvancedConfig',
                 version=None,
                ):
        """
        :type  high_performance_config_params: :class:`list` of :class:`HighPerformanceConfigParams` or ``None``
        :param high_performance_config_params: List of parameters that could be used to configure high
            performance.
        :type  high_performance_config_type: :class:`str`
        :param high_performance_config_type: Possible values are: 
            
            *
              :attr:`HighPerformanceConfig.HIGH_PERFORMANCE_CONFIG_TYPE_ADV_CONFIG`
            *
              :attr:`HighPerformanceConfig.HIGH_PERFORMANCE_CONFIG_TYPE_DRIVER_CONFIG`
            *
              :attr:`HighPerformanceConfig.HIGH_PERFORMANCE_CONFIG_TYPE_MISC_CONFIG`
            
            The specific type of config.
        :type  version: :class:`list` of :class:`str` or ``None``
        :param version: Based on the high_performance_config_type, it could be either
            driver version or host version. For high_performance_config_type as
            ADV_CONFIG or MISC_CONFIG, this represents host version. For
            high_performance_config_type as DRIVER_CONFIG, this represents
            physical NIC driver version.
        """
        self.high_performance_config_params = high_performance_config_params
        self._high_performance_config_type = high_performance_config_type
        self.version = version
        VapiStruct.__init__(self)

    @property
    def high_performance_config_type(self):
        """
        Return the discriminator value
        """
        return self._high_performance_config_type

AdvancedConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.advanced_config', {
        'high_performance_config_params': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'HighPerformanceConfigParams'))),
        'high_performance_config_type': type.StringType(),
        'version': type.OptionalType(type.ListType(type.StringType())),
    },
    AdvancedConfig,
    False,
    None))



class AdvertisedNetworkCsvRecord(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'network': 'network',
                            'rule_filter_type': 'rule_filter_type',
                            'status': 'status',
                            }

    def __init__(self,
                 network=None,
                 rule_filter_type=None,
                 status=None,
                ):
        """
        :type  network: :class:`str` or ``None``
        :param network: Advertised network address.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  rule_filter_type: :class:`str` or ``None``
        :param rule_filter_type: Advertised rule filter type
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`str` or ``None``
        :param status: advertisement status of network to connected gateway SUCCESS -
            network route successfully plumbed on target gateway
            DENIED_BY_TARGET_GATEWAY - network denied by target gateway because
            of in filter rules or missing inter vrf config
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.network = network
        self.rule_filter_type = rule_filter_type
        self.status = status
        VapiStruct.__init__(self)


AdvertisedNetworkCsvRecord._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.advertised_network_csv_record', {
        'network': type.OptionalType(type.StringType()),
        'rule_filter_type': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
    },
    AdvertisedNetworkCsvRecord,
    False,
    None))



class AgentStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    NAME_AGENT = "NSX_AGENT"
    """


    """
    NAME_OPSAGENT = "NSX_OPSAGENT"
    """


    """
    NAME_CFGAGENT = "NSX_CFGAGENT"
    """


    """
    NAME_NESTDB = "NSX_NESTDB"
    """


    """
    STATUS_UP = "UP"
    """


    """
    STATUS_DOWN = "DOWN"
    """


    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """
    STATUS_DEGRADED = "DEGRADED"
    """


    """



    _canonical_to_pep_names = {
                            'components': 'components',
                            'last_status_changed_time': 'last_status_changed_time',
                            'name': 'name',
                            'status': 'status',
                            'status_description': 'status_description',
                            }

    def __init__(self,
                 components=None,
                 last_status_changed_time=None,
                 name=None,
                 status=None,
                 status_description=None,
                ):
        """
        :type  components: :class:`list` of :class:`AgentSubStatus` or ``None``
        :param components: List of agent subcomponent statuses
        :type  last_status_changed_time: :class:`long` or ``None``
        :param last_status_changed_time: Timestamp of the last status change, in epoch milliseconds format:
            int64
        :type  name: :class:`str` or ``None``
        :param name: Possible values are: 
            
            * :attr:`AgentStatus.NAME_AGENT`
            * :attr:`AgentStatus.NAME_OPSAGENT`
            * :attr:`AgentStatus.NAME_CFGAGENT`
            * :attr:`AgentStatus.NAME_NESTDB`
            
            Agent name
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`AgentStatus.STATUS_UP`
            * :attr:`AgentStatus.STATUS_DOWN`
            * :attr:`AgentStatus.STATUS_UNKNOWN`
            * :attr:`AgentStatus.STATUS_DEGRADED`
            
            Agent status
        :type  status_description: :class:`str` or ``None``
        :param status_description: Describe what makes the status not UP
        """
        self.components = components
        self.last_status_changed_time = last_status_changed_time
        self.name = name
        self.status = status
        self.status_description = status_description
        VapiStruct.__init__(self)


AgentStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.agent_status', {
        'components': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AgentSubStatus'))),
        'last_status_changed_time': type.OptionalType(type.IntegerType()),
        'name': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
        'status_description': type.OptionalType(type.StringType()),
    },
    AgentStatus,
    False,
    None))



class AgentStatusCount(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_UP = "UP"
    """


    """
    STATUS_DOWN = "DOWN"
    """


    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """
    STATUS_DEGRADED = "DEGRADED"
    """


    """



    _canonical_to_pep_names = {
                            'agents': 'agents',
                            'degraded_count': 'degraded_count',
                            'down_count': 'down_count',
                            'last_status_changed_time': 'last_status_changed_time',
                            'smartnic_agents': 'smartnic_agents',
                            'status': 'status',
                            'up_count': 'up_count',
                            }

    def __init__(self,
                 agents=None,
                 degraded_count=None,
                 down_count=None,
                 last_status_changed_time=None,
                 smartnic_agents=None,
                 status=None,
                 up_count=None,
                ):
        """
        :type  agents: :class:`list` of :class:`AgentStatus` or ``None``
        :param agents: List of agent statuses belonging to the transport node
        :type  degraded_count: :class:`long` or ``None``
        :param degraded_count: Degraded count format: int32
        :type  down_count: :class:`long` or ``None``
        :param down_count: Down count format: int32
        :type  last_status_changed_time: :class:`long` or ``None``
        :param last_status_changed_time: Timestamp of the last status change, in epoch milliseconds format:
            int64
        :type  smartnic_agents: :class:`list` of :class:`SmartnicAgentStatus` or ``None``
        :param smartnic_agents: List of Smartnic agent statuses
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`AgentStatusCount.STATUS_UP`
            * :attr:`AgentStatusCount.STATUS_DOWN`
            * :attr:`AgentStatusCount.STATUS_UNKNOWN`
            * :attr:`AgentStatusCount.STATUS_DEGRADED`
            
            Roll-up agent status
        :type  up_count: :class:`long` or ``None``
        :param up_count: Up count format: int32
        """
        self.agents = agents
        self.degraded_count = degraded_count
        self.down_count = down_count
        self.last_status_changed_time = last_status_changed_time
        self.smartnic_agents = smartnic_agents
        self.status = status
        self.up_count = up_count
        VapiStruct.__init__(self)


AgentStatusCount._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.agent_status_count', {
        'agents': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AgentStatus'))),
        'degraded_count': type.OptionalType(type.IntegerType()),
        'down_count': type.OptionalType(type.IntegerType()),
        'last_status_changed_time': type.OptionalType(type.IntegerType()),
        'smartnic_agents': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'SmartnicAgentStatus'))),
        'status': type.OptionalType(type.StringType()),
        'up_count': type.OptionalType(type.IntegerType()),
    },
    AgentStatusCount,
    False,
    None))



class AgentSubStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_UP = "UP"
    """


    """
    STATUS_DOWN = "DOWN"
    """


    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'name': 'name',
                            'status': 'status',
                            'status_description': 'status_description',
                            }

    def __init__(self,
                 name=None,
                 status=None,
                 status_description=None,
                ):
        """
        :type  name: :class:`str` or ``None``
        :param name: Agent subcomponent name
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`AgentSubStatus.STATUS_UP`
            * :attr:`AgentSubStatus.STATUS_DOWN`
            * :attr:`AgentSubStatus.STATUS_UNKNOWN`
            
            Agent subcomponent status
        :type  status_description: :class:`str` or ``None``
        :param status_description: Describe what makes the status not UP
        """
        self.name = name
        self.status = status
        self.status_description = status_description
        VapiStruct.__init__(self)


AgentSubStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.agent_sub_status', {
        'name': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
        'status_description': type.OptionalType(type.StringType()),
    },
    AgentSubStatus,
    False,
    None))



class AggregateDNSForwarderStatistics(VapiStruct):
    """
    Aggregate of DNS forwarder statistics across enforcement points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'statistics_per_enforcement_point': 'statistics_per_enforcement_point',
                            }

    def __init__(self,
                 intent_path=None,
                 statistics_per_enforcement_point=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: String path of the DNS forwarder intent.
        :type  statistics_per_enforcement_point: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param statistics_per_enforcement_point: List of DNS forwarder statistics per enforcement point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`DNSForwarderStatisticsPerEnforcementPoint`. When methods
            return a value of this class as a return value, the attribute will
            contain all the attributes defined in
            :class:`DNSForwarderStatisticsPerEnforcementPoint`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.statistics_per_enforcement_point = statistics_per_enforcement_point
        VapiStruct.__init__(self)


AggregateDNSForwarderStatistics._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_DNS_forwarder_statistics', {
        'intent_path': type.OptionalType(type.StringType()),
        'statistics_per_enforcement_point': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'DNSForwarderStatisticsPerEnforcementPoint')]))),
    },
    AggregateDNSForwarderStatistics,
    False,
    None))



class AggregateDNSForwarderStatus(VapiStruct):
    """
    Aggregate of DNS forwarder status across enforcement points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'status_per_enforcement_point': 'status_per_enforcement_point',
                            }

    def __init__(self,
                 intent_path=None,
                 status_per_enforcement_point=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: String path of the DNS forwarder intent.
        :type  status_per_enforcement_point: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param status_per_enforcement_point: List of DNS forwarder status per enforcement point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`DNSForwarderStatusPerEnforcementPoint`. When methods return
            a value of this class as a return value, the attribute will contain
            all the attributes defined in
            :class:`DNSForwarderStatusPerEnforcementPoint`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.status_per_enforcement_point = status_per_enforcement_point
        VapiStruct.__init__(self)


AggregateDNSForwarderStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_DNS_forwarder_status', {
        'intent_path': type.OptionalType(type.StringType()),
        'status_per_enforcement_point': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'DNSForwarderStatusPerEnforcementPoint')]))),
    },
    AggregateDNSForwarderStatus,
    False,
    None))



class AggregateIPSecVpnSessionStatistics(VapiStruct):
    """
    Aggregate of IPSec VPN Session Statistics across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: List of IPSec VPN Session Statistics per Enforcement Point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`IPSecVpnSessionStatisticsPerEP`. When methods return a
            value of this class as a return value, the attribute will contain
            all the attributes defined in
            :class:`IPSecVpnSessionStatisticsPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateIPSecVpnSessionStatistics._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_IP_sec_vpn_session_statistics', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'IPSecVpnSessionStatisticsPerEP')]))),
    },
    AggregateIPSecVpnSessionStatistics,
    False,
    None))



class AggregateIPSecVpnSessionStatus(VapiStruct):
    """
    Aggregate of IPSec VPN Session Status across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: List of IPSec VPN Session Status per Enforcement Point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`IPSecVpnSessionStatusPerEP`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`IPSecVpnSessionStatusPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateIPSecVpnSessionStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_IP_sec_vpn_session_status', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'IPSecVpnSessionStatusPerEP')]))),
    },
    AggregateIPSecVpnSessionStatus,
    False,
    None))



class AggregateL2VPNSessionPeerConfig(VapiStruct):
    """
    Aggregate of L2VPN Session peer config across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: List of L2VPN Session peer config per Enforcement Point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`L2VPNSessionPeerConfigPerEP`. When methods return a value
            of this class as a return value, the attribute will contain all the
            attributes defined in :class:`L2VPNSessionPeerConfigPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateL2VPNSessionPeerConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_l2_VPN_session_peer_config', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'L2VPNSessionPeerConfigPerEP')]))),
    },
    AggregateL2VPNSessionPeerConfig,
    False,
    None))



class AggregateL2VPNSessionStatistics(VapiStruct):
    """
    Aggregate of L2VPN Session Statistics across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: List of L2VPN Session Statistics per Enforcement Point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`L2VPNSessionStatisticsPerEP`. When methods return a value
            of this class as a return value, the attribute will contain all the
            attributes defined in :class:`L2VPNSessionStatisticsPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateL2VPNSessionStatistics._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_l2_VPN_session_statistics', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'L2VPNSessionStatisticsPerEP')]))),
    },
    AggregateL2VPNSessionStatistics,
    False,
    None))



class AggregateL2VPNSessionStatus(VapiStruct):
    """
    Aggregate of L2VPN Session Status across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: List of L2VPN Session Status per Enforcement Point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`L2VPNSessionStatusPerEP`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`L2VPNSessionStatusPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateL2VPNSessionStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_l2_VPN_session_status', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'L2VPNSessionStatusPerEP')]))),
    },
    AggregateL2VPNSessionStatus,
    False,
    None))



class AggregateL2VpnPeerConfig(VapiStruct):
    """
    Aggregate of L2Vpn peer config across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'l2vpn_path': 'l2vpn_path',
                            'l2vpn_peer_config_per_enforcement_point': 'l2vpn_peer_config_per_enforcement_point',
                            }

    def __init__(self,
                 l2vpn_path=None,
                 l2vpn_peer_config_per_enforcement_point=None,
                ):
        """
        :type  l2vpn_path: :class:`str` or ``None``
        :param l2vpn_path: Policy path referencing the L2Vpn.
        :type  l2vpn_peer_config_per_enforcement_point: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param l2vpn_peer_config_per_enforcement_point: List of L2Vpn peer config per Enforcement Point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`L2VpnPeerConfigPerEnforcementPoint`. When methods return a
            value of this class as a return value, the attribute will contain
            all the attributes defined in
            :class:`L2VpnPeerConfigPerEnforcementPoint`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.l2vpn_path = l2vpn_path
        self.l2vpn_peer_config_per_enforcement_point = l2vpn_peer_config_per_enforcement_point
        VapiStruct.__init__(self)


AggregateL2VpnPeerConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_l2_vpn_peer_config', {
        'l2vpn_path': type.OptionalType(type.StringType()),
        'l2vpn_peer_config_per_enforcement_point': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'L2VpnPeerConfigPerEnforcementPoint')]))),
    },
    AggregateL2VpnPeerConfig,
    False,
    None))



class AggregateL2VpnSessionRemoteMac(VapiStruct):
    """
    Aggregate of L2Vpn session remote mac across enforcement points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'l2vpn_session_remote_macs': 'l2vpn_session_remote_macs',
                            }

    def __init__(self,
                 intent_path=None,
                 l2vpn_session_remote_macs=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  l2vpn_session_remote_macs: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param l2vpn_session_remote_macs: List of L2Vpn Session remote mac
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`L2VpnSessionRemoteMacPerEP`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`L2VpnSessionRemoteMacPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.l2vpn_session_remote_macs = l2vpn_session_remote_macs
        VapiStruct.__init__(self)


AggregateL2VpnSessionRemoteMac._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_l2_vpn_session_remote_mac', {
        'intent_path': type.OptionalType(type.StringType()),
        'l2vpn_session_remote_macs': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'L2VpnSessionRemoteMacPerEP')]))),
    },
    AggregateL2VpnSessionRemoteMac,
    False,
    None))



class AggregateL2VpnStatistics(VapiStruct):
    """
    Aggregate of L2Vpn Statistics across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'l2vpn_statistics_per_enforcement_point': 'l2vpn_statistics_per_enforcement_point',
                            }

    def __init__(self,
                 intent_path=None,
                 l2vpn_statistics_per_enforcement_point=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
        :type  l2vpn_statistics_per_enforcement_point: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param l2vpn_statistics_per_enforcement_point: List of L2Vpn Statistics per Enforcement Point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`L2VpnStatisticsPerEnforcementPoint`. When methods return a
            value of this class as a return value, the attribute will contain
            all the attributes defined in
            :class:`L2VpnStatisticsPerEnforcementPoint`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.l2vpn_statistics_per_enforcement_point = l2vpn_statistics_per_enforcement_point
        VapiStruct.__init__(self)


AggregateL2VpnStatistics._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_l2_vpn_statistics', {
        'intent_path': type.OptionalType(type.StringType()),
        'l2vpn_statistics_per_enforcement_point': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'L2VpnStatisticsPerEnforcementPoint')]))),
    },
    AggregateL2VpnStatistics,
    False,
    None))



class AggregateL3VpnStatistics(VapiStruct):
    """
    Aggregate of L3Vpn Statistics across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'l3vpn_statistics_per_enforcement_point': 'l3vpn_statistics_per_enforcement_point',
                            }

    def __init__(self,
                 intent_path=None,
                 l3vpn_statistics_per_enforcement_point=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
        :type  l3vpn_statistics_per_enforcement_point: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param l3vpn_statistics_per_enforcement_point: List of L3Vpn Statistics per Enforcement Point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`L3VpnStatisticsPerEnforcementPoint`. When methods return a
            value of this class as a return value, the attribute will contain
            all the attributes defined in
            :class:`L3VpnStatisticsPerEnforcementPoint`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.l3vpn_statistics_per_enforcement_point = l3vpn_statistics_per_enforcement_point
        VapiStruct.__init__(self)


AggregateL3VpnStatistics._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_l3_vpn_statistics', {
        'intent_path': type.OptionalType(type.StringType()),
        'l3vpn_statistics_per_enforcement_point': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'L3VpnStatisticsPerEnforcementPoint')]))),
    },
    AggregateL3VpnStatistics,
    False,
    None))



class AggregateLBNodeUsageSummary(VapiStruct):
    """
    Aggregate of LBNodeUsageSummary across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`LBNodeUsageSummary` or ``None``
        :param results: LBNodeUsageSummary list results.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateLBNodeUsageSummary._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_LB_node_usage_summary', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'LBNodeUsageSummary'))),
    },
    AggregateLBNodeUsageSummary,
    False,
    None))



class AggregateLBPoolStatistics(VapiStruct):
    """
    Paged Collection of LBPoolStatisticsPerEP

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: LBPoolStatisticsPerEP list results.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`LBPoolStatisticsPerEP`. When methods return a value of this
            class as a return value, the attribute will contain all the
            attributes defined in :class:`LBPoolStatisticsPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateLBPoolStatistics._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_LB_pool_statistics', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'LBPoolStatisticsPerEP')]))),
    },
    AggregateLBPoolStatistics,
    False,
    None))



class AggregateLBPoolStatus(VapiStruct):
    """
    Paged Collection of LBPoolStatusPerEP

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: LBPoolStatusPerEP list results.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`LBPoolStatusPerEP`. When methods return a value of this
            class as a return value, the attribute will contain all the
            attributes defined in :class:`LBPoolStatusPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateLBPoolStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_LB_pool_status', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'LBPoolStatusPerEP')]))),
    },
    AggregateLBPoolStatus,
    False,
    None))



class AggregateLBServiceStatistics(VapiStruct):
    """
    Paged Collection of LBServiceStatisticsPerEP

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: LBServiceStatisticsPerEP list results.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`LBServiceStatisticsPerEP`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`LBServiceStatisticsPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateLBServiceStatistics._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_LB_service_statistics', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'LBServiceStatisticsPerEP')]))),
    },
    AggregateLBServiceStatistics,
    False,
    None))



class AggregateLBServiceStatus(VapiStruct):
    """
    Paged Collection of LBServiceStatusPerEP

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: LBServiceStatusPerEP list results.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`LBServiceStatusPerEP`. When methods return a value of this
            class as a return value, the attribute will contain all the
            attributes defined in :class:`LBServiceStatusPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateLBServiceStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_LB_service_status', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'LBServiceStatusPerEP')]))),
    },
    AggregateLBServiceStatus,
    False,
    None))



class AggregateLBServiceUsage(VapiStruct):
    """
    Aggregate of LBServiceUsagePerEP across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: LBServiceUsagePerEP list results.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`LBServiceUsagePerEP`. When methods return a value of this
            class as a return value, the attribute will contain all the
            attributes defined in :class:`LBServiceUsagePerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateLBServiceUsage._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_LB_service_usage', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'LBServiceUsagePerEP')]))),
    },
    AggregateLBServiceUsage,
    False,
    None))



class AggregateLBVirtualServerStatistics(VapiStruct):
    """
    Paged Collection of LBVirtualServerStatisticsPerEP

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: LBVirtualServerStatisticsPerEP list results.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`LBVirtualServerStatisticsPerEP`. When methods return a
            value of this class as a return value, the attribute will contain
            all the attributes defined in
            :class:`LBVirtualServerStatisticsPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateLBVirtualServerStatistics._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_LB_virtual_server_statistics', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'LBVirtualServerStatisticsPerEP')]))),
    },
    AggregateLBVirtualServerStatistics,
    False,
    None))



class AggregateLBVirtualServerStatus(VapiStruct):
    """
    Paged Collection of LBVirtualServerStatusPerEP

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            'results': 'results',
                            }

    def __init__(self,
                 intent_path=None,
                 results=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param results: LBVirtualServerStatusPerEP list results.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`LBVirtualServerStatusPerEP`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`LBVirtualServerStatusPerEP`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        self.results = results
        VapiStruct.__init__(self)


AggregateLBVirtualServerStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_LB_virtual_server_status', {
        'intent_path': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'LBVirtualServerStatusPerEP')]))),
    },
    AggregateLBVirtualServerStatus,
    False,
    None))



class AggregatePolicyDnsAnswer(VapiStruct):
    """
    Aggregate of DNS forwarder nslookup answer across enforcement points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'dns_answer_per_enforcement_point': 'dns_answer_per_enforcement_point',
                            'intent_path': 'intent_path',
                            }

    def __init__(self,
                 dns_answer_per_enforcement_point=None,
                 intent_path=None,
                ):
        """
        :type  dns_answer_per_enforcement_point: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param dns_answer_per_enforcement_point: List of DNS forwarder nslookup answer per enforcement point.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyDnsAnswerPerEnforcementPoint`. When methods return a
            value of this class as a return value, the attribute will contain
            all the attributes defined in
            :class:`PolicyDnsAnswerPerEnforcementPoint`.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: String path of the DNS forwarder intent.
        """
        self.dns_answer_per_enforcement_point = dns_answer_per_enforcement_point
        self.intent_path = intent_path
        VapiStruct.__init__(self)


AggregatePolicyDnsAnswer._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_policy_dns_answer', {
        'dns_answer_per_enforcement_point': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyDnsAnswerPerEnforcementPoint')]))),
        'intent_path': type.OptionalType(type.StringType()),
    },
    AggregatePolicyDnsAnswer,
    False,
    None))



class AggregatePolicyRuntimeInfo(VapiStruct):
    """
    Aggregate of PolicyRuntimeInfoPerEP across Enforcement Points.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'intent_path': 'intent_path',
                            }

    def __init__(self,
                 intent_path=None,
                ):
        """
        :type  intent_path: :class:`str` or ``None``
        :param intent_path: Intent path of object, forward slashes must be escaped using %2F.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.intent_path = intent_path
        VapiStruct.__init__(self)


AggregatePolicyRuntimeInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_policy_runtime_info', {
        'intent_path': type.OptionalType(type.StringType()),
    },
    AggregatePolicyRuntimeInfo,
    False,
    None))



class AggregateTunnelTrafficStatistics(VapiStruct):
    """
    Aggregate Tunnel Traffic Statistics object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AggregateTunnelTrafficStatistics"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    RESOURCE_TYPE_GRETUNNELAGGREGATETRAFFICSTATISTICS = "GreTunnelAggregateTrafficStatistics"
    """


    """



    _canonical_to_pep_names = {
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 resource_type='AggregateTunnelTrafficStatistics',
                ):
        """
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            *
              :attr:`AggregateTunnelTrafficStatistics.RESOURCE_TYPE_GRETUNNELAGGREGATETRAFFICSTATISTICS`
            
            GreTunnelAggregateTrafficStatistics - Resource type as
            GreTunnelAggregateTrafficStatistics will be used to populate P2P
            GRE Aggregate Tunnel traffic statistics
        """
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

AggregateTunnelTrafficStatistics._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregate_tunnel_traffic_statistics', {
        'resource_type': type.StringType(),
    },
    AggregateTunnelTrafficStatistics,
    False,
    None))



class AggregatedDataCounter(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'rx_bytes': 'rx_bytes',
                            'rx_packets': 'rx_packets',
                            'tx_bytes': 'tx_bytes',
                            'tx_packets': 'tx_packets',
                            }

    def __init__(self,
                 rx_bytes=None,
                 rx_packets=None,
                 tx_bytes=None,
                 tx_packets=None,
                ):
        """
        :type  rx_bytes: :class:`DataCounter` or ``None``
        :param rx_bytes: 
        :type  rx_packets: :class:`DataCounter` or ``None``
        :param rx_packets: 
        :type  tx_bytes: :class:`DataCounter` or ``None``
        :param tx_bytes: 
        :type  tx_packets: :class:`DataCounter` or ``None``
        :param tx_packets: 
        """
        self.rx_bytes = rx_bytes
        self.rx_packets = rx_packets
        self.tx_bytes = tx_bytes
        self.tx_packets = tx_packets
        VapiStruct.__init__(self)


AggregatedDataCounter._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregated_data_counter', {
        'rx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'rx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
    },
    AggregatedDataCounter,
    False,
    None))



class AggregatedDataCounterEx(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'rx_bytes': 'rx_bytes',
                            'rx_packets': 'rx_packets',
                            'tx_bytes': 'tx_bytes',
                            'tx_packets': 'tx_packets',
                            'dropped_by_firewall_packets': 'dropped_by_firewall_packets',
                            'dropped_by_security_packets': 'dropped_by_security_packets',
                            'mac_learning': 'mac_learning',
                            }

    def __init__(self,
                 rx_bytes=None,
                 rx_packets=None,
                 tx_bytes=None,
                 tx_packets=None,
                 dropped_by_firewall_packets=None,
                 dropped_by_security_packets=None,
                 mac_learning=None,
                ):
        """
        :type  rx_bytes: :class:`DataCounter` or ``None``
        :param rx_bytes: 
        :type  rx_packets: :class:`DataCounter` or ``None``
        :param rx_packets: 
        :type  tx_bytes: :class:`DataCounter` or ``None``
        :param tx_bytes: 
        :type  tx_packets: :class:`DataCounter` or ``None``
        :param tx_packets: 
        :type  dropped_by_firewall_packets: :class:`DfwDropCounters` or ``None``
        :param dropped_by_firewall_packets: 
        :type  dropped_by_security_packets: :class:`PacketsDroppedBySecurity` or ``None``
        :param dropped_by_security_packets: 
        :type  mac_learning: :class:`MacLearningCounters` or ``None``
        :param mac_learning: 
        """
        self.rx_bytes = rx_bytes
        self.rx_packets = rx_packets
        self.tx_bytes = tx_bytes
        self.tx_packets = tx_packets
        self.dropped_by_firewall_packets = dropped_by_firewall_packets
        self.dropped_by_security_packets = dropped_by_security_packets
        self.mac_learning = mac_learning
        VapiStruct.__init__(self)


AggregatedDataCounterEx._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregated_data_counter_ex', {
        'rx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'rx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'dropped_by_firewall_packets': type.OptionalType(type.ReferenceType(__name__, 'DfwDropCounters')),
        'dropped_by_security_packets': type.OptionalType(type.ReferenceType(__name__, 'PacketsDroppedBySecurity')),
        'mac_learning': type.OptionalType(type.ReferenceType(__name__, 'MacLearningCounters')),
    },
    AggregatedDataCounterEx,
    False,
    None))



class AggregatedFeatureDetailListResult(VapiStruct):
    """
    Paged Collection of AggregatedFeatureStateDetail

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`AggregatedFeatureStateDetails` or ``None``
        :param results: AggregatedFeatureStateDetail list results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


AggregatedFeatureDetailListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregated_feature_detail_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AggregatedFeatureStateDetails'))),
    },
    AggregatedFeatureDetailListResult,
    False,
    None))



class AggregatedFeatureListResult(VapiStruct):
    """
    Paged Collection of AggregatedFeatureState

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`AggregatedFeatureState` or ``None``
        :param results: AggregatedFeatureState list results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


AggregatedFeatureListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregated_feature_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AggregatedFeatureState'))),
    },
    AggregatedFeatureListResult,
    False,
    None))



class AggregatedFeatureState(VapiStruct):
    """
    Feature state aggregating both feature flag and license information

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATE_INCOMPATIBLE = "INCOMPATIBLE"
    """


    """
    STATE_DISABLED_AND_UNLICENSED = "DISABLED_AND_UNLICENSED"
    """


    """
    STATE_ENABLED_ONLY = "ENABLED_ONLY"
    """


    """
    STATE_LICENSED_ONLY = "LICENSED_ONLY"
    """


    """
    STATE_ENABLED_AND_LICENSED = "ENABLED_AND_LICENSED"
    """


    """



    _canonical_to_pep_names = {
                            'feature_name': 'feature_name',
                            'state': 'state',
                            }

    def __init__(self,
                 feature_name=None,
                 state=None,
                ):
        """
        :type  feature_name: :class:`str` or ``None``
        :param feature_name: feature name
        :type  state: :class:`str` or ``None``
        :param state: Possible values are: 
            
            * :attr:`AggregatedFeatureState.STATE_INCOMPATIBLE`
            * :attr:`AggregatedFeatureState.STATE_DISABLED_AND_UNLICENSED`
            * :attr:`AggregatedFeatureState.STATE_ENABLED_ONLY`
            * :attr:`AggregatedFeatureState.STATE_LICENSED_ONLY`
            * :attr:`AggregatedFeatureState.STATE_ENABLED_AND_LICENSED`
            
            Aggregated feature state
        """
        self.feature_name = feature_name
        self.state = state
        VapiStruct.__init__(self)


AggregatedFeatureState._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregated_feature_state', {
        'feature_name': type.OptionalType(type.StringType()),
        'state': type.OptionalType(type.StringType()),
    },
    AggregatedFeatureState,
    False,
    None))



class AggregatedFeatureStateDetails(VapiStruct):
    """
    Feature state aggregating both feature flag and license information
    including API details

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATE_INCOMPATIBLE = "INCOMPATIBLE"
    """


    """
    STATE_DISABLED_AND_UNLICENSED = "DISABLED_AND_UNLICENSED"
    """


    """
    STATE_ENABLED_ONLY = "ENABLED_ONLY"
    """


    """
    STATE_LICENSED_ONLY = "LICENSED_ONLY"
    """


    """
    STATE_ENABLED_AND_LICENSED = "ENABLED_AND_LICENSED"
    """


    """



    _canonical_to_pep_names = {
                            'apis': 'apis',
                            'attributes': 'attributes',
                            'enum_values': 'enum_values',
                            'feature_name': 'feature_name',
                            'state': 'state',
                            }

    def __init__(self,
                 apis=None,
                 attributes=None,
                 enum_values=None,
                 feature_name=None,
                 state=None,
                ):
        """
        :type  apis: :class:`list` of :class:`str` or ``None``
        :param apis: The list of APIs included in the named feature
        :type  attributes: :class:`list` of :class:`str` or ``None``
        :param attributes: The list of DTO attributes included in the named feature
        :type  enum_values: :class:`list` of :class:`str` or ``None``
        :param enum_values: The list of DTO attribute enum values included in the named feature
        :type  feature_name: :class:`str` or ``None``
        :param feature_name: feature name
        :type  state: :class:`str` or ``None``
        :param state: Possible values are: 
            
            * :attr:`AggregatedFeatureStateDetails.STATE_INCOMPATIBLE`
            *
              :attr:`AggregatedFeatureStateDetails.STATE_DISABLED_AND_UNLICENSED`
            * :attr:`AggregatedFeatureStateDetails.STATE_ENABLED_ONLY`
            * :attr:`AggregatedFeatureStateDetails.STATE_LICENSED_ONLY`
            * :attr:`AggregatedFeatureStateDetails.STATE_ENABLED_AND_LICENSED`
            
            Aggregated feature state
        """
        self.apis = apis
        self.attributes = attributes
        self.enum_values = enum_values
        self.feature_name = feature_name
        self.state = state
        VapiStruct.__init__(self)


AggregatedFeatureStateDetails._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregated_feature_state_details', {
        'apis': type.OptionalType(type.ListType(type.StringType())),
        'attributes': type.OptionalType(type.ListType(type.StringType())),
        'enum_values': type.OptionalType(type.ListType(type.StringType())),
        'feature_name': type.OptionalType(type.StringType()),
        'state': type.OptionalType(type.StringType()),
    },
    AggregatedFeatureStateDetails,
    False,
    None))



class AggregatedLogicalRouterPortCounters(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'last_update_timestamp': 'last_update_timestamp',
                            'rx': 'rx',
                            'tx': 'tx',
                            }

    def __init__(self,
                 last_update_timestamp=None,
                 rx=None,
                 tx=None,
                ):
        """
        :type  last_update_timestamp: :class:`long` or ``None``
        :param last_update_timestamp: Timestamp when the data was last updated; unset if data source has
            never updated the data. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  rx: :class:`LogicalRouterPortCounters` or ``None``
        :param rx: 
        :type  tx: :class:`LogicalRouterPortCounters` or ``None``
        :param tx: 
        """
        self.last_update_timestamp = last_update_timestamp
        self.rx = rx
        self.tx = tx
        VapiStruct.__init__(self)


AggregatedLogicalRouterPortCounters._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.aggregated_logical_router_port_counters', {
        'last_update_timestamp': type.OptionalType(type.IntegerType()),
        'rx': type.OptionalType(type.ReferenceType(__name__, 'LogicalRouterPortCounters')),
        'tx': type.OptionalType(type.ReferenceType(__name__, 'LogicalRouterPortCounters')),
    },
    AggregatedLogicalRouterPortCounters,
    False,
    None))



class AlbControllerClusterRuntimeError(VapiStruct):
    """
    Advanced Load Balancer controller cluster runtime error.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'error_code': 'error_code',
                            'error_message': 'error_message',
                            }

    def __init__(self,
                 error_code=None,
                 error_message=None,
                ):
        """
        :type  error_code: :class:`long` or ``None``
        :param error_code: Advanced Load Balancer cluster runtime error code. format: int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  error_message: :class:`str` or ``None``
        :param error_message: Advanced Load Balancer cluster runtime error msg.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.error_code = error_code
        self.error_message = error_message
        VapiStruct.__init__(self)


AlbControllerClusterRuntimeError._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.alb_controller_cluster_runtime_error', {
        'error_code': type.OptionalType(type.IntegerType()),
        'error_message': type.OptionalType(type.StringType()),
    },
    AlbControllerClusterRuntimeError,
    False,
    None))



class AlbControllerVsphereClusterNodeVmDeploymentConfig(VapiStruct):
    """
    The vSphere deployment configuration determines where to deploy the
    Advanced Load Balancer controller node VM through a vCenter server. It
    contains settings that are applied during install time. If using DHCP, the
    following fields must be left unset - management_port_subnets, and
    default_gateway_addresses

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AlbControllerVsphereClusterNodeVmDeploymentConfig"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    DISK_PROVISIONING_THIN = "THIN"
    """


    """
    DISK_PROVISIONING_LAZY_ZEROED_THICK = "LAZY_ZEROED_THICK"
    """


    """
    DISK_PROVISIONING_EAGER_ZEROED_THICK = "EAGER_ZEROED_THICK"
    """


    """



    _canonical_to_pep_names = {
                            'compute_id': 'compute_id',
                            'default_gateway_addresses': 'default_gateway_addresses',
                            'disk_provisioning': 'disk_provisioning',
                            'display_name': 'display_name',
                            'dns_servers': 'dns_servers',
                            'host_id': 'host_id',
                            'hostname': 'hostname',
                            'management_network_id': 'management_network_id',
                            'management_port_subnets': 'management_port_subnets',
                            'ntp_servers': 'ntp_servers',
                            'storage_id': 'storage_id',
                            'storage_policy_id': 'storage_policy_id',
                            'vc_id': 'vc_id',
                            'placement_type': 'placement_type',
                            }

    def __init__(self,
                 compute_id=None,
                 default_gateway_addresses=None,
                 disk_provisioning=None,
                 display_name=None,
                 dns_servers=None,
                 host_id=None,
                 hostname=None,
                 management_network_id=None,
                 management_port_subnets=None,
                 ntp_servers=None,
                 storage_id=None,
                 storage_policy_id=None,
                 vc_id=None,
                 placement_type='AlbControllerVsphereClusterNodeVmDeploymentConfig',
                ):
        """
        :type  compute_id: :class:`str` or ``None``
        :param compute_id: The Advanced Load Balancer controller node VM will be deployed on
            the specified cluster or resourcepool for specified VC server.
        :type  default_gateway_addresses: :class:`list` of :class:`str` or ``None``
        :param default_gateway_addresses: The default gateway for the VM to be deployed must be specified if
            all the other VMs it communicates with are not in the same subnet.
            Do not specify this field and management_port_subnets to use DHCP.
            Note: only single IPv4 default gateway address is supported and it
            must belong to management network. format: ip
        :type  disk_provisioning: :class:`str` or ``None``
        :param disk_provisioning: Possible values are: 
            
            *
              :attr:`AlbControllerVsphereClusterNodeVmDeploymentConfig.DISK_PROVISIONING_THIN`
            *
              :attr:`AlbControllerVsphereClusterNodeVmDeploymentConfig.DISK_PROVISIONING_LAZY_ZEROED_THICK`
            *
              :attr:`AlbControllerVsphereClusterNodeVmDeploymentConfig.DISK_PROVISIONING_EAGER_ZEROED_THICK`
            
            Specifies the disk provisioning type of the VM.
        :type  display_name: :class:`str` or ``None``
        :param display_name: Desired display name for Advanced Load Balancer controller VM to be
            deployed.
        :type  dns_servers: :class:`list` of :class:`str` or ``None``
        :param dns_servers: List of DNS servers. format: ipv4
        :type  host_id: :class:`str` or ``None``
        :param host_id: The Advanced Load Balancer controller node VM will be deployed on
            the specified host in the specified VC server within the cluster if
            host_id is specified. Note: User must ensure that storage and
            specified networks are accessible by this host.
        :type  hostname: :class:`str` or ``None``
        :param hostname: Desired host name/FQDN for the VM to be deployed. format:
            hostname-or-ip
        :type  management_network_id: :class:`str` or ``None``
        :param management_network_id: Distributed portgroup identifier to which the management vnic of
            Advanced Load Balancer controller node VM will be connected.
        :type  management_port_subnets: :class:`list` of :class:`IPSubnet` or ``None``
        :param management_port_subnets: IP Address and subnet configuration for the management port. Do not
            specify this field and default_gateway_addresses to use DHCP. Note:
            only one IPv4 address is supported for the management port.
        :type  ntp_servers: :class:`list` of :class:`str` or ``None``
        :param ntp_servers: List of NTP servers. format: hostname-or-ipv4
        :type  storage_id: :class:`str` or ``None``
        :param storage_id: The Advanced Load Balancer controller node VM will be deployed on
            the specified datastore in the specified VC server. User must
            ensure that storage is accessible by the specified cluster/host.
        :type  storage_policy_id: :class:`str` or ``None``
        :param storage_policy_id: The cluster node VM will be deployed with the specified storage
            policy on the specified datastore in the specified VC server. User
            must ensure that the storage policy is applicable on the given
            datastore.
        :type  vc_id: :class:`str` or ``None``
        :param vc_id: The VC-specific identifiers will be resolved on this VC, so all
            other identifiers specified in the config must belong to this
            vCenter server.
        :type  placement_type: :class:`str`
        :param placement_type: Possible values are: 
            
            *
              :attr:`ALBControllerNodeVMDeploymentConfig.PLACEMENT_TYPE_ALBCONTROLLERVSPHERECLUSTERNODEVMDEPLOYMENTCONFIG`
            
            Specifies the config for the platform through which to deploy the
            VM.
        """
        self.compute_id = compute_id
        self.default_gateway_addresses = default_gateway_addresses
        self.disk_provisioning = disk_provisioning
        self.display_name = display_name
        self.dns_servers = dns_servers
        self.host_id = host_id
        self.hostname = hostname
        self.management_network_id = management_network_id
        self.management_port_subnets = management_port_subnets
        self.ntp_servers = ntp_servers
        self.storage_id = storage_id
        self.storage_policy_id = storage_policy_id
        self.vc_id = vc_id
        self._placement_type = placement_type
        VapiStruct.__init__(self)

    @property
    def placement_type(self):
        """
        Return the discriminator value
        """
        return self._placement_type

AlbControllerVsphereClusterNodeVmDeploymentConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.alb_controller_vsphere_cluster_node_vm_deployment_config', {
        'compute_id': type.OptionalType(type.StringType()),
        'default_gateway_addresses': type.OptionalType(type.ListType(type.StringType())),
        'disk_provisioning': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'dns_servers': type.OptionalType(type.ListType(type.StringType())),
        'host_id': type.OptionalType(type.StringType()),
        'hostname': type.OptionalType(type.StringType()),
        'management_network_id': type.OptionalType(type.StringType()),
        'management_port_subnets': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'IPSubnet'))),
        'ntp_servers': type.OptionalType(type.ListType(type.StringType())),
        'storage_id': type.OptionalType(type.StringType()),
        'storage_policy_id': type.OptionalType(type.StringType()),
        'vc_id': type.OptionalType(type.StringType()),
        'placement_type': type.StringType(),
    },
    AlbControllerVsphereClusterNodeVmDeploymentConfig,
    False,
    None))



class AnalyticsMaintenanceMode(VapiStruct):
    """
    Set Analytics agents to maintenance mode during cluster changes.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'agent_error_message': 'agent_error_message',
                            'enable': 'enable',
                            }

    def __init__(self,
                 agent_error_message=None,
                 enable=None,
                ):
        """
        :type  agent_error_message: :class:`str` or ``None``
        :param agent_error_message: string describing the error
        :type  enable: :class:`bool` or ``None``
        :param enable: Activate/deactivate maintenance mode
        """
        self.agent_error_message = agent_error_message
        self.enable = enable
        VapiStruct.__init__(self)


AnalyticsMaintenanceMode._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.analytics_maintenance_mode', {
        'agent_error_message': type.OptionalType(type.StringType()),
        'enable': type.OptionalType(type.BooleanType()),
    },
    AnalyticsMaintenanceMode,
    False,
    None))



class AntreaAdapterStatus(VapiStruct):
    """
    Antrea adapter status

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_HEALTHY = "HEALTHY"
    """


    """
    STATUS_DEGRADED = "DEGRADED"
    """


    """
    STATUS_FAILED = "FAILED"
    """


    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'conditions': 'conditions',
                            'status': 'status',
                            }

    def __init__(self,
                 conditions=None,
                 status=None,
                ):
        """
        :type  conditions: :class:`list` of :class:`ComponentConditionItem` or ``None``
        :param conditions: Collection of adapter conditions.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`AntreaAdapterStatus.STATUS_HEALTHY`
            * :attr:`AntreaAdapterStatus.STATUS_DEGRADED`
            * :attr:`AntreaAdapterStatus.STATUS_FAILED`
            * :attr:`AntreaAdapterStatus.STATUS_UNKNOWN`
            
            Indicate overall healthy status.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.conditions = conditions
        self.status = status
        VapiStruct.__init__(self)


AntreaAdapterStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.antrea_adapter_status', {
        'conditions': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ComponentConditionItem'))),
        'status': type.OptionalType(type.StringType()),
    },
    AntreaAdapterStatus,
    False,
    None))



class AntreaAgentsInfo(VapiStruct):
    """
    Antrea agents information

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'degraded_agent_num': 'degraded_agent_num',
                            'failed_agent_num': 'failed_agent_num',
                            'healthy_agent_num': 'healthy_agent_num',
                            }

    def __init__(self,
                 degraded_agent_num=None,
                 failed_agent_num=None,
                 healthy_agent_num=None,
                ):
        """
        :type  degraded_agent_num: :class:`long` or ``None``
        :param degraded_agent_num: The number of degraded agents format: int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  failed_agent_num: :class:`long` or ``None``
        :param failed_agent_num: The number of failed agents format: int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  healthy_agent_num: :class:`long` or ``None``
        :param healthy_agent_num: The number of healthy agents format: int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.degraded_agent_num = degraded_agent_num
        self.failed_agent_num = failed_agent_num
        self.healthy_agent_num = healthy_agent_num
        VapiStruct.__init__(self)


AntreaAgentsInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.antrea_agents_info', {
        'degraded_agent_num': type.OptionalType(type.IntegerType()),
        'failed_agent_num': type.OptionalType(type.IntegerType()),
        'healthy_agent_num': type.OptionalType(type.IntegerType()),
    },
    AntreaAgentsInfo,
    False,
    None))



class AntreaClusterInfo(VapiStruct):
    """
    Antrea cluster status info.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_HEALTHY = "HEALTHY"
    """


    """
    STATUS_DEGRADED = "DEGRADED"
    """


    """
    STATUS_FAILED = "FAILED"
    """


    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'origin_site_id': 'origin_site_id',
                            'owner_id': 'owner_id',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'remote_path': 'remote_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'agent_info': 'agent_info',
                            'ccp_adapter_status': 'ccp_adapter_status',
                            'controller_status': 'controller_status',
                            'mp_adapter_status': 'mp_adapter_status',
                            'status': 'status',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 origin_site_id=None,
                 owner_id=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 remote_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 agent_info=None,
                 ccp_adapter_status=None,
                 controller_status=None,
                 mp_adapter_status=None,
                 status=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  origin_site_id: :class:`str` or ``None``
        :param origin_site_id: This is a UUID generated by the system for knowing which site owns
            an object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  owner_id: :class:`str` or ``None``
        :param owner_id: This is a UUID generated by the system for knowing who owns this
            object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated their unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_path: :class:`str` or ``None``
        :param remote_path: This is the path of the object on the local managers when queried
            on the NSX+ service, and path of the object on NSX+ service when
            queried from the local managers.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entities
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: Subtree for this type within policy tree containing nested
            elements. Note that this type is applicable to be used in
            Hierarchical API only.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  agent_info: :class:`AntreaAgentsInfo` or ``None``
        :param agent_info: 
        :type  ccp_adapter_status: :class:`AntreaAdapterStatus` or ``None``
        :param ccp_adapter_status: 
        :type  controller_status: :class:`AntreaControllerStatus` or ``None``
        :param controller_status: 
        :type  mp_adapter_status: :class:`AntreaAdapterStatus` or ``None``
        :param mp_adapter_status: 
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`AntreaClusterInfo.STATUS_HEALTHY`
            * :attr:`AntreaClusterInfo.STATUS_DEGRADED`
            * :attr:`AntreaClusterInfo.STATUS_FAILED`
            * :attr:`AntreaClusterInfo.STATUS_UNKNOWN`
            
            Roll-up status of components
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.origin_site_id = origin_site_id
        self.owner_id = owner_id
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.remote_path = remote_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.agent_info = agent_info
        self.ccp_adapter_status = ccp_adapter_status
        self.controller_status = controller_status
        self.mp_adapter_status = mp_adapter_status
        self.status = status
        VapiStruct.__init__(self)


AntreaClusterInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.antrea_cluster_info', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'origin_site_id': type.OptionalType(type.StringType()),
        'owner_id': type.OptionalType(type.StringType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'remote_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'agent_info': type.OptionalType(type.ReferenceType(__name__, 'AntreaAgentsInfo')),
        'ccp_adapter_status': type.OptionalType(type.ReferenceType(__name__, 'AntreaAdapterStatus')),
        'controller_status': type.OptionalType(type.ReferenceType(__name__, 'AntreaControllerStatus')),
        'mp_adapter_status': type.OptionalType(type.ReferenceType(__name__, 'AntreaAdapterStatus')),
        'status': type.OptionalType(type.StringType()),
    },
    AntreaClusterInfo,
    False,
    None))



class AntreaClusterListResult(VapiStruct):
    """
    Paged list of Antrea Cluster list.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`AntreaClusterInfo` or ``None``
        :param results: Antrea cluster list results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


AntreaClusterListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.antrea_cluster_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AntreaClusterInfo'))),
    },
    AntreaClusterListResult,
    False,
    None))



class AntreaControllerStatus(VapiStruct):
    """
    Antrea Controller status, including component status, connected agent and
    CONTROLLER_ prefix conditions status.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_HEALTHY = "HEALTHY"
    """


    """
    STATUS_DEGRADED = "DEGRADED"
    """


    """
    STATUS_FAILED = "FAILED"
    """


    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'conditions': 'conditions',
                            'connected_agent_num': 'connected_agent_num',
                            'status': 'status',
                            }

    def __init__(self,
                 conditions=None,
                 connected_agent_num=None,
                 status=None,
                ):
        """
        :type  conditions: :class:`list` of :class:`ComponentConditionItem` or ``None``
        :param conditions: Collection of controller related conditions.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  connected_agent_num: :class:`long` or ``None``
        :param connected_agent_num: If status is UNKNOWN, this number is meaningless. format: int32
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`AntreaControllerStatus.STATUS_HEALTHY`
            * :attr:`AntreaControllerStatus.STATUS_DEGRADED`
            * :attr:`AntreaControllerStatus.STATUS_FAILED`
            * :attr:`AntreaControllerStatus.STATUS_UNKNOWN`
            
            Indicate overall healthy status.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.conditions = conditions
        self.connected_agent_num = connected_agent_num
        self.status = status
        VapiStruct.__init__(self)


AntreaControllerStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.antrea_controller_status', {
        'conditions': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ComponentConditionItem'))),
        'connected_agent_num': type.OptionalType(type.IntegerType()),
        'status': type.OptionalType(type.StringType()),
    },
    AntreaControllerStatus,
    False,
    None))



class AntreaHeartbeatConfig(VapiStruct):
    """
    Antrea heartbeat configuration for interval time.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'origin_site_id': 'origin_site_id',
                            'owner_id': 'owner_id',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'remote_path': 'remote_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'report_interval': 'report_interval',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 origin_site_id=None,
                 owner_id=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 remote_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 report_interval=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  origin_site_id: :class:`str` or ``None``
        :param origin_site_id: This is a UUID generated by the system for knowing which site owns
            an object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  owner_id: :class:`str` or ``None``
        :param owner_id: This is a UUID generated by the system for knowing who owns this
            object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated their unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_path: :class:`str` or ``None``
        :param remote_path: This is the path of the object on the local managers when queried
            on the NSX+ service, and path of the object on NSX+ service when
            queried from the local managers.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entities
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: Subtree for this type within policy tree containing nested
            elements. Note that this type is applicable to be used in
            Hierarchical API only.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  report_interval: :class:`long` or ``None``
        :param report_interval: If exceeding 3\*report_interval, there is still no heartbeat,
            cluster status will be UNKNOWN. format: int32
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.origin_site_id = origin_site_id
        self.owner_id = owner_id
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.remote_path = remote_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.report_interval = report_interval
        VapiStruct.__init__(self)


AntreaHeartbeatConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.antrea_heartbeat_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'origin_site_id': type.OptionalType(type.StringType()),
        'owner_id': type.OptionalType(type.StringType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'remote_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'report_interval': type.OptionalType(type.IntegerType()),
    },
    AntreaHeartbeatConfig,
    False,
    None))



class AntreaHeartbeatConfigListResult(VapiStruct):
    """
    Paged list of Antrea Cluster heartbeat config.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`AntreaHeartbeatConfig` or ``None``
        :param results: List of Antrea cluster heartbeat config.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


AntreaHeartbeatConfigListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.antrea_heartbeat_config_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AntreaHeartbeatConfig'))),
    },
    AntreaHeartbeatConfigListResult,
    False,
    None))



class AntreaTraceflowConfig(VapiStruct):
    """
    The configuration for Antrea traceflow.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'origin_site_id': 'origin_site_id',
                            'owner_id': 'owner_id',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'remote_path': 'remote_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'container_cluster_id': 'container_cluster_id',
                            'destination_external_id': 'destination_external_id',
                            'is_transient': 'is_transient',
                            'packet': 'packet',
                            'source_external_id': 'source_external_id',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 origin_site_id=None,
                 owner_id=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 remote_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 container_cluster_id=None,
                 destination_external_id=None,
                 is_transient=None,
                 packet=None,
                 source_external_id=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  origin_site_id: :class:`str` or ``None``
        :param origin_site_id: This is a UUID generated by the system for knowing which site owns
            an object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  owner_id: :class:`str` or ``None``
        :param owner_id: This is a UUID generated by the system for knowing who owns this
            object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated their unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_path: :class:`str` or ``None``
        :param remote_path: This is the path of the object on the local managers when queried
            on the NSX+ service, and path of the object on NSX+ service when
            queried from the local managers.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entities
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: Subtree for this type within policy tree containing nested
            elements. Note that this type is applicable to be used in
            Hierarchical API only.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  container_cluster_id: :class:`str` or ``None``
        :param container_cluster_id: Container cluster ID in inventory. This property is used to
            identify multiple clusters under single NSX-T.
        :type  destination_external_id: :class:`str` or ``None``
        :param destination_external_id: Destination external id for Antrea traceflow. Must be
            ContainerApplicationInstance or ContainerApplication. Ignored if
            destination_ip provided in packet data.
        :type  is_transient: :class:`bool` or ``None``
        :param is_transient: This field indicates if intent is transient and will be cleaned up
            by the system if set to true.
        :type  packet: :class:`AntreaTraceflowPacketData` or ``None``
        :param packet: 
        :type  source_external_id: :class:`str` or ``None``
        :param source_external_id: Source external id for Antrea traceflow. Must be
            ContainerApplicationInstance external_id.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.origin_site_id = origin_site_id
        self.owner_id = owner_id
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.remote_path = remote_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.container_cluster_id = container_cluster_id
        self.destination_external_id = destination_external_id
        self.is_transient = is_transient
        self.packet = packet
        self.source_external_id = source_external_id
        VapiStruct.__init__(self)


AntreaTraceflowConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.antrea_traceflow_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'origin_site_id': type.OptionalType(type.StringType()),
        'owner_id': type.OptionalType(type.StringType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'remote_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'container_cluster_id': type.OptionalType(type.StringType()),
        'destination_external_id': type.OptionalType(type.StringType()),
        'is_transient': type.OptionalType(type.BooleanType()),
        'packet': type.OptionalType(type.ReferenceType(__name__, 'AntreaTraceflowPacketData')),
        'source_external_id': type.OptionalType(type.StringType()),
    },
    AntreaTraceflowConfig,
    False,
    None))



class AntreaTraceflowConfigListResult(VapiStruct):
    """
    Paged Collection for AntreaTraceflowConfigs.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`AntreaTraceflowConfig` or ``None``
        :param results: AntreaTraceflowConfig list results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


AntreaTraceflowConfigListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.antrea_traceflow_config_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AntreaTraceflowConfig'))),
    },
    AntreaTraceflowConfigListResult,
    False,
    None))



class AntreaTraceflowIcmpEchoRequestHeader(VapiStruct):
    """
    IcmpEchoRequest header stuffs for Antrea traceflow.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'id': 'id',
                            'sequence': 'sequence',
                            }

    def __init__(self,
                 id=None,
                 sequence=None,
                ):
        """
        :type  id: :class:`long` or ``None``
        :param id: Id of IcmpEchoRequest. format: int64
        :type  sequence: :class:`long` or ``None``
        :param sequence: Sequence number of IcmpEchoRequest. format: int64
        """
        self.id = id
        self.sequence = sequence
        VapiStruct.__init__(self)


AntreaTraceflowIcmpEchoRequestHeader._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.antrea_traceflow_icmp_echo_request_header', {
        'id': type.OptionalType(type.IntegerType()),
        'sequence': type.OptionalType(type.IntegerType()),
    },
    AntreaTraceflowIcmpEchoRequestHeader,
    False,
    None))



class AntreaTraceflowIpHeader(VapiStruct):
    """
    Ip header stuffs for Antrea traceflow.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'dstIp': 'dst_ip',
                            'flags': 'flags',
                            'protocol': 'protocol',
                            'srcIp': 'src_ip',
                            'ttl': 'ttl',
                            }

    def __init__(self,
                 dst_ip=None,
                 flags=None,
                 protocol=None,
                 src_ip=None,
                 ttl=None,
                ):
        """
        :type  dst_ip: :class:`str` or ``None``
        :param dst_ip: Destination ip address in IpHeader.
        :type  flags: :class:`long` or ``None``
        :param flags: Protocol setting in IpHeader. format: int64
        :type  protocol: :class:`long` or ``None``
        :param protocol: Protocol setting in IpHeader. format: int64
        :type  src_ip: :class:`str` or ``None``
        :param src_ip: Source ip address in IpHeader.
        :type  ttl: :class:`long` or ``None``
        :param ttl: TTL value in IpHeader. Default is 64. format: int64
        """
        self.dst_ip = dst_ip
        self.flags = flags
        self.protocol = protocol
        self.src_ip = src_ip
        self.ttl = ttl
        VapiStruct.__init__(self)


AntreaTraceflowIpHeader._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.antrea_traceflow_ip_header', {
        'dstIp': type.OptionalType(type.StringType()),
        'flags': type.OptionalType(type.IntegerType()),
        'protocol': type.OptionalType(type.IntegerType()),
        'srcIp': type.OptionalType(type.StringType()),
        'ttl': type.OptionalType(type.IntegerType()),
    },
    AntreaTraceflowIpHeader,
    False,
    None))



class AntreaTraceflowIpv6Header(VapiStruct):
    """
    Ipv6 header stuffs for Antrea traceflow.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'dstIp': 'dst_ip',
                            'hopLimit': 'hop_limit',
                            'nextHeader': 'next_header',
                            'srcIp': 'src_ip',
                            }

    def __init__(self,
                 dst_ip=None,
                 hop_limit=None,
                 next_header=None,
                 src_ip=None,
                ):
        """
        :type  dst_ip: :class:`str` or ``None``
        :param dst_ip: Destination ip address in Ipv6Header.
        :type  hop_limit: :class:`long` or ``None``
        :param hop_limit: Hop limit setting in Ipv6Header. format: int64
        :type  next_header: :class:`long` or ``None``
        :param next_header: Next header setting in Ipv6Header. format: int64
        :type  src_ip: :class:`str` or ``None``
        :param src_ip: Source ip address in Ipv6Header.
        """
        self.dst_ip = dst_ip
        self.hop_limit = hop_limit
        self.next_header = next_header
        self.src_ip = src_ip
        VapiStruct.__init__(self)


AntreaTraceflowIpv6Header._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.antrea_traceflow_ipv6_header', {
        'dstIp': type.OptionalType(type.StringType()),
        'hopLimit': type.OptionalType(type.IntegerType()),
        'nextHeader': type.OptionalType(type.IntegerType()),
        'srcIp': type.OptionalType(type.StringType()),
    },
    AntreaTraceflowIpv6Header,
    False,
    None))



class AntreaTraceflowObservation(VapiStruct):
    """
    Observation result for Antrea traceflow.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    COMPONENT_TYPE_UNKNOWN = "UNKNOWN"
    """


    """
    COMPONENT_TYPE_ANTREA_SPOOFGUARD = "ANTREA_SPOOFGUARD"
    """


    """
    COMPONENT_TYPE_ANTREA_LB = "ANTREA_LB"
    """


    """
    COMPONENT_TYPE_ANTREA_ROUTING = "ANTREA_ROUTING"
    """


    """
    COMPONENT_TYPE_ANTREA_DFW = "ANTREA_DFW"
    """


    """
    COMPONENT_TYPE_ANTREA_FORWARDING = "ANTREA_FORWARDING"
    """


    """
    OBSERVATION_TYPE_ANTREATRACEFLOWOBSERVATIONDELIVERED = "AntreaTraceflowObservationDelivered"
    """


    """
    OBSERVATION_TYPE_ANTREATRACEFLOWOBSERVATIONRECEIVED = "AntreaTraceflowObservationReceived"
    """


    """
    OBSERVATION_TYPE_ANTREATRACEFLOWOBSERVATIONFORWARDED = "AntreaTraceflowObservationForwarded"
    """


    """
    OBSERVATION_TYPE_ANTREATRACEFLOWOBSERVATIONDROPPED = "AntreaTraceflowObservationDropped"
    """


    """



    _canonical_to_pep_names = {
                            'component_type': 'component_type',
                            'container_node_id': 'container_node_id',
                            'observation_type': 'observation_type',
                            'timestamp': 'timestamp',
                            }

    def __init__(self,
                 component_type=None,
                 container_node_id=None,
                 observation_type=None,
                 timestamp=None,
                ):
        """
        :type  component_type: :class:`str` or ``None``
        :param component_type: Possible values are: 
            
            * :attr:`AntreaTraceflowObservation.COMPONENT_TYPE_UNKNOWN`
            *
              :attr:`AntreaTraceflowObservation.COMPONENT_TYPE_ANTREA_SPOOFGUARD`
            * :attr:`AntreaTraceflowObservation.COMPONENT_TYPE_ANTREA_LB`
            * :attr:`AntreaTraceflowObservation.COMPONENT_TYPE_ANTREA_ROUTING`
            * :attr:`AntreaTraceflowObservation.COMPONENT_TYPE_ANTREA_DFW`
            *
              :attr:`AntreaTraceflowObservation.COMPONENT_TYPE_ANTREA_FORWARDING`
            
            The type of component.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  container_node_id: :class:`str` or ``None``
        :param container_node_id: UID of the container node that observed a traceflow packet.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  observation_type: :class:`str` or ``None``
        :param observation_type: Possible values are: 
            
            *
              :attr:`AntreaTraceflowObservation.OBSERVATION_TYPE_ANTREATRACEFLOWOBSERVATIONDELIVERED`
            *
              :attr:`AntreaTraceflowObservation.OBSERVATION_TYPE_ANTREATRACEFLOWOBSERVATIONRECEIVED`
            *
              :attr:`AntreaTraceflowObservation.OBSERVATION_TYPE_ANTREATRACEFLOWOBSERVATIONFORWARDED`
            *
              :attr:`AntreaTraceflowObservation.OBSERVATION_TYPE_ANTREATRACEFLOWOBSERVATIONDROPPED`
            
            The type of observation. AntreaTraceflowObservationDelivered: The
            packet was delivered to destination Pod properly
            AntreaTraceflowObservationReceived: The packet was received from
            another ContainerNode AntreaTraceflowObservationForwarded: The
            packet was forwarded to next logical node or ContainerNode
            AntreaTraceflowObservationDropped: The packet was dropped
        :type  timestamp: :class:`long` or ``None``
        :param timestamp: Timestamp when the observation was collect by Antrea controller.
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.component_type = component_type
        self.container_node_id = container_node_id
        self.observation_type = observation_type
        self.timestamp = timestamp
        VapiStruct.__init__(self)


AntreaTraceflowObservation._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.antrea_traceflow_observation', {
        'component_type': type.OptionalType(type.StringType()),
        'container_node_id': type.OptionalType(type.StringType()),
        'observation_type': type.OptionalType(type.StringType()),
        'timestamp': type.OptionalType(type.IntegerType()),
    },
    AntreaTraceflowObservation,
    False,
    None))



class AntreaTraceflowObservationListResult(VapiStruct):
    """
    List collection for AnteaTraceflowObservation, used in batch API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`AntreaTraceflowObservation` or ``None``
        :param results: AntreaTraceflowObservation list results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


AntreaTraceflowObservationListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.antrea_traceflow_observation_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AntreaTraceflowObservation'))),
    },
    AntreaTraceflowObservationListResult,
    False,
    None))



class AntreaTraceflowPacketData(VapiStruct):
    """
    Packet data stuffs for Antrea traceflow.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    RESOURCE_TYPE_FIELDS_PACKET_DATA = "FIELDS_PACKET_DATA"
    """


    """
    RESOURCE_TYPE_BINARY_PACKET_DATA = "BINARY_PACKET_DATA"
    """


    """
    TRANSPORT_TYPE_UNICAST = "UNICAST"
    """


    """
    TRANSPORT_TYPE_MULTICAST = "MULTICAST"
    """


    """
    TRANSPORT_TYPE_BROADCAST = "BROADCAST"
    """


    """
    TRANSPORT_TYPE_UNKNOWN = "UNKNOWN"
    """


    """



    _canonical_to_pep_names = {
                            'frameSize': 'frame_size',
                            'ipHeader': 'ip_header',
                            'ipv6Header': 'ipv6_header',
                            'payload': 'payload',
                            'resourceType': 'resource_type',
                            'transportHeader': 'transport_header',
                            'transportType': 'transport_type',
                            }

    def __init__(self,
                 frame_size=None,
                 ip_header=None,
                 ipv6_header=None,
                 payload=None,
                 resource_type=None,
                 transport_header=None,
                 transport_type=None,
                ):
        """
        :type  frame_size: :class:`long` or ``None``
        :param frame_size: This property is used to set packet data size. format: int64
        :type  ip_header: :class:`AntreaTraceflowIpHeader` or ``None``
        :param ip_header: 
        :type  ipv6_header: :class:`AntreaTraceflowIpv6Header` or ``None``
        :param ipv6_header: 
        :type  payload: :class:`str` or ``None``
        :param payload: This property is used to set payload data.
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: Possible values are: 
            
            *
              :attr:`AntreaTraceflowPacketData.RESOURCE_TYPE_FIELDS_PACKET_DATA`
            *
              :attr:`AntreaTraceflowPacketData.RESOURCE_TYPE_BINARY_PACKET_DATA`
            
            This property is used to set resource type.
        :type  transport_header: :class:`AntreaTraceflowTransportHeader` or ``None``
        :param transport_header: 
        :type  transport_type: :class:`str` or ``None``
        :param transport_type: Possible values are: 
            
            * :attr:`AntreaTraceflowPacketData.TRANSPORT_TYPE_UNICAST`
            * :attr:`AntreaTraceflowPacketData.TRANSPORT_TYPE_MULTICAST`
            * :attr:`AntreaTraceflowPacketData.TRANSPORT_TYPE_BROADCAST`
            * :attr:`AntreaTraceflowPacketData.TRANSPORT_TYPE_UNKNOWN`
            
            This property is used to set transport type.
        """
        self.frame_size = frame_size
        self.ip_header = ip_header
        self.ipv6_header = ipv6_header
        self.payload = payload
        self.resource_type = resource_type
        self.transport_header = transport_header
        self.transport_type = transport_type
        VapiStruct.__init__(self)


AntreaTraceflowPacketData._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.antrea_traceflow_packet_data', {
        'frameSize': type.OptionalType(type.IntegerType()),
        'ipHeader': type.OptionalType(type.ReferenceType(__name__, 'AntreaTraceflowIpHeader')),
        'ipv6Header': type.OptionalType(type.ReferenceType(__name__, 'AntreaTraceflowIpv6Header')),
        'payload': type.OptionalType(type.StringType()),
        'resourceType': type.OptionalType(type.StringType()),
        'transportHeader': type.OptionalType(type.ReferenceType(__name__, 'AntreaTraceflowTransportHeader')),
        'transportType': type.OptionalType(type.StringType()),
    },
    AntreaTraceflowPacketData,
    False,
    None))



class AntreaTraceflowStatus(VapiStruct):
    """
    The status value of one Antrea traceflow.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    PHASE_SUCCEEDED = "SUCCEEDED"
    """


    """
    PHASE_FAILED = "FAILED"
    """


    """



    _canonical_to_pep_names = {
                            'phase': 'phase',
                            'reason': 'reason',
                            }

    def __init__(self,
                 phase=None,
                 reason=None,
                ):
        """
        :type  phase: :class:`str` or ``None``
        :param phase: Possible values are: 
            
            * :attr:`AntreaTraceflowStatus.PHASE_SUCCEEDED`
            * :attr:`AntreaTraceflowStatus.PHASE_FAILED`
            
            The execution phase of one traceflow.
        :type  reason: :class:`str` or ``None``
        :param reason: The reason for the failure.
        """
        self.phase = phase
        self.reason = reason
        VapiStruct.__init__(self)


AntreaTraceflowStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.antrea_traceflow_status', {
        'phase': type.OptionalType(type.StringType()),
        'reason': type.OptionalType(type.StringType()),
    },
    AntreaTraceflowStatus,
    False,
    None))



class AntreaTraceflowTcpHeader(VapiStruct):
    """
    Tcp header stuffs for Antrea traceflow.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'dstPort': 'dst_port',
                            'srcPort': 'src_port',
                            'tcpFlags': 'tcp_flags',
                            }

    def __init__(self,
                 dst_port=None,
                 src_port=None,
                 tcp_flags=None,
                ):
        """
        :type  dst_port: :class:`long` or ``None``
        :param dst_port: Destination port number in TcpHeader. format: int64
        :type  src_port: :class:`long` or ``None``
        :param src_port: Source port number in TcpHeader. format: int64
        :type  tcp_flags: :class:`long` or ``None``
        :param tcp_flags: Tcp flags in TcpHeader. SYN flag must be set for traceflow. format:
            int64
        """
        self.dst_port = dst_port
        self.src_port = src_port
        self.tcp_flags = tcp_flags
        VapiStruct.__init__(self)


AntreaTraceflowTcpHeader._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.antrea_traceflow_tcp_header', {
        'dstPort': type.OptionalType(type.IntegerType()),
        'srcPort': type.OptionalType(type.IntegerType()),
        'tcpFlags': type.OptionalType(type.IntegerType()),
    },
    AntreaTraceflowTcpHeader,
    False,
    None))



class AntreaTraceflowTransportHeader(VapiStruct):
    """
    Transport header stuffs for Antrea traceflow.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'icmpEchoRequestHeader': 'icmp_echo_request_header',
                            'tcpHeader': 'tcp_header',
                            'udpHeader': 'udp_header',
                            }

    def __init__(self,
                 icmp_echo_request_header=None,
                 tcp_header=None,
                 udp_header=None,
                ):
        """
        :type  icmp_echo_request_header: :class:`AntreaTraceflowIcmpEchoRequestHeader` or ``None``
        :param icmp_echo_request_header: 
        :type  tcp_header: :class:`AntreaTraceflowTcpHeader` or ``None``
        :param tcp_header: 
        :type  udp_header: :class:`AntreaTraceflowUdpHeader` or ``None``
        :param udp_header: 
        """
        self.icmp_echo_request_header = icmp_echo_request_header
        self.tcp_header = tcp_header
        self.udp_header = udp_header
        VapiStruct.__init__(self)


AntreaTraceflowTransportHeader._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.antrea_traceflow_transport_header', {
        'icmpEchoRequestHeader': type.OptionalType(type.ReferenceType(__name__, 'AntreaTraceflowIcmpEchoRequestHeader')),
        'tcpHeader': type.OptionalType(type.ReferenceType(__name__, 'AntreaTraceflowTcpHeader')),
        'udpHeader': type.OptionalType(type.ReferenceType(__name__, 'AntreaTraceflowUdpHeader')),
    },
    AntreaTraceflowTransportHeader,
    False,
    None))



class AntreaTraceflowUdpHeader(VapiStruct):
    """
    Udp header stuffs for Antrea traceflow.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'dstPort': 'dst_port',
                            'srcPort': 'src_port',
                            }

    def __init__(self,
                 dst_port=None,
                 src_port=None,
                ):
        """
        :type  dst_port: :class:`long` or ``None``
        :param dst_port: Destination port number in UdpHeader. format: int64
        :type  src_port: :class:`long` or ``None``
        :param src_port: Source port number in UdpHeader. format: int64
        """
        self.dst_port = dst_port
        self.src_port = src_port
        VapiStruct.__init__(self)


AntreaTraceflowUdpHeader._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.antrea_traceflow_udp_header', {
        'dstPort': type.OptionalType(type.IntegerType()),
        'srcPort': type.OptionalType(type.IntegerType()),
    },
    AntreaTraceflowUdpHeader,
    False,
    None))



class ApiError(VapiStruct):
    """
    Detailed information about an API Error

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'details': 'details',
                            'error_code': 'error_code',
                            'error_data': 'error_data',
                            'error_message': 'error_message',
                            'module_name': 'module_name',
                            'related_errors': 'related_errors',
                            }

    def __init__(self,
                 details=None,
                 error_code=None,
                 error_data=None,
                 error_message=None,
                 module_name=None,
                 related_errors=None,
                ):
        """
        :type  details: :class:`str` or ``None``
        :param details: Further details about the error
        :type  error_code: :class:`long` or ``None``
        :param error_code: A numeric error code format: int64
        :type  error_data: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param error_data: Additional data about the error
        :type  error_message: :class:`str` or ``None``
        :param error_message: A description of the error
        :type  module_name: :class:`str` or ``None``
        :param module_name: The module name where the error occurred
        :type  related_errors: :class:`list` of :class:`RelatedApiError` or ``None``
        :param related_errors: Other errors related to this error
        """
        self.details = details
        self.error_code = error_code
        self.error_data = error_data
        self.error_message = error_message
        self.module_name = module_name
        self.related_errors = related_errors
        VapiStruct.__init__(self)


ApiError._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.api_error', {
        'details': type.OptionalType(type.StringType()),
        'error_code': type.OptionalType(type.IntegerType()),
        'error_data': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
        'error_message': type.OptionalType(type.StringType()),
        'module_name': type.OptionalType(type.StringType()),
        'related_errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'RelatedApiError'))),
    },
    ApiError,
    False,
    None))



class ApiRequestBody(VapiStruct):
    """
    API Request Body is an Event Source that represents an API request body
    that is being reveived as part of an API. Supported Request Bodies are
    those received as part of a PATCH/PUT/POST request.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ApiRequestBody"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'resource_pointer': 'resource_pointer',
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 resource_pointer=None,
                 resource_type='ApiRequestBody',
                ):
        """
        :type  resource_pointer: :class:`str` or ``None``
        :param resource_pointer: Regex path representing a regex expression on resources. This regex
            is used to identify the request body(ies) that is/are the source of
            the Event. For instance: specifying \"Lb\* |
            /infra/tier-0s/vmc/ipsec-vpn-services/default\" as a source means
            that ANY resource starting with Lb or ANY resource with
            \"/infra/tier-0s/vmc/ipsec-vpn-services/default\" as path would be
            the source of the event in question.
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`Source.RESOURCE_TYPE_RESOURCEOPERATION`
            * :attr:`Source.RESOURCE_TYPE_APIREQUESTBODY`
            
            Event Source resource type.
        """
        self.resource_pointer = resource_pointer
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ApiRequestBody._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.api_request_body', {
        'resource_pointer': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
    },
    ApiRequestBody,
    False,
    None))



class ApiServiceConfig(VapiStruct):
    """
    Properties that affect the configuration of the NSX API service.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'basic_authentication_enabled': 'basic_authentication_enabled',
                            'cipher_suites': 'cipher_suites',
                            'client_api_concurrency_limit': 'client_api_concurrency_limit',
                            'client_api_rate_limit': 'client_api_rate_limit',
                            'connection_timeout': 'connection_timeout',
                            'cookie_based_authentication_enabled': 'cookie_based_authentication_enabled',
                            'global_api_concurrency_limit': 'global_api_concurrency_limit',
                            'lockout_immune_addresses': 'lockout_immune_addresses',
                            'protocol_versions': 'protocol_versions',
                            'redirect_host': 'redirect_host',
                            'session_timeout': 'session_timeout',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 basic_authentication_enabled=None,
                 cipher_suites=None,
                 client_api_concurrency_limit=None,
                 client_api_rate_limit=None,
                 connection_timeout=None,
                 cookie_based_authentication_enabled=None,
                 global_api_concurrency_limit=None,
                 lockout_immune_addresses=None,
                 protocol_versions=None,
                 redirect_host=None,
                 session_timeout=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  basic_authentication_enabled: :class:`bool` or ``None``
        :param basic_authentication_enabled: Identifies whether basic authentication is enabled or disabled in
            API calls.
        :type  cipher_suites: :class:`list` of :class:`CipherSuite` or ``None``
        :param cipher_suites: The TLS cipher suites that the API service will negotiate.
        :type  client_api_concurrency_limit: :class:`long` or ``None``
        :param client_api_concurrency_limit: The maximum number of concurrent API requests that will be serviced
            for a given authenticated client. If the number of API requests
            being processed exceeds this limit, new API requests will be
            refused and a 503 Service Unavailable response will be returned to
            the client. To disable API concurrency limiting, set this value to
            0. format: int64
        :type  client_api_rate_limit: :class:`long` or ``None``
        :param client_api_rate_limit: The maximum number of API requests that will be serviced per second
            for a given authenticated client. If more API requests are received
            than can be serviced, a 429 Too Many Requests HTTP response will be
            returned. To disable API rate limiting, set this value to 0.
            format: int64
        :type  connection_timeout: :class:`long` or ``None``
        :param connection_timeout: NSX connection timeout, in seconds. To disable timeout, set to 0.
            format: int64
        :type  cookie_based_authentication_enabled: :class:`bool` or ``None``
        :param cookie_based_authentication_enabled: Identifies whether cookie-based authentication is enabled or
            disabled in API calls. When cookie-based authentication is
            disabled, new sessions cannot be created via /api/session/create.
        :type  global_api_concurrency_limit: :class:`long` or ``None``
        :param global_api_concurrency_limit: The maximum number of concurrent API requests that will be
            serviced. If the number of API requests being processed exceeds
            this limit, new API requests will be refused and a 503 Service
            Unavailable response will be returned to the client. To disable API
            concurrency limiting, set this value to 0. format: int64
        :type  lockout_immune_addresses: :class:`list` of :class:`str` or ``None``
        :param lockout_immune_addresses: The list of IP addresses which are not subjected to a lockout on
            failed login attempts. format: ip
        :type  protocol_versions: :class:`list` of :class:`ProtocolVersion` or ``None``
        :param protocol_versions: The TLS protocol versions that the API service will negotiate.
        :type  redirect_host: :class:`str` or ``None``
        :param redirect_host: Host name or IP address to use for redirect location headers, or
            empty string to derive from current request. To disable, set
            redirect_host to the empty string (\"\").
        :type  session_timeout: :class:`long` or ``None``
        :param session_timeout: NSX session inactivity timeout format: int64
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.basic_authentication_enabled = basic_authentication_enabled
        self.cipher_suites = cipher_suites
        self.client_api_concurrency_limit = client_api_concurrency_limit
        self.client_api_rate_limit = client_api_rate_limit
        self.connection_timeout = connection_timeout
        self.cookie_based_authentication_enabled = cookie_based_authentication_enabled
        self.global_api_concurrency_limit = global_api_concurrency_limit
        self.lockout_immune_addresses = lockout_immune_addresses
        self.protocol_versions = protocol_versions
        self.redirect_host = redirect_host
        self.session_timeout = session_timeout
        VapiStruct.__init__(self)


ApiServiceConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.api_service_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'basic_authentication_enabled': type.OptionalType(type.BooleanType()),
        'cipher_suites': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CipherSuite'))),
        'client_api_concurrency_limit': type.OptionalType(type.IntegerType()),
        'client_api_rate_limit': type.OptionalType(type.IntegerType()),
        'connection_timeout': type.OptionalType(type.IntegerType()),
        'cookie_based_authentication_enabled': type.OptionalType(type.BooleanType()),
        'global_api_concurrency_limit': type.OptionalType(type.IntegerType()),
        'lockout_immune_addresses': type.OptionalType(type.ListType(type.StringType())),
        'protocol_versions': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ProtocolVersion'))),
        'redirect_host': type.OptionalType(type.StringType()),
        'session_timeout': type.OptionalType(type.IntegerType()),
    },
    ApiServiceConfig,
    False,
    None))



class ApplianceLatencyData(VapiStruct):
    """
    Display the latency data by given appliance node

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'id': 'id',
                            'latency_data': 'latency_data',
                            'name': 'name',
                            'timestamp': 'timestamp',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 id=None,
                 latency_data=None,
                 name=None,
                 timestamp=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  id: :class:`str` or ``None``
        :param id: Display the Appliance id.
        :type  latency_data: :class:`list` of :class:`ApplianceLatencyDataItem` or ``None``
        :param latency_data: Latency Data list.
        :type  name: :class:`str` or ``None``
        :param name: Display the appliance name.
        :type  timestamp: :class:`long` or ``None``
        :param timestamp: Timestamp of last modification. format: int64
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.id = id
        self.latency_data = latency_data
        self.name = name
        self.timestamp = timestamp
        VapiStruct.__init__(self)


ApplianceLatencyData._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.appliance_latency_data', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'id': type.OptionalType(type.StringType()),
        'latency_data': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ApplianceLatencyDataItem'))),
        'name': type.OptionalType(type.StringType()),
        'timestamp': type.OptionalType(type.IntegerType()),
    },
    ApplianceLatencyData,
    False,
    None))



class ApplianceLatencyDataItem(VapiStruct):
    """
    Describes appliance latency data in detail.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_UP = "UP"
    """


    """
    STATUS_DOWN = "DOWN"
    """


    """



    _canonical_to_pep_names = {
                            'destination_node_id': 'destination_node_id',
                            'destination_node_ip': 'destination_node_ip',
                            'destination_node_name': 'destination_node_name',
                            'packet_loss_percent': 'packet_loss_percent',
                            'packet_received': 'packet_received',
                            'packet_transmitted': 'packet_transmitted',
                            'rtt_avg': 'rtt_avg',
                            'rtt_max': 'rtt_max',
                            'rtt_mdev': 'rtt_mdev',
                            'rtt_min': 'rtt_min',
                            'source_node_ip': 'source_node_ip',
                            'status': 'status',
                            'total_time': 'total_time',
                            }

    def __init__(self,
                 destination_node_id=None,
                 destination_node_ip=None,
                 destination_node_name=None,
                 packet_loss_percent=None,
                 packet_received=None,
                 packet_transmitted=None,
                 rtt_avg=None,
                 rtt_max=None,
                 rtt_mdev=None,
                 rtt_min=None,
                 source_node_ip=None,
                 status=None,
                 total_time=None,
                ):
        """
        :type  destination_node_id: :class:`str` or ``None``
        :param destination_node_id: Display the appliance node id.
        :type  destination_node_ip: :class:`str` or ``None``
        :param destination_node_ip: Display the appliance node ip.
        :type  destination_node_name: :class:`str` or ``None``
        :param destination_node_name: Display the appliance node name.
        :type  packet_loss_percent: :class:`str` or ``None``
        :param packet_loss_percent: Display the percentage of lost packet.
        :type  packet_received: :class:`long` or ``None``
        :param packet_received: Display the received packets. format: int64
        :type  packet_transmitted: :class:`long` or ``None``
        :param packet_transmitted: Display the transmitted packets in Ping format: int64
        :type  rtt_avg: :class:`float` or ``None``
        :param rtt_avg: Display the average Round Trip Time in milliseconds.
        :type  rtt_max: :class:`float` or ``None``
        :param rtt_max: Display the max Round Trip Time in milliseconds.
        :type  rtt_mdev: :class:`float` or ``None``
        :param rtt_mdev: Display the mean Round Trip Time in milliseconds.
        :type  rtt_min: :class:`float` or ``None``
        :param rtt_min: Display the min Round Trip Time in milliseconds.
        :type  source_node_ip: :class:`str` or ``None``
        :param source_node_ip: Display the appliance node ip.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`ApplianceLatencyDataItem.STATUS_UP`
            * :attr:`ApplianceLatencyDataItem.STATUS_DOWN`
            
            Display the connection status between source node and destination
            node.
        :type  total_time: :class:`long` or ``None``
        :param total_time: Display the total time of sending and receiving packets in
            milliseconds. format: int64
        """
        self.destination_node_id = destination_node_id
        self.destination_node_ip = destination_node_ip
        self.destination_node_name = destination_node_name
        self.packet_loss_percent = packet_loss_percent
        self.packet_received = packet_received
        self.packet_transmitted = packet_transmitted
        self.rtt_avg = rtt_avg
        self.rtt_max = rtt_max
        self.rtt_mdev = rtt_mdev
        self.rtt_min = rtt_min
        self.source_node_ip = source_node_ip
        self.status = status
        self.total_time = total_time
        VapiStruct.__init__(self)


ApplianceLatencyDataItem._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.appliance_latency_data_item', {
        'destination_node_id': type.OptionalType(type.StringType()),
        'destination_node_ip': type.OptionalType(type.StringType()),
        'destination_node_name': type.OptionalType(type.StringType()),
        'packet_loss_percent': type.OptionalType(type.StringType()),
        'packet_received': type.OptionalType(type.IntegerType()),
        'packet_transmitted': type.OptionalType(type.IntegerType()),
        'rtt_avg': type.OptionalType(type.DoubleType()),
        'rtt_max': type.OptionalType(type.DoubleType()),
        'rtt_mdev': type.OptionalType(type.DoubleType()),
        'rtt_min': type.OptionalType(type.DoubleType()),
        'source_node_ip': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
        'total_time': type.OptionalType(type.IntegerType()),
    },
    ApplianceLatencyDataItem,
    False,
    None))



class ApplianceLatencyListResult(VapiStruct):
    """
    List of process data

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Total appliance latency count format: int64
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ApplianceLatencyData` or ``None``
        :param results: Display the appliance latency data list.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ApplianceLatencyListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.appliance_latency_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ApplianceLatencyData'))),
    },
    ApplianceLatencyListResult,
    False,
    None))



class ApplianceProcessData(VapiStruct):
    """
    List of process data in given appliance node

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'id': 'id',
                            'name': 'name',
                            'timestamp': 'timestamp',
                            'top_process_by_cpu_count': 'top_process_by_cpu_count',
                            'top_process_by_cpu_list': 'top_process_by_cpu_list',
                            'top_process_by_mem_count': 'top_process_by_mem_count',
                            'top_process_by_mem_list': 'top_process_by_mem_list',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 id=None,
                 name=None,
                 timestamp=None,
                 top_process_by_cpu_count=None,
                 top_process_by_cpu_list=None,
                 top_process_by_mem_count=None,
                 top_process_by_mem_list=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  id: :class:`str` or ``None``
        :param id: Display the Appliance id.
        :type  name: :class:`str` or ``None``
        :param name: Display the appliance name.
        :type  timestamp: :class:`long` or ``None``
        :param timestamp: Timestamp of last modification. format: int64
        :type  top_process_by_cpu_count: :class:`long` or ``None``
        :param top_process_by_cpu_count: Display the total count of process. format: int64
        :type  top_process_by_cpu_list: :class:`list` of :class:`ProcessInformation` or ``None``
        :param top_process_by_cpu_list: Display the top process list by CPU.
        :type  top_process_by_mem_count: :class:`long` or ``None``
        :param top_process_by_mem_count: Display the total count of process. format: int64
        :type  top_process_by_mem_list: :class:`list` of :class:`ProcessInformation` or ``None``
        :param top_process_by_mem_list: Display the top process list by memory.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.id = id
        self.name = name
        self.timestamp = timestamp
        self.top_process_by_cpu_count = top_process_by_cpu_count
        self.top_process_by_cpu_list = top_process_by_cpu_list
        self.top_process_by_mem_count = top_process_by_mem_count
        self.top_process_by_mem_list = top_process_by_mem_list
        VapiStruct.__init__(self)


ApplianceProcessData._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.appliance_process_data', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'id': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
        'timestamp': type.OptionalType(type.IntegerType()),
        'top_process_by_cpu_count': type.OptionalType(type.IntegerType()),
        'top_process_by_cpu_list': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ProcessInformation'))),
        'top_process_by_mem_count': type.OptionalType(type.IntegerType()),
        'top_process_by_mem_list': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ProcessInformation'))),
    },
    ApplianceProcessData,
    False,
    None))



class ApplianceProcessListResult(VapiStruct):
    """
    List of process data

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ApplianceProcessData` or ``None``
        :param results: Display the appliance process list.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ApplianceProcessListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.appliance_process_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ApplianceProcessData'))),
    },
    ApplianceProcessListResult,
    False,
    None))



class ApplicationConnectivityStrategy(VapiStruct):
    """
    Allows more granular policies for application workloads

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    APPLICATION_CONNECTIVITY_STRATEGY_ALLOW_INTRA = "ALLOW_INTRA"
    """


    """
    APPLICATION_CONNECTIVITY_STRATEGY_ALLOW_EGRESS = "ALLOW_EGRESS"
    """


    """
    APPLICATION_CONNECTIVITY_STRATEGY_ALLOW_INGRESS = "ALLOW_INGRESS"
    """


    """
    APPLICATION_CONNECTIVITY_STRATEGY_DROP_INGRESS = "DROP_INGRESS"
    """


    """
    APPLICATION_CONNECTIVITY_STRATEGY_DROP_EGRESS = "DROP_EGRESS"
    """


    """



    _canonical_to_pep_names = {
                            'application_connectivity_strategy': 'application_connectivity_strategy',
                            'default_application_rule_id': 'default_application_rule_id',
                            'logging_enabled': 'logging_enabled',
                            }

    def __init__(self,
                 application_connectivity_strategy=None,
                 default_application_rule_id=None,
                 logging_enabled=None,
                ):
        """
        :type  application_connectivity_strategy: :class:`str` or ``None``
        :param application_connectivity_strategy: Possible values are: 
            
            *
              :attr:`ApplicationConnectivityStrategy.APPLICATION_CONNECTIVITY_STRATEGY_ALLOW_INTRA`
            *
              :attr:`ApplicationConnectivityStrategy.APPLICATION_CONNECTIVITY_STRATEGY_ALLOW_EGRESS`
            *
              :attr:`ApplicationConnectivityStrategy.APPLICATION_CONNECTIVITY_STRATEGY_ALLOW_INGRESS`
            *
              :attr:`ApplicationConnectivityStrategy.APPLICATION_CONNECTIVITY_STRATEGY_DROP_INGRESS`
            *
              :attr:`ApplicationConnectivityStrategy.APPLICATION_CONNECTIVITY_STRATEGY_DROP_EGRESS`
            
            App connectivity strategies
        :type  default_application_rule_id: :class:`long` or ``None``
        :param default_application_rule_id: Based on the value of the app connectivity strategy, a default rule
            is created for the security policy. The rule id is internally
            assigned by the system for this default rule. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  logging_enabled: :class:`bool` or ``None``
        :param logging_enabled: Flag to enable packet logging. Default is deactivated.
        """
        self.application_connectivity_strategy = application_connectivity_strategy
        self.default_application_rule_id = default_application_rule_id
        self.logging_enabled = logging_enabled
        VapiStruct.__init__(self)


ApplicationConnectivityStrategy._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.application_connectivity_strategy', {
        'application_connectivity_strategy': type.OptionalType(type.StringType()),
        'default_application_rule_id': type.OptionalType(type.IntegerType()),
        'logging_enabled': type.OptionalType(type.BooleanType()),
    },
    ApplicationConnectivityStrategy,
    False,
    None))



class ArpHeader(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    OP_CODE_REQUEST = "ARP_REQUEST"
    """


    """
    OP_CODE_REPLY = "ARP_REPLY"
    """


    """



    _canonical_to_pep_names = {
                            'dst_ip': 'dst_ip',
                            'op_code': 'op_code',
                            'src_ip': 'src_ip',
                            }

    def __init__(self,
                 dst_ip=None,
                 op_code=None,
                 src_ip=None,
                ):
        """
        :type  dst_ip: :class:`str` or ``None``
        :param dst_ip: The destination IP address format: ipv4
        :type  op_code: :class:`str` or ``None``
        :param op_code: Possible values are: 
            
            * :attr:`ArpHeader.OP_CODE_REQUEST`
            * :attr:`ArpHeader.OP_CODE_REPLY`
            
            This field specifies the nature of the Arp message being sent.
        :type  src_ip: :class:`str` or ``None``
        :param src_ip: This field specifies the IP address of the sender. If omitted, the
            src_ip is set to 0.0.0.0. format: ipv4
        """
        self.dst_ip = dst_ip
        self.op_code = op_code
        self.src_ip = src_ip
        VapiStruct.__init__(self)


ArpHeader._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.arp_header', {
        'dst_ip': type.OptionalType(type.StringType()),
        'op_code': type.OptionalType(type.StringType()),
        'src_ip': type.OptionalType(type.StringType()),
    },
    ArpHeader,
    False,
    None))



class ArpSnoopingConfig(VapiStruct):
    """
    Contains ARP snooping related configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'arp_binding_limit': 'arp_binding_limit',
                            'arp_snooping_enabled': 'arp_snooping_enabled',
                            }

    def __init__(self,
                 arp_binding_limit=None,
                 arp_snooping_enabled=None,
                ):
        """
        :type  arp_binding_limit: :class:`long` or ``None``
        :param arp_binding_limit: Number of arp snooped IP addresses Indicates the number of arp
            snooped IP addresses to be remembered per LogicalPort. Decreasing
            this value, will retain the latest bindings from the existing list
            of address bindings. Increasing this value will retain existing
            bindings and also learn any new address bindings discovered on the
            port until the new limit is reached. format: int32
        :type  arp_snooping_enabled: :class:`bool` or ``None``
        :param arp_snooping_enabled: Indicates whether ARP snooping is enabled
        """
        self.arp_binding_limit = arp_binding_limit
        self.arp_snooping_enabled = arp_snooping_enabled
        VapiStruct.__init__(self)


ArpSnoopingConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.arp_snooping_config', {
        'arp_binding_limit': type.OptionalType(type.IntegerType()),
        'arp_snooping_enabled': type.OptionalType(type.BooleanType()),
    },
    ArpSnoopingConfig,
    False,
    None))



class AssignedByAutoConf(VapiStruct):
    """
    This type can be specified in ipv6 assignment spec of host switch if
    auto-conf based IPv6 assignment is desired for host switch virtual tunnel
    endpoints.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AssignedByAutoConf"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 resource_type='AssignedByAutoConf',
                ):
        """
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_STATICIPV6POOLSPEC`
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_STATICIPV6LISTSPEC`
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_ASSIGNEDBYDHCPV6`
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_STATICIPV6MACLISTSPEC`
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_ASSIGNEDBYAUTOCONF`
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_NOIPV6`
        """
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

AssignedByAutoConf._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.assigned_by_auto_conf', {
        'resource_type': type.StringType(),
    },
    AssignedByAutoConf,
    False,
    None))



class AssignedByDhcp(VapiStruct):
    """
    This type can be specified in ip assignment spec of host switch if DHCP
    based IP assignment is desired for host switch virtual tunnel endpoints.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AssignedByDhcp"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 resource_type='AssignedByDhcp',
                ):
        """
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`IpAssignmentSpec.RESOURCE_TYPE_STATICIPPOOLSPEC`
            * :attr:`IpAssignmentSpec.RESOURCE_TYPE_STATICIPLISTSPEC`
            * :attr:`IpAssignmentSpec.RESOURCE_TYPE_ASSIGNEDBYDHCP`
            * :attr:`IpAssignmentSpec.RESOURCE_TYPE_STATICIPMACLISTSPEC`
            * :attr:`IpAssignmentSpec.RESOURCE_TYPE_NOIPV4`
        """
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

AssignedByDhcp._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.assigned_by_dhcp', {
        'resource_type': type.StringType(),
    },
    AssignedByDhcp,
    False,
    None))



class AssignedByDhcpv6(VapiStruct):
    """
    This type can be specified in ip assignment spec of host switch if DHCP
    based IP assignment is desired for host switch virtual tunnel endpoints.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AssignedByDhcpv6"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 resource_type='AssignedByDhcpv6',
                ):
        """
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_STATICIPV6POOLSPEC`
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_STATICIPV6LISTSPEC`
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_ASSIGNEDBYDHCPV6`
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_STATICIPV6MACLISTSPEC`
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_ASSIGNEDBYAUTOCONF`
            * :attr:`Ipv6AssignmentSpec.RESOURCE_TYPE_NOIPV6`
        """
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

AssignedByDhcpv6._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.assigned_by_dhcpv6', {
        'resource_type': type.StringType(),
    },
    AssignedByDhcpv6,
    False,
    None))



class AsyncCompatibilityCheckResult(VapiStruct):
    """
    This result shows the location of the asynchronous compatibility check that
    will be created and updated later on after starting the NSX+ compatibility
    check.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'compatibility_validation_results': 'compatibility_validation_results',
                            }

    def __init__(self,
                 compatibility_validation_results=None,
                ):
        """
        :type  compatibility_validation_results: :class:`str` or ``None``
        :param compatibility_validation_results: Result for NSX+ compatibility check
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.compatibility_validation_results = compatibility_validation_results
        VapiStruct.__init__(self)


AsyncCompatibilityCheckResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.async_compatibility_check_result', {
        'compatibility_validation_results': type.OptionalType(type.StringType()),
    },
    AsyncCompatibilityCheckResult,
    False,
    None))



class AttachedInterfaceEntry(VapiStruct):
    """
    The Attached interface is only effective for the segment port on Bare metal
    server.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'app_intf_name': 'app_intf_name',
                            'default_gateway': 'default_gateway',
                            'migrate_intf': 'migrate_intf',
                            'routing_table': 'routing_table',
                            }

    def __init__(self,
                 app_intf_name=None,
                 default_gateway=None,
                 migrate_intf=None,
                 routing_table=None,
                ):
        """
        :type  app_intf_name: :class:`str` or ``None``
        :param app_intf_name: The name of application interface
        :type  default_gateway: :class:`str` or ``None``
        :param default_gateway: Gateway IP format: ip
        :type  migrate_intf: :class:`str` or ``None``
        :param migrate_intf: IP configuration on migrate_intf will migrate to app_intf_name. It
            is used for Management and Application sharing the same IP.
        :type  routing_table: :class:`list` of :class:`str` or ``None``
        :param routing_table: Routing rules
        """
        self.app_intf_name = app_intf_name
        self.default_gateway = default_gateway
        self.migrate_intf = migrate_intf
        self.routing_table = routing_table
        VapiStruct.__init__(self)


AttachedInterfaceEntry._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.attached_interface_entry', {
        'app_intf_name': type.OptionalType(type.StringType()),
        'default_gateway': type.OptionalType(type.StringType()),
        'migrate_intf': type.OptionalType(type.StringType()),
        'routing_table': type.OptionalType(type.ListType(type.StringType())),
    },
    AttachedInterfaceEntry,
    False,
    None))



class Attribute(VapiStruct):
    """
    Attribute specific to a partner. There attributes are passed on to the
    partner appliance and is opaque to the NSX Manager. The Attributes used by
    the partner applicance.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ATTRIBUTE_TYPE_IP_ADDRESS = "IP_ADDRESS"
    """


    """
    ATTRIBUTE_TYPE_PORT = "PORT"
    """


    """
    ATTRIBUTE_TYPE_PASSWORD = "PASSWORD"
    """


    """
    ATTRIBUTE_TYPE_STRING = "STRING"
    """


    """
    ATTRIBUTE_TYPE_LONG = "LONG"
    """


    """
    ATTRIBUTE_TYPE_BOOLEAN = "BOOLEAN"
    """


    """



    _canonical_to_pep_names = {
                            'attribute_type': 'attribute_type',
                            'display_name': 'display_name',
                            'key': 'key',
                            'read_only': 'read_only',
                            'value': 'value',
                            }

    def __init__(self,
                 attribute_type=None,
                 display_name=None,
                 key=None,
                 read_only=None,
                 value=None,
                ):
        """
        :type  attribute_type: :class:`str` or ``None``
        :param attribute_type: Possible values are: 
            
            * :attr:`Attribute.ATTRIBUTE_TYPE_IP_ADDRESS`
            * :attr:`Attribute.ATTRIBUTE_TYPE_PORT`
            * :attr:`Attribute.ATTRIBUTE_TYPE_PASSWORD`
            * :attr:`Attribute.ATTRIBUTE_TYPE_STRING`
            * :attr:`Attribute.ATTRIBUTE_TYPE_LONG`
            * :attr:`Attribute.ATTRIBUTE_TYPE_BOOLEAN`
            
            Attribute Type can be of any of the allowed enum type.
        :type  display_name: :class:`str` or ``None``
        :param display_name: Attribute display name string value.
        :type  key: :class:`str` or ``None``
        :param key: Attribute key string value.
        :type  read_only: :class:`bool` or ``None``
        :param read_only: Read only Attribute cannot be overdidden by service
            instance/deployment.
        :type  value: :class:`str` or ``None``
        :param value: Attribute value string value.
        """
        self.attribute_type = attribute_type
        self.display_name = display_name
        self.key = key
        self.read_only = read_only
        self.value = value
        VapiStruct.__init__(self)


Attribute._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.attribute', {
        'attribute_type': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'key': type.OptionalType(type.StringType()),
        'read_only': type.OptionalType(type.BooleanType()),
        'value': type.OptionalType(type.StringType()),
    },
    Attribute,
    False,
    None))



class AttributeVal(VapiStruct):
    """
    Contains type specific properties of generic realized entity

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    DATA_TYPE_STRING = "STRING"
    """


    """
    DATA_TYPE_DATE = "DATE"
    """


    """
    DATA_TYPE_INTEGER = "INTEGER"
    """


    """
    DATA_TYPE_BOOLEAN = "BOOLEAN"
    """


    """



    _canonical_to_pep_names = {
                            'data_type': 'data_type',
                            'key': 'key',
                            'multivalue': 'multivalue',
                            'values': 'values',
                            }

    def __init__(self,
                 data_type=None,
                 key=None,
                 multivalue=None,
                 values=None,
                ):
        """
        :type  data_type: :class:`str` or ``None``
        :param data_type: Possible values are: 
            
            * :attr:`AttributeVal.DATA_TYPE_STRING`
            * :attr:`AttributeVal.DATA_TYPE_DATE`
            * :attr:`AttributeVal.DATA_TYPE_INTEGER`
            * :attr:`AttributeVal.DATA_TYPE_BOOLEAN`
            
            Datatype of the property
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  key: :class:`str` or ``None``
        :param key: Attribute key
        :type  multivalue: :class:`bool` or ``None``
        :param multivalue: If attribute has a single value or collection of values
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  values: :class:`list` of :class:`str` or ``None``
        :param values: List of attribute values
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.data_type = data_type
        self.key = key
        self.multivalue = multivalue
        self.values = values
        VapiStruct.__init__(self)


AttributeVal._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.attribute_val', {
        'data_type': type.OptionalType(type.StringType()),
        'key': type.OptionalType(type.StringType()),
        'multivalue': type.OptionalType(type.BooleanType()),
        'values': type.OptionalType(type.ListType(type.StringType())),
    },
    AttributeVal,
    False,
    None))



class AutoRds(VapiStruct):
    """
    This object holds auto assigned route distinguishers for Layer 2 and Layer
    3 configurations.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'l2_auto_rds': 'l2_auto_rds',
                            'l3_auto_rd': 'l3_auto_rd',
                            }

    def __init__(self,
                 l2_auto_rds=None,
                 l3_auto_rd=None,
                ):
        """
        :type  l2_auto_rds: :class:`list` of :class:`L2AutoRD` or ``None``
        :param l2_auto_rds: List of layer 2 Auto assigned Route Distinguisher
        :type  l3_auto_rd: :class:`str` or ``None``
        :param l3_auto_rd: This field is auto assigned by the system. The auto RD seed is
            populated when user does not assign a route_distinguisher field in
            the gateway.
        """
        self.l2_auto_rds = l2_auto_rds
        self.l3_auto_rd = l3_auto_rd
        VapiStruct.__init__(self)


AutoRds._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.auto_rds', {
        'l2_auto_rds': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'L2AutoRD'))),
        'l3_auto_rd': type.OptionalType(type.StringType()),
    },
    AutoRds,
    False,
    None))



class AviConnectionInfo(VapiStruct):
    """
    Credential info to connect to a AVI type of enforcement point.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "AviConnectionInfo"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    STATUS_ACTIVATE = "ACTIVATE"
    """


    """
    STATUS_DEACTIVATE_PROVIDER = "DEACTIVATE_PROVIDER"
    """


    """
    STATUS_DEACTIVATE_API = "DEACTIVATE_API"
    """


    """



    _canonical_to_pep_names = {
                            'certificate': 'certificate',
                            'cloud': 'cloud',
                            'expires_at': 'expires_at',
                            'is_default_cert': 'is_default_cert',
                            'managed_by': 'managed_by',
                            'password': 'password',
                            'status': 'status',
                            'tenant': 'tenant',
                            'thumbprint': 'thumbprint',
                            'username': 'username',
                            'version': 'version',
                            'enforcement_point_address': 'enforcement_point_address',
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 certificate=None,
                 cloud=None,
                 expires_at=None,
                 is_default_cert=None,
                 managed_by=None,
                 password=None,
                 status=None,
                 tenant=None,
                 thumbprint=None,
                 username=None,
                 version=None,
                 enforcement_point_address=None,
                 resource_type='AviConnectionInfo',
                ):
        """
        :type  certificate: :class:`str` or ``None``
        :param certificate: Certificate used when on-borading workflow created by LCM/VCF.
        :type  cloud: :class:`str` or ``None``
        :param cloud: Clouds are containers for the environment that Avi Vantage is
            installed or operating within. During initial setup of Vantage, a
            default cloud, named Default-Cloud, is created. This is where the
            first Controller is deployed, into Default-Cloud. Additional clouds
            may be added, containing SEs and virtual services. This is a
            deprecated property. Cloud has been renamed to cloud_name and it
            will added from specific ALB entity.

            .. deprecated:: unknown
        :type  expires_at: :class:`str` or ``None``
        :param expires_at: Expiry time of the token will be set by LCM at the time of
            Enforcement Point Creation.
        :type  is_default_cert: :class:`bool` or ``None``
        :param is_default_cert: Advanced Load Balancer controller using default portal certificate.
        :type  managed_by: :class:`str` or ``None``
        :param managed_by: Managed by used when on-borading workflow created by LCM/VCF.
        :type  password: :class:`str` or ``None``
        :param password: Password or Token for Avi Controller.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`AviConnectionInfo.STATUS_ACTIVATE`
            * :attr:`AviConnectionInfo.STATUS_DEACTIVATE_PROVIDER`
            * :attr:`AviConnectionInfo.STATUS_DEACTIVATE_API`
            
            This is connection property which checks whether ALB is connected
            to the controller. Enum options - ACTIVATE, DEACTIVATE_PROVIDER,
            DEACTIVATE_API. Default value is DEACTIVATE_API.
        :type  tenant: :class:`str` or ``None``
        :param tenant: A tenant is an isolated instance of Avi Controller. Each Avi user
            account is associated with one or more tenants. The tenant
            associated with a user account defines the resources that user can
            access within Avi Vantage. When a user logs in, Avi restricts their
            access to only those resources that are in the same tenant
        :type  thumbprint: :class:`str` or ``None``
        :param thumbprint: Thumbprint of EnforcementPoint in the form of a SHA-256 hash
            represented in lower case HEX.
        :type  username: :class:`str` or ``None``
        :param username: Username.
        :type  version: :class:`str` or ``None``
        :param version: Avi supports API versioning for backward compatibility with
            automation scripts written for an object model older than the
            current one. Such scripts need not be updated to keep up with
            object model changes This is a deprecated property. The version is
            now auto populated from property file and its value can be read
            using APIs

            .. deprecated:: unknown
        :type  enforcement_point_address: :class:`str` or ``None``
        :param enforcement_point_address: Value of this property could be Hostname or IP. For instance: - On
            an NSX-T MP running on default port, the value could be
            \"10.192.1.1\" - On an NSX-T MP running on custom port, the value
            could be \"192.168.1.1:32789\" - On an NSX-T MP in VMC deployments,
            the value could be \"192.168.1.1:5480/nsxapi\"
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            *
              :attr:`EnforcementPointConnectionInfo.RESOURCE_TYPE_NSXTCONNECTIONINFO`
            *
              :attr:`EnforcementPointConnectionInfo.RESOURCE_TYPE_NSXVCONNECTIONINFO`
            *
              :attr:`EnforcementPointConnectionInfo.RESOURCE_TYPE_CVXCONNECTIONINFO`
            *
              :attr:`EnforcementPointConnectionInfo.RESOURCE_TYPE_AVICONNECTIONINFO`
            
            Resource Type of Enforcement Point Connection Info.
        """
        self.certificate = certificate
        self.cloud = cloud
        self.expires_at = expires_at
        self.is_default_cert = is_default_cert
        self.managed_by = managed_by
        self.password = password
        self.status = status
        self.tenant = tenant
        self.thumbprint = thumbprint
        self.username = username
        self.version = version
        self.enforcement_point_address = enforcement_point_address
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

AviConnectionInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.avi_connection_info', {
        'certificate': type.OptionalType(type.StringType()),
        'cloud': type.OptionalType(type.StringType()),
        'expires_at': type.OptionalType(type.StringType()),
        'is_default_cert': type.OptionalType(type.BooleanType()),
        'managed_by': type.OptionalType(type.StringType()),
        'password': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
        'tenant': type.OptionalType(type.StringType()),
        'thumbprint': type.OptionalType(type.StringType()),
        'username': type.OptionalType(type.StringType()),
        'version': type.OptionalType(type.StringType()),
        'enforcement_point_address': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
    },
    AviConnectionInfo,
    False,
    None))



class Axes(VapiStruct):
    """
    Represents X and Y axes of a graph. For a multi-graph, the same axes are
    shared by all the graphs.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'x_label': 'x_label',
                            'x_labels': 'x_labels',
                            'y_axis_unit_labels': 'y_axis_unit_labels',
                            'y_axis_units': 'y_axis_units',
                            'y_label': 'y_label',
                            'y_labels': 'y_labels',
                            }

    def __init__(self,
                 x_label=None,
                 x_labels=None,
                 y_axis_unit_labels=None,
                 y_axis_units=None,
                 y_label=None,
                 y_labels=None,
                ):
        """
        :type  x_label: :class:`Label` or ``None``
        :param x_label: 
        :type  x_labels: :class:`list` of :class:`Label` or ``None``
        :param x_labels: A list of X-Axis Labels with condition support. If needed, this
            property can be used to provide a list of x-axis label with
            condition support. For a label with single condition,'x-label'
            property can be used.
        :type  y_axis_unit_labels: :class:`list` of :class:`Label` or ``None``
        :param y_axis_unit_labels: A list of Y-Axis unit Labels with condition support. If needed,
            this property can be used to provide a list of y-axis unit label
            with condition support. This unit label can be used to display the
            point value along with units like percentage, milliseconds etc.
        :type  y_axis_units: :class:`list` of :class:`AxisUnit` or ``None``
        :param y_axis_units: A list of Y-Axis unit with condition support. If needed, this
            property can be used to provide a list of y-axis unit with
            condition support. This unit could be like percentage, seconds,
            milliseconds etc.
        :type  y_label: :class:`Label` or ``None``
        :param y_label: 
        :type  y_labels: :class:`list` of :class:`Label` or ``None``
        :param y_labels: A list of Y-Axis Labels with condition support. If needed, this
            property can be used to provide a list of y-axis label with
            condition support. For a label with single condition,'y-label'
            property can be used.
        """
        self.x_label = x_label
        self.x_labels = x_labels
        self.y_axis_unit_labels = y_axis_unit_labels
        self.y_axis_units = y_axis_units
        self.y_label = y_label
        self.y_labels = y_labels
        VapiStruct.__init__(self)


Axes._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.axes', {
        'x_label': type.OptionalType(type.ReferenceType(__name__, 'Label')),
        'x_labels': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Label'))),
        'y_axis_unit_labels': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Label'))),
        'y_axis_units': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'AxisUnit'))),
        'y_label': type.OptionalType(type.ReferenceType(__name__, 'Label')),
        'y_labels': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Label'))),
    },
    Axes,
    False,
    None))



class AxisUnit(VapiStruct):
    """
    Represents X and Y axis unit of a graph.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    UNIT_COUNT = "COUNT"
    """


    """
    UNIT_PERCENT = "PERCENT"
    """


    """
    UNIT_BYTES = "BYTES"
    """


    """
    UNIT_MILLISECONDS = "MILLISECONDS"
    """


    """
    UNIT_SECONDS = "SECONDS"
    """


    """
    UNIT_MINUTE = "MINUTE"
    """


    """
    UNIT_HOUR = "HOUR"
    """


    """
    UNIT_DAY = "DAY"
    """


    """
    UNIT_KILO_BYTES = "KILO_BYTES"
    """


    """
    UNIT_MEGA_BYTES = "MEGA_BYTES"
    """


    """
    UNIT_GIGA_BYTES = "GIGA_BYTES"
    """


    """



    _canonical_to_pep_names = {
                            'condition': 'condition',
                            'unit': 'unit',
                            }

    def __init__(self,
                 condition=None,
                 unit=None,
                ):
        """
        :type  condition: :class:`str` or ``None``
        :param condition: If the condition is met then the above unit will be displayed. to
            UI. If no condition is provided, then the unit will be displayed
            unconditionally.
        :type  unit: :class:`str` or ``None``
        :param unit: Possible values are: 
            
            * :attr:`AxisUnit.UNIT_COUNT`
            * :attr:`AxisUnit.UNIT_PERCENT`
            * :attr:`AxisUnit.UNIT_BYTES`
            * :attr:`AxisUnit.UNIT_MILLISECONDS`
            * :attr:`AxisUnit.UNIT_SECONDS`
            * :attr:`AxisUnit.UNIT_MINUTE`
            * :attr:`AxisUnit.UNIT_HOUR`
            * :attr:`AxisUnit.UNIT_DAY`
            * :attr:`AxisUnit.UNIT_KILO_BYTES`
            * :attr:`AxisUnit.UNIT_MEGA_BYTES`
            * :attr:`AxisUnit.UNIT_GIGA_BYTES`
            
            An Axis unit.
        """
        self.condition = condition
        self.unit = unit
        VapiStruct.__init__(self)


AxisUnit._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.axis_unit', {
        'condition': type.OptionalType(type.StringType()),
        'unit': type.OptionalType(type.StringType()),
    },
    AxisUnit,
    False,
    None))



class BFDDiagnosticCount(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'administratively_down_count': 'administratively_down_count',
                            'concatenated_path_down_count': 'concatenated_path_down_count',
                            'control_detection_time_expired_count': 'control_detection_time_expired_count',
                            'echo_function_failed_count': 'echo_function_failed_count',
                            'forwarding_plane_reset_count': 'forwarding_plane_reset_count',
                            'neighbor_signaled_session_down_count': 'neighbor_signaled_session_down_count',
                            'no_diagnostic_count': 'no_diagnostic_count',
                            'path_down_count': 'path_down_count',
                            'reverse_concatenated_path_down_count': 'reverse_concatenated_path_down_count',
                            }

    def __init__(self,
                 administratively_down_count=None,
                 concatenated_path_down_count=None,
                 control_detection_time_expired_count=None,
                 echo_function_failed_count=None,
                 forwarding_plane_reset_count=None,
                 neighbor_signaled_session_down_count=None,
                 no_diagnostic_count=None,
                 path_down_count=None,
                 reverse_concatenated_path_down_count=None,
                ):
        """
        :type  administratively_down_count: :class:`long` or ``None``
        :param administratively_down_count: Number of tunnels with administratively down diagnostic message
            format: int64
        :type  concatenated_path_down_count: :class:`long` or ``None``
        :param concatenated_path_down_count: Number of tunnels with concatenated path down diagnostic message
            format: int64
        :type  control_detection_time_expired_count: :class:`long` or ``None``
        :param control_detection_time_expired_count: Number of tunnels with control detection time expired diagnostic
            message format: int64
        :type  echo_function_failed_count: :class:`long` or ``None``
        :param echo_function_failed_count: Number of tunnels with echo function failed diagnostic message
            format: int64
        :type  forwarding_plane_reset_count: :class:`long` or ``None``
        :param forwarding_plane_reset_count: Number of tunnels with forwarding plane reset diagnostic message
            format: int64
        :type  neighbor_signaled_session_down_count: :class:`long` or ``None``
        :param neighbor_signaled_session_down_count: Number of tunnels neighbor signaled session down format: int64
        :type  no_diagnostic_count: :class:`long` or ``None``
        :param no_diagnostic_count: Number of tunnels with no diagnostic format: int64
        :type  path_down_count: :class:`long` or ``None``
        :param path_down_count: Number of tunnels with path down diagnostic message format: int64
        :type  reverse_concatenated_path_down_count: :class:`long` or ``None``
        :param reverse_concatenated_path_down_count: Number of tunnels with reverse concatenated path down diagnostic
            message format: int64
        """
        self.administratively_down_count = administratively_down_count
        self.concatenated_path_down_count = concatenated_path_down_count
        self.control_detection_time_expired_count = control_detection_time_expired_count
        self.echo_function_failed_count = echo_function_failed_count
        self.forwarding_plane_reset_count = forwarding_plane_reset_count
        self.neighbor_signaled_session_down_count = neighbor_signaled_session_down_count
        self.no_diagnostic_count = no_diagnostic_count
        self.path_down_count = path_down_count
        self.reverse_concatenated_path_down_count = reverse_concatenated_path_down_count
        VapiStruct.__init__(self)


BFDDiagnosticCount._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.BFD_diagnostic_count', {
        'administratively_down_count': type.OptionalType(type.IntegerType()),
        'concatenated_path_down_count': type.OptionalType(type.IntegerType()),
        'control_detection_time_expired_count': type.OptionalType(type.IntegerType()),
        'echo_function_failed_count': type.OptionalType(type.IntegerType()),
        'forwarding_plane_reset_count': type.OptionalType(type.IntegerType()),
        'neighbor_signaled_session_down_count': type.OptionalType(type.IntegerType()),
        'no_diagnostic_count': type.OptionalType(type.IntegerType()),
        'path_down_count': type.OptionalType(type.IntegerType()),
        'reverse_concatenated_path_down_count': type.OptionalType(type.IntegerType()),
    },
    BFDDiagnosticCount,
    False,
    None))



class BFDProperties(VapiStruct):
    """
    BFD information

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    BFD_ENCAP_GENEVE = "GENEVE"
    """


    """
    BFD_ENCAP_NONE = "NONE"
    """


    """
    BFD_ENCAP_UNKNOWN_ENCAP = "UNKNOWN_ENCAP"
    """


    """
    REMOTE_STATE_UNKNOWN_STATE = "UNKNOWN_STATE"
    """


    """
    REMOTE_STATE_ADMIN_DOWN = "ADMIN_DOWN"
    """


    """
    REMOTE_STATE_DOWN = "DOWN"
    """


    """
    REMOTE_STATE_INIT = "INIT"
    """


    """
    REMOTE_STATE_UP = "UP"
    """


    """
    STATE_UNKNOWN_STATE = "UNKNOWN_STATE"
    """


    """
    STATE_ADMIN_DOWN = "ADMIN_DOWN"
    """


    """
    STATE_DOWN = "DOWN"
    """


    """
    STATE_INIT = "INIT"
    """


    """
    STATE_UP = "UP"
    """


    """



    _canonical_to_pep_names = {
                            'active': 'active',
                            'bfd_encap': 'bfd_encap',
                            'diagnostic': 'diagnostic',
                            'forwarding': 'forwarding',
                            'remote_diagnostic': 'remote_diagnostic',
                            'remote_state': 'remote_state',
                            'state': 'state',
                            }

    def __init__(self,
                 active=None,
                 bfd_encap=None,
                 diagnostic=None,
                 forwarding=None,
                 remote_diagnostic=None,
                 remote_state=None,
                 state=None,
                ):
        """
        :type  active: :class:`bool` or ``None``
        :param active: True if tunnel is active in a gateway HA setup
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  bfd_encap: :class:`str` or ``None``
        :param bfd_encap: Possible values are: 
            
            * :attr:`BFDProperties.BFD_ENCAP_GENEVE`
            * :attr:`BFDProperties.BFD_ENCAP_NONE`
            * :attr:`BFDProperties.BFD_ENCAP_UNKNOWN_ENCAP`
            
            The encapsulation type of BFD. GENEVE - BFD with GENEVE
            encapsulation NONE - BFD with no encapsulation UNKNOWN_ENCAP - BFD
            with unknown encapsulation
        :type  diagnostic: :class:`str` or ``None``
        :param diagnostic: A short message indicating what the BFD session thinks is wrong in
            case of a problem
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  forwarding: :class:`bool` or ``None``
        :param forwarding: True if the BFD session believes this interface may be used to
            forward traffic
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_diagnostic: :class:`str` or ``None``
        :param remote_diagnostic: A short message indicating what the remote interface's BFD session
            thinks is wrong in case of a problem
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_state: :class:`str` or ``None``
        :param remote_state: Possible values are: 
            
            * :attr:`BFDProperties.REMOTE_STATE_UNKNOWN_STATE`
            * :attr:`BFDProperties.REMOTE_STATE_ADMIN_DOWN`
            * :attr:`BFDProperties.REMOTE_STATE_DOWN`
            * :attr:`BFDProperties.REMOTE_STATE_INIT`
            * :attr:`BFDProperties.REMOTE_STATE_UP`
            
            State of the remote interface's BFD session
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  state: :class:`str` or ``None``
        :param state: Possible values are: 
            
            * :attr:`BFDProperties.STATE_UNKNOWN_STATE`
            * :attr:`BFDProperties.STATE_ADMIN_DOWN`
            * :attr:`BFDProperties.STATE_DOWN`
            * :attr:`BFDProperties.STATE_INIT`
            * :attr:`BFDProperties.STATE_UP`
            
            State of the BFD session
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.active = active
        self.bfd_encap = bfd_encap
        self.diagnostic = diagnostic
        self.forwarding = forwarding
        self.remote_diagnostic = remote_diagnostic
        self.remote_state = remote_state
        self.state = state
        VapiStruct.__init__(self)


BFDProperties._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.BFD_properties', {
        'active': type.OptionalType(type.BooleanType()),
        'bfd_encap': type.OptionalType(type.StringType()),
        'diagnostic': type.OptionalType(type.StringType()),
        'forwarding': type.OptionalType(type.BooleanType()),
        'remote_diagnostic': type.OptionalType(type.StringType()),
        'remote_state': type.OptionalType(type.StringType()),
        'state': type.OptionalType(type.StringType()),
    },
    BFDProperties,
    False,
    None))



class BFDStatusCount(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'bfd_admin_down_count': 'bfd_admin_down_count',
                            'bfd_down_count': 'bfd_down_count',
                            'bfd_init_count': 'bfd_init_count',
                            'bfd_up_count': 'bfd_up_count',
                            }

    def __init__(self,
                 bfd_admin_down_count=None,
                 bfd_down_count=None,
                 bfd_init_count=None,
                 bfd_up_count=None,
                ):
        """
        :type  bfd_admin_down_count: :class:`long` or ``None``
        :param bfd_admin_down_count: Number of tunnels in BFD admin down state format: int32
        :type  bfd_down_count: :class:`long` or ``None``
        :param bfd_down_count: Number of tunnels in BFD down state format: int32
        :type  bfd_init_count: :class:`long` or ``None``
        :param bfd_init_count: Number of tunnels in BFD init state format: int32
        :type  bfd_up_count: :class:`long` or ``None``
        :param bfd_up_count: Number of tunnels in BFD up state format: int32
        """
        self.bfd_admin_down_count = bfd_admin_down_count
        self.bfd_down_count = bfd_down_count
        self.bfd_init_count = bfd_init_count
        self.bfd_up_count = bfd_up_count
        VapiStruct.__init__(self)


BFDStatusCount._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.BFD_status_count', {
        'bfd_admin_down_count': type.OptionalType(type.IntegerType()),
        'bfd_down_count': type.OptionalType(type.IntegerType()),
        'bfd_init_count': type.OptionalType(type.IntegerType()),
        'bfd_up_count': type.OptionalType(type.IntegerType()),
    },
    BFDStatusCount,
    False,
    None))



class BackupConfiguration(VapiStruct):
    """
    Configuration for taking manual/automated backup

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'after_inventory_update_interval': 'after_inventory_update_interval',
                            'backup_enabled': 'backup_enabled',
                            'backup_schedule': 'backup_schedule',
                            'inventory_summary_interval': 'inventory_summary_interval',
                            'passphrase': 'passphrase',
                            'remote_file_server': 'remote_file_server',
                            }

    def __init__(self,
                 after_inventory_update_interval=None,
                 backup_enabled=None,
                 backup_schedule=None,
                 inventory_summary_interval=None,
                 passphrase=None,
                 remote_file_server=None,
                ):
        """
        :type  after_inventory_update_interval: :class:`long` or ``None``
        :param after_inventory_update_interval: A number of seconds after a last backup, that needs to pass, before
            a topology change will trigger a generation of a new cluster/node
            backups. If parameter is not provided, then changes in a topology
            will not trigger a generation of cluster/node backups. format:
            int64
        :type  backup_enabled: :class:`bool` or ``None``
        :param backup_enabled: true if automated backup is enabled
        :type  backup_schedule: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param backup_schedule: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`BackupSchedule`. When methods return a value of this class
            as a return value, the attribute will contain all the attributes
            defined in :class:`BackupSchedule`.
        :type  inventory_summary_interval: :class:`long` or ``None``
        :param inventory_summary_interval: The minimum number of seconds between each upload of the inventory
            summary to backup server. format: int64
        :type  passphrase: :class:`str` or ``None``
        :param passphrase: Passphrase used to encrypt backup files. The passphrase specified
            must be at least 8 characters in length and must contain at least
            one lowercase, one uppercase, one numeric character and one special
            character (any other non-space character).
        :type  remote_file_server: :class:`RemoteFileServer` or ``None``
        :param remote_file_server: 
        """
        self.after_inventory_update_interval = after_inventory_update_interval
        self.backup_enabled = backup_enabled
        self.backup_schedule = backup_schedule
        self.inventory_summary_interval = inventory_summary_interval
        self.passphrase = passphrase
        self.remote_file_server = remote_file_server
        VapiStruct.__init__(self)


BackupConfiguration._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.backup_configuration', {
        'after_inventory_update_interval': type.OptionalType(type.IntegerType()),
        'backup_enabled': type.OptionalType(type.BooleanType()),
        'backup_schedule': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'BackupSchedule')])),
        'inventory_summary_interval': type.OptionalType(type.IntegerType()),
        'passphrase': type.OptionalType(type.StringType()),
        'remote_file_server': type.OptionalType(type.ReferenceType(__name__, 'RemoteFileServer')),
    },
    BackupConfiguration,
    False,
    None))



class BackupOperationHistory(VapiStruct):
    """
    Past backup operation details

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    OVERALL_BACKUP_STATUS_NOT_AVAILABLE = "NOT_AVAILABLE"
    """


    """
    OVERALL_BACKUP_STATUS_IN_PROGRESS = "IN_PROGRESS"
    """


    """
    OVERALL_BACKUP_STATUS_SUCCESS = "SUCCESS"
    """


    """
    OVERALL_BACKUP_STATUS_FAILED = "FAILED"
    """


    """



    _canonical_to_pep_names = {
                            'cluster_backup_statuses': 'cluster_backup_statuses',
                            'inventory_backup_statuses': 'inventory_backup_statuses',
                            'node_backup_statuses': 'node_backup_statuses',
                            'overall_backup_status': 'overall_backup_status',
                            }

    def __init__(self,
                 cluster_backup_statuses=None,
                 inventory_backup_statuses=None,
                 node_backup_statuses=None,
                 overall_backup_status=None,
                ):
        """
        :type  cluster_backup_statuses: :class:`list` of :class:`BackupOperationStatus` or ``None``
        :param cluster_backup_statuses: Statuses of previous cluster backups
        :type  inventory_backup_statuses: :class:`list` of :class:`BackupOperationStatus` or ``None``
        :param inventory_backup_statuses: Statuses of previous inventory backups
        :type  node_backup_statuses: :class:`list` of :class:`BackupOperationStatus` or ``None``
        :param node_backup_statuses: Statuses of previous node backups
        :type  overall_backup_status: :class:`str` or ``None``
        :param overall_backup_status: Possible values are: 
            
            *
              :attr:`BackupOperationHistory.OVERALL_BACKUP_STATUS_NOT_AVAILABLE`
            * :attr:`BackupOperationHistory.OVERALL_BACKUP_STATUS_IN_PROGRESS`
            * :attr:`BackupOperationHistory.OVERALL_BACKUP_STATUS_SUCCESS`
            * :attr:`BackupOperationHistory.OVERALL_BACKUP_STATUS_FAILED`
            
            This attribute is used to indicate the overall backup status
        """
        self.cluster_backup_statuses = cluster_backup_statuses
        self.inventory_backup_statuses = inventory_backup_statuses
        self.node_backup_statuses = node_backup_statuses
        self.overall_backup_status = overall_backup_status
        VapiStruct.__init__(self)


BackupOperationHistory._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.backup_operation_history', {
        'cluster_backup_statuses': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BackupOperationStatus'))),
        'inventory_backup_statuses': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BackupOperationStatus'))),
        'node_backup_statuses': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BackupOperationStatus'))),
        'overall_backup_status': type.OptionalType(type.StringType()),
    },
    BackupOperationHistory,
    False,
    None))



class BackupOperationStatus(VapiStruct):
    """
    Backup operation status

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ERROR_CODE_BACKUP_NOT_RUN_ON_MASTER = "BACKUP_NOT_RUN_ON_MASTER"
    """


    """
    ERROR_CODE_BACKUP_SERVER_UNREACHABLE = "BACKUP_SERVER_UNREACHABLE"
    """


    """
    ERROR_CODE_BACKUP_AUTHENTICATION_FAILURE = "BACKUP_AUTHENTICATION_FAILURE"
    """


    """
    ERROR_CODE_BACKUP_PERMISSION_ERROR = "BACKUP_PERMISSION_ERROR"
    """


    """
    ERROR_CODE_BACKUP_TIMEOUT = "BACKUP_TIMEOUT"
    """


    """
    ERROR_CODE_BACKUP_BAD_FINGERPRINT = "BACKUP_BAD_FINGERPRINT"
    """


    """
    ERROR_CODE_BACKUP_GENERIC_ERROR = "BACKUP_GENERIC_ERROR"
    """


    """
    ERROR_CODE_UPGRADE_IN_PROGRESS = "UPGRADE_IN_PROGRESS"
    """


    """



    _canonical_to_pep_names = {
                            'backup_id': 'backup_id',
                            'end_time': 'end_time',
                            'error_code': 'error_code',
                            'error_message': 'error_message',
                            'start_time': 'start_time',
                            'success': 'success',
                            }

    def __init__(self,
                 backup_id=None,
                 end_time=None,
                 error_code=None,
                 error_message=None,
                 start_time=None,
                 success=None,
                ):
        """
        :type  backup_id: :class:`str` or ``None``
        :param backup_id: Unique identifier of a backup
        :type  end_time: :class:`long` or ``None``
        :param end_time: Time when operation was ended format: int64
        :type  error_code: :class:`str` or ``None``
        :param error_code: Possible values are: 
            
            * :attr:`BackupOperationStatus.ERROR_CODE_BACKUP_NOT_RUN_ON_MASTER`
            *
              :attr:`BackupOperationStatus.ERROR_CODE_BACKUP_SERVER_UNREACHABLE`
            *
              :attr:`BackupOperationStatus.ERROR_CODE_BACKUP_AUTHENTICATION_FAILURE`
            * :attr:`BackupOperationStatus.ERROR_CODE_BACKUP_PERMISSION_ERROR`
            * :attr:`BackupOperationStatus.ERROR_CODE_BACKUP_TIMEOUT`
            * :attr:`BackupOperationStatus.ERROR_CODE_BACKUP_BAD_FINGERPRINT`
            * :attr:`BackupOperationStatus.ERROR_CODE_BACKUP_GENERIC_ERROR`
            * :attr:`BackupOperationStatus.ERROR_CODE_UPGRADE_IN_PROGRESS`
            
            Error code
        :type  error_message: :class:`str` or ``None``
        :param error_message: Error code details
        :type  start_time: :class:`long` or ``None``
        :param start_time: Time when operation was started format: int64
        :type  success: :class:`bool` or ``None``
        :param success: True if backup is successfully completed, else false
        """
        self.backup_id = backup_id
        self.end_time = end_time
        self.error_code = error_code
        self.error_message = error_message
        self.start_time = start_time
        self.success = success
        VapiStruct.__init__(self)


BackupOperationStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.backup_operation_status', {
        'backup_id': type.OptionalType(type.StringType()),
        'end_time': type.OptionalType(type.IntegerType()),
        'error_code': type.OptionalType(type.StringType()),
        'error_message': type.OptionalType(type.StringType()),
        'start_time': type.OptionalType(type.IntegerType()),
        'success': type.OptionalType(type.BooleanType()),
    },
    BackupOperationStatus,
    False,
    None))



class BackupOverview(VapiStruct):
    """
    Data for a single backup/restore card

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            'backup_config': 'backup_config',
                            'backup_operation_history': 'backup_operation_history',
                            'current_backup_operation_status': 'current_backup_operation_status',
                            'restore_status': 'restore_status',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                 backup_config=None,
                 backup_operation_history=None,
                 current_backup_operation_status=None,
                 restore_status=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ClusterBackupInfo` or ``None``
        :param results: List of timestamps of backed-up cluster files
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  backup_config: :class:`BackupConfiguration` or ``None``
        :param backup_config: 
        :type  backup_operation_history: :class:`BackupOperationHistory` or ``None``
        :param backup_operation_history: 
        :type  current_backup_operation_status: :class:`CurrentBackupOperationStatus` or ``None``
        :param current_backup_operation_status: 
        :type  restore_status: :class:`ClusterRestoreStatus` or ``None``
        :param restore_status: 
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        self.backup_config = backup_config
        self.backup_operation_history = backup_operation_history
        self.current_backup_operation_status = current_backup_operation_status
        self.restore_status = restore_status
        VapiStruct.__init__(self)


BackupOverview._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.backup_overview', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ClusterBackupInfo'))),
        'backup_config': type.OptionalType(type.ReferenceType(__name__, 'BackupConfiguration')),
        'backup_operation_history': type.OptionalType(type.ReferenceType(__name__, 'BackupOperationHistory')),
        'current_backup_operation_status': type.OptionalType(type.ReferenceType(__name__, 'CurrentBackupOperationStatus')),
        'restore_status': type.OptionalType(type.ReferenceType(__name__, 'ClusterRestoreStatus')),
    },
    BackupOverview,
    False,
    None))



class BackupSchedule(VapiStruct):
    """
    Abstract base type for Weekly or Interval Backup Schedule

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BackupSchedule"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    RESOURCE_TYPE_WEEKLYBACKUPSCHEDULE = "WeeklyBackupSchedule"
    """


    """
    RESOURCE_TYPE_INTERVALBACKUPSCHEDULE = "IntervalBackupSchedule"
    """


    """



    _canonical_to_pep_names = {
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 resource_type='BackupSchedule',
                ):
        """
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`BackupSchedule.RESOURCE_TYPE_WEEKLYBACKUPSCHEDULE`
            * :attr:`BackupSchedule.RESOURCE_TYPE_INTERVALBACKUPSCHEDULE`
            
            Schedule type
        """
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BackupSchedule._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.backup_schedule', {
        'resource_type': type.StringType(),
    },
    BackupSchedule,
    False,
    None))



class BaseCompatibilityCheckResult(VapiStruct):
    """
    Precheck result for onboaring standby Global Manager or remote Site to
    federation description: | Result of prechecks run for onboarding standby
    Global Manager or remote site. The checks include NSX version compatibility
    with active Global Manager, Round Trip Time (RTT), etc. Note that some of
    checks like RTT are soft limits.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'local_nsx_version': 'local_nsx_version',
                            'nsx_version': 'nsx_version',
                            'rtt': 'rtt',
                            'rtt_exceeded': 'rtt_exceeded',
                            'version_compatible': 'version_compatible',
                            }

    def __init__(self,
                 local_nsx_version=None,
                 nsx_version=None,
                 rtt=None,
                 rtt_exceeded=None,
                 version_compatible=None,
                ):
        """
        :type  local_nsx_version: :class:`str` or ``None``
        :param local_nsx_version: Local Site NSX version where active Global Mananger is running.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  nsx_version: :class:`str` or ``None``
        :param nsx_version: Remote Site NSX version.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  rtt: :class:`long` or ``None``
        :param rtt: Round trip time to the remote Site or Global Manager from active
            Global Manager. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  rtt_exceeded: :class:`bool` or ``None``
        :param rtt_exceeded: Flag to indicate if RTT to remote Site exceeds the recommended
            limit.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  version_compatible: :class:`bool` or ``None``
        :param version_compatible: Flag to indicate if remote Site NSX version is compatible with
            active Global Manager.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.local_nsx_version = local_nsx_version
        self.nsx_version = nsx_version
        self.rtt = rtt
        self.rtt_exceeded = rtt_exceeded
        self.version_compatible = version_compatible
        VapiStruct.__init__(self)


BaseCompatibilityCheckResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.base_compatibility_check_result', {
        'local_nsx_version': type.OptionalType(type.StringType()),
        'nsx_version': type.OptionalType(type.StringType()),
        'rtt': type.OptionalType(type.IntegerType()),
        'rtt_exceeded': type.OptionalType(type.BooleanType()),
        'version_compatible': type.OptionalType(type.BooleanType()),
    },
    BaseCompatibilityCheckResult,
    False,
    None))



class BaseConsolidatedStatusPerEnforcementPoint(VapiStruct):
    """
    Consolidated Realized Status Per Enforcement Point.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BaseConsolidatedStatusPerEnforcementPoint"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'alarm': 'alarm',
                            'enforcement_point_path': 'enforcement_point_path',
                            'consolidated_status': 'consolidated_status',
                            'enforcement_point_id': 'enforcement_point_id',
                            'resource_type': 'resource_type',
                            'site_path': 'site_path',
                            }

    def __init__(self,
                 alarm=None,
                 enforcement_point_path=None,
                 consolidated_status=None,
                 enforcement_point_id=None,
                 resource_type='BaseConsolidatedStatusPerEnforcementPoint',
                 site_path=None,
                ):
        """
        :type  alarm: :class:`PolicyRuntimeAlarm` or ``None``
        :param alarm: 
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: Policy Path referencing the enforcement point where the info is
            fetched.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  consolidated_status: :class:`ConsolidatedStatus` or ``None``
        :param consolidated_status: 
        :type  enforcement_point_id: :class:`str` or ``None``
        :param enforcement_point_id: Enforcement Point Id.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  site_path: :class:`str` or ``None``
        :param site_path: The site where this enforcement point resides.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.alarm = alarm
        self.enforcement_point_path = enforcement_point_path
        self.consolidated_status = consolidated_status
        self.enforcement_point_id = enforcement_point_id
        self._resource_type = resource_type
        self.site_path = site_path
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BaseConsolidatedStatusPerEnforcementPoint._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.base_consolidated_status_per_enforcement_point', {
        'alarm': type.OptionalType(type.ReferenceType(__name__, 'PolicyRuntimeAlarm')),
        'enforcement_point_path': type.OptionalType(type.StringType()),
        'consolidated_status': type.OptionalType(type.ReferenceType(__name__, 'ConsolidatedStatus')),
        'enforcement_point_id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'site_path': type.OptionalType(type.StringType()),
    },
    BaseConsolidatedStatusPerEnforcementPoint,
    False,
    None))



class BaseCountObservation(VapiStruct):
    """
    The count action results from aggregating checkpoints per port.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'checkpoints': 'checkpoints',
                            'port_id': 'port_id',
                            'port_name': 'port_name',
                            'transport_node_id': 'transport_node_id',
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 checkpoints=None,
                 port_id=None,
                 port_name=None,
                 transport_node_id=None,
                 resource_type=None,
                ):
        """
        :type  checkpoints: :class:`CheckpointCounterResult` or ``None``
        :param checkpoints: 
        :type  port_id: :class:`str` or ``None``
        :param port_id: The port identifier in UUID format. This field won't appear
            together with port_name.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  port_name: :class:`str` or ``None``
        :param port_name: The port name for a port. It applies to ports like the uplink port.
            This field won't appear together with port_id.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  transport_node_id: :class:`str` or ``None``
        :param transport_node_id: This field tells which transport node the checkpoints are reported
            from.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  resource_type: :class:`str`
        :param resource_type: Type of count observation
        """
        self.checkpoints = checkpoints
        self.port_id = port_id
        self.port_name = port_name
        self.transport_node_id = transport_node_id
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BaseCountObservation._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.base_count_observation', {
        'checkpoints': type.OptionalType(type.ReferenceType(__name__, 'CheckpointCounterResult')),
        'port_id': type.OptionalType(type.StringType()),
        'port_name': type.OptionalType(type.StringType()),
        'transport_node_id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
    },
    BaseCountObservation,
    False,
    None))



class BaseEndpoint(VapiStruct):
    """
    Represents an endpoint which will be used as subject in rule. It is a
    polymorphic type object which can be either of the types - 1. Virtual 2.
    Logical We have 2 separate objects representing these 2 types.
    VirtualEndPoint for Virtual type and ServiceInstanceEndpoint for Logical.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BaseEndpoint"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    RESOURCE_TYPE_VIRTUALENDPOINT = "VirtualEndpoint"
    """


    """
    RESOURCE_TYPE_SERVICEINSTANCEENDPOINT = "ServiceInstanceEndpoint"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'origin_site_id': 'origin_site_id',
                            'owner_id': 'owner_id',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'remote_path': 'remote_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'target_ips': 'target_ips',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type='BaseEndpoint',
                 tags=None,
                 origin_site_id=None,
                 owner_id=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 remote_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 target_ips=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`BaseEndpoint.RESOURCE_TYPE_VIRTUALENDPOINT`
            * :attr:`BaseEndpoint.RESOURCE_TYPE_SERVICEINSTANCEENDPOINT`
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  origin_site_id: :class:`str` or ``None``
        :param origin_site_id: This is a UUID generated by the system for knowing which site owns
            an object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  owner_id: :class:`str` or ``None``
        :param owner_id: This is a UUID generated by the system for knowing who owns this
            object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated their unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_path: :class:`str` or ``None``
        :param remote_path: This is the path of the object on the local managers when queried
            on the NSX+ service, and path of the object on NSX+ service when
            queried from the local managers.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entities
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: Subtree for this type within policy tree containing nested
            elements. Note that this type is applicable to be used in
            Hierarchical API only.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  target_ips: :class:`list` of :class:`IPInfo` or ``None``
        :param target_ips: IPs where either inbound or outbound traffic is to be redirected.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.origin_site_id = origin_site_id
        self.owner_id = owner_id
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.remote_path = remote_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.target_ips = target_ips
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BaseEndpoint._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.base_endpoint', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'origin_site_id': type.OptionalType(type.StringType()),
        'owner_id': type.OptionalType(type.StringType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'remote_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'target_ips': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'IPInfo'))),
    },
    BaseEndpoint,
    False,
    None))



class BaseInterfaceGroup(VapiStruct):
    """
    Tier0/Tier1 Interface group for interface grouping.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'origin_site_id': 'origin_site_id',
                            'owner_id': 'owner_id',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'remote_path': 'remote_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'members': 'members',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 origin_site_id=None,
                 owner_id=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 remote_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 members=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  origin_site_id: :class:`str` or ``None``
        :param origin_site_id: This is a UUID generated by the system for knowing which site owns
            an object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  owner_id: :class:`str` or ``None``
        :param owner_id: This is a UUID generated by the system for knowing who owns this
            object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated their unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_path: :class:`str` or ``None``
        :param remote_path: This is the path of the object on the local managers when queried
            on the NSX+ service, and path of the object on NSX+ service when
            queried from the local managers.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entities
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: Subtree for this type within policy tree containing nested
            elements. Note that this type is applicable to be used in
            Hierarchical API only.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  members: :class:`list` of :class:`GatewayInterfaceReference` or ``None``
        :param members: List of interface reference. Interface must belong to same
            location.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.origin_site_id = origin_site_id
        self.owner_id = owner_id
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.remote_path = remote_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.members = members
        VapiStruct.__init__(self)


BaseInterfaceGroup._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.base_interface_group', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'origin_site_id': type.OptionalType(type.StringType()),
        'owner_id': type.OptionalType(type.StringType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'remote_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'members': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'GatewayInterfaceReference'))),
    },
    BaseInterfaceGroup,
    False,
    None))



class BasePktCapResource(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BasePktCapResource"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'resource_type': 'resource_type',
                            }

    def __init__(self,
                 resource_type='BasePktCapResource',
                ):
        """
        :type  resource_type: :class:`str`
        :param resource_type: Type of packet capture resource
        """
        self._resource_type = resource_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BasePktCapResource._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.base_pkt_cap_resource', {
        'resource_type': type.StringType(),
    },
    BasePktCapResource,
    False,
    None))



class BasePolicyServiceInstance(VapiStruct):
    """
    Represents an instance of partner Service and its configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    DEPLOYMENT_MODE_STAND_ALONE = "STAND_ALONE"
    """


    """
    DEPLOYMENT_MODE_ACTIVE_STANDBY = "ACTIVE_STANDBY"
    """


    """
    TRANSPORT_TYPE_L2_BRIDGE = "L2_BRIDGE"
    """


    """
    TRANSPORT_TYPE_L3_ROUTED = "L3_ROUTED"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'origin_site_id': 'origin_site_id',
                            'owner_id': 'owner_id',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'remote_path': 'remote_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'deployment_mode': 'deployment_mode',
                            'partner_service_name': 'partner_service_name',
                            'transport_type': 'transport_type',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 origin_site_id=None,
                 owner_id=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 remote_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 deployment_mode=None,
                 partner_service_name=None,
                 transport_type=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  origin_site_id: :class:`str` or ``None``
        :param origin_site_id: This is a UUID generated by the system for knowing which site owns
            an object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  owner_id: :class:`str` or ``None``
        :param owner_id: This is a UUID generated by the system for knowing who owns this
            object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated their unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_path: :class:`str` or ``None``
        :param remote_path: This is the path of the object on the local managers when queried
            on the NSX+ service, and path of the object on NSX+ service when
            queried from the local managers.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entities
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: Subtree for this type within policy tree containing nested
            elements. Note that this type is applicable to be used in
            Hierarchical API only.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  deployment_mode: :class:`str` or ``None``
        :param deployment_mode: Possible values are: 
            
            * :attr:`BasePolicyServiceInstance.DEPLOYMENT_MODE_STAND_ALONE`
            * :attr:`BasePolicyServiceInstance.DEPLOYMENT_MODE_ACTIVE_STANDBY`
            
            Deployment mode specifies how the partner appliance will be
            deployed i.e. in HA or standalone mode.
        :type  partner_service_name: :class:`str` or ``None``
        :param partner_service_name: Unique name of Partner Service in the Marketplace
        :type  transport_type: :class:`str` or ``None``
        :param transport_type: Possible values are: 
            
            * :attr:`BasePolicyServiceInstance.TRANSPORT_TYPE_L2_BRIDGE`
            * :attr:`BasePolicyServiceInstance.TRANSPORT_TYPE_L3_ROUTED`
            
            Transport to be used while deploying Service-VM.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.origin_site_id = origin_site_id
        self.owner_id = owner_id
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.remote_path = remote_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.deployment_mode = deployment_mode
        self.partner_service_name = partner_service_name
        self.transport_type = transport_type
        VapiStruct.__init__(self)


BasePolicyServiceInstance._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.base_policy_service_instance', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'origin_site_id': type.OptionalType(type.StringType()),
        'owner_id': type.OptionalType(type.StringType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'remote_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'deployment_mode': type.OptionalType(type.StringType()),
        'partner_service_name': type.OptionalType(type.StringType()),
        'transport_type': type.OptionalType(type.StringType()),
    },
    BasePolicyServiceInstance,
    False,
    None))



class BaseRule(VapiStruct):
    """
    A rule indicates the action to be performed for various types of traffic
    flowing between workload groups.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    DIRECTION_IN = "IN"
    """


    """
    DIRECTION_OUT = "OUT"
    """


    """
    DIRECTION_IN_OUT = "IN_OUT"
    """


    """
    IP_PROTOCOL_IPV4 = "IPV4"
    """


    """
    IP_PROTOCOL_IPV6 = "IPV6"
    """


    """
    IP_PROTOCOL_IPV4_IPV6 = "IPV4_IPV6"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'origin_site_id': 'origin_site_id',
                            'owner_id': 'owner_id',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'remote_path': 'remote_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'destination_groups': 'destination_groups',
                            'destinations_excluded': 'destinations_excluded',
                            'direction': 'direction',
                            'disabled': 'disabled',
                            'ip_protocol': 'ip_protocol',
                            'is_default': 'is_default',
                            'logged': 'logged',
                            'notes': 'notes',
                            'profiles': 'profiles',
                            'rule_id': 'rule_id',
                            'scope': 'scope',
                            'sequence_number': 'sequence_number',
                            'service_entries': 'service_entries',
                            'services': 'services',
                            'source_groups': 'source_groups',
                            'sources_excluded': 'sources_excluded',
                            'tag': 'tag',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 origin_site_id=None,
                 owner_id=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 remote_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 destination_groups=None,
                 destinations_excluded=None,
                 direction=None,
                 disabled=None,
                 ip_protocol=None,
                 is_default=None,
                 logged=None,
                 notes=None,
                 profiles=None,
                 rule_id=None,
                 scope=None,
                 sequence_number=None,
                 service_entries=None,
                 services=None,
                 source_groups=None,
                 sources_excluded=None,
                 tag=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  origin_site_id: :class:`str` or ``None``
        :param origin_site_id: This is a UUID generated by the system for knowing which site owns
            an object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  owner_id: :class:`str` or ``None``
        :param owner_id: This is a UUID generated by the system for knowing who owns this
            object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated their unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_path: :class:`str` or ``None``
        :param remote_path: This is the path of the object on the local managers when queried
            on the NSX+ service, and path of the object on NSX+ service when
            queried from the local managers.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entities
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: Subtree for this type within policy tree containing nested
            elements. Note that this type is applicable to be used in
            Hierarchical API only.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  destination_groups: :class:`list` of :class:`str` or ``None``
        :param destination_groups: We need paths as duplicate names may exist for groups under
            different domains. Along with paths we support IP Address of type
            IPv4 and IPv6. IP Address can be in one of the format(CIDR, IP
            Address, Range of IP Address). In order to specify all groups, use
            the constant \"ANY\". This is case insensitive. If \"ANY\" is used,
            it should be the ONLY element in the group array. Error will be
            thrown if ANY is used in conjunction with other values.
        :type  destinations_excluded: :class:`bool` or ``None``
        :param destinations_excluded: If set to true, the rule gets applied on all the groups that are
            NOT part of the destination groups. If false, the rule applies to
            the destination groups
        :type  direction: :class:`str` or ``None``
        :param direction: Possible values are: 
            
            * :attr:`BaseRule.DIRECTION_IN`
            * :attr:`BaseRule.DIRECTION_OUT`
            * :attr:`BaseRule.DIRECTION_IN_OUT`
            
            Define direction of traffic.
        :type  disabled: :class:`bool` or ``None``
        :param disabled: Flag to deactivate the rule. Default is activated.
        :type  ip_protocol: :class:`str` or ``None``
        :param ip_protocol: Possible values are: 
            
            * :attr:`BaseRule.IP_PROTOCOL_IPV4`
            * :attr:`BaseRule.IP_PROTOCOL_IPV6`
            * :attr:`BaseRule.IP_PROTOCOL_IPV4_IPV6`
            
            Type of IP packet that should be matched while enforcing the rule.
            The value is set to IPV4_IPV6 for Layer3 rule if not specified. For
            Layer2/Ether rule the value must be null.
        :type  is_default: :class:`bool` or ``None``
        :param is_default: A flag to indicate whether rule is a default rule.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  logged: :class:`bool` or ``None``
        :param logged: Flag to enable packet logging. Default is deactivated.
        :type  notes: :class:`str` or ``None``
        :param notes: Text for additional notes on changes.
        :type  profiles: :class:`list` of :class:`str` or ``None``
        :param profiles: Holds the list of layer 7 service profile paths. These profiles
            accept attributes and sub-attributes of various network services
            (e.g. L4 AppId, encryption algorithm, domain name, etc) as key
            value pairs. Instead of Layer 7 service profiles you can use a L7
            access profile. One of either Layer 7 service profiles or L7 Access
            Profile can be used in firewall rule. In case of L7 access profile
            only one is allowed.
        :type  rule_id: :class:`long` or ``None``
        :param rule_id: This is a unique 4 byte positive number that is assigned by the
            system. This rule id is passed all the way down to the data path.
            The first 1GB (1000 to 2^30) will be shared by GM and LM with zebra
            style striped number space. For E.g 1000 to (1Million -1) by LM,
            (1M - 2M-1) by GM and so on. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  scope: :class:`list` of :class:`str` or ``None``
        :param scope: The list of policy paths where the rule is applied
            LR/Edge/T0/T1/LRP etc. Note that a given rule can be applied on
            multiple LRs/LRPs.
        :type  sequence_number: :class:`long` or ``None``
        :param sequence_number: This field is used to resolve conflicts between multiple Rules
            under Security or Gateway Policy for a Domain If no sequence number
            is specified in the payload, a value of 0 is assigned by default.
            If there are multiple rules with the same sequence number then
            their order is not deterministic. If a specific order of rules is
            desired, then one has to specify unique sequence numbers or use the
            POST request on the rule entity with a query parameter
            action=revise to let the framework assign a sequence number format:
            int32
        :type  service_entries: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param service_entries: In order to specify raw services this can be used, along with
            services which contains path to services. This can be empty or
            null.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ServiceEntry`. When methods return a value of this class as
            a return value, the attribute will contain all the attributes
            defined in :class:`ServiceEntry`.
        :type  services: :class:`list` of :class:`str` or ``None``
        :param services: In order to specify all services, use the constant \"ANY\". This is
            case insensitive. If \"ANY\" is used, it should be the ONLY element
            in the services array. Error will be thrown if ANY is used in
            conjunction with other values.
        :type  source_groups: :class:`list` of :class:`str` or ``None``
        :param source_groups: We need paths as duplicate names may exist for groups under
            different domains. Along with paths we support IP Address of type
            IPv4 and IPv6. IP Address can be in one of the format(CIDR, IP
            Address, Range of IP Address). In order to specify all groups, use
            the constant \"ANY\". This is case insensitive. If \"ANY\" is used,
            it should be the ONLY element in the group array. Error will be
            thrown if ANY is used in conjunction with other values.
        :type  sources_excluded: :class:`bool` or ``None``
        :param sources_excluded: If set to true, the rule gets applied on all the groups that are
            NOT part of the source groups. If false, the rule applies to the
            source groups
        :type  tag: :class:`str` or ``None``
        :param tag: User level field which will be printed in CLI and packet logs. Even
            though there is no limitation on length of a tag, internally tag
            will get truncated after 32 characters.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.origin_site_id = origin_site_id
        self.owner_id = owner_id
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.remote_path = remote_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.destination_groups = destination_groups
        self.destinations_excluded = destinations_excluded
        self.direction = direction
        self.disabled = disabled
        self.ip_protocol = ip_protocol
        self.is_default = is_default
        self.logged = logged
        self.notes = notes
        self.profiles = profiles
        self.rule_id = rule_id
        self.scope = scope
        self.sequence_number = sequence_number
        self.service_entries = service_entries
        self.services = services
        self.source_groups = source_groups
        self.sources_excluded = sources_excluded
        self.tag = tag
        VapiStruct.__init__(self)


BaseRule._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.base_rule', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'origin_site_id': type.OptionalType(type.StringType()),
        'owner_id': type.OptionalType(type.StringType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'remote_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'destination_groups': type.OptionalType(type.ListType(type.StringType())),
        'destinations_excluded': type.OptionalType(type.BooleanType()),
        'direction': type.OptionalType(type.StringType()),
        'disabled': type.OptionalType(type.BooleanType()),
        'ip_protocol': type.OptionalType(type.StringType()),
        'is_default': type.OptionalType(type.BooleanType()),
        'logged': type.OptionalType(type.BooleanType()),
        'notes': type.OptionalType(type.StringType()),
        'profiles': type.OptionalType(type.ListType(type.StringType())),
        'rule_id': type.OptionalType(type.IntegerType()),
        'scope': type.OptionalType(type.ListType(type.StringType())),
        'sequence_number': type.OptionalType(type.IntegerType()),
        'service_entries': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ServiceEntry')]))),
        'services': type.OptionalType(type.ListType(type.StringType())),
        'source_groups': type.OptionalType(type.ListType(type.StringType())),
        'sources_excluded': type.OptionalType(type.BooleanType()),
        'tag': type.OptionalType(type.StringType()),
    },
    BaseRule,
    False,
    None))



class BaseRuleListResult(VapiStruct):
    """
    Paged Collection of Rules

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        VapiStruct.__init__(self)


BaseRuleListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.base_rule_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
    },
    BaseRuleListResult,
    False,
    None))



class BaseTier0Interface(VapiStruct):
    """
    Tier-0 interface configuration for external connectivity.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'origin_site_id': 'origin_site_id',
                            'owner_id': 'owner_id',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'remote_path': 'remote_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'dhcp_relay_path': 'dhcp_relay_path',
                            'subnets': 'subnets',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 origin_site_id=None,
                 owner_id=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 remote_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 dhcp_relay_path=None,
                 subnets=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  origin_site_id: :class:`str` or ``None``
        :param origin_site_id: This is a UUID generated by the system for knowing which site owns
            an object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  owner_id: :class:`str` or ``None``
        :param owner_id: This is a UUID generated by the system for knowing who owns this
            object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated their unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_path: :class:`str` or ``None``
        :param remote_path: This is the path of the object on the local managers when queried
            on the NSX+ service, and path of the object on NSX+ service when
            queried from the local managers.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entities
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: Subtree for this type within policy tree containing nested
            elements. Note that this type is applicable to be used in
            Hierarchical API only.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  dhcp_relay_path: :class:`str` or ``None``
        :param dhcp_relay_path: Policy path of dhcp-relay-config to be attached to this Interface.
        :type  subnets: :class:`list` of :class:`InterfaceSubnet` or ``None``
        :param subnets: Specify IP address and network prefix for interface.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.origin_site_id = origin_site_id
        self.owner_id = owner_id
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.remote_path = remote_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.dhcp_relay_path = dhcp_relay_path
        self.subnets = subnets
        VapiStruct.__init__(self)


BaseTier0Interface._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.base_tier0_interface', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'origin_site_id': type.OptionalType(type.StringType()),
        'owner_id': type.OptionalType(type.StringType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'remote_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'dhcp_relay_path': type.OptionalType(type.StringType()),
        'subnets': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'InterfaceSubnet'))),
    },
    BaseTier0Interface,
    False,
    None))



class BatchRequest(VapiStruct):
    """
    A set of operations to be performed in a single batch

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'continue_on_error': 'continue_on_error',
                            'requests': 'requests',
                            }

    def __init__(self,
                 continue_on_error=None,
                 requests=None,
                ):
        """
        :type  continue_on_error: :class:`bool` or ``None``
        :param continue_on_error: Continue even if an error is encountered.
        :type  requests: :class:`list` of :class:`BatchRequestItem` or ``None``
        :param requests: 
        """
        self.continue_on_error = continue_on_error
        self.requests = requests
        VapiStruct.__init__(self)


BatchRequest._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.batch_request', {
        'continue_on_error': type.OptionalType(type.BooleanType()),
        'requests': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BatchRequestItem'))),
    },
    BatchRequest,
    False,
    None))



class BatchRequestItem(VapiStruct):
    """
    A single request within a batch of operations

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    METHOD_GET = "GET"
    """


    """
    METHOD_POST = "POST"
    """


    """
    METHOD_PUT = "PUT"
    """


    """
    METHOD_DELETE = "DELETE"
    """


    """
    METHOD_PATCH = "PATCH"
    """


    """



    _canonical_to_pep_names = {
                            'body': 'body',
                            'method': 'method',
                            'uri': 'uri',
                            }

    def __init__(self,
                 body=None,
                 method=None,
                 uri=None,
                ):
        """
        :type  body: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param body: 
        :type  method: :class:`str` or ``None``
        :param method: Possible values are: 
            
            * :attr:`BatchRequestItem.METHOD_GET`
            * :attr:`BatchRequestItem.METHOD_POST`
            * :attr:`BatchRequestItem.METHOD_PUT`
            * :attr:`BatchRequestItem.METHOD_DELETE`
            * :attr:`BatchRequestItem.METHOD_PATCH`
            
            http method type
        :type  uri: :class:`str` or ``None``
        :param uri: relative uri (path and args), of the call including resource id (if
            this is a POST/DELETE), exclude hostname and port and prefix,
            exploded form of parameters
        """
        self.body = body
        self.method = method
        self.uri = uri
        VapiStruct.__init__(self)


BatchRequestItem._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.batch_request_item', {
        'body': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
        'method': type.OptionalType(type.StringType()),
        'uri': type.OptionalType(type.StringType()),
    },
    BatchRequestItem,
    False,
    None))



class BatchResponse(VapiStruct):
    """
    The reponse to a batch operation

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'has_errors': 'has_errors',
                            'results': 'results',
                            'rolled_back': 'rolled_back',
                            }

    def __init__(self,
                 has_errors=None,
                 results=None,
                 rolled_back=None,
                ):
        """
        :type  has_errors: :class:`bool` or ``None``
        :param has_errors: Indicates if any of the APIs failed
        :type  results: :class:`list` of :class:`BatchResponseItem` or ``None``
        :param results: Bulk list results
        :type  rolled_back: :class:`bool` or ``None``
        :param rolled_back: Optional flag indicating that all items were rolled back even if
            succeeded initially
        """
        self.has_errors = has_errors
        self.results = results
        self.rolled_back = rolled_back
        VapiStruct.__init__(self)


BatchResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.batch_response', {
        'has_errors': type.OptionalType(type.BooleanType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BatchResponseItem'))),
        'rolled_back': type.OptionalType(type.BooleanType()),
    },
    BatchResponse,
    False,
    None))



class BatchResponseItem(VapiStruct):
    """
    A single respose in a list of batched responses

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'body': 'body',
                            'code': 'code',
                            'headers': 'headers',
                            }

    def __init__(self,
                 body=None,
                 code=None,
                 headers=None,
                ):
        """
        :type  body: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param body: object returned by api
        :type  code: :class:`long` or ``None``
        :param code: http status code format: int64
        :type  headers: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param headers: The headers returned by the API call
        """
        self.body = body
        self.code = code
        self.headers = headers
        VapiStruct.__init__(self)


BatchResponseItem._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.batch_response_item', {
        'body': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
        'code': type.OptionalType(type.IntegerType()),
        'headers': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
    },
    BatchResponseItem,
    False,
    None))



class BfdHealthMonitoringConfig(VapiStruct):
    """
    Bfd Health Monitoring Options used specific to BFD Transport Zone profiles

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'enabled': 'enabled',
                            'latency_enabled': 'latency_enabled',
                            'probe_interval': 'probe_interval',
                            }

    def __init__(self,
                 enabled=None,
                 latency_enabled=None,
                 probe_interval=None,
                ):
        """
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Whether the heartbeat is enabled. A PATCH or PUT request with
            \"enabled\" false (with no probe intervals) will set or reset the
            probe_interval to their default value.
        :type  latency_enabled: :class:`bool` or ``None``
        :param latency_enabled: The flag is to turn on/off latency. A PATCH or PUT request with
            \"latency_enabled\" true will enable NSX to send the networking
            latency data to thrid-party monitoring tools like vRNI.
        :type  probe_interval: :class:`long` or ``None``
        :param probe_interval: The time interval (in millisec) between probe packets for tunnels
            between transport nodes. format: int64
        """
        self.enabled = enabled
        self.latency_enabled = latency_enabled
        self.probe_interval = probe_interval
        VapiStruct.__init__(self)


BfdHealthMonitoringConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bfd_health_monitoring_config', {
        'enabled': type.OptionalType(type.BooleanType()),
        'latency_enabled': type.OptionalType(type.BooleanType()),
        'probe_interval': type.OptionalType(type.IntegerType()),
    },
    BfdHealthMonitoringConfig,
    False,
    None))



class BfdProfile(VapiStruct):
    """
    Bidirectional Forwarding Detection configuration for BGP peers

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'origin_site_id': 'origin_site_id',
                            'owner_id': 'owner_id',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'remote_path': 'remote_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'interval': 'interval',
                            'multiple': 'multiple',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 origin_site_id=None,
                 owner_id=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 remote_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 interval=None,
                 multiple=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  origin_site_id: :class:`str` or ``None``
        :param origin_site_id: This is a UUID generated by the system for knowing which site owns
            an object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  owner_id: :class:`str` or ``None``
        :param owner_id: This is a UUID generated by the system for knowing who owns this
            object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated their unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_path: :class:`str` or ``None``
        :param remote_path: This is the path of the object on the local managers when queried
            on the NSX+ service, and path of the object on NSX+ service when
            queried from the local managers.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entities
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: Subtree for this type within policy tree containing nested
            elements. Note that this type is applicable to be used in
            Hierarchical API only.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  interval: :class:`long` or ``None``
        :param interval: Time interval between heartbeat packets in milliseconds. format:
            int32
        :type  multiple: :class:`long` or ``None``
        :param multiple: Declare dead multiple. Number of times heartbeat packet is missed
            before BFD declares the neighbor is down. format: int32
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.origin_site_id = origin_site_id
        self.owner_id = owner_id
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.remote_path = remote_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.interval = interval
        self.multiple = multiple
        VapiStruct.__init__(self)


BfdProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bfd_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'origin_site_id': type.OptionalType(type.StringType()),
        'owner_id': type.OptionalType(type.StringType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'remote_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'interval': type.OptionalType(type.IntegerType()),
        'multiple': type.OptionalType(type.IntegerType()),
    },
    BfdProfile,
    False,
    None))



class BfdProfileListResult(VapiStruct):
    """
    Paged Collection of BfdProfile.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`BfdProfile` or ``None``
        :param results: Bfd Profile list results.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


BfdProfileListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bfd_profile_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BfdProfile'))),
    },
    BfdProfileListResult,
    False,
    None))



class BgpAddressFamily(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_IPV4_UNICAST = "IPV4_UNICAST"
    """


    """
    TYPE_VPNV4_UNICAST = "VPNV4_UNICAST"
    """


    """
    TYPE_IPV6_UNICAST = "IPV6_UNICAST"
    """


    """
    TYPE_L2VPN_EVPN = "L2VPN_EVPN"
    """


    """



    _canonical_to_pep_names = {
                            'in_prefix_count': 'in_prefix_count',
                            'out_prefix_count': 'out_prefix_count',
                            'type': 'type',
                            }

    def __init__(self,
                 in_prefix_count=None,
                 out_prefix_count=None,
                 type=None,
                ):
        """
        :type  in_prefix_count: :class:`long` or ``None``
        :param in_prefix_count: Count of in prefixes format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  out_prefix_count: :class:`long` or ``None``
        :param out_prefix_count: Count of out prefixes format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`BgpAddressFamily.TYPE_IPV4_UNICAST`
            * :attr:`BgpAddressFamily.TYPE_VPNV4_UNICAST`
            * :attr:`BgpAddressFamily.TYPE_IPV6_UNICAST`
            * :attr:`BgpAddressFamily.TYPE_L2VPN_EVPN`
            
            BGP address family type
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.in_prefix_count = in_prefix_count
        self.out_prefix_count = out_prefix_count
        self.type = type
        VapiStruct.__init__(self)


BgpAddressFamily._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_address_family', {
        'in_prefix_count': type.OptionalType(type.IntegerType()),
        'out_prefix_count': type.OptionalType(type.IntegerType()),
        'type': type.OptionalType(type.StringType()),
    },
    BgpAddressFamily,
    False,
    None))



class BgpBfdConfig(VapiStruct):
    """
    BFD configuration for BGP peers

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'enabled': 'enabled',
                            'interval': 'interval',
                            'multiple': 'multiple',
                            }

    def __init__(self,
                 enabled=None,
                 interval=None,
                 multiple=None,
                ):
        """
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Flag to enable BFD cofiguration.
        :type  interval: :class:`long` or ``None``
        :param interval: Time interval between heartbeat packets in milliseconds. format:
            int32
        :type  multiple: :class:`long` or ``None``
        :param multiple: Declare dead multiple. Number of times heartbeat packet is missed
            before BFD declares the neighbor is down. format: int32
        """
        self.enabled = enabled
        self.interval = interval
        self.multiple = multiple
        VapiStruct.__init__(self)


BgpBfdConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_bfd_config', {
        'enabled': type.OptionalType(type.BooleanType()),
        'interval': type.OptionalType(type.IntegerType()),
        'multiple': type.OptionalType(type.IntegerType()),
    },
    BgpBfdConfig,
    False,
    None))



class BgpGracefulRestartConfig(VapiStruct):
    """
    Configuration field to hold BGP restart mode and timer.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MODE_DISABLE = "DISABLE"
    """


    """
    MODE_GR_AND_HELPER = "GR_AND_HELPER"
    """


    """
    MODE_HELPER_ONLY = "HELPER_ONLY"
    """


    """



    _canonical_to_pep_names = {
                            'mode': 'mode',
                            'timer': 'timer',
                            }

    def __init__(self,
                 mode=None,
                 timer=None,
                ):
        """
        :type  mode: :class:`str` or ``None``
        :param mode: Possible values are: 
            
            * :attr:`BgpGracefulRestartConfig.MODE_DISABLE`
            * :attr:`BgpGracefulRestartConfig.MODE_GR_AND_HELPER`
            * :attr:`BgpGracefulRestartConfig.MODE_HELPER_ONLY`
            
            If mode is DISABLE, then graceful restart and helper modes are
            disabled. If mode is GR_AND_HELPER, then both graceful restart and
            helper modes are enabled. If mode is HELPER_ONLY, then helper mode
            is enabled. HELPER_ONLY mode is the ability for a BGP speaker to
            indicate its ability to preserve forwarding state during BGP
            restart. GRACEFUL_RESTART mode is the ability of a BGP speaker to
            advertise its restart to its peers.
        :type  timer: :class:`BgpGracefulRestartTimer` or ``None``
        :param timer: 
        """
        self.mode = mode
        self.timer = timer
        VapiStruct.__init__(self)


BgpGracefulRestartConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_graceful_restart_config', {
        'mode': type.OptionalType(type.StringType()),
        'timer': type.OptionalType(type.ReferenceType(__name__, 'BgpGracefulRestartTimer')),
    },
    BgpGracefulRestartConfig,
    False,
    None))



class BgpGracefulRestartTimer(VapiStruct):
    """
    Configuration field to hold BGP restart timers

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'restart_timer': 'restart_timer',
                            'stale_route_timer': 'stale_route_timer',
                            }

    def __init__(self,
                 restart_timer=None,
                 stale_route_timer=None,
                ):
        """
        :type  restart_timer: :class:`long` or ``None``
        :param restart_timer: Maximum time taken (in seconds) for a BGP session to be established
            after a restart. This can be used to speed up routing convergence
            by its peer in case the BGP speaker does not come back up after a
            restart. If the session is not re-established within this timer,
            the receiving speaker will delete all the stale routes from that
            peer. format: int64
        :type  stale_route_timer: :class:`long` or ``None``
        :param stale_route_timer: Maximum time (in seconds) before stale routes are removed from the
            RIB (Routing Information Base) when BGP restarts. format: int64
        """
        self.restart_timer = restart_timer
        self.stale_route_timer = stale_route_timer
        VapiStruct.__init__(self)


BgpGracefulRestartTimer._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_graceful_restart_timer', {
        'restart_timer': type.OptionalType(type.IntegerType()),
        'stale_route_timer': type.OptionalType(type.IntegerType()),
    },
    BgpGracefulRestartTimer,
    False,
    None))



class BgpNeighborConfig(VapiStruct):
    """
    Contains information necessary to configure a BGP neighbor.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    GRACEFUL_RESTART_MODE_DISABLE = "DISABLE"
    """


    """
    GRACEFUL_RESTART_MODE_GR_AND_HELPER = "GR_AND_HELPER"
    """


    """
    GRACEFUL_RESTART_MODE_HELPER_ONLY = "HELPER_ONLY"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'origin_site_id': 'origin_site_id',
                            'owner_id': 'owner_id',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'remote_path': 'remote_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'allow_as_in': 'allow_as_in',
                            'bfd': 'bfd',
                            'enabled': 'enabled',
                            'graceful_restart_mode': 'graceful_restart_mode',
                            'hold_down_time': 'hold_down_time',
                            'in_route_filters': 'in_route_filters',
                            'keep_alive_time': 'keep_alive_time',
                            'maximum_hop_limit': 'maximum_hop_limit',
                            'neighbor_address': 'neighbor_address',
                            'neighbor_local_as_config': 'neighbor_local_as_config',
                            'out_route_filters': 'out_route_filters',
                            'password': 'password',
                            'remote_as_num': 'remote_as_num',
                            'route_filtering': 'route_filtering',
                            'source_addresses': 'source_addresses',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 origin_site_id=None,
                 owner_id=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 remote_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 allow_as_in=None,
                 bfd=None,
                 enabled=None,
                 graceful_restart_mode=None,
                 hold_down_time=None,
                 in_route_filters=None,
                 keep_alive_time=None,
                 maximum_hop_limit=None,
                 neighbor_address=None,
                 neighbor_local_as_config=None,
                 out_route_filters=None,
                 password=None,
                 remote_as_num=None,
                 route_filtering=None,
                 source_addresses=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  origin_site_id: :class:`str` or ``None``
        :param origin_site_id: This is a UUID generated by the system for knowing which site owns
            an object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  owner_id: :class:`str` or ``None``
        :param owner_id: This is a UUID generated by the system for knowing who owns this
            object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated their unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_path: :class:`str` or ``None``
        :param remote_path: This is the path of the object on the local managers when queried
            on the NSX+ service, and path of the object on NSX+ service when
            queried from the local managers.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entities
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: Subtree for this type within policy tree containing nested
            elements. Note that this type is applicable to be used in
            Hierarchical API only.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  allow_as_in: :class:`bool` or ``None``
        :param allow_as_in: Flag to enable allowas_in option for BGP neighbor
        :type  bfd: :class:`BgpBfdConfig` or ``None``
        :param bfd: 
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Flag to enable/disable BGP peering. Disabling will stop the BGP
            peering. True - indicates enable BGP peering, False - indicates
            disable BGP peering. Default is True.
        :type  graceful_restart_mode: :class:`str` or ``None``
        :param graceful_restart_mode: Possible values are: 
            
            * :attr:`BgpNeighborConfig.GRACEFUL_RESTART_MODE_DISABLE`
            * :attr:`BgpNeighborConfig.GRACEFUL_RESTART_MODE_GR_AND_HELPER`
            * :attr:`BgpNeighborConfig.GRACEFUL_RESTART_MODE_HELPER_ONLY`
            
            If mode is DISABLE, then graceful restart and helper modes are
            disabled. If mode is GR_AND_HELPER, then both graceful restart and
            helper modes are enabled. If mode is HELPER_ONLY, then helper mode
            is enabled. HELPER_ONLY mode is the ability for a BGP speaker to
            indicate its ability to preserve forwarding state during BGP
            restart. GRACEFUL_RESTART mode is the ability of a BGP speaker to
            advertise its restart to its peers.
        :type  hold_down_time: :class:`long` or ``None``
        :param hold_down_time: Wait time in seconds before declaring peer dead. format: int32
        :type  in_route_filters: :class:`list` of :class:`str` or ``None``
        :param in_route_filters: Specify path of prefix-list or route map to filter routes for IN
            direction. This property is deprecated, use route_filtering
            instead. Specifying different values for both properties will
            result in error.

            .. deprecated:: unknown
        :type  keep_alive_time: :class:`long` or ``None``
        :param keep_alive_time: Interval (in seconds) between keep alive messages sent to peer.
            format: int32
        :type  maximum_hop_limit: :class:`long` or ``None``
        :param maximum_hop_limit: Maximum number of hops allowed to reach BGP neighbor. format: int32
        :type  neighbor_address: :class:`str` or ``None``
        :param neighbor_address: Neighbor IP Address format: ip
        :type  neighbor_local_as_config: :class:`BgpNeighborLocalAsConfig` or ``None``
        :param neighbor_local_as_config: 
        :type  out_route_filters: :class:`list` of :class:`str` or ``None``
        :param out_route_filters: Specify path of prefix-list or route map to filter routes for OUT
            direction. When not specified, a built-in prefix-list named
            'prefixlist-out-default' is automatically applied. This property is
            deprecated, use route_filtering instead. Specifying different
            values for both properties will result in error.

            .. deprecated:: unknown
        :type  password: :class:`str` or ``None``
        :param password: Specify password for BGP neighbor authentication. Empty string
            (\"\") clears existing password.
        :type  remote_as_num: :class:`str` or ``None``
        :param remote_as_num: 4 Byte ASN of the neighbor in ASPLAIN Format
        :type  route_filtering: :class:`list` of :class:`BgpRouteFiltering` or ``None``
        :param route_filtering: Enable address families and route filtering in each direction.
        :type  source_addresses: :class:`list` of :class:`str` or ``None``
        :param source_addresses: Source addresses should belong to Tier0 external or loopback or VTI
            interface IP Addresses . BGP peering is formed from all these
            addresses. This property is mandatory when maximum_hop_limit is
            greater than 1. format: ip
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.origin_site_id = origin_site_id
        self.owner_id = owner_id
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.remote_path = remote_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.allow_as_in = allow_as_in
        self.bfd = bfd
        self.enabled = enabled
        self.graceful_restart_mode = graceful_restart_mode
        self.hold_down_time = hold_down_time
        self.in_route_filters = in_route_filters
        self.keep_alive_time = keep_alive_time
        self.maximum_hop_limit = maximum_hop_limit
        self.neighbor_address = neighbor_address
        self.neighbor_local_as_config = neighbor_local_as_config
        self.out_route_filters = out_route_filters
        self.password = password
        self.remote_as_num = remote_as_num
        self.route_filtering = route_filtering
        self.source_addresses = source_addresses
        VapiStruct.__init__(self)


BgpNeighborConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_neighbor_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'origin_site_id': type.OptionalType(type.StringType()),
        'owner_id': type.OptionalType(type.StringType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'remote_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'allow_as_in': type.OptionalType(type.BooleanType()),
        'bfd': type.OptionalType(type.ReferenceType(__name__, 'BgpBfdConfig')),
        'enabled': type.OptionalType(type.BooleanType()),
        'graceful_restart_mode': type.OptionalType(type.StringType()),
        'hold_down_time': type.OptionalType(type.IntegerType()),
        'in_route_filters': type.OptionalType(type.ListType(type.StringType())),
        'keep_alive_time': type.OptionalType(type.IntegerType()),
        'maximum_hop_limit': type.OptionalType(type.IntegerType()),
        'neighbor_address': type.OptionalType(type.StringType()),
        'neighbor_local_as_config': type.OptionalType(type.ReferenceType(__name__, 'BgpNeighborLocalAsConfig')),
        'out_route_filters': type.OptionalType(type.ListType(type.StringType())),
        'password': type.OptionalType(type.StringType()),
        'remote_as_num': type.OptionalType(type.StringType()),
        'route_filtering': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BgpRouteFiltering'))),
        'source_addresses': type.OptionalType(type.ListType(type.StringType())),
    },
    BgpNeighborConfig,
    False,
    None))



class BgpNeighborConfigListResult(VapiStruct):
    """
    Paged collection of BGP Neighbor Configs

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`BgpNeighborConfig` or ``None``
        :param results: BGP neighbor configs list results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


BgpNeighborConfigListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_neighbor_config_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BgpNeighborConfig'))),
    },
    BgpNeighborConfigListResult,
    False,
    None))



class BgpNeighborLocalAsConfig(VapiStruct):
    """
    BGP neighbor local-as configuration

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    AS_PATH_MODIFIER_TYPE_PREPEND = "NO_PREPEND"
    """


    """
    AS_PATH_MODIFIER_TYPE_PREPEND_REPLACE_AS = "NO_PREPEND_REPLACE_AS"
    """


    """



    _canonical_to_pep_names = {
                            'as_path_modifier_type': 'as_path_modifier_type',
                            'local_as_num': 'local_as_num',
                            }

    def __init__(self,
                 as_path_modifier_type=None,
                 local_as_num=None,
                ):
        """
        :type  as_path_modifier_type: :class:`str` or ``None``
        :param as_path_modifier_type: Possible values are: 
            
            * :attr:`BgpNeighborLocalAsConfig.AS_PATH_MODIFIER_TYPE_PREPEND`
            *
              :attr:`BgpNeighborLocalAsConfig.AS_PATH_MODIFIER_TYPE_PREPEND_REPLACE_AS`
            
            Optional parameter. If this property is not set, by default BGP
            prepends neighbor's local_as_num value to the AS_PATH for BOTH
            outgoing and incoming route advertisements from the peer neighbor.
            By setting one of the following value, user can modify the default
            prepend action on the AS_PATH in both inbound and outbound
            direction. NO_PREPEND: If type is NO_PREPEND, then the local router
            will NOT prepend the incoming advertisement from that peer with
            neighbor's local_as_num, so the AS path advertised will now prepend
            only the BGP local-as of the router. NO_PREPEND_REPLACE_AS - If
            type is \"NO_PREPEND_REPLACE_AS\", then the local routes will be
            advertised with the neighbor's local-as instead of the BGP's
            local-as to peer router.
        :type  local_as_num: :class:`str` or ``None``
        :param local_as_num: 
        """
        self.as_path_modifier_type = as_path_modifier_type
        self.local_as_num = local_as_num
        VapiStruct.__init__(self)


BgpNeighborLocalAsConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_neighbor_local_as_config', {
        'as_path_modifier_type': type.OptionalType(type.StringType()),
        'local_as_num': type.OptionalType(type.StringType()),
    },
    BgpNeighborLocalAsConfig,
    False,
    None))



class BgpNeighborRouteDetailsCsvRecord(VapiStruct):
    """
    BGP neighbor learned/advertised route details.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'as_path': 'as_path',
                            'local_pref': 'local_pref',
                            'logical_router_id': 'logical_router_id',
                            'med': 'med',
                            'neighbor_address': 'neighbor_address',
                            'neighbor_id': 'neighbor_id',
                            'network': 'network',
                            'next_hop': 'next_hop',
                            'source_address': 'source_address',
                            'transport_node_id': 'transport_node_id',
                            'weight': 'weight',
                            }

    def __init__(self,
                 as_path=None,
                 local_pref=None,
                 logical_router_id=None,
                 med=None,
                 neighbor_address=None,
                 neighbor_id=None,
                 network=None,
                 next_hop=None,
                 source_address=None,
                 transport_node_id=None,
                 weight=None,
                ):
        """
        :type  as_path: :class:`str` or ``None``
        :param as_path: BGP AS path attribute.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  local_pref: :class:`long` or ``None``
        :param local_pref: BGP Local Preference attribute. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  logical_router_id: :class:`str` or ``None``
        :param logical_router_id: Logical router id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  med: :class:`long` or ``None``
        :param med: BGP Multi Exit Discriminator attribute. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  neighbor_address: :class:`str` or ``None``
        :param neighbor_address: BGP neighbor peer IP address. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  neighbor_id: :class:`str` or ``None``
        :param neighbor_id: BGP neighbor id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  network: :class:`str` or ``None``
        :param network: CIDR network address. format: ip-cidr-block
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  next_hop: :class:`str` or ``None``
        :param next_hop: Next hop IP address. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  source_address: :class:`str` or ``None``
        :param source_address: BGP neighbor source address. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  transport_node_id: :class:`str` or ``None``
        :param transport_node_id: Transport node id
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  weight: :class:`long` or ``None``
        :param weight: BGP Weight attribute. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.as_path = as_path
        self.local_pref = local_pref
        self.logical_router_id = logical_router_id
        self.med = med
        self.neighbor_address = neighbor_address
        self.neighbor_id = neighbor_id
        self.network = network
        self.next_hop = next_hop
        self.source_address = source_address
        self.transport_node_id = transport_node_id
        self.weight = weight
        VapiStruct.__init__(self)


BgpNeighborRouteDetailsCsvRecord._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_neighbor_route_details_csv_record', {
        'as_path': type.OptionalType(type.StringType()),
        'local_pref': type.OptionalType(type.IntegerType()),
        'logical_router_id': type.OptionalType(type.StringType()),
        'med': type.OptionalType(type.IntegerType()),
        'neighbor_address': type.OptionalType(type.StringType()),
        'neighbor_id': type.OptionalType(type.StringType()),
        'network': type.OptionalType(type.StringType()),
        'next_hop': type.OptionalType(type.StringType()),
        'source_address': type.OptionalType(type.StringType()),
        'transport_node_id': type.OptionalType(type.StringType()),
        'weight': type.OptionalType(type.IntegerType()),
    },
    BgpNeighborRouteDetailsCsvRecord,
    False,
    None))



class BgpNeighborRouteDetailsInCsvFormat(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'file_name': 'file_name',
                            'results': 'results',
                            }

    def __init__(self,
                 file_name=None,
                 results=None,
                ):
        """
        :type  file_name: :class:`str` or ``None``
        :param file_name: File name set by HTTP server if API returns CSV result as a file.
        :type  results: :class:`list` of :class:`BgpNeighborRouteDetailsCsvRecord` or ``None``
        :param results: 
        """
        self.file_name = file_name
        self.results = results
        VapiStruct.__init__(self)


BgpNeighborRouteDetailsInCsvFormat._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_neighbor_route_details_in_csv_format', {
        'file_name': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BgpNeighborRouteDetailsCsvRecord'))),
    },
    BgpNeighborRouteDetailsInCsvFormat,
    False,
    None))



class BgpNeighborRoutes(VapiStruct):
    """
    BGP neighbor learned/advertised route details.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'edge_node_routes': 'edge_node_routes',
                            'egde_node_routes': 'egde_node_routes',
                            'enforcement_point_path': 'enforcement_point_path',
                            'neighbor_path': 'neighbor_path',
                            }

    def __init__(self,
                 edge_node_routes=None,
                 egde_node_routes=None,
                 enforcement_point_path=None,
                 neighbor_path=None,
                ):
        """
        :type  edge_node_routes: :class:`list` of :class:`RoutesPerTransportNode` or ``None``
        :param edge_node_routes: Array of BGP neighbor route details per edge node.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  egde_node_routes: :class:`list` of :class:`RoutesPerTransportNode` or ``None``
        :param egde_node_routes: Array of BGP neighbor route details per edge node.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.

            .. deprecated:: unknown
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: Enforcement point policy path
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  neighbor_path: :class:`str` or ``None``
        :param neighbor_path: BGP neighbor policy path
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.edge_node_routes = edge_node_routes
        self.egde_node_routes = egde_node_routes
        self.enforcement_point_path = enforcement_point_path
        self.neighbor_path = neighbor_path
        VapiStruct.__init__(self)


BgpNeighborRoutes._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_neighbor_routes', {
        'edge_node_routes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'RoutesPerTransportNode'))),
        'egde_node_routes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'RoutesPerTransportNode'))),
        'enforcement_point_path': type.OptionalType(type.StringType()),
        'neighbor_path': type.OptionalType(type.StringType()),
    },
    BgpNeighborRoutes,
    False,
    None))



class BgpNeighborRoutesListResult(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`BgpNeighborRoutes` or ``None``
        :param results: Paged Collection of Bgp neighbor routes.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


BgpNeighborRoutesListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_neighbor_routes_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'BgpNeighborRoutes'))),
    },
    BgpNeighborRoutesListResult,
    False,
    None))



class BgpRouteFiltering(VapiStruct):
    """
    Enable address_families and route filtering in each direction

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ADDRESS_FAMILY_IPV4 = "IPV4"
    """


    """
    ADDRESS_FAMILY_IPV6 = "IPV6"
    """


    """
    ADDRESS_FAMILY_L2VPN_EVPN = "L2VPN_EVPN"
    """


    """



    _canonical_to_pep_names = {
                            'address_family': 'address_family',
                            'enabled': 'enabled',
                            'in_route_filters': 'in_route_filters',
                            'maximum_routes': 'maximum_routes',
                            'out_route_filters': 'out_route_filters',
                            }

    def __init__(self,
                 address_family=None,
                 enabled=None,
                 in_route_filters=None,
                 maximum_routes=None,
                 out_route_filters=None,
                ):
        """
        :type  address_family: :class:`str` or ``None``
        :param address_family: Possible values are: 
            
            * :attr:`BgpRouteFiltering.ADDRESS_FAMILY_IPV4`
            * :attr:`BgpRouteFiltering.ADDRESS_FAMILY_IPV6`
            * :attr:`BgpRouteFiltering.ADDRESS_FAMILY_L2VPN_EVPN`
            
            Address family type. If not configured, this property automatically
            derived for IPv4 & IPv6 peer configuration.
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Flag to enable address family.
        :type  in_route_filters: :class:`list` of :class:`str` or ``None``
        :param in_route_filters: Specify path of prefix-list or route map to filter routes for IN
            direction.
        :type  maximum_routes: :class:`long` or ``None``
        :param maximum_routes: Maximum number of routes for the address family. format: int32
        :type  out_route_filters: :class:`list` of :class:`str` or ``None``
        :param out_route_filters: Specify path of prefix-list or route map to filter routes for OUT
            direction. When not specified, a built-in prefix-list named
            'prefixlist-out-default' is automatically applied.
        """
        self.address_family = address_family
        self.enabled = enabled
        self.in_route_filters = in_route_filters
        self.maximum_routes = maximum_routes
        self.out_route_filters = out_route_filters
        VapiStruct.__init__(self)


BgpRouteFiltering._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_route_filtering', {
        'address_family': type.OptionalType(type.StringType()),
        'enabled': type.OptionalType(type.BooleanType()),
        'in_route_filters': type.OptionalType(type.ListType(type.StringType())),
        'maximum_routes': type.OptionalType(type.IntegerType()),
        'out_route_filters': type.OptionalType(type.ListType(type.StringType())),
    },
    BgpRouteFiltering,
    False,
    None))



class BgpRouteLeaking(VapiStruct):
    """
    BGP route leaking in each direction

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ADDRESS_FAMILY_IPV4 = "IPV4"
    """


    """
    ADDRESS_FAMILY_IPV6 = "IPV6"
    """


    """



    _canonical_to_pep_names = {
                            'address_family': 'address_family',
                            'in_filter': 'in_filter',
                            'out_filter': 'out_filter',
                            }

    def __init__(self,
                 address_family=None,
                 in_filter=None,
                 out_filter=None,
                ):
        """
        :type  address_family: :class:`str` or ``None``
        :param address_family: Possible values are: 
            
            * :attr:`BgpRouteLeaking.ADDRESS_FAMILY_IPV4`
            * :attr:`BgpRouteLeaking.ADDRESS_FAMILY_IPV6`
            
            Address family type. Assumed IPv4 address family when not
            specified.
        :type  in_filter: :class:`list` of :class:`str` or ``None``
        :param in_filter: Specify path of route map to filter routes for IN direction. If not
            specified then all exported routes from peer attachment will be
            imported.
        :type  out_filter: :class:`list` of :class:`str` or ``None``
        :param out_filter: Specify path of route map to filter routes for OUT direction. If
            not specified then all redistribute routes will be exported.
        """
        self.address_family = address_family
        self.in_filter = in_filter
        self.out_filter = out_filter
        VapiStruct.__init__(self)


BgpRouteLeaking._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_route_leaking', {
        'address_family': type.OptionalType(type.StringType()),
        'in_filter': type.OptionalType(type.ListType(type.StringType())),
        'out_filter': type.OptionalType(type.ListType(type.StringType())),
    },
    BgpRouteLeaking,
    False,
    None))



class BgpRoutingConfig(VapiStruct):
    """
    Contains BGP routing configuration.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'origin_site_id': 'origin_site_id',
                            'owner_id': 'owner_id',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'remote_path': 'remote_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'ebgp_admin_distance': 'ebgp_admin_distance',
                            'ecmp': 'ecmp',
                            'enabled': 'enabled',
                            'graceful_restart': 'graceful_restart',
                            'graceful_restart_config': 'graceful_restart_config',
                            'ibgp_admin_distance': 'ibgp_admin_distance',
                            'inter_sr_ibgp': 'inter_sr_ibgp',
                            'local_as_num': 'local_as_num',
                            'multipath_relax': 'multipath_relax',
                            'route_aggregations': 'route_aggregations',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 origin_site_id=None,
                 owner_id=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 remote_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 ebgp_admin_distance=None,
                 ecmp=None,
                 enabled=None,
                 graceful_restart=None,
                 graceful_restart_config=None,
                 ibgp_admin_distance=None,
                 inter_sr_ibgp=None,
                 local_as_num=None,
                 multipath_relax=None,
                 route_aggregations=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  origin_site_id: :class:`str` or ``None``
        :param origin_site_id: This is a UUID generated by the system for knowing which site owns
            an object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  owner_id: :class:`str` or ``None``
        :param owner_id: This is a UUID generated by the system for knowing who owns this
            object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated their unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_path: :class:`str` or ``None``
        :param remote_path: This is the path of the object on the local managers when queried
            on the NSX+ service, and path of the object on NSX+ service when
            queried from the local managers.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entities
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: Subtree for this type within policy tree containing nested
            elements. Note that this type is applicable to be used in
            Hierarchical API only.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  ebgp_admin_distance: :class:`long` or ``None``
        :param ebgp_admin_distance: Administrative distance for IPv4 and IPv6 eBGP learnt
            routes(inbound). User is allowed to set this value only if BGP is
            disabled. format: int32
        :type  ecmp: :class:`bool` or ``None``
        :param ecmp: Flag to enable ECMP.
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Flag to enable BGP configuration. Disabling will stop feature and
            BGP peering.
        :type  graceful_restart: :class:`bool` or ``None``
        :param graceful_restart: Flag to enable graceful restart. This field is deprecated, please
            use graceful_restart_config parameter for graceful restart
            configuration. If both parameters are set and consistent with each
            other (i.e. graceful_restart=false and
            graceful_restart_mode=HELPER_ONLY OR graceful_restart=true and
            graceful_restart_mode=GR_AND_HELPER) then this is allowed, but if
            inconsistent with each other then this is not allowed and
            validation error will be thrown.

            .. deprecated:: unknown
        :type  graceful_restart_config: :class:`BgpGracefulRestartConfig` or ``None``
        :param graceful_restart_config: 
        :type  ibgp_admin_distance: :class:`long` or ``None``
        :param ibgp_admin_distance: Administrative distance for IPv4 and IPv6 iBGP learnt
            routes(inbound). User is allowed to set this value only if BGP is
            disabled. format: int32
        :type  inter_sr_ibgp: :class:`bool` or ``None``
        :param inter_sr_ibgp: Flag to enable inter SR IBGP configuration. When not specified,
            inter SR IBGP is automatically enabled if Tier-0 is created in
            ACTIVE_ACTIVE ha_mode.
        :type  local_as_num: :class:`str` or ``None``
        :param local_as_num: Specify BGP AS number for Tier-0 to advertize to BGP peers. AS
            number can be specified in ASPLAIN (e.g., \"65546\") or ASDOT
            (e.g., \"1.10\") format. Empty string disables BGP feature. It is
            required by normal tier0 but not required in vrf tier0.
        :type  multipath_relax: :class:`bool` or ``None``
        :param multipath_relax: Flag to enable BGP multipath relax option.
        :type  route_aggregations: :class:`list` of :class:`RouteAggregationEntry` or ``None``
        :param route_aggregations: List of routes to be aggregated.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.origin_site_id = origin_site_id
        self.owner_id = owner_id
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.remote_path = remote_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.ebgp_admin_distance = ebgp_admin_distance
        self.ecmp = ecmp
        self.enabled = enabled
        self.graceful_restart = graceful_restart
        self.graceful_restart_config = graceful_restart_config
        self.ibgp_admin_distance = ibgp_admin_distance
        self.inter_sr_ibgp = inter_sr_ibgp
        self.local_as_num = local_as_num
        self.multipath_relax = multipath_relax
        self.route_aggregations = route_aggregations
        VapiStruct.__init__(self)


BgpRoutingConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bgp_routing_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'origin_site_id': type.OptionalType(type.StringType()),
        'owner_id': type.OptionalType(type.StringType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'remote_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'ebgp_admin_distance': type.OptionalType(type.IntegerType()),
        'ecmp': type.OptionalType(type.BooleanType()),
        'enabled': type.OptionalType(type.BooleanType()),
        'graceful_restart': type.OptionalType(type.BooleanType()),
        'graceful_restart_config': type.OptionalType(type.ReferenceType(__name__, 'BgpGracefulRestartConfig')),
        'ibgp_admin_distance': type.OptionalType(type.IntegerType()),
        'inter_sr_ibgp': type.OptionalType(type.BooleanType()),
        'local_as_num': type.OptionalType(type.StringType()),
        'multipath_relax': type.OptionalType(type.BooleanType()),
        'route_aggregations': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'RouteAggregationEntry'))),
    },
    BgpRoutingConfig,
    False,
    None))



class BinaryPacketData(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "BinaryPacketData"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """



    _canonical_to_pep_names = {
                            'payload': 'payload',
                            'frame_size': 'frame_size',
                            'resource_type': 'resource_type',
                            'routed': 'routed',
                            'transport_type': 'transport_type',
                            }

    def __init__(self,
                 payload=None,
                 frame_size=None,
                 resource_type='BinaryPacketData',
                 routed=None,
                 transport_type=None,
                ):
        """
        :type  payload: :class:`str` or ``None``
        :param payload: Up to 1000 bytes of payload may be supplied (with a base64-encoded
            length of 1336 bytes.) Additional bytes of traceflow metadata will
            be appended to the payload. The payload must contain all headers
            (Ethernet, IP, etc). Note that VLAN is not supported in the logical
            space. Hence, payload must not contain 802.1Q headers.
        :type  frame_size: :class:`long` or ``None``
        :param frame_size: If the requested frame_size is too small (given the payload and
            traceflow metadata requirement of 16 bytes), the traceflow request
            will fail with an appropriate message. The frame will be zero
            padded to the requested size. format: int64
        :type  resource_type: :class:`str`
        :param resource_type: Possible values are: 
            
            * :attr:`PacketData.RESOURCE_TYPE_BINARYPACKETDATA`
            * :attr:`PacketData.RESOURCE_TYPE_FIELDSPACKETDATA`
            
            Packet configuration
        :type  routed: :class:`bool` or ``None``
        :param routed: When this flag is set, traceflow packet will have its destination
            overwritten as the gateway address of the logical router to which
            the source logical switch is connected. More specifically: - For
            ARP request, the target IP will be overwritten as gateway IP if the
            target IP is not in the same subnet of gateway. - For ARP response,
            the target IP and destination MAC will be overwritten as gateway
            IP/MAC respectively, if the target IP is not in the same subnet of
            gateway. - For IP packet, the destination MAC will be overwritten
            as gateway MAC. However, this flag will not be effective when
            injecting the traceflow packet to a VLAN backed port. This is
            because the gateway in this case is a physical gateway that is
            outside the scope of NSX. Therefore, users need to manually
            populate the gateway MAC address. If the user still sets this flag
            in this case, a validation error will be thrown.
        :type  transport_type: :class:`str` or ``None``
        :param transport_type: Possible values are: 
            
            * :attr:`PacketData.TRANSPORT_TYPE_BROADCAST`
            * :attr:`PacketData.TRANSPORT_TYPE_UNICAST`
            * :attr:`PacketData.TRANSPORT_TYPE_MULTICAST`
            * :attr:`PacketData.TRANSPORT_TYPE_UNKNOWN`
            
            This type takes effect only for IP packet.
        """
        self.payload = payload
        self.frame_size = frame_size
        self._resource_type = resource_type
        self.routed = routed
        self.transport_type = transport_type
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

BinaryPacketData._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.binary_packet_data', {
        'payload': type.OptionalType(type.StringType()),
        'frame_size': type.OptionalType(type.IntegerType()),
        'resource_type': type.StringType(),
        'routed': type.OptionalType(type.BooleanType()),
        'transport_type': type.OptionalType(type.StringType()),
    },
    BinaryPacketData,
    False,
    None))



class BondPnicStatus(VapiStruct):
    """
    pNIC/bond statuses

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_UNKNOWN = "UNKNOWN"
    """


    """
    STATUS_UP = "UP"
    """


    """
    STATUS_DOWN = "DOWN"
    """


    """
    STATUS_DEGRADED = "DEGRADED"
    """


    """
    TYPE_UNKNOWN_TYPE = "UNKNOWN_TYPE"
    """


    """
    TYPE_PNIC = "PNIC"
    """


    """
    TYPE_BOND = "BOND"
    """


    """



    _canonical_to_pep_names = {
                            'name': 'name',
                            'status': 'status',
                            'type': 'type',
                            }

    def __init__(self,
                 name=None,
                 status=None,
                 type=None,
                ):
        """
        :type  name: :class:`str` or ``None``
        :param name: Name of the pNIC/bond
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            * :attr:`BondPnicStatus.STATUS_UNKNOWN`
            * :attr:`BondPnicStatus.STATUS_UP`
            * :attr:`BondPnicStatus.STATUS_DOWN`
            * :attr:`BondPnicStatus.STATUS_DEGRADED`
            
            Status of pNIC/bond
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`BondPnicStatus.TYPE_UNKNOWN_TYPE`
            * :attr:`BondPnicStatus.TYPE_PNIC`
            * :attr:`BondPnicStatus.TYPE_BOND`
            
            Type, whether the object is a pNIC or a bond
        """
        self.name = name
        self.status = status
        self.type = type
        VapiStruct.__init__(self)


BondPnicStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bond_pnic_status', {
        'name': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
        'type': type.OptionalType(type.StringType()),
    },
    BondPnicStatus,
    False,
    None))



class BridgeEndpointStatistics(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'rx_bytes': 'rx_bytes',
                            'rx_packets': 'rx_packets',
                            'tx_bytes': 'tx_bytes',
                            'tx_packets': 'tx_packets',
                            'endpoint_id': 'endpoint_id',
                            'last_update_timestamp': 'last_update_timestamp',
                            }

    def __init__(self,
                 rx_bytes=None,
                 rx_packets=None,
                 tx_bytes=None,
                 tx_packets=None,
                 endpoint_id=None,
                 last_update_timestamp=None,
                ):
        """
        :type  rx_bytes: :class:`DataCounter` or ``None``
        :param rx_bytes: 
        :type  rx_packets: :class:`DataCounter` or ``None``
        :param rx_packets: 
        :type  tx_bytes: :class:`DataCounter` or ``None``
        :param tx_bytes: 
        :type  tx_packets: :class:`DataCounter` or ``None``
        :param tx_packets: 
        :type  endpoint_id: :class:`str` or ``None``
        :param endpoint_id: The id of the bridge endpoint
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_update_timestamp: :class:`long` or ``None``
        :param last_update_timestamp: Timestamp when the data was last updated; unset if data source has
            never updated the data. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.rx_bytes = rx_bytes
        self.rx_packets = rx_packets
        self.tx_bytes = tx_bytes
        self.tx_packets = tx_packets
        self.endpoint_id = endpoint_id
        self.last_update_timestamp = last_update_timestamp
        VapiStruct.__init__(self)


BridgeEndpointStatistics._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bridge_endpoint_statistics', {
        'rx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'rx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_bytes': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'tx_packets': type.OptionalType(type.ReferenceType(__name__, 'DataCounter')),
        'endpoint_id': type.OptionalType(type.StringType()),
        'last_update_timestamp': type.OptionalType(type.IntegerType()),
    },
    BridgeEndpointStatistics,
    False,
    None))



class BridgeEndpointStatus(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'active_nodes': 'active_nodes',
                            'endpoint_id': 'endpoint_id',
                            'last_update_timestamp': 'last_update_timestamp',
                            }

    def __init__(self,
                 active_nodes=None,
                 endpoint_id=None,
                 last_update_timestamp=None,
                ):
        """
        :type  active_nodes: :class:`list` of :class:`str` or ``None``
        :param active_nodes: The Ids of the transport nodes which actively serve the endpoint.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  endpoint_id: :class:`str` or ``None``
        :param endpoint_id: The id of the bridge endpoint
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_update_timestamp: :class:`long` or ``None``
        :param last_update_timestamp: Timestamp when the data was last updated; unset if data source has
            never updated the data. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.active_nodes = active_nodes
        self.endpoint_id = endpoint_id
        self.last_update_timestamp = last_update_timestamp
        VapiStruct.__init__(self)


BridgeEndpointStatus._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bridge_endpoint_status', {
        'active_nodes': type.OptionalType(type.ListType(type.StringType())),
        'endpoint_id': type.OptionalType(type.StringType()),
        'last_update_timestamp': type.OptionalType(type.IntegerType()),
    },
    BridgeEndpointStatus,
    False,
    None))



class BridgeProfileConfig(VapiStruct):
    """
    configuration parameters for Bridge Profile

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'bridge_profile_path': 'bridge_profile_path',
                            'uplink_teaming_policy_name': 'uplink_teaming_policy_name',
                            'vlan_ids': 'vlan_ids',
                            'vlan_transport_zone_path': 'vlan_transport_zone_path',
                            }

    def __init__(self,
                 bridge_profile_path=None,
                 uplink_teaming_policy_name=None,
                 vlan_ids=None,
                 vlan_transport_zone_path=None,
                ):
        """
        :type  bridge_profile_path: :class:`str` or ``None``
        :param bridge_profile_path: Same bridge profile can be configured on different segments. Each
            bridge profile on a segment must unique.
        :type  uplink_teaming_policy_name: :class:`str` or ``None``
        :param uplink_teaming_policy_name: The name of the switching uplink teaming policy for the bridge
            endpoint. This name corresponds to one fot he switching uplink
            teaming policy names listed in teh transport zone. When this
            property is not specified, the teaming policy is assigned by MP.
        :type  vlan_ids: :class:`list` of :class:`str` or ``None``
        :param vlan_ids: VLAN specification for bridge endpoint. Either VLAN ID or VLAN
            ranges can be specified. Not both.
        :type  vlan_transport_zone_path: :class:`str` or ``None``
        :param vlan_transport_zone_path: VLAN transport zone should belong to the enforcment-point as the
            transport zone specified in the segment.
        """
        self.bridge_profile_path = bridge_profile_path
        self.uplink_teaming_policy_name = uplink_teaming_policy_name
        self.vlan_ids = vlan_ids
        self.vlan_transport_zone_path = vlan_transport_zone_path
        VapiStruct.__init__(self)


BridgeProfileConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.bridge_profile_config', {
        'bridge_profile_path': type.OptionalType(type.StringType()),
        'uplink_teaming_policy_name': type.OptionalType(type.StringType()),
        'vlan_ids': type.OptionalType(type.ListType(type.StringType())),
        'vlan_transport_zone_path': type.OptionalType(type.StringType()),
    },
    BridgeProfileConfig,
    False,
    None))



class ByodPolicyServiceInstance(VapiStruct):
    """
    Represents an instance of partner's service whose wiring will be done by
    partner itself. As partner does all the wiring, we call it as Byod - Bring
    your own device.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    DEPLOYMENT_MODE_STAND_ALONE = "STAND_ALONE"
    """


    """
    DEPLOYMENT_MODE_ACTIVE_STANDBY = "ACTIVE_STANDBY"
    """


    """
    TRANSPORT_TYPE_L2_BRIDGE = "L2_BRIDGE"
    """


    """
    TRANSPORT_TYPE_L3_ROUTED = "L3_ROUTED"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'origin_site_id': 'origin_site_id',
                            'owner_id': 'owner_id',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'remote_path': 'remote_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'deployment_mode': 'deployment_mode',
                            'partner_service_name': 'partner_service_name',
                            'transport_type': 'transport_type',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 origin_site_id=None,
                 owner_id=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 remote_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 deployment_mode=None,
                 partner_service_name=None,
                 transport_type=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  origin_site_id: :class:`str` or ``None``
        :param origin_site_id: This is a UUID generated by the system for knowing which site owns
            an object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  owner_id: :class:`str` or ``None``
        :param owner_id: This is a UUID generated by the system for knowing who owns this
            object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated their unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_path: :class:`str` or ``None``
        :param remote_path: This is the path of the object on the local managers when queried
            on the NSX+ service, and path of the object on NSX+ service when
            queried from the local managers.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entities
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: Subtree for this type within policy tree containing nested
            elements. Note that this type is applicable to be used in
            Hierarchical API only.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  deployment_mode: :class:`str` or ``None``
        :param deployment_mode: Possible values are: 
            
            * :attr:`ByodPolicyServiceInstance.DEPLOYMENT_MODE_STAND_ALONE`
            * :attr:`ByodPolicyServiceInstance.DEPLOYMENT_MODE_ACTIVE_STANDBY`
            
            Deployment mode specifies how the partner appliance will be
            deployed i.e. in HA or standalone mode.
        :type  partner_service_name: :class:`str` or ``None``
        :param partner_service_name: Unique name of Partner Service in the Marketplace
        :type  transport_type: :class:`str` or ``None``
        :param transport_type: Possible values are: 
            
            * :attr:`ByodPolicyServiceInstance.TRANSPORT_TYPE_L2_BRIDGE`
            * :attr:`ByodPolicyServiceInstance.TRANSPORT_TYPE_L3_ROUTED`
            
            Transport to be used while deploying Service-VM.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.origin_site_id = origin_site_id
        self.owner_id = owner_id
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.remote_path = remote_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.deployment_mode = deployment_mode
        self.partner_service_name = partner_service_name
        self.transport_type = transport_type
        VapiStruct.__init__(self)


ByodPolicyServiceInstance._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.byod_policy_service_instance', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'origin_site_id': type.OptionalType(type.StringType()),
        'owner_id': type.OptionalType(type.StringType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'remote_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'deployment_mode': type.OptionalType(type.StringType()),
        'partner_service_name': type.OptionalType(type.StringType()),
        'transport_type': type.OptionalType(type.StringType()),
    },
    ByodPolicyServiceInstance,
    False,
    None))



class ByodPolicyServiceInstanceListResult(VapiStruct):
    """
    Collection of only Byod SI objects

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ByodPolicyServiceInstance` or ``None``
        :param results: Byod Service instance list results
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ByodPolicyServiceInstanceListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.byod_policy_service_instance_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ByodPolicyServiceInstance'))),
    },
    ByodPolicyServiceInstanceListResult,
    False,
    None))



class CaBundle(VapiStruct):
    """
    CA certificates bundle

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'origin_site_id': 'origin_site_id',
                            'owner_id': 'owner_id',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'remote_path': 'remote_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'certificates': 'certificates',
                            'earliest_not_after': 'earliest_not_after',
                            'not_after_list': 'not_after_list',
                            'pem_encoded': 'pem_encoded',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 origin_site_id=None,
                 owner_id=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 remote_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 certificates=None,
                 earliest_not_after=None,
                 not_after_list=None,
                 pem_encoded=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  origin_site_id: :class:`str` or ``None``
        :param origin_site_id: This is a UUID generated by the system for knowing which site owns
            an object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  owner_id: :class:`str` or ``None``
        :param owner_id: This is a UUID generated by the system for knowing who owns this
            object. This is used in NSX+.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated their unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  remote_path: :class:`str` or ``None``
        :param remote_path: This is the path of the object on the local managers when queried
            on the NSX+ service, and path of the object on NSX+ service when
            queried from the local managers.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entities
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: Subtree for this type within policy tree containing nested
            elements. Note that this type is applicable to be used in
            Hierarchical API only.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  certificates: :class:`list` of :class:`X509Certificate` or ``None``
        :param certificates: X509Certificates in the bundle
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  earliest_not_after: :class:`long` or ``None``
        :param earliest_not_after: The earliest time in epoch milliseconds at which a certificate
            becomes invalid. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  not_after_list: :class:`list` of :class:`long` or ``None``
        :param not_after_list: Times for each certificate in the bundle at which the certificate
            becomes invalid. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  pem_encoded: :class:`str` or ``None``
        :param pem_encoded: PEM-encoded CA bundle certificates.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.origin_site_id = origin_site_id
        self.owner_id = owner_id
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.remote_path = remote_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.certificates = certificates
        self.earliest_not_after = earliest_not_after
        self.not_after_list = not_after_list
        self.pem_encoded = pem_encoded
        VapiStruct.__init__(self)


CaBundle._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ca_bundle', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'origin_site_id': type.OptionalType(type.StringType()),
        'owner_id': type.OptionalType(type.StringType()),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'remote_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'certificates': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'X509Certificate'))),
        'earliest_not_after': type.OptionalType(type.IntegerType()),
        'not_after_list': type.OptionalType(type.ListType(type.IntegerType())),
        'pem_encoded': type.OptionalType(type.StringType()),
    },
    CaBundle,
    False,
    None))



class CaBundleListResult(VapiStruct):
    """
    CA Bundle query result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`CaBundle` or ``None``
        :param results: CA bundles list.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


CaBundleListResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ca_bundle_list_result', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CaBundle'))),
    },
    CaBundleListResult,
    False,
    None))



class CapacityDashboardUsage(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    SEVERITY_INFO = "INFO"
    """


    """
    SEVERITY_WARNING = "WARNING"
    """


    """
    SEVERITY_CRITICAL = "CRITICAL"
    """


    """
    SEVERITY_ERROR = "ERROR"
    """


    """



    _canonical_to_pep_names = {
                            'current_usage_count': 'current_usage_count',
                            'current_usage_percentage': 'current_usage_percentage',
                            'display_name': 'display_name',
                            'max_supported_count': 'max_supported_count',
                            'max_threshold_percentage': 'max_threshold_percentage',
                            'min_threshold_percentage': 'min_threshold_percentage',
                            'severity': 'severity',
                            'usage_type': 'usage_type',
                            }

    def __init__(self,
                 current_usage_count=None,
                 current_usage_percentage=None,
                 display_name=None,
                 max_supported_count=None,
                 max_threshold_percentage=None,
                 min_threshold_percentage=None,
                 severity=None,
                 usage_type=None,
                ):
        """
        :type  current_usage_count: :class:`long` or ``None``
        :param current_usage_count: Indicate the current usage count of object type. format: int64
        :type  current_usage_percentage: :class:`float` or ``None``
        :param current_usage_percentage: Current usage percentage for object type
        :type  display_name: :class:`str` or ``None``
        :param display_name: Display name for NSX object type.
        :type  max_supported_count: :class:`long` or ``None``
        :param max_supported_count: This is the maximum supported count for object type in
            consideration. format: int64
        :type  max_threshold_percentage: :class:`float` or ``None``
        :param max_threshold_percentage: This indicates the maximum threshold percentage for object type.
        :type  min_threshold_percentage: :class:`float` or ``None``
        :param min_threshold_percentage: This indicates the minimum threshold percentage for object type.
        :type  severity: :class:`str` or ``None``
        :param severity: Possible values are: 
            
            * :attr:`CapacityDashboardUsage.SEVERITY_INFO`
            * :attr:`CapacityDashboardUsage.SEVERITY_WARNING`
            * :attr:`CapacityDashboardUsage.SEVERITY_CRITICAL`
            * :attr:`CapacityDashboardUsage.SEVERITY_ERROR`
            
            Severity calculated from percentage usage
        :type  usage_type: :class:`str` or ``None``
        :param usage_type: Indicate the object type for which usage is calculated.
        """
        self.current_usage_count = current_usage_count
        self.current_usage_percentage = current_usage_percentage
        self.display_name = display_name
        self.max_supported_count = max_supported_count
        self.max_threshold_percentage = max_threshold_percentage
        self.min_threshold_percentage = min_threshold_percentage
        self.severity = severity
        self.usage_type = usage_type
        VapiStruct.__init__(self)


CapacityDashboardUsage._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.capacity_dashboard_usage', {
        'current_usage_count': type.OptionalType(type.IntegerType()),
        'current_usage_percentage': type.OptionalType(type.DoubleType()),
        'display_name': type.OptionalType(type.StringType()),
        'max_supported_count': type.OptionalType(type.IntegerType()),
        'max_threshold_percentage': type.OptionalType(type.DoubleType()),
        'min_threshold_percentage': type.OptionalType(type.DoubleType()),
        'severity': type.OptionalType(type.StringType()),
        'usage_type': type.OptionalType(type.StringType()),
    },
    CapacityDashboardUsage,
    False,
    None))



class CapacityThreshold(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'max_threshold_percentage': 'max_threshold_percentage',
                            'min_threshold_percentage': 'min_threshold_percentage',
                            'threshold_type': 'threshold_type',
                            }

    def __init__(self,
                 max_threshold_percentage=None,
                 min_threshold_percentage=None,
                 threshold_type=None,
                ):
        """
        :type  max_threshold_percentage: :class:`float` or ``None``
        :param max_threshold_percentage: Set the maximum threshold percentage. Specify a value between 0 and
            100. Usage percentage above this value is tagged as critical.
        :type  min_threshold_percentage: :class:`float` or ``None``
        :param min_threshold_percentage: Set the minimum threshold percentage. Specify a value between 0 and
            100. Usage percentage above this value is tagged as warning.
        :type  threshold_type: :class:`str` or ``None``
        :param threshold_type: Indicate the object type for which threshold is to be set.
        """
        self.max_threshold_percentage = max_threshold_percentage
        self.min_threshold_percentage = min_threshold_percentage
        self.threshold_type = threshold_type
        VapiStruct.__init__(self)


CapacityThreshold._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.capacity_threshold', {
        'max_threshold_percentage': type.OptionalType(type.DoubleType()),
        'min_threshold_percentage': type.OptionalType(type.DoubleType()),
        'threshold_type': type.OptionalType(type.StringType()),
    },
    CapacityThreshold,
    False,
    None))



class CapacityThresholdList(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'capacity_thresholds': 'capacity_thresholds',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 capacity_thresholds=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  capacity_thresholds: :class:`list` of :class:`CapacityThreshold` or ``None``
        :param capacity_thresholds: List of capacity thresholds for NSX Objects
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.capacity_thresholds = capacity_thresholds
        VapiStruct.__init__(self)


CapacityThresholdList._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.capacity_threshold_list', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'capacity_thresholds': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CapacityThreshold'))),
    },
    CapacityThresholdList,
    False,
    None))



class CapacityUsageMetaInfo(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'last_updated_timestamp': 'last_updated_timestamp',
                            'max_global_threshold_percentage': 'max_global_threshold_percentage',
                            'min_global_threshold_percentage': 'min_global_threshold_percentage',
                            }

    def __init__(self,
                 last_updated_timestamp=None,
                 max_global_threshold_percentage=None,
                 min_global_threshold_percentage=None,
                ):
        """
        :type  last_updated_timestamp: :class:`long` or ``None``
        :param last_updated_timestamp: Timestamp at which capacity usage was last calculated format: int64
        :type  max_global_threshold_percentage: :class:`float` or ``None``
        :param max_global_threshold_percentage: Indicates the maximum global threshold percentage
        :type  min_global_threshold_percentage: :class:`float` or ``None``
        :param min_global_threshold_percentage: Indicates the minimum global threshold percentage
        """
        self.last_updated_timestamp = last_updated_timestamp
        self.max_global_threshold_percentage = max_global_threshold_percentage
        self.min_global_threshold_percentage = min_global_threshold_percentage
        VapiStruct.__init__(self)


CapacityUsageMetaInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.capacity_usage_meta_info', {
        'last_updated_timestamp': type.OptionalType(type.IntegerType()),
        'max_global_threshold_percentage': type.OptionalType(type.DoubleType()),
        'min_global_threshold_percentage': type.OptionalType(type.DoubleType()),
    },
    CapacityUsageMetaInfo,
    False,
    None))



class CapacityUsageResponse(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'capacity_usage': 'capacity_usage',
                            'meta_info': 'meta_info',
                            'unreported_usage_types': 'unreported_usage_types',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 capacity_usage=None,
                 meta_info=None,
                 unreported_usage_types=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  capacity_usage: :class:`list` of :class:`CapacityDashboardUsage` or ``None``
        :param capacity_usage: List of capacity usage for NSX Objects
        :type  meta_info: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param meta_info: Meta data for capacity usage statistics
        :type  unreported_usage_types: :class:`list` of :class:`str` or ``None``
        :param unreported_usage_types: Types for which usage data was not reported
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.capacity_usage = capacity_usage
        self.meta_info = meta_info
        self.unreported_usage_types = unreported_usage_types
        VapiStruct.__init__(self)


CapacityUsageResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.capacity_usage_response', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'capacity_usage': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CapacityDashboardUsage'))),
        'meta_info': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
        'unreported_usage_types': type.OptionalType(type.ListType(type.StringType())),
    },
    CapacityUsageResponse,
    False,
    None))



class CheckpointCounter(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CHECKPOINT_TYPE_UNKNOWN = "UNKNOWN"
    """


    """
    CHECKPOINT_TYPE_PORT_INPUT = "PORT_INPUT"
    """


    """
    CHECKPOINT_TYPE_PORT_OUTPUT = "PORT_OUTPUT"
    """


    """
    CHECKPOINT_TYPE_SPOOFGUARD_INPUT = "SPOOFGUARD_INPUT"
    """


    """
    CHECKPOINT_TYPE_SPOOFGUARD_OUTPUT = "SPOOFGUARD_OUTPUT"
    """


    """
    CHECKPOINT_TYPE_SPOOFGUARD_DROP = "SPOOFGUARD_DROP"
    """


    """
    CHECKPOINT_TYPE_DFW_INPUT = "DFW_INPUT"
    """


    """
    CHECKPOINT_TYPE_DFW_OUTPUT = "DFW_OUTPUT"
    """


    """
    CHECKPOINT_TYPE_DFW_DROP = "DFW_DROP"
    """


    """
    CHECKPOINT_TYPE_UPLINK_INPUT = "UPLINK_INPUT"
    """


    """
    CHECKPOINT_TYPE_UPLINK_OUTPUT = "UPLINK_OUTPUT"
    """


    """
    CHECKPOINT_TYPE_ENS_PORT_INPUT = "ENS_PORT_INPUT"
    """


    """
    CHECKPOINT_TYPE_ENS_PORT_OUTPUT = "ENS_PORT_OUTPUT"
    """


    """
    CHECKPOINT_TYPE_ENS_UPLINK_INPUT = "ENS_UPLINK_INPUT"
    """


    """
    CHECKPOINT_TYPE_ENS_UPLINK_OUTPUT = "ENS_UPLINK_OUTPUT"
    """


    """
    CHECKPOINT_TYPE_ENS_DFW_INPUT = "ENS_DFW_INPUT"
    """


    """
    CHECKPOINT_TYPE_ENS_DFW_OUTPUT = "ENS_DFW_OUTPUT"
    """


    """
    CHECKPOINT_TYPE_ENS_DFW_DROP = "ENS_DFW_DROP"
    """


    """
    CHECKPOINT_TYPE_ROUTER_DROP = "ROUTER_DROP"
    """


    """



    _canonical_to_pep_names = {
                            'checkpoint_type': 'checkpoint_type',
                            'count': 'count',
                            }

    def __init__(self,
                 checkpoint_type=None,
                 count=None,
                ):
        """
        :type  checkpoint_type: :class:`str` or ``None``
        :param checkpoint_type: Possible values are: 
            
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_UNKNOWN`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_PORT_INPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_PORT_OUTPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_SPOOFGUARD_INPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_SPOOFGUARD_OUTPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_SPOOFGUARD_DROP`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_DFW_INPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_DFW_OUTPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_DFW_DROP`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_UPLINK_INPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_UPLINK_OUTPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_ENS_PORT_INPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_ENS_PORT_OUTPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_ENS_UPLINK_INPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_ENS_UPLINK_OUTPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_ENS_DFW_INPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_ENS_DFW_OUTPUT`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_ENS_DFW_DROP`
            * :attr:`CheckpointCounter.CHECKPOINT_TYPE_ROUTER_DROP`
            
            Type of Livetrace checkpoint. UNKNOWN - Unknown checkpoint.
            PORT_INPUT - Received by a port on slowpath. The first slowpath
            checkpoint is encountered when the packet enters a certain port.
            For a certain port, a series of subsequent checkpoints is usually
            encountered after the packet traverses through PORT_INPUT.
            PORT_OUTPUT - Forwarded to a port on slowpath. The last slowpath
            checkpoint is encountered when the packet left a certain port. For
            a certain port, a series of checkpoints is usually encountered
            before the packet traverses through PORT_OUTPUT. SPOOFGUARD_INPUT -
            Received by slowpath Spoofguard service. This checkpoint should be
            encountered either after the packet encounters PORT_INPUT or before
            the packet encounters PORT_OUTPUT. SPOOFGUARD_OUTPUT - Forwarded
            from slowpath Spoofguard service. This checkpoint should be
            encountered after SPOOFGUARD_INPUT. SPOOFUGARD_DROP - Dropped by
            slowpath Spoofguard service. This checkpoint should be encountered
            after SPOOFGUARD_INPUT. DFW_INPUT - Received by slowpath DFW
            service. This checkpoint should be encountered encountered either
            after the packet encounters PORT_INPUT or before the packet
            encounters PORT_OUTPUT. This checkpoint should after SPOOFGUARD
            related checkpoints, if they exist. DFW_OUTPUT - Forwarded from
            slowpath DFW service. This checkpoint should be encountered after
            DFW_INPUT. DFW_DROP - Dropped by slowpath DFW service.This
            checkpoint should be encountered after DFW_INPUT. UPLINK_INPUT -
            Ingressed via an uplink port on slowpath. The first slowpath
            checkpoint is encountered when the packet ingress from external
            network via an uplink. UPLINK_OUTPUT - Egressed via an uplink port
            on slowpath. The last slowpath checkpoint is encountered when the
            packet egress to external network via an uplink. ENS_PORT_INPUT -
            Received by a port on ENS fastpath. The first ENS fastpath
            checkpoint is encountered when the packet enters a certain port.
            ENS_PORT_OUTPUT - Forwarded to a port on ENS fastpath. The last ENS
            fastpath checkpoint is encountered when the packet left a certain
            port. ENS_UPLINK_INPUT - Ingressed via an uplink port on ENS
            fastpath. The first ENS fastpath checkpoint is encountered when the
            packet ingress from external network via an uplink.
            ENS_UPLINK_OUTPUT - Egressed via an uplink port on ENS fastpath.
            The last ENS fastpath checkpoint is encountered when the packet
            egress to external network via an uplink. ENS_DFW_INPUT - Received
            by ENS fastpath DFW service. This checkpoint should be encountered
            after ENS_PORT_INPUT. ENS_DFW_OUTPUT - Forwarded from ENS fastpath
            DFW service. This checkpoint should be encountered after
            ENS_DFW_INPUT. ENS_DFW_DROP - Dropped by ENS fastpath DFW service.
            This checkpoint should be encountered after ENS_DFW_INPUT.
            ROUTER_DROP - Dropped by slowpath router service. This checkpoint
            should be encountered after PORT_INPUT.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  count: :class:`long` or ``None``
        :param count: The number of packets traversed by this checkpoint. The packet
            connectivity issue can be discovered by comparing the count value
            of different checkpoints. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.checkpoint_type = checkpoint_type
        self.count = count
        VapiStruct.__init__(self)


CheckpointCounter._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.checkpoint_counter', {
        'checkpoint_type': type.OptionalType(type.StringType()),
        'count': type.OptionalType(type.IntegerType()),
    },
    CheckpointCounter,
    False,
    None))



class CheckpointCounterResult(VapiStruct):
    """
    The packets that only have the count action (other permutations such as
    trace + pktcap or count + trace/pktcap cannot) can traverse through the ENS
    fastpath. Therefore, two checkpoint results from ENS fastpath and slowpath
    are listed below.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ens_checkpoints_result': 'ens_checkpoints_result',
                            'non_ens_checkpoints_result': 'non_ens_checkpoints_result',
                            }

    def __init__(self,
                 ens_checkpoints_result=None,
                 non_ens_checkpoints_result=None,
                ):
        """
        :type  ens_checkpoints_result: :class:`list` of :class:`CheckpointCounter` or ``None``
        :param ens_checkpoints_result: The counter result from ENS checkpoints
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  non_ens_checkpoints_result: :class:`list` of :class:`CheckpointCounter` or ``None``
        :param non_ens_checkpoints_result: The counter result from non ENS checkpoints
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.ens_checkpoints_result = ens_checkpoints_result
        self.non_ens_checkpoints_result = non_ens_checkpoints_result
        VapiStruct.__init__(self)


CheckpointCounterResult._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.checkpoint_counter_result', {
        'ens_checkpoints_result': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CheckpointCounter'))),
        'non_ens_checkpoints_result': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'CheckpointCounter'))),
    },
    CheckpointCounterResult,
    False,
    None))



class ChildAntreaTraceflowConfig(VapiStruct):
    """
    Child wrapper for AntreaTraceflowConfig, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'TraceflowConfig': 'traceflow_config',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 traceflow_config=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  traceflow_config: :class:`AntreaTraceflowConfig` or ``None``
        :param traceflow_config: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.traceflow_config = traceflow_config
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildAntreaTraceflowConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_antrea_traceflow_config', {
        'TraceflowConfig': type.OptionalType(type.ReferenceType(__name__, 'AntreaTraceflowConfig')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildAntreaTraceflowConfig,
    False,
    None))



class ChildBfdProfile(VapiStruct):
    """
    Child wrapper for BfdProfile, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'BfdProfile': 'bfd_profile',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 bfd_profile=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  bfd_profile: :class:`BfdProfile` or ``None``
        :param bfd_profile: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.bfd_profile = bfd_profile
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildBfdProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_bfd_profile', {
        'BfdProfile': type.OptionalType(type.ReferenceType(__name__, 'BfdProfile')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildBfdProfile,
    False,
    None))



class ChildBgpNeighborConfig(VapiStruct):
    """
    Child wrapper object for BgpNeighborConfig, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'BgpNeighborConfig': 'bgp_neighbor_config',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 bgp_neighbor_config=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  bgp_neighbor_config: :class:`BgpNeighborConfig` or ``None``
        :param bgp_neighbor_config: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.bgp_neighbor_config = bgp_neighbor_config
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildBgpNeighborConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_bgp_neighbor_config', {
        'BgpNeighborConfig': type.OptionalType(type.ReferenceType(__name__, 'BgpNeighborConfig')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildBgpNeighborConfig,
    False,
    None))



class ChildBgpRoutingConfig(VapiStruct):
    """
    Child wrapper object for BgpRoutingConfig, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'BgpRoutingConfig': 'bgp_routing_config',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 bgp_routing_config=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  bgp_routing_config: :class:`BgpRoutingConfig` or ``None``
        :param bgp_routing_config: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.bgp_routing_config = bgp_routing_config
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildBgpRoutingConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_bgp_routing_config', {
        'BgpRoutingConfig': type.OptionalType(type.ReferenceType(__name__, 'BgpRoutingConfig')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildBgpRoutingConfig,
    False,
    None))



class ChildByodPolicyServiceInstance(VapiStruct):
    """
    Child wrapper object for ByodPolicyServiceInstance used in hierarchical
    API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ByodPolicyServiceInstance': 'byod_policy_service_instance',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 byod_policy_service_instance=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  byod_policy_service_instance: :class:`ByodPolicyServiceInstance` or ``None``
        :param byod_policy_service_instance: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.byod_policy_service_instance = byod_policy_service_instance
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildByodPolicyServiceInstance._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_byod_policy_service_instance', {
        'ByodPolicyServiceInstance': type.OptionalType(type.ReferenceType(__name__, 'ByodPolicyServiceInstance')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildByodPolicyServiceInstance,
    False,
    None))



class ChildCaBundle(VapiStruct):
    """
    Child wrapper for CA certificates bundle, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'CaBundle': 'ca_bundle',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 ca_bundle=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  ca_bundle: :class:`CaBundle` or ``None``
        :param ca_bundle: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.ca_bundle = ca_bundle
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildCaBundle._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_ca_bundle', {
        'CaBundle': type.OptionalType(type.ReferenceType(__name__, 'CaBundle')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildCaBundle,
    False,
    None))



class ChildCommunicationEntry(VapiStruct):
    """
    Child wrapper object for CommunicationEntry, used in hierarchical API This
    type is deprecated. Use the type ChildRule instead.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'CommunicationEntry': 'communication_entry',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 communication_entry=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  communication_entry: :class:`CommunicationEntry` or ``None``
        :param communication_entry: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.communication_entry = communication_entry
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildCommunicationEntry._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_communication_entry', {
        'CommunicationEntry': type.OptionalType(type.ReferenceType(__name__, 'CommunicationEntry')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildCommunicationEntry,
    False,
    None))



class ChildCommunicationMap(VapiStruct):
    """
    Child wrapper object for CommunicationMap, used in hierarchical API This
    type is deprecated. Use the type ChildSecurityPolicy instead.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'CommunicationMap': 'communication_map',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 communication_map=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  communication_map: :class:`CommunicationMap` or ``None``
        :param communication_map: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.communication_map = communication_map
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildCommunicationMap._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_communication_map', {
        'CommunicationMap': type.OptionalType(type.ReferenceType(__name__, 'CommunicationMap')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildCommunicationMap,
    False,
    None))



class ChildCommunityList(VapiStruct):
    """
    Child wrapper object for CommunityList, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'CommunityList': 'community_list',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 community_list=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  community_list: :class:`CommunityList` or ``None``
        :param community_list: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.community_list = community_list
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildCommunityList._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_community_list', {
        'CommunityList': type.OptionalType(type.ReferenceType(__name__, 'CommunityList')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildCommunityList,
    False,
    None))



class ChildComputeClusterIdfwConfiguration(VapiStruct):
    """
    Wrapper object for ComputeClusterIdfwConfiguration

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ComputeClusterIdfwConfiguration': 'compute_cluster_idfw_configuration',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 compute_cluster_idfw_configuration=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  compute_cluster_idfw_configuration: :class:`ComputeClusterIdfwConfiguration` or ``None``
        :param compute_cluster_idfw_configuration: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.compute_cluster_idfw_configuration = compute_cluster_idfw_configuration
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildComputeClusterIdfwConfiguration._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_compute_cluster_idfw_configuration', {
        'ComputeClusterIdfwConfiguration': type.OptionalType(type.ReferenceType(__name__, 'ComputeClusterIdfwConfiguration')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildComputeClusterIdfwConfiguration,
    False,
    None))



class ChildConstraint(VapiStruct):
    """
    Child wrapper object for Constraint, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'Constraint': 'constraint',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 constraint=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  constraint: :class:`Constraint` or ``None``
        :param constraint: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.constraint = constraint
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildConstraint._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_constraint', {
        'Constraint': type.OptionalType(type.ReferenceType(__name__, 'Constraint')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildConstraint,
    False,
    None))



class ChildConstraintGlobalConfig(VapiStruct):
    """
    Child wrapper object for ConstraintGlobalConfig, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'GlobalConfig': 'global_config',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 global_config=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  global_config: :class:`ConstraintGlobalConfig` or ``None``
        :param global_config: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.global_config = global_config
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildConstraintGlobalConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_constraint_global_config', {
        'GlobalConfig': type.OptionalType(type.ReferenceType(__name__, 'ConstraintGlobalConfig')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildConstraintGlobalConfig,
    False,
    None))



class ChildDeploymentZone(VapiStruct):
    """
    Child wrapper object for DeploymentZone, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'DeploymentZone': 'deployment_zone',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 deployment_zone=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  deployment_zone: :class:`DeploymentZone` or ``None``
        :param deployment_zone: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.deployment_zone = deployment_zone
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildDeploymentZone._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_deployment_zone', {
        'DeploymentZone': type.OptionalType(type.ReferenceType(__name__, 'DeploymentZone')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildDeploymentZone,
    False,
    None))



class ChildDfwFirewallConfiguration(VapiStruct):
    """
    Wrapper object for FirewallConfiguration

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'DfwFirewallConfiguration': 'dfw_firewall_configuration',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 dfw_firewall_configuration=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  dfw_firewall_configuration: :class:`DfwFirewallConfiguration` or ``None``
        :param dfw_firewall_configuration: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.dfw_firewall_configuration = dfw_firewall_configuration
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildDfwFirewallConfiguration._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_dfw_firewall_configuration', {
        'DfwFirewallConfiguration': type.OptionalType(type.ReferenceType(__name__, 'DfwFirewallConfiguration')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildDfwFirewallConfiguration,
    False,
    None))



class ChildDhcpRelayConfig(VapiStruct):
    """
    Child wrapper object for DhcpRelayConfig, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'DhcpRelayConfig': 'dhcp_relay_config',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 dhcp_relay_config=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  dhcp_relay_config: :class:`DhcpRelayConfig` or ``None``
        :param dhcp_relay_config: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.dhcp_relay_config = dhcp_relay_config
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildDhcpRelayConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_dhcp_relay_config', {
        'DhcpRelayConfig': type.OptionalType(type.ReferenceType(__name__, 'DhcpRelayConfig')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildDhcpRelayConfig,
    False,
    None))



class ChildDhcpServerConfig(VapiStruct):
    """
    Child wrapper object for DhcpServerConfig, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'DhcpServerConfig': 'dhcp_server_config',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 dhcp_server_config=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  dhcp_server_config: :class:`DhcpServerConfig` or ``None``
        :param dhcp_server_config: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.dhcp_server_config = dhcp_server_config
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildDhcpServerConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_dhcp_server_config', {
        'DhcpServerConfig': type.OptionalType(type.ReferenceType(__name__, 'DhcpServerConfig')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildDhcpServerConfig,
    False,
    None))



class ChildDhcpStaticBindingConfig(VapiStruct):
    """
    Child wrapper for DhcpStaticBindingConfig, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'DhcpStaticBindingConfig': 'dhcp_static_binding_config',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 dhcp_static_binding_config=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  dhcp_static_binding_config: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param dhcp_static_binding_config: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`DhcpStaticBindingConfig`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`DhcpStaticBindingConfig`.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.dhcp_static_binding_config = dhcp_static_binding_config
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildDhcpStaticBindingConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_dhcp_static_binding_config', {
        'DhcpStaticBindingConfig': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'DhcpStaticBindingConfig')])),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildDhcpStaticBindingConfig,
    False,
    None))



class ChildDnsSecurityProfile(VapiStruct):
    """
    Child wrapper object for DnsSecurityProfile, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'DnsSecurityProfile': 'dns_security_profile',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 dns_security_profile=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  dns_security_profile: :class:`DnsSecurityProfile` or ``None``
        :param dns_security_profile: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.dns_security_profile = dns_security_profile
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildDnsSecurityProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_dns_security_profile', {
        'DnsSecurityProfile': type.OptionalType(type.ReferenceType(__name__, 'DnsSecurityProfile')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildDnsSecurityProfile,
    False,
    None))



class ChildDnsSecurityProfileBindingMap(VapiStruct):
    """
    Child wrapper obejct for DnsSecurityProfileBindingMap used in hierarchical
    API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'DnsSecurityProfileBindingMap': 'dns_security_profile_binding_map',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 dns_security_profile_binding_map=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  dns_security_profile_binding_map: :class:`DnsSecurityProfileBindingMap` or ``None``
        :param dns_security_profile_binding_map: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.dns_security_profile_binding_map = dns_security_profile_binding_map
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildDnsSecurityProfileBindingMap._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_dns_security_profile_binding_map', {
        'DnsSecurityProfileBindingMap': type.OptionalType(type.ReferenceType(__name__, 'DnsSecurityProfileBindingMap')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildDnsSecurityProfileBindingMap,
    False,
    None))



class ChildDomain(VapiStruct):
    """
    Child wrapper object for domain, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'Domain': 'domain',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 domain=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  domain: :class:`Domain` or ``None``
        :param domain: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.domain = domain
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildDomain._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_domain', {
        'Domain': type.OptionalType(type.ReferenceType(__name__, 'Domain')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildDomain,
    False,
    None))



class ChildDomainDeploymentMap(VapiStruct):
    """
    Child wrapper object for DomainDeploymentMap, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'DomainDeploymentMap': 'domain_deployment_map',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 domain_deployment_map=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  domain_deployment_map: :class:`DomainDeploymentMap` or ``None``
        :param domain_deployment_map: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.domain_deployment_map = domain_deployment_map
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildDomainDeploymentMap._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_domain_deployment_map', {
        'DomainDeploymentMap': type.OptionalType(type.ReferenceType(__name__, 'DomainDeploymentMap')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildDomainDeploymentMap,
    False,
    None))



class ChildEndpointPolicy(VapiStruct):
    """
    Child wrapper object for EndpointPolicy used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'EndpointPolicy': 'endpoint_policy',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 endpoint_policy=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  endpoint_policy: :class:`EndpointPolicy` or ``None``
        :param endpoint_policy: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.endpoint_policy = endpoint_policy
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildEndpointPolicy._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_endpoint_policy', {
        'EndpointPolicy': type.OptionalType(type.ReferenceType(__name__, 'EndpointPolicy')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildEndpointPolicy,
    False,
    None))



class ChildEndpointRule(VapiStruct):
    """
    Child wrapper object for EndpointRule used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'EndpointRule': 'endpoint_rule',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 endpoint_rule=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  endpoint_rule: :class:`EndpointRule` or ``None``
        :param endpoint_rule: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.endpoint_rule = endpoint_rule
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildEndpointRule._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_endpoint_rule', {
        'EndpointRule': type.OptionalType(type.ReferenceType(__name__, 'EndpointRule')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildEndpointRule,
    False,
    None))



class ChildEnforcementPoint(VapiStruct):
    """
    Child wrapper object for EnforcementPoint, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'EnforcementPoint': 'enforcement_point',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 enforcement_point=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  enforcement_point: :class:`EnforcementPoint` or ``None``
        :param enforcement_point: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.enforcement_point = enforcement_point
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildEnforcementPoint._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_enforcement_point', {
        'EnforcementPoint': type.OptionalType(type.ReferenceType(__name__, 'EnforcementPoint')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildEnforcementPoint,
    False,
    None))



class ChildEvpnConfig(VapiStruct):
    """
    Child wrapper object for EvpnConfig, used in hierarchical API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'EvpnConfig': 'evpn_config',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 evpn_config=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  evpn_config: :class:`EvpnConfig` or ``None``
        :param evpn_config: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.evpn_config = evpn_config
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildEvpnConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_evpn_config', {
        'EvpnConfig': type.OptionalType(type.ReferenceType(__name__, 'EvpnConfig')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildEvpnConfig,
    False,
    None))



class ChildEvpnTunnelEndpointConfig(VapiStruct):
    """
    Child wrapper object for EvpnTunnelEndpointConfig, used in hierarchical
    API.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'EvpnTunnelEndpointConfig': 'evpn_tunnel_endpoint_config',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 evpn_tunnel_endpoint_config=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  evpn_tunnel_endpoint_config: :class:`EvpnTunnelEndpointConfig` or ``None``
        :param evpn_tunnel_endpoint_config: 
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.evpn_tunnel_endpoint_config = evpn_tunnel_endpoint_config
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildEvpnTunnelEndpointConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_evpn_tunnel_endpoint_config', {
        'EvpnTunnelEndpointConfig': type.OptionalType(type.ReferenceType(__name__, 'EvpnTunnelEndpointConfig')),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildEvpnTunnelEndpointConfig,
    False,
    None))



class ChildFloodProtectionProfile(VapiStruct):
    """
    Child wrapper object for FloodProtectionProfile, used in hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'FloodProtectionProfile': 'flood_protection_profile',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 flood_protection_profile=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
        """
        :type  flood_protection_profile: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param flood_protection_profile: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`FloodProtectionProfile`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`FloodProtectionProfile`.
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str`
        :param resource_type: 
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  mark_for_override: :class:`bool` or ``None``
        :param mark_for_override: Indicates whether this object is the overridden intent object
            Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: If this field is set to true, delete operation is triggered on the
            intent tree. This resource along with its all children in intent
            tree will be deleted. This is a cascade delete and should only be
            used if intent object along with its all children are to be
            deleted. This does not support deletion of single non-leaf node
            within the tree and should be used carefully.
        :type  request_parameter: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param request_parameter: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`PolicyRequestParameter`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`PolicyRequestParameter`.
        """
        self.flood_protection_profile = flood_protection_profile
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self._resource_type = resource_type
        self.tags = tags
        self.mark_for_override = mark_for_override
        self.marked_for_delete = marked_for_delete
        self.request_parameter = request_parameter
        VapiStruct.__init__(self)

    @property
    def resource_type(self):
        """
        Return the discriminator value
        """
        return self._resource_type

ChildFloodProtectionProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.child_flood_protection_profile', {
        'FloodProtectionProfile': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'FloodProtectionProfile')])),
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.StringType(),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'mark_for_override': type.OptionalType(type.BooleanType()),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'request_parameter': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'PolicyRequestParameter')])),
    },
    ChildFloodProtectionProfile,
    False,
    None))



class ChildFloodProtectionProfileBindingMap(VapiStruct):
    """
    Child wrapper object for FloodProtectionProfileBindingMap, used in
    hierarchical API

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'FloodProtectionProfileBindingMap': 'flood_protection_profile_binding_map',
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'mark_for_override': 'mark_for_override',
                            'marked_for_delete': 'marked_for_delete',
                            'request_parameter': 'request_parameter',
                            }

    def __init__(self,
                 flood_protection_profile_binding_map=None,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 mark_for_override=None,
                 marked_for_delete=None,
                 request_parameter=None,
                ):
    