/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.completer.OptionCompleter;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Arguments;
import org.aesh.command.registry.CommandRegistry;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.HelpSupport;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.CommandDomain;

@CommandDefinition(name="help", description="Display help for a given command. Without any argument list the set of available commands")
public class HelpCommand
extends PmSessionCommand {
    @Arguments(description="The command name optionally followed by sub command name", completer=CommandCompleter.class)
    private List<String> command;
    private CommandRegistry<? extends CommandInvocation> registry;

    public void setRegistry(CommandRegistry<? extends CommandInvocation> registry) {
        this.registry = registry;
    }

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        if (this.command == null || this.command.isEmpty()) {
            try {
                session.println(HelpSupport.buildHelp(this.registry, this.registry.getAllCommandNames()));
            }
            catch (CommandNotFoundException e) {
                throw new CommandExecutionException(e.getLocalizedMessage());
            }
        }
        StringBuilder builder = new StringBuilder();
        for (String str : this.command) {
            builder.append(str).append(" ");
        }
        String cmd = builder.toString().trim();
        try {
            CommandContainer<? extends CommandInvocation> container = this.registry.getCommand(this.command.get(0), null);
            if (this.command.size() > 1 && container.getParser().getChildParser(this.command.get(1)) == null) {
                throw new CommandExecutionException(CliErrors.commandNotFound(cmd));
            }
        }
        catch (CommandNotFoundException ex) {
            throw new CommandExecutionException(CliErrors.commandNotFound(cmd));
        }
        session.println(session.getHelpInfo(cmd));
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.OTHERS;
    }

    public static class CommandCompleter
    implements OptionCompleter<PmCompleterInvocation> {
        @Override
        public void complete(PmCompleterInvocation completerInvocation) {
            HelpCommand cmd = (HelpCommand)completerInvocation.getCommand();
            String mainCommand = null;
            if (cmd.command != null) {
                if (cmd.command.size() > 1) {
                    return;
                }
                mainCommand = cmd.command.get(0);
            }
            String buff = completerInvocation.getGivenCompleteValue();
            List<String> allAvailable = HelpSupport.getAvailableCommands(cmd.registry, false, true);
            ArrayList<String> candidates = new ArrayList<String>();
            if (mainCommand == null) {
                if (buff == null || buff.isEmpty()) {
                    candidates.addAll(allAvailable);
                } else {
                    for (String c : allAvailable) {
                        if (!c.startsWith(buff)) continue;
                        candidates.add(c);
                    }
                }
            } else {
                try {
                    CommandLineParser<? extends CommandInvocation> p = cmd.registry.getCommand(mainCommand, null).getParser();
                    for (CommandLineParser<? extends CommandInvocation> child : p.getAllChildParsers()) {
                        CommandActivator childActivator;
                        if (!child.getProcessedCommand().name().startsWith(buff) || (childActivator = child.getProcessedCommand().getActivator()) != null && !childActivator.isActivated(new ParsedCommand(child.getProcessedCommand()))) continue;
                        candidates.add(child.getProcessedCommand().name());
                    }
                }
                catch (CommandNotFoundException commandNotFoundException) {
                    // empty catch block
                }
            }
            Collections.sort(candidates);
            completerInvocation.addAllCompleterValues(candidates);
        }
    }
}

