/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.internal.Cast;
import org.gradle.internal.service.DefaultServiceLocator;
import org.gradle.internal.service.ServiceLocator;
import org.gradle.internal.service.UnknownServiceException;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Global.class})
public class CachingServiceLocator
implements ServiceLocator {
    private final ServiceLocator delegate;
    private final Map<Class<?>, DefaultServiceLocator.ServiceFactory<?>> serviceFactories = new HashMap();
    private final Map<Class<?>, Object> services = new HashMap();
    private final Map<Class<?>, List<?>> allServices = new HashMap();

    public static CachingServiceLocator of(ServiceLocator other) {
        return new CachingServiceLocator(other);
    }

    private CachingServiceLocator(ServiceLocator delegate) {
        this.delegate = delegate;
    }

    @Override
    public synchronized <T> DefaultServiceLocator.ServiceFactory<T> findFactory(Class<T> serviceType) {
        if (this.serviceFactories.containsKey(serviceType)) {
            return (DefaultServiceLocator.ServiceFactory)Cast.uncheckedCast(this.serviceFactories.get(serviceType));
        }
        DefaultServiceLocator.ServiceFactory<T> factory = this.delegate.findFactory(serviceType);
        this.serviceFactories.put(serviceType, factory);
        return factory;
    }

    @Override
    public synchronized <T> T get(Class<T> serviceType) throws UnknownServiceException {
        if (this.services.containsKey(serviceType)) {
            return (T)Cast.uncheckedNonnullCast((Object)this.services.get(serviceType));
        }
        T t = this.delegate.get(serviceType);
        this.services.put(serviceType, t);
        return t;
    }

    @Override
    public synchronized <T> List<T> getAll(Class<T> serviceType) throws UnknownServiceException {
        if (this.allServices.containsKey(serviceType)) {
            return (List)Cast.uncheckedNonnullCast(this.allServices.get(serviceType));
        }
        List<T> all = this.delegate.getAll(serviceType);
        this.allServices.put(serviceType, all);
        return all;
    }

    @Override
    public synchronized <T> DefaultServiceLocator.ServiceFactory<T> getFactory(Class<T> serviceType) throws UnknownServiceException {
        DefaultServiceLocator.ServiceFactory<T> factory = this.findFactory(serviceType);
        if (factory == null) {
            throw new UnknownServiceException(serviceType, String.format("Could not find meta-data resource 'META-INF/services/%s' for service '%s'.", serviceType.getName(), serviceType.getName()));
        }
        return factory;
    }
}

