/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.duo;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.duo.DuoAuthenticationProviderModule;
import org.apache.guacamole.auth.duo.DuoAuthenticationSession;
import org.apache.guacamole.auth.duo.DuoAuthenticationSessionManager;
import org.apache.guacamole.auth.duo.UserVerificationService;
import org.apache.guacamole.net.auth.AbstractAuthenticationProvider;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.UserContext;

public class DuoAuthenticationProvider
extends AbstractAuthenticationProvider {
    public static String PROVIDER_IDENTIFER = "duo";
    private final UserVerificationService verificationService;
    private final DuoAuthenticationSessionManager sessionManager;

    public DuoAuthenticationProvider() throws GuacamoleException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new DuoAuthenticationProviderModule((AuthenticationProvider)this)});
        this.sessionManager = (DuoAuthenticationSessionManager)((Object)injector.getInstance(DuoAuthenticationSessionManager.class));
        this.verificationService = (UserVerificationService)injector.getInstance(UserVerificationService.class);
    }

    public String getIdentifier() {
        return PROVIDER_IDENTIFER;
    }

    public Credentials updateCredentials(Credentials credentials) throws GuacamoleException {
        String duoState = credentials.getParameter("state");
        if (duoState == null) {
            return credentials;
        }
        DuoAuthenticationSession session = (DuoAuthenticationSession)this.sessionManager.resume(duoState);
        if (session == null) {
            return credentials;
        }
        Credentials previousCredentials = session.getCredentials();
        previousCredentials.setRequestDetails(credentials.getRequestDetails());
        return previousCredentials;
    }

    public UserContext getUserContext(AuthenticatedUser authenticatedUser) throws GuacamoleException {
        this.verificationService.verifyAuthenticatedUser(authenticatedUser);
        return null;
    }

    public void shutdown() {
        this.sessionManager.shutdown();
    }
}

