/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.openid;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.UriBuilder;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.openid.conf.ConfigurationService;
import org.apache.guacamole.auth.openid.token.TokenValidationService;
import org.apache.guacamole.auth.sso.NonceService;
import org.apache.guacamole.auth.sso.SSOAuthenticationProviderService;
import org.apache.guacamole.auth.sso.user.SSOAuthenticatedUser;
import org.apache.guacamole.form.RedirectField;
import org.apache.guacamole.language.TranslatableMessage;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.credentials.CredentialsInfo;
import org.apache.guacamole.net.auth.credentials.GuacamoleInvalidCredentialsException;
import org.jose4j.jwt.JwtClaims;

@Singleton
public class AuthenticationProviderService
implements SSOAuthenticationProviderService {
    public static final String TOKEN_PARAMETER_NAME = "id_token";
    @Inject
    private ConfigurationService confService;
    @Inject
    private NonceService nonceService;
    @Inject
    private TokenValidationService tokenService;
    @Inject
    private Provider<SSOAuthenticatedUser> authenticatedUserProvider;

    public SSOAuthenticatedUser authenticateUser(Credentials credentials) throws GuacamoleException {
        JwtClaims claims;
        String username = null;
        Set<String> groups = null;
        Map<Object, Object> tokens = Collections.emptyMap();
        String token = credentials.getParameter(TOKEN_PARAMETER_NAME);
        if (token != null && (claims = this.tokenService.validateToken(token)) != null) {
            username = this.tokenService.processUsername(claims);
            groups = this.tokenService.processGroups(claims);
            tokens = this.tokenService.processAttributes(claims);
        }
        if (username != null) {
            SSOAuthenticatedUser authenticatedUser = (SSOAuthenticatedUser)this.authenticatedUserProvider.get();
            authenticatedUser.init(username, credentials, groups, tokens);
            return authenticatedUser;
        }
        throw new GuacamoleInvalidCredentialsException("Invalid login.", new CredentialsInfo(Arrays.asList(new RedirectField(TOKEN_PARAMETER_NAME, this.getLoginURI(), new TranslatableMessage("LOGIN.INFO_IDP_REDIRECT_PENDING")))));
    }

    public URI getLoginURI() throws GuacamoleException {
        return UriBuilder.fromUri((URI)this.confService.getAuthorizationEndpoint()).queryParam("scope", new Object[]{this.confService.getScope()}).queryParam("response_type", new Object[]{TOKEN_PARAMETER_NAME}).queryParam("client_id", new Object[]{this.confService.getClientID()}).queryParam("redirect_uri", new Object[]{this.confService.getRedirectURI()}).queryParam("nonce", new Object[]{this.nonceService.generate((long)this.confService.getMaxNonceValidity() * 60000L)}).build(new Object[0]);
    }

    public void shutdown() {
    }
}

