/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.srtp.crypto;

import java.lang.ref.Cleaner;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import org.jitsi.srtp.crypto.JitsiOpenSslProvider;

public class OpenSslHmacSpi
extends MacSpi
implements AutoCloseable {
    private final OpenSslHmacSpiCleanable ctx = new OpenSslHmacSpiCleanable();
    private final Cleaner.Cleanable ctxCleanable;
    private Key key;
    private final int macSize;
    private final long md;

    private static native int EVP_MD_size(long var0);

    private static native long EVP_sha1();

    private static native long HMAC_CTX_create();

    private static native void HMAC_CTX_destroy(long var0);

    private native int HMAC_Final(long var1, byte[] var3, int var4, int var5);

    private native boolean HMAC_Init_ex(long var1, byte[] var3, int var4, long var5, long var7);

    private native boolean HMAC_Update(long var1, byte[] var3, int var4, int var5);

    public OpenSslHmacSpi() {
        if (!JitsiOpenSslProvider.isLoaded()) {
            throw new RuntimeException("OpenSSL wrapper not loaded");
        }
        this.md = OpenSslHmacSpi.EVP_sha1();
        if (this.md == 0L) {
            throw new IllegalStateException("EVP_sha1 == 0");
        }
        this.macSize = OpenSslHmacSpi.EVP_MD_size(this.md);
        if (this.macSize == 0) {
            throw new IllegalStateException("EVP_MD_size == 0");
        }
        this.ctx.ptr = OpenSslHmacSpi.HMAC_CTX_create();
        if (this.ctx.ptr == 0L) {
            throw new RuntimeException("HMAC_CTX_create == 0");
        }
        this.ctxCleanable = JitsiOpenSslProvider.CLEANER.register(this, this.ctx);
    }

    @Override
    protected int engineGetMacLength() {
        return this.macSize;
    }

    @Override
    protected byte[] engineDoFinal() {
        long ctx = this.ctx.ptr;
        if (ctx == 0L) {
            throw new IllegalStateException("ctx");
        }
        byte[] out = new byte[this.macSize];
        int outLen = this.HMAC_Final(ctx, out, 0, out.length);
        if (outLen < 0) {
            throw new RuntimeException("HMAC_Final");
        }
        this.engineReset();
        return out;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException {
        this.key = key;
        if (key == null) {
            throw new InvalidKeyException("key == null");
        }
        long ctx = this.ctx.ptr;
        if (ctx == 0L) {
            throw new IllegalStateException("ctx == 0");
        }
        byte[] k = key.getEncoded();
        if (!this.HMAC_Init_ex(ctx, k, k.length, this.md, 0L)) {
            throw new RuntimeException("HMAC_Init_ex() init failed");
        }
    }

    @Override
    protected void engineReset() {
        if (this.key == null) {
            throw new IllegalStateException("key == null");
        }
        long ctx = this.ctx.ptr;
        if (ctx == 0L) {
            throw new IllegalStateException("ctx == 0");
        }
        if (!this.HMAC_Init_ex(ctx, null, 0, 0L, 0L)) {
            throw new RuntimeException("HMAC_Init_ex() reset failed");
        }
    }

    @Override
    protected void engineUpdate(byte in) throws IllegalStateException {
        long ctx = this.ctx.ptr;
        if (ctx == 0L) {
            throw new IllegalStateException("ctx");
        }
        if (!this.HMAC_Update(ctx, new byte[]{in}, 0, 1)) {
            throw new RuntimeException("HMAC_Update");
        }
    }

    @Override
    protected void engineUpdate(byte[] in, int off, int len) {
        if (len != 0) {
            if (in == null) {
                throw new NullPointerException("in");
            }
            if (off < 0 || in.length <= off) {
                throw new ArrayIndexOutOfBoundsException(off);
            }
            if (len < 0 || in.length < off + len) {
                throw new IllegalArgumentException("len " + len);
            }
            long ctx = this.ctx.ptr;
            if (ctx == 0L) {
                throw new IllegalStateException("ctx");
            }
            if (!this.HMAC_Update(ctx, in, off, len)) {
                throw new RuntimeException("HMAC_Update");
            }
        }
    }

    @Override
    public void close() {
        this.ctxCleanable.clean();
    }

    private static class OpenSslHmacSpiCleanable
    implements Runnable {
        long ptr;

        private OpenSslHmacSpiCleanable() {
        }

        @Override
        public void run() {
            if (this.ptr != 0L) {
                OpenSslHmacSpi.HMAC_CTX_destroy(this.ptr);
                this.ptr = 0L;
            }
        }
    }
}

