'''OpenGL extension EXT.texture_buffer

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.texture_buffer to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides a new texture type, called a buffer texture.
	Buffer textures are one-dimensional arrays of texels whose storage comes
	from an attached buffer object. When a buffer object is bound to a
	buffer texture, a format is specified, and the data in the buffer object
	is treated as an array of texels of the specified format.
	
	The use of a buffer object to provide storage allows the texture data to
	be specified in a number of different ways: via buffer object loads
	(BufferData), direct CPU writes (MapBuffer), or framebuffer readbacks to
	pixel buffer objects (ReadPixels). A buffer object can also be loaded by
	transform feedback, which captures
	selected transformed attributes of vertices processed by the GL. Several
	of these mechanisms do not require an extra data copy, which would be
	required when using conventional TexImage-like entry points.
	
	Buffer textures do not support mipmapping, texture lookups with
	normalized floating-point texture coordinates, and texture filtering of
	any sort.
	They can be accessed via single texel fetch operations in programmable
	shaders, using a new sampler type and texel fetch function, and
	access can be controlled using the same memory barrier operations
	as for other texture types.
	
	Buffer textures are treated as (potentially large) one-dimensional
	textures; the maximum texture size supported for buffer textures in the
	initial implementation of this extension is 2^27 texels (note that this
	extension only guarantees support for buffer textures with 2^16 texels,
	but we expect most implementations to exceed that substantially). When a
	buffer object is attached to a buffer texture, a size is not specified;
	rather, the number of texels in the texture is taken by dividing the size
	of the buffer object by the size of each texel.
	
	This extension also allows a sub-range of the buffer's data store to
	be attached to a texture. This can be used, for example, to allow multiple
	buffer textures to be backed by independent sub-ranges of the same buffer
	object, or for different sub-ranges of a single buffer object to be used
	for different purposes.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/texture_buffer.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.texture_buffer import *
from OpenGL.raw.GLES2.EXT.texture_buffer import _EXTENSION_NAME

def glInitTextureBufferEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION