<?php
function get_metric_single_template($graph_type) {
    switch (strtolower((string) $graph_type)) {
    case 'cpu':
        return '
--step %step%
-s %start%
-e %stop%
DEF:A=%rrdfile%:user:AVERAGE
DEF:B=%rrdfile%:nice:AVERAGE
DEF:C=%rrdfile%:system:AVERAGE
DEF:D=%rrdfile%:interrupt:AVERAGE
DEF:E=%rrdfile%:idle:AVERAGE
XPORT:A:user
XPORT:B:nice
XPORT:C:system
XPORT:D:interrupt
XPORT:E:idle
';
        break;

    case 'cpuiow':
        return '
--step %step%
-s %start%
-e %stop%
DEF:A=%rrdfile%:user:AVERAGE
DEF:B=%rrdfile%:nice:AVERAGE
DEF:C=%rrdfile%:system:AVERAGE
DEF:D=%rrdfile%:interrupt:AVERAGE
DEF:E=%rrdfile%:idle:AVERAGE
DEF:F=%rrdfile%:iowait:AVERAGE
CDEF:u=user,nice,+
XPORT:u:user
XPORT:C:system
XPORT:D:interrupt
XPORT:E:idle
XPORT:F:iowait
';
        break;

    case 'io':
        return '
--step %step%
-s %start%
-e %stop%
DEF:rx=%rrdfile%:rxfer:AVERAGE
DEF:wx=%rrdfile%:wxfer:AVERAGE
DEF:rb=%rrdfile%:rbytes:AVERAGE
DEF:wb=%rrdfile%:wbytes:AVERAGE
XPORT:rx:rxfer
XPORT:wx:wxfer
XPORT:rb:rbytes
XPORT:wb:wbytes
';
        break;
        
    case 'if':
        return '
--step %step%
-s %start%
-e %stop%
DEF:in=%rrdfile%:ibytes:AVERAGE
DEF:out=%rrdfile%:obytes:AVERAGE
DEF:inp=%rrdfile%:ipackets:AVERAGE
DEF:outp=%rrdfile%:opackets:AVERAGE
DEF:coll=%rrdfile%:collisions:AVERAGE
CDEF:nodata=in,UN,0,*
CDEF:inb=in,8,*
CDEF:outb=out,8,*
XPORT:inb:ibits
XPORT:outb:obits
';
        break;

    case 'mem':
        return '
--step %step%
-s %start%
-e %stop%
DEF:A=%rrdfile%:real_active:AVERAGE
DEF:B=%rrdfile%:real_total:AVERAGE
DEF:C=%rrdfile%:free:AVERAGE
DEF:D=%rrdfile%:swap_used:AVERAGE
DEF:E=%rrdfile%:swap_total:AVERAGE
XPORT:A:real_active
XPORT:B:real_total
XPORT:C:free
XPORT:D:swap_used
XPORT:E:swap_total
';
        break;
        
    case 'load':
        return '
--step %step%
-s %start%
-e %stop%
DEF:load1=%rrdfile%:load1:AVERAGE
XPORT:load1:load1
';
        break;
                            
    default:
        return '';
        break;
    };
}

function get_metric_combined_template($graph_type, $number) {
    global $symon;

    $def = '
--step %step%
-s %start%
-e %stop%
';

    switch ($graph_type) {
    case "cpu":
        $rrd = ['us' => 'user', 'ni' => 'nice', 'sy' => 'system', 'in' => 'interrupt', 'id' => 'idle'];
        break;

    case "cpuiow":
        $rrd = ['us' => 'user', 'ni' => 'nice', 'sy' => 'system', 'in' => 'interrupt', 'id' => 'idle', 'io' => 'iowait'];
        break;

    case 'io':
        $rrd = ['rx' => 'rxfer', 'wx' => 'wxfer', 'rb' => 'rbytes', 'wb' => 'wbytes'];
        break;
    }

    for ($item = 0; $item < $number; $item++) {
        foreach ($rrd as $key => $long) {
            $def .= sprintf('DEF:%s%d=%%rrdfile%d%%:%s:AVERAGE
',$key, $item, $item, $long);

            /* prepare totals cdefs */
            if ($item == 0)
                $cdef[$key] = sprintf('CDEF:%s=%s0', $key, $key);
            else
                $cdef[$key] .= sprintf(',%s%d,+', $key, $item);
        }
    }

    if ($number > 0) {
        $t = sprintf(',%d,/
', $number);
        foreach ($cdef as $type => $s)
            $cdef[$type] .= $t;
    }

    foreach ($rrd as $key => $long) {
        $def .= $cdef[$key];
    }

    foreach ($rrd as $key => $long) {
        $def .= sprintf('XPORT:%s:%s
', $key, $long);
    }

    return $def;
}
?>
