/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.PskClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ClientKeyExchangeParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskClientKeyExchangeParser
extends ClientKeyExchangeParser<PskClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PskClientKeyExchangeParser(int startposition, byte[] array, ProtocolVersion version, Config config) {
        super(startposition, array, version, config);
    }

    @Override
    protected void parseHandshakeMessageContent(PskClientKeyExchangeMessage msg) {
        LOGGER.debug("Parsing PSKClientKeyExchangeMessage");
        this.parsePskIdentityLength(msg);
        this.parsePskIdentity(msg);
    }

    @Override
    protected PskClientKeyExchangeMessage createHandshakeMessage() {
        return new PskClientKeyExchangeMessage();
    }

    private void parsePskIdentityLength(PskClientKeyExchangeMessage msg) {
        msg.setIdentityLength(this.parseIntField(2));
        LOGGER.debug("PskIdentityLength: " + msg.getIdentityLength().getValue());
    }

    private void parsePskIdentity(PskClientKeyExchangeMessage msg) {
        msg.setIdentity(this.parseByteArrayField((Integer)msg.getIdentityLength().getValue()));
        LOGGER.debug("PskIdentity: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getIdentity().getValue())));
    }
}

