/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PWDProtectExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PWDProtectExtensionParser
extends ExtensionParser<PWDProtectExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PWDProtectExtensionParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public void parseExtensionMessageContent(PWDProtectExtensionMessage msg) {
        LOGGER.debug("Parsing PWDProtectExtensionMessage");
        this.parseUsernameLength(msg);
        this.parseUsername(msg);
    }

    @Override
    protected PWDProtectExtensionMessage createExtensionMessage() {
        return new PWDProtectExtensionMessage();
    }

    private void parseUsernameLength(PWDProtectExtensionMessage msg) {
        msg.setUsernameLength(this.parseIntField(1));
        LOGGER.debug("UsernameLength: " + msg.getUsernameLength().getValue());
    }

    private void parseUsername(PWDProtectExtensionMessage msg) {
        msg.setUsername(this.parseByteArrayField((Integer)msg.getUsernameLength().getValue()));
        LOGGER.debug("Username: " + ArrayConverter.bytesToHexString((ModifiableByteArray)msg.getUsername()));
    }
}

