/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.PskRsaClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.RSAClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskRsaClientKeyExchangePreparator
extends RSAClientKeyExchangePreparator<PskRsaClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PskRsaClientKeyExchangeMessage msg;
    private ByteArrayOutputStream outputStream;

    public PskRsaClientKeyExchangePreparator(Chooser chooser, PskRsaClientKeyExchangeMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        this.msg.setIdentity(this.chooser.getPSKIdentity());
        this.msg.setIdentityLength(((byte[])this.msg.getIdentity().getValue()).length);
        super.prepareHandshakeMessageContents();
    }

    @Override
    protected byte[] manipulatePremasterSecret(byte[] premasterSecret) {
        this.outputStream = new ByteArrayOutputStream();
        try {
            this.outputStream.write(ArrayConverter.intToBytes((int)48, (int)2));
            this.outputStream.write(premasterSecret);
            this.outputStream.write(ArrayConverter.intToBytes((int)this.chooser.getConfig().getDefaultPSKKey().length, (int)2));
            this.outputStream.write(this.chooser.getConfig().getDefaultPSKKey());
        }
        catch (IOException ex) {
            LOGGER.warn("Encountered exception while writing to ByteArrayOutputStream.");
            LOGGER.debug((Object)ex);
        }
        byte[] tempPremasterSecret = this.outputStream.toByteArray();
        return tempPremasterSecret;
    }
}

