untrusted comment: verify with openbsd-69-base.pub
RWQQsAemppS46G+d63Zm0IMMudagYEdzlSQanF0fxsZNqe1cQP7CtRYj78siPF+mZsaJeGXxUimpxdrjvhMMvrSIUlzxwZ4HJg8=

OpenBSD 6.9 errata 020, October 31, 2021:

The kernel could leak memory when closing unix sockets.

Apply by doing:
    signify -Vep /etc/signify/openbsd-69-base.pub -x 020_uipc.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/uipc_usrreq.c
===================================================================
RCS file: /cvs/src/sys/kern/uipc_usrreq.c,v
retrieving revision 1.144
diff -u -p -r1.144 uipc_usrreq.c
--- sys/kern/uipc_usrreq.c	22 Feb 2021 19:14:01 -0000	1.144
+++ sys/kern/uipc_usrreq.c	25 Oct 2021 18:53:00 -0000
@@ -301,7 +301,13 @@ uipc_usrreq(struct socket *so, int req, 
 		break;
 
 	case PRU_ABORT:
-		unp_drop(unp, ECONNABORTED);
+		unp_detach(unp);
+		/*
+		 * As long as `unp_lock' is taken before entering
+		 * uipc_usrreq() releasing it here would lead to a
+		 * double unlock.
+		 */
+		sofree(so, SL_NOUNLOCK);
 		break;
 
 	case PRU_SENSE: {
