untrusted comment: verify with openbsd-71-base.pub
RWR2eHwZTOEiTZ0oLiq3Y99Prni9o44tyYm9ppxfp0KNU9wbbp0EkON24//LGI6fpqzitAn/llNm8lgF5QLe4G6wOADHNm7JDgw=

OpenBSD 7.1 errata 022, February 7, 2023:

A malicious certificate revocation list or timestamp response token would
allow an attacker to read arbitrary memory.

Apply by doing:
    signify -Vep /etc/signify/openbsd-71-base.pub -x 022_x509.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libcrypto and unwind:
    cd /usr/src/lib/libcrypto
    make obj
    make includes
    make
    make install
    cd /usr/src/sbin/unwind
    make obj
    make
    make install

Index: lib/libcrypto/x509/x509_genn.c
===================================================================
RCS file: /cvs/src/lib/libcrypto/x509/x509_genn.c,v
diff -u -p -r1.2 x509_genn.c
--- lib/libcrypto/x509/x509_genn.c	8 Dec 2020 15:06:42 -0000	1.2
+++ lib/libcrypto/x509/x509_genn.c	24 Jan 2023 09:43:10 -0000
@@ -366,7 +366,8 @@ GENERAL_NAME_cmp(GENERAL_NAME *a, GENERA
 		return -1;
 	switch (a->type) {
 	case GEN_X400:
-		result = ASN1_TYPE_cmp(a->d.x400Address, b->d.x400Address);
+		result = ASN1_STRING_cmp((ASN1_STRING *)a->d.x400Address,
+		    (ASN1_STRING *)b->d.x400Address);
 		break;
 
 	case GEN_EDIPARTY:
