untrusted comment: verify with openbsd-72-base.pub
RWQTKNnK3CZZ8Cr3XhC9+EHB7OsC8GN+4gIhXNkj59B369wzLnmxOiKTZ1kdmPnX4GqHE4TBdSCA8zt4ekSQ8LZyfNp7Y8irugQ=

OpenBSD 7.2 errata 026, May 26, 2023:

A double free or use after free could occur after SSL_clear(3).

Apply by doing:
    signify -Vep /etc/signify/openbsd-72-base.pub -x 026_ssl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libssl:
    cd /usr/src/lib/libssl
    make obj
    make
    make install

Index: lib/libssl/s3_lib.c
===================================================================
RCS file: /cvs/src/lib/libssl/s3_lib.c,v
diff -u -p -r1.238 s3_lib.c
--- lib/libssl/s3_lib.c	21 Aug 2022 19:39:44 -0000	1.238
+++ lib/libssl/s3_lib.c	15 May 2023 05:05:28 -0000
@@ -1573,6 +1573,7 @@ ssl3_free(SSL *s)
 
 	sk_X509_NAME_pop_free(s->s3->hs.tls12.ca_names, X509_NAME_free);
 	sk_X509_pop_free(s->internal->verified_chain, X509_free);
+	s->internal->verified_chain = NULL;
 
 	tls1_transcript_free(s);
 	tls1_transcript_hash_free(s);
