untrusted comment: verify with openbsd-74-base.pub
RWRoyQmAD08ajahok9K0LaCCG+fDVN8jLa+eGar68sEa+Vz8jMLji2nh7Bb5F+mMLTWIREd1LnQCI8nKa4YgLdteAkHiirp5Pws=

OpenBSD 7.4 errata 015, March 18, 2022:

In libexpat fix billion laughs attack vulnerability CVE-2024-28757.

Apply by doing:
    signify -Vep /etc/signify/openbsd-74-base.pub -x 015_expat.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libexpat:
    cd /usr/src/lib/libexpat
    make obj
    make
    make install

Index: lib/libexpat/Changes
===================================================================
RCS file: /cvs/src/lib/libexpat/Changes,v
diff -u -p -r1.23 Changes
--- lib/libexpat/Changes	27 Oct 2022 12:58:37 -0000	1.23
+++ lib/libexpat/Changes	14 Mar 2024 18:21:22 -0000
@@ -2,6 +2,12 @@ NOTE: We are looking for help with a few
       https://github.com/libexpat/libexpat/labels/help%20wanted
       If you can help, please get in touch.  Thanks!
 
+        Security fixes:
+       #839 #842  CVE-2024-28757 -- Prevent billion laughs attacks with
+                    isolated use of external parsers.  Please see the commit
+                    message of commit 1d50b80cf31de87750103656f6eb693746854aa8
+                    for details.
+
 Release 2.5.0 Tue October 25 2022
         Security fixes:
   #616 #649 #650  CVE-2022-43680 -- Fix heap use-after-free after overeager
Index: lib/libexpat/lib/xmlparse.c
===================================================================
RCS file: /cvs/src/lib/libexpat/lib/xmlparse.c,v
diff -u -p -r1.35 xmlparse.c
--- lib/libexpat/lib/xmlparse.c	27 Oct 2022 12:58:37 -0000	1.35
+++ lib/libexpat/lib/xmlparse.c	14 Mar 2024 18:21:23 -0000
@@ -7655,6 +7655,8 @@ copyString(const XML_Char *s, const XML_
 
 static float
 accountingGetCurrentAmplification(XML_Parser rootParser) {
+  //                                          1.........1.........12 => 22
+  const size_t lenOfShortestInclude = sizeof("<!ENTITY a SYSTEM 'b'>") - 1;
   const XmlBigCount countBytesOutput
       = rootParser->m_accounting.countBytesDirect
         + rootParser->m_accounting.countBytesIndirect;
@@ -7662,7 +7664,9 @@ accountingGetCurrentAmplification(XML_Pa
       = rootParser->m_accounting.countBytesDirect
             ? (countBytesOutput
                / (float)(rootParser->m_accounting.countBytesDirect))
-            : 1.0f;
+            : ((lenOfShortestInclude
+                + rootParser->m_accounting.countBytesIndirect)
+               / (float)lenOfShortestInclude);
   assert(! rootParser->m_parentParser);
   return amplificationFactor;
 }
