/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.message;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.JavaMethod;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.message.AttachmentSetImpl;
import java.util.UUID;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Message {
    protected AttachmentSet attachmentSet;
    private WSDLBoundOperation operation = null;
    private Boolean isOneWay;
    private String uuid;

    public abstract boolean hasHeaders();

    @NotNull
    public abstract HeaderList getHeaders();

    @NotNull
    public AttachmentSet getAttachments() {
        if (this.attachmentSet == null) {
            this.attachmentSet = new AttachmentSetImpl();
        }
        return this.attachmentSet;
    }

    protected boolean hasAttachments() {
        return this.attachmentSet != null;
    }

    @Nullable
    public final WSDLBoundOperation getOperation(@NotNull WSDLBoundPortType wSDLBoundPortType) {
        if (this.operation == null) {
            this.operation = wSDLBoundPortType.getOperation(this.getPayloadNamespaceURI(), this.getPayloadLocalPart());
        }
        return this.operation;
    }

    @Nullable
    public final WSDLBoundOperation getOperation(@NotNull WSDLPort wSDLPort) {
        return this.getOperation(wSDLPort.getBinding());
    }

    @Nullable
    public final JavaMethod getMethod(@NotNull SEIModel sEIModel) {
        String string;
        String string2 = this.getPayloadLocalPart();
        if (string2 == null) {
            string2 = "";
            string = "";
        } else {
            string = this.getPayloadNamespaceURI();
        }
        QName qName = new QName(string, string2);
        return sEIModel.getJavaMethod(qName);
    }

    public boolean isOneWay(@NotNull WSDLPort wSDLPort) {
        if (this.isOneWay == null) {
            WSDLBoundOperation wSDLBoundOperation = this.getOperation(wSDLPort);
            this.isOneWay = wSDLBoundOperation != null ? Boolean.valueOf(wSDLBoundOperation.getOperation().isOneWay()) : Boolean.valueOf(false);
        }
        return this.isOneWay;
    }

    public final void assertOneWay(boolean bl) {
        assert (this.isOneWay == null || this.isOneWay == bl);
        this.isOneWay = bl;
    }

    @Nullable
    public abstract String getPayloadLocalPart();

    public abstract String getPayloadNamespaceURI();

    public abstract boolean hasPayload();

    public boolean isFault() {
        String string = this.getPayloadLocalPart();
        if (string == null || !string.equals("Fault")) {
            return false;
        }
        String string2 = this.getPayloadNamespaceURI();
        return string2.equals(SOAPVersion.SOAP_11.nsUri) || string2.equals(SOAPVersion.SOAP_12.nsUri);
    }

    @Nullable
    public QName getFirstDetailEntryName() {
        assert (this.isFault());
        Message message = this.copy();
        try {
            SOAPFaultBuilder sOAPFaultBuilder = SOAPFaultBuilder.create(message);
            return sOAPFaultBuilder.getFirstDetailEntryName();
        }
        catch (JAXBException jAXBException) {
            throw new WebServiceException(jAXBException);
        }
    }

    public abstract Source readEnvelopeAsSource();

    public abstract Source readPayloadAsSource();

    public abstract SOAPMessage readAsSOAPMessage() throws SOAPException;

    public SOAPMessage readAsSOAPMessage(Packet packet, boolean bl) throws SOAPException {
        return this.readAsSOAPMessage();
    }

    public abstract <T> T readPayloadAsJAXB(Unmarshaller var1) throws JAXBException;

    public abstract <T> T readPayloadAsJAXB(Bridge<T> var1) throws JAXBException;

    public abstract XMLStreamReader readPayload() throws XMLStreamException;

    public void consume() {
    }

    public abstract void writePayloadTo(XMLStreamWriter var1) throws XMLStreamException;

    public abstract void writeTo(XMLStreamWriter var1) throws XMLStreamException;

    public abstract void writeTo(ContentHandler var1, ErrorHandler var2) throws SAXException;

    public abstract Message copy();

    @NotNull
    public String getID(@NotNull WSBinding wSBinding) {
        return this.getID(wSBinding.getAddressingVersion(), wSBinding.getSOAPVersion());
    }

    @NotNull
    public String getID(AddressingVersion addressingVersion, SOAPVersion sOAPVersion) {
        if (this.uuid == null) {
            if (addressingVersion != null) {
                this.uuid = this.getHeaders().getMessageID(addressingVersion, sOAPVersion);
            }
            if (this.uuid == null) {
                this.uuid = "uuid:" + UUID.randomUUID().toString();
            }
        }
        return this.uuid;
    }
}

