/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.FailedDownloadException;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.pings.Pings;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.ui.ComponentRef;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.PerfLogger;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import com.sun.javaws.BrowserSupport;
import com.sun.javaws.Globals;
import com.sun.javaws.JAuthenticator;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.JreExecException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.exceptions.NoLocalJREException;
import com.sun.javaws.exceptions.OfflineLaunchException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.LaunchSelection;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.progress.CustomProgress;
import com.sun.javaws.progress.Progress;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.security.JavaWebStartSecurity;
import com.sun.javaws.ui.AutoDownloadPrompt;
import com.sun.javaws.ui.DownloadWindowHelper;
import com.sun.javaws.ui.LaunchErrorDialog;
import com.sun.javaws.ui.SecureStaticVersioning;
import com.sun.javaws.ui.SplashScreen;
import com.sun.javaws.util.JavawsConsoleController;
import com.sun.jnlp.AppletContainer;
import com.sun.jnlp.AppletContainerCallback;
import com.sun.jnlp.BasicServiceImpl;
import com.sun.jnlp.ExtensionInstallerServiceImpl;
import com.sun.jnlp.JNLPClassLoader;
import com.sun.jnlp.PreverificationClassLoader;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import javax.jnlp.DownloadServiceListener;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class Launcher
implements Runnable {
    private DownloadWindowHelper _downloadWindowHelper = null;
    private LaunchDesc _initialLaunchDesc;
    private LaunchDesc _launchDesc;
    private String[] _args;
    private boolean _exit = true;
    private JAuthenticator _ja;
    private LocalApplicationProperties _lap = null;
    private JNLPClassLoader _jnlpClassLoader = null;
    private JREInfo _jreInfo = null;
    private boolean _isRelaunch = false;
    private boolean _isCached = false;
    private boolean _jreInstalled = false;
    private static boolean _isImport = false;
    private static boolean _isSilent = false;
    private boolean _javafx_install_initiated = false;
    private LaunchSelection.MatchJREIf _jreMatcher;
    private boolean _shownDownloadWindow = false;

    public Launcher(LaunchDesc launchDesc) {
        this._initialLaunchDesc = launchDesc;
        this._downloadWindowHelper = new DownloadWindowHelper();
        Trace.println((String)("new Launcher: " + launchDesc.toString()), (TraceLevel)TraceLevel.BASIC);
    }

    public void launch(String[] stringArray, boolean bl) {
        this._args = stringArray;
        this._exit = bl;
        if (this.prepareToLaunch()) {
            new Thread(Main.getLaunchThreadGroup(), this, "javawsApplicationMain").start();
        } else {
            LaunchErrorDialog.show(this._downloadWindowHelper.getOwner(), new Exception(ResourceManager.getString((String)"launch.error.category.unexpected")), true);
        }
    }

    public void run() {
        block8: {
            try {
                this.doLaunchApp();
            }
            catch (Throwable throwable) {
                int n;
                ExitException exitException = throwable instanceof ExitException ? (ExitException)throwable : new ExitException(throwable, 3);
                int n2 = n = exitException.getReason() == 0 ? 0 : -1;
                if (exitException.getReason() == 3) {
                    if (this._launchDesc.getUpdater().isBackgroundUpdateRunning() && this._lap != null) {
                        this._lap.setForceUpdateCheck(true);
                        try {
                            this._lap.store();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    LaunchErrorDialog.show(this._downloadWindowHelper.getOwner(), exitException.getException(), this._exit);
                }
                if (!this._exit) break block8;
                try {
                    Main.systemExit(n);
                }
                catch (ExitException exitException2) {
                    Trace.println((String)("systemExit: " + exitException2), (TraceLevel)TraceLevel.BASIC);
                    Trace.ignoredException((Exception)exitException2);
                }
            }
        }
    }

    private boolean prepareToLaunch() {
        if (SingleInstanceManager.isServerRunning((String)this._initialLaunchDesc.getCanonicalHome().toString())) {
            String[] stringArray = Globals.getApplicationArgs();
            if (stringArray != null && this._initialLaunchDesc.getApplicationDescriptor() != null) {
                this._initialLaunchDesc.getApplicationDescriptor().setArguments(stringArray);
            }
            if (SingleInstanceManager.connectToServer((String)this._initialLaunchDesc.toString())) {
                Trace.println((String)"Exiting (launched in the other instance)", (TraceLevel)TraceLevel.BASIC);
                return true;
            }
        }
        boolean bl = Cache.isCacheEnabled() && (this._initialLaunchDesc.getUpdate().isBackgroundCheck() || DeployOfflineManager.isForcedOffline() || JnlpxArgs.getIsRelaunch());
        try {
            if (!bl && DeployOfflineManager.isForcedOffline()) {
                throw new CacheUpdateRequiredException("Forced offline mode!");
            }
            boolean bl2 = this.prepareToLaunch(bl);
            if (Cache.isCacheEnabled() && !DeployOfflineManager.isForcedOffline()) {
                this._launchDesc.getUpdater().startBackgroundUpdateOpt();
            }
            return bl2;
        }
        catch (CacheUpdateRequiredException cacheUpdateRequiredException) {
            Trace.println((String)("Could not launch from cache. Will try online mode. [" + cacheUpdateRequiredException.getMessage() + "]"));
            if (bl && DeployOfflineManager.isForcedOffline()) {
                DeployOfflineManager.setForcedOffline((boolean)false);
                if (!DeployOfflineManager.askUserGoOnline((URL)this._initialLaunchDesc.getLocation())) {
                    DeployOfflineManager.setForcedOffline((boolean)true);
                    Trace.println((String)"User chose not to go online and we can not not start in offline mode");
                    LaunchErrorDialog.show(this._downloadWindowHelper.getOwner(), new OfflineLaunchException(0), this._exit);
                    return false;
                }
            }
            try {
                return this.prepareToLaunch(false);
            }
            catch (CacheUpdateRequiredException cacheUpdateRequiredException2) {
                Trace.println((String)("Unexpected exception: " + cacheUpdateRequiredException2));
                return false;
            }
        }
    }

    private boolean prepareToLaunch(boolean bl) throws CacheUpdateRequiredException {
        try {
            URL uRL;
            Trace.println((String)("prepareToLaunch: offlineOnly=" + bl), (TraceLevel)TraceLevel.NETWORK);
            _isSilent = Globals.isSilentMode();
            PerfLogger.setTime((String)"Begin updateFinalLaunchDesc");
            boolean bl2 = this.updateFinalLaunchDesc(this._initialLaunchDesc, 0, bl);
            this.removeTempJnlpFile(this._launchDesc);
            if (bl2) {
                File file = null;
                if (this._launchDesc.isApplicationDescriptor()) {
                    try {
                        file = DownloadEngine.getCachedFile((URL)this._launchDesc.getCanonicalHome());
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException((Exception)iOException);
                    }
                    if (this._args != null) {
                        this._args[0] = file.getPath();
                    }
                }
            }
            PerfLogger.setTime((String)"End updateFinalLaunchDesc");
            boolean bl3 = this._launchDesc.isInstaller();
            this._isRelaunch = JnlpxArgs.getIsRelaunch();
            URL uRL2 = this._launchDesc.getCanonicalHome();
            if (!bl3 && !this._launchDesc.isLibrary()) {
                this._lap = Cache.getLocalApplicationProperties((URL)uRL2);
                if (bl && this._lap != null && this._lap.forceUpdateCheck()) {
                    throw new CacheUpdateRequiredException("Need to update: force update set in LAP");
                }
            }
            if (bl2 && this._lap != null && Cache.isCacheEnabled() && this._lap.isLocallyInstalled() && LocalInstallHandler.getInstance().isShortcutExists(this._lap)) {
                Launcher.notifyLocalInstallHandler(this._launchDesc, this._lap, _isSilent, false, this._downloadWindowHelper.getOwnerRef());
            }
            if ((uRL = this._launchDesc.getLocation()) != null) {
                Cache.removeRemovedApp((String)uRL.toString(), (String)this._launchDesc.getInformation().getTitle());
            }
            Trace.println((String)("isUpdated: " + bl2), (TraceLevel)TraceLevel.NETWORK);
            if (this._launchDesc.getResources() != null) {
                Globals.getDebugOptionsFromProperties(this._launchDesc.getResources().getResourceProperties());
            }
            if (Config.getBooleanProperty((String)"deployment.security.authenticator")) {
                this._ja = JAuthenticator.getInstance(this._downloadWindowHelper.getOwnerRef());
                Authenticator.setDefault((Authenticator)((Object)this._ja));
            }
            boolean bl4 = _isImport = Environment.isImportMode() || this._launchDesc.getLaunchType() == 3;
            if (!_isSilent) {
                this._downloadWindowHelper.initialize(this._launchDesc, true, false);
            }
            this.prepareAllResources(this._launchDesc, this._args, bl2, bl);
        }
        catch (CacheUpdateRequiredException cacheUpdateRequiredException) {
            throw cacheUpdateRequiredException;
        }
        catch (Throwable throwable) {
            int n;
            ExitException exitException = throwable instanceof ExitException ? (ExitException)throwable : new ExitException(throwable, 3);
            int n2 = n = exitException.getReason() == 0 ? 0 : -1;
            if (exitException.getReason() == 3) {
                LaunchErrorDialog.show(this._downloadWindowHelper.getOwner(), exitException.getException(), this._exit);
            }
            if (n == 0) {
                Trace.println((String)"Exiting", (TraceLevel)TraceLevel.BASIC);
            } else {
                Trace.ignoredException((Exception)exitException);
            }
            if (this._exit) {
                try {
                    Main.systemExit(n);
                }
                catch (ExitException exitException2) {
                    Trace.println((String)("systemExit: " + exitException2), (TraceLevel)TraceLevel.BASIC);
                    Trace.ignoredException((Exception)exitException2);
                }
            }
            return false;
        }
        return true;
    }

    private boolean updateFinalLaunchDesc(LaunchDesc launchDesc, int n, boolean bl) throws ExitException, CacheUpdateRequiredException {
        try {
            URL uRL = launchDesc.getLocation();
            if (uRL == null) {
                this._launchDesc = launchDesc;
                return LaunchDownload.updateNoHrefLaunchDescInCache(launchDesc);
            }
            String string = Config.getCacheDirectory();
            String string2 = Config.getSystemCacheDirectory();
            boolean bl2 = this._args[0] != null && (string != null && this._args[0].startsWith(string) || string2 != null && this._args[0].startsWith(string2));
            File file = DownloadEngine.getCachedFile((URL)uRL);
            if (!bl && bl2) {
                LaunchDesc launchDesc2 = LaunchDownload.getUpdatedLaunchDesc(uRL, null);
                if (launchDesc2 == null) {
                    this._launchDesc = launchDesc;
                    return false;
                }
                URL uRL2 = launchDesc2.getLocation();
                if (uRL2 == null || !uRL2.toString().equals(uRL.toString()) && n == 0) {
                    Cache.removeCacheEntry((URL)uRL, null, null);
                    return this.updateFinalLaunchDesc(launchDesc2, ++n, false);
                }
                this._launchDesc = launchDesc2;
                return true;
            }
            if (file != null) {
                block20: {
                    try {
                        this._launchDesc = LaunchDescFactory.buildDescriptor(file, LaunchDescFactory.getDerivedCodebase(), LaunchDescFactory.getDocBase(), uRL);
                    }
                    catch (LaunchDescException launchDescException) {
                        this._launchDesc = LaunchDescFactory.buildDescriptor(file);
                        if (this._launchDesc != null) break block20;
                        throw launchDescException;
                    }
                }
                byte[] byArray = this._launchDesc.getBytes();
                LaunchDesc launchDesc3 = null;
                if (!launchDesc.hasIdenticalContent(byArray)) {
                    if (n == 0 && bl) {
                        throw new CacheUpdateRequiredException("Given JNLP is newer than cached copy!");
                    }
                    launchDesc3 = LaunchDownload.getUpdatedLaunchDesc(uRL, null);
                }
                if (launchDesc3 != null) {
                    this._launchDesc = launchDesc3;
                    URL uRL3 = this._launchDesc.getLocation();
                    if (uRL3 == null || !uRL3.toString().equals(uRL.toString()) && n == 0) {
                        Cache.removeCacheEntry((URL)uRL, null, null);
                        return this.updateFinalLaunchDesc(this._launchDesc, ++n, bl);
                    }
                    return true;
                }
                Cache.removeRemovedApp((String)uRL.toString(), (String)this._launchDesc.getInformation().getTitle());
                URL uRL4 = this._launchDesc.getLocation();
                if (uRL4 == null || !uRL4.toString().equals(uRL.toString()) && n == 0) {
                    Cache.removeCacheEntry((URL)uRL, null, null);
                    return this.updateFinalLaunchDesc(this._launchDesc, ++n, bl);
                }
                this._launchDesc = launchDesc;
                return false;
            }
            if (bl) {
                throw new CacheUpdateRequiredException("Missing from the cache: " + uRL);
            }
            if (Cache.isCacheEnabled()) {
                DownloadEngine.getResource((URL)uRL, null, null, null, (boolean)true);
                file = DownloadEngine.getCachedFile((URL)uRL);
                if (file != null) {
                    this._launchDesc = LaunchDescFactory.buildDescriptor(file, LaunchDescFactory.getDerivedCodebase(), LaunchDescFactory.getDocBase(), uRL);
                    URL uRL5 = this._launchDesc.getLocation();
                    if (uRL5 == null || !uRL5.toString().equals(uRL.toString()) && n == 0) {
                        Cache.removeCacheEntry((URL)uRL, null, null);
                        return this.updateFinalLaunchDesc(this._launchDesc, ++n, bl);
                    }
                    return true;
                }
                throw new Exception("cache failed for" + uRL);
            }
            this._launchDesc = LaunchDescFactory.buildDescriptor(uRL, null);
            URL uRL6 = this._launchDesc.getLocation();
            if (uRL6 != null && !uRL6.toString().equals(uRL.toString()) && n == 0) {
                return this.updateFinalLaunchDesc(this._launchDesc, ++n, bl);
            }
            return false;
        }
        catch (CacheUpdateRequiredException cacheUpdateRequiredException) {
            throw cacheUpdateRequiredException;
        }
        catch (Exception exception) {
            throw new ExitException(exception, 3);
        }
    }

    private void removeTempJnlpFile(LaunchDesc launchDesc) {
        File file = null;
        if (launchDesc.isApplicationDescriptor()) {
            try {
                file = DownloadEngine.getCachedFile((URL)launchDesc.getCanonicalHome());
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        if (file == null) {
            return;
        }
        if (this._args != null && file != null && JnlpxArgs.shouldRemoveArgumentFile()) {
            new File(this._args[0]).delete();
            JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(false));
            this._args[0] = file.getPath();
        }
    }

    static String getCurrentJavaFXVersion() {
        URL uRL = null;
        try {
            uRL = new URL("http://dl.javafx.com/javafx-rt.jnlp");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        CacheEntry cacheEntry = Cache.getLatestCacheEntry((URL)uRL, null);
        LaunchDesc launchDesc = null;
        String string = "XX";
        if (cacheEntry != null) {
            try {
                launchDesc = LaunchDescFactory.buildDescriptor(cacheEntry.getDataFile(), null, null, uRL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = launchDesc.getVersion();
        }
        return string;
    }

    static String getRequestedJavaFXVersion(LaunchDesc launchDesc) {
        String string = "XX";
        if (launchDesc != null) {
            string = launchDesc.getVersion();
        }
        return string;
    }

    private void prepareAllResources(LaunchDesc launchDesc, String[] stringArray, boolean bl, boolean bl2) throws ExitException, CacheUpdateRequiredException {
        ArrayList arrayList = new ArrayList();
        boolean bl3 = this.prepareLaunchFile(launchDesc, stringArray, bl2, arrayList);
        if (!bl2) {
            this.prepareEnvironment(launchDesc);
            ResourcesDesc resourcesDesc = launchDesc.getResources();
            if (!(resourcesDesc == null || _isSilent || _isImport || bl2)) {
                JARDesc jARDesc = resourcesDesc.getProgressJar();
                if (jARDesc != null) {
                    String string = launchDesc.getProgressClassName();
                    if (string != null) {
                        Trace.println((String)("Using Custome Progress jar: " + jARDesc), (TraceLevel)TraceLevel.NETWORK);
                        this.prepareCustomProgress(launchDesc, jARDesc, string);
                    } else {
                        Trace.println((String)"No Custom progress class found", (TraceLevel)TraceLevel.NETWORK);
                    }
                } else {
                    Trace.println((String)"No Custom Progress jar specified", (TraceLevel)TraceLevel.NETWORK);
                }
            }
        } else {
            AppPolicy.createInstance(launchDesc.getCanonicalHome().getHost());
        }
        this.prepareResources(launchDesc, stringArray, bl, bl2, bl3, arrayList);
        if (bl2) {
            this.prepareEnvironment(launchDesc);
        }
    }

    private boolean prepareLaunchFile(LaunchDesc launchDesc, String[] stringArray, boolean bl, ArrayList arrayList) throws ExitException, CacheUpdateRequiredException {
        boolean bl2;
        Serializable serializable;
        Object object;
        boolean bl3 = false;
        if (launchDesc.getResources() == null) {
            this.handleJnlpFileException(launchDesc, new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.noappresources", (String)launchDesc.getSpecVersion()), null));
        }
        if (!_isImport && launchDesc.isLibrary()) {
            LaunchDescException launchDescException = new LaunchDescException(launchDesc, "Internal Error: !_isImport && ld.isLibrary()", null);
            this.handleJnlpFileException(launchDesc, launchDescException);
        }
        boolean bl4 = launchDesc.isInstaller();
        JNLPException.setDefaultLaunchDesc(launchDesc);
        JREInfo jREInfo = JREInfo.getHomeJRE();
        Trace.println((String)("Launcher: isInstaller: " + bl4 + ", isRelaunch: " + this._isRelaunch + ", isImport: " + _isImport + ", java.home:" + Config.getJavaHome() + ", Running JRE: " + jREInfo), (TraceLevel)TraceLevel.BASIC);
        Trace.println((String)"JREInfos", (TraceLevel)TraceLevel.BASIC);
        JREInfo.traceJREs();
        if (jREInfo == null) {
            object = new LaunchDescException(launchDesc, "Internal Error: no running JRE", null);
            this.handleJnlpFileException(launchDesc, (Exception)object);
        }
        if (!launchDesc.getInformation().supportsOfflineOperation() && DeployOfflineManager.isGlobalOffline()) {
            throw new ExitException(new OfflineLaunchException(1), 3);
        }
        PerfLogger.setTime((String)"Begin LaunchDownload.isInCache(ld)");
        if (launchDesc.getUpdate().isBackgroundCheck() && (this._lap == null || !this._lap.forceUpdateCheck())) {
            this._isCached = LaunchDownload.isInCache(launchDesc);
        }
        PerfLogger.setTime((String)"End LaunchDownload.isInCache(ld)");
        if (!this._isCached && !bl) {
            try {
                LaunchDownload.downloadExtensions(launchDesc, null, 0, arrayList);
                bl3 = true;
            }
            catch (Exception exception) {
                if (!launchDesc.getInformation().supportsOfflineOperation() || !LaunchDownload.isInCache(launchDesc)) {
                    throw new ExitException(exception, 3);
                }
                Trace.ignoredException((Exception)exception);
            }
        } else {
            bl3 = this._isCached;
        }
        if (!bl3) {
            if (!launchDesc.getInformation().supportsOfflineOperation() || !LaunchDownload.isInCache(launchDesc)) {
                throw new CacheUpdateRequiredException("Some of required resources are not cached.");
            }
            bl3 = true;
        }
        object = launchDesc.getJREMatcher();
        JVMParameters jVMParameters = object.getSelectedJVMParameters();
        this._jreInfo = object.getSelectedJREInfo();
        JREDesc jREDesc = object.getSelectedJREDesc();
        if (this._jreInfo == null && jREDesc == null || null == jVMParameters) {
            Trace.println((String)object.toString());
            serializable = new LaunchDescException(launchDesc, "Internal Error: Internal error, jreMatcher uninitialized", null);
            this.handleJnlpFileException(launchDesc, (Exception)serializable);
        }
        if (!launchDesc.isJRESpecified()) {
            serializable = new LaunchDescException(launchDesc, "Internal Error: !isJRESpecified()", null);
            this.handleJnlpFileException(launchDesc, (Exception)serializable);
        }
        if ((serializable = launchDesc.getCanonicalHome()) == null) {
            LaunchDescException launchDescException = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.nomainjar"), null);
            throw new ExitException(launchDescException, 3);
        }
        if (bl4) {
            this._lap = Cache.getLocalApplicationProperties((String)stringArray[0]);
            if (this._lap == null || !Environment.isInstallMode()) {
                this.handleJnlpFileException(launchDesc, new MissingFieldException(launchDesc.getSource(), "<application-desc>|<applet-desc>"));
            }
            serializable = this._lap.getLocation();
        } else if (!launchDesc.isLibrary()) {
            this._lap = Cache.getLocalApplicationProperties((URL)serializable);
        }
        Trace.println((String)("LaunchDesc location: " + serializable), (TraceLevel)TraceLevel.BASIC);
        boolean bl5 = bl2 = this._isCached && DeployOfflineManager.isGlobalOffline();
        if (!_isImport && this._jreInfo == null) {
            String string;
            boolean bl6;
            if (bl) {
                throw new CacheUpdateRequiredException("Need to install JRE");
            }
            String string2 = Config.getProperty((String)"deployment.javaws.autodownload");
            if (string2 != null && string2.equalsIgnoreCase("NEVER")) {
                throw new ExitException(new NoLocalJREException(launchDesc, jREDesc.getVersion(), false), 3);
            }
            String string3 = jREDesc.getSource();
            URL uRL = jREDesc.getHref();
            boolean bl7 = bl6 = uRL == null;
            if (bl6) {
                string = Config.getProperty((String)"deployment.javaws.installURL");
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new ExitException(malformedURLException, 3);
                }
            }
            if ((string = DownloadEngine.getAvailableVersion((URL)uRL, (String)jREDesc.getVersion(), (boolean)bl6, (String)JREInfo.getKnownPlatforms())) == null) {
                string = jREDesc.getVersion();
            }
            if (SecureStaticVersioning.promptRequired(launchDesc, this._lap, true, string) ? !SecureStaticVersioning.promptDownload(null, launchDesc, this._lap, string, string3) : string2 != null && string2.equalsIgnoreCase("PROMPT") && !AutoDownloadPrompt.prompt(null, launchDesc)) {
                throw new ExitException(null, 0);
            }
        } else if (!_isImport && SecureStaticVersioning.promptRequired(launchDesc, this._lap, false, this._jreInfo.getProduct()) && !SecureStaticVersioning.promptUse(null, launchDesc, this._lap, this._jreInfo)) {
            throw new ExitException(null, 0);
        }
        return bl3;
    }

    private void prepareEnvironment(LaunchDesc launchDesc) throws ExitException {
        AppPolicy appPolicy = AppPolicy.createInstance(launchDesc.getCanonicalHome().getHost());
        this._jnlpClassLoader = JNLPClassLoader.createClassLoader(launchDesc, appPolicy);
        try {
            String string = "http";
            URL uRL = launchDesc.getCanonicalHome();
            if (uRL.getProtocol().equalsIgnoreCase("file") && uRL.getHost().equals("")) {
                string = "file";
            }
            BasicServiceImpl.initialize(launchDesc.getCodebase(), BrowserSupport.isWebBrowserSupported(), string);
            if (launchDesc.getLaunchType() == 4) {
                String string2 = this._lap.getInstallDirectory();
                if (string2 == null) {
                    string2 = Cache.getNewExtensionInstallDirectory();
                    this._lap.setInstallDirectory(string2);
                }
                ExtensionInstallerServiceImpl.initialize(launchDesc.isSecure() ? null : string2, this._lap, this._downloadWindowHelper.getProgressListener());
            }
        }
        catch (Throwable throwable) {
            throw new ExitException(throwable, 3);
        }
        System.setSecurityManager(new JavaWebStartSecurity());
    }

    private void prepareResources(LaunchDesc launchDesc, String[] stringArray, boolean bl, boolean bl2, boolean bl3, ArrayList arrayList) throws ExitException, CacheUpdateRequiredException {
        boolean bl4;
        boolean bl5;
        Object object;
        boolean bl6;
        PerfLogger.setTime((String)"Begin UpdateCheck");
        boolean bl7 = launchDesc.isInstaller();
        boolean bl8 = this._isCached && DeployOfflineManager.isGlobalOffline();
        boolean bl9 = !_isImport && this._jreInfo == null || bl7;
        boolean bl10 = bl6 = !this._isCached || bl9;
        if (bl6 && bl8) {
            throw new ExitException(new OfflineLaunchException(0), 3);
        }
        boolean bl11 = bl6;
        if (!bl8) {
            if (this._lap != null && this._lap.forceUpdateCheck()) {
                Trace.println((String)"Forced update check in LAP, do full update", (TraceLevel)TraceLevel.BASIC);
                bl11 = true;
            } else if (!bl2 && !launchDesc.getUpdate().isBackgroundCheck() && launchDesc.getUpdate().getPolicy() == 0) {
                bl11 = true;
            } else if (!bl2) {
                try {
                    bl11 = launchDesc.getUpdater().isUpdateAvailable();
                }
                catch (Exception exception) {
                    throw new ExitException(exception, 3);
                }
                if (bl11 && launchDesc.getUpdate().getPolicy() != 0) {
                    this._isCached = LaunchDownload.isInCache(launchDesc);
                    if (this._isCached) {
                        bl6 = bl9;
                    }
                }
                if (launchDesc.getUpdater().isCheckAborted()) {
                    throw new ExitException(new LaunchDescException(launchDesc, "User rejected cert - aborted", null), 4);
                }
            }
        }
        if (bl2 && bl11) {
            throw new CacheUpdateRequiredException("Need to update");
        }
        Trace.println((String)("Offline mode: " + bl8 + "\nIsInCache: " + this._isCached + "\nforceUpdate: " + bl6 + "\nneedUpdate: " + bl11 + "\nIsInstaller: " + bl7), (TraceLevel)TraceLevel.BASIC);
        if (bl11 && !bl6) {
            bl6 = launchDesc.getUpdater().needUpdatePerPolicy(this._downloadWindowHelper);
        }
        if (bl6 && bl8) {
            throw new ExitException(new OfflineLaunchException(0), 3);
        }
        if (bl6) {
            if (!_isImport && this._jreInfo == null) {
                this.downloadJREResource(launchDesc, arrayList);
                if (!arrayList.isEmpty()) {
                    JnlpxArgs.executeInstallers(arrayList, this._downloadWindowHelper.getProgressListener());
                    if (!this.isValidSpecificationVersion(launchDesc)) {
                        Config.getInstance().resetJavaHome();
                    }
                }
                object = Config.getJavaHome() + File.separator + "bin" + File.separator;
                Config.getInstance().notifyJREInstalled((String)object);
                this._jreInstalled = true;
            } else {
                if (Environment.getJavaFxInstallMode() != 0) {
                    this._javafx_install_initiated = true;
                }
                try {
                    this.downloadResources(launchDesc, arrayList, bl3);
                }
                catch (ExitException exitException) {
                    if (this._javafx_install_initiated) {
                        Throwable throwable = exitException.getException();
                        if (throwable instanceof FailedDownloadException) {
                            String string = ((FailedDownloadException)throwable).getLocation().toString();
                            Pings.sendJFXPing((String)"jfxic", (String)Launcher.getCurrentJavaFXVersion(), (String)Launcher.getRequestedJavaFXVersion(launchDesc), (int)3, (String)string);
                        } else {
                            Pings.sendJFXPing((String)"jfxic", (String)Launcher.getCurrentJavaFXVersion(), (String)Launcher.getRequestedJavaFXVersion(launchDesc), (int)2, null);
                        }
                    }
                    throw exitException;
                }
            }
            if (this._lap != null && this._lap.forceUpdateCheck()) {
                this._lap.setForceUpdateCheck(false);
                try {
                    this._lap.store();
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
            }
        } else {
            PerfLogger.setTime((String)"End UpdateCheck - Nothing to update");
        }
        if (this._jreInfo != null || _isImport) {
            SplashScreen.generateCustomSplash(null, launchDesc, bl);
            if (!_isImport && !arrayList.isEmpty()) {
                if (bl7) {
                    // empty if block
                }
                JnlpxArgs.executeInstallers(arrayList, this._downloadWindowHelper.getProgressListener());
            }
            if (!_isSilent) {
                object = "progress.title.app";
                if (launchDesc.getLaunchType() == 4) {
                    object = "progress.title.installer";
                }
                this._downloadWindowHelper.showLaunchingApplication((String)object);
            }
        }
        object = launchDesc.getJREMatcher();
        JVMParameters jVMParameters = object.getSelectedJVMParameters();
        this._jreInfo = object.getSelectedJREInfo();
        JREDesc jREDesc = object.getSelectedJREDesc();
        if (!_isImport) {
            if (!this.isValidSpecificationVersion(launchDesc)) {
                JNLPException.setDefaultLaunchDesc(launchDesc);
                this.handleJnlpFileException(launchDesc, new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.badjnlversion", (String)launchDesc.getSpecVersion()), null));
            }
            if (this._jreInfo == null) {
                Config.refreshProps();
                this._jreInfo = launchDesc.selectJRE();
                if (this._jreInfo == null) {
                    Trace.println((String)("No JREInfo(1): " + launchDesc.getJREMatcher()));
                    LaunchDescException launchDescException = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.missingjreversion"), null);
                    throw new ExitException(launchDescException, 3);
                }
                object = launchDesc.getJREMatcher();
                jREDesc = object.getSelectedJREDesc();
                jVMParameters = object.getSelectedJVMParameters();
            }
            bl5 = object.isRunningJVMSatisfying(true);
            if (Trace.isTraceLevelEnabled((TraceLevel)TraceLevel.BASIC)) {
                Trace.println((String)("_jreInstalled:    " + this._jreInstalled), (TraceLevel)TraceLevel.BASIC);
                Trace.println((String)object.toString(), (TraceLevel)TraceLevel.BASIC);
            }
            if (this._jreInstalled && bl5) {
                throw new ExitException(new Exception("Internal Error: jreInstalled, but homeJVM matches"), 3);
            }
            if (launchDesc.isSecureJVMArgs() && !bl5 && this._jreInfo != null) {
                if (!this._isRelaunch) {
                    long l = jREDesc.getMinHeap();
                    long l2 = jREDesc.getMaxHeap();
                    try {
                        stringArray = this.insertApplicationArgs(stringArray);
                        JnlpxArgs.execProgram(this._jreInfo, stringArray, l, l2, jVMParameters, false);
                    }
                    catch (IOException iOException) {
                        throw new ExitException(new JreExecException(this._jreInfo.getPath(), iOException), 3);
                    }
                    if (JnlpxArgs.shouldRemoveArgumentFile()) {
                        JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(false));
                    }
                    throw new ExitException(null, 0);
                }
                Trace.println((String)"JAVAWS: Relaunch ignored(1): relaunched already", (TraceLevel)TraceLevel.BASIC);
            }
        }
        JnlpxArgs.removeArgumentFile(stringArray[0]);
        PerfLogger.setTime((String)"End removeArgumentFile");
        if (_isImport) {
            this._downloadWindowHelper.disposeWindow();
            bl5 = LaunchDownload.isJnlpCached(launchDesc) && bl;
            Launcher.notifyLocalInstallHandler(launchDesc, this._lap, _isSilent, bl5, null);
            if (this._javafx_install_initiated) {
                Pings.sendJFXPing((String)"jfxic", (String)Launcher.getCurrentJavaFXVersion(), (String)Launcher.getRequestedJavaFXVersion(launchDesc), (int)0, null);
            }
            this.preverifyImportedJARs(launchDesc);
            Trace.println((String)"Exiting after import", (TraceLevel)TraceLevel.BASIC);
            throw new ExitException(null, 0);
        }
        final String string = " - " + launchDesc.getInformation().getTitle();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JavawsConsoleController.setTitle("console.caption", string);
                JavawsConsoleController.showConsoleIfEnable();
            }
        });
        boolean bl12 = false;
        try {
            PerfLogger.setTime((String)"Begin checkSignedLaunchDesc");
            LaunchDownload.checkSignedLaunchDesc(launchDesc);
            PerfLogger.setTime((String)"End checkSignedLaunchDesc");
            bl12 = LaunchDownload.checkSignedResources(launchDesc);
            bl12 = bl12 && launchDesc.isSigned();
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 3);
        }
        catch (IOException iOException) {
            throw new ExitException(iOException, 3);
        }
        if (Trace.isTraceLevelEnabled((TraceLevel)TraceLevel.BASIC)) {
            Trace.println((String)("passing security checks; secureArgs:" + launchDesc.isSecureJVMArgs() + ", allSigned:" + bl12), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("trusted app: " + !launchDesc.isSecure() + ", -secure=" + Globals.isSecureMode()), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)object.toString(), (TraceLevel)TraceLevel.BASIC);
        }
        if (!(bl4 = object.isRunningJVMSatisfying(bl12))) {
            if (!this._isRelaunch) {
                long l = jREDesc.getMinHeap();
                long l3 = jREDesc.getMaxHeap();
                try {
                    stringArray = this.insertApplicationArgs(stringArray);
                    JnlpxArgs.execProgram(this._jreInfo, stringArray, l, l3, jVMParameters, bl12);
                }
                catch (IOException iOException) {
                    throw new ExitException(new JreExecException(this._jreInfo.getPath(), iOException), 3);
                }
                if (JnlpxArgs.shouldRemoveArgumentFile()) {
                    JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(false));
                }
                throw new ExitException(null, 0);
            }
            Trace.println((String)"JAVAWS: Relaunch ignored(2): relaunched already", (TraceLevel)TraceLevel.BASIC);
        }
        if (Cache.isCacheEnabled() && (!LocalInstallHandler.getInstance().isShortcutExists(this._lap) || Globals.isIconImageUpdated())) {
            Launcher.notifyLocalInstallHandler(launchDesc, this._lap, _isSilent, bl || Globals.isIconImageUpdated(), this._downloadWindowHelper.getOwnerRef());
            if (Globals.isIconImageUpdated()) {
                Globals.setIconImageUpdated(false);
            }
        }
        Trace.println((String)"continuing launch in this VM", (TraceLevel)TraceLevel.BASIC);
    }

    private void prepareCustomProgress(LaunchDesc launchDesc, JARDesc jARDesc, final String string) throws ExitException {
        final CustomProgress customProgress = new CustomProgress();
        Progress.setCustomProgress(customProgress);
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Class<?> clazz = Launcher.this._jnlpClassLoader.loadClass(string);
                    final Class[] classArray = new Class[]{};
                    final Constructor<?> constructor = clazz.getConstructor(classArray);
                    final Object[] objectArray = new Object[1];
                    Runnable runnable = new Runnable(){

                        public void run() {
                            objectArray[0] = null;
                            try {
                                objectArray[0] = constructor.newInstance(classArray);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    };
                    ThreadGroup threadGroup = Main.getLaunchThreadGroup();
                    Thread thread = new Thread(threadGroup, runnable, "javawsApplicationMain");
                    thread.start();
                    try {
                        thread.join(5000L);
                        DownloadServiceListener downloadServiceListener = (DownloadServiceListener)objectArray[0];
                        customProgress.setAppThreadGroup(threadGroup);
                        customProgress.setListener(downloadServiceListener);
                        SplashScreen.hide();
                        Trace.println((String)"Custom Progress class setup OK", (TraceLevel)TraceLevel.BASIC);
                    }
                    catch (InterruptedException interruptedException) {
                        Trace.println((String)"Custom Progress class not constructed", (TraceLevel)TraceLevel.BASIC);
                        Trace.ignored((Throwable)interruptedException);
                    }
                    catch (ClassCastException classCastException) {
                        Trace.println((String)"CustomProgress class is not in an  mplementation of DownloadServiceListener", (TraceLevel)TraceLevel.BASIC);
                    }
                }
                catch (Exception exception) {
                    Trace.println((String)("Error generating custom progress : " + exception));
                    Trace.ignored((Throwable)exception);
                }
                finally {
                    if (customProgress.getListener() == null) {
                        Progress.setCustomProgress(null);
                    }
                }
            }
        });
        thread.start();
    }

    private void preverifyImportedJARs(LaunchDesc launchDesc) {
        if (Environment.getJavaFxInstallMode() == 1 || Environment.getJavaFxInstallMode() == 2) {
            try {
                LaunchDownload.checkSignedResources(launchDesc);
            }
            catch (JNLPException jNLPException) {
                Trace.ignoredException((Exception)jNLPException);
            }
            catch (ExitException exitException) {
                Trace.ignoredException((Exception)exitException);
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
            PreverificationClassLoader preverificationClassLoader = new PreverificationClassLoader(ClassLoader.getSystemClassLoader());
            preverificationClassLoader.initialize(launchDesc);
            preverificationClassLoader.preverifyJARs();
        }
    }

    private boolean isValidSpecificationVersion(LaunchDesc launchDesc) {
        VersionString versionString = new VersionString(launchDesc.getSpecVersion());
        return versionString.contains(new VersionID("6.0.18")) || versionString.contains(new VersionID("6.0.10")) || versionString.contains(new VersionID("6.0")) || versionString.contains(new VersionID("1.5")) || versionString.contains(new VersionID("1.0"));
    }

    private String[] insertApplicationArgs(String[] stringArray) {
        String[] stringArray2 = Globals.getApplicationArgs();
        if (stringArray2 == null) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray2.length + stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray3[i] = stringArray2[i];
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray3[i++] = stringArray[i];
        }
        return stringArray3;
    }

    private void doLaunchApp() throws ExitException {
        final JNLPClassLoader jNLPClassLoader = this._jnlpClassLoader;
        Thread.currentThread().setContextClassLoader(jNLPClassLoader);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    try {
                        Thread.currentThread().setContextClassLoader(jNLPClassLoader);
                    }
                    catch (Throwable throwable) {
                        Trace.ignored((Throwable)throwable);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Trace.ignoredException((Exception)interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Trace.ignoredException((Exception)invocationTargetException);
        }
        String string = null;
        Class<?> clazz = null;
        try {
            string = LaunchDownload.getMainClassName(this._launchDesc, true);
            Trace.println((String)("Main-class: " + string), (TraceLevel)TraceLevel.BASIC);
            if (string == null) {
                throw new ClassNotFoundException(string);
            }
            PerfLogger.setTime((String)"Begin load main class ");
            clazz = jNLPClassLoader.loadClass(string);
            PerfLogger.setTime((String)"End load main class ");
            if (this.getClass().getPackage().equals(clazz.getPackage())) {
                throw new ClassNotFoundException(string);
            }
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader != jNLPClassLoader && classLoader != jNLPClassLoader.getJNLPPreverifyClassLoader()) {
                SecurityException securityException = new SecurityException("Bad main-class name");
                throw new ExitException(securityException, 3);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExitException(classNotFoundException, 3);
        }
        catch (IOException iOException) {
            throw new ExitException(iOException, 3);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 3);
        }
        catch (Exception exception) {
            throw new ExitException(exception, 3);
        }
        catch (Throwable throwable) {
            throw new ExitException(throwable, 3);
        }
        try {
            this._downloadWindowHelper.disable();
            if (Globals.TCKHarnessRun) {
                Main.tckprintln("JNLP Launching");
            }
            PerfLogger.setTime((String)"calling executeMainClass ...");
            this.executeMainClass(this._launchDesc, this._lap, clazz, this._downloadWindowHelper);
        }
        catch (SecurityException securityException) {
            throw new ExitException(securityException, 3);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ExitException(illegalAccessException, 3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExitException(illegalArgumentException, 3);
        }
        catch (InstantiationException instantiationException) {
            throw new ExitException(instantiationException, 3);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exception exception = invocationTargetException;
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof Exception) {
                exception = (Exception)invocationTargetException.getTargetException();
            } else {
                throwable.printStackTrace();
            }
            throw new ExitException(exception, 3);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ExitException(noSuchMethodException, 3);
        }
        catch (Throwable throwable) {
            throw new ExitException(throwable, 3);
        }
        if (this._launchDesc.getLaunchType() == 4) {
            throw new ExitException(null, 0);
        }
    }

    private void downloadJREResource(LaunchDesc launchDesc, ArrayList arrayList) throws ExitException {
        if (!this._shownDownloadWindow && !_isSilent) {
            this._shownDownloadWindow = true;
            this._downloadWindowHelper.showLoadingProgressScreen();
            this._downloadWindowHelper.setVisible(true);
        }
        try {
            if (!Cache.isCacheEnabled()) {
                throw new IOException("Cache disabled, cannot download JRE");
            }
            LaunchDownload.downloadJRE(launchDesc, this._downloadWindowHelper.getProgressListener(), arrayList);
        }
        catch (SecurityException securityException) {
            throw new ExitException(securityException, 3);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 3);
        }
        catch (IOException iOException) {
            Trace.ignored((Throwable)iOException);
            throw new ExitException(new NoLocalJREException(launchDesc, launchDesc.getResources().getSelectedJRE().getVersion(), false), 3);
        }
    }

    private void downloadResources(LaunchDesc launchDesc, ArrayList arrayList, boolean bl) throws ExitException {
        if (!this._shownDownloadWindow && !_isSilent) {
            this._shownDownloadWindow = true;
            this._downloadWindowHelper.showLoadingProgressScreen();
            this._downloadWindowHelper.setVisible(true);
        }
        try {
            if (!bl) {
                LaunchDownload.downloadExtensions(launchDesc, this._downloadWindowHelper.getProgressListener(), 0, arrayList);
            }
            LaunchDownload.checkJNLPSecurity(launchDesc);
            LaunchDownload.downloadEagerorAll(launchDesc, false, this._downloadWindowHelper.getProgressListener(), false);
        }
        catch (SecurityException securityException) {
            throw new ExitException(securityException, 3);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 3);
        }
        catch (IOException iOException) {
            if (launchDesc.getInformation().supportsOfflineOperation() && LaunchDownload.isInCache(launchDesc, bl)) {
                Trace.ignoredException((Exception)iOException);
            }
            throw new ExitException(iOException, 3);
        }
    }

    public static void notifyLocalInstallHandler(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl, boolean bl2, ComponentRef componentRef) {
        LocalInstallHandler localInstallHandler;
        if (localApplicationProperties == null) {
            return;
        }
        URL uRL = LaunchDescFactory.getDerivedCodebase();
        if (uRL != null) {
            localApplicationProperties.setCodebase(uRL.toString());
        }
        localApplicationProperties.setLastAccessed(new Date());
        if (!_isImport) {
            localApplicationProperties.incrementLaunchCount();
        }
        if ((localInstallHandler = LocalInstallHandler.getInstance()) != null) {
            localInstallHandler.install(launchDesc, localApplicationProperties, bl2, bl, componentRef);
        }
        try {
            localApplicationProperties.store();
        }
        catch (IOException iOException) {
            Trace.println((String)("Couldn't save LAP: " + iOException), (TraceLevel)TraceLevel.BASIC);
        }
    }

    private void executeMainClass(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Class clazz, DownloadWindowHelper downloadWindowHelper) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (launchDesc.getLaunchType() == 2) {
            boolean bl;
            String string = null;
            String string2 = null;
            boolean bl2 = false;
            if (localApplicationProperties != null) {
                string = localApplicationProperties.getCodebase();
                string2 = localApplicationProperties.getDocumentBase();
                bl2 = localApplicationProperties.isDraggedApplet();
            }
            boolean bl3 = bl = !bl2 && (string == null || string2 == null);
            if (bl) {
                AppletDesc appletDesc = launchDesc.getAppletDescriptor();
                URL uRL = BasicServiceImpl.getInstance().getCodeBase();
                URL uRL2 = appletDesc.getDocumentBase();
                if (uRL2 == null) {
                    uRL2 = uRL;
                }
                string = uRL != null ? uRL.toString() : null;
                String string3 = string2 = uRL2 != null ? uRL2.toString() : null;
                if (string2 == null) {
                    string2 = launchDesc.getCanonicalHome().toString();
                }
            }
            this.executeApplet(launchDesc, clazz, downloadWindowHelper, localApplicationProperties, string, string2, bl);
        } else {
            this.executeApplication(launchDesc, localApplicationProperties, clazz, downloadWindowHelper);
        }
    }

    private void executeApplication(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Class clazz, DownloadWindowHelper downloadWindowHelper) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        PerfLogger.setTime((String)"Begin executeApplication");
        String[] stringArray = null;
        if (launchDesc.getLaunchType() == 4) {
            downloadWindowHelper.reset();
            stringArray = new String[]{localApplicationProperties.isLocallyInstalled() ? "uninstall" : "install"};
            localApplicationProperties.setLocallyInstalled(false);
            localApplicationProperties.setRebootNeeded(false);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        } else {
            downloadWindowHelper.disposeWindow();
            SplashScreen.hide();
            stringArray = Globals.getApplicationArgs() != null ? Globals.getApplicationArgs() : launchDesc.getApplicationDescriptor().getArguments();
        }
        Object[] objectArray = new Object[]{stringArray};
        Class[] classArray = new Class[]{new String[0].getClass()};
        Method method = clazz.getMethod("main", classArray);
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodException(ResourceManager.getString((String)"launch.error.nonstaticmainmethod"));
        }
        method.setAccessible(true);
        PerfLogger.setTime((String)"End executeApplication (invoking App main)");
        method.invoke(null, objectArray);
    }

    private void executeApplet(LaunchDesc launchDesc, Class clazz, DownloadWindowHelper downloadWindowHelper, LocalApplicationProperties localApplicationProperties, String string, String string2, boolean bl) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        try {
            Class<?> clazz2 = null;
            clazz2 = Class.forName("sun.plugin2.applet.viewer.JNLP2Viewer");
            downloadWindowHelper.disposeWindow();
            SplashScreen.hide();
            Class[] classArray = new Class[]{new String[0].getClass()};
            Method method = clazz2.getMethod("main", classArray);
            method.setAccessible(true);
            URL uRL = launchDesc.getCanonicalHome();
            File file = null;
            try {
                file = DownloadEngine.getCachedFile((URL)uRL);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (file != null) {
                Object[] objectArray;
                String[] stringArray = null;
                stringArray = !bl ? ((objectArray = SingleInstanceManager.getActionName()) != null && (objectArray.equals("-open") || objectArray.equals("-print")) ? new String[]{objectArray, SingleInstanceManager.getOpenPrintFilePath(), file.toString()} : (localApplicationProperties.isDraggedApplet() ? new String[]{"-draggedApplet", file.toString()} : new String[]{file.toString()})) : new String[]{"-codebase", string, "-documentbase", string2, file.toString()};
                objectArray = new Object[]{stringArray};
                DeployOfflineManager.setForcedOffline((boolean)false);
                method.invoke(null, objectArray);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AppletDesc appletDesc = launchDesc.getAppletDescriptor();
            int n = appletDesc.getWidth();
            int n2 = appletDesc.getHeight();
            Applet applet = null;
            applet = (Applet)clazz.newInstance();
            downloadWindowHelper.disposeWindow();
            SplashScreen.hide();
            final JFrame jFrame = new JFrame();
            boolean bl2 = BrowserSupport.isWebBrowserSupported();
            AppletContainerCallback appletContainerCallback = new AppletContainerCallback(){

                public void showDocument(URL uRL) {
                    BrowserSupport.showDocument(uRL);
                }

                public void relativeResize(Dimension dimension) {
                    Dimension dimension2 = jFrame.getSize();
                    dimension2.width += dimension.width;
                    dimension2.height += dimension.height;
                    jFrame.setSize(dimension2);
                }
            };
            URL uRL = BasicServiceImpl.getInstance().getCodeBase();
            URL uRL2 = appletDesc.getDocumentBase();
            if (uRL2 == null) {
                uRL2 = uRL;
            }
            final AppletContainer appletContainer = new AppletContainer(appletContainerCallback, applet, appletDesc.getName(), uRL2, uRL, n, n2, appletDesc.getParameters());
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    appletContainer.stopApplet();
                }
            });
            jFrame.setTitle(launchDesc.getInformation().getTitle());
            Container container = jFrame.getContentPane();
            container.setLayout(new BorderLayout());
            container.add("Center", appletContainer);
            jFrame.pack();
            Dimension dimension = appletContainer.getPreferredFrameSize(jFrame);
            jFrame.setSize(dimension);
            jFrame.getRootPane().revalidate();
            jFrame.getRootPane().repaint();
            jFrame.setResizable(false);
            if (!jFrame.isVisible()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        jFrame.setVisible(true);
                    }
                });
            }
            appletContainer.startApplet();
        }
    }

    private void handleJnlpFileException(LaunchDesc launchDesc, Exception exception) throws ExitException {
        DownloadEngine.removeCachedResource((URL)launchDesc.getCanonicalHome(), null, null);
        throw new ExitException(exception, 3);
    }

    class CacheUpdateRequiredException
    extends Exception {
        public CacheUpdateRequiredException(String string) {
            super(string);
        }
    }
}

