/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server;

import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.binding.soap.SOAPBindingImpl;
import com.sun.xml.internal.ws.model.RuntimeModel;
import com.sun.xml.internal.ws.modeler.RuntimeModeler;
import com.sun.xml.internal.ws.server.DocInfo;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.server.WSDLGenResolver;
import com.sun.xml.internal.ws.server.provider.ProviderModel;
import com.sun.xml.internal.ws.spi.runtime.Binding;
import com.sun.xml.internal.ws.spi.runtime.WebServiceContext;
import com.sun.xml.internal.ws.util.HandlerAnnotationInfo;
import com.sun.xml.internal.ws.util.HandlerAnnotationProcessor;
import com.sun.xml.internal.ws.util.localization.LocalizableMessageFactory;
import com.sun.xml.internal.ws.util.localization.Localizer;
import com.sun.xml.internal.ws.wsdl.parser.RuntimeWSDLParser;
import com.sun.xml.internal.ws.wsdl.parser.Service;
import com.sun.xml.internal.ws.wsdl.parser.WSDLDocument;
import com.sun.xml.internal.ws.wsdl.writer.WSDLGenerator;
import com.sun.xml.internal.ws.wsdl.writer.WSDLOutputResolver;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.SOAPBinding;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeEndpointInfo
implements com.sun.xml.internal.ws.spi.runtime.RuntimeEndpointInfo {
    private String name;
    private QName portName;
    private QName serviceName;
    private String wsdlFileName;
    private boolean deployed;
    private String urlPattern;
    private List<Source> metadata;
    private Binding binding;
    private RuntimeModel runtimeModel;
    private Object implementor;
    private Class implementorClass;
    private Map<String, DocInfo> docs;
    private Map<String, DocInfo> query2Doc;
    private WebServiceContext wsContext;
    private boolean beginServiceDone;
    private boolean endServiceDone;
    private boolean injectedContext;
    private URL wsdlUrl;
    private EntityResolver wsdlResolver;
    private QName portTypeName;
    private Integer mtomThreshold;
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.endpoint");
    private static final Localizer localizer = new Localizer();
    private static final LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("com.sun.xml.internal.ws.resources.server");
    private WebService ws;
    private WebServiceProvider wsProvider;
    private ProviderModel providerModel;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public String getWSDLFileName() {
        return this.wsdlFileName;
    }

    public void setWSDLFileName(String string) {
        this.wsdlFileName = string;
    }

    @Override
    public void setWsdlInfo(URL uRL, EntityResolver entityResolver) {
        this.wsdlUrl = uRL;
        this.wsdlResolver = entityResolver;
    }

    public EntityResolver getWsdlResolver() {
        return this.wsdlResolver;
    }

    public URL getWsdlUrl() {
        return this.wsdlUrl;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public void createProviderModel() {
        this.providerModel = new ProviderModel(this.implementorClass, this.binding);
    }

    public void createSEIModel() {
        if (this.wsdlUrl == null) {
            RuntimeModeler runtimeModeler = new RuntimeModeler(this.getImplementorClass(), this.getImplementor(), this.getServiceName(), ((BindingImpl)this.binding).getBindingId());
            if (this.getPortName() != null) {
                runtimeModeler.setPortName(this.getPortName());
            }
            this.runtimeModel = runtimeModeler.buildRuntimeModel();
        } else {
            try {
                Object object;
                WSDLDocument wSDLDocument = RuntimeWSDLParser.parse(this.getWsdlUrl(), this.getWsdlResolver());
                com.sun.xml.internal.ws.wsdl.parser.Binding binding = null;
                if (this.serviceName == null) {
                    this.serviceName = RuntimeModeler.getServiceName(this.getImplementorClass());
                }
                if (this.getPortName() != null) {
                    binding = wSDLDocument.getBinding(this.getServiceName(), this.getPortName());
                    if (binding == null) {
                        throw new ServerRtException("runtime.parser.wsdl.incorrectserviceport", this.serviceName, this.portName, this.getWsdlUrl());
                    }
                } else {
                    object = wSDLDocument.getService(this.serviceName);
                    if (object == null) {
                        throw new ServerRtException("runtime.parser.wsdl.noservice", this.serviceName, this.getWsdlUrl());
                    }
                    String string = ((BindingImpl)this.binding).getBindingId();
                    List<com.sun.xml.internal.ws.wsdl.parser.Binding> list = wSDLDocument.getBindings((Service)object, string);
                    if (list.size() == 0) {
                        throw new ServerRtException("runtime.parser.wsdl.nobinding", string, this.serviceName, this.getWsdlUrl());
                    }
                    if (list.size() > 1) {
                        throw new ServerRtException("runtime.parser.wsdl.multiplebinding", string, this.serviceName, this.getWsdlUrl());
                    }
                }
                object = new RuntimeModeler(this.getImplementorClass(), this.getImplementor(), this.getServiceName(), binding);
                if (this.getPortName() != null) {
                    ((RuntimeModeler)object).setPortName(this.getPortName());
                }
                this.runtimeModel = ((RuntimeModeler)object).buildRuntimeModel();
            }
            catch (IOException iOException) {
                throw new ServerRtException("runtime.parser.wsdl", this.getWsdlUrl().toString());
            }
            catch (XMLStreamException xMLStreamException) {
                throw new ServerRtException("runtime.saxparser.exception", xMLStreamException.getMessage(), xMLStreamException.getLocation());
            }
            catch (SAXException sAXException) {
                throw new ServerRtException("runtime.parser.wsdl", this.getWsdlUrl().toString());
            }
        }
    }

    public boolean isProviderEndpoint() {
        WebServiceProvider webServiceProvider = this.getImplementorClass().getAnnotation(WebServiceProvider.class);
        return webServiceProvider != null;
    }

    public void doServiceNameProcessing() {
        if (this.getServiceName() == null) {
            if (this.isProviderEndpoint()) {
                WebServiceProvider webServiceProvider = this.getImplementorClass().getAnnotation(WebServiceProvider.class);
                String string = webServiceProvider.targetNamespace();
                String string2 = webServiceProvider.serviceName();
                this.setServiceName(new QName(string, string2));
            } else {
                this.setServiceName(RuntimeModeler.getServiceName(this.getImplementorClass()));
            }
        }
    }

    public void doPortNameProcessing() {
        if (this.getPortName() == null) {
            if (this.isProviderEndpoint()) {
                WebServiceProvider webServiceProvider = this.getImplementorClass().getAnnotation(WebServiceProvider.class);
                String string = webServiceProvider.targetNamespace();
                String string2 = webServiceProvider.portName();
                this.setPortName(new QName(string, string2));
            } else {
                this.setPortName(RuntimeModeler.getPortName(this.getImplementorClass(), this.getServiceName().getNamespaceURI()));
            }
        } else {
            String string;
            String string3 = this.getServiceName().getNamespaceURI();
            if (!string3.equals(string = this.getPortName().getNamespaceURI())) {
                throw new ServerRtException("wrong.tns.for.port", string, string3);
            }
        }
    }

    public void doPortTypeNameProcessing() {
        if (this.getPortTypeName() == null && !this.isProviderEndpoint()) {
            this.setPortTypeName(RuntimeModeler.getPortTypeName(this.getImplementorClass()));
        }
    }

    @Override
    public void init() {
        String string;
        if (this.implementor == null) {
            throw new ServerRtException("null.implementor", new Object[0]);
        }
        if (this.implementorClass == null) {
            this.setImplementorClass(this.getImplementor().getClass());
        }
        this.verifyImplementorClass();
        this.doServiceNameProcessing();
        this.doPortNameProcessing();
        if (this.binding == null) {
            string = RuntimeModeler.getBindingId(this.getImplementorClass());
            this.setBinding(new SOAPBindingImpl("http://schemas.xmlsoap.org/wsdl/soap/http"));
        }
        if (this.isProviderEndpoint()) {
            this.checkProvider();
            this.createProviderModel();
        } else {
            this.createSEIModel();
            if (this.getServiceName() == null) {
                this.setServiceName(this.runtimeModel.getServiceQName());
            }
            if (this.getPortName() == null) {
                this.setPortName(this.runtimeModel.getPortName());
            }
            if (this.binding instanceof SOAPBindingImpl) {
                this.runtimeModel.enableMtom(((SOAPBinding)((Object)this.binding)).isMTOMEnabled());
            }
        }
        if (this.getBinding().getHandlerChain() == null) {
            string = ((BindingImpl)this.binding).getActualBindingId();
            HandlerAnnotationInfo handlerAnnotationInfo = HandlerAnnotationProcessor.buildHandlerInfo(this.implementorClass, this.getServiceName(), this.getPortName(), string);
            if (handlerAnnotationInfo != null) {
                this.getBinding().setHandlerChain(handlerAnnotationInfo.getHandlers());
                if (this.getBinding() instanceof SOAPBinding) {
                    ((SOAPBinding)((Object)this.getBinding())).setRoles(handlerAnnotationInfo.getRoles());
                }
            }
        }
        this.deployed = true;
    }

    public boolean needWSDLGeneration() {
        if (this.isProviderEndpoint()) {
            return false;
        }
        return this.getWsdlUrl() == null;
    }

    public void generateWSDL() {
        Object object;
        BindingImpl bindingImpl = (BindingImpl)this.getBinding();
        String string = bindingImpl.getActualBindingId();
        if (!(string.equals("http://schemas.xmlsoap.org/wsdl/soap/http") || string.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || string.equals("http://java.sun.com/xml/ns/jaxws/2003/05/soap/bindings/HTTP/"))) {
            throw new ServerRtException("can.not.generate.wsdl", string);
        }
        if (string.equals("http://java.sun.com/xml/ns/jaxws/2003/05/soap/bindings/HTTP/")) {
            object = localizer.localize(messageFactory.getMessage("generate.non.standard.wsdl", new Object[0]));
            logger.warning((String)object);
        }
        if (this.getDocMetadata() == null) {
            this.setMetadata(new HashMap<String, DocInfo>());
        }
        object = new WSDLGenResolver(this.getDocMetadata());
        WSDLGenerator wSDLGenerator = new WSDLGenerator(this.runtimeModel, (WSDLOutputResolver)object, ((BindingImpl)this.binding).getBindingId());
        try {
            wSDLGenerator.doGeneration();
        }
        catch (Exception exception) {
            throw new ServerRtException("server.rt.err", new Object[]{exception});
        }
        this.setWSDLFileName(((WSDLGenResolver)object).getWSDLFile());
    }

    private void checkProvider() {
        if (!Provider.class.isAssignableFrom(this.getImplementorClass())) {
            throw new ServerRtException("not.implement.provider", this.getImplementorClass());
        }
    }

    public QName getPortName() {
        return this.portName;
    }

    @Override
    public void setPortName(QName qName) {
        this.portName = qName;
    }

    public QName getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(QName qName) {
        this.portTypeName = qName;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    @Override
    public void setServiceName(QName qName) {
        this.serviceName = qName;
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public String getUrlPatternWithoutStar() {
        if (this.urlPattern.endsWith("/*")) {
            return this.urlPattern.substring(0, this.urlPattern.length() - 2);
        }
        return this.urlPattern;
    }

    public void setUrlPattern(String string) {
        this.urlPattern = string;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    public List<Source> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<Source> list) {
        this.metadata = list;
    }

    public RuntimeModel getRuntimeModel() {
        return this.runtimeModel;
    }

    @Override
    public Object getImplementor() {
        return this.implementor;
    }

    @Override
    public void setImplementor(Object object) {
        this.implementor = object;
    }

    @Override
    public Class getImplementorClass() {
        if (this.implementorClass == null) {
            this.implementorClass = this.implementor.getClass();
        }
        return this.implementorClass;
    }

    @Override
    public void setImplementorClass(Class clazz) {
        this.implementorClass = clazz;
    }

    public void setMetadata(Map<String, DocInfo> map) {
        this.docs = map;
    }

    private void updateQuery2DocInfo() {
        if (this.query2Doc != null) {
            this.query2Doc.clear();
        } else {
            this.query2Doc = new HashMap<String, DocInfo>();
        }
        Set<Map.Entry<String, DocInfo>> set = this.docs.entrySet();
        for (Map.Entry<String, DocInfo> entry : set) {
            DocInfo docInfo = entry.getValue();
            if (docInfo.getQueryString().equals("wsdl")) {
                this.query2Doc.put("WSDL", docInfo);
            }
            this.query2Doc.put(docInfo.getQueryString(), docInfo);
        }
    }

    @Override
    public WebServiceContext getWebServiceContext() {
        return this.wsContext;
    }

    @Override
    public void setWebServiceContext(WebServiceContext webServiceContext) {
        this.wsContext = webServiceContext;
    }

    public Map<String, DocInfo> getDocMetadata() {
        return this.docs;
    }

    public String getQueryString(URL uRL) {
        Set<Map.Entry<String, DocInfo>> set = this.getDocMetadata().entrySet();
        for (Map.Entry<String, DocInfo> entry : set) {
            if (!entry.getValue().getUrl().toString().equals(uRL.toString())) continue;
            return entry.getValue().getQueryString();
        }
        return null;
    }

    public String getPath(String string) {
        if (this.query2Doc != null) {
            DocInfo docInfo = this.query2Doc.get(string);
            return docInfo == null ? null : docInfo.getUrl().toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void injectContext() throws IllegalAccessException, InvocationTargetException {
        if (this.injectedContext) {
            return;
        }
        try {
            this.doFieldsInjection();
            this.doMethodsInjection();
        }
        finally {
            this.injectedContext = true;
        }
    }

    private void doFieldsInjection() {
        Field[] fieldArray;
        Class clazz = this.getImplementorClass();
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            Resource resource = field.getAnnotation(Resource.class);
            if (resource == null) continue;
            Class clazz2 = resource.type();
            Class<javax.xml.ws.WebServiceContext> clazz3 = field.getType();
            if (clazz2.equals(Object.class)) {
                if (!clazz3.equals(javax.xml.ws.WebServiceContext.class)) continue;
                this.injectField(field);
                continue;
            }
            if (!clazz2.equals(javax.xml.ws.WebServiceContext.class)) continue;
            if (clazz3.isAssignableFrom(javax.xml.ws.WebServiceContext.class)) {
                this.injectField(field);
                continue;
            }
            throw new ServerRtException("wrong.field.type", field.getName());
        }
    }

    private void doMethodsInjection() {
        Method[] methodArray;
        Class clazz = this.getImplementorClass();
        for (Method method : methodArray = clazz.getDeclaredMethods()) {
            Resource resource = method.getAnnotation(Resource.class);
            if (resource == null) continue;
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != 1) {
                throw new ServerRtException("wrong.no.parameters", method.getName());
            }
            Class clazz2 = resource.type();
            Class<javax.xml.ws.WebServiceContext> clazz3 = classArray[0];
            if (clazz2.equals(Object.class) && clazz3.equals(javax.xml.ws.WebServiceContext.class)) {
                this.invokeMethod(method, new Object[]{this.wsContext});
                continue;
            }
            if (!clazz2.equals(javax.xml.ws.WebServiceContext.class)) continue;
            if (clazz3.isAssignableFrom(javax.xml.ws.WebServiceContext.class)) {
                this.invokeMethod(method, new Object[]{this.wsContext});
                continue;
            }
            throw new ServerRtException("wrong.parameter.type", method.getName());
        }
    }

    private void injectField(final Field field) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalAccessException, InvocationTargetException {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    field.set(RuntimeEndpointInfo.this.implementor, RuntimeEndpointInfo.this.wsContext);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new ServerRtException("server.rt.err", new Object[]{privilegedActionException.getException()});
        }
    }

    private void invokeMethod(final Method method, final Object[] objectArray) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalAccessException, InvocationTargetException {
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    method.invoke(RuntimeEndpointInfo.this.implementor, objectArray);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new ServerRtException("server.rt.err", new Object[]{privilegedActionException.getException()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void beginService() {
        if (this.beginServiceDone) {
            return;
        }
        try {
            this.invokeOnceMethod(PostConstruct.class);
        }
        finally {
            this.beginServiceDone = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void endService() {
        if (this.endServiceDone) {
            return;
        }
        try {
            this.invokeOnceMethod(PreDestroy.class);
            this.destroy();
        }
        finally {
            this.endServiceDone = true;
        }
    }

    private void invokeOnceMethod(Class clazz) {
        Class clazz2 = this.getImplementorClass();
        Method[] methodArray = clazz2.getDeclaredMethods();
        boolean bl = false;
        for (Method method : methodArray) {
            if (method.getAnnotation(clazz) == null) continue;
            if (bl) {
                throw new ServerRtException("annotation.only.once", clazz);
            }
            if (method.getParameterTypes().length != 0) {
                throw new ServerRtException("not.zero.parameters", method.getName());
            }
            this.invokeMethod(method, new Object[0]);
            bl = true;
        }
    }

    @Override
    public void destroy() {
        List<Handler> list;
        Binding binding = this.getBinding();
        if (binding != null && (list = binding.getHandlerChain()) != null) {
            block2: for (Handler handler : list) {
                for (Method method : handler.getClass().getMethods()) {
                    if (method.getAnnotation(PreDestroy.class) == null) continue;
                    try {
                        method.invoke(handler, new Object[0]);
                    }
                    catch (Exception exception) {
                        logger.warning("exception ignored from handler @PreDestroy method: " + exception.getMessage());
                    }
                    continue block2;
                }
            }
        }
    }

    public Integer getMtomThreshold() {
        return this.mtomThreshold;
    }

    public void setMtomThreshold(int n) {
        this.mtomThreshold = n;
    }

    public static void fillDocInfo(RuntimeEndpointInfo runtimeEndpointInfo) throws XMLStreamException {
        Map<String, DocInfo> map = runtimeEndpointInfo.getDocMetadata();
        if (map != null) {
            for (Map.Entry<String, DocInfo> entry : map.entrySet()) {
                RuntimeWSDLParser.fillDocInfo(entry.getValue(), runtimeEndpointInfo.getServiceName(), runtimeEndpointInfo.getPortTypeName());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void publishWSDLDocs(RuntimeEndpointInfo runtimeEndpointInfo) {
        Object object;
        Object object22;
        Map<String, DocInfo> map = runtimeEndpointInfo.getDocMetadata();
        if (map == null) {
            return;
        }
        Set<Map.Entry<String, DocInfo>> set = map.entrySet();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Map.Entry<String, DocInfo> object3 : set) {
            Iterator iterator = object3.getValue();
            object22 = iterator.getDocType();
            object = iterator.getQueryString();
            if (object != null || object22 == null) continue;
            switch (3.$SwitchMap$com$sun$xml$internal$ws$server$DocInfo$DOC_TYPE[((Enum)object22).ordinal()]) {
                case 1: {
                    arrayList.add(object3.getKey());
                    break;
                }
                case 2: {
                    arrayList2.add(object3.getKey());
                    break;
                }
            }
        }
        Collections.sort(arrayList);
        int n = 1;
        for (Iterator iterator : arrayList) {
            object22 = map.get(iterator);
            object22.setQueryString("wsdl=" + n++);
        }
        Collections.sort(arrayList2);
        boolean bl = true;
        for (Object object22 : arrayList2) {
            void var6_10;
            object = map.get(object22);
            object.setQueryString("xsd=" + (int)(++var6_10));
        }
        runtimeEndpointInfo.updateQuery2DocInfo();
    }

    public void verifyImplementorClass() {
        if (this.wsProvider == null) {
            this.wsProvider = this.implementorClass.getAnnotation(WebServiceProvider.class);
        }
        if (this.ws == null) {
            this.ws = this.implementorClass.getAnnotation(WebService.class);
        }
        if (this.wsProvider == null && this.ws == null) {
            throw new ServerRtException("no.ws.annotation", this.implementorClass);
        }
        if (this.wsProvider != null && this.ws != null) {
            throw new ServerRtException("both.ws.annotations", this.implementorClass);
        }
    }

    public String getWsdlLocation() {
        if (this.wsProvider != null && this.wsProvider.wsdlLocation().length() > 0) {
            return this.wsProvider.wsdlLocation();
        }
        if (this.ws != null && this.ws.wsdlLocation().length() > 0) {
            return this.ws.wsdlLocation();
        }
        return null;
    }

    public ProviderModel getProviderModel() {
        return this.providerModel;
    }

    static class 3 {
        static final /* synthetic */ int[] $SwitchMap$com$sun$xml$internal$ws$server$DocInfo$DOC_TYPE;

        static {
            $SwitchMap$com$sun$xml$internal$ws$server$DocInfo$DOC_TYPE = new int[DocInfo.DOC_TYPE.values().length];
            try {
                3.$SwitchMap$com$sun$xml$internal$ws$server$DocInfo$DOC_TYPE[DocInfo.DOC_TYPE.WSDL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                3.$SwitchMap$com$sun$xml$internal$ws$server$DocInfo$DOC_TYPE[DocInfo.DOC_TYPE.SCHEMA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                3.$SwitchMap$com$sun$xml$internal$ws$server$DocInfo$DOC_TYPE[DocInfo.DOC_TYPE.OTHER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

