/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.AccessFlags;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.SourceFile;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.util.ClassQueue;
import com.sun.org.apache.bcel.internal.util.ClassVector;
import com.sun.org.apache.bcel.internal.util.Repository;
import com.sun.org.apache.bcel.internal.util.SyntheticRepository;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class JavaClass
extends AccessFlags
implements Cloneable,
Node {
    private String file_name;
    private String package_name;
    private String source_file_name = "<Unknown>";
    private int class_name_index;
    private int superclass_name_index;
    private String class_name;
    private String superclass_name;
    private int major;
    private int minor;
    private ConstantPool constant_pool;
    private int[] interfaces;
    private String[] interface_names;
    private Field[] fields;
    private Method[] methods;
    private Attribute[] attributes;
    private byte source = 1;
    public static final byte HEAP = 1;
    public static final byte FILE = 2;
    public static final byte ZIP = 3;
    static boolean debug = false;
    static char sep = (char)47;
    private transient Repository repository = SyntheticRepository.getInstance();

    public JavaClass(int n, int n2, String string, int n3, int n4, int n5, ConstantPool constantPool, int[] nArray, Field[] fieldArray, Method[] methodArray, Attribute[] attributeArray, byte by) {
        int n6;
        if (nArray == null) {
            nArray = new int[]{};
        }
        if (attributeArray == null) {
            this.attributes = new Attribute[0];
        }
        if (fieldArray == null) {
            fieldArray = new Field[]{};
        }
        if (methodArray == null) {
            methodArray = new Method[]{};
        }
        this.class_name_index = n;
        this.superclass_name_index = n2;
        this.file_name = string;
        this.major = n3;
        this.minor = n4;
        this.access_flags = n5;
        this.constant_pool = constantPool;
        this.interfaces = nArray;
        this.fields = fieldArray;
        this.methods = methodArray;
        this.attributes = attributeArray;
        this.source = by;
        for (n6 = 0; n6 < attributeArray.length; ++n6) {
            if (!(attributeArray[n6] instanceof SourceFile)) continue;
            this.source_file_name = ((SourceFile)attributeArray[n6]).getSourceFileName();
            break;
        }
        this.class_name = constantPool.getConstantString(n, (byte)7);
        this.class_name = Utility.compactClassName(this.class_name, false);
        n6 = this.class_name.lastIndexOf(46);
        this.package_name = n6 < 0 ? "" : this.class_name.substring(0, n6);
        if (n2 > 0) {
            this.superclass_name = constantPool.getConstantString(n2, (byte)7);
            this.superclass_name = Utility.compactClassName(this.superclass_name, false);
        } else {
            this.superclass_name = "java.lang.Object";
        }
        this.interface_names = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            String string2 = constantPool.getConstantString(nArray[i], (byte)7);
            this.interface_names[i] = Utility.compactClassName(string2, false);
        }
    }

    public JavaClass(int n, int n2, String string, int n3, int n4, int n5, ConstantPool constantPool, int[] nArray, Field[] fieldArray, Method[] methodArray, Attribute[] attributeArray) {
        this(n, n2, string, n3, n4, n5, constantPool, nArray, fieldArray, methodArray, attributeArray, 1);
    }

    public void accept(Visitor visitor) {
        visitor.visitJavaClass(this);
    }

    static final void Debug(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    public void dump(File file) throws IOException {
        File file2;
        String string = file.getParent();
        if (string != null && (file2 = new File(string)) != null) {
            file2.mkdirs();
        }
        this.dump(new DataOutputStream(new FileOutputStream(file)));
    }

    public void dump(String string) throws IOException {
        this.dump(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.dump(dataOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                dataOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void dump(OutputStream outputStream) throws IOException {
        this.dump(new DataOutputStream(outputStream));
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        int n;
        dataOutputStream.writeInt(-889275714);
        dataOutputStream.writeShort(this.minor);
        dataOutputStream.writeShort(this.major);
        this.constant_pool.dump(dataOutputStream);
        dataOutputStream.writeShort(this.access_flags);
        dataOutputStream.writeShort(this.class_name_index);
        dataOutputStream.writeShort(this.superclass_name_index);
        dataOutputStream.writeShort(this.interfaces.length);
        for (n = 0; n < this.interfaces.length; ++n) {
            dataOutputStream.writeShort(this.interfaces[n]);
        }
        dataOutputStream.writeShort(this.fields.length);
        for (n = 0; n < this.fields.length; ++n) {
            this.fields[n].dump(dataOutputStream);
        }
        dataOutputStream.writeShort(this.methods.length);
        for (n = 0; n < this.methods.length; ++n) {
            this.methods[n].dump(dataOutputStream);
        }
        if (this.attributes != null) {
            dataOutputStream.writeShort(this.attributes.length);
            for (n = 0; n < this.attributes.length; ++n) {
                this.attributes[n].dump(dataOutputStream);
            }
        } else {
            dataOutputStream.writeShort(0);
        }
        dataOutputStream.close();
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public String getClassName() {
        return this.class_name;
    }

    public String getPackageName() {
        return this.package_name;
    }

    public int getClassNameIndex() {
        return this.class_name_index;
    }

    public ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public String getFileName() {
        return this.file_name;
    }

    public String[] getInterfaceNames() {
        return this.interface_names;
    }

    public int[] getInterfaceIndices() {
        return this.interfaces;
    }

    public int getMajor() {
        return this.major;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public Method getMethod(java.lang.reflect.Method method) {
        for (int i = 0; i < this.methods.length; ++i) {
            Method method2 = this.methods[i];
            if (!method.getName().equals(method2.getName()) || method.getModifiers() != method2.getModifiers() || !Type.getSignature(method).equals(method2.getSignature())) continue;
            return method2;
        }
        return null;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getSourceFileName() {
        return this.source_file_name;
    }

    public String getSuperclassName() {
        return this.superclass_name;
    }

    public int getSuperclassNameIndex() {
        return this.superclass_name_index;
    }

    public void setAttributes(Attribute[] attributeArray) {
        this.attributes = attributeArray;
    }

    public void setClassName(String string) {
        this.class_name = string;
    }

    public void setClassNameIndex(int n) {
        this.class_name_index = n;
    }

    public void setConstantPool(ConstantPool constantPool) {
        this.constant_pool = constantPool;
    }

    public void setFields(Field[] fieldArray) {
        this.fields = fieldArray;
    }

    public void setFileName(String string) {
        this.file_name = string;
    }

    public void setInterfaceNames(String[] stringArray) {
        this.interface_names = stringArray;
    }

    public void setInterfaces(int[] nArray) {
        this.interfaces = nArray;
    }

    public void setMajor(int n) {
        this.major = n;
    }

    public void setMethods(Method[] methodArray) {
        this.methods = methodArray;
    }

    public void setMinor(int n) {
        this.minor = n;
    }

    public void setSourceFileName(String string) {
        this.source_file_name = string;
    }

    public void setSuperclassName(String string) {
        this.superclass_name = string;
    }

    public void setSuperclassNameIndex(int n) {
        this.superclass_name_index = n;
    }

    public String toString() {
        int n;
        String string = Utility.accessToString(this.access_flags, true);
        string = string.equals("") ? "" : string + " ";
        StringBuffer stringBuffer = new StringBuffer(string + Utility.classOrInterface(this.access_flags) + " " + this.class_name + " extends " + Utility.compactClassName(this.superclass_name, false) + '\n');
        int n2 = this.interfaces.length;
        if (n2 > 0) {
            stringBuffer.append("implements\t\t");
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(this.interface_names[n]);
                if (n >= n2 - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append('\n');
        }
        stringBuffer.append("filename\t\t" + this.file_name + '\n');
        stringBuffer.append("compiled from\t\t" + this.source_file_name + '\n');
        stringBuffer.append("compiler version\t" + this.major + "." + this.minor + '\n');
        stringBuffer.append("access flags\t\t" + this.access_flags + '\n');
        stringBuffer.append("constant pool\t\t" + this.constant_pool.getLength() + " entries\n");
        stringBuffer.append("ACC_SUPER flag\t\t" + this.isSuper() + "\n");
        if (this.attributes.length > 0) {
            stringBuffer.append("\nAttribute(s):\n");
            for (n = 0; n < this.attributes.length; ++n) {
                stringBuffer.append(JavaClass.indent(this.attributes[n]));
            }
        }
        if (this.fields.length > 0) {
            stringBuffer.append("\n" + this.fields.length + " fields:\n");
            for (n = 0; n < this.fields.length; ++n) {
                stringBuffer.append("\t" + this.fields[n] + '\n');
            }
        }
        if (this.methods.length > 0) {
            stringBuffer.append("\n" + this.methods.length + " methods:\n");
            for (n = 0; n < this.methods.length; ++n) {
                stringBuffer.append("\t" + this.methods[n] + '\n');
            }
        }
        return stringBuffer.toString();
    }

    private static final String indent(Object object) {
        StringTokenizer stringTokenizer = new StringTokenizer(object.toString(), "\n");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("\t" + stringTokenizer.nextToken() + "\n");
        }
        return stringBuffer.toString();
    }

    public JavaClass copy() {
        int n;
        JavaClass javaClass = null;
        try {
            javaClass = (JavaClass)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        javaClass.constant_pool = this.constant_pool.copy();
        javaClass.interfaces = (int[])this.interfaces.clone();
        javaClass.interface_names = (String[])this.interface_names.clone();
        javaClass.fields = new Field[this.fields.length];
        for (n = 0; n < this.fields.length; ++n) {
            javaClass.fields[n] = this.fields[n].copy(javaClass.constant_pool);
        }
        javaClass.methods = new Method[this.methods.length];
        for (n = 0; n < this.methods.length; ++n) {
            javaClass.methods[n] = this.methods[n].copy(javaClass.constant_pool);
        }
        javaClass.attributes = new Attribute[this.attributes.length];
        for (n = 0; n < this.attributes.length; ++n) {
            javaClass.attributes[n] = this.attributes[n].copy(javaClass.constant_pool);
        }
        return javaClass;
    }

    public final boolean isSuper() {
        return (this.access_flags & 0x20) != 0;
    }

    public final boolean isClass() {
        return (this.access_flags & 0x200) == 0;
    }

    public final byte getSource() {
        return this.source;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public final boolean instanceOf(JavaClass javaClass) {
        if (this.equals(javaClass)) {
            return true;
        }
        JavaClass[] javaClassArray = this.getSuperClasses();
        for (int i = 0; i < javaClassArray.length; ++i) {
            if (!javaClassArray[i].equals(javaClass)) continue;
            return true;
        }
        if (javaClass.isInterface()) {
            return this.implementationOf(javaClass);
        }
        return false;
    }

    public boolean implementationOf(JavaClass javaClass) {
        if (!javaClass.isInterface()) {
            throw new IllegalArgumentException(javaClass.getClassName() + " is no interface");
        }
        if (this.equals(javaClass)) {
            return true;
        }
        JavaClass[] javaClassArray = this.getAllInterfaces();
        for (int i = 0; i < javaClassArray.length; ++i) {
            if (!javaClassArray[i].equals(javaClass)) continue;
            return true;
        }
        return false;
    }

    public JavaClass getSuperClass() {
        if ("java.lang.Object".equals(this.getClassName())) {
            return null;
        }
        try {
            return this.repository.loadClass(this.getSuperclassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
            return null;
        }
    }

    public JavaClass[] getSuperClasses() {
        JavaClass javaClass = this;
        ClassVector classVector = new ClassVector();
        for (javaClass = javaClass.getSuperClass(); javaClass != null; javaClass = javaClass.getSuperClass()) {
            classVector.addElement(javaClass);
        }
        return classVector.toArray();
    }

    public JavaClass[] getInterfaces() {
        String[] stringArray = this.getInterfaceNames();
        JavaClass[] javaClassArray = new JavaClass[stringArray.length];
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                javaClassArray[i] = this.repository.loadClass(stringArray[i]);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
            return null;
        }
        return javaClassArray;
    }

    public JavaClass[] getAllInterfaces() {
        ClassQueue classQueue = new ClassQueue();
        ClassVector classVector = new ClassVector();
        classQueue.enqueue(this);
        while (!classQueue.empty()) {
            JavaClass javaClass = classQueue.dequeue();
            JavaClass javaClass2 = javaClass.getSuperClass();
            JavaClass[] javaClassArray = javaClass.getInterfaces();
            if (javaClass.isInterface()) {
                classVector.addElement(javaClass);
            } else if (javaClass2 != null) {
                classQueue.enqueue(javaClass2);
            }
            for (int i = 0; i < javaClassArray.length; ++i) {
                classQueue.enqueue(javaClassArray[i]);
            }
        }
        return classVector.toArray();
    }

    static {
        String string = null;
        String string2 = null;
        try {
            string = System.getProperty("JavaClass.debug");
            string2 = System.getProperty("file.separator");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string != null) {
            debug = new Boolean(string);
        }
        if (string2 != null) {
            try {
                sep = string2.charAt(0);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }
}

