/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.packaging.mime.internet;

import com.sun.xml.internal.messaging.saaj.packaging.mime.MessagingException;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentType;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.InternetHeaders;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeBodyPart;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeMultipart;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.SharedInputStream;
import com.sun.xml.internal.messaging.saaj.packaging.mime.util.ASCIIUtility;
import com.sun.xml.internal.messaging.saaj.packaging.mime.util.OutputUtil;
import com.sun.xml.internal.messaging.saaj.util.ByteOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import javax.activation.DataSource;

public class BMMimeMultipart
extends MimeMultipart {
    private boolean begining = true;
    int[] bcs = new int[256];
    int[] gss = null;
    private static final int BUFFER_SIZE = 4096;
    private byte[] buffer = new byte[4096];
    private byte[] prevBuffer = new byte[4096];
    private BitSet lastPartFound = new BitSet(1);
    private InputStream in = null;
    private String boundary = null;
    int b = 0;
    private boolean lazyAttachments = false;
    byte[] buf = new byte[1024];

    public BMMimeMultipart() {
    }

    public BMMimeMultipart(String string) {
        super(string);
    }

    public BMMimeMultipart(DataSource dataSource, ContentType contentType) throws MessagingException {
        super(dataSource, contentType);
        this.boundary = contentType.getParameter("boundary");
    }

    public InputStream initStream() throws MessagingException {
        if (this.in == null) {
            try {
                this.in = this.ds.getInputStream();
                if (!(this.in instanceof ByteArrayInputStream || this.in instanceof BufferedInputStream || this.in instanceof SharedInputStream)) {
                    this.in = new BufferedInputStream(this.in);
                }
            }
            catch (Exception exception) {
                throw new MessagingException("No inputstream from datasource");
            }
            if (!this.in.markSupported()) {
                throw new MessagingException("InputStream does not support Marking");
            }
        }
        return this.in;
    }

    protected void parse() throws MessagingException {
        if (this.parsed) {
            return;
        }
        this.initStream();
        SharedInputStream sharedInputStream = null;
        if (this.in instanceof SharedInputStream) {
            sharedInputStream = (SharedInputStream)((Object)this.in);
        }
        String string = "--" + this.boundary;
        byte[] byArray = ASCIIUtility.getBytes(string);
        try {
            this.parse(this.in, byArray, sharedInputStream);
        }
        catch (IOException iOException) {
            throw new MessagingException("IO Error", iOException);
        }
        catch (Exception exception) {
            throw new MessagingException("Error", exception);
        }
        this.parsed = true;
    }

    public boolean lastBodyPartFound() {
        return this.lastPartFound.get(0);
    }

    public MimeBodyPart getNextPart(InputStream inputStream, byte[] byArray, SharedInputStream sharedInputStream) throws Exception {
        if (!inputStream.markSupported()) {
            throw new Exception("InputStream does not support Marking");
        }
        if (this.begining) {
            this.compile(byArray);
            if (!this.skipPreamble(inputStream, byArray, sharedInputStream)) {
                throw new Exception("Missing Start Boundary, or boundary does not start on a new line");
            }
            this.begining = false;
        }
        if (this.lastBodyPartFound()) {
            throw new Exception("No parts found in Multipart InputStream");
        }
        if (sharedInputStream != null) {
            long l = sharedInputStream.getPosition();
            this.b = this.readHeaders(inputStream);
            if (this.b == -1) {
                throw new Exception("End of Stream encountered while reading part headers");
            }
            long[] lArray = new long[]{-1L};
            this.b = this.readBody(inputStream, byArray, lArray, null, sharedInputStream);
            long l2 = lArray[0];
            MimeBodyPart mimeBodyPart = this.createMimeBodyPart(sharedInputStream.newStream(l, l2));
            this.addBodyPart(mimeBodyPart);
            return mimeBodyPart;
        }
        InternetHeaders internetHeaders = this.createInternetHeaders(inputStream);
        ByteOutputStream byteOutputStream = new ByteOutputStream();
        this.b = this.readBody(inputStream, byArray, null, byteOutputStream, null);
        MimeBodyPart mimeBodyPart = this.createMimeBodyPart(internetHeaders, byteOutputStream.getBytes(), byteOutputStream.getCount());
        this.addBodyPart(mimeBodyPart);
        return mimeBodyPart;
    }

    public boolean parse(InputStream inputStream, byte[] byArray, SharedInputStream sharedInputStream) throws Exception {
        while (!this.lastPartFound.get(0) && this.b != -1) {
            this.getNextPart(inputStream, byArray, sharedInputStream);
        }
        return true;
    }

    private int readHeaders(InputStream inputStream) throws Exception {
        int n = inputStream.read();
        while (n != -1) {
            if (n == 13) {
                n = inputStream.read();
                if (n != 10 || (n = inputStream.read()) != 13 || (n = inputStream.read()) != 10) continue;
                return n;
            }
            n = inputStream.read();
        }
        if (n == -1) {
            throw new Exception("End of inputstream while reading Mime-Part Headers");
        }
        return n;
    }

    private int readBody(InputStream inputStream, byte[] byArray, long[] lArray, ByteOutputStream byteOutputStream, SharedInputStream sharedInputStream) throws Exception {
        if (!this.find(inputStream, byArray, lArray, byteOutputStream, sharedInputStream)) {
            throw new Exception("Missing boundary delimitier while reading Body Part");
        }
        return this.b;
    }

    private boolean skipPreamble(InputStream inputStream, byte[] byArray, SharedInputStream sharedInputStream) throws Exception {
        if (!this.find(inputStream, byArray, sharedInputStream)) {
            return false;
        }
        if (this.lastPartFound.get(0)) {
            throw new Exception("Found closing boundary delimiter while trying to skip preamble");
        }
        return true;
    }

    public int readNext(InputStream inputStream, byte[] byArray, int n, BitSet bitSet, long[] lArray, SharedInputStream sharedInputStream) throws Exception {
        int n2 = inputStream.read(this.buffer, 0, n);
        if (n2 == -1) {
            bitSet.flip(0);
        } else if (n2 < n) {
            int n3;
            int n4 = 0;
            long l = 0L;
            for (n3 = n2; n3 < n; ++n3) {
                if (sharedInputStream != null) {
                    l = sharedInputStream.getPosition();
                }
                if ((n4 = inputStream.read()) == -1) {
                    bitSet.flip(0);
                    if (sharedInputStream == null) break;
                    lArray[0] = l;
                    break;
                }
                this.buffer[n3] = (byte)n4;
            }
            n2 = n3;
        }
        return n2;
    }

    public boolean find(InputStream inputStream, byte[] byArray, SharedInputStream sharedInputStream) throws Exception {
        int n = byArray.length;
        int n2 = n - 1;
        int n3 = 0;
        BitSet bitSet = new BitSet(1);
        long[] lArray = new long[1];
        while (true) {
            int n4;
            inputStream.mark(n);
            n3 = this.readNext(inputStream, this.buffer, n, bitSet, lArray, sharedInputStream);
            if (bitSet.get(0)) {
                return false;
            }
            for (n4 = n2; n4 >= 0 && this.buffer[n4] == byArray[n4]; --n4) {
            }
            if (n4 < 0) {
                if (!this.skipLWSPAndCRLF(inputStream)) {
                    throw new Exception("Boundary does not terminate with CRLF");
                }
                return true;
            }
            int n5 = Math.max(n4 + 1 - this.bcs[this.buffer[n4] & 0x7F], this.gss[n4]);
            inputStream.reset();
            inputStream.skip(n5);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean find(InputStream inputStream, byte[] byArray, long[] lArray, ByteOutputStream byteOutputStream, SharedInputStream sharedInputStream) throws Exception {
        int n = byArray.length;
        int n2 = n - 1;
        int n3 = 0;
        int n4 = 0;
        long l = -1L;
        byte[] byArray2 = null;
        boolean bl = true;
        BitSet bitSet = new BitSet(1);
        while (true) {
            int n5;
            inputStream.mark(n);
            if (!bl) {
                byArray2 = this.prevBuffer;
                this.prevBuffer = this.buffer;
                this.buffer = byArray2;
            }
            if (sharedInputStream != null) {
                l = sharedInputStream.getPosition();
            }
            if ((n3 = this.readNext(inputStream, this.buffer, n, bitSet, lArray, sharedInputStream)) == -1) {
                this.b = -1;
                if (n4 != n || sharedInputStream != null) return true;
                byteOutputStream.write(this.prevBuffer, 0, n4);
                return true;
            }
            if (n3 < n) {
                if (sharedInputStream == null) {
                    byteOutputStream.write(this.buffer, 0, n3);
                }
                this.b = -1;
                return true;
            }
            for (n5 = n2; n5 >= 0 && this.buffer[n5] == byArray[n5]; --n5) {
            }
            if (n5 < 0) {
                if (n4 > 0) {
                    if (n4 <= 2) {
                        if (n4 == 2) {
                            if (this.prevBuffer[1] != 10) throw new Exception("Boundary characters encountered in part Body without a preceeding CRLF");
                            if (this.prevBuffer[0] != 13 && this.prevBuffer[0] != 10) {
                                byteOutputStream.write(this.prevBuffer, 0, 1);
                            }
                            if (sharedInputStream != null) {
                                lArray[0] = l;
                            }
                        } else if (n4 == 1) {
                            if (this.prevBuffer[0] != 10) {
                                throw new Exception("Boundary characters encountered in part Body without a preceeding CRLF");
                            }
                            if (sharedInputStream != null) {
                                lArray[0] = l;
                            }
                        }
                    } else if (n4 > 2) {
                        if (this.prevBuffer[n4 - 2] == 13 && this.prevBuffer[n4 - 1] == 10) {
                            if (sharedInputStream != null) {
                                lArray[0] = l - 2L;
                            } else {
                                byteOutputStream.write(this.prevBuffer, 0, n4 - 2);
                            }
                        } else {
                            if (this.prevBuffer[n4 - 1] != 10) throw new Exception("Boundary characters encountered in part Body without a preceeding CRLF");
                            if (sharedInputStream != null) {
                                lArray[0] = l - 1L;
                            } else {
                                byteOutputStream.write(this.prevBuffer, 0, n4 - 1);
                            }
                        }
                    }
                }
                if (this.skipLWSPAndCRLF(inputStream)) return true;
                return true;
            }
            if (n4 > 0 && sharedInputStream == null) {
                if (this.prevBuffer[n4 - 1] == 13) {
                    if (this.buffer[0] == 10) {
                        int n6 = n2 - 1;
                        for (n6 = n2 - 1; n6 > 0 && this.buffer[n6 + 1] == byArray[n6]; --n6) {
                        }
                        if (n6 == 0) {
                            byteOutputStream.write(this.prevBuffer, 0, n4 - 1);
                        } else {
                            byteOutputStream.write(this.prevBuffer, 0, n4);
                        }
                    } else {
                        byteOutputStream.write(this.prevBuffer, 0, n4);
                    }
                } else {
                    byteOutputStream.write(this.prevBuffer, 0, n4);
                }
            }
            n4 = Math.max(n5 + 1 - this.bcs[this.buffer[n5] & 0x7F], this.gss[n5]);
            inputStream.reset();
            inputStream.skip(n4);
            if (!bl) continue;
            bl = false;
        }
    }

    private boolean skipLWSPAndCRLF(InputStream inputStream) throws Exception {
        this.b = inputStream.read();
        if (this.b == 10) {
            return true;
        }
        if (this.b == 13) {
            this.b = inputStream.read();
            if (this.b == 13) {
                this.b = inputStream.read();
            }
            if (this.b == 10) {
                return true;
            }
            throw new Exception("transport padding after a Mime Boundary  should end in a CRLF, found CR only");
        }
        if (this.b == 45) {
            this.b = inputStream.read();
            if (this.b != 45) {
                throw new Exception("Unexpected singular '-' character after Mime Boundary");
            }
            this.lastPartFound.flip(0);
            this.b = inputStream.read();
        }
        while (this.b != -1 && (this.b == 32 || this.b == 9)) {
            this.b = inputStream.read();
            if (this.b != 13) continue;
            this.b = inputStream.read();
            if (this.b == 13) {
                this.b = inputStream.read();
            }
            if (this.b != 10) continue;
            return true;
        }
        if (this.b == -1) {
            if (!this.lastPartFound.get(0)) {
                throw new Exception("End of Multipart Stream before encountering  closing boundary delimiter");
            }
            return true;
        }
        return false;
    }

    private void compile(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        for (n = 0; n < n2; ++n) {
            this.bcs[byArray[n]] = n + 1;
        }
        this.gss = new int[n2];
        block1: for (n = n2; n > 0; --n) {
            int n3;
            for (n3 = n2 - 1; n3 >= n; --n3) {
                if (byArray[n3] != byArray[n3 - n]) continue block1;
                this.gss[n3 - 1] = n;
            }
            while (n3 > 0) {
                this.gss[--n3] = n;
            }
        }
        this.gss[n2 - 1] = 1;
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        if (this.in != null) {
            this.contentType.setParameter("boundary", this.boundary);
        }
        String string = "--" + this.contentType.getParameter("boundary");
        for (int i = 0; i < this.parts.size(); ++i) {
            OutputUtil.writeln(string, outputStream);
            ((MimeBodyPart)this.parts.get(i)).writeTo(outputStream);
            OutputUtil.writeln(outputStream);
        }
        if (this.in != null) {
            OutputUtil.writeln(string, outputStream);
            if (outputStream instanceof ByteOutputStream && this.lazyAttachments) {
                ((ByteOutputStream)outputStream).write(this.in);
            } else {
                ByteOutputStream byteOutputStream = new ByteOutputStream(this.in.available());
                byteOutputStream.write(this.in);
                byteOutputStream.writeTo(outputStream);
                this.in = byteOutputStream.newInputStream();
            }
        } else {
            OutputUtil.writeAsAscii(string, outputStream);
            OutputUtil.writeAsAscii("--", outputStream);
        }
    }

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void setBoundary(String string) {
        this.boundary = string;
        if (this.contentType != null) {
            this.contentType.setParameter("boundary", string);
        }
    }

    public String getBoundary() {
        return this.boundary;
    }

    public boolean isEndOfStream() {
        return this.b == -1;
    }

    public void setLazyAttachments(boolean bl) {
        this.lazyAttachments = bl;
    }
}

