/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.util;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Writer;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;

public class XMLDeclarationParser {
    private String m_encoding;
    private PushbackReader m_pushbackReader;
    private boolean m_hasHeader;
    private String xmlDecl = null;
    static String gt16 = null;
    static String utf16Decl = null;

    public XMLDeclarationParser(PushbackReader pushbackReader) {
        this.m_pushbackReader = pushbackReader;
        this.m_encoding = "utf-8";
        this.m_hasHeader = false;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public String getXmlDeclaration() {
        return this.xmlDecl;
    }

    public void parse() throws TransformerException, IOException {
        int n = 0;
        int n2 = 0;
        char[] cArray = new char[65535];
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.m_pushbackReader.read()) != -1) {
            cArray[n2] = (char)n;
            stringBuffer.append((char)n);
            ++n2;
            if (n != 62) continue;
        }
        int n3 = n2;
        String string = stringBuffer.toString();
        boolean bl = false;
        boolean bl2 = false;
        int n4 = string.indexOf(utf16Decl);
        if (n4 > -1) {
            bl = true;
        } else {
            n4 = string.indexOf("<?xml");
            if (n4 > -1) {
                bl2 = true;
            }
        }
        if (!bl && !bl2) {
            this.m_pushbackReader.unread(cArray, 0, n3);
            return;
        }
        this.m_hasHeader = true;
        if (bl) {
            this.xmlDecl = new String(string.getBytes(), "utf-16");
            this.xmlDecl = this.xmlDecl.substring(this.xmlDecl.indexOf("<"));
        } else {
            this.xmlDecl = string;
        }
        if (n4 != 0) {
            throw new IOException("Unexpected characters before XML declaration");
        }
        int n5 = this.xmlDecl.indexOf("version");
        if (n5 == -1) {
            throw new IOException("Mandatory 'version' attribute Missing in XML declaration");
        }
        int n6 = this.xmlDecl.indexOf("encoding");
        if (n6 == -1) {
            return;
        }
        if (n5 > n6) {
            throw new IOException("The 'version' attribute should preceed the 'encoding' attribute in an XML Declaration");
        }
        int n7 = this.xmlDecl.indexOf("standalone");
        if (n7 > -1 && (n7 < n5 || n7 < n6)) {
            throw new IOException("The 'standalone' attribute should be the last attribute in an XML Declaration");
        }
        int n8 = this.xmlDecl.indexOf("=", n6);
        if (n8 == -1) {
            throw new IOException("Missing '=' character after 'encoding' in XML declaration");
        }
        this.m_encoding = this.parseEncoding(this.xmlDecl, n8);
        if (this.m_encoding.startsWith("\"")) {
            this.m_encoding = this.m_encoding.substring(this.m_encoding.indexOf("\"") + 1, this.m_encoding.lastIndexOf("\""));
        } else if (this.m_encoding.startsWith("'")) {
            this.m_encoding = this.m_encoding.substring(this.m_encoding.indexOf("'") + 1, this.m_encoding.lastIndexOf("'"));
        }
    }

    public void writeTo(Writer writer) throws IOException {
        if (!this.m_hasHeader) {
            return;
        }
        writer.write(this.xmlDecl.toString());
    }

    private String parseEncoding(String string, int n) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1));
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = string2.indexOf("?");
            if (n2 > -1) {
                return string2.substring(0, n2);
            }
            return string2;
        }
        throw new IOException("Error parsing 'encoding' attribute in XML declaration");
    }

    static {
        try {
            gt16 = new String(">".getBytes("utf-16"));
            utf16Decl = new String("<?xml".getBytes("utf-16"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

