// __________ Imports __________

// base classes
import com.sun.star.uno.UnoRuntime;
import com.sun.star.lang.*;

// factory for creating components
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.frame.XComponentLoader;

// property access
import com.sun.star.beans.*;

public class Helper
{
    // __________ static helper methods __________

    /** Connect to a running office that is accepting connections
        and return the ServiceManager to instantiate office components
     */
    static public XMultiServiceFactory connect( String sConnection )
		throws Exception
    {
		XMultiServiceFactory xMultiServiceFactory = null;
		XMultiServiceFactory xLocalServiceManager =
			com.sun.star.comp.helper.Bootstrap.createSimpleServiceManager();

		XUnoUrlResolver aURLResolver = (XUnoUrlResolver)UnoRuntime.queryInterface(
			XUnoUrlResolver.class,
			xLocalServiceManager.createInstance( "com.sun.star.bridge.UnoUrlResolver" ) );

		xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(
			XMultiServiceFactory.class,
			aURLResolver.resolve( sConnection ) );
		if ( xMultiServiceFactory == null )
			throw new Exception( "couldn't not connect to:'" + sConnection + "'" );
		return xMultiServiceFactory;
    }

    /** creates and instantiates new document
	*/
	static public XComponent createDocument( XMultiServiceFactory xMultiServiceFactory,
		String sURL, String sTargetFrame, int nSearchFlags, PropertyValue[] aArgs )
			throws Exception
	{
		XComponent xComponent = null;
		XComponentLoader aLoader = (XComponentLoader)UnoRuntime.queryInterface(
			XComponentLoader.class,
				xMultiServiceFactory.createInstance( "com.sun.star.frame.Desktop" ) );

		xComponent = (XComponent)UnoRuntime.queryInterface( XComponent.class,
			aLoader.loadComponentFromURL(
				sURL, sTargetFrame, nSearchFlags, aArgs ) );
		if ( xComponent == null )
			throw new Exception( "could not create document: " + sURL );
		return xComponent;
	}
}
