/*************************************************************************
 *
 *  $RCSfile: client.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _INET_CLIENT_HXX
#define _INET_CLIENT_HXX "$Revision: 1.1.1.1 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif
#ifndef _VOS_OBJECT_HXX_
#include <vos/object.hxx>
#endif

#ifndef _INET_MACROS_HXX
#include <inet/macros.hxx>
#endif

class INetCoreDNSHostEntry;

#ifdef _USE_NAMESPACE
namespace inet {
#endif

class INetSocket;
class INetClientManager_Impl;

/*========================================================================
 *
 * INetClientConnection_Impl interface.
 *
 *======================================================================*/
class INetClientConnection_Impl :
	public NAMESPACE_VOS(OReference),
	public NAMESPACE_VOS(OObject)
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetClientConnection_Impl, inet));

public:
	INetClientConnection_Impl (void);
	virtual ~INetClientConnection_Impl (void);

	virtual sal_Bool handleResolverEvent (
		sal_Int32             nEvent,
		INetCoreDNSHostEntry *pHostEntry) = 0;

	virtual sal_Bool handleSocketEvent (
		const NAMESPACE_VOS(ORef)<INetSocket> &rxSocket,
		sal_Int32                              nEvent) = 0;

protected:
	/** Resolver callback procedure.
	 *  @see INetCoreDNSResolverCallback
	 */
	static sal_Bool onResolverEvent (
		sal_Int32             nEvent,
		INetCoreDNSHostEntry *pHostEntry,
		void                 *pData);

	/** Socket callback procedure.
	 *  @see INetSocket::EventHandler
	 */
	static sal_Bool onSocketEvent (
		const NAMESPACE_VOS(ORef)<INetSocket> &rxSocket,
		sal_Int32                              nEvent,
		void                                  *pData);

private:
	/** Representation.
	 */
	NAMESPACE_VOS(ORef)<INetClientManager_Impl> m_xManager;

	/** Not implemented.
	 */
	INetClientConnection_Impl (const INetClientConnection_Impl&);
	INetClientConnection_Impl& operator= (const INetClientConnection_Impl&);
};

/*========================================================================
 *
 * The End.
 *
 *======================================================================*/
#ifdef _USE_NAMESPACE
}
#endif

extern "C" void SAL_CALL INetClientCleanup_Impl (void);

#endif /* _INET_CLIENT_HXX */

