/*************************************************************************
 *
 *  $RCSfile: inetmail.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/03/19 11:05:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#ifndef _INETCOREMAIL_HXX
#define _INETCOREMAIL_HXX "$Revision: 1.2 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _INETCOREMSG_HXX
#include <inet/inetmsg.hxx>
#endif

#ifndef _INETSMTP_HXX
#include <inet/inetsmtp.hxx>
#endif

#ifndef _INETPOP3_HXX
#include <inet/inetpop3.hxx>
#endif

#ifndef _INETNNTP_HXX
#include <inet/inetnntp.hxx>
#endif

class DateTime;
class List;

/*=======================================================================
 *
 * INetCoreMailer Interface.
 *
 * Implementation Note:
 *
 * INetCoreMailer currently handles sending/receiving of mail messages
 * (via SMTP/POP3) and retrieving/posting of news articles (via NNTP).
 * Mail and News messages can be of any MIME/1.0 compliant type.
 *
 * Will be upgraded (one day) to provide more advanced message transfer
 * (SvLockBytes instead of Sv(File)Stream) and parsing.
 * Upgrade requires an (incompatible) interface change/extension.
 * 
 *=====================================================================*/

typedef INetCorePOP3MailListEntry INetCoreMailInfoListEntry;

#ifdef _USE_NAMESPACE
namespace inet {
#endif

class INetCoreMailer;

typedef sal_Bool INetCoreMailerCallback (
	INetCoreMailer *pMailer,
	sal_Int32       nReplyCode,
	const sal_Char *pReplyText,
	void           *pData);

class INetCoreMailer
{
	/** Not implemented.
	 */
	INetCoreMailer (const INetCoreMailer&);
	INetCoreMailer& operator= (const INetCoreMailer&);

protected:
	/** Construction.
	 */
	INetCoreMailer (void);

public:
	/** Destruction.
	 */
	virtual ~INetCoreMailer (void);

	/** Message Creation.
	 */
	virtual INetCoreMIMEMessage *CreateINetCoreMIMEMessage (void) const = 0;
	virtual INetCoreNewsMessage *CreateINetCoreNewsMessage (void) const = 0;

	/** Send-Connection (via SMTP).
	 */
	virtual sal_Bool SendOpenConnection (
		const rtl::OUString    &rHost, sal_uInt16 nPort,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;
	virtual sal_Bool SendIsOpen (void) const = 0;

	virtual sal_Bool SendCloseConnection (
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;
	virtual void SendAbortConnection (void) = 0;

	virtual sal_Bool SendMail (
		INetCoreMIMEMessage& rMessage,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;

	virtual sal_uInt32 SendGetTransferCount (void) const = 0;
	virtual sal_Bool  SendSetTransferCallback (
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;

	/** Receive-Connection (via POP3).
	 */
	virtual sal_Bool RecvOpenConnection (
		const rtl::OUString &rHost, sal_uInt16 nPort,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;
	virtual sal_Bool RecvIsOpen (void) const = 0;

	virtual sal_Bool RecvCloseConnection (
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;
	virtual void RecvAbortConnection (void) = 0;

	virtual sal_Bool RecvLogin (
		const rtl::OUString &rUsername,
		const rtl::OUString &rPassword,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;
	virtual sal_Bool RecvLoginSecure ( /* NYI */
		const rtl::OUString &rUsername,
		const rtl::OUString &rPassword,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;
	virtual sal_Bool RecvIsLoggedIn (void) const = 0;

	virtual sal_Bool RecvUniqueIdList (
		List& rUniqueIdList,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;
	virtual sal_Bool RecvMailList (
		List& rMailInfoList,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;
	virtual sal_Bool RecvMailListEntry (
		INetCoreMailInfoListEntry& rEntry,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;
	virtual sal_Bool RecvMailHead (
		sal_uInt32 nIndex, INetCoreMIMEMessage& rMessage,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;
	virtual sal_Bool RecvMail (
		sal_uInt32 nIndex, INetCoreMIMEMessage& rMessage,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;
	virtual sal_Bool RecvDeleteMail (
		sal_uInt32 nIndex,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;

	virtual sal_uInt32 RecvGetTransferCount (void) const = 0;
	virtual sal_Bool  RecvSetTransferCallback (
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;

	/** News-Connection (via NNTP).
	 */
	virtual sal_Bool NewsOpenConnection (
		const rtl::OUString &rHost, sal_uInt16 nPort,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;
	virtual sal_Bool NewsIsOpen (void) const = 0;

	virtual sal_Bool NewsCloseConnection (
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;
	virtual void NewsAbortConnection (void) = 0;

	virtual sal_Bool NewsModeReader (
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;

	virtual sal_Bool NewsAuthenticate (
		const rtl::OUString &rUsername,
		const rtl::OUString &rPassword,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;
	virtual sal_Bool NewsAuthenticatePassword (
		const rtl::OUString &rPassword,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;

	virtual sal_Bool NewsGroupList (
		List& rGroupList,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;
	virtual sal_Bool NewsNewGroupsList (
		const DateTime& rSinceDateTime,
		List& rNewGroupsList,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;
	virtual sal_Bool NewsNewNewsList (
		const rtl::OUString &rGroups,
		const DateTime& rSinceDateTime,
		List& rNewNewsList,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;

	virtual sal_Bool NewsSelectGroup (
		INetCoreNNTPGroupListEntry& rGroupListEntry,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;

	virtual sal_Bool NewsHasOverview (void) const = 0;
	virtual sal_Bool NewsArticleHeadOverview (
		sal_uInt32 nFirstArticleNumber,
		sal_uInt32 nLastArticleNumber,
		INetCoreNewsMessage& rMessage,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;

	virtual sal_Bool NewsArticleHead (
		sal_uInt32 nArticleNumber,
		INetCoreNewsMessage& rMessage,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;
	virtual sal_Bool NewsArticleHead (
		const rtl::OUString &rMessageID,
		INetCoreNewsMessage& rMessage,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;

	virtual sal_Bool NewsArticle (
		sal_uInt32 nArticleNumber,
		INetCoreNewsMessage& rMessage,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;
	virtual sal_Bool NewsArticle (
		const rtl::OUString &rMessageID,
		INetCoreNewsMessage& rMessage,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;

	virtual sal_Bool NewsIsPostingAllowed (void) const = 0;
	virtual sal_Bool NewsPostArticle (
		INetCoreNewsMessage& rMessage,
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;

	virtual sal_uInt32 NewsGetTransferCount (void) const = 0;
	virtual sal_Bool  NewsSetTransferCallback (
		INetCoreMailerCallback *pfnCallback, void *pData) = 0;

	/** Reserved.
	 */
	virtual void Dummy1 (void) = 0;
	virtual void Dummy2 (void) = 0;
	virtual void Dummy3 (void) = 0;
};

/*=======================================================================
 *
 * The End.
 *
 *=====================================================================*/
#ifdef _USE_NAMESPACE
}
#endif

extern "C" {
	NAMESPACE_INET(INetCoreMailer)* SAL_CALL NewINetCoreMailer (void);
}

#endif /* !_INETCOREMAIL_HXX */

