/*************************************************************************
 *
 *  $RCSfile: hatch.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 10:23:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_HATCH_HXX
#define _SV_HATCH_HXX

#include <vcl/color.hxx>
#include <vcl/vclenum.hxx>

// --------------
// - Impl_Hatch -
// --------------

class SvStream;

struct ImplHatch
{
    USHORT				mnRefCount;
    Color				maColor;
    HatchStyle			meStyle;
    long				mnDistance;
	long				mnDummy;
    USHORT				mnAngle;

						ImplHatch();
						ImplHatch( const ImplHatch& rImplHatch );

    friend SvStream&	operator>>( SvStream& rIStm, ImplHatch& rImplHatch );
    friend SvStream&	operator<<( SvStream& rOStm, const ImplHatch& rImplHatch );
};

// ---------
// - Hatch -
// ---------

class Hatch
{
private:	

	ImplHatch*		mpImplHatch;
	void			ImplMakeUnique();

public:

					Hatch();
                    Hatch( const Hatch& rHatch );
                    Hatch( HatchStyle eStyle, const Color& rHatchColor, long nDistance, USHORT nAngle10 = 0 );
                    ~Hatch();

	Hatch&			operator=( const Hatch& rHatch );
    BOOL            operator==( const Hatch& rHatch ) const;
    BOOL            operator!=( const Hatch& rHatch ) const { return !(Hatch::operator==( rHatch ) ); }
    BOOL            IsSameInstance( const Hatch& rHatch ) const { return( mpImplHatch == rHatch.mpImplHatch ); }

    void            SetStyle( HatchStyle eStyle );
    HatchStyle		GetStyle() const { return mpImplHatch->meStyle; }

    void            SetColor( const Color& rColor  );
    const Color&	GetColor() const { return mpImplHatch->maColor; }

    void            SetDistance( long nDistance  );
    long			GetDistance() const { return mpImplHatch->mnDistance; }

	void            SetAngle( USHORT nAngle10 );
    USHORT          GetAngle() const { return mpImplHatch->mnAngle; }

    friend SvStream& operator>>( SvStream& rIStm, Hatch& rHatch );
    friend SvStream& operator<<( SvStream& rOStm, const Hatch& rHatch );

#ifdef SMART_UNO_GENERATION

	HatchStyle		getStyle() const { return GetStyle(); }
	void 			setStyle( HatchStyle eStyle ) { SetStyle( eStyle ); }

	long 			getColor() const { return GetColor().GetColor(); }
	void 			setColor( long nColor ) { SetColor( Color( nColor ) ); }

	long			getDistance() const { return GetDistance(); }
	void 			setDistance( ULONG nDistance ) { SetDistance( nDistance ); }

	USHORT 			getAngle() const { return GetAngle(); }
	void 			setAngle( USHORT n ) { SetAngle( n ); }

#endif
};

#endif  // _SV_HATCH_HXX
