/*************************************************************************
 *
 *  $RCSfile: infocom.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _INFO_COMMUNICATION_HXX
#define _INFO_COMMUNICATION_HXX

#include <string.h>

#if SUPD == 358
#ifndef _TOOLERR_HXX
#include <tools/toolerr.hxx>
#endif
#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#else
#include <tools/solar.h>
#include <tools/string.hxx>
#endif

//#define INFODATA_MAX_INFO 0x0400
#define INFODATA_MAX_INFO 0xFFFF
#define INFODATA_MAX_STR_LEN (INFODATA_MAX_INFO - 1 - (3*sizeof(SVBT16)) - sizeof(SVBT8) -(2*sizeof(BOOL)))
//#define INFODATA_MAX_STR_LEN 0x1000
/* INFODATA_MAX_INFO:
 * Die maximale Groesse eines Sendepakets.
 * Die Groesse haengt vom physikalischen Puffer auf der Netzwerkkarte
 * ab. Wird der Wert ueberschritten, kann es zu unerwarteten
 * Nebeneffekten kommen.
 * INFODATA_MAX_STR_LEN:
 * Die maximale Groesse des InformationsStrings innerhalb des Info Pakets,
 * ohne Abschliessendes NULL Zeichen.
 * Die Abzuege der Speichermenge (3*SVBT16, 1*SVBT8, 2*BOOL)
 * sollen dynamisch an den Speicherverbrauch von struct InfoPack
 * angepasst werden, sonst jibbet dat Chaos !!!!
 */

#define INFODATA_CHARARRAY_LEN (INFODATA_MAX_STR_LEN + 1)

/* key value paare werden durch die laenge von nKeylen
 * unterschieden.
 */
class InfoDataPack
{
public:
  // last not least: the information
  struct InfoPack {
    // weiter Infos hier unter einfuegen, bitte

    // laenge des Keys bei key-Value uebermittlung
    SVBT16 nKeylen;

    SVBT8 nCommand; // Art der Information

    BOOL bSubList, bLastPacket; // hat keyvalue noch eine Sublist ? kommen noch mehr pakete ?
    // Paket x von n Paketen eingetroffen
    SVBT16 nAktuellPacket, nGesamtPacket;

    // weitere statische Infos hier ueber einfuegen, bitte.
    // bis jetzt 9Bytes Groesse
    // das chararray kommt ganz zum Schluss, da die aktuelle Groesse des Pakets kleiner
    // gemacht wird
    char sInfoString[INFODATA_CHARARRAY_LEN];
  };

  enum CommandType{ none,
		    info_request, info_request_list, info_request_whole_list,
		    info_result, info_result_whole_list,
		    info_reject, info_ak,
		    info_write, info_write_new,
		    command_req, command_ack, command_deny,
		    notify,
		    handshake,
			dependency_create, dependency_close,
			dependency_getdependinfo, dependency_touch,
			dependency_getdependlist, dependency_ack,
			dependency_getdata, dependency_reopen, dependency_deny,
			dependency_changetitle, dependency_delete };
public:

  InfoDataPack( );
  InfoDataPack( const char *pInfo, CommandType eCommand,
		USHORT nAktuell = 1, USHORT nGesamt = 1 );
  /*  InfoDataPack( const char *pKey, const char *pValue,
		UINT16 nAktuell = 1, UINT16 nGesamt = 1 );*/
  InfoDataPack( const char *pKey, const char *pValue, CommandType eCommand,
		BOOL bHasLink = FALSE, BOOL bLastPacket = TRUE,
		USHORT nAktuell = 1, USHORT nGesamt = 1 );
  InfoDataPack( const InfoPack &rInfoPack );

  InfoDataPack& operator =( const InfoPack &rInfoPack );
  InfoDataPack& operator =( const ByteString &rStr );
  InfoDataPack& operator =( const char *pChar );

  ULONG Size() const { return sizeof( InfoPack )            // das gesamte Packet
			 - INFODATA_CHARARRAY_LEN           // minus den char Array
			 + strlen( aInfoPack.sInfoString )  // plus Laenge des Strings
			 + 1; }                             // plus ein '\0' zeichen
  ULONG InfoSize() const { return strlen( aInfoPack.sInfoString ); }

  const InfoPack &DataPack() const { return aInfoPack; }
  InfoPack *DataPackCopy() const { return (InfoPack *)(memcpy( new InfoPack, &aInfoPack, Size() )); }
  //  InfoPack *DataPackCopy() const { return (InfoPack *)(memcpy( new InfoPack, &aInfoPack, INFODATA_MAX_INFO )); }
  void PutPacketNum( USHORT nAktuell, USHORT nGesamt );
  void PutCommand( CommandType eCommand ) { ByteToSVBT8( BYTE(eCommand), aInfoPack.nCommand ); }
  void SetInfoStr( const char *pInfo );
  //  void SetInfoStr( const char *pInfo, ULONG nLength );
  void SetKeyValueStr( const char *pKey, const char *pValue );
  void SetKeyValueStr( const ByteString &aKey, const ByteString &aValue )
		{ SetKeyValueStr( aKey.GetBuffer(), aValue.GetBuffer() ); }
  void SetHasLink( BOOL bHasLink ) { aInfoPack.bSubList = bHasLink; }
  void SetLastPacket( BOOL bLastPacket ) { aInfoPack.bLastPacket = bLastPacket; }

  CommandType GetPacketType() const { return CommandType( SVBT8ToByte( aInfoPack.nCommand)); }
  USHORT      GetCurrPaket() const { return SVBT16ToShort(aInfoPack.nAktuellPacket); }
  USHORT      GetMaxPaket() const { return SVBT16ToShort(aInfoPack.nGesamtPacket); }
  // wenn kein Key ex. ( GetKeyString='\0' ) gibt es nur den InfoString
  const char *GetKeyString() const { return sKey.GetBuffer(); } // =="", wenn kein "Value" ex.
  const char *GetValueString() const { return pValue; } // =='\x0', wenn kein "Wert" existiert
  const char *GetInfoString() const { return aInfoPack.sInfoString; }
  BOOL        HasSubList() const { return aInfoPack.bSubList; }
  BOOL        IsLastPaket() const { return aInfoPack.bLastPacket; }

private:
  void SetKeyLen( USHORT nLen ) { ShortToSVBT16( nLen, aInfoPack.nKeylen ); }
  USHORT GetKeyLen() { return SVBT16ToShort( aInfoPack.nKeylen ); }

  ByteString sKey;
  char *pValue;
  struct InfoPack aInfoPack;
};

#endif
