/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openide.awt.JMenuPlus;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.MenuView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;

public class MenuView
extends JPanel {
    static final long serialVersionUID = -4970665063421766904L;
    private transient ExplorerManager explorerManager;
    private JButton root;
    private JButton current;
    private transient Listener listener;
    static final NodeAcceptor DEFAULT_LISTENER = new NodeAcceptor(){

        public boolean acceptNodes(Node[] nodeArray) {
            if (nodeArray == null || nodeArray.length != 1) {
                return false;
            }
            Node node = nodeArray[0];
            SystemAction systemAction = node.getDefaultAction();
            if (systemAction != null) {
                TreeView.invokeAction(systemAction, new ActionEvent(node, 0, ""));
                return true;
            }
            return false;
        }
    };
    static /* synthetic */ Class class$org$openide$explorer$view$MenuView;

    public MenuView() {
        this.setLayout(new FlowLayout());
        this.root = new JButton(NbBundle.getBundle(class$org$openide$explorer$view$MenuView == null ? (class$org$openide$explorer$view$MenuView = MenuView.class$("org.openide.explorer.view.MenuView")) : class$org$openide$explorer$view$MenuView).getString("MenuViewStartFromRoot"));
        this.add(this.root);
        this.current = new JButton(NbBundle.getBundle(class$org$openide$explorer$view$MenuView == null ? (class$org$openide$explorer$view$MenuView = MenuView.class$("org.openide.explorer.view.MenuView")) : class$org$openide$explorer$view$MenuView).getString("MenuViewStartFromCurrent"));
        this.add(this.current);
        this.init();
    }

    private void init() {
        this.listener = new Listener(true);
        this.root.addMouseListener(this.listener);
        this.current.addMouseListener(new Listener(false));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public void addNotify() {
        super.addNotify();
        this.explorerManager = ExplorerManager.find(this);
        this.explorerManager.addPropertyChangeListener(this.listener);
        this.doChecks();
    }

    public void removeNotify() {
        super.removeNotify();
        this.explorerManager.removePropertyChangeListener(this.listener);
        this.explorerManager = null;
    }

    private void doChecks() {
        this.current.setEnabled(this.explorerManager.getSelectedNodes().length == 1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class MenuItem
    extends JMenuItem {
        static final long serialVersionUID = -918973978614344429L;
        protected Node node;
        protected NodeAcceptor action;

        public MenuItem(Node node) {
            this(node, DEFAULT_LISTENER);
        }

        public MenuItem(Node node, NodeAcceptor nodeAcceptor) {
            this(node, nodeAcceptor, true);
        }

        public MenuItem(Node node, Acceptor acceptor) {
            this(node, new AcceptorProxy(acceptor), true);
        }

        public MenuItem(Node node, Acceptor acceptor, boolean bl) {
            this(node, new AcceptorProxy(acceptor), bl);
        }

        public MenuItem(Node node, NodeAcceptor nodeAcceptor, boolean bl) {
            HelpCtx helpCtx;
            this.node = node;
            this.action = nodeAcceptor;
            if (bl) {
                MenuItem.initialize(this, node);
            }
            if ((helpCtx = node.getHelpCtx()) != null && !helpCtx.equals(HelpCtx.DEFAULT_HELP) && helpCtx.getHelpID() != null) {
                HelpCtx.setHelpIDString(this, helpCtx.getHelpID());
            }
        }

        public void doClick(int n) {
            this.action.acceptNodes(new Node[]{this.node});
        }

        static void initialize(JMenuItem jMenuItem, Node node) {
            final class NI
            implements Runnable,
            NodeListener,
            ItemListener {
                private final /* synthetic */ JMenuItem val$item;
                private final /* synthetic */ Node val$node;

                NI(JMenuItem jMenuItem, Node node) {
                    this.val$item = jMenuItem;
                    this.val$node = node;
                }

                public void run() {
                    this.val$item.setIcon(new ImageIcon(this.val$node.getIcon(1)));
                    this.val$item.setText(this.val$node.getDisplayName());
                }

                public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
                }

                public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
                }

                public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
                }

                public void nodeDestroyed(NodeEvent nodeEvent) {
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("icon".equals(propertyChangeEvent.getPropertyName())) {
                        Mutex.EVENT.readAccess(this);
                        return;
                    }
                    if ("displayName".equals(propertyChangeEvent.getPropertyName())) {
                        Mutex.EVENT.readAccess(this);
                        return;
                    }
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                }
            }
            NI nI = new NI(jMenuItem, node);
            nI.run();
            jMenuItem.addItemListener(nI);
            node.addNodeListener(WeakListener.node(nI, node));
        }
    }

    private static final class AcceptorProxy
    implements NodeAcceptor {
        private Acceptor original;

        AcceptorProxy(Acceptor acceptor) {
            this.original = acceptor;
        }

        public boolean acceptNodes(Node[] nodeArray) {
            if (nodeArray == null || nodeArray.length != 1) {
                return false;
            }
            return this.original.accept(nodeArray[0]);
        }
    }

    public static interface Acceptor {
        public boolean accept(Node var1);
    }

    public static class Menu
    extends JMenuPlus {
        static final long serialVersionUID = -1505289666675423991L;
        protected Node node;
        protected NodeAcceptor action;
        private boolean filled = false;

        public Menu(Node node) {
            this(node, DEFAULT_LISTENER);
        }

        public Menu(Node node, NodeAcceptor nodeAcceptor) {
            this(node, nodeAcceptor, true);
        }

        public Menu(Node node, Acceptor acceptor) {
            this(node, new AcceptorProxy(acceptor), true);
        }

        public Menu(Node node, Acceptor acceptor, boolean bl) {
            this(node, new AcceptorProxy(acceptor), bl);
        }

        public Menu(Node node, NodeAcceptor nodeAcceptor, boolean bl) {
            this.node = node;
            this.action = nodeAcceptor;
            if (bl) {
                MenuItem.initialize(this, node);
                HelpCtx helpCtx = node.getHelpCtx();
                if (helpCtx != null && !helpCtx.equals(HelpCtx.DEFAULT_HELP) && helpCtx.getHelpID() != null) {
                    HelpCtx.setHelpIDString(this, helpCtx.getHelpID());
                }
            }
        }

        public JPopupMenu getPopupMenu() {
            JPopupMenu jPopupMenu = super.getPopupMenu();
            this.fillSubmenu(jPopupMenu);
            return jPopupMenu;
        }

        private void fillSubmenu(JPopupMenu jPopupMenu) {
            if (!this.filled) {
                this.filled = true;
                Helper helper = new Helper(jPopupMenu);
                Node[] nodeArray = this.node.getChildren().getNodes(true);
                this.removeAll();
                int n = 0;
                while (n < nodeArray.length) {
                    this.add(this.createMenuItem(nodeArray[n]));
                    ++n;
                }
                if (this.getMenuComponentCount() == 0) {
                    this.add(Menu.createEmptyMenuItem());
                }
            }
        }

        public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
            super.processMouseEvent(mouseEvent, menuElementArray, menuSelectionManager);
            if (mouseEvent.isPopupTrigger() && this.action.acceptNodes(new Node[]{this.node})) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }

        private static JMenuItem createEmptyMenuItem() {
            JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(class$org$openide$explorer$view$MenuView == null ? (class$org$openide$explorer$view$MenuView = MenuView.class$("org.openide.explorer.view.MenuView")) : class$org$openide$explorer$view$MenuView, "EmptySubMenu"));
            jMenuItem.setEnabled(false);
            return jMenuItem;
        }

        protected JMenuItem createMenuItem(Node node) {
            return node.isLeaf() ? new MenuItem(node, this.action) : new Menu(node, this.action);
        }

        private class Helper
        implements PopupMenuListener {
            private JPopupMenu popup;

            Helper(JPopupMenu jPopupMenu) {
                this.popup = jPopupMenu;
                this.popup.addPopupMenuListener(this);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                Menu.this.filled = false;
                this.popup.removePopupMenuListener(this);
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        }
    }

    private class Listener
    extends MouseAdapter
    implements NodeAcceptor,
    PropertyChangeListener {
        private boolean root;

        public Listener(boolean bl) {
            this.root = bl;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getComponent().isEnabled()) {
                Object object;
                Node node = null;
                if (!this.root && ((Node[])(object = MenuView.this.explorerManager.getSelectedNodes())).length > 0) {
                    node = object[0];
                }
                if (node == null) {
                    node = MenuView.this.explorerManager.getRootContext();
                }
                object = new Menu(node, MenuView.this.listener);
                JPopupMenu jPopupMenu = ((Menu)object).getPopupMenu();
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                point.x = mouseEvent.getX() - point.x;
                point.y = mouseEvent.getY() - point.y;
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                Dimension dimension = jPopupMenu.getPreferredSize();
                Rectangle rectangle = Utilities.getUsableScreenBounds(MenuView.this.getGraphicsConfiguration());
                if (point.x + dimension.width > rectangle.x + rectangle.width) {
                    point.x = rectangle.x + rectangle.width - dimension.width;
                }
                if (point.y + dimension.height > rectangle.y + rectangle.height) {
                    point.y = rectangle.y + rectangle.height - dimension.height;
                }
                SwingUtilities.convertPointFromScreen(point, mouseEvent.getComponent());
                jPopupMenu.show(mouseEvent.getComponent(), point.x, point.y);
            }
        }

        public boolean acceptNodes(Node[] nodeArray) {
            if (nodeArray == null || nodeArray.length != 1) {
                return false;
            }
            Node node = nodeArray[0];
            Node node2 = node.getParentNode();
            if (node2 != null) {
                MenuView.this.explorerManager.setExploredContext(node2, new Node[]{node});
            }
            return true;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                MenuView.this.doChecks();
            }
        }
    }
}

