/*
 * Decompiled with CFR 0.152.
 */
package org.openide.modules;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.openide.util.Utilities;

public final class SpecificationVersion
implements Comparable {
    private final int[] digits;

    public SpecificationVersion(String string) throws NumberFormatException {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(string.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        if (stringTokenizer.countTokens() % 2 == 0) {
            throw new NumberFormatException("Even number of pieces in a spec version: `" + string + "'");
        }
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            if (bl) {
                bl = false;
                n = Integer.parseInt(stringTokenizer.nextToken());
                if (n < 0) {
                    throw new NumberFormatException("Spec version component <0: " + n);
                }
                arrayList.add(new Integer(n));
                continue;
            }
            if (!".".equals(stringTokenizer.nextToken())) {
                throw new NumberFormatException("Expected dot in spec version: `" + string + "'");
            }
            bl = true;
        }
        n = arrayList.size();
        this.digits = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.digits[n2] = (Integer)arrayList.get(n2);
            ++n2;
        }
    }

    public int compareTo(Object object) {
        int[] nArray = ((SpecificationVersion)object).digits;
        int n = 0;
        while (n < Math.max(this.digits.length, nArray.length)) {
            int n2;
            int n3 = n < this.digits.length ? this.digits[n] : 0;
            int n4 = n2 = n < nArray.length ? nArray[n] : 0;
            if (n3 != n2) {
                return n3 - n2;
            }
            ++n;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SpecificationVersion)) {
            return false;
        }
        return Utilities.compareObjects(this.digits, ((SpecificationVersion)object).digits);
    }

    public int hashCode() {
        int n = 925295;
        int n2 = 0;
        while (n2 < this.digits.length) {
            n ^= this.digits[n2] << n2;
            ++n2;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.digits.length * 3 + 1);
        int n = 0;
        while (n < this.digits.length) {
            if (n > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(this.digits[n]);
            ++n;
        }
        return stringBuffer.toString();
    }
}

