
#include <stdio.h>

#include "simple_fstream.hh"

namespace autil {

  void SimpleFstream::open(const string & name, const char * mode)
  {
    assert (file_ == 0);
    file_ = fopen(name.c_str(),mode);
  }

  void SimpleFstream::close()
  {
    if (file_ != 0)
      fclose(file_);
    file_ = 0;
  }

  int SimpleFstream::file_no() 
  {
    return fileno(file_);
  }

  void SimpleFstream::restart()
  {
    flush();
    fseek(file_,0,SEEK_SET);
  }

  void SimpleFstream::skipws() 
  {
    int c;
    while (c = getc(file_), c != EOF && isspace(c));
    ungetc(c, file_);
  }


  SimpleFstream & operator>> (SimpleFstream & in, string & str)
  {
    in.skipws();
    int c;
    str = "";
    while (c = getc(in.file_), c != EOF && !isspace(c))
      str += static_cast<char>(c);
    ungetc(c, in.file_);
    return in;
  }

  SimpleFstream & operator<< (SimpleFstream & out, const string & str)
  {
    string::const_iterator i = str.begin();
    string::const_iterator end = str.end();
    while (i != end) {
      putc(*i, out.file_);
      ++i;
    }
    return out;
  }

  void getline(SimpleFstream & in, string & str, char delem)
  {
    str = "";
    int c;
    while (c = getc(in.file_), c != EOF && c != delem)
      str += static_cast<char>(c);
  }

  void SimpleFstream::read(char * str, unsigned int n)
  {
    fread(str,1,n,file_);
  }

  void SimpleFstream::write(const char * str, unsigned int n)
  {
    fwrite(str,1,n,file_);
  }

  SimpleFstream & operator>> (SimpleFstream & in, unsigned int & num)
  {
    int r = fscanf(in.file_, " %u", &num);
    if (r != 1)
      in.close();
    return in;
  }


  SimpleFstream & operator<< (SimpleFstream & out, unsigned int num)
  {
    fprintf(out.file_, "%u", num);
    return out;
  }

}
