*** orig/win32_55/inc/pgpEncode.h	Wed Aug 30 12:05:27 2000
--- modified/win32_55/inc/pgpEncode.h	Wed Aug 30 12:05:27 2000
***************
*** 1,35 ****
  /*____________________________________________________________________________
  	pgpEncode.h
  	
  	Copyright (C) 1997 Pretty Good Privacy, Inc.
  	All rights reserved.
  	
  	This file contains the prototypes for functions which build PGPOptionLists
  	and encode/decode files and buffers.
  
! 	$Id: pgpEncode.h,v 1.90 1997/10/21 20:29:00 lloyd Exp $
  ____________________________________________________________________________*/
  
  #ifndef Included_pgpEncode_h	/* [ */
  #define Included_pgpEncode_h
  
  #include "pgpPubTypes.h"
  
  #include "pgpSymmetricCipher.h"
  #include "pgpCFB.h"
  #include "pgpHash.h"
  
  #if PGP_MACINTOSH	/* [ */
  #include <Files.h>
  
  #if PRAGMA_ALIGN_SUPPORTED
  #pragma options align=mac68k
  #endif
  
  #endif	/* ] */
  
  
  /* Trust values, used to set validity values */
  #define kPGPKeyTrust_Mask       0x7u
  #define kPGPKeyTrust_Undefined	0x0u
  #define kPGPKeyTrust_Unknown	0x1u
--- 1,35 ----
  /*____________________________________________________________________________
  	pgpEncode.h
  	
  	Copyright (C) 1997 Pretty Good Privacy, Inc.
  	All rights reserved.
  	
  	This file contains the prototypes for functions which build PGPOptionLists
  	and encode/decode files and buffers.
  
! 	$Id: pgpEncode.h,v 1.1 2000/07/28 15:40:22 mhu Exp $
  ____________________________________________________________________________*/
  
  #ifndef Included_pgpEncode_h	/* [ */
  #define Included_pgpEncode_h
  
  #include "pgpPubTypes.h"
  
  #include "pgpSymmetricCipher.h"
  #include "pgpCFB.h"
  #include "pgpHash.h"
  
  #if PGP_MACINTOSH	/* [ */
  #include <Files.h>
  
  #if PRAGMA_ALIGN_SUPPORTED
  #pragma options align=mac68k
  #endif
  
  #endif	/* ] */
  
  
  /* Trust values, used to set validity values */
  #define kPGPKeyTrust_Mask       0x7u
  #define kPGPKeyTrust_Undefined	0x0u
  #define kPGPKeyTrust_Unknown	0x1u
***************
*** 270,526 ****
  	PGPEventKeyServerData		keyServerData;
  	PGPEventKeyServerSignData	keyServerSignData;
  } PGPEventData;
  
  /* Refs to internal "job" structure */
  typedef struct PGPJob *				PGPJobRef;
  typedef const struct PGPJob *		PGPConstPGPJobRef;
  
  #define	kInvalidPGPJobRef			((PGPJobRef) NULL)
  #define PGPJobRefIsValid( ref )		( (ref) != kInvalidPGPJobRef )
  
  /* PGPEvent structure */
  
  struct PGPEvent_
  {
  	PGPVersion				 version;		/* Version of event structure */
  	struct PGPEvent_		*nextEvent;		/* Allow lists of events */
  	PGPJobRef				 job;			/* Associated with what job */
  	PGPEventType			 type;			/* Type of event */
  	PGPEventData			 data;			/* Event specific data */
  };
  typedef struct PGPEvent_ PGPEvent;
  
  
  /* Standard event callback declaration */
! typedef PGPError (*PGPEventHandlerProcPtr)(PGPContextRef context,
  						PGPEvent *event, PGPUserValue userValue);
  
  
  PGP_BEGIN_C_DECLARATIONS
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import on
  #endif
  
  /*
  **	Functions to encode and decode. The variable parameters are one or more
  **	PGPOptionListRef's which describe the inputs, outputs, and options.
  */
  
! PGPError 				PGPEncode(PGPContextRef context,
  								PGPOptionListRef firstOption, ...);
! PGPError 				PGPDecode(PGPContextRef context,
  								PGPOptionListRef firstOption, ...);
  
! PGPError				PGPNewOptionList( PGPContextRef context,
  							PGPOptionListRef *outList );
! PGPError 				PGPAppendOptionList(
  								PGPContextRef context,
  								PGPOptionListRef optionList,
  								PGPOptionListRef firstOption, ...);
! PGPError 				PGPBuildOptionList( PGPContextRef context,
  							PGPOptionListRef *outList,
  							PGPOptionListRef firstOption, ...);
! PGPError		 		PGPCopyOptionList(PGPConstOptionListRef optionList,
  							PGPOptionListRef *outList );
! PGPError 				PGPFreeOptionList(PGPOptionListRef optionList);
! PGPError 				PGPAddJobOptions(PGPJobRef job,
  								PGPOptionListRef firstOption, ...);
  
  
  /*
  **	The following functions are used to create PGPOptionListRef's for
  **	specifying the various options to PGPEncode() and PGPEncode(). The
  **	functions can be used as inline parameters in a temporary manner or
  **	used with PGPBuildOptionList() to create persistent lists.
  */
  
  /*
  ** Special PGPOptionListRef to mark last option passed to those functions
  ** which take variable lists of PGPOptionListRef's:
  */
  
! PGPOptionListRef 		PGPOLastOption( PGPContextRef context );
  
  /*
  ** Special PGPOptionListRef which is always ignored:
  */
  
! PGPOptionListRef 		PGPONullOption( PGPContextRef context);
  
  /* Data input (required): */
  
! PGPOptionListRef 		PGPOInputFile( PGPContextRef context,
  							PGPConstFileSpecRef fileRef);
! PGPOptionListRef 		PGPOInputBuffer( PGPContextRef context,
  							void const *buffer, PGPSize bufferSize);
  #if PGP_MACINTOSH
! PGPOptionListRef 		PGPOInputFileFSSpec( PGPContextRef context,
  							const FSSpec *fileSpec);
  #endif
  	
  /* Data output (optional, generates event if missing): */
  
! PGPOptionListRef 		PGPOOutputFile( PGPContextRef context,
  							PGPConstFileSpecRef fileRef);
! PGPOptionListRef 		PGPOOutputBuffer( PGPContextRef context,
  							void *buffer, PGPSize bufferSize,
  							PGPSize *outputDataLength);
  #if PGP_MACINTOSH
! PGPOptionListRef 		PGPOOutputFileFSSpec( PGPContextRef context,
  							const FSSpec *fileSpec);
  #endif
  
  /* '*buffer' must be disposed of via PGPFreeData() */
  /* maximum memory usage will be no more than maximumBufferSize */
! PGPOptionListRef 		PGPOAllocatedOutputBuffer(PGPContextRef context,
  							void **buffer,
  							PGPSize maximumBufferSize,
  							PGPSize *actualBufferSize);
! PGPOptionListRef 		PGPOAppendOutput( PGPContextRef context,
  							PGPBoolean appendOutput );
! PGPOptionListRef 		PGPODiscardOutput( PGPContextRef context,
  							PGPBoolean discardOutput );
! PGPOptionListRef 		PGPOAskUserForOutput( PGPContextRef context,
  							PGPBoolean askUserForOutput );
  
  /* Encrypting and signing */
  
! PGPOptionListRef 		PGPOEncryptToKey( PGPContextRef context,
  							PGPKeyRef keyRef);
! PGPOptionListRef 		PGPOEncryptToKeySet( PGPContextRef context,
  							PGPKeySetRef keySetRef);
! PGPOptionListRef 		PGPOEncryptToUserID( PGPContextRef context,
  							PGPUserIDRef userIDRef);
! PGPOptionListRef 		PGPOSignWithKey( PGPContextRef context,
  							PGPKeyRef keyRef,
  							PGPOptionListRef firstOption, ...);
! PGPOptionListRef 		PGPOConventionalEncrypt( PGPContextRef context,
  							PGPOptionListRef firstOption,
  								...);
  
! PGPOptionListRef 		PGPOPassphraseBuffer( PGPContextRef context,
  							const void *passphrase, PGPSize passphraseLength);
! PGPOptionListRef 		PGPOPassphrase( PGPContextRef context,
  							const char *passphrase);
! PGPOptionListRef 		PGPOAskUserForEntropy( PGPContextRef context,
  							PGPBoolean askUserForEntropy );
! PGPOptionListRef 		PGPORawPGPInput( PGPContextRef context,
  							PGPBoolean rawPGPInput );
! PGPOptionListRef 		PGPOCompression( PGPContextRef context,
  							PGPBoolean compression );
  
! PGPOptionListRef		PGPOLocalEncoding( PGPContextRef context,
  							PGPLocalEncodingFlags localEncode);
! PGPOptionListRef		PGPOOutputLineEndType(PGPContextRef context,
  							PGPLineEndType lineEnd);
! PGPOptionListRef		PGPOPGPMIMEEncoding(PGPContextRef context,
  							PGPBoolean mimeEncoding, PGPSize *mimeBodyOffset,
  							char mimeSeparator[ kPGPMimeSeparatorSize ]);
! PGPOptionListRef		PGPOOmitMIMEVersion( PGPContextRef context,
  							PGPBoolean omitVersion);
  							
! PGPOptionListRef 		PGPODetachedSig( PGPContextRef context,
  							PGPOptionListRef firstOption,
  								...);
  
! PGPOptionListRef 		PGPOCipherAlgorithm( PGPContextRef context,
  							PGPCipherAlgorithm algorithm);
! PGPOptionListRef 		PGPOHashAlgorithm( PGPContextRef context,
  							PGPHashAlgorithm algorithm);
  
! PGPOptionListRef 		PGPOFailBelowValidity( PGPContextRef context,
  							PGPValidity minValidity);
! PGPOptionListRef 		PGPOWarnBelowValidity( PGPContextRef context,
  							PGPValidity minValidity);
  
  
! PGPOptionListRef 		PGPOEventHandler( PGPContextRef context,
  							PGPEventHandlerProcPtr handler,
  								PGPUserValue userValue);
! PGPOptionListRef 		PGPOSendNullEvents( PGPContextRef context,
  							PGPTimeInterval approxInterval);
  	
! PGPOptionListRef 		PGPOArmorOutput( PGPContextRef context,
  							PGPBoolean armorOutput );
! PGPOptionListRef 		PGPODataIsASCII( PGPContextRef context,
  							PGPBoolean dataIsASCII );
! PGPOptionListRef 		PGPOClearSign( PGPContextRef context,
  							PGPBoolean clearSign );
! PGPOptionListRef 		PGPOForYourEyesOnly( PGPContextRef context,
  							PGPBoolean forYourEyesOnly );
! PGPOptionListRef 		PGPOKeySetRef( PGPContextRef context,
  							PGPKeySetRef keysetRef);
  
! PGPOptionListRef 		PGPOImportKeysTo( PGPContextRef context,
  							PGPKeySetRef keysetRef);
! PGPOptionListRef 		PGPOSendEventIfKeyFound( PGPContextRef context,
  							PGPBoolean sendEventIfKeyFound );
! PGPOptionListRef 		PGPOPassThroughIfUnrecognized( PGPContextRef context,
  							PGPBoolean passThroughIfUnrecognized );
  
! PGPOptionListRef		PGPOKeyGenParams( PGPContextRef context,
  							PGPPublicKeyAlgorithm pubKeyAlg,
  							PGPUInt32 bits);
  								
! PGPOptionListRef		PGPOKeyGenName( PGPContextRef context,
  							const void *name, PGPSize nameLength);
  							
! PGPOptionListRef		PGPOExpiration( PGPContextRef context,
  							PGPUInt32 expirationDays);
  							
! PGPOptionListRef		PGPOAdditionalRecipientRequestKeySet(
  							PGPContextRef context, 
  							PGPKeySetRef arKeySetRef, PGPByte arkClass);
  								
! PGPOptionListRef		PGPOKeyGenMasterKey( PGPContextRef context,
  							PGPKeyRef masterKeyRef);
  							
! PGPOptionListRef		PGPOPreferredAlgorithms(
  							PGPContextRef context, 
  							PGPCipherAlgorithm const *prefAlg,
  							PGPUInt32 numAlgs);
  								
! PGPOptionListRef		PGPOKeyGenFast( PGPContextRef context,
  							PGPBoolean fastGen);
  							
! PGPOptionListRef		PGPOCommentString( PGPContextRef context,
  							char const *comment);
  
! PGPOptionListRef		PGPOVersionString( PGPContextRef context,
  							char const *version);
  							
! PGPOptionListRef		PGPOSigRegularExpression(PGPContextRef context,
  							char const *regularExpression);
  							
! PGPOptionListRef		PGPOExportPrivateKeys( PGPContextRef context,
  							PGPBoolean exportPrivate);
  							
! PGPOptionListRef		PGPOExportable( PGPContextRef context,
  							PGPBoolean exportable);
  							
! PGPOptionListRef		PGPOSigTrust( PGPContextRef context,
  							PGPUInt32 trustLevel,
  							PGPUInt32 trustValue);
  
  
  
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import reset
  #endif
  PGP_END_C_DECLARATIONS
  
  
  
  #if PGP_MACINTOSH
  #if PRAGMA_ALIGN_SUPPORTED
  #pragma options align=reset
  #endif
  #endif
  
  
  #endif /* ] Included_pgpEncode_h */
  
  
  /*__Editor_settings____
  
  	Local Variables:
--- 270,526 ----
  	PGPEventKeyServerData		keyServerData;
  	PGPEventKeyServerSignData	keyServerSignData;
  } PGPEventData;
  
  /* Refs to internal "job" structure */
  typedef struct PGPJob *				PGPJobRef;
  typedef const struct PGPJob *		PGPConstPGPJobRef;
  
  #define	kInvalidPGPJobRef			((PGPJobRef) NULL)
  #define PGPJobRefIsValid( ref )		( (ref) != kInvalidPGPJobRef )
  
  /* PGPEvent structure */
  
  struct PGPEvent_
  {
  	PGPVersion				 version;		/* Version of event structure */
  	struct PGPEvent_		*nextEvent;		/* Allow lists of events */
  	PGPJobRef				 job;			/* Associated with what job */
  	PGPEventType			 type;			/* Type of event */
  	PGPEventData			 data;			/* Event specific data */
  };
  typedef struct PGPEvent_ PGPEvent;
  
  
  /* Standard event callback declaration */
! typedef PGPError (PGPAPI *PGPEventHandlerProcPtr)(PGPContextRef context,
  						PGPEvent *event, PGPUserValue userValue);
  
  
  PGP_BEGIN_C_DECLARATIONS
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import on
  #endif
  
  /*
  **	Functions to encode and decode. The variable parameters are one or more
  **	PGPOptionListRef's which describe the inputs, outputs, and options.
  */
  
! PGPError 	PGPAPI PGPEncode(PGPContextRef context,
  								PGPOptionListRef firstOption, ...);
! PGPError 	PGPAPI PGPDecode(PGPContextRef context,
  								PGPOptionListRef firstOption, ...);
  
! PGPError	PGPAPI PGPNewOptionList( PGPContextRef context,
  							PGPOptionListRef *outList );
! PGPError 	PGPAPI PGPAppendOptionList(
  								PGPContextRef context,
  								PGPOptionListRef optionList,
  								PGPOptionListRef firstOption, ...);
! PGPError 	PGPAPI PGPBuildOptionList( PGPContextRef context,
  							PGPOptionListRef *outList,
  							PGPOptionListRef firstOption, ...);
! PGPError	PGPAPI PGPCopyOptionList(PGPConstOptionListRef optionList,
  							PGPOptionListRef *outList );
! PGPError 	PGPAPI PGPFreeOptionList(PGPOptionListRef optionList);
! PGPError 	PGPAPI PGPAddJobOptions(PGPJobRef job,
  								PGPOptionListRef firstOption, ...);
  
  
  /*
  **	The following functions are used to create PGPOptionListRef's for
  **	specifying the various options to PGPEncode() and PGPEncode(). The
  **	functions can be used as inline parameters in a temporary manner or
  **	used with PGPBuildOptionList() to create persistent lists.
  */
  
  /*
  ** Special PGPOptionListRef to mark last option passed to those functions
  ** which take variable lists of PGPOptionListRef's:
  */
  
! PGPOptionListRef 	PGPAPI PGPOLastOption( PGPContextRef context );
  
  /*
  ** Special PGPOptionListRef which is always ignored:
  */
  
! PGPOptionListRef 	PGPAPI PGPONullOption( PGPContextRef context);
  
  /* Data input (required): */
  
! PGPOptionListRef 	PGPAPI PGPOInputFile( PGPContextRef context,
  							PGPConstFileSpecRef fileRef);
! PGPOptionListRef 	PGPAPI PGPOInputBuffer( PGPContextRef context,
  							void const *buffer, PGPSize bufferSize);
  #if PGP_MACINTOSH
! PGPOptionListRef 	PGPAPI PGPOInputFileFSSpec( PGPContextRef context,
  							const FSSpec *fileSpec);
  #endif
  	
  /* Data output (optional, generates event if missing): */
  
! PGPOptionListRef 	PGPAPI PGPOOutputFile( PGPContextRef context,
  							PGPConstFileSpecRef fileRef);
! PGPOptionListRef 	PGPAPI PGPOOutputBuffer( PGPContextRef context,
  							void *buffer, PGPSize bufferSize,
  							PGPSize *outputDataLength);
  #if PGP_MACINTOSH
! PGPOptionListRef 	PGPAPI PGPOOutputFileFSSpec( PGPContextRef context,
  							const FSSpec *fileSpec);
  #endif
  
  /* '*buffer' must be disposed of via PGPFreeData() */
  /* maximum memory usage will be no more than maximumBufferSize */
! PGPOptionListRef 	PGPAPI PGPOAllocatedOutputBuffer(PGPContextRef context,
  							void **buffer,
  							PGPSize maximumBufferSize,
  							PGPSize *actualBufferSize);
! PGPOptionListRef 	PGPAPI PGPOAppendOutput( PGPContextRef context,
  							PGPBoolean appendOutput );
! PGPOptionListRef 	PGPAPI PGPODiscardOutput( PGPContextRef context,
  							PGPBoolean discardOutput );
! PGPOptionListRef 	PGPAPI PGPOAskUserForOutput( PGPContextRef context,
  							PGPBoolean askUserForOutput );
  
  /* Encrypting and signing */
  
! PGPOptionListRef 	PGPAPI PGPOEncryptToKey( PGPContextRef context,
  							PGPKeyRef keyRef);
! PGPOptionListRef 	PGPAPI PGPOEncryptToKeySet( PGPContextRef context,
  							PGPKeySetRef keySetRef);
! PGPOptionListRef 	PGPAPI PGPOEncryptToUserID( PGPContextRef context,
  							PGPUserIDRef userIDRef);
! PGPOptionListRef 	PGPAPI PGPOSignWithKey( PGPContextRef context,
  							PGPKeyRef keyRef,
  							PGPOptionListRef firstOption, ...);
! PGPOptionListRef 	PGPAPI PGPOConventionalEncrypt( PGPContextRef context,
  							PGPOptionListRef firstOption,
  								...);
  
! PGPOptionListRef 	PGPAPI PGPOPassphraseBuffer( PGPContextRef context,
  							const void *passphrase, PGPSize passphraseLength);
! PGPOptionListRef 	PGPAPI PGPOPassphrase( PGPContextRef context,
  							const char *passphrase);
! PGPOptionListRef 	PGPAPI PGPOAskUserForEntropy( PGPContextRef context,
  							PGPBoolean askUserForEntropy );
! PGPOptionListRef 	PGPAPI PGPORawPGPInput( PGPContextRef context,
  							PGPBoolean rawPGPInput );
! PGPOptionListRef 	PGPAPI PGPOCompression( PGPContextRef context,
  							PGPBoolean compression );
  
! PGPOptionListRef	PGPAPI PGPOLocalEncoding( PGPContextRef context,
  							PGPLocalEncodingFlags localEncode);
! PGPOptionListRef	PGPAPI PGPOOutputLineEndType(PGPContextRef context,
  							PGPLineEndType lineEnd);
! PGPOptionListRef	PGPAPI PGPOPGPMIMEEncoding(PGPContextRef context,
  							PGPBoolean mimeEncoding, PGPSize *mimeBodyOffset,
  							char mimeSeparator[ kPGPMimeSeparatorSize ]);
! PGPOptionListRef	PGPAPI PGPOOmitMIMEVersion( PGPContextRef context,
  							PGPBoolean omitVersion);
  							
! PGPOptionListRef 	PGPAPI PGPODetachedSig( PGPContextRef context,
  							PGPOptionListRef firstOption,
  								...);
  
! PGPOptionListRef 	PGPAPI PGPOCipherAlgorithm( PGPContextRef context,
  							PGPCipherAlgorithm algorithm);
! PGPOptionListRef 	PGPAPI PGPOHashAlgorithm( PGPContextRef context,
  							PGPHashAlgorithm algorithm);
  
! PGPOptionListRef 	PGPAPI PGPOFailBelowValidity( PGPContextRef context,
  							PGPValidity minValidity);
! PGPOptionListRef 	PGPAPI PGPOWarnBelowValidity( PGPContextRef context,
  							PGPValidity minValidity);
  
  
! PGPOptionListRef 	PGPAPI PGPOEventHandler( PGPContextRef context,
  							PGPEventHandlerProcPtr handler,
  								PGPUserValue userValue);
! PGPOptionListRef 	PGPAPI PGPOSendNullEvents( PGPContextRef context,
  							PGPTimeInterval approxInterval);
  	
! PGPOptionListRef 	PGPAPI PGPOArmorOutput( PGPContextRef context,
  							PGPBoolean armorOutput );
! PGPOptionListRef 	PGPAPI PGPODataIsASCII( PGPContextRef context,
  							PGPBoolean dataIsASCII );
! PGPOptionListRef 	PGPAPI PGPOClearSign( PGPContextRef context,
  							PGPBoolean clearSign );
! PGPOptionListRef 	PGPAPI PGPOForYourEyesOnly( PGPContextRef context,
  							PGPBoolean forYourEyesOnly );
! PGPOptionListRef 	PGPAPI PGPOKeySetRef( PGPContextRef context,
  							PGPKeySetRef keysetRef);
  
! PGPOptionListRef 	PGPAPI PGPOImportKeysTo( PGPContextRef context,
  							PGPKeySetRef keysetRef);
! PGPOptionListRef 	PGPAPI PGPOSendEventIfKeyFound( PGPContextRef context,
  							PGPBoolean sendEventIfKeyFound );
! PGPOptionListRef 	PGPAPI PGPOPassThroughIfUnrecognized( PGPContextRef context,
  							PGPBoolean passThroughIfUnrecognized );
  
! PGPOptionListRef	PGPAPI PGPOKeyGenParams( PGPContextRef context,
  							PGPPublicKeyAlgorithm pubKeyAlg,
  							PGPUInt32 bits);
  								
! PGPOptionListRef	PGPAPI PGPOKeyGenName( PGPContextRef context,
  							const void *name, PGPSize nameLength);
  							
! PGPOptionListRef	PGPAPI PGPOExpiration( PGPContextRef context,
  							PGPUInt32 expirationDays);
  							
! PGPOptionListRef	PGPAPI PGPOAdditionalRecipientRequestKeySet(
  							PGPContextRef context, 
  							PGPKeySetRef arKeySetRef, PGPByte arkClass);
  								
! PGPOptionListRef	PGPAPI PGPOKeyGenMasterKey( PGPContextRef context,
  							PGPKeyRef masterKeyRef);
  							
! PGPOptionListRef	PGPAPI PGPOPreferredAlgorithms(
  							PGPContextRef context, 
  							PGPCipherAlgorithm const *prefAlg,
  							PGPUInt32 numAlgs);
  								
! PGPOptionListRef	PGPAPI PGPOKeyGenFast( PGPContextRef context,
  							PGPBoolean fastGen);
  							
! PGPOptionListRef	PGPAPI PGPOCommentString( PGPContextRef context,
  							char const *comment);
  
! PGPOptionListRef	PGPAPI PGPOVersionString( PGPContextRef context,
  							char const *version);
  							
! PGPOptionListRef	PGPAPI PGPOSigRegularExpression(PGPContextRef context,
  							char const *regularExpression);
  							
! PGPOptionListRef	PGPAPI PGPOExportPrivateKeys( PGPContextRef context,
  							PGPBoolean exportPrivate);
  							
! PGPOptionListRef	PGPAPI PGPOExportable( PGPContextRef context,
  							PGPBoolean exportable);
  							
! PGPOptionListRef	PGPAPI PGPOSigTrust( PGPContextRef context,
  							PGPUInt32 trustLevel,
  							PGPUInt32 trustValue);
  
  
  
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import reset
  #endif
  PGP_END_C_DECLARATIONS
  
  
  
  #if PGP_MACINTOSH
  #if PRAGMA_ALIGN_SUPPORTED
  #pragma options align=reset
  #endif
  #endif
  
  
  #endif /* ] Included_pgpEncode_h */
  
  
  /*__Editor_settings____
  
  	Local Variables:
