*** orig/win32_60/inc/pgpTLS.h	Wed Aug 30 12:08:12 2000
--- modified/win32_60/inc/pgpTLS.h	Wed Aug 30 12:08:12 2000
***************
*** 1,30 ****
  /*____________________________________________________________________________
  	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
  	All rights reserved.
  	
! 	$Id: pgpTLS.h,v 1.25.2.1.2.1 1998/11/12 03:23:44 heller Exp $
  ____________________________________________________________________________*/
  #ifndef Included_PGPtls_h	/* [ */
  #define Included_PGPtls_h
  
  #include "pgpPubTypes.h"
  
  PGP_BEGIN_C_DECLARATIONS
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import on
  #endif
  
  
  typedef struct PGPtlsContext *			PGPtlsContextRef;
  typedef const struct PGPtlsContext *	PGPtlsConstContextRef;
  
  #define	kInvalidPGPtlsContextRef		((PGPtlsContextRef) NULL)
  #define PGPtlsContextRefIsValid( ref )	( (ref) != kInvalidPGPtlsContextRef )
  
  typedef struct PGPtlsSession *			PGPtlsSessionRef;
  typedef const struct PGPtlsSession *	PGPtlsConstSessionRef;
  
  #define	kInvalidPGPtlsSessionRef		((PGPtlsSessionRef) NULL)
  #define PGPtlsSessionRefIsValid( ref )	( (ref) != kInvalidPGPtlsSessionRef )
  
  
--- 1,30 ----
  /*____________________________________________________________________________
  	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
  	All rights reserved.
  	
! 	$Id: pgpTLS.h,v 1.1 2000/07/28 15:52:10 mhu Exp $
  ____________________________________________________________________________*/
  #ifndef Included_PGPtls_h	/* [ */
  #define Included_PGPtls_h
  
  #include "pgpPubTypes.h"
  
  PGP_BEGIN_C_DECLARATIONS
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import on
  #endif
  
  
  typedef struct PGPtlsContext *			PGPtlsContextRef;
  typedef const struct PGPtlsContext *	PGPtlsConstContextRef;
  
  #define	kInvalidPGPtlsContextRef		((PGPtlsContextRef) NULL)
  #define PGPtlsContextRefIsValid( ref )	( (ref) != kInvalidPGPtlsContextRef )
  
  typedef struct PGPtlsSession *			PGPtlsSessionRef;
  typedef const struct PGPtlsSession *	PGPtlsConstSessionRef;
  
  #define	kInvalidPGPtlsSessionRef		((PGPtlsSessionRef) NULL)
  #define PGPtlsSessionRefIsValid( ref )	( (ref) != kInvalidPGPtlsSessionRef )
  
  
***************
*** 94,310 ****
  	kPGPtls_AT_AccessDenied			= 49,	/* FATAL */
  	kPGPtls_AT_DecodeError			= 50,	/* FATAL */
  	kPGPtls_AT_DecryptError			= 51,
  	kPGPtls_AT_ExportRestriction	= 60,	/* FATAL */
  	kPGPtls_AT_ProtocolVersion		= 70,	/* FATAL */
  	kPGPtls_AT_InsufficientSecurity	= 71,	/* FATAL */
  	kPGPtls_AT_InternalError		= 80,	/* FATAL */
  	kPGPtls_AT_UserCancelled		= 90,
  	kPGPtls_AT_NoRenegotiation		= 100,
  	
  	kPGPtls_AT_None					= 255,
  
  	PGP_ENUM_FORCE( PGPtlsAlert_ )
  };
  PGPENUM_TYPEDEF( PGPtlsAlert_, PGPtlsAlert );
  
  /* The Send and Receive function pointers should return
  	kPGPError_TLSWouldBlock when the socket is non-blocking and the
  	call would block.  The Send and Receive functions passed in will
  	need to translate the platform-specific socket error in appropriate
  	cases by using calls such as WSAGetLastError() on Win32.  Remember
  	to call PGPtlsSendQueueIdle for non-blocking sockets also if
  	kPGPError_TLSWouldBlock is returned from a send on a non-blocking
  	socket. */
  
! typedef PGPInt32 (* PGPtlsReceiveProcPtr)(void *inData, void *outBuffer,
  										PGPInt32 inBufferSize);
! typedef PGPInt32 (* PGPtlsSendProcPtr)(void *inData, const void *inBuffer,
  										PGPInt32 inBufferLength);
  
  
! PGPError 	PGPNewTLSContext( PGPContextRef context,
  					PGPtlsContextRef *outRef );
  
! PGPError 	PGPFreeTLSContext( PGPtlsContextRef ref );
  
  /*____________________________________________________________________________
  	The following function activates or deactivates the session key cache
  	for TLS sessions.  This defaults to on but can be deactivated with this
  	function to force all connections to proceed through the entire
  	handshake.
  ____________________________________________________________________________*/
! PGPError	PGPtlsSetCache( PGPtlsContextRef ref, PGPBoolean useCache );
  
! PGPError	PGPtlsClearCache( PGPtlsContextRef ref );
  
! PGPError	PGPNewTLSSession( PGPtlsContextRef	ref,
  					PGPtlsSessionRef			*outRef );
  
! PGPError 	PGPFreeTLSSession( PGPtlsSessionRef ref );
  
  /* Default options are client side and no client cert request */
! PGPError	PGPtlsSetProtocolOptions( PGPtlsSessionRef ref,
  					PGPtlsFlags options );
  					
  
  /*____________________________________________________________________________
  	The following function must be called to cleanly close a TLS
  	connection.  If it is not called, the session will not be able
  	to be resumed from the session cache.
  	
  	In the event the application determines any problem with the
  	connection such as the remote key not being valid, call this
  	function with dontCache set to true in order to not cache the
  	session keys.
  ____________________________________________________________________________*/
! PGPError	PGPtlsClose( PGPtlsSessionRef	ref,
  					PGPBoolean				dontCache );
  
  /*____________________________________________________________________________
  	The following function must be called to initiate the PGPtls session.
  	Once a TLS session has been assigned to a socket, no data can be sent
  	over that socket by the application until the handshake is completed.
  	Handshake completion is indicated by completion of this call without
  	error or by checking the state of the PGPtlsSession.  It will be
  	kPGPtls_ReadyState when the application layer may send and receive
  	data securely.
  	
  	This function performs all negotiation of the TLS connection.
  ____________________________________________________________________________*/
! PGPError	PGPtlsHandshake( PGPtlsSessionRef ref );
  
  /*____________________________________________________________________________
  	The following function should be called before PGPtlsHandshake.
  	In the general case, the remoteID will be an IP address.  This
  	is provided to PGPtls in order to allow it to cache the current
  	session and be able to look it up later.  If the remoteID passed
  	into a future session is the same as a previously cached session,
  	PGPtls will attempt to resume the session.
  ____________________________________________________________________________*/
! PGPError	PGPtlsSetRemoteUniqueID( PGPtlsSessionRef ref,
  					PGPUInt32 remoteID );
  
  /*____________________________________________________________________________
  	The following function sets the local private authenticating key.
  	
  	The passphrase and key are retained in memory.  By default, no
  	key is specified and a client side session will return no key in the
  	client key exchange message to the server.
  	It is an error not to specify a key on a server side TLS session.
  	This function must be passed either PGPOPassphrase or PGPOPasskeyBuffer.
  ____________________________________________________________________________*/
! PGPError	PGPtlsSetLocalPrivateKey( PGPtlsSessionRef ref,
  					PGPKeyRef			inKey,
  					PGPOptionListRef	firstOption, ... );
  					
  /*____________________________________________________________________________
  	The following function sets the preferred cipher suite.
  	
  	There is no guarantee that cipher will actually be negotiated,
  	but it will be attempted in preference to others.
  ____________________________________________________________________________*/
! PGPError	PGPtlsSetPreferredCipherSuite( PGPtlsSessionRef ref,
  					PGPtlsCipherSuiteNum cipher );
  
  /*____________________________________________________________________________
  	The following function sets the desired DH prime.
  	
  	The requested primes are drawn from a set of primes hard-coded
  	into PGPtls.  New primes can be added in a fully compatible
  	fashion since the server sends the prime to the client, but this
  	version of the API does not support passing in a desired prime.  The
  	default prime if this function is not called is kPGPtls_DHPrime2048.
  ____________________________________________________________________________*/
! PGPError	PGPtlsSetDHPrime( PGPtlsSessionRef ref,
  					PGPtlsPrime prime );
  
  /*____________________________________________________________________________
  	The following function gets the authenticated remote key after a
  	successful handshake.
  	
  	The key returned must already have been approved through the callback
  	mechanism.  The PGPEvent mechanism is used to request approval from the
  	client of the remote key received during the TLS handshake.  The
  	callback should be set through the standard PGPSockets callback
  	mechanism.  The event kPGPEvent_TLSRemoteKeyApprovalEvent will be
  	used in this case.  In some cases, the
  	kPGPEvent_TLSRemoteKeyApprovalEvent may only pass a Key ID to the
  	caller, and it will be up to the caller to resolve the Key ID into a
  	key and pass the PGPKeyRef back to TLS.
  ____________________________________________________________________________*/
! PGPError	PGPtlsGetRemoteAuthenticatedKey( PGPtlsSessionRef ref,
  					PGPKeyRef *outKey );
  
  /*____________________________________________________________________________
  	The following function returns the negotiated symmetric cipher.
  	
  	This function will return an error if called before a successful
  	handshake.
  ____________________________________________________________________________*/
! PGPError	PGPtlsGetNegotiatedCipherSuite( PGPtlsSessionRef ref,
  					PGPtlsCipherSuiteNum *outCipher );
  
! PGPError	PGPtlsGetState( PGPtlsSessionRef ref,
  					PGPtlsProtocolState *outState );
  
  /*____________________________________________________________________________
  	The following two functions process data through TLS.
  	
  	It is an error to call these functions without having set a
  	Read function pointer or Write function pointer.  Most applications
  	will never need to use these functions as the function pointers
  	are automatically configured by PGPsockets, and these functions
  	are automatically called by the PGPsockets implementations of
  	PGPWrite and PGPRead whenever a PGPtlsSessionRef has been set for
  	a given socket.
  ____________________________________________________________________________*/
! PGPError	PGPtlsReceive( PGPtlsSessionRef ref,
  					void *			outBuffer,
  					PGPSize *		bufferSize );
  
! PGPError	PGPtlsSend( PGPtlsSessionRef ref,
  					const void *	inBuffer,
  					PGPSize 		inBufferLength );
  					
! PGPError	PGPtlsSetReceiveCallback( PGPtlsSessionRef	ref,
  					PGPtlsReceiveProcPtr	tlsReceiveProc,
  					void *					inData );
  
! PGPError	PGPtlsSetSendCallback( PGPtlsSessionRef ref,
  					PGPtlsSendProcPtr		tlsSendProc,
  					void *					inData );
  
  
  /*____________________________________________________________________________
  	The following function is necessary *only* on a non-blocking socket.
  	If a call to PGPtlsSend returns kPGPError_TLSWouldBlock, call
  	the following function repeatedly until that error is no longer
  	returned in order to make sure data is sent.  Another call to
  	PGPtlsSend will also call this function automatically and queue
  	any new data if necessary.
  ____________________________________________________________________________*/
! PGPError	PGPtlsSendQueueIdle( PGPtlsSessionRef ref );
  					
  /*____________________________________________________________________________
  	The following function gets the ID of the fatal alert which caused
  	the TLS session to abort and go into the kPGPtls_FatalErrorState.
  ____________________________________________________________________________*/
! PGPError	PGPtlsGetAlert( PGPtlsSessionRef ref, PGPtlsAlert *outAlert );
  
  
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import reset
  #endif
  PGP_END_C_DECLARATIONS
  
  #endif /* ] Included_PGPtls_h */
  
  
  /*__Editor_settings____
  
  	Local Variables:
  	tab-width: 4
  	End:
  	vi: ts=4 sw=4
  	vim: si
  _____________________*/
--- 94,310 ----
  	kPGPtls_AT_AccessDenied			= 49,	/* FATAL */
  	kPGPtls_AT_DecodeError			= 50,	/* FATAL */
  	kPGPtls_AT_DecryptError			= 51,
  	kPGPtls_AT_ExportRestriction	= 60,	/* FATAL */
  	kPGPtls_AT_ProtocolVersion		= 70,	/* FATAL */
  	kPGPtls_AT_InsufficientSecurity	= 71,	/* FATAL */
  	kPGPtls_AT_InternalError		= 80,	/* FATAL */
  	kPGPtls_AT_UserCancelled		= 90,
  	kPGPtls_AT_NoRenegotiation		= 100,
  	
  	kPGPtls_AT_None					= 255,
  
  	PGP_ENUM_FORCE( PGPtlsAlert_ )
  };
  PGPENUM_TYPEDEF( PGPtlsAlert_, PGPtlsAlert );
  
  /* The Send and Receive function pointers should return
  	kPGPError_TLSWouldBlock when the socket is non-blocking and the
  	call would block.  The Send and Receive functions passed in will
  	need to translate the platform-specific socket error in appropriate
  	cases by using calls such as WSAGetLastError() on Win32.  Remember
  	to call PGPtlsSendQueueIdle for non-blocking sockets also if
  	kPGPError_TLSWouldBlock is returned from a send on a non-blocking
  	socket. */
  
! typedef PGPInt32 (PGPAPI *PGPtlsReceiveProcPtr)(void *inData, void *outBuffer,
  										PGPInt32 inBufferSize);
! typedef PGPInt32 (PGPAPI *PGPtlsSendProcPtr)(void *inData, const void *inBuffer,
  										PGPInt32 inBufferLength);
  
  
! PGPError 	PGPAPI PGPNewTLSContext( PGPContextRef context,
  					PGPtlsContextRef *outRef );
  
! PGPError 	PGPAPI PGPFreeTLSContext( PGPtlsContextRef ref );
  
  /*____________________________________________________________________________
  	The following function activates or deactivates the session key cache
  	for TLS sessions.  This defaults to on but can be deactivated with this
  	function to force all connections to proceed through the entire
  	handshake.
  ____________________________________________________________________________*/
! PGPError	PGPAPI PGPtlsSetCache( PGPtlsContextRef ref, PGPBoolean useCache );
  
! PGPError	PGPAPI PGPtlsClearCache( PGPtlsContextRef ref );
  
! PGPError	PGPAPI PGPNewTLSSession( PGPtlsContextRef	ref,
  					PGPtlsSessionRef			*outRef );
  
! PGPError 	PGPAPI PGPFreeTLSSession( PGPtlsSessionRef ref );
  
  /* Default options are client side and no client cert request */
! PGPError	PGPAPI PGPtlsSetProtocolOptions( PGPtlsSessionRef ref,
  					PGPtlsFlags options );
  					
  
  /*____________________________________________________________________________
  	The following function must be called to cleanly close a TLS
  	connection.  If it is not called, the session will not be able
  	to be resumed from the session cache.
  	
  	In the event the application determines any problem with the
  	connection such as the remote key not being valid, call this
  	function with dontCache set to true in order to not cache the
  	session keys.
  ____________________________________________________________________________*/
! PGPError	PGPAPI PGPtlsClose( PGPtlsSessionRef	ref,
  					PGPBoolean				dontCache );
  
  /*____________________________________________________________________________
  	The following function must be called to initiate the PGPtls session.
  	Once a TLS session has been assigned to a socket, no data can be sent
  	over that socket by the application until the handshake is completed.
  	Handshake completion is indicated by completion of this call without
  	error or by checking the state of the PGPtlsSession.  It will be
  	kPGPtls_ReadyState when the application layer may send and receive
  	data securely.
  	
  	This function performs all negotiation of the TLS connection.
  ____________________________________________________________________________*/
! PGPError	PGPAPI PGPtlsHandshake( PGPtlsSessionRef ref );
  
  /*____________________________________________________________________________
  	The following function should be called before PGPtlsHandshake.
  	In the general case, the remoteID will be an IP address.  This
  	is provided to PGPtls in order to allow it to cache the current
  	session and be able to look it up later.  If the remoteID passed
  	into a future session is the same as a previously cached session,
  	PGPtls will attempt to resume the session.
  ____________________________________________________________________________*/
! PGPError	PGPAPI PGPtlsSetRemoteUniqueID( PGPtlsSessionRef ref,
  					PGPUInt32 remoteID );
  
  /*____________________________________________________________________________
  	The following function sets the local private authenticating key.
  	
  	The passphrase and key are retained in memory.  By default, no
  	key is specified and a client side session will return no key in the
  	client key exchange message to the server.
  	It is an error not to specify a key on a server side TLS session.
  	This function must be passed either PGPOPassphrase or PGPOPasskeyBuffer.
  ____________________________________________________________________________*/
! PGPError	PGPAPI PGPtlsSetLocalPrivateKey( PGPtlsSessionRef ref,
  					PGPKeyRef			inKey,
  					PGPOptionListRef	firstOption, ... );
  					
  /*____________________________________________________________________________
  	The following function sets the preferred cipher suite.
  	
  	There is no guarantee that cipher will actually be negotiated,
  	but it will be attempted in preference to others.
  ____________________________________________________________________________*/
! PGPError	PGPAPI PGPtlsSetPreferredCipherSuite( PGPtlsSessionRef ref,
  					PGPtlsCipherSuiteNum cipher );
  
  /*____________________________________________________________________________
  	The following function sets the desired DH prime.
  	
  	The requested primes are drawn from a set of primes hard-coded
  	into PGPtls.  New primes can be added in a fully compatible
  	fashion since the server sends the prime to the client, but this
  	version of the API does not support passing in a desired prime.  The
  	default prime if this function is not called is kPGPtls_DHPrime2048.
  ____________________________________________________________________________*/
! PGPError	PGPAPI PGPtlsSetDHPrime( PGPtlsSessionRef ref,
  					PGPtlsPrime prime );
  
  /*____________________________________________________________________________
  	The following function gets the authenticated remote key after a
  	successful handshake.
  	
  	The key returned must already have been approved through the callback
  	mechanism.  The PGPEvent mechanism is used to request approval from the
  	client of the remote key received during the TLS handshake.  The
  	callback should be set through the standard PGPSockets callback
  	mechanism.  The event kPGPEvent_TLSRemoteKeyApprovalEvent will be
  	used in this case.  In some cases, the
  	kPGPEvent_TLSRemoteKeyApprovalEvent may only pass a Key ID to the
  	caller, and it will be up to the caller to resolve the Key ID into a
  	key and pass the PGPKeyRef back to TLS.
  ____________________________________________________________________________*/
! PGPError	PGPAPI PGPtlsGetRemoteAuthenticatedKey( PGPtlsSessionRef ref,
  					PGPKeyRef *outKey );
  
  /*____________________________________________________________________________
  	The following function returns the negotiated symmetric cipher.
  	
  	This function will return an error if called before a successful
  	handshake.
  ____________________________________________________________________________*/
! PGPError	PGPAPI PGPtlsGetNegotiatedCipherSuite( PGPtlsSessionRef ref,
  					PGPtlsCipherSuiteNum *outCipher );
  
! PGPError	PGPAPI PGPtlsGetState( PGPtlsSessionRef ref,
  					PGPtlsProtocolState *outState );
  
  /*____________________________________________________________________________
  	The following two functions process data through TLS.
  	
  	It is an error to call these functions without having set a
  	Read function pointer or Write function pointer.  Most applications
  	will never need to use these functions as the function pointers
  	are automatically configured by PGPsockets, and these functions
  	are automatically called by the PGPsockets implementations of
  	PGPWrite and PGPRead whenever a PGPtlsSessionRef has been set for
  	a given socket.
  ____________________________________________________________________________*/
! PGPError	PGPAPI PGPtlsReceive( PGPtlsSessionRef ref,
  					void *			outBuffer,
  					PGPSize *		bufferSize );
  
! PGPError	PGPAPI PGPtlsSend( PGPtlsSessionRef ref,
  					const void *	inBuffer,
  					PGPSize 		inBufferLength );
  					
! PGPError	PGPAPI PGPtlsSetReceiveCallback( PGPtlsSessionRef	ref,
  					PGPtlsReceiveProcPtr	tlsReceiveProc,
  					void *					inData );
  
! PGPError	PGPAPI PGPtlsSetSendCallback( PGPtlsSessionRef ref,
  					PGPtlsSendProcPtr		tlsSendProc,
  					void *					inData );
  
  
  /*____________________________________________________________________________
  	The following function is necessary *only* on a non-blocking socket.
  	If a call to PGPtlsSend returns kPGPError_TLSWouldBlock, call
  	the following function repeatedly until that error is no longer
  	returned in order to make sure data is sent.  Another call to
  	PGPtlsSend will also call this function automatically and queue
  	any new data if necessary.
  ____________________________________________________________________________*/
! PGPError	PGPAPI PGPtlsSendQueueIdle( PGPtlsSessionRef ref );
  					
  /*____________________________________________________________________________
  	The following function gets the ID of the fatal alert which caused
  	the TLS session to abort and go into the kPGPtls_FatalErrorState.
  ____________________________________________________________________________*/
! PGPError	PGPAPI PGPtlsGetAlert( PGPtlsSessionRef ref, PGPtlsAlert *outAlert );
  
  
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import reset
  #endif
  PGP_END_C_DECLARATIONS
  
  #endif /* ] Included_PGPtls_h */
  
  
  /*__Editor_settings____
  
  	Local Variables:
  	tab-width: 4
  	End:
  	vi: ts=4 sw=4
  	vim: si
  _____________________*/
