/*************************************************************************
 *
 *  $RCSfile: ca_type.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ARY_CPP_CA_TYPE_HXX
#define ARY_CPP_CA_TYPE_HXX



// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
#include <ary/ids.hxx>
#include <ary/cpp/c_etypes.hxx>
	// PARAMETERS


namespace ary
{

namespace cpp
{
	class DisplayGate;



/**	Base of all C++ types
*/
class Type
{
  public:
    virtual             ~Type() {}

	Tid                 Id() const;
    Rid                 RelatedCe() const;
	bool                IsConst() const;
	void                Get_Text(
							StreamStr &         o_rOut,
							const DisplayGate &	i_rGate ) const;

    /** It is guaranteed, that the output is correct, also,
        if all three output-streams are the same instance.
    */
	void                Get_Text(
							StreamStr &         o_rPreName,
							StreamStr &         o_rName,
							StreamStr &         o_rPostName,
							const DisplayGate &	i_rGate ) const;

  private:
	virtual Tid         inq_Id_Type() const = 0;
    virtual Rid         inq_RelatedCe() const;  // Defaulted to 0.
	virtual bool        inq_IsConst() const = 0;
	virtual void        inq_Get_Text(
							StreamStr &         o_rPreName,
							StreamStr &         o_rName,
							StreamStr &         o_rPostName,
							const DisplayGate &	i_rGate ) const = 0;
};



/**	Represents types like: void, int, double.
*/
class BuiltInType : public Type
{
  public:
						BuiltInType(
							Tid					i_nId,
							const udmstri &		i_sName,
							E_TypeSpecialisation
												i_Specialisation );
  private:
	virtual Tid         inq_Id_Type() const;
	virtual bool        inq_IsConst() const;
	virtual void        inq_Get_Text(
							StreamStr &         o_rPreName,
							StreamStr &         o_rName,
							StreamStr &         o_rPostName,
							const DisplayGate &	i_rGate ) const;
	// DATA
	Tid                 nId;
	udmstri             sName;
	E_TypeSpecialisation
						eSpecialisation;
};

class NullType : public Type
{
  private:
	virtual Tid         inq_Id_Type() const;
	virtual bool        inq_IsConst() const;
	virtual void        inq_Get_Text(
							StreamStr &         o_rPreName,
							StreamStr &         o_rName,
							StreamStr &         o_rPostName,
							const DisplayGate &	i_rGate ) const;
};


// IMPLEMENTATION

inline Tid
Type::Id() const
	{ return inq_Id_Type(); }
inline Rid
Type::RelatedCe() const
	{ return inq_RelatedCe(); }
inline bool
Type::IsConst() const
	{ return inq_IsConst(); }
inline void
Type::Get_Text( StreamStr &         o_rOut,
				const DisplayGate &	i_rGate ) const
	{ inq_Get_Text( o_rOut, o_rOut, o_rOut, i_rGate ); }
inline void
Type::Get_Text( StreamStr &         o_rPreName,
				StreamStr &         o_rName,
				StreamStr &         o_rPostName,
				const DisplayGate &	i_rGate ) const
    { inq_Get_Text( o_rPreName,o_rName,o_rPostName, i_rGate ); }


}	// namespace cpp
}	// namespace ary


#endif




#if 0
class MemberPtr : public Type
{
  public:
};

class DataMemberPtr : public MemberPtr
{
  public:
                        DataMemberPtr(
	                        Tid                 i_nId,
	                        Cid                 i_nClass,
	                        Tid                 i_nMemberType );
     bool                operator<(
                            const DataMemberPtr &
                                                i_r ) const;
	virtual Tid         IdAsType() const;
  private:
	Tid                 nId;
	Cid                 nClass;
	Tid                 nMemberType;
};

class OperationMemberPtr : public MemberPtr
{
  public:
                        OperationMemberPtr(
	                        Tid                 i_nId,
	                        Cid                 i_nClass,
	                        OperationType       i_nMemberOperation );
    bool                operator<(
                            const OperationMemberPtr &
                                                i_r ) const;
	virtual Tid         IdAsType() const;
  private:
	 Tid				nId;
	 Cid				nClass;
	 OperationType      aMemberOperationType;
};

//********************************      NamedTypes      *****************************//

/**	Any template parameter, which is a type (class or typename)
*/
class TemplateParameterType : public Type
{
  public:
                        TemplateParameterType(
                            Tid                 i_nId,
                            const udmstri &     i_sName,
                            Cid                 i_nOwner ); // class or operation.

  private:
	virtual Tid         inq_Id_Type() const;
    virtual const char* inq_TextSegment() const;

    Tid                 nId;
    udmstri             sName;
    Cid                 nOwner;
};






//********************************      ReferingTypes      *****************************//

/**	Any type with has no own name, but refers to another type. At the end of
    this chain will be a named type.
*/
class ReferingType : public Type
{
  public:
	Tid                 ReferedType() const;

  protected:
                        ReferingType(
	                        Tid                 nId,
	                        Tid                 nReferedType );
  private:
	virtual Tid         inq_Id_Type() const;

    // DATA
	Tid                 nId;
	Tid                 nReferedType;
};

class ConstType : public ReferingType
{
  public:
						ConstType(
	                        Tid                 nId,
	                        Tid                 nReferedType );
  private:
    virtual const char* inq_TextSegment() const;
};

class VolatileType : public ReferingType
{
  public:
						VolatileType(
	                        Tid                 nId,
	                        Tid                 nReferedType );
  private:
    virtual const char* inq_TextSegment() const;
};

class PtrType : public ReferingType
{
  public:
						PtrType(
	                        Tid                 nId,
	                        Tid                 nReferedType );
  private:
    virtual const char* inq_TextSegment() const;
};

class RefType : public ReferingType
{
  public:
						RefType(
	                        Tid                 nId,
	                        Tid                 nReferedType );
  private:
    virtual const char* inq_TextSegment() const;
};



//********************************      ComplicatedTypes      *****************************//
class FunctionPtr : public Type
{
  public:
                        FunctionPtr(
	                        Tid                 i_nId,
                            OperationType       i_aOperationType );
    bool                operator<(
                            const FunctionPtr & i_r ) const;
	virtual Tid         IdAsType() const;
  private:
	Tid                 nId;
	OperationType       aOperationType;
};

class TemplateInstance : public Type
{
  public:
                        TemplateInstance(
	                        Tid                 i_nId,
                            Cid                 i_nReferedClass,
                            const char *        i_sInstantiation );
    bool                operator<(
                            const TemplateInstance &
                                                i_r ) const;
  private:
	virtual Tid         inq_Id_Type() const;
    virtual const char* inq_TextSegment() const;

    // DATA
	Tid                 nId;
    Cid                 nReferedClass;
	udmstri             sInstantiation;
};

#endif // 0
