/*************************************************************************
 *
 *  $RCSfile: htmlpie2.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CSI_HTML_HTMLPIEC_HXX
#define CSI_HTML_HTMLPIEC_HXX

// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
#include <cosv/template/swelist.hxx>
	// PARAMETERS

namespace csv
{
class File;
}




class Html_MultiPiece;



/// Html pieces of text interface.

class HtmlPiece
{
  public:
	virtual				~HtmlPiece() {}
	virtual void		WriteOut(
							csv::File &			io_aFile ) = 0;
};


typedef csv::SweList_dyn<HtmlPiece>	    HtmlVector;
typedef const char *			        HtmlTagType;
typedef const char *			        HtmlStyleType;



/// Html pieces diverse interfaces.


/**	Base class for pieces with <TAG <diverse style vars>> .
*/
class Html_Styled : public HtmlPiece
{
  public:
	void				SetStyle(
							HtmlStyleType		i_pStyle );
	const udmstri &		Style() const;
  protected:
						Html_Styled(
							HtmlStyleType		i_pStyle = 0 );
  private:
	udmstri 				sStyle;
};

/**	One well formed HTM-tag-pair with content.
*/
class Html_Field : public Html_Styled
{
  public:
						~Html_Field();
	virtual void		WriteOut(
							csv::File &			io_aFile );

  protected:
						Html_Field(
							DYN HtmlPiece &		let_drData,
							HtmlTagType			i_sTag,
							HtmlStyleType		i_pStyle = 0 );

	const HtmlPiece &	Data() const;

  private:
	virtual void	 	Write_BeginTag(         /// Default: "<"; sTag;  Write_SpecificStyle(); *pStyle; ">".
							csv::File &			io_aFile );
	virtual void	 	Write_SpecificStyle(    /// Default does nothing.
							csv::File &			io_aFile );

	// DATA
	udmstri				sTag;
	DYN HtmlPiece *		dpData;
};

/**	Base class for simple tags, like <H4> or <B>.
*/
class Html_Tag  : public Html_Field
{
  protected:
						Html_Tag(
							DYN HtmlPiece &		let_drData,
							HtmlTagType			i_sTag,
							HtmlStyleType		i_pStyle = 0 );
};


/**	Base class for lists.
*/
class Html_List : public HtmlPiece
{
  public:
	virtual void		WriteOut(
							csv::File &			io_aFile );
	bool				IsEmpty() const 		{ return aRows.begin() != aRows.end(); }
  protected:
						Html_List(
							HtmlTagType			i_sListTag,
							HtmlStyleType		i_sListStyle );
	void				Add_Elem(
							DYN HtmlPiece &		let_drElement,
							HtmlTagType			i_sTag,
							HtmlStyleType		i_sStyle = 0 );

  private:
	class Element : public Html_Field
	{
	  public:
								Element(
									DYN HtmlPiece &		let_drElementsContent,
									HtmlTagType			i_sTag,
									HtmlStyleType		i_pStyle = 0 );
	};

	// DATA
	udmstri				sListTag;
	udmstri 				sListStyle;
	csv::SweList_dyn<Element>
						aRows;
};



/// Html pieces - concrete classes.

/**	One simple tag, like <H4> or <B>
*/
class Html_AnyTag : public Html_Tag
{
  public:
						Html_AnyTag(
							DYN HtmlPiece &		let_drData,
							HtmlTagType			i_sTag,
							HtmlStyleType		i_pStyle = 0 );
};

/**	<BODY> tag
*/
class Html_Body : public Html_Field
{
  public:
						Html_Body(
							HtmlStyleType		i_pStyle = 0 );
	Html_MultiPiece &	Contents()				{ return *pData; }

  private:
	Html_MultiPiece *	pData;
};

/**	<HR>
*/
class Html_HorizontalLine : public Html_Styled
{
  public:               Html_HorizontalLine(
							HtmlStyleType		i_pStyle );

	virtual void		WriteOut(
							csv::File &			io_aFile );
};

/**	<IMG .... >
*/
class Html_Image : public HtmlPiece
{
  public:
						Html_Image(
							const udmstri &		 i_sSrc,
							const udmstri &      i_sWidth,
							const udmstri &      i_sHeight,
							const udmstri &      i_sAlign,
							const udmstri &      i_sBorder,
							const udmstri &      i_sAlt = "" );

	void				SetSrc(
							const char *		 i_sSrc )
												 { sSrc = i_sSrc; }

	virtual void		WriteOut(
							csv::File &			io_aFile );
  private:
	udmstri 			 sSrc;
	udmstri              sWidth;
	udmstri              sHeight;
	udmstri              sAlign;
	udmstri              sBorder;
	udmstri              sAlt;
};

/**	<A name="">
*/
class Html_Label : public Html_Styled
{
  public:
						Html_Label(
							DYN HtmlPiece &		let_drShowedData,
							const udmstri &		i_sName,
							HtmlStyleType		i_pStyle = 0 );
						~Html_Label();

	virtual void		WriteOut(
							csv::File &			io_aFile );
  private:
	DYN HtmlPiece *		dpShowedData;
	udmstri				sName;
};

/**	<BR>
*/
class Html_LineBreak : public HtmlPiece
{
  public:
	virtual void		WriteOut(
							csv::File &			io_aFile );
};

/**	<A href="">
*/
class Html_Link : public Html_Styled
{
  public:
						Html_Link(
							DYN HtmlPiece &		let_drShowedData,
							const udmstri &		i_sDestinaton,
							HtmlStyleType		i_pStyle = 0 );
						~Html_Link();

	virtual void		WriteOut(
							csv::File &			io_aFile );
  private:
	DYN HtmlPiece *		dpShowedData;
	udmstri				sDestination;
};

/**	Several HTML-pieces to be lined up within one tag pair.
*/
class Html_MultiPiece : public HtmlPiece
{
  public:
	void				AddData(
							DYN HtmlPiece &		let_drDatum );
	virtual void		WriteOut(
							csv::File &			io_aFile );
	void				Empty()					{ aData.erase_all(); }

  private:
	HtmlVector			aData;
};

class Html_TableCell : public Html_Field
{
  public:
						Html_TableCell(
							DYN HtmlPiece &		let_drData,
							HtmlStyleType		i_pStyle = 0 );
};

class Html_TableRow  : public Html_Styled
{
  public:
	void				AddCell(
							DYN Html_TableCell *
												let_dpData );
	virtual void		WriteOut(
							csv::File &			io_aFile );
  private:
	csv::SweList_dyn<Html_TableCell>
						aCells;
};

/**	<table ....>
*/
class Html_Table : public Html_Styled
{
  public:
						Html_Table(
							const udmstri &		i_sBorder,
							const udmstri &		i_sWidth,
							const udmstri &		i_sCellPadding = "",
							const udmstri &		i_sCellSpacing = "",
							HtmlStyleType		i_pAdditionalStyle = "" );

	void				AddRow(
							DYN Html_TableRow *	let_dpData );
	virtual void		WriteOut(
							csv::File &			io_aFile );
  private:
	csv::SweList_dyn<Html_TableRow>
						aRows;
};


/**	Text where reserved HTML-chars will be replaced
*/
class Html_Text : public HtmlPiece
{
  public:
						Html_Text(
							const udmstri &		i_sText );
	virtual void		WriteOut(
							csv::File &			io_aFile );
  private:
	static char 		cReplacable[256];

	// DATA
	udmstri				sText;
};

/**	Text which will not be changed
*/
class Html_TextWithHtml : public HtmlPiece
{
  public:
						Html_TextWithHtml(
							const udmstri &		i_sText );
	virtual void		WriteOut(
							csv::File &			io_aFile );
  private:
	udmstri				sText;
};

/**	<DL>
*/
class Html_DefList : public Html_List
{
  public:
						Html_DefList(
							HtmlStyleType		i_pStyle = 0 );

	void				AddTerm(
							DYN HtmlPiece &		let_drElement,
							HtmlStyleType		i_pStyle = 0 );
	void				AddDefinition(
							DYN HtmlPiece &		let_drElement,
							HtmlStyleType		i_pStyle = 0 );
};

/** <OL>
*/
class Html_Enumeration : public Html_List
{
  public:
						Html_Enumeraton(
							char 				i_cType = '\0',
							const udmstri &		i_sStart = "",
							HtmlStyleType		i_pStyle = 0 );

	void				AddElement(
							DYN HtmlPiece &		let_drElement,
							HtmlStyleType		i_pStyle = 0 );
};

/**	<UL>
*/
class Html_SimpleList : public Html_List
{
  public:
						Html_SimpleList(
							HtmlTagType			i_sDifferentTag = "",
							HtmlStyleType		i_pStyle = 0 );

	void				AddElement(
							DYN HtmlPiece &		let_drElement,
							HtmlStyleType		i_pStyle = 0 );
};


// Short hands:

inline DYN Html_Text &
                    TextOH(
						const char *       	i_sText );
inline DYN Html_TextWithHtml &
					TextWH(
						const char * 	    i_sText );
inline DYN Html_Label &
                    Create_TextLabel(
						const char *		i_sText,
						const char *		i_sLink,
						HtmlStyleType		i_pStyle = 0 );
inline DYN Html_Link &
                    Create_TextLink(
						const char *		i_sText,
						const char *		i_sLink,
						HtmlStyleType		i_pStyle = 0 );


inline void
Html_Styled::SetStyle( HtmlStyleType i_pStyle )
	{ sStyle = i_pStyle ? i_pStyle : ""; }
inline const udmstri &
Html_Styled::Style() const
	{ return sStyle; }
inline const HtmlPiece &
Html_Field::Data() const
	{ return *dpData; }

inline DYN Html_Text &
TextOH( const char * i_sText )
	{ return *new Html_Text( i_sText); }
inline DYN Html_TextWithHtml &
TextWH( const char * i_sText )
	{ return *new Html_TextWithHtml( i_sText); }
inline DYN Html_Label &
Create_TextLabel( const char *	i_sText,
				  const char *	i_sLink,
				  HtmlStyleType	i_pStyle )
	{ return *new Html_Label( *new Html_Text(i_sText), i_sLink, i_pStyle ); }
inline DYN Html_Link &
Create_TextLink( const char *	i_sText,
				 const char *	i_sLink,
				 HtmlStyleType	i_pStyle )
	{ return *new Html_Link( *new Html_Text(i_sText), i_sLink, i_pStyle ); }


#endif


