/*************************************************************************
 *
 *  $RCSfile: quname2.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CSI_PRL_QUNAME2_HXX
#define CSI_PRL_QUNAME2_HXX



// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS
#include <cosv/template/tpltools.hxx>


namespace csi
{
namespace prl
{


class QualifiedName
{
  public:
	typedef StringVector::const_iterator  namespace_iterator;

						QualifiedName(
							uintt				i_nSize = 0)
												:	bIsAbsolute(false) { if (i_nSize > 0) aNamespace.reserve(i_nSize); }
						~QualifiedName()        {}

	QualifiedName &		operator+=(
							const udmstri &		i_sNamespaceName )
												{ if (i_sNamespaceName.length() > 0)
														aNamespace.push_back(i_sNamespaceName);
                                                  return *this; }
	void				Init(
							bool				i_bAbsolute )
												{ Empty(); bIsAbsolute = i_bAbsolute; }
	void				SetName(
							const udmstri &		isName )
												{ sName = isName; }
	void				Empty()					{ csv::erase_container(aNamespace); sName = ""; bIsAbsolute = false; }

	const udmstri &		Name() const			{ return sName; }
	namespace_iterator	first_namespace() const	{ return aNamespace.begin(); }
	namespace_iterator	end() const				{ return aNamespace.end(); }
	virtual bool		IsAbsolute() const		{ return bIsAbsolute; }
	virtual bool	   	IsQualified() const		{ return aNamespace.size() > 0; }

  private:
	// DATA
	StringVector		aNamespace;
	udmstri				sName;
	bool				bIsAbsolute;			/// true := beginning with "::".
};



// IMPLEMENTATION


}   // namespace prl
}   // namespace csi


#ifndef NO_SHORTCUT_FOR_QUALIFIEDNAME
typedef csi::prl::QualifiedName		QuName;
#endif


#endif

